<?php

/**
 * firefly.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

declare(strict_types=1);


return [
    // general stuff:
    'stored_in_tz'                              => 'збережено в ":timezone"',
    'displayed_in_tz'                           => 'відображається в ":timezone"',
    'close'                                     => 'Закрити',
    'actions'                                   => 'Дії',
    'edit'                                      => 'Редагувати',
    'loading'                                   => 'Loading',
    'transaction_journal_id'                    => 'Transaction journal ID',
    'delete'                                    => 'Видалити',
    'split'                                     => 'Розділити',
    'single_split'                              => 'Розділити',
    'clone'                                     => 'Клонувати',
    'clone_and_edit'                            => 'Клонувати та редагувати',
    'confirm_action'                            => 'Підтвердити дію',
    'last_seven_days'                           => 'Останні сім днів',
    'last_thirty_days'                          => 'Останні тридцять днів',
    'last_180_days'                             => 'Останні 180 днів',
    'month_to_date'                             => 'Місяць до дати',
    'year_to_date'                              => 'Рік до дати',
    'YTD'                                       => 'З початку року',
    'welcome_back'                              => 'Що в гаманці?',
    'main_dashboard_page_title'                 => 'Головна',
    'everything'                                => 'Все',
    'today'                                     => 'сьогодні',
    'customRange'                               => 'Власний діапазон',
    'date_range'                                => 'Період',
    'apply'                                     => 'Застосувати',
    'select_date'                               => 'Оберіть дату..',
    'cancel'                                    => 'Скасувати',
    'from'                                      => 'Від',
    'to'                                        => 'До',
    'structure'                                 => 'Структура',
    'help_translating'                          => 'Цей текст довідки поки що не доступний українською мовою. <a href="https://crowdin.com/project/firefly-iii-help"> Ви допоможете перекласти?</a>',
    'showEverything'                            => 'Показати все',
    'never'                                     => 'Ніколи',
    'no_results_for_empty_search'               => 'Ваш пошук був порожнім, тому нічого не знайдено.',
    'removed_amount'                            => 'Видалено :amount',
    'added_amount'                              => 'Додано :amount',
    'asset_account_role_help'                   => 'Будь-які додаткові параметри, що виникли з вашого вибору, можна додати пізніше.',
    'Opening balance'                           => 'Початковий баланс',
    'create_new_stuff'                          => 'Створити новий матеріал',
    'new_withdrawal'                            => 'Нове зняття коштів',
    'create_new_transaction'                    => 'Створити нову операцію',
    'sidebar_frontpage_create'                  => 'Створити',
    'new_transaction'                           => 'Нова операція',
    'no_rules_for_bill'                         => 'Ця підписка не має правил, пов\'язаних з нею.',
    'go_to_asset_accounts'                      => 'Переглянути ваші активи рахунків',
    'go_to_budgets'                             => 'Перейти до ваших бюджетів',
    'go_to_withdrawals'                         => 'Перейти до зняття коштів',
    'clones_journal_x'                          => 'Операція є копією ":description" (#:id)',
    'go_to_categories'                          => 'Перейти до ваших категорій',
    'go_to_bills'                               => 'Перейти до своїх підписок',
    'go_to_expense_accounts'                    => 'Переглянь свої рахунки витрат',
    'go_to_revenue_accounts'                    => 'Перегляньте свої рахунки доходу',
    'go_to_piggies'                             => 'Відкрити скарбнички',
    'new_deposit'                               => 'Новий внесок',
    'new_transfer'                              => 'Новий переказ',
    'new_transfers'                             => 'Новий переказ',
    'new_asset_account'                         => 'Новий рахунок активів',
    'new_expense_account'                       => 'Новий рахунок витрат',
    'new_revenue_account'                       => 'Новий рахунок доходів',
    'new_liabilities_account'                   => 'Нове боргове зобов\'язання',
    'new_budget'                                => 'Новий бюджет',
    'new_bill'                                  => 'Нова підписка',
    'block_account_logout'                      => 'Ви вийшли з системи. Заблоковані облікові записи не можуть використовувати цей сервіс. Ви зареєструвалися з дійсною електронною адресою?',
    'flash_success'                             => 'Успішно!',
    'flash_info'                                => 'Повідомлення',
    'flash_warning'                             => 'Увага!',
    'flash_error'                               => 'Помилка!',
    'flash_danger'                              => 'Небезпека!',
    'flash_info_multiple'                       => 'Є одне повідомлення|Є :count повідомлень',
    'flash_error_multiple'                      => 'Є одна помилка|Є :count помилок',
    'net_worth'                                 => 'Чисті активи',
    'help_for_this_page'                        => 'Довідка до сторінки',
    'help_for_this_page_body'                   => 'Ви можете знайти більше інформації про цю сторінку <a href="https://docs.firefly-iii.org/">в документації</a>.',
    'two_factor_welcome'                        => 'Доброго дня!',
    'two_factor_enter_code'                     => 'Для продовження, введіть свій код двофакторної аутентифікації. Його може згенерувати ваш додаток.',
    'two_factor_code_here'                      => 'Введіть код тут',
    'two_factor_title'                          => 'Двофакторна аутентифікація',
    'authenticate'                              => 'Аутентифікація',
    'two_factor_forgot_title'                   => 'Втрачено двофакторну автентифікацію',
    'two_factor_forgot'                         => 'Я забув свій двофакторний ключ.',
    'two_factor_lost_header'                    => 'Чи втрачено двофакторну аутентифікацію?',
    'two_factor_lost_intro'                     => 'Якщо ви втратили резервні копії, вам не пощастило. Через вебінтерфейс це неможливо виправити. Ви маєте виходи.',
    'two_factor_lost_fix_self'                  => 'Якщо ви запускаєте власний екземпляр Firefly III, прочитайте <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">цей запис у FAQ</a> для отримання інструкцій.',
    'two_factor_lost_fix_owner'                 => 'В іншому випадку надішліть електронний лист адміністратору сервісу, <a href="mailto::site_owner">:site_owner</a> та попросіть його створити новий ключ двофакторної автентифікації.',
    'mfa_backup_code'                           => 'Ви використали резервний код для входу в Firefly III. Його не можна використати повторно, тому видаліть його зі свого списку.',
    'pref_two_factor_new_backup_codes'          => 'Отримати нові резервні коди',
    'pref_two_factor_backup_code_count'         => 'У вас є :count дійсний резервний код.|У вас :count дійсних резервних кодів.',
    '2fa_i_have_them'                           => 'Я їх зберіг!',
    'warning_much_data'                         => ':days днів для завантаження даних, може знадобитися деякий час.',
    'registered'                                => 'Ви успішно зареєструвалися!',
    'Default asset account'                     => 'Рахунок активів за замовчуванням',
    'no_budget_pointer'                         => 'Здається, не створили жодного бюджету. Створіть один на сторінці <a href="budgets">бюджетів</a>. Бюджети можуть допомогти вам стежити за витратами.',
    'no_bill_pointer'                           => 'Схоже, у вас ще немає підписки. Створіть її на сторінці <a href="subscriptions">підписок</a>. Підписки допоможуть вам відстежувати витрати.',
    'Savings account'                           => 'Рахунок для накопичення',
    'Credit card'                               => 'Кредитна картка',
    'source_accounts'                           => 'Джерело рахунку|Джерела рахунків',
    'destination_accounts'                      => 'Рахунок-одержувач|Рахунки-одержувачі',
    'user_id_is'                                => 'Ідентифікатор користувача <strong>:user</strong>',
    'field_supports_markdown'                   => 'Це поле підтримує <a href="https://en.support.wordpress.com/markdown-quick-reference/">Уцінку</a>.',
    'need_more_help'                            => 'Якщо вам потрібна додаткова допомога щодо Firefly III, <a href="https://github.com/firefly-iii/firefly-iii/issues">створіть звернення на Github</a>.',
    'reenable_intro_text'                       => 'Ви можете повторно увімкнути <a href="#" id="reenableGuidance">вступне керівництво</a>.',
    'intro_boxes_after_refresh'                 => 'Вступне керівництво з\'явиться знову після оновлення сторінки.',
    'show_all_no_filter'                        => 'Показати всі операції без групування за датою.',
    'expenses_by_category'                      => 'Витрати за категоріями',
    'expenses_by_budget'                        => 'Витрати за бюджетом',
    'income_by_category'                        => 'Дохід за категоріями',
    'expenses_by_asset_account'                 => 'Витрати з основного рахунку',
    'expenses_by_expense_account'               => 'Expenses by destination account',
    'cannot_redirect_to_account'                => 'Firefly III не може перенаправити вас на правильну сторінку. Вибачте.',
    'sum_of_expenses'                           => 'Сума витрат',
    'sum_of_income'                             => 'Сума доходу',
    'liabilities'                               => 'Зобов\'язання',
    'spent_in_specific_budget'                  => 'Витрати в бюджеті ":budget"',
    'spent_in_specific_double'                  => 'Витрати з рахунку ":account"',
    'earned_in_specific_double'                 => 'Зароблено у рахунок ":account"',
    'source_account'                            => 'Вихідний рахунок',
    'source_account_reconciliation'             => 'Ви не можете редагувати операції звірки, рахунка джерела.',
    'destination_account'                       => 'Рахунок призначення',
    'destination_account_reconciliation'        => 'Ви не можете редагувати операції погодження, рахунку призначення.',
    'sum_of_expenses_in_budget'                 => 'Загальна сума витрат у бюджеті ":budget"',
    'left_in_budget_limit'                      => 'Залишилося витратити відповідно до бюджету',
    'current_period'                            => 'Поточний період',
    'show_the_current_period_and_overview'      => 'Показати поточний період та огляд',
    'pref_languages_locale'                     => 'Щоб мова, відмінна від англійської, працювала належним чином, ваша операційна система має мати правильну інформацію про мову. Якщо їх немає, дані про валюту, дати та суми можуть мати неправильний формат.',
    'budget_in_period'                          => 'Усі транзакції для бюджету ":name" між :start та :end у :currency',
    'chart_budget_in_period'                    => 'Графік всіх операцій для бюджету ":name" між :start та :end у :currency',
    'chart_budget_in_period_only_currency'      => 'Сума бюджету була у :currency, тому цей графік відображатиме лише транзакції у :currency.',
    'chart_account_in_period'                   => 'Діаграма для всіх транзакцій по рахунку ":name" (:balance) між :start і :end',
    'chart_category_in_period'                  => 'Діаграма всіх операцій для категорії ":name" між :start і :end',
    'chart_category_all'                        => 'Діаграма всіх операцій для категорії ":name"',
    'clone_withdrawal'                          => 'Клонувати цю витрату',
    'clone_deposit'                             => 'Клонувати цей дохід',
    'clone_transfer'                            => 'Клонувати цей переказ',
    'multi_select_no_selection'                 => 'Нічого не вибрано',
    'multi_select_select_all'                   => 'Обрати все',
    'multi_select_n_selected'                   => 'обрано',
    'multi_select_all_selected'                 => 'Усе обрано',
    'multi_select_filter_placeholder'           => 'Знайти..',
    'intro_next_label'                          => 'Далі',
    'intro_prev_label'                          => 'Попередній',
    'intro_skip_label'                          => 'Пропустити',
    'intro_done_label'                          => 'Готово',
    'between_dates_breadcrumb'                  => 'Між :start і :end',
    'all_journals_without_budget'               => 'Всі транзакції без бюджету',
    'journals_without_budget'                   => 'Транзакції без бюджету',
    'all_journals_without_category'             => 'Усі транзакції без категорії',
    'journals_without_category'                 => 'Транзакції без категорії',
    'all_journals_for_account'                  => 'Всі транзакції для рахунку :name',
    'chart_all_journals_for_account'            => 'Діаграма всіх операцій для рахунку :name',
    'journals_in_period_for_account'            => 'Всі транзакції для рахунку :name між :start і :end',
    'journals_in_period_for_account_js'         => 'Всі транзакції для облікового запису {title} між {start} і {end}',
    'transferred'                               => 'Передано',
    'all_withdrawal'                            => 'Усі витрати',
    'all_transactions'                          => 'Всі транзакції',
    'title_withdrawal_between'                  => 'Всі витрати між :start і :end',
    'all_deposit'                               => 'Всі доходи',
    'title_deposit_between'                     => 'Всі доходи між :start і :end',
    'all_transfers'                             => 'Всі перекази',
    'title_transfers_between'                   => 'Всі перекази між :start і :end',
    'all_transfer'                              => 'Всі перекази',
    'all_journals_for_tag'                      => 'Всі транзакції для тегу ":tag"',
    'title_transfer_between'                    => 'Всі перекази між :start і :end',
    'all_journals_for_category'                 => 'Всі транзакції для категорії :name',
    'all_journals_for_budget'                   => 'Всі транзакції для бюджету :name',
    'chart_all_journals_for_budget'             => 'Діаграма всіх операцій для бюджету: :name',
    'journals_in_period_for_category'           => 'Всі транзакції для категорії :name між :start і :end',
    'journals_in_period_for_tag'                => 'Всі транзакції для тегу: :tag між :start і :end',
    'not_available_demo_user'                   => 'Дана функція недоступна для демо-користувачів.',
    'exchange_rate_instructions'                => 'Asset account "@name" only accepts transactions in @primary_currency. If you wish to use @foreign_currency instead, make sure that the amount in @primary_currency is known as well:',
    'transfer_exchange_rate_instructions'       => 'Вихідний рахунок "@source_name" приймає транзакції лише в @source_currency. Рахунок призначення "@dest_name" приймає транзакції лише в @dest_currency. Ви повинні вказати перераховану суму правильно в обох валютах.',
    'transaction_data'                          => 'Дані транзакції',
    'invalid_server_configuration'              => 'Невірна конфігурація сервера',
    'invalid_locale_settings'                   => 'Firefly III не може форматувати грошові суми, оскільки на вашому сервері відсутні необхідні пакети. Існують <a href="https://docs.firefly-iii.org/how-to/firefly-iii/advanced/locales/">інструкції, як це виправити</a>.',
    'quickswitch'                               => 'Швидке перемикання',
    'sign_in_to_start'                          => 'Увійдіть щоб розпочати сеанс',
    'sign_in'                                   => 'Ввійти',
    'register_new_account'                      => 'Зареєструвати новий обліковий запис',
    'forgot_my_password'                        => 'Я забув пароль',
    'problems_with_input'                       => 'Є деякі проблеми з введеними вами даними.',
    'reset_password'                            => 'Відновити ваш пароль',
    'button_reset_password'                     => 'Відновити пароль',
    'reset_button'                              => 'Скинути',
    'want_to_login'                             => 'Я хочу увійти',
    'login_page_title'                          => 'Вхід у Firefly III',
    'register_page_title'                       => 'Реєстрація у Firefly III',
    'forgot_pw_page_title'                      => 'Забув пароль для Firefly III',
    'reset_pw_page_title'                       => 'Скинути пароль для Firefly III',
    'cannot_reset_demo_user'                    => 'Ви не можете скинути пароль демо-користувача.',
    'no_att_demo_user'                          => 'Демо-користувач не може завантажувати вкладені файли.',
    'button_register'                           => 'Реєєстрація',
    'authorization'                             => 'Авторизація',
    'active_bills_only'                         => 'тільки активна підписка',
    'active_bills_only_total'                   => 'всі активні підписки',
    'active_exp_bills_only'                     => 'тільки активні та очікувані підписки',
    'active_exp_bills_only_total'               => 'тільки активні очікувані підписки',
    'per_period_sum_1D'                         => 'Очікувані щоденні витрати',
    'per_period_sum_1W'                         => 'Очікувані щотижневі витрати',
    'per_period_sum_1M'                         => 'Очікувані щомісячні витрати',
    'per_period_sum_3M'                         => 'Очікувані квартальні витрати',
    'per_period_sum_6M'                         => 'Очікувані піврічні витрати',
    'per_period_sum_1Y'                         => 'Очікувані річні витрати',
    'average_per_bill'                          => 'в середньому за підписку',
    'expected_total'                            => 'очікується загалом',
    'reconciliation_account_name'               => ':name погодження (:currency)',
    'saved'                                     => 'Збережено',
    'advanced_options'                          => 'Додаткові налаштування',
    'advanced_options_explain'                  => 'Деякі сторінки у Firefly III мають додаткові опції, приховані за цією кнопкою. Ця сторінка не має тут нічого цікавого, але перевірте інші!',
    'here_be_dragons'                           => 'Тут живуть дракони',
    'bad_date_transaction'                      => 'Firefly III has detected you have transactions from before the year 1970. Please correct these transactions at your earliest convenience.',
    'anonymous_warning_on'                      => 'For your privacy, all amounts are now displayed as "zero". Warning: text input boxes may still show the original amounts!',
    'anonymous_warning_off'                     => 'Amounts will be visible again. Please be mindful of your surroundings.',

    // Webhooks
    'webhooks'                                  => 'Веб-гаки',
    'webhooks_breadcrumb'                       => 'Веб-хуки',
    'webhooks_menu_disabled'                    => 'вимкнуто',
    'no_webhook_messages'                       => 'Повідомлення відсутні',
    'webhook_trigger_ANY'         => 'After any event',
    'webhook_trigger_STORE_TRANSACTION'         => 'Після створення операції',
    'webhook_trigger_UPDATE_TRANSACTION'        => 'Після оновлення операції',
    'webhook_trigger_DESTROY_TRANSACTION'       => 'Після видалення операції',
    'webhook_trigger_STORE_BUDGET'              => 'After budget creation',
    'webhook_trigger_UPDATE_BUDGET'             => 'After budget update',
    'webhook_trigger_DESTROY_BUDGET'            => 'After budget delete',
    'webhook_trigger_STORE_UPDATE_BUDGET_LIMIT' => 'After budgeted amount change',
    'webhook_response_TRANSACTIONS'             => 'Деталі операції',
    'webhook_response_ACCOUNTS'                 => 'Дані рахунку',
    'webhook_response_BUDGET'                   => 'Budget details',
    'webhook_response_RELEVANT'                 => 'Relevant details',
    'webhook_response_NONE'                     => 'No details',
    'webhook_delivery_JSON'                     => 'JSON',
    'inspect'                                   => 'Дослідити',
    'create_new_webhook'                        => 'Створити новий веб-хук',
    'webhooks_create_breadcrumb'                => 'Створити новий веб-хук',
    'webhook_trigger_form_help'                 => 'Укажіть, за якої події запускатиметься вебхук',
    'webhook_response_form_help'                => 'Укажіть, що веб-хук має передати в URL-адресу.',
    'webhook_delivery_form_help'                => 'У якому форматі веб-хук має надавати дані.',
    'webhook_active_form_help'                  => 'Веб-хук має бути активним, інакше його не буде викликано.',
    'stored_new_webhook'                        => 'Збережено новий веб-хук ":title"',
    'delete_webhook'                            => 'Видалити веб-хук',
    'deleted_webhook'                           => 'Видалено веб-хук',
    'edit_webhook'                              => 'Редагувати веб-хук ":title"',
    'updated_webhook'                           => 'Оновлено веб-хук ":title"',
    'edit_webhook_js'                           => 'Редагувати веб-хук "{title}"',
    'show_webhook'                              => 'Веб-хук ":title"',
    'webhook_was_triggered'                     => 'Вебхук був запущений в зазначеній транзакції. Будь ласка, зачекайте на отримання результатів.',
    'webhook_messages'                          => 'Повідомлення веб-хука',
    'view_message'                              => 'Переглянути повідомлення',
    'view_attempts'                             => 'Переглянути невдалі спроби',
    'message_content_title'                     => 'Вміст веб-хук повідомлення',
    'message_content_help'                      => 'Це вміст повідомлення, яке було надіслано (або зроблено спробу) за допомогою цього вебхука.',
    'attempt_content_title'                     => 'Спроби веб-хуку',
    'attempt_content_help'                      => 'Це всі невдалі спроби цього повідомлення вебхуку надіслати налаштовану URL-адресу. Через деякий час Firefly III припинить спроби.',
    'no_attempts'                               => 'Безуспішних спроб нема. Це добре!',
    'webhook_attempt_at'                        => 'Спроба {moment}',
    'logs'                                      => 'Журнали',
    'response'                                  => 'Відповідь',
    'visit_webhook_url'                         => 'Відвідайте URL-адресу веб-хуку',
    'reset_webhook_secret'                      => 'Відновити сікрет веб-хука',
    'webhook_stored_link'                       => '<a href="webhooks/show/{ID}">Вебхук #{ID} ("{title}")</a> був збережений.',
    'webhook_updated_link'                      => '<a href="webhooks/show/{ID}">Вебхук #{ID}</a> ("{title}") був оновлений.',

    // API access
    'authorization_request'                     => 'Firefly III v:version запит авторизації',
    'authorization_request_intro'               => 'Додаток "<strong>:client</strong>" вимагає дозволу на доступ до фінансового управління. Бажаєте авторизувати <strong>:client</strong> для доступу до цих записів?',
    'authorization_request_site'                => 'Ви будете перенаправлені на <code>:url</code>, куди згодом надасться доступ до даних Firefly III.',
    'authorization_request_invalid'             => 'Цей запит доступу є недійсним. Будь ласка, ніколи не переходіть за цим посиланням знову.',
    'scopes_will_be_able'                       => 'Цей додаток матиме змогу:',
    'button_authorize'                          => 'Авторизувати',
    'none_in_select_list'                       => '(немає)',
    'no_piggy_bank'                             => '(немає скарбнички)',
    'name_in_currency'                          => ':name в :currency',
    'paid_in_currency'                          => 'Сплачено в :currency',
    'unpaid_in_currency'                        => 'Неоплачено в :currency',
    'is_alpha_warning'                          => 'Ви використовуєте ALPHA - версію. Можуть зустрічатись баги та недопрацювання.',
    'is_beta_warning'                           => 'Ви використовуєте BETA - версію. Можуть зустрічатись баги та недопрацювання.',
    'all_destination_accounts'                  => 'Рахунки-одержувачі',
    'all_source_accounts'                       => 'Вихідні рахунки',
    'back_to_index'                             => 'Назад до змісту',
    'cant_logout_guard'                         => 'Firefly III не може вийти з вашого облікового запису.',
    'internal_reference'                        => 'Внутрішнє посилання',

    // check for updates:
    'update_check_title'                        => 'Перевірити оновлення',
    'admin_update_check_title'                  => 'Автоматично перевіряти оновлення',
    'admin_update_check_explain'                => 'Firefly III може автоматично перевіряти наявність оновлень. Коли ви вмикаєте цей параметр, програма зв\'яжеться з сервером, щоб перевірити наявність нової версії Firefly III. Коли це станеться, ви отримаєте сповіщення. Також Ви можете перевірити наявність оновлення за допомогою кнопки справа. Будь ласка, зазначте нижче, чи хочете Ви щоб Firefly III перевіряв наявність оновлень.',
    'check_for_updates_permission'              => 'Firefly III може перевіряти наявність оновлень, але для цього потрібен Ваш дозвіл. Будь ласка, перейдіть до <a href=":link">налаштувань</a>, щоб увімкнути цю можливість.',
    'updates_ask_me_later'                      => 'Запитати пізніше',
    'updates_do_not_check'                      => 'Не перевіряти наявність оновлень',
    'updates_enable_check'                      => 'Увімкнути перевірку оновлень',
    'admin_update_check_now_title'              => 'Перевірити наявність оновлень',
    'admin_update_check_now_explain'            => 'Якщо ви натиснете кнопку, Firefly III перевірить, чи ваша поточна версія остання.',
    'check_for_updates_button'                  => 'Перевірити зараз!',
    'update_new_version_alert'                  => 'Доступна нова версія Firefly III. Ви працюєте з :your_version, остання версія :new_version яка була випущена на :date.',
    'update_version_beta'                       => 'Це бета-версія. Ви можете зіткнутися з проблемами.',
    'update_version_alpha'                      => 'Це альфа-версія. Може містити баги та недоліки.',
    'update_current_dev_older'                  => 'Ви використовуєте розробник ":version, який старіший за останню версію :new_version. Будь ласка оновіться!',
    'update_current_dev_newer'                  => 'Ви використовуєте розробник ":version", який є новішим, ніж останній реліз :new_version.',
    'update_current_version_alert'              => 'Ви працюєте в найновішій версії :version.',
    'update_newer_version_alert'                => 'Ви працюєте з :your_version версією, яка є новішою за останній реліз, :new_version.',
    'update_check_error'                        => 'Сталася помилка під час перевірки наявності оновлень: :error',
    'unknown_error'                             => 'Невідома помилка. Вибачте.',
    'disabled_but_check'                        => 'Ви відключили перевірку оновлення. Тому не забудьте перевіряти наявність оновлень особисто час від часу. Дякуємо!',
    'admin_update_channel_title'                => 'Канал оновлень',
    'admin_update_channel_explain'              => 'Firefly III має три "канали" оновлення, які визначають як швидко ви можете отримати нові функції. Використовуйте канал "бета", якщо ви любителі пригоди та "альфа", коли вам подобається ризикувати.',
    'update_channel_stable'                     => 'Стабільний. Все працює, як і очікувалося.',
    'update_channel_beta'                       => 'Бета. Нові функції, але дані можуть бути зіпсовані.',
    'update_channel_alpha'                      => 'Альфа. Ми додаємо нові функції, але вони працюють на милицях.',

    // search
    'search'                                    => 'Пошук',
    'search_query'                              => 'Запит',
    'search_found_transactions'                 => 'Firefly III знайшов :count транзакцію за :time секунд.|Firefly III знайшов :count транзакцій за :time секунд.',
    'search_found_more_transactions'            => 'Firefly III знайшов більше, ніж :count транзакцій за :time секунд.',
    'search_for_overview'                       => 'Firefly ІІІ шукає транзакції, які відповідають <b>усім</b> наступним умовам:',
    'search_for_query'                          => 'Усі ці слова мають бути присутні: <span class="text-info">:query</span>',
    'search_for_excluded_words'                 => 'Жодне з цих слів не може бути присутнім: <span class="text-info">:excluded_words</span>',
    'invalid_operators_list'                    => 'Ці параметри пошуку є недійсними і були проігноровані.',

    // old


    'search_modifier_date_on'                             => 'Дата операції ":value"',
    'search_modifier_not_date_on'                         => 'Дата операції не ":value"',
    'search_modifier_reconciled'                          => 'Операція узгоджена',
    'search_modifier_not_reconciled'                      => 'Операція не узгоджена',
    'search_modifier_id'                                  => 'Ідентифікатор транзакції: ":value"',
    'search_modifier_not_id'                              => 'Ідентифікатор операції не ":value"',
    'search_modifier_date_before'                         => 'Дата транзакції перед або ":value"',
    'search_modifier_date_after'                          => 'Дата транзакції після або о ":value"',
    'search_modifier_external_id_is'                      => 'Зовнішній ID - ":value"',
    'search_modifier_not_external_id_is'                  => 'Зовнішній ідентифікатор не ":value"',
    'search_modifier_no_external_url'                     => 'Операція не має зовнішнього URL',
    'search_modifier_no_external_id'                      => 'Операція не має зовнішнього ID',
    'search_modifier_not_any_external_url'                => 'Операція не має зовнішнього URL',
    'search_modifier_not_any_external_id'                 => 'Операція не має зовнішнього ID',
    'search_modifier_any_external_url'                    => 'Операція повинна мати зовнішні URL-адреси (будь-який)',
    'search_modifier_any_external_id'                     => 'Операція повинна мати (якийсь) зовнішній ID',
    'search_modifier_not_no_external_url'                 => 'Операція повинна мати (будь-які) зовнішні URL-адреси',
    'search_modifier_not_no_external_id'                  => 'Операція повинна мати (якийсь) зовнішній ID',
    'search_modifier_internal_reference_is'               => 'Внутрішнє посилання - ":value"',
    'search_modifier_not_internal_reference_is'           => 'Внутрішнє посилання не ":value"',
    'search_modifier_description_starts'                  => 'Опис починається з ":value"',
    'search_modifier_not_description_starts'              => 'Опис не починається з ":value"',
    'search_modifier_description_ends'                    => 'Опис закінчується на ":value"',
    'search_modifier_not_description_ends'                => 'Опис не закінчується на ":value"',
    'search_modifier_description_contains'                => 'Опис містить ":value"',
    'search_modifier_not_description_contains'            => 'Опис не містить ":value"',
    'search_modifier_description_is'                      => 'Опис повністю відповідає ":value"',
    'search_modifier_not_description_is'                  => 'Опис точно не ":value"',
    'search_modifier_currency_is'                         => 'Валюта (іноземна) транзакції - ":value"',
    'search_modifier_not_currency_is'                     => 'Валюта (іноземна) операції не ":value"',
    'search_modifier_foreign_currency_is'                 => 'Валюта іноземна транзакції - ":value"',
    'search_modifier_not_foreign_currency_is'             => 'Іноземна валюта операції не ":value"',
    'search_modifier_has_attachments'                     => 'Транзакція має містити вкладення',
    'search_modifier_has_no_category'                     => 'Транзакція повинна бути без категорії',
    'search_modifier_not_has_no_category'                 => 'Операція повинна мати (будь-яку) категорію',
    'search_modifier_not_has_any_category'                => 'Операція має містити жодної категорії',
    'search_modifier_has_any_category'                    => 'Транзакція повинна мати (будь яку) категорію',
    'search_modifier_has_no_budget'                       => 'Транзакція не повинна мати бюджет',
    'search_modifier_not_has_any_budget'                  => 'Операція не повинна мати бюджету',
    'search_modifier_has_any_budget'                      => 'Транзакція повинна мати (будь який) бюджет',
    'search_modifier_not_has_no_budget'                   => 'Операція повинна мати (будь-який) бюджет',
    'search_modifier_has_no_bill'                         => 'Транзакція не повинна мати підписки',
    'search_modifier_not_has_no_bill'                     => 'Транзакція мусить мати хоч якусь підписку',
    'search_modifier_has_any_bill'                        => 'Транзакція мусить мати хоч якусь підписку',
    'search_modifier_not_has_any_bill'                    => 'Транзакція не повинна мати підписки',
    'search_modifier_has_no_tag'                          => 'Транзакція не повинна мати міток',
    'search_modifier_not_has_any_tag'                     => 'Операція не повинна мати мітки',
    'search_modifier_not_has_no_tag'                      => 'Операція повинна мати (будь-яку) мітку',
    'search_modifier_has_any_tag'                         => 'Транзакція повинна мати (будь яку) мітку',
    'search_modifier_notes_contains'                      => 'Примітки для операції містять ":value"',
    'search_modifier_not_notes_contains'                  => 'Примітки до операції не містять ":value"',
    'search_modifier_notes_starts'                        => 'Примітки для операції починаються з ":value"',
    'search_modifier_not_notes_starts'                    => 'Примітки до операції не починаються з ":value"',
    'search_modifier_notes_ends'                          => 'Примітки для операції закінчуються на ":value"',
    'search_modifier_not_notes_ends'                      => 'Примітки до операції не закінчуються на ":value"',
    'search_modifier_notes_is'                            => 'Примітки для операції відповідають ":value"',
    'search_modifier_not_notes_is'                        => 'Примітки до операції не ":value"',
    'search_modifier_no_notes'                            => 'Транзакція не містить приміток',
    'search_modifier_not_no_notes'                        => 'Операція повинна мати примітки',
    'search_modifier_any_notes'                           => 'Транзакція має містити примітки',
    'search_modifier_not_any_notes'                       => 'Транзакція не має приміток',
    'search_modifier_amount_is'                           => 'Сума дорівнює :value',
    'search_modifier_not_amount_is'                       => 'Сума не дорівнює :value',
    'search_modifier_amount_less'                         => 'Сума менша або дорівнює :value',
    'search_modifier_not_amount_more'                     => 'Сума менша або дорівнює :value',
    'search_modifier_amount_more'                         => 'Сума більше або дорівнює :value',
    'search_modifier_not_amount_less'                     => 'Сума більше або дорівнює :value',
    'search_modifier_source_account_is'                   => 'Імя вихідного рахунку співпадає з ":value"',
    'search_modifier_not_source_account_is'               => 'Назва рахунку не ":value"',
    'search_modifier_source_account_contains'             => 'Імя вихідного рахунку містить ":value"',
    'search_modifier_not_source_account_contains'         => 'Назва рахунку не містить ":value"',
    'search_modifier_source_account_starts'               => 'Імя вихідного рахунку починається з ":value"',
    'search_modifier_not_source_account_starts'           => 'Назва рахунку не починається з ":value"',
    'search_modifier_source_account_ends'                 => 'Імя вихідного рахунку закінчується на ":value"',
    'search_modifier_not_source_account_ends'             => 'Назва рахунку не закінчується на ":value"',
    'search_modifier_source_account_id'                   => 'ID вихідного рахунку дорівнює :value',
    'search_modifier_not_source_account_id'               => 'Ідентифікатор рахунку не :value',
    'search_modifier_source_account_nr_is'                => 'Номер вихідного рахунку (IBAN) дорівнює ":value"',
    'search_modifier_not_source_account_nr_is'            => 'Номер рахунку (IBAN) не ":value"',
    'search_modifier_source_account_nr_contains'          => 'Номер вихідного рахунку (IBAN) містить ":value"',
    'search_modifier_not_source_account_nr_contains'      => 'Номер рахунку (IBAN) не містить ":value"',
    'search_modifier_source_account_nr_starts'            => 'Номер вихідного рахунку (IBAN) починається з ":value"',
    'search_modifier_not_source_account_nr_starts'        => 'Номер рахунку (IBAN) не починається з ":value"',
    'search_modifier_source_account_nr_ends'              => 'Номер рахунку (IBAN) закінчується на ":value"',
    'search_modifier_not_source_account_nr_ends'          => 'Номер рахунку (IBAN) не закінчується на ":value"',
    'search_modifier_destination_account_is'              => 'Ім\'я рахуноку-одержувача співпадає з ":value"',
    'search_modifier_not_destination_account_is'          => 'Назва цільового рахунку не ":value"',
    'search_modifier_destination_account_contains'        => 'Ім\'я рахуноку-одержувача містить ":value"',
    'search_modifier_not_destination_account_contains'    => 'Назва цільового рахунку не містить ":value"',
    'search_modifier_destination_account_starts'          => 'Ім\'я рахуноку-одержувача починається з ":value"',
    'search_modifier_not_destination_account_starts'      => 'Назва цільового рахунку не починається з ":value"',
    'search_modifier_destination_account_ends'            => 'Назва цільового рахунку закінчується на ":value"',
    'search_modifier_not_destination_account_ends'        => 'Назва цільового рахунку не закінчується на ":value"',
    'search_modifier_destination_account_id'              => 'Ідентифікатор рахуноку-одержувача дорівнює ":value"',
    'search_modifier_not_destination_account_id'          => 'Ідентифікатор цільового рахунку не :value',
    'search_modifier_destination_is_cash'                 => 'Рахунок призначення – "(cash)" рахунок',
    'search_modifier_not_destination_is_cash'             => 'Рахунок призначення – не "(cash)" рахунок',
    'search_modifier_source_is_cash'                      => 'Джерело рахунка - "(cash)" ​​рахунок',
    'search_modifier_not_source_is_cash'                  => 'Джерелом рахунка - не "(cash)" ​​рахунок',
    'search_modifier_destination_account_nr_is'           => 'Номер рахунку-одержувача (IBAN) дорівнює ":value"',
    'search_modifier_not_destination_account_nr_is'       => 'Номер цільового рахунку (IBAN) - ":value"',
    'search_modifier_destination_account_nr_contains'     => 'Номер рахунку-одержувача (IBAN) містить ":value"',
    'search_modifier_not_destination_account_nr_contains' => 'Номер цільового рахунку (IBAN) не містить ":value"',
    'search_modifier_destination_account_nr_starts'       => 'Номер рахунку-одержувача (IBAN) починається з ":value"',
    'search_modifier_not_destination_account_nr_starts'   => 'Номер цільового рахунку (IBAN) не починається з ":value"',
    'search_modifier_destination_account_nr_ends'         => 'Номер рахунку-одержувача (IBAN) закінчується на ":value"',
    'search_modifier_not_destination_account_nr_ends'     => 'Номер цільового рахунку (IBAN) не закінчується на ":value"',
    'search_modifier_account_id'                          => 'Ідентифікатор вихідного рахунку або рахуноку-одержувача дорівнює/дорівнюють: :value',
    'search_modifier_not_account_id'                      => 'Ідентифікатори джерел або цільових рахунків не: :value',
    'search_modifier_category_is'                         => 'Категорія дорівнює ":value"',
    'search_modifier_not_category_is'                     => 'Категорія не ":value"',
    'search_modifier_budget_is'                           => 'Бюджет дорівнює ":value"',
    'search_modifier_not_budget_is'                       => 'Бюджет - це не ":value"',
    'search_modifier_bill_is'                             => 'Підписка ":value"',
    'search_modifier_not_bill_is'                         => 'Підписка не є ":value"',
    'search_modifier_transaction_type'                    => 'Тип транзакції дорівнює ":value"',
    'search_modifier_not_transaction_type'                => 'Тип операції не ":value"',
    'search_modifier_tag_is'                              => 'Мітка дорівнює ":value"',
    'search_modifier_tag_contains'                        => 'Мітка містить ":value"',
    'search_modifier_not_tag_contains'                    => 'Мітка не містить ":value"',
    'search_modifier_tag_ends'                            => 'Мітка закінчується на ":value"',
    'search_modifier_tag_starts'                          => 'Мітка починається з ":value"',
    'search_modifier_not_tag_is'                          => 'Жодної мітки зі значенням ":value"',
    'search_modifier_date_on_year'                        => 'Рік операції ":value"',
    'search_modifier_not_date_on_year'                    => 'Операція не в ":value" році',
    'search_modifier_date_on_month'                       => 'Місяць операції ":value"',
    'search_modifier_not_date_on_month'                   => 'Операція не в ":value" місяці',
    'search_modifier_date_on_day'                         => 'День операції ":value"',
    'search_modifier_not_date_on_day'                     => 'Операція не в ":value" дні місяця',
    'search_modifier_date_before_year'                    => 'Дата операції до чи в році ":value"',
    'search_modifier_date_before_month'                   => 'Дата операції до чи в місяці ":value"',
    'search_modifier_date_before_day'                     => 'Дата операції до чи в день ":value"',
    'search_modifier_date_after_year'                     => 'Дата операції до чи після року ":value"',
    'search_modifier_date_after_month'                    => 'Дата операції до чи після місяця ":value"',
    'search_modifier_date_after_day'                      => 'Дата операції до чи після дня ":value"',

    // new
    'search_modifier_tag_is_not'                          => 'Помітка ":value"',
    'search_modifier_not_tag_is_not'                      => 'Мітка ":value"',
    'search_modifier_account_is'                          => 'Будь-який рахунок є ":value"',
    'search_modifier_not_account_is'                      => 'Жодного рахунку ":value"',
    'search_modifier_account_contains'                    => 'Всі рахунки які містять ":value"',
    'search_modifier_not_account_contains'                => 'Жодних рахунків які містять ":value"',
    'search_modifier_account_ends'                        => 'Всі рахунки які закінчуються на ":value"',
    'search_modifier_not_account_ends'                    => 'Жодних рахунків які закінчуються на ":value"',
    'search_modifier_account_starts'                      => 'Всі рахунки які починаються з ":value"',
    'search_modifier_not_account_starts'                  => 'Жодних рахунків які починаються з ":value"',
    'search_modifier_account_nr_is'                       => 'Усі номери рахунків або IBAN ":value"',
    'search_modifier_not_account_nr_is'                   => 'Жодних номерів рахунків або IBAN ":value"',
    'search_modifier_account_nr_contains'                 => 'Усі номери рахунків або IBAN які містять ":value"',
    'search_modifier_not_account_nr_contains'             => 'Жодних номерів рахунків або IBAN які містять ":value"',
    'search_modifier_account_nr_ends'                     => 'Усі номери рахунків або IBAN які закінчуються на ":value"',
    'search_modifier_not_account_nr_ends'                 => 'Жодних номерів рахунків або IBAN які закінчуються на ":value"',
    'search_modifier_account_nr_starts'                   => 'Усі номери рахунків або IBAN які починаються з ":value"',
    'search_modifier_not_account_nr_starts'               => 'Жодних номерів рахунків або IBAN які починаються з ":value"',
    'search_modifier_category_contains'                   => 'Категорія містить ":value"',
    'search_modifier_not_category_contains'               => 'Категорія не містить ":value"',
    'search_modifier_category_ends'                       => 'Категорія закінчується на ":value"',
    'search_modifier_not_category_ends'                   => 'Категорія не закінчується на ":value"',
    'search_modifier_category_starts'                     => 'Категорія починається з ":value"',
    'search_modifier_not_category_starts'                 => 'Категорія не починається з ":value"',
    'search_modifier_budget_contains'                     => 'Бюджет містить ":value"',
    'search_modifier_not_budget_contains'                 => 'Бюджет не містить ":value"',
    'search_modifier_budget_ends'                         => 'Бюджет закінчується на ":value"',
    'search_modifier_not_budget_ends'                     => 'Бюджет не закінчується на ":value"',
    'search_modifier_budget_starts'                       => 'Бюджет починається з ":value"',
    'search_modifier_not_budget_starts'                   => 'Бюджет не починається з ":value"',
    'search_modifier_bill_contains'                       => 'Підписка містить ":value"',
    'search_modifier_not_bill_contains'                   => 'Підписка не містить ":value"',
    'search_modifier_bill_ends'                           => 'Підписка закінчується на ":value"',
    'search_modifier_not_bill_ends'                       => 'Підписка не закінчується на ":value"',
    'search_modifier_bill_starts'                         => 'Підписка починається з ":value"',
    'search_modifier_not_bill_starts'                     => 'Підписка не починається з ":value"',
    'search_modifier_external_id_contains'                => 'Зовнішній ідентифікатор містить ":value"',
    'search_modifier_not_external_id_contains'            => 'Зовнішній ідентифікатор не містить ":value"',
    'search_modifier_external_id_ends'                    => 'Зовнішній ідентифікатор закінчується на ":value"',
    'search_modifier_not_external_id_ends'                => 'Зовнішній ідентифікатор не закінчується на ":value"',
    'search_modifier_external_id_starts'                  => 'Зовнішній ідентифікатор починається з ":value"',
    'search_modifier_not_external_id_starts'              => 'Зовнішній ідентифікатор не починається з ":value"',
    'search_modifier_internal_reference_contains'         => 'Внутрішнє посилання містить ":value"',
    'search_modifier_not_internal_reference_contains'     => 'Внутрішнє посилання не містить ":value"',
    'search_modifier_internal_reference_ends'             => 'Внутрішнє посилання закінчується на ":value"',
    'search_modifier_internal_reference_starts'           => 'Внутрішнє посилання починається з ":value"',
    'search_modifier_not_internal_reference_ends'         => 'Внутрішнє посилання не закінчується на ":value"',
    'search_modifier_not_internal_reference_starts'       => 'Внутрішнє посилання не починається з ":value"',
    'search_modifier_external_url_is'                     => 'Зовнішня URL-адреса ":value"',
    'search_modifier_not_external_url_is'                 => 'Зовнішня URL-адреса не є ":value"',
    'search_modifier_external_url_contains'               => 'Зовнішня URL-адреса містить ":value"',
    'search_modifier_not_external_url_contains'           => 'Зовнішня URL-адреса не містить ":value"',
    'search_modifier_external_url_ends'                   => 'Зовнішня URL-адреса закінчується на ":value"',
    'search_modifier_not_external_url_ends'               => 'Зовнішня URL-адреса не закінчується на ":value"',
    'search_modifier_external_url_starts'                 => 'Зовнішня URL-адреса починається з ":value"',
    'search_modifier_not_external_url_starts'             => 'Зовнішня URL-адреса не починається з ":value"',
    'search_modifier_has_no_attachments'                  => 'Операція має прикріплених файлів',
    'search_modifier_not_has_no_attachments'              => 'Операція має прикріплені файли',
    'search_modifier_not_has_attachments'                 => 'Операція має прикріплених файлів',
    'search_modifier_account_is_cash'                     => 'Будь-який рахунок є "(cash)" рахунком.',
    'search_modifier_not_account_is_cash'                 => 'Жоден рахунок не є "(cash)" рахунком.',
    'search_modifier_journal_id'                          => 'Ідентифікатор журналу: ":value"',
    'search_modifier_not_journal_id'                      => 'Ідентифікатор журналу не ":value"',
    'search_modifier_recurrence_id'                       => 'Ідентифікатор повторюваної операції ":value"',
    'search_modifier_not_recurrence_id'                   => 'Ідентифікатор повторюваної операції не ":value"',
    'search_modifier_foreign_amount_is'                   => 'Сума у валюті ":value"',
    'search_modifier_not_foreign_amount_is'               => 'Сума у валюті не ":value"',
    'search_modifier_foreign_amount_less'                 => 'Сума у валюті менша за ":value"',
    'search_modifier_not_foreign_amount_more'             => 'Сума у валюті більша за ":value"',
    'search_modifier_not_foreign_amount_less'             => 'Сума у валюті не менша за ":value"',
    'search_modifier_foreign_amount_more'                 => 'Сума у валюті не більша за ":value"',
    'search_modifier_exists'                              => 'Операція існує (будь-яка операція)',
    'search_modifier_not_exists'                          => 'Операція не існує (немає операцій)',

    // date fields
    'search_modifier_interest_date_on'                    => 'Дата нарахування відсотків ":value"',
    'search_modifier_not_interest_date_on'                => 'Дата нарахування відсотків не ":value"',
    'search_modifier_interest_date_on_year'               => 'Дата нарахування відсотків ":value" року',
    'search_modifier_not_interest_date_on_year'           => 'Дата нарахування відсотків не ":value" року',
    'search_modifier_interest_date_on_month'              => 'Дата нарахування відсотків ":value" місяця',
    'search_modifier_not_interest_date_on_month'          => 'Дата нарахування відсотків не ":value" місяця',
    'search_modifier_interest_date_on_day'                => 'Дата нарахування відсотків в ":value" дні місяця',
    'search_modifier_not_interest_date_on_day'            => 'Дата нарахування відсотків не в ":value" дні місяця',
    'search_modifier_interest_date_before_year'           => 'Дата нарахування відсотків до або в ":value" році',
    'search_modifier_interest_date_before_month'          => 'Дата нарахування відсотків до або в ":value" місяці',
    'search_modifier_interest_date_before_day'            => 'Дата нарахування відсотків до або в ":value" дні місяця',
    'search_modifier_interest_date_after_year'            => 'Дата нарахування відсотків після або в ":value" році',
    'search_modifier_interest_date_after_month'           => 'Дата нарахування відсотків після або в ":value" місяці',
    'search_modifier_interest_date_after_day'             => 'Дата нарахування відсотків після або в ":value" дні місяця',
    'search_modifier_book_date_on_year'                   => 'Дата книги операцій знаходиться в ":value" році',
    'search_modifier_book_date_on_month'                  => 'Дата книги операцій знаходиться в ":value" місяці',
    'search_modifier_book_date_on_day'                    => 'Дата книги операцій знаходиться в ":value" дні місяця',
    'search_modifier_not_book_date_on_year'               => 'Дата книги операцій знаходиться не в ":value" році',
    'search_modifier_not_book_date_on_month'              => 'Дата книги операцій знаходиться не в ":value" місяці',
    'search_modifier_not_book_date_on_day'                => 'Дата книги операцій знаходиться не в ":value" дні місяця',
    'search_modifier_book_date_before_year'               => 'Дата книги операцій знаходиться до або в ":value" році',
    'search_modifier_book_date_before_month'              => 'Дата книги операцій знаходиться до або в ":value" місяці',
    'search_modifier_book_date_before_day'                => 'Дата книги операцій знаходиться до або в ":value" дні місяця',
    'search_modifier_book_date_after_year'                => 'Дата операції була після або в ":value" році',
    'search_modifier_book_date_after_month'               => 'Дата операції була після або в ":value" місяці',
    'search_modifier_book_date_after_day'                 => 'Дата операції була після або в ":value" дні місяця',
    'search_modifier_process_date_on_year'                => 'Дата операції вказана в ":value" році',
    'search_modifier_process_date_on_month'               => 'Дата операції вказана в ":value" місяці',
    'search_modifier_process_date_on_day'                 => 'Дата операції вказана в ":value" дні місяця',
    'search_modifier_not_process_date_on_year'            => 'Дата операції вказана не в ":value" році',
    'search_modifier_not_process_date_on_month'           => 'Дата операції вказана не в ":value" місяці',
    'search_modifier_not_process_date_on_day'             => 'Дата операції вказана не в ":value" дні місяця',
    'search_modifier_process_date_before_year'            => 'Дата операції вказана до або в ":value" році',
    'search_modifier_process_date_before_month'           => 'Дата операції вказана до або в ":value" місяці',
    'search_modifier_process_date_before_day'             => 'Дата операції вказана до або в ":value" дні місяця',
    'search_modifier_process_date_after_year'             => 'Дата операції вказана після або в ":value" році',
    'search_modifier_process_date_after_month'            => 'Дата операції вказана після або в ":value" місяці',
    'search_modifier_process_date_after_day'              => 'Дата операції вказана після або в ":value" дні місяця',
    'search_modifier_due_date_on_year'                    => 'Термін виконання операції вказано в ":value" році',
    'search_modifier_due_date_on_month'                   => 'Термін виконання операції вказано в ":value" місяці',
    'search_modifier_due_date_on_day'                     => 'Термін виконання операції вказано в ":value" дні місяця',
    'search_modifier_not_due_date_on_year'                => 'Термін виконання операції не вказано в ":value" році',
    'search_modifier_not_due_date_on_month'               => 'Термін виконання операції не вказано в ":value" місяці',
    'search_modifier_not_due_date_on_day'                 => 'Термін виконання операції не вказано в ":value" дні місяця',
    'search_modifier_due_date_before_year'                => 'Термін виконання операції до або в ":value" році',
    'search_modifier_due_date_before_month'               => 'Термін виконання операції до або в ":value" місяці',
    'search_modifier_due_date_before_day'                 => 'Термін виконання операції до або в ":value" дні місяця',
    'search_modifier_due_date_after_year'                 => 'Термін виконання операції наступає після або в ":value" році',
    'search_modifier_due_date_after_month'                => 'Термін виконання операції наступає після або в ":value" місяці',
    'search_modifier_due_date_after_day'                  => 'Термін виконання операції наступає після або в ":value" дні місяця',
    'search_modifier_payment_date_on_year'                => 'Дата платежу операції вказана в ":value" році',
    'search_modifier_payment_date_on_month'               => 'Дата платежу операції вказана в ":value" місяці',
    'search_modifier_payment_date_on_day'                 => 'Дата платежу операції вказана в ":value" дні місяця',
    'search_modifier_not_payment_date_on_year'            => 'Дата платежу операції не вказано в ":value" році',
    'search_modifier_not_payment_date_on_month'           => 'Дата платежу операції не вказано в ":value" місяці',
    'search_modifier_not_payment_date_on_day'             => 'Дата платежу операції не вказано в ":value" дні місяця',
    'search_modifier_payment_date_before_year'            => 'Дата платежу операції до або в ":value" році',
    'search_modifier_payment_date_before_month'           => 'Дата платежу операції до або в ":value" місяці',
    'search_modifier_payment_date_before_day'             => 'Дата платежу операції до або в ":value" дні місяця',
    'search_modifier_payment_date_after_year'             => 'Дата платежу операції наступає після або в ":value" році',
    'search_modifier_payment_date_after_month'            => 'Дата платежу операції наступає після або в ":value" місяці',
    'search_modifier_payment_date_after_day'              => 'Дата платежу операції наступає після або в ":value" дні місяця',
    'search_modifier_invoice_date_on_year'                => 'Дата рахунку-фактури операції вказана в ":value" році',
    'search_modifier_invoice_date_on_month'               => 'Дата рахунку-фактури операції вказана в ":value" місяці',
    'search_modifier_invoice_date_on_day'                 => 'Дата рахунку-фактури операції вказана в ":value" дні місяця',
    'search_modifier_not_invoice_date_on_year'            => 'Дата рахунку-фактури операції не вказано в ":value" році',
    'search_modifier_not_invoice_date_on_month'           => 'Дата рахунку-фактури операції не вказано в ":value" місяці',
    'search_modifier_not_invoice_date_on_day'             => 'Дата рахунку-фактури операції не вказано в ":value" дні місяця',
    'search_modifier_invoice_date_before_year'            => 'Дата рахунку-фактури операції до або в ":value" році',
    'search_modifier_invoice_date_before_month'           => 'Дата рахунку-фактури операції до або в ":value" місяці',
    'search_modifier_invoice_date_before_day'             => 'Дата рахунку-фактури операції до або в ":value" дні місяця',
    'search_modifier_invoice_date_after_year'             => 'Дата рахунка-фактури операції після або в ":value" році',
    'search_modifier_invoice_date_after_month'            => 'Дата рахунка-фактури операції після або в ":value" місяці',
    'search_modifier_invoice_date_after_day'              => 'Дата рахунку-фактури операції після або в ":value" день місяця',
    // other dates
    'search_modifier_updated_at_on_year'                  => 'Операцію востаннє оновлено в ":value" році',
    'search_modifier_updated_at_on_month'                 => 'Операцію востаннє оновлено в ":value" місяці',
    'search_modifier_updated_at_on_day'                   => 'Операцію востаннє оновлено в ":value" дні місяця',
    'search_modifier_not_updated_at_on_year'              => 'Операцію востаннє не оновлено в ":value" році',
    'search_modifier_not_updated_at_on_month'             => 'Операцію востаннє не оновлено в ":value" місяці',
    'search_modifier_not_updated_at_on_day'               => 'Операцію востаннє не оновлено в ":value" дні місяця',
    'search_modifier_updated_at_before_year'              => 'Операцію востаннє оновлено в або до ":value" році',
    'search_modifier_updated_at_before_month'             => 'Операцію востаннє оновлено в або до ":value" місяці',
    'search_modifier_updated_at_before_day'               => 'Операцію востаннє оновлено в або до ":value" дні місяця',
    'search_modifier_updated_at_after_year'               => 'Операцію востаннє оновлено в або після ":value" році',
    'search_modifier_updated_at_after_month'              => 'Операцію востаннє оновлено в або після ":value" місяці',
    'search_modifier_updated_at_after_day'                => 'Операцію востаннє оновлено в або після ":value" дні місяця',
    'search_modifier_created_at_on_year'                  => 'Операцію було створено в ":value" році',
    'search_modifier_created_at_on_month'                 => 'Операцію було створено в ":value" місяці',
    'search_modifier_created_at_on_day'                   => 'Операцію було створено в ":value" дні місяця',
    'search_modifier_not_created_at_on_year'              => 'Операцію не було створено в ":value" році',
    'search_modifier_not_created_at_on_month'             => 'Операцію не було створено в ":value" місяці',
    'search_modifier_not_created_at_on_day'               => 'Операцію не було створено в ":value" дні місяця',
    'search_modifier_created_at_before_year'              => 'Операцію було створено в або до ":value" році',
    'search_modifier_created_at_before_month'             => 'Операцію було створено в або до ":value" місяці',
    'search_modifier_created_at_before_day'               => 'Операцію було створено в або до ":value" дні місяця',
    'search_modifier_created_at_after_year'               => 'Операцію було створено в або після ":value" році',
    'search_modifier_created_at_after_month'              => 'Операцію було створено в або після ":value" місяці',
    'search_modifier_created_at_after_day'                => 'Операцію було створено в або після ":value" дні місяця',
    'search_modifier_interest_date_before'                => 'Дата нарахування відсотків не перевищує ":value"',
    'search_modifier_interest_date_after'                 => 'Дата нарахування відсотків не раніше ":value"',
    'search_modifier_book_date_on'                        => 'Дата книги операцій ":value"',
    'search_modifier_not_book_date_on'                    => 'Дата книги операцій не ":value"',
    'search_modifier_book_date_before'                    => 'Дата книги операцій не перевищує ":value"',
    'search_modifier_book_date_after'                     => 'Дата книги операцій не раніше ":value"',
    'search_modifier_process_date_on'                     => 'Дата обробки операції ":value"',
    'search_modifier_not_process_date_on'                 => 'Дата обробки операції не ":value"',
    'search_modifier_process_date_before'                 => 'Дата обробки операції не перевищує ":value"',
    'search_modifier_process_date_after'                  => 'Дата обробки операції не раніше ":value"',
    'search_modifier_due_date_on'                         => 'Термін виконання операції ":value"',
    'search_modifier_not_due_date_on'                     => 'Термін виконання операції не ":value"',
    'search_modifier_due_date_before'                     => 'Термін виконання операції не перевищує ":value"',
    'search_modifier_due_date_after'                      => 'Термін виконання операції не раніше ":value"',
    'search_modifier_payment_date_on'                     => 'Дата платежу ":value"',
    'search_modifier_not_payment_date_on'                 => 'Дата платежу не ":value"',
    'search_modifier_payment_date_before'                 => 'Дата платежу не перевищує ":value"',
    'search_modifier_payment_date_after'                  => 'Дата платежу не раніше ":value"',
    'search_modifier_invoice_date_on'                     => 'Дата рахунка-фактури ":value"',
    'search_modifier_not_invoice_date_on'                 => 'Дата рахунка-фактури не ":value"',
    'search_modifier_invoice_date_before'                 => 'Дата рахунка-фактури не перевищує ":value"',
    'search_modifier_invoice_date_after'                  => 'Дата рахунка-фактури не раніше ":value"',
    'search_modifier_created_at_on'                       => 'Операцію створено ":value"',
    'search_modifier_not_created_at_on'                   => 'Операцію не створено ":value"',
    'search_modifier_created_at_before'                   => 'Операцію створено не пізніше ":value"',
    'search_modifier_created_at_after'                    => 'Операцію створена в або після ":value"',
    'search_modifier_updated_at_on'                       => 'Операцію оновлено ":value"',
    'search_modifier_not_updated_at_on'                   => 'Операцію не оновлено ":value"',
    'search_modifier_updated_at_before'                   => 'Операцію оновлено в або до ":value"',
    'search_modifier_updated_at_after'                    => 'Операцію оновлено в або після ":value"',

    'search_modifier_attachment_name_is'            => 'Будь-яке вкладення має назву ":value"',
    'search_modifier_attachment_name_contains'      => 'Будь-яке ім’я вкладення містить ":value"',
    'search_modifier_attachment_name_starts'        => 'Ім\'я будь-якого вкладення починається з ":value"',
    'search_modifier_attachment_name_ends'          => 'Будь-яке ім’я вкладення закінчується на ":value"',
    'search_modifier_attachment_notes_are'          => 'Будь-які примітки до вкладення мають значення ":value"',
    'search_modifier_attachment_notes_contains'     => 'Будь-які примітки до вкладення містять ":value"',
    'search_modifier_attachment_notes_starts'       => 'Будь-які примітки до вкладення починаються з ":value"',
    'search_modifier_attachment_notes_ends'         => 'Будь-які примітки до вкладення закінчуються на ":value"',
    'search_modifier_not_attachment_name_is'        => 'Будь-яке ім\'я вкладення не ":value"',
    'search_modifier_not_attachment_name_contains'  => 'Будь-яке ім\'я вкладення не містить ":value"',
    'search_modifier_not_attachment_name_starts'    => 'Назва вкладення не починається з ":value"',
    'search_modifier_not_attachment_name_ends'      => 'Назва вкладення не закінчується на ":value"',
    'search_modifier_not_attachment_notes_are'      => 'Будь-які примітки вкладення не ":value"',
    'search_modifier_not_attachment_notes_contains' => 'Будь-які примітки вкладення не містять ":value"',
    'search_modifier_not_attachment_notes_starts'   => 'Будь-які примітки до вкладення починаються з ":value"',
    'search_modifier_not_attachment_notes_ends'     => 'Примітки до вкладення не закінчуються на ":value"',
    'search_modifier_sepa_ct_is'                    => 'SEPA CT дорівнює ":value"',
    'update_rule_from_query'                        => 'Оновити правило ":rule" із пошукового запиту',
    'create_rule_from_query'                        => 'Створити нове правило з пошукового запиту',
    'rule_from_search_words'                        => 'Рушію правил важко обробити ":string". Пропоноване правило, яке відповідає вашому запиту, може дати різні результати. Будь ласка, уважно перевіряйте умови.',

    // more new stuff
    'search_modifier_destination_balance_is'        => 'Баланс на рахунку-одержувача співпадає з ":value"',
    'search_modifier_not_destination_balance_is'    => 'Баланс на рахунку-одержувача не співпадає з ":value"',
    'search_modifier_source_balance_is'             => 'Баланс вихідного рахунку співпадає з ":value"',
    'search_modifier_not_source_balance_is'         => 'Баланс вихідного рахунку не співпадає з ":value"',

    'search_modifier_destination_balance_lte'     => 'Баланс на рахунку-одержувача менше чи дорівнює ":value"',
    'search_modifier_not_destination_balance_lte' => 'Баланс на рахунку-одержувача перевищує ":value"',
    'search_modifier_source_balance_lte'          => 'Баланс на вихідному рахунку менше чи дорівнює ":value"',
    'search_modifier_not_source_balance_lte'      => 'Баланс на вихідному рахунку перевищує ":value"',

    'search_modifier_destination_balance_lt'     => 'Баланс на рахунку-одержувача менше ніж ":value"',
    'search_modifier_not_destination_balance_lt' => 'Баланс на рахунку-одержувача більше чи дорівнює ":value"',
    'search_modifier_source_balance_lt'          => 'Баланс на вихідному рахунку менше ніж ":value"',
    'search_modifier_not_source_balance_lt'      => 'Баланс на вихідному рахунку більше чи дорівнює ":value"',

    'search_modifier_destination_balance_gte'     => 'Баланс на рахунку-одержувача більше чи дорівнює ":value"',
    'search_modifier_not_destination_balance_gte' => 'Баланс на рахунку-одержувача менше ніж ":value"',
    'search_modifier_source_balance_gte'          => 'Баланс на вихідному рахунку більше чи дорівнює ":value"',
    'search_modifier_not_source_balance_gte'      => 'Баланс на вихідному рахунку менше ніж ":value"',

    'search_modifier_destination_balance_gt'              => 'Баланс на рахунку-одержувача перевищує ":value"',
    'search_modifier_not_destination_balance_gt'          => 'Баланс на рахунку-одержувача менше чи дорівнює ":value"',
    'search_modifier_source_balance_gt'                   => 'Баланс на вихідному рахунку перевищує ":value"',
    'search_modifier_not_source_balance_gt'               => 'Баланс на вихідному рахунку менше чи дорівнює ":value"',


    // END
    'general_search_error'                                => 'Під час пошуку виникла помилка. Будь-ласка, перевірте файл журналу для отримання додаткової інформації.',
    'search_box'                                          => 'Пошук',
    'search_box_intro'                                    => 'Ласкаво просимо до функції пошуку Firefly III. Введіть ваш пошуковий запит у віконце. Переконайтеся, що ви ознайомились із <a href="https://docs.firefly-iii.org/how-to/firefly-iii/features/search/">файлом довідки</a>, оскільки пошук є досить просунутим.',
    'search_error'                                        => 'Помилка під час пошуку',
    'search_searching'                                    => 'Шукаємо ...',
    'search_results'                                      => 'Результати пошуку',

    // repeat frequencies:
    'repeat_freq_yearly'                                  => 'за роками',
    'repeat_freq_half-year'                               => 'кожних півроку',
    'repeat_freq_quarterly'                               => 'за кварталами',
    'repeat_freq_monthly'                                 => 'щомісяця',
    'repeat_freq_weekly'                                  => 'щотижня',
    'repeat_freq_daily'                                   => 'щодня',
    'daily'                                               => 'щодня',
    'weekly'                                              => 'щотижня',
    'quarterly'                                           => 'за кварталами',
    'half-year'                                           => 'кожних півроку',
    'yearly'                                              => 'щороку',

    // rules
    'is_not_rule_trigger'                                 => 'Не',
    'cannot_fire_inactive_rules'                          => 'Ви не можете виконати неактивні правила.',
    'show_triggers'                                       => 'Показувати тригери',
    'show_actions'                                        => 'Показати дії',
    'rules'                                               => 'Правила',
    'rule_name'                                           => 'Назва правила',
    'rule_triggers'                                       => 'Виконується правило коли',
    'rule_actions'                                        => 'Правило буде',
    'new_rule'                                            => 'Нове правило',
    'new_rule_group'                                      => 'Нова група правил',
    'rule_priority_up'                                    => 'Вказати для правила більший пріоритет',
    'rule_priority_down'                                  => 'Дати правилу меньший пріоритет',
    'make_new_rule_group'                                 => 'Створити нову групу правил',
    'store_new_rule_group'                                => 'Зберегти нову групу правил',
    'created_new_rule_group'                              => 'Збережена нова група правил ":title"!',
    'updated_rule_group'                                  => 'Група правил ":title" успішно оновлена.',
    'edit_rule_group'                                     => 'Редагувати групу правил ":title"',
    'duplicate_rule'                                      => 'Дублювати правило ":title"',
    'rule_copy_of'                                        => 'Копія ":title"',
    'duplicated_rule'                                     => 'Дубльоване правило ":title" в ":newTitle"',
    'delete_rule_group'                                   => 'Видалити групу правил ":title"',
    'deleted_rule_group'                                  => 'Видалено групу правил ":title"',
    'update_rule_group'                                   => 'Редагувати групу правил',
    'no_rules_in_group'                                   => 'У цій групі немає правил',
    'move_rule_group_up'                                  => 'Перемістити групу правил вгору',
    'move_rule_group_down'                                => 'Перемістити групу правил вниз',
    'save_rules_by_moving'                                => 'Збережіть це правило, перемістивши його в іншу групу правил:|Збережіть ці правила, перемістивши їх в іншу групу:',
    'make_new_rule'                                       => 'Створити нове правило в групі правил ":title"',
    'make_new_rule_no_group'                              => 'Створити нове правило',
    'instructions_rule_from_bill'                         => 'Щоби зіставити транзакції з вашою новою підпискою ":name", Firefly III може створити правило, яке буде автоматично перевіряти усі новостворені транзакції. Будь ласка, перевірте зазначені нижче деталі та збережіть правило, щоби Firefly III автоматично зіставляв транзакції з новими квитанціями.',
    'instructions_rule_from_journal'                      => 'Створіть правило на основі однієї з ваших транзакцій. Доповненіть або надішліть форму що нижче.',
    'rule_is_strict'                                      => 'суворе правило',
    'rule_is_not_strict'                                  => 'не суворе правило',
    'rule_help_stop_processing'                           => 'Коли вибрати цю опцію, наступні правила у цій групі не будуть виконані, якщо це конкретне правило буде виконано.',
    'rule_help_strict'                                    => 'У жорстких правилах ВСІ тригери повинні спрацювати для виконання дії(й). У не жорстких правилах достатньо і спрацювання одного тригера, щоб дія(ї) було виконано.',
    'rule_help_active'                                    => 'Неактивні правила ніколи не спрацьовують.',
    'stored_new_rule'                                     => 'Збережено нове правило ":title"',
    'deleted_rule'                                        => 'Видалено правило ":title"',
    'store_new_rule'                                      => 'Зберегти нове правило',
    'updated_rule'                                        => 'Оновлено правило ":title"',
    'default_rule_group_name'                             => 'Типові правила',
    'default_rule_group_description'                      => 'Тут ваші не згуртовані правила.',
    'trigger'                                             => 'Умова',
    'trigger_value'                                       => 'Значення умови',
    'stop_processing_other_triggers'                      => 'Припинити обробку інших умов',
    'add_rule_trigger'                                    => 'Додати нову умову',
    'action'                                              => 'Дія',
    'action_value'                                        => 'Значення дії',
    'stop_executing_other_actions'                        => 'Зупинити виконання інших дій',
    'add_rule_action'                                     => 'Додати нову дію',
    'edit_rule'                                           => 'Edit rule #:nr ":title"',
    'delete_rule'                                         => 'Видалити правило ":title"',
    'update_rule'                                         => 'Оновити правило',
    'test_rule_triggers'                                  => 'Переглянути відповідні транзакції',
    'warning_no_matching_transactions'                    => 'Не знайдено відповідних транзакцій.',
    'warning_no_valid_triggers'                           => 'Немає правильних умов.',
    'apply_rule_selection'                                => 'Застосуйте правило ":title" до ваших транзакцій',
    'apply_rule_selection_intro'                          => 'Правила на зразок ":title" зазвичай застосовуються лише для нових або оновлених транзакцій, але ви можете застосувати його для вже існуючих транзакцій. Це може бути корисним, коли ви оновили правило.',
    'include_transactions_from_accounts'                  => 'Транзакції з цих рахунків',
    'include'                                             => 'Включити?',
    'applied_rule_selection'                              => '{0} Жодна транзакція у вашому виборі не була змінена правилом ":title".|[1] Одна транзакція у вашому виборі була змінена правилом ":title".|[2,*] :count транзакцій у вашому виборі змінено правило ":title".',
    'execute'                                             => 'Виконати',
    'apply_rule_group_selection'                          => 'Застосуйте групу правил ":title" до обраних транзакцій',
    'apply_rule_group_selection_intro'                    => 'Групи правили як ":title" зазвичай застосовуються тільки до нових або оновлених транзакцій, але ви можете сказати Firefly III виконувати всі правила в цій групі при виборі ваших вже існуючих операцій. Це може бути корисним коли ви оновили групу правил і вам потрібні зміни, які будуть застосовані до всіх інших ваших операцій.',
    'applied_rule_group_selection'                        => 'Група правил ":title" була застосована до обраних транзакцій.',
    'rule_run_after_creation' => 'If you check this box, you get the opportunity to run the rule after it has been created.',
    'rule_run_after_edit' => 'If you check this box, you get the opportunity to run the rule after it has been updated.',

    // actions and triggers
    'rule_trigger_store_journal'                          => 'При створенні транзакції',
    'rule_trigger_update_journal'                         => 'Коли транзакція оновлена',
    'rule_trigger_manual'                                 => 'Тільки за активації користувачем',
    'rule_trigger_user_action'                            => 'Дія користувача ":trigger_value"',

    // OLD values (remove non-doubles later):
    'rule_trigger_source_account_starts_choice'           => 'Ім\'я вихідного рахунку починається з ": value"..',
    'rule_trigger_source_account_starts'                  => 'Назва джерела рахунку починається з ":trigger_value"',
    'rule_trigger_source_account_ends_choice'             => 'Назва джерела рахунку закінчується на..',
    'rule_trigger_source_account_ends'                    => 'Назва джерела рахунку закінчується на ":trigger_value"',
    'rule_trigger_source_account_is_choice'               => 'Ім\'я вихідного рахунку містить..',
    'rule_trigger_source_account_is'                      => 'Назва джерела рахунку ":trigger_value"',
    'rule_trigger_source_account_contains_choice'         => 'Назва джерела рахунку містить..',
    'rule_trigger_source_account_contains'                => 'Назва джерела рахунку містить ":trigger_value"',
    'rule_trigger_account_id_choice'                      => 'Ідентифікація будь-якого рахунку є точною..',
    'rule_trigger_account_id'                             => 'Ідентифікатор рахунку є саме :trigger_value',
    'rule_trigger_source_account_id_choice'               => 'Ідентифікація будь-якого джерела рахунку є точною..',
    'rule_trigger_source_account_id'                      => 'Ідентифікатор джерела рахунку є саме :trigger_value',
    'rule_trigger_destination_account_id_choice'          => 'Ідентифікація рахунку призначення є точною..',
    'rule_trigger_destination_account_id'                 => 'Ідентифікатор рахунку призначення є саме :trigger_value',
    'rule_trigger_account_is_cash_choice'                 => 'Будь-який рахунок є готівковим',
    'rule_trigger_account_is_cash'                        => 'Будь-який рахунок є готівковим',
    'rule_trigger_source_is_cash_choice'                  => 'Джерелом рахунком є ​​(готівковий) рахунок',
    'rule_trigger_source_is_cash'                         => 'Джерелом рахунком є ​​(готівковий) рахунок',
    'rule_trigger_destination_is_cash_choice'             => 'Рахунком призначення є ​​(готівковий) рахунок',
    'rule_trigger_destination_is_cash'                    => 'Рахунком призначення є ​​(готівковий) рахунок',
    'rule_trigger_source_account_nr_starts_choice'        => 'Номер джерела рахунку / IBAN починається з..',
    'rule_trigger_source_account_nr_starts'               => 'Номер джерела рахунку / IBAN починається з ":trigger_value"',
    'rule_trigger_source_account_nr_ends_choice'          => 'Номер рахунку призначення / IBAN закінчується на..',
    'rule_trigger_source_account_nr_ends'                 => 'Номер рахунку призначення / IBAN закінчується на ":trigger_value"',
    'rule_trigger_source_account_nr_is_choice'            => 'Номер джерела рахунку / IBAN є..',
    'rule_trigger_source_account_nr_is'                   => 'Номер джерела рахунку / IBAN є ":trigger_value"',
    'rule_trigger_source_account_nr_contains_choice'      => 'Номер джерела рахунку / IBAN містить..',
    'rule_trigger_source_account_nr_contains'             => 'Номер джерела рахунку / IBAN ":trigger_value"',
    'rule_trigger_destination_account_starts_choice'      => 'Рахунок призначення починається з..',
    'rule_trigger_destination_account_starts'             => 'Рахунок призначення починається з ":trigger_value"',
    'rule_trigger_destination_account_ends_choice'        => 'Рахунок призначення закінчується на..',
    'rule_trigger_destination_account_ends'               => 'Рахунок призначення закінчується на ":trigger_value"',
    'rule_trigger_destination_account_is_choice'          => 'Рахунок-одержувач..',
    'rule_trigger_destination_account_is'                 => 'Рахунок-одержувач ":trigger_value"',
    'rule_trigger_destination_account_contains_choice'    => 'Ім\'я рахуноку-одержувача містить..',
    'rule_trigger_destination_account_contains'           => 'Ім\'я рахуноку-одержувача містить ":trigger_value"',
    'rule_trigger_destination_account_nr_starts_choice'   => 'Рахунок призначення / IBAN починається з..',
    'rule_trigger_destination_account_nr_starts'          => 'Рахунок призначення / IBAN починається з ":trigger_value"',
    'rule_trigger_destination_account_nr_ends_choice'     => 'Рахунок призначення / IBAN закінчується на..',
    'rule_trigger_destination_account_nr_ends'            => 'Рахунок призначення / IBAN закінчується на ":trigger_value"',
    'rule_trigger_destination_account_nr_is_choice'       => 'Рахунок призначення / IBAN..',
    'rule_trigger_destination_account_nr_is'              => 'Рахунок призначення / IBAN ":trigger_value"',
    'rule_trigger_destination_account_nr_contains_choice' => 'Рахунок призначення / IBAN містить..',
    'rule_trigger_destination_account_nr_contains'        => 'Рахунок призначення / IBAN містить ":trigger_value"',
    'rule_trigger_transaction_type_choice'                => 'Транзакція має тип..',
    'rule_trigger_transaction_type'                       => 'Тип операції ":trigger_value"',
    'rule_trigger_category_is_choice'                     => 'Категорія є..',
    'rule_trigger_category_is'                            => 'Категорія дорівнює ":trigger_value"',
    'rule_trigger_amount_less_choice'                     => 'Сума менша або дорівнює ..',
    'rule_trigger_amount_less'                            => 'Сума менша або дорівнює :trigger_value',
    'rule_trigger_amount_is_choice'                       => 'Сума..',
    'rule_trigger_amount_is'                              => 'Сума :trigger_value',
    'rule_trigger_amount_more_choice'                     => 'Сума більше або дорівнює..',
    'rule_trigger_amount_more'                            => 'Сума більше або дорівнює :trigger_value',
    'rule_trigger_description_starts_choice'              => 'Опис починається з..',
    'rule_trigger_description_starts'                     => 'Опис починається з ":trigger_value"',
    'rule_trigger_description_ends_choice'                => 'Опис закінчується на..',
    'rule_trigger_description_ends'                       => 'Опис закінчується ":trigger_value"',
    'rule_trigger_description_contains_choice'            => 'Опис містить..',
    'rule_trigger_description_contains'                   => 'Опис містить ":trigger_value"',
    'rule_trigger_description_is_choice'                  => 'Опис..',
    'rule_trigger_description_is'                         => 'Опис ":trigger_value"',
    'rule_trigger_date_on_choice'                         => 'Дата операції..',
    'rule_trigger_date_on'                                => 'Дата операції ":trigger_value"',
    'rule_trigger_date_before_choice'                     => 'Дата операції раніше..',
    'rule_trigger_date_before'                            => 'Дата операції раніше ":trigger_value"',
    'rule_trigger_date_after_choice'                      => 'Дата операції пізніше..',
    'rule_trigger_date_after'                             => 'Дата транзакції після ":trigger_value"',
    'rule_trigger_created_at_on_choice'                   => 'Операція була створена..',
    'rule_trigger_created_at_on'                          => 'Операція була створена ":trigger_value"',
    'rule_trigger_updated_at_on_choice'                   => 'Операція була відредагована..',
    'rule_trigger_updated_at_on'                          => 'Операція була відредагована ":trigger_value"',
    'rule_trigger_budget_is_choice'                       => 'Бюджет..',
    'rule_trigger_budget_is'                              => 'Бюджет ":trigger_value"',
    'rule_trigger_tag_is_choice'                          => 'Будь-яка мітка..',
    'rule_trigger_tag_is'                                 => 'Будь-яка мітка ":trigger_value"',
    'rule_trigger_tag_contains_choice'                    => 'Будь-який тег містить..',
    'rule_trigger_tag_contains'                           => 'Будь-який тег містить ":trigger_value"',
    'rule_trigger_not_tag_contains'                           => 'No tag contains ":trigger_value"',
    'rule_trigger_tag_ends_choice'                        => 'Будь-яка мітка закінчується на..',
    'rule_trigger_tag_ends'                               => 'Будь-який тег закінчується на ":trigger_value "',
    'rule_trigger_tag_starts_choice'                      => 'Будь-який тег починається з..',
    'rule_trigger_tag_starts'                             => 'Будь-який тег починається з ":trigger_value "',
    'rule_trigger_currency_is_choice'                     => 'Валюти транзакцій є..',
    'rule_trigger_currency_is'                            => 'Валюта цієї транзакції ":trigger_value"',
    'rule_trigger_foreign_currency_is_choice'             => 'Валюта транзакції є..',
    'rule_trigger_foreign_currency_is'                    => 'Валюта цієї транзакції ":trigger_value"',
    'rule_trigger_has_attachments_choice'                 => 'Має будь-які вкладення',
    'rule_trigger_has_attachments'                        => 'Має вкладення',
    'rule_trigger_has_no_category_choice'                 => 'Без категорії',
    'rule_trigger_has_no_category'                        => 'Транзакції без категорії',
    'rule_trigger_has_any_category_choice'                => 'Має (будь-яку) категорію',
    'rule_trigger_has_any_category'                       => 'Транзакція має категорію (будь-яка)',
    'rule_trigger_has_no_budget_choice'                   => 'Немає пов\'язаного бюджету',
    'rule_trigger_has_no_budget'                          => 'Транзакція не має бюджету',
    'rule_trigger_has_any_budget_choice'                  => 'Має (будь-який) бюджет',
    'rule_trigger_has_any_budget'                         => 'Транзакція має бюджет (будь-який)',
    'rule_trigger_has_no_bill_choice'                     => 'Не має жодних підписок',
    'rule_trigger_has_no_bill'                            => 'Транзакція не має підписки',
    'rule_trigger_has_any_bill_choice'                    => 'Має (будь-яку) підписку',
    'rule_trigger_has_any_bill'                           => 'Транзакція має хоч якусь підписку',
    'rule_trigger_has_no_tag_choice'                      => 'Немає тегів',
    'rule_trigger_has_no_tag'                             => 'Транзакція не має тегів(ів)',
    'rule_trigger_has_any_tag_choice'                     => 'Є один або кілька тегів (будь-яких)',
    'rule_trigger_has_any_tag'                            => 'Транзакція має один або декілька (будь-який) тегів',
    'rule_trigger_any_notes_choice'                       => 'Має (будь-які) нотатки',
    'rule_trigger_any_notes'                              => 'Операція має (якісь) примітки',
    'rule_trigger_no_notes_choice'                        => 'Нотатки відсутні',
    'rule_trigger_no_notes'                               => 'Транзакція не містить нотаток',
    'rule_trigger_notes_is_choice'                        => 'Примітки..',
    'rule_trigger_notes_is'                               => 'Примітки ":trigger_value"',
    'rule_trigger_notes_contains_choice'                  => 'Примітки містять..',
    'rule_trigger_notes_contains'                         => 'Примітки містять ":trigger_value"',
    'rule_trigger_notes_starts_choice'                    => 'Примітки починаються з..',
    'rule_trigger_notes_starts'                           => 'Примітки починаються з ":trigger_value"',
    'rule_trigger_notes_ends_choice'                      => 'Примітки завершуються на..',
    'rule_trigger_notes_ends'                             => 'Примітки завершуються на ":trigger_value"',
    'rule_trigger_bill_is_choice'                         => 'Підписка..',
    'rule_trigger_bill_is'                                => 'Підписка ":trigger_value"',
    'rule_trigger_external_id_is_choice'                  => 'Зовнішній ID містить..',
    'rule_trigger_external_id_is'                         => 'Зовнішній ідентифікатор ":trigger_value"',
    'rule_trigger_internal_reference_is_choice'           => 'Внутрішнє посилання - це..',
    'rule_trigger_internal_reference_is'                  => 'Внутрішнє посилання ":trigger_value"',
    'rule_trigger_journal_id_choice'                      => 'Ідентифікатор журналу операцій є..',
    'rule_trigger_journal_id'                             => 'Ідентифікатор журналу операцій є ":trigger_value"',
    'rule_trigger_any_external_url'                       => 'Операція має (якусь) зовнішню URL-адресу',
    'rule_trigger_any_external_url_choice'                => 'Has an (any) external URL',
    'rule_trigger_any_external_id'                        => 'Операція має (якийсь) зовнішній ID',
    'rule_trigger_any_external_id_choice'                 => 'Has an (any) external ID',
    'rule_trigger_no_external_url_choice'                 => 'Has no external URL',
    'rule_trigger_no_external_url'                        => 'Операція не має зовнішньої URL-адреси',
    'rule_trigger_no_external_id_choice'                  => 'Has no external ID',
    'rule_trigger_no_external_id'                         => 'Операція не має зовнішнього ID',
    'rule_trigger_id_choice'                              => 'Ідентифікатор операції..',
    'rule_trigger_id'                                     => 'Ідентифікатор операції: ":trigger_value"',
    'rule_trigger_sepa_ct_is_choice'                      => 'SEPA CT дорівнює..',
    'rule_trigger_sepa_ct_is'                             => 'SEPA CT це ":trigger_value"',

    // new values:
    'rule_trigger_user_action_choice'                     => 'Дія користувача: ":trigger_value"',
    'rule_trigger_tag_is_not_choice'                      => 'Міток немає..',
    'rule_trigger_tag_is_not'                             => 'Міток немає ":trigger_value"',
    'rule_trigger_account_is_choice'                      => 'Будь-який рахунок є точним..',
    'rule_trigger_account_is'                             => 'Будь-який рахунок є точним ":trigger_value"',
    'rule_trigger_account_contains_choice'                => 'Будь-який рахунок містить..',
    'rule_trigger_account_contains'                       => 'Будь-який рахунок містить ":trigger_value"',
    'rule_trigger_account_ends_choice'                    => 'Будь-який рахунок закінчується на..',
    'rule_trigger_account_ends'                           => 'Будь-який обліковий запис закінчується на ":trigger_value"',
    'rule_trigger_account_starts_choice'                  => 'Будь-який рахунок починається з..',
    'rule_trigger_account_starts'                         => 'Будь-який рахунок починається з ":trigger_value"',
    'rule_trigger_account_nr_is_choice'                   => 'Будь-який номер рахунку / IBAN є..',
    'rule_trigger_account_nr_is'                          => 'Будь-який номер рахунку / IBAN є ":trigger_value"',
    'rule_trigger_account_nr_contains_choice'             => 'Будь-який номер рахунку / IBAN містить..',
    'rule_trigger_account_nr_contains'                    => 'Будь-який номер рахунку / IBAN містить ":trigger_value"',
    'rule_trigger_account_nr_ends_choice'                 => 'Будь-який номер рахунку/IBAN закінчується на..',
    'rule_trigger_account_nr_ends'                        => 'Будь-який номер рахунку/IBAN закінчується на ":trigger_value"',
    'rule_trigger_account_nr_starts_choice'               => 'Будь-який номер рахунку/IBAN починається з..',
    'rule_trigger_account_nr_starts'                      => 'Будь-який номер рахунку/IBAN починається з ":trigger_value"',
    'rule_trigger_category_contains_choice'               => 'Категорія містить..',
    'rule_trigger_category_contains'                      => 'Категорія містить ":trigger_value"',
    'rule_trigger_category_ends_choice'                   => 'Категорія закінчується на..',
    'rule_trigger_category_ends'                          => 'Категорія закінчується на ":trigger_value"',
    'rule_trigger_category_starts_choice'                 => 'Категорія починається з..',
    'rule_trigger_category_starts'                        => 'Категорія починається з ":trigger_value"',
    'rule_trigger_budget_contains_choice'                 => 'Бюджет містить..',
    'rule_trigger_budget_contains'                        => 'Бюджет містить ":trigger_value"',
    'rule_trigger_budget_ends_choice'                     => 'Бюджет закінчується на..',
    'rule_trigger_budget_ends'                            => 'Бюджет закінчується на ":trigger_value"',
    'rule_trigger_budget_starts_choice'                   => 'Бюджет починається з..',
    'rule_trigger_budget_starts'                          => 'Бюджет починається з ":trigger_value"',
    'rule_trigger_bill_contains_choice'                   => 'Підписка містить..',
    'rule_trigger_bill_contains'                          => 'Підписка містить ":trigger_value"',
    'rule_trigger_bill_ends_choice'                       => 'Підписка закінчується на..',
    'rule_trigger_bill_ends'                              => 'Subscription ends with ":trigger_value"',
    'rule_trigger_bill_starts_choice'                     => 'Subscription starts with..',
    'rule_trigger_bill_starts'                            => 'Subscription starts with ":trigger_value"',
    'rule_trigger_external_id_contains_choice'            => 'Зовнішній ID містить..',
    'rule_trigger_external_id_contains'                   => 'Зовнішній ID містить ":trigger_value"',
    'rule_trigger_external_id_ends_choice'                => 'Зовнішній ідентифікатор закінчується на..',
    'rule_trigger_external_id_ends'                       => 'Зовнішній ідентифікатор закінчується ":trigger_value"',
    'rule_trigger_external_id_starts_choice'              => 'Зовнішній ідентифікатор починається з..',
    'rule_trigger_external_id_starts'                     => 'Зовнішній ідентифікатор починається з ":trigger_value"',
    'rule_trigger_internal_reference_contains_choice'     => 'Внутрішнє посилання містить..',
    'rule_trigger_internal_reference_contains'            => 'Внутрішнє посилання містить ":trigger_value"',
    'rule_trigger_internal_reference_ends_choice'         => 'Внутрішнє посилання закінчується на..',
    'rule_trigger_internal_reference_ends'                => 'Внутрішнє посилання закінчується на ":trigger_value"',
    'rule_trigger_internal_reference_starts_choice'       => 'Внутрішнє посилання починається з..',
    'rule_trigger_internal_reference_starts'              => 'Внутрішнє посилання починається з ":trigger_value"',
    'rule_trigger_external_url_is_choice'                 => 'Зовнішня URL-адреса..',
    'rule_trigger_external_url_is'                        => 'Зовнішня URL-адреса ":trigger_value"',
    'rule_trigger_external_url_contains_choice'           => 'Зовнішня URL-адреса містить..',
    'rule_trigger_external_url_contains'                  => 'Зовнішня URL-адреса містить ":trigger_value"',
    'rule_trigger_external_url_ends_choice'               => 'Зовнішня URL-адреса закінчується на..',
    'rule_trigger_external_url_ends'                      => 'Зовнішня URL-адреса закінчується на ":trigger_value"',
    'rule_trigger_external_url_starts_choice'             => 'Зовнішня URL-адреса починається з..',
    'rule_trigger_external_url_starts'                    => 'Зовнішня URL-адреса починається з ":trigger_value"',
    'rule_trigger_has_no_attachments_choice'              => 'Не має вкладень',
    'rule_trigger_has_no_attachments'                     => 'Операція не має вкладень',
    'rule_trigger_recurrence_id_choice'                   => 'Ідентифікатор повторюваної транзакції..',
    'rule_trigger_recurrence_id'                          => 'Ідентифікатор повторюваної транзакції ":trigger_value"',
    'rule_trigger_interest_date_on_choice'                => 'Дата нарахування відсотків..',
    'rule_trigger_interest_date_on'                       => 'Дата нарахування відсотків ":trigger_value"',
    'rule_trigger_interest_date_before_choice'            => 'Дата нарахування відсотків раніше..',
    'rule_trigger_interest_date_before'                   => 'Дата нарахування відсотків раніше ":trigger_value"',
    'rule_trigger_interest_date_after_choice'             => 'Дата нарахування відсотків після..',
    'rule_trigger_interest_date_after'                    => 'Дата нарахування відсотків після ":trigger_value"',
    'rule_trigger_book_date_on_choice'                    => 'Дата книги..',
    'rule_trigger_book_date_on'                           => 'Дата книги ":trigger_value"',
    'rule_trigger_book_date_before_choice'                => 'Дата книги раніше..',
    'rule_trigger_book_date_before'                       => 'Дата книги раніше ":trigger_value"',
    'rule_trigger_book_date_after_choice'                 => 'Дата книги після..',
    'rule_trigger_book_date_after'                        => 'Дата книги після ":trigger_value"',
    'rule_trigger_process_date_on_choice'                 => 'Дата обробки..',
    'rule_trigger_process_date_on'                        => 'Дата обробки ":trigger_value"',
    'rule_trigger_process_date_before_choice'             => 'Дата обробки раніше..',
    'rule_trigger_process_date_before'                    => 'Дата обробки раніше ":trigger_value"',
    'rule_trigger_process_date_after_choice'              => 'Дата обробки після..',
    'rule_trigger_process_date_after'                     => 'Дата обробки після ":trigger_value"',
    'rule_trigger_due_date_on_choice'                     => 'Термін погашення..',
    'rule_trigger_due_date_on'                            => 'Термін погашення ":trigger_value"',
    'rule_trigger_due_date_before_choice'                 => 'Термін погашення раніше..',
    'rule_trigger_due_date_before'                        => 'Термін погашення раніше ":trigger_value"',
    'rule_trigger_due_date_after_choice'                  => 'Термін погашення після..',
    'rule_trigger_due_date_after'                         => 'Термін погашення після ":trigger_value"',
    'rule_trigger_payment_date_on_choice'                 => 'Дата оплати..',
    'rule_trigger_payment_date_on'                        => 'Дата оплати ":trigger_value"',
    'rule_trigger_payment_date_before_choice'             => 'Дата оплати раніше..',
    'rule_trigger_payment_date_before'                    => 'Дата оплати раніше ":trigger_value"',
    'rule_trigger_payment_date_after_choice'              => 'Дата оплати після..',
    'rule_trigger_payment_date_after'                     => 'Дата платежу після ":trigger_value"',
    'rule_trigger_invoice_date_on_choice'                 => 'Дата виставлення рахунку вказана..',
    'rule_trigger_invoice_date_on'                        => 'Дата виставлення рахунку вказана ":trigger_value"',
    'rule_trigger_invoice_date_before_choice'             => 'Дата рахунка-фактури передує..',
    'rule_trigger_invoice_date_before'                    => 'Дата рахунка-фактури передує ":trigger_value"',
    'rule_trigger_invoice_date_after_choice'              => 'Дата рахунка-фактури після..',
    'rule_trigger_invoice_date_after'                     => 'Дата рахунка-фактури після ":trigger_value"',
    'rule_trigger_created_at_before_choice'               => 'Операція була створена раніше..',
    'rule_trigger_created_at_before'                      => 'Трансакція була створена раніше ":trigger_value"',
    'rule_trigger_created_at_after_choice'                => 'Операцію було створено після..',
    'rule_trigger_created_at_after'                       => 'Операцію було створено після ":trigger_value"',
    'rule_trigger_updated_at_before_choice'               => 'Операцію востаннє оновлено раніше..',
    'rule_trigger_updated_at_before'                      => 'Операцію востаннє оновлено раніше ":trigger_value"',
    'rule_trigger_updated_at_after_choice'                => 'Операцію востаннє оновлено після..',
    'rule_trigger_updated_at_after'                       => 'Операцію востаннє оновлено після ":trigger_value"',
    'rule_trigger_foreign_amount_is_choice'               => 'Сума в валюті точно..',
    'rule_trigger_foreign_amount_is'                      => 'Сума в валюті точно ":trigger_value"',
    'rule_trigger_foreign_amount_less_choice'             => 'Сума в валюті менше ніж..',
    'rule_trigger_foreign_amount_less'                    => 'Сума в валюті менше ніж ":trigger_value"',
    'rule_trigger_foreign_amount_more_choice'             => 'Сума в валюті більше ніж..',
    'rule_trigger_foreign_amount_more'                    => 'Сума в валюті більше ніж ":trigger_value"',
    'rule_trigger_attachment_name_is_choice'              => 'Ім\'я будь-якого вкладеного файлу..',
    'rule_trigger_attachment_name_is'                     => 'Ім\'я будь-якого вкладеного файлу ":trigger_value"',
    'rule_trigger_attachment_name_contains_choice'        => 'Будь-яке ім\'я вкладення містить..',
    'rule_trigger_attachment_name_contains'               => 'Будь-яке ім\'я вкладення містить ":trigger_value"',
    'rule_trigger_attachment_name_starts_choice'          => 'Будь-яке ім’я вкладення починається з..',
    'rule_trigger_attachment_name_starts'                 => 'Будь-яке ім’я вкладення починається з ":trigger_value"',
    'rule_trigger_attachment_name_ends_choice'            => 'Будь-яке ім’я вкладення закінчується на..',
    'rule_trigger_attachment_name_ends'                   => 'Будь-яке ім’я вкладення закінчується на ":trigger_value"',
    'rule_trigger_attachment_notes_are_choice'            => 'Будь-які примітки до вкладень є..',
    'rule_trigger_attachment_notes_are'                   => 'Будь-які примітки до вкладень є ":trigger_value"',
    'rule_trigger_attachment_notes_contains_choice'       => 'Будь-які примітки до вкладення містять..',
    'rule_trigger_attachment_notes_contains'              => 'Будь-які примітки до вкладення містять ":trigger_value"',
    'rule_trigger_attachment_notes_starts_choice'         => 'Будь-які примітки до вкладення починаються з..',
    'rule_trigger_attachment_notes_starts'                => 'Будь-які примітки до вкладення починаються з ":trigger_value"',
    'rule_trigger_attachment_notes_ends_choice'           => 'Будь-які примітки до вкладення закінчуються на..',
    'rule_trigger_attachment_notes_ends'                  => 'Будь-які примітки до вкладення закінчуються на ":trigger_value"',
    'rule_trigger_reconciled_choice'                      => 'Операція узгоджена',
    'rule_trigger_reconciled'                             => 'Операція узгоджена',
    'rule_trigger_exists_choice'                          => 'Будь-яка трансакція збігається(!)',
    'rule_trigger_exists'                                 => 'Будь-яка трансакція збігається',

    // more values for new types:
    'rule_trigger_not_account_id'                         => 'Ідентифікатор рахунку не ":trigger_value"',
    'rule_trigger_not_source_account_id'                  => 'Ідентифікатор джерела рахунку не ":trigger_value"',
    'rule_trigger_not_destination_account_id'             => 'Ідентифікатор рахунку призначення не є ":trigger_value"',
    'rule_trigger_not_transaction_type'                   => 'Тип операції не ":trigger_value"',
    'rule_trigger_not_tag_is'                             => 'Тег не ":trigger_value"',
    'rule_trigger_not_tag_is_not'                         => 'Тег ":trigger_value"',
    'rule_trigger_not_description_is'                     => 'Опис не ":trigger_value"',
    'rule_trigger_not_description_contains'               => 'Description does not contain ":trigger_value"',
    'rule_trigger_not_description_ends'                   => 'Опис не закінчується на ":trigger_value"',
    'rule_trigger_not_description_starts'                 => 'Опис не починається з ":trigger_value"',
    'rule_trigger_not_notes_is'                           => 'Примітки не ":trigger_value"',
    'rule_trigger_not_notes_contains'                     => 'Примітки не містять ":trigger_value"',
    'rule_trigger_not_notes_ends'                         => 'Нотатки не закінчуються на ":trigger_value"',
    'rule_trigger_not_notes_starts'                       => 'Нотатки розпочинаються не з ":trigger_value"',
    'rule_trigger_not_source_account_is'                  => 'Джерело рахунку не ":trigger_value"',
    'rule_trigger_not_source_account_contains'            => 'Джерело рахунку не містить ":trigger_value"',
    'rule_trigger_not_source_account_ends'                => 'Джерело рахунку не закінчується на ":trigger_value"',
    'rule_trigger_not_source_account_starts'              => 'Джерело рахунку не починається з ":trigger_value"',
    'rule_trigger_not_source_account_nr_is'               => 'Номер джерела рахунку / IBAN не ":trigger_value"',
    'rule_trigger_not_source_account_nr_contains'         => 'Номер джерела рахунку / IBAN не містить ":trigger_value"',
    'rule_trigger_not_source_account_nr_ends'             => 'Номер джерела рахунку / IBAN не закінчується на ":trigger_value"',
    'rule_trigger_not_source_account_nr_starts'           => 'Номер джерела рахунку / IBAN не починається з ":trigger_value"',
    'rule_trigger_not_destination_account_is'             => 'Рахунок призначення не ":trigger_value"',
    'rule_trigger_not_destination_account_contains'       => 'Рахунок призначення не містить ":trigger_value"',
    'rule_trigger_not_destination_account_ends'           => 'Рахунок призначення не закінчується на ":trigger_value"',
    'rule_trigger_not_destination_account_starts'         => 'Рахунок призначення не починається з ":trigger_value"',
    'rule_trigger_not_destination_account_nr_is'          => 'Номер джерела рахунку / IBAN не ":trigger_value"',
    'rule_trigger_not_destination_account_nr_contains'    => 'Номер джерела рахунку / IBAN не містить ":trigger_value"',
    'rule_trigger_not_destination_account_nr_ends'        => 'Номер джерела рахунку / IBAN не закінчується на ":trigger_value"',
    'rule_trigger_not_destination_account_nr_starts'      => 'Номер джерела рахунку / IBAN не починається з ":trigger_value"',
    'rule_trigger_not_account_is'                         => 'Жодного рахунку ":trigger_value"',
    'rule_trigger_not_account_contains'                   => 'Жодного рахунку який містить ":trigger_value"',
    'rule_trigger_not_account_ends'                       => 'Жоден рахунок не закінчується ":trigger_value"',
    'rule_trigger_not_account_starts'                     => 'Жоден рахунок не починається ":trigger_value"',
    'rule_trigger_not_account_nr_is'                      => 'Жодного рахунку з номером / IBAN ":trigger_value"',
    'rule_trigger_not_account_nr_contains'                => 'Жодного рахунку з номером / IBAN який містить ":trigger_value"',
    'rule_trigger_not_account_nr_ends'                    => 'Жодного рахунку з номером / IBAN який закінчується ":trigger_value"',
    'rule_trigger_not_account_nr_starts'                  => 'Жодного рахунку з номером / IBAN який починається ":trigger_value"',
    'rule_trigger_not_category_is'                        => 'Категорія не є ":trigger_value"',
    'rule_trigger_not_category_contains'                  => 'Категорія не містить ":trigger_value"',
    'rule_trigger_not_category_ends'                      => 'Категорія не закінчується на ":trigger_value"',
    'rule_trigger_not_category_starts'                    => 'Категорія не починається з ":trigger_value"',
    'rule_trigger_not_budget_is'                          => 'Бюджет не ":trigger_value"',
    'rule_trigger_not_budget_contains'                    => 'Бюджет не включає ":trigger_value"',
    'rule_trigger_not_budget_ends'                        => 'Бюджет не закінчується на ":trigger_value"',
    'rule_trigger_not_budget_starts'                      => 'Бюджет не починається з ":trigger_value"',
    'rule_trigger_not_bill_is'                            => 'Subscription is not is ":trigger_value"',
    'rule_trigger_not_bill_contains'                      => 'Subscription does not contain ":trigger_value"',
    'rule_trigger_not_bill_ends'                          => 'Subscription does not end on ":trigger_value"',
    'rule_trigger_not_bill_starts'                        => 'Subscription does not end with ":trigger_value"',
    'rule_trigger_not_external_id_is'                     => 'Зовнішній ідентифікатор не ":trigger_value"',
    'rule_trigger_not_external_id_contains'               => 'Зовнішній ідентифікатор не містить ":trigger_value"',
    'rule_trigger_not_external_id_ends'                   => 'Зовнішній ідентифікатор не закінчується на ":trigger_value"',
    'rule_trigger_not_external_id_starts'                 => 'Зовнішній ідентифікатор не починається з ":trigger_value"',
    'rule_trigger_not_internal_reference_is'              => 'Внутрішнє посилання не ":trigger_value"',
    'rule_trigger_not_internal_reference_contains'        => 'Внутрішнє посилання не містить ":trigger_value"',
    'rule_trigger_not_internal_reference_ends'            => 'Внутрішнє посилання не закінчується на ":trigger_value"',
    'rule_trigger_not_internal_reference_starts'          => 'Внутрішнє посилання не починається з ":trigger_value"',
    'rule_trigger_not_external_url_is'                    => 'Зовнішня URL-адреса не ":trigger_value"',
    'rule_trigger_not_external_url_contains'              => 'Зовнішня URL-адреса не містить ":trigger_value"',
    'rule_trigger_not_external_url_ends'                  => 'Зовнішня URL-адреса не закінчується на ":trigger_value"',
    'rule_trigger_not_external_url_starts'                => 'Зовнішня URL-адреса не починається з ":trigger_value"',
    'rule_trigger_not_currency_is'                        => 'Валюта не ":trigger_value"',
    'rule_trigger_not_foreign_currency_is'                => 'Валюта не ":trigger_value"',
    'rule_trigger_not_id'                                 => 'Ідентифікатор операції не ":trigger_value"',
    'rule_trigger_not_journal_id'                         => 'Ідентифікатор журналу операцій не ":trigger_value"',
    'rule_trigger_not_recurrence_id'                      => 'Ідентифікатор повторення не ":trigger_value"',
    'rule_trigger_not_date_on'                            => 'Дата не ":trigger_value"',
    'rule_trigger_not_date_before'                        => 'Дата не раніше ":trigger_value"',
    'rule_trigger_not_date_after'                         => 'Дата не пізніше ":trigger_value"',
    'rule_trigger_not_interest_date_on'                   => 'Дата нарахування відсотків не ":trigger_value"',
    'rule_trigger_not_interest_date_before'               => 'Дата нарахування відсотків не раніше ":trigger_value"',
    'rule_trigger_not_interest_date_after'                => 'Дата нарахування відсотків не пізніше ":trigger_value"',
    'rule_trigger_not_book_date_on'                       => 'Дата книги не ":trigger_value"',
    'rule_trigger_not_book_date_before'                   => 'Дата книги не раніше ":trigger_value"',
    'rule_trigger_not_book_date_after'                    => 'Дата книги не пізніше ":trigger_value"',
    'rule_trigger_not_process_date_on'                    => 'Дата обробки не ":trigger_value"',
    'rule_trigger_not_process_date_before'                => 'Дата обробки не раніше ":trigger_value"',
    'rule_trigger_not_process_date_after'                 => 'Дата обробки не пізніше ":trigger_value"',
    'rule_trigger_not_due_date_on'                        => 'Термін виконання не ":trigger_value"',
    'rule_trigger_not_due_date_before'                    => 'Термін виконання не раніше ":trigger_value"',
    'rule_trigger_not_due_date_after'                     => 'Термін виконання не пізніше ":trigger_value"',
    'rule_trigger_not_payment_date_on'                    => 'Дата платежу не ":trigger_value"',
    'rule_trigger_not_payment_date_before'                => 'Дата платежу не раніше ":trigger_value"',
    'rule_trigger_not_payment_date_after'                 => 'Дата платежу не пізніше ":trigger_value"',
    'rule_trigger_not_invoice_date_on'                    => 'Дата рахунка-фактури не ":trigger_value"',
    'rule_trigger_not_invoice_date_before'                => 'Дата рахунку-фактури не раніше ":trigger_value"',
    'rule_trigger_not_invoice_date_after'                 => 'Дата рахунку-фактури не пізніше ":trigger_value"',
    'rule_trigger_not_created_at_on'                      => 'Операція не створена ":trigger_value"',
    'rule_trigger_not_created_at_before'                  => 'Операція не створена раніше ":trigger_value"',
    'rule_trigger_not_created_at_after'                   => 'Операція не створена пізніше ":trigger_value"',
    'rule_trigger_not_updated_at_on'                      => 'Операція не оновлена ":trigger_value"',
    'rule_trigger_not_updated_at_before'                  => 'Операція не оновлена раніше ":trigger_value"',
    'rule_trigger_not_updated_at_after'                   => 'Операція не оновлена після ":trigger_value"',
    'rule_trigger_not_amount_is'                          => 'Сума операції не ":trigger_value"',
    'rule_trigger_not_amount_less'                        => 'Сума операції перевищує ":trigger_value"',
    'rule_trigger_not_amount_more'                        => 'Сума операції менша за ":trigger_value"',
    'rule_trigger_not_foreign_amount_is'                  => 'Сума операції в валюті не ":trigger_value"',
    'rule_trigger_not_foreign_amount_less'                => 'Сума операції в валюті більша за ":trigger_value"',
    'rule_trigger_not_foreign_amount_more'                => 'Сума операції в валюті не перевищує ":trigger_value"',
    'rule_trigger_not_attachment_name_is'                 => 'Немає вкладень з назвою ":trigger_value"',
    'rule_trigger_not_attachment_name_contains'           => 'Ім\'я вкладення не містить ":trigger_value"',
    'rule_trigger_not_attachment_name_starts'             => 'Ім\'я вкладення починається з ":trigger_value"',
    'rule_trigger_not_attachment_name_ends'               => 'Ім\'я вкладення закінчується на ":trigger_value"',
    'rule_trigger_not_attachment_notes_are'               => 'Немає примітки до вкладення ":trigger_value"',
    'rule_trigger_not_attachment_notes_contains'          => 'Примітки до вкладень не містять ":trigger_value"',
    'rule_trigger_not_attachment_notes_starts'            => 'Немає приміток вкладення починаючогося з ":trigger_value"',
    'rule_trigger_not_attachment_notes_ends'              => 'Немає приміток вкладення закінчуючогося на ":trigger_value"',
    'rule_trigger_not_reconciled'                         => 'Операція не узгоджена',
    'rule_trigger_not_exists'                             => 'Операція не існує',
    'rule_trigger_not_has_attachments'                    => 'Операція не має вкладень',
    'rule_trigger_not_has_any_category'                   => 'Операція не має категорії',
    'rule_trigger_not_has_any_budget'                     => 'Транзакція не має бюджету',
    'rule_trigger_not_has_any_bill'                       => 'Transaction has no subscription',
    'rule_trigger_not_has_any_tag'                        => 'Операція не має тегів',
    'rule_trigger_not_any_notes'                          => 'Операція не містить приміток',
    'rule_trigger_not_any_external_url'                   => 'Операція не має зовнішньої URL-адреси',
    'rule_trigger_not_has_no_attachments'                 => 'Операція має (деякі) вкладення',
    'rule_trigger_not_has_no_category'                    => 'Операція має (деяку) категорію',
    'rule_trigger_not_has_no_budget'                      => 'Операція має (деякий) бюджет',
    'rule_trigger_not_has_no_bill'                        => 'Transaction has a (any) subscription',
    'rule_trigger_not_has_no_tag'                         => 'Операція має (деякий) тег',
    'rule_trigger_not_no_notes'                           => 'Операція має примітки',
    'rule_trigger_not_no_external_url'                    => 'Операція має зовнішню URL-адресу',
    'rule_trigger_not_source_is_cash'                     => 'Джерелом рахунка не є готівковий рахунок',
    'rule_trigger_not_destination_is_cash'                => 'Рахунком призначення не є готівковий рахунок',
    'rule_trigger_not_account_is_cash'                    => 'Жоден рахунок не є готівковим',

    // new account balance things.
    'rule_trigger_destination_balance_gt_choice'          => 'Destination account balance is more than..',
    'rule_trigger_destination_balance_gte_choice'         => 'Destination account balance is more than or equal to..',
    'rule_trigger_destination_balance_is_choice'          => 'Destination account balance is exactly..',
    'rule_trigger_destination_balance_lt_choice'          => 'Destination account balance is less than..',
    'rule_trigger_destination_balance_lte_choice'         => 'Destination account balance is less than or equal to..',

    'rule_trigger_source_balance_gt_choice'  => 'Source account balance is more than..',
    'rule_trigger_source_balance_gte_choice' => 'Source account balance is more than or equal to..',
    'rule_trigger_source_balance_is_choice'  => 'Source account balance is exactly..',
    'rule_trigger_source_balance_lt_choice'  => 'Source account balance is less than..',
    'rule_trigger_source_balance_lte_choice' => 'Source account balance is less than or equal to..',

    'rule_trigger_destination_balance_gt'  => 'Destination account balance is more than :trigger_value',
    'rule_trigger_destination_balance_gte' => 'Destination account balance is more than or equal to :trigger_value',
    'rule_trigger_destination_balance_is'  => 'Destination account balance is exactly :trigger_value',
    'rule_trigger_destination_balance_lt'  => 'Destination account balance is less than :trigger_value',
    'rule_trigger_destination_balance_lte' => 'Destination account balance is less than or equal to :trigger_value',

    'rule_trigger_source_balance_gt'           => 'Source account balance is more than :trigger_value',
    'rule_trigger_source_balance_gte'          => 'Source account balance is more than or equal to :trigger_value',
    'rule_trigger_source_balance_is'           => 'Source account balance is exactly :trigger_value',
    'rule_trigger_source_balance_lt'           => 'Source account balance is less than :trigger_value',
    'rule_trigger_source_balance_lte'          => 'Source account balance is less than or equal to :trigger_value',

    // NOT
    'rule_trigger_not_destination_balance_gt'  => 'Destination account balance is less than or equal to :trigger_value',
    'rule_trigger_not_destination_balance_gte' => 'Destination account balance is less than :trigger_value',
    'rule_trigger_not_destination_balance_is'  => 'Destination account balance is not :trigger_value',
    'rule_trigger_not_destination_balance_lt'  => 'Destination account balance is more than or equal to :trigger_value',
    'rule_trigger_not_destination_balance_lte' => 'Destination account balance is more than :trigger_value',

    'rule_trigger_not_source_balance_gt'         => 'Source account balance is less than or equal to :trigger_value',
    'rule_trigger_not_source_balance_gte'        => 'Source account balance is less than :trigger_value',
    'rule_trigger_not_source_balance_is'         => 'Source account balance is not :trigger_value',
    'rule_trigger_not_source_balance_lt'         => 'Source account balance is more than or equal to :trigger_value',
    'rule_trigger_not_source_balance_lte'        => 'Source account balance is more than :trigger_value',


    // actions
    // set, clear, add, remove, append/prepend
    'rule_action_delete_transaction_choice'      => 'ВИДАЛИТИ операцію(!)',
    'rule_action_delete_transaction'             => 'ВИДАЛИТИ операцію(!)',
    'rule_action_set_category'                   => 'Вибрати категорію ":action_value"',
    'rule_action_clear_category'                 => 'Звільнити поле "Категорія"',
    'rule_action_set_budget'                     => 'Встановити бюджет ":action_value"',
    'rule_action_clear_budget'                   => 'Видалити бюджет',
    'rule_action_add_tag'                        => 'Додати тег ":action_value"',
    'rule_action_remove_tag'                     => 'Видалити тег ":action_value"',
    'rule_action_remove_all_tags'                => 'Видалити усі теги',
    'rule_action_set_description'                => 'Вказати примітки до ":action_value"',
    'rule_action_append_description'             => 'Додайте до опису ":action_value"',
    'rule_action_prepend_description'            => 'Почніть опис з ":action_value"',
    'rule_action_set_category_choice'            => 'Обрати категорію..',
    'rule_action_clear_category_choice'          => 'Очистити всі категорії',
    'rule_action_set_budget_choice'              => 'Встановити бюджет..',
    'rule_action_clear_budget_choice'            => 'Очистити всі бюджети',
    'rule_action_add_tag_choice'                 => 'Додати тег..',
    'rule_action_remove_tag_choice'              => 'Видалити тег..',
    'rule_action_remove_all_tags_choice'         => 'Видалити усі теги',
    'rule_action_set_description_choice'         => 'Встановити опис на..',
    'rule_action_update_piggy_choice'            => 'Додати / видалити суму транзакції в скарбничці ..',
    'rule_action_update_piggy'                   => 'Додати/видалити суму транзакції в скарбничці ":action_value"',
    'rule_action_append_description_choice'      => 'Доповнити опис з ..',
    'rule_action_prepend_description_choice'     => 'Перед описом додати з ..',
    'rule_action_set_source_account_choice'      => 'Встановити вихідний обліковий запис на ..',
    'rule_action_set_source_account'             => 'Встановити вихідний обліковий запис на :action_value',
    'rule_action_set_destination_account_choice' => 'Вибрати цільовий рахунок..',
    'rule_action_set_destination_account'        => 'Вибрати цільовий рахунок :action_value',
    'rule_action_append_notes_choice'            => 'Додайте нотатки за допомогою ..',
    'rule_action_append_notes'                   => 'Додайте нотатки за допомогою ":action_value"',
    'rule_action_prepend_notes_choice'           => 'Додайте до нотаток ..',
    'rule_action_prepend_notes'                  => 'Додайте до нотаток ":action_value"',
    'rule_action_clear_notes_choice'             => 'Видаліть будь-які примітки',
    'rule_action_clear_notes'                    => 'Видаліть будь-які примітки',
    'rule_action_set_notes_choice'               => 'Виберіть нотатки до ..',
    'rule_action_link_to_bill_choice'            => 'Link to a subscription ..',
    'rule_action_link_to_bill'                   => 'Link to subscription ":action_value"',
    'rule_action_switch_accounts_choice'         => 'Поміняти місцями рахунки джерела та призначення (лише перекази!)',
    'rule_action_switch_accounts'                => 'Поміняти місцями рахунки джерела та призначення',
    'rule_action_set_notes'                      => 'Вказати примітки до ":action_value"',
    'rule_action_convert_deposit_choice'         => 'Перетворити операцію в депозит',
    'rule_action_convert_deposit'                => 'Перетворити операцію в депозит з ":action_value"',
    'rule_action_convert_withdrawal_choice'      => 'Перетворіть операцію на зняття',
    'rule_action_convert_withdrawal'             => 'Перетворіть операцію на зняття в ":action_value"',
    'rule_action_convert_transfer_choice'        => 'Перетворення операції на переказ',
    'rule_action_convert_transfer'               => 'Перетворення операції на переказ з ":action_value"',
    'rule_action_append_descr_to_notes_choice'   => 'Додайте опис в примітках до операції',
    'rule_action_append_notes_to_descr_choice'   => 'Додайте примітки до операції в описі',
    'rule_action_move_descr_to_notes_choice'     => 'Замініть поточні примітки до операції в описі',
    'rule_action_move_notes_to_descr_choice'     => 'Замініть поточні примітки до операції в описі',
    'rule_action_append_descr_to_notes'          => 'Додайте опис в примітках',
    'rule_action_append_notes_to_descr'          => 'Додайте примітки до опису',
    'rule_action_move_descr_to_notes'            => 'Замініть примітки в описі',
    'rule_action_move_notes_to_descr'            => 'Замініть примітки в описі',
    'rule_action_set_amount_choice'              => 'Встановити суму ..',
    'rule_action_set_amount'                     => 'Set amount to ":action_value"',
    'rule_action_set_destination_to_cash_choice' => 'Налаштувати цільовий рахунок як (готівковий)',
    'rule_action_set_source_to_cash_choice'      => 'Налаштувати вихідний рахунок як (готівковий)',
    'rulegroup_for_bills_title'                  => 'Група правил для підписок',
    'rulegroup_for_bills_description'            => 'Спеціальна група правил для всіх правил, які стосуються підписок.',
    'rule_for_bill_title'                        => 'Auto-generated rule for subscription ":name"',
    'rule_for_bill_description'                  => 'This rule is auto-generated to try to match subscription ":name".',
    'create_rule_for_bill'                       => 'Create a new rule for subscription ":name"',
    'create_rule_for_bill_txt'                   => 'You have just created a new subscription called ":name", congratulations! Firefly III can automagically match new withdrawals to this subscription. For example, whenever you pay your rent, the subscription "rent" will be linked to the expense. This way, Firefly III can accurately show you which subscriptions are due and which ones aren\'t. In order to do so, a new rule must be created. Firefly III has filled in some sensible defaults for you. Please make sure these are correct. If these values are correct, Firefly III will automatically link the correct withdrawal to the correct subscription. Please check out the triggers to see if they are correct, and add some if they\'re wrong.',
    'new_rule_for_bill_title'                    => 'Rule for subscription ":name"',
    'new_rule_for_bill_description'              => 'This rule marks transactions for subscription ":name".',

    'new_rule_for_journal_title'                => 'Правило на основі операції ":description"',
    'new_rule_for_journal_description'          => 'Це правило базується на операції ":description". Він відповідатиме операціям, які абсолютно однакові.',

    // tags
    'store_new_tag'                             => 'Зберегти новий тег',
    'update_tag'                                => 'Оновити тег',
    'no_location_set'                           => 'Місцезаходження не вказано.',
    'meta_data'                                 => 'Мета-дані',
    'location'                                  => 'Місцерозташування',
    'location_first_split'                      => 'Розташування цієї операції може бути встановлене на першому розбитті цієї транзакції.',
    'without_date'                              => 'Без дати',
    'result'                                    => 'Результат',
    'sums_apply_to_range'                       => 'Усі суми стосуються вибраного діапазону',
    'mapbox_api_key'                            => 'Щоб використовувати карту, отримайте ключ API від <a href="https://www.mapbox.com/">Mapbox</a>. Відкрийте файл <code>.env</code> і додайте цей код після <code>MAPBOX_API_KEY=</code>.',
    'press_object_location'                     => 'Клацніть правою кнопкою миші або натисніть і утримуйте, щоб установити розташування об’єкта.',
    'click_tap_location'                        => 'Натисніть на карту, щоб додати місце розташування',
    'clear_location'                            => 'Видалити розташування',
    'delete_all_selected_tags'                  => 'Видалити всі вибрані теги',
    'select_tags_to_delete'                     => 'Не забудьте вибрати деякі теги.',
    'deleted_x_tags'                            => 'Видалено тег :count.|Видалено теги :count.',
    'create_rule_from_transaction'              => 'Створення правила на основі операції',
    'create_recurring_from_transaction'         => 'Створення повторюваної операції на основі операції',

    // preferences
    'test_notifications_buttons'                => 'To test your configuration, use the buttons below. Please note that the buttons have no spam control.',
    'dark_mode_option_browser'                  => 'Дозвольте браузеру вирішити',
    'dark_mode_option_light'                    => 'Завжди світла',
    'dark_mode_option_dark'                     => 'Завжди темна',
    'equal_to_language'                         => '(прирівнюється до мови)',
    'dark_mode_preference'                      => 'Темний режим',
    'dark_mode_preference_help'                 => 'Скажіть Firefly III, коли використовувати темний режим.',
    'pref_home_screen_accounts'                 => 'Головна сторінка рахунків',
    'pref_home_screen_accounts_help'            => 'Які рахунки слід відображати на головній сторінці?',
    'pref_view_range'                           => 'Діапазон перегляду',
    'pref_view_range_help'                      => 'Деякі діаграми автоматично згруповані в періоди. Ваші бюджети також будуть згруповані за періодами. Якому періоду ви віддаєте перевагу?',
    'pref_1D'                                   => 'Один день',
    'pref_1W'                                   => 'Один тиждень',
    'pref_1M'                                   => 'Один місяць',
    'pref_3M'                                   => 'Три місяці (квартал)',
    'pref_6M'                                   => 'Шість місяців',
    'pref_1Y'                                   => 'Один рік',
    'pref_last365'                              => 'Минулий рік',
    'pref_last90'                               => 'Останні 90 днів',
    'pref_last30'                               => 'Останні 30 днів',
    'pref_last7'                                => 'Останні 7 днів',
    'pref_YTD'                                  => 'Рік до дати',
    'pref_QTD'                                  => 'Квартал до дати',
    'pref_MTD'                                  => 'Місяць до дати',
    'pref_languages'                            => 'Мови',
    'pref_locale'                               => 'Налаштування локалі',
    'pref_languages_help'                       => 'Firefly III підтримує декілька мов. Якій ви віддаєте перевагу?',
    'pref_locale_help'                          => 'Firefly III дозволяє встановлювати інші локальні налаштування, такі як валюти, числа та дати. Записи в цьому списку можуть не підтримуватися вашою системою. Firefly III не має правильних параметрів дати для кожної локалі; зв\'яжіться зі мною для вдосконалення.',
    'pref_locale_no_demo'                       => 'Ця функція не працюватиме для демо-користувача.',
    'pref_convert_to_primary'                   => 'Display amounts in your primary currency',
    'pref_convert_to_primary_help'              => 'This option will make Firefly III try to display and show your primary currency in as many places as possible, converting amounts where necessary. This sacrifices accuracy for ease of use, because conversion is not always exact. Please verify that Firefly III has the necessary conversion rates on the "exchange rates"-page.',
    'pref_convert_primary_help'                 => 'Display primary amounts',
    'pref_custom_fiscal_year'                   => 'Налаштування фінансового року',
    'pref_custom_fiscal_year_label'             => 'Увiмкнено',
    'pref_custom_fiscal_year_help'              => 'У країнах, які використовують фінансовий рік, крім 1 січня до 31 грудня, ви можете увімкнути це і вказати початкові/кінцеві дні фіскального року',
    'pref_fiscal_year_start_label'              => 'Дата початку фіскального року',
    'pref_two_factor_auth'                      => 'Багатофакторна аутентифікація',
    'pref_two_factor_auth_help'                 => 'When you enable multi-factor authentication (also known as two-factor authentication), you add an extra layer of security to your account. You sign in with something you know (your password) and something you have (a verification code). Verification codes are generated by an application on your phone, such as Authy or Google Authenticator.',
    'pref_enable_two_factor_auth'               => 'Увімкнути багатофакторну автентифікацію',
    'pref_two_factor_auth_disabled'             => 'Multi-factor authentication verification code removed and disabled',
    'pref_two_factor_auth_remove_it'            => 'Не забудьте видалити обліковий запис з вашого додатка для автентифікації!',
    'pref_two_factor_auth_code'                 => 'Підтвердити код',
    'pref_two_factor_auth_code_help'            => 'Scan the QR code with an application on your phone such as Authy or Google Authenticator and enter the generated code. The QR code changes every time you visit this page. Make sure you use the most recent one.',
    'pref_two_factor_auth_reset_code'           => 'Скинути код підтвердження',
    'pref_two_factor_auth_disable_2fa'          => 'Вимкнути MFA',
    '2fa_use_secret_instead'                    => 'Якщо ви не можете відсканувати QR-код, використовуйте секретний код: <code>:secret</code>.',
    '2fa_backup_codes'                          => 'Збережіть ці резервні коди доступу на випадок втрати вашого пристрій.',
    '2fa_already_enabled'                       => 'Multi-factor authentication verification is already enabled.',
    'wrong_mfa_code'                            => 'Цей MFA код не дійсний.',
    'pref_save_settings'                        => 'Зберегти налаштування',
    'saved_preferences'                         => 'Налаштування збережено!',
    'preferences_general'                       => 'Загальні',
    'preferences_frontpage'                     => 'Головний екран',
    'preferences_security'                      => 'Безпека',
    'preferences_layout'                        => 'Зовнішній вигляд',
    'preferences_notifications'                 => 'Сповіщення',
    'pref_home_show_deposits'                   => 'Показувати надходження на головному екрані',
    'pref_home_show_deposits_info'              => 'На головному екрані тепер відображаються ваші рахунки витрат. Бажаєте також переглянути рахунки доходів?',
    'pref_home_do_show_deposits'                => 'Так, показати їх',
    'successful_count'                          => 'з яких :count успішно завершено',
    'list_page_size_title'                      => 'Розмір сторінки',
    'list_page_size_help'                       => 'Будь-який список речей (рахунки, транзакції тощо) показує максимум стільки на сторінці.',
    'list_page_size_label'                      => 'Розмір сторінки',
    'between_dates'                             => '(:start і :end)',
    'pref_optional_fields_transaction'          => 'Необов\'язкові поля для операцій',
    'pref_optional_fields_transaction_help'     => 'За замовчуванням не всі поля активні під час створення нової транзакції (щоб уникнути безладу). Нижче ви можете включити ці поля, якщо вважаєте, що вони можуть бути корисними для вас. Звичайно, будь-яке поле, що відключене, але вже заповнене, буде видимим незалежно від налаштувань.',
    'optional_tj_date_fields'                   => 'Поле дати',
    'optional_tj_other_fields'                  => 'Інші поля',
    'optional_tj_attachment_fields'             => 'Поля вкладення',
    'pref_optional_tj_interest_date'            => 'Дата нарахування відсотку',
    'pref_optional_tj_book_date'                => 'Дата обліку',
    'pref_optional_tj_process_date'             => 'Дата опрацювання',
    'pref_optional_tj_due_date'                 => 'Дата закінчення',
    'pref_optional_tj_payment_date'             => 'Дата оплати',
    'pref_optional_tj_invoice_date'             => 'Дата рахунку',
    'pref_optional_tj_internal_reference'       => 'Внутрішнє посилання',
    'pref_optional_tj_notes'                    => 'Нотатки',
    'pref_optional_tj_attachments'              => 'Вкладення',
    'pref_optional_tj_external_url'             => 'Зовнішній URL',
    'pref_optional_tj_location'                 => 'Розташування',
    'pref_optional_tj_links'                    => 'Пов\'язані транзакції',
    'optional_field_meta_dates'                 => 'Дати',
    'optional_field_meta_business'              => 'Бізнес',
    'optional_field_attachments'                => 'Вкладення',
    'optional_field_meta_data'                  => 'Додаткові метадані',
    'external_url'                              => 'Зовнішній URL',
    'pref_notification_login_failure'           => 'Помилка входу',
    'pref_notification_bill_reminder'           => 'Нагадування про термін дії підписок',
    'pref_notification_new_access_token'        => 'Попереджати, коли створюється новий токен доступу до API',
    'pref_notification_transaction_creation'    => 'Попереджати про автоматичне створення транзакції',
    'pref_notification_user_login'              => 'Попереджати, коли ви входите з нового місця',
    'pref_notification_rule_action_failures'    => 'Alert when rule actions fail to execute (not over email)',
    'pref_notification_new_password'            => 'Ваш пароль змінено',
    'pref_notification_enabled_mfa'             => 'Multi factor authentication is enabled',
    'pref_notification_disabled_mfa'            => 'Multi factor authentication is disabled',
    'pref_notification_few_left_mfa'            => 'You have just a few backup codes left',
    'pref_notification_no_left_mfa'             => 'You have no backup codes left',
    'pref_notification_many_failed_mfa'         => 'The multi factor authentication check keeps failing',
    'pref_notification_new_backup_codes'        => 'New backup codes have been generated',
    'pref_notifications'                        => 'Сповіщення',
    'pref_notifications_help'                   => 'Укажіть, чи хотіли б ви отримувати ці сповіщення. Деякі сповіщення можуть містити конфіденційну фінансову інформацію.',
    'pref_notifications_settings'               => 'Notifications settings',
    'pref_notifications_settings_help'          => 'Use these settings to configure your notification channels. Please note that notifications will be sent to ALL channels. Please save your settings FIRST.',
    'slack_url_label'                           => 'URL-адреса Slack "вхідного вебхуку"',
    'discord_url_label'                         => 'URL-адреса вебхуку Discord',

    // exchange rates
    'menu_exchange_rates_index'                 => 'Курси валют',
    'header_exchange_rates'                     => 'Курси валют',
    'exchange_rates_intro'                      => 'Firefly III supports downloading and using exchange rates. Read more about this in <a href="https://docs.firefly-iii.org/explanation/financial-concepts/exchange-rates/">the documentation</a>.',
    'exchange_rates_from_to'                    => 'Between {from} and {to} (and the other way around)',
    'header_exchange_rates_rates'               => 'Курси валют',
    'exchange_rates_intro_rates'                => 'Firefly III uses the following exchange rates. The inverse is automatically calculated when it is not provided. If no exchange rate exists for the date of the transaction, Firefly III will go back in time to find one. If none are present, the rate "1" will be used.',
    'header_exchange_rates_table'               => 'Table with exchange rates',
    'help_rate_form'                            => 'On this day, how many {to} will you get for one {from}?',
    'save_new_rate'                             => 'Save new rate',
    'add_new_rate'                              => 'Add a new exchange rate',
    'not_enough_currencies'                     => 'Недостатньо валют',
    'not_enough_currencies_enabled'             => 'If you have just one currency enabled, there is no need to add exchange rates.',

    // Financial administrations
    'administration_index'                      => 'Фінансове управління',
    'administrations_breadcrumb'                => 'Фінансові адміністрації',
    'administrations_page_title'                => 'Фінансові адміністрації',
    'administrations_index_menu'                => 'Фінансові адміністрації',
    'administrations_page_sub_title'            => 'Огляд',
    'create_administration'                     => 'Create new administration',
    'administration_owner'                      => 'Administration owner: {{email}}',
    'administration_you'                        => 'Ваша роль: {{role}}',
    'other_users_in_admin'                      => 'Other users in this administration',
    'administrations_create_breadcrumb'         => 'Create new financial administration',
    'administrations_page_create_sub_title'     => 'Create new financial administration',
    'basic_administration_information'          => 'Basic administration information',
    'new_administration_created'                => 'New financial administration "{{title}}" has been created',
    'edit_administration_breadcrumb'            => 'Edit financial administration ":title"',
    'administrations_page_edit_sub_title'       => 'Edit financial administration ":title"',
    'administrations_page_edit_sub_title_js'    => 'Edit financial administration "{title}"',
    'temp_administrations_introduction'         => 'Firefly III will soon get the ability to manage multiple financial administrations. Right now, you only have the one. You can set the title of this administration and its primary currency. This replaces the previous setting where you would set your "default currency". This setting is now tied to the financial administration and can be different per administration.',
    'temp_administrations_introduction_edit'    => 'Currently, you can only set the "primary currency" of the default financial administration. This replaces the "default currency" setting. This setting is now tied to the financial administration and can be different per administration.',
    'administration_currency_form_help'         => 'It may take a long time for the page to load if you change the primary currency because transaction may need to be converted to your (new) primary currency.',
    'flash_administration_updated'              => 'Administration ":title" has been updated',
    'flash_administration_created'              => 'Administration ":title" has been created',
    'flash_administration_deleted'              => 'Administration ":title" has been deleted',

    // roles
    'administration_role_owner'                 => 'Власник',
    'administration_role_ro'                    => 'Лише перегляд',
    'administration_role_mng_trx'               => 'Керування транзакціями',
    'administration_role_mng_meta'              => 'Керування класифікацією і метаданими',
    'administration_role_mng_budgets'           => 'Manage budgets',
    'administration_role_mng_piggies'           => 'Manage piggy banks',
    'administration_role_mng_subscriptions'     => 'Manage subscriptions',
    'administration_role_mng_rules'             => 'Manage rules',
    'administration_role_mng_recurring'         => 'Manage recurring transactions',
    'administration_role_mng_webhooks'          => 'Manage webhooks',
    'administration_role_mng_currencies'        => 'Manage currencies',
    'administration_role_view_reports'          => 'Перегляд звітів',
    'administration_role_full'                  => 'Повний доступ',

    // mfa
    'enable_mfa'                                => 'Увімкнути багатофакторну автентифікацію',
    'mfa_index_title'                           => 'Багатофакторна автентифікація',
    'mfa_index_intro'                           => 'Firefly III supports multi-factor authentication (MFA). You can enable MFA for your account to add an extra layer of security. Applications like Authy, Google Authenticator and FreeOTP can be used to generate the codes you need to log in. Security keys are not supported by Firefly III but you can use a security key as a storage device for your MFA secret.',
    'mfa_index_enabled'                         => 'Multi-factor authentication is enabled for your account.',
    'mfa_index_disabled'                        => 'Multi-factor authentication is not enabled for your account.',
    'mfa_index_owner'                           => 'The owner of this instance will always be able to disable multi-factor authentication for your account.',
    'current_password_confirm_mfa'              => 'Введіть поточний пароль',
    'mfa_warning_code_changes'                  => 'You may get a MFA dialog after you entered your password and a MFA code. In that case, please wait for your application to generate a new MFA code, and do not recycle the one you just used.',
    'mfa_already_disabled'                      => 'Multi-factor authentication is not enabled, so you cannot disable it.',
    'disable_mfa_page'                          => 'Disable multi-factor authentication',
    'disable_mfa_intro'                         => 'You can disable multi-factor authentication. To do so, please enter your password and a multi-factor authentication code. If you want to disable multi-factor authentication because you have lost access to your code generator, <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">please refer to the documentation instead</a>.',
    'pref_disable_mfa'                          => 'Disable multi-factor authentication',
    'mfa_not_enabled'                           => 'Multi-factor authentication is not enabled.',
    'mfa_backup_codes_intro'                    => 'Firefly III can generate backup codes for you. These codes can be used to log in when you cannot use your code generator. You can generate a new set of codes at any time. If you generate a new set, the old set will be invalidated.',
    'mfa_backup_codes_quick'                    => 'If you are very fast coming from the setup page of multi-factor authentication, your app may not have generated a new code yet. Please know that MFA codes can only be used once. Make sure you use a different code from the previous one.',
    'mfa_backup_codes_title'                    => 'Multi-factor authentication backup codes',
    'mfa_backup_codes_post_title'               => 'Multi-factor authentication backup codes',

    // profile:
    'manage_mfa_settings'                       => 'Manage multi-factor authentication settings',
    'purge_data_title'                          => 'Очистити дані з Firefly III',
    'purge_data_expl'                           => '«Очищення» означає «видалення того, що вже видалено». За звичайних обставин Firefly III нічого не видаляє остаточно. Це просто приховує це. Кнопка нижче видаляє всі ці раніше "видалені" записи НАЗАВЖДИ.',
    'delete_stuff_header'                       => 'Видалити та очистити дані',
    'purge_all_data'                            => 'Знищити всі видалені записи',
    'purge_data'                                => 'Очистити дані',
    'purged_all_records'                        => 'Всі видалені записи були очищені.',
    'delete_data_title'                         => 'Видалити дані з Firefly III',
    'permanent_delete_stuff'                    => 'Ви можете видалити вміст з Firefly III. Використання кнопок нижче означає, що ваші елементи будуть видалені з поля зору та приховані. Для цього немає кнопки скасування, але елементи можуть залишатися в базі даних, де ви можете їх зберегти, якщо це необхідно.',
    'other_sessions_logged_out'                 => 'Усі інші ваші сеанси вийшли з системи.',
    'delete_unused_accounts'                    => 'Видалення невикористаних облікових записів очистить ваші списки автозаповнення.',
    'delete_all_unused_accounts'                => 'Видалити невикористані облікові записи',
    'deleted_all_unused_accounts'               => 'Усі невикористовувані облікові записи видаляються',
    'delete_all_budgets'                        => 'Видалити УСІ свої бюджети',
    'delete_all_categories'                     => 'Видалити ВСІ ваші категорії',
    'delete_all_tags'                           => 'Видалити УСІ свої теги',
    'delete_all_bills'                          => 'Delete ALL your subscriptions',
    'delete_all_piggy_banks'                    => 'Видалити УСІ свої скарбнички',
    'delete_all_rules'                          => 'Видалити УСІ свої правила',
    'delete_all_recurring'                      => 'Видалити УСІ повторювані операції',
    'delete_all_object_groups'                  => 'Видалити УСІ ваші групи',
    'delete_all_accounts'                       => 'Видалити ВСІ свої рахунки',
    'delete_all_asset_accounts'                 => 'Видалити УСІ свої рахунки активів',
    'delete_all_expense_accounts'               => 'Видалити УСІ свої рахунки витрат',
    'delete_all_revenue_accounts'               => 'Видалити УСІ свої рахунки доходів',
    'delete_all_liabilities'                    => 'Видалити УСІ свої зобов\'язання',
    'delete_all_transactions'                   => 'Видалити ВСІ операції',
    'delete_all_withdrawals'                    => 'Видалити УСІ свої зняття',
    'delete_all_deposits'                       => 'Видалити УСІ свої депозити',
    'delete_all_transfers'                      => 'Видалити ВСІ перекази',
    'also_delete_transactions'                  => 'Видалення рахунків також призведе до видалення ВСІХ пов’язаних зняття коштів, депозитів і переказів!',
    'deleted_all_budgets'                       => 'Усі бюджети видалено',
    'deleted_all_categories'                    => 'Всі категорії видалено',
    'deleted_all_tags'                          => 'Усі теги видалено',
    'deleted_all_bills'                         => 'All subscriptions have been deleted',
    'deleted_all_piggy_banks'                   => 'Всі скарбнички видалені',
    'deleted_all_rules'                         => 'Усі правила та групи правил видалено',
    'deleted_all_object_groups'                 => 'Усі групи видалено',
    'deleted_all_accounts'                      => 'Усі рахунки видалено',
    'deleted_all_asset_accounts'                => 'Усі рахунки активів видалено',
    'deleted_all_expense_accounts'              => 'Усі рахунки витрат видалено',
    'deleted_all_revenue_accounts'              => 'Усі прибуткові рахунки видалено',
    'deleted_all_liabilities'                   => 'Усі зобов’язання видалено',
    'deleted_all_transactions'                  => 'Усі операції видалено',
    'deleted_all_withdrawals'                   => 'Усі зняття було видалено',
    'deleted_all_deposits'                      => 'Усі депозити видалено',
    'deleted_all_transfers'                     => 'Усі перекази видалено',
    'deleted_all_recurring'                     => 'Усі повторювані транзакції видалено',
    'change_your_password'                      => 'Змінити пароль',
    'delete_account'                            => 'Видалити обліковий запис',
    'current_password'                          => 'Поточний пароль',
    'new_password'                              => 'Новий пароль',
    'new_password_again'                        => 'Новий пароль (іще раз)',
    'delete_your_account'                       => 'Видалити ваш обліковий запис',
    'delete_your_account_help'                  => 'Видалення вашого облікового запису також призведе до видалення всіх облікових записів, транзакцій, <em>всього</em>, що ви зберігали у Firefly III. Все буде втрачено.',
    'delete_your_account_password'              => 'Введіть свій пароль, щоб продовжити.',
    'password'                                  => 'Пароль',
    'are_you_sure'                              => 'Ви впевнені? Скасовувати видалення не можливо.',
    'are_you_sure_confirm'                      => 'Ви впевнені?',
    'delete_account_button'                     => 'Видалити ваш обліковий запис',
    'invalid_current_password'                  => 'Невірний поточний пароль!',
    'password_changed'                          => 'Пароль змінено!',
    'should_change'                             => 'Ідея в тому, щоб змінити пароль.',
    'invalid_password'                          => 'Невірний пароль!',
    'what_is_pw_security'                       => 'Що таке "перевірити надійність паролю"?',
    'secure_pw_title'                           => 'Як вибрати безпечний пароль',
    'forgot_password_response'                  => 'Дякуємо. Якщо обліковий запис існує з цією електронною адресою, ви знайдете інструкції у вашій поштовій скриньці.',
    'secure_pw_history'                         => 'Не проходить і тижня, щоб ви не прочитали в новинах про те, що сервіси втрачають паролі своїх користувачів. Хакери та злодії використовують ці паролі, щоб спробувати викрасти вашу особисту інформацію. Ця інформація є цінною.',
    'secure_pw_ff'                              => 'Ви використовуєте один і той самий пароль в Інтернеті? Якщо один сайт втратить ваш пароль, хакери отримають доступ до всіх ваших даних. Firefly III покладається на те, що ви виберете надійний і унікальний пароль для захисту своїх фінансових записів.',
    'secure_pw_check_box'                       => 'Щоб допомогти вам у цьому, Firefly III може перевірити, чи пароль, який ви хочете використати, був викрадений у минулому. Якщо це так, Firefly III радить вам НЕ використовувати цей пароль.',
    'secure_pw_working_title'                   => 'Як це працює?',
    'secure_pw_working'                         => 'Якщо поставити прапорець, Firefly III надішле перші п’ять символів хешу SHA1 вашого пароля на <a href="https://www.troyhunt.com/introducing-306-million-freely-downloadable-pwned-passwords/ ">веб-сайт Troy Hunt</a>, щоб перевірити, чи є він у списку. Це дозволить вам не використовувати небезпечні паролі, як рекомендовано в останній <a href="https://pages.nist.gov/800-63-3/sp800-63b.html">спеціальній публікації NIST</a> на цю тему.',
    'secure_pw_should'                          => 'Чи варто поставити прапорець?',
    'secure_pw_long_password'                   => 'Так. Завжди перевіряйте надійність свого пароля.',
    'command_line_token'                        => 'Токен командного рядка',
    'explain_command_line_token'                => 'Цей токен потрібен для виконання параметрів командного рядка, наприклад експорту даних. Без нього ця чутлива команда не працюватиме. Не повідомляйте свій токен командного рядка. Ніхто не буде просити у вас цей токен, навіть я. Якщо ви боїтеся втратити його, або коли Ви параноїдні, відновіть цей токен за допомогою кнопки.',
    'regenerate_command_line_token'             => 'Відновити токен командного рядка',
    'token_regenerated'                         => 'Було створено новий токен командного рядка',
    'change_your_email'                         => 'Змінити електронну адресу',
    'email_verification'                        => 'An email message will be sent to your old AND new email address. For security purposes, you will not be able to login until you verify your new email address. If you are unsure if your Firefly III installation is capable of sending email, please do not use this feature. If you are an administrator, you can test this in the <a href="settings">settings</a>.',
    'email_changed_logout'                      => 'Доки ви не підтвердите свою електронну адресу, ви не зможете увійти.',
    'login_with_new_email'                      => 'Тепер ви можете увійти за допомогою нової електронної адреси.',
    'login_with_old_email'                      => 'Тепер ви можете знову увійти зі своєю старою електронною адресою.',
    'login_provider_local_only'                 => 'Ця дія недоступна під час автентифікації через ":login_provider".',
    'external_user_mgt_disabled'                => 'Ця дія недоступна, якщо Firefly III не відповідає за керування користувачами чи обробку автентифікації.',
    'external_auth_disabled'                    => 'Ця дія недоступна, якщо Firefly III не відповідає за обробку автентифікації.',
    'delete_local_info_only'                    => "Оскільки Firefly III не відповідає за керування користувачами чи обробку автентифікації, ця функція видалятиме лише локальну інформацію Firefly III.",
    'oauth'                                     => 'OAuth',
    'profile_oauth_clients'                     => 'Клієнти OAuth',
    'profile_oauth_no_clients'                  => 'Ви не створили жодних клієнтів OAuth.',
    'profile_oauth_clients_external_auth'       => 'Якщо ви використовуєте стороннього постачальника автентифікації, наприклад Authelia, клієнти OAuth не працюватимуть. Ви можете використовувати лише особисті токени доступу.',
    'profile_oauth_clients_header'              => 'Клієнти',
    'profile_oauth_client_id'                   => 'ID клієнта',
    'profile_oauth_client_name'                 => 'Ім\'я',
    'profile_oauth_client_secret'               => 'Секретний ключ',
    'profile_oauth_create_new_client'           => 'Створити нового клієнта',
    'profile_oauth_create_client'               => 'Створити клієнта',
    'profile_oauth_edit_client'                 => 'Редагувати клієнта',
    'profile_oauth_name_help'                   => 'Щось, що ваші користувачі впізнають і довірятимуть.',
    'profile_oauth_redirect_url'                => 'URL-адреса перенаправлення',
    'profile_oauth_redirect_url_help'           => 'Зовнішній URL для авторизації додатка.',
    'profile_authorized_apps'                   => 'Авторизовані додатки',
    'profile_authorized_clients'                => 'Авторизовані клієнти',
    'profile_scopes'                            => 'Області застосування',
    'profile_revoke'                            => 'Відкликати',
    'profile_oauth_client_secret_title'         => 'Секретний ключ клієнта',
    'profile_oauth_client_secret_expl'          => 'Ось новий секретний ключ клієнта. Це єдиний раз, коли він буде показаний, тому не втрачайте його! Тепер ви можете використовувати цей секретний ключ для надсилання запитів API.',
    'profile_personal_access_tokens'            => 'Токени особистого доступу',
    'profile_personal_access_token'             => 'Токен персонального доступу',
    'profile_oauth_confidential'                => 'Конфіденційно',
    'profile_oauth_confidential_help'           => 'Require the client to authenticate with a secret. Confidential clients can hold credentials in a secure way without exposing them to unauthorized parties. Public applications, such as native desktop or JavaScript SPA applications, are unable to hold secrets securely.',
    'profile_personal_access_token_explanation' => 'Ось ваш новий особистий токен. Це єдиний раз, коли він буде показаний, тому не втрачайте його! Тепер ви можете використовувати цей токен для надсилання запитів API.',
    'profile_no_personal_access_token'          => 'Ви не створили особистих токенів доступу.',
    'profile_create_new_token'                  => 'Створити новий токен',
    'profile_create_token'                      => 'Створити токен',
    'profile_create'                            => 'Створити',
    'profile_save_changes'                      => 'Зберегти зміни',
    'profile_whoops'                            => 'Лишенько!',
    'profile_something_wrong'                   => 'Щось пішло не так!',
    'profile_try_again'                         => 'Щось пішло не так. Будь ласка, спробуйте ще раз.',
    'amounts'                                   => 'Суми',
    'multi_account_warning_unknown'             => 'Залежно від типу транзакції, яку ви створюєте, вихідним і/або цільовим рахунком наступних поділів може бути рахунок, визначений у першому поділі транзакції.',
    'multi_account_warning_withdrawal'          => 'Зауважте, що вихідним рахунком для наступних розподілів буде встановлено рахунок, визначений у першому розподілі виплат.',
    'multi_account_warning_deposit'             => 'Зауважте, що цільовим рахунком для наступних розподілів буде встановлено рахунок, визначений у першому розподілі депозиту.',
    'multi_account_warning_transfer'            => 'Зауважте, що облікові записи джерела та призначення наступних поділів буде встановлено на рахунок, визначений у першому поділі переказу.',


    // export data:
    'export_data_title'                         => 'Експорт даних з Firefly III',
    'export_data_menu'                          => 'Експорт даних',
    'export_data_bc'                            => 'Експорт даних з Firefly III',
    'export_data_main_title'                    => 'Експорт даних з Firefly III',
    'export_data_expl'                          => 'Це посилання дозволяє експортувати всі транзакції та метадані з Firefly III. Додаткову інформацію про процес можна знайти в довідці (значок (?) у верхньому правому куті).',
    'export_data_all_transactions'              => 'Експорт всіх транзакцій',
    'export_data_advanced_expl'                 => 'Якщо вам потрібен розширений або спеціальний тип експорту, прочитайте довідку про використання консольної команди <code>php artisan help firefly-iii:export-data</code>.',

    // attachments
    'nr_of_attachments'                         => 'Один вкладений файл |:count вкладених файлів',
    'attachments'                               => 'Вкладення',
    'edit_attachment'                           => 'Редагувати вкладення ":name"',
    'update_attachment'                         => 'Оновлення вкладення',
    'delete_attachment'                         => 'Видалити вкладення":name"',
    'attachment_deleted'                        => 'Видалено вкладення":name"',
    'liabilities_deleted'                       => 'Видалено зобов\'язання ":name"',
    'attachment_updated'                        => 'Оновлено вкладення":name"',
    'upload_max_file_size'                      => 'Максимальний розмір файлу: :size',
    'list_all_attachments'                      => 'Список всіх вкладень',

    // transaction index
    'is_reconciled_fields_dropped'              => 'Because this transaction is reconciled, you will not be able to update the accounts, nor the amount(s) unless you remove the reconciliation flag.',
    'is_reconciled'                             => 'Is reconciled',
    'title_expenses'                            => 'Витрати',
    'title_withdrawal'                          => 'Витрати',
    'title_revenue'                             => 'Дохід / прихід',
    'title_deposit'                             => 'Дохід / прихід',
    'title_transfer'                            => 'Переказ',
    'title_transfers'                           => 'Перекази',
    'submission_options'                        => 'Параметри сабміту',
    'apply_rules_checkbox'                      => 'Застосувати правила',
    'fire_webhooks_checkbox'                    => 'Пожежні вебгаки',
    'select_source_account'                     => 'Будь ласка, виберіть або введіть дійсне ім\'я вихідного облікового запису',
    'select_dest_account'                       => 'Будь ласка, виберіть або введіть дійсне ім\'я облікового запису призначення',

    // convert stuff:
    'convert_is_already_type_Withdrawal'        => 'Ця транзакція вже є витратою',
    'convert_is_already_type_Deposit'           => 'Ця транзакція вже є надходженням',
    'convert_is_already_type_Transfer'          => 'Ця транзакція вже є переказом',
    'convert_to_Withdrawal'                     => 'Перетворити ":description" на витрату',
    'convert_to_Deposit'                        => 'Перетворити ":description" у надходження',
    'convert_to_Transfer'                       => 'Перетворити ":description" у переказ',
    'convert_options_WithdrawalDeposit'         => 'Перетворити витрату у надходження',
    'convert_options_WithdrawalTransfer'        => 'Перетворити витрату у переказ',
    'convert_options_DepositTransfer'           => 'Перетворити надходження у переказ',
    'convert_options_DepositWithdrawal'         => 'Перетворити надходження у витрату',
    'convert_options_TransferWithdrawal'        => 'Перетворити переказ у витрату',
    'convert_options_TransferDeposit'           => 'Перетворити цй переказ у надходження',
    'convert_Withdrawal_to_deposit'             => 'Перетворити цю витрату у надходження',
    'convert_Withdrawal_to_transfer'            => 'Перетворити цю витрату у переказ',
    'convert_Deposit_to_withdrawal'             => 'Перетворити цей депозит на витрату',
    'convert_Deposit_to_transfer'               => 'Перетворити цей дохід у переказ',
    'convert_Transfer_to_deposit'               => 'Перетворити цй переказ у надходження',
    'convert_Transfer_to_withdrawal'            => 'Перетворити цй переказ у витрату',
    'convert_please_set_revenue_source'         => 'Будь ласка, виберітьджерело, з якого надійдуть гроші.',
    'convert_please_set_asset_destination'      => 'Будь ласка, оберіть рахунок, куди прямують гроші.',
    'convert_please_set_expense_destination'    => 'Будь ласка, оберіть рахунок, куди будуть витрачені гроші.',
    'convert_please_set_asset_source'           => 'Будь ласка, виберіть на якому рахунку будуть витрачені гроші.',
    'convert_expl_w_d'                          => 'При конвертації з виведення на депозит, гроші будуть виплачені на вказаний рахунок призначення, а не на виведенні коштів. При конвертації з виведення на депозит, гроші будуть виплачені на вказані рахунки призначення, а не на виведені з них.',
    'convert_expl_w_t'                          => 'Під час перетворення виведення на переказ, гроші будуть перераховані з вихідного рахунку на інші активи або рахунок з відповідальності, а не витрачені на оригінальний рахунок витрат. Під час перетворення виведення на переказ, гроші будуть перераховані з вихідних рахунків на інші активи чи кредитні рахунки, а не витрачаються на оригінальні рахунки витрат.',
    'convert_expl_d_w'                          => 'При перетворенні депозиту на зняття, гроші будуть зняті з відображуваного вихідного рахунку замість того, щоб поповнюватись в нього. При перетворенні депозиту на зняття, гроші будуть зняті з відображуваних вихідних рахунків, а не з їх депозитів.',
    'convert_expl_d_t'                          => 'Коли ви перетворюєте депозит в переказ, гроші будуть поповнені в зазначений цільовий рахунок з будь-якого вашого активу або рахунку відповідальності. Коли ви перетворюєте депозит в переказ, гроші будуть поповнені в перераховані кінцеві рахунки з будь-якого з ваших активів або рахунків за відповідальність.',
    'convert_expl_t_w'                          => 'Коли ви конвертуєте кошти в вихідний, гроші будуть витрачені на цільовий рахунок, замість того, щоб перерахувати таки. Коли ви конвертуєте переказ в кошти, гроші будуть витрачені на встановлені вами рахунки призначення замість переказу.',
    'convert_expl_t_d'                          => 'Коли ви перетворюєте на депозит, гроші будуть вкладені в цільовий рахунок ви бачите тут, замість переказу в нього. Коли ви перетворюєте на депозит, гроші будуть вводити в цільові рахунки, які ви бачите тут, замість того, щоб переказувати їх.',
    'convert_select_sources'                    => 'Для завершення конверсії, будь ласка, встановіть новий вихідний рахунок нижче.|Для завершення версії, будь ласка, встановіть нові вихідні облікові записи.',
    'convert_select_destinations'               => 'Для завершення конверсії, будь ласка, оберіть новий рахунок призначення нижче.|Для завершення конвертації виберіть нові кінцеві облікові записи нижче.',
    'converted_to_Withdrawal'                   => 'Операція була перетворена на виведення коштів',
    'converted_to_Deposit'                      => 'Операція була перетворена на депозит',
    'converted_to_Transfer'                     => 'Транзакцію перетворено на переказ',
    'invalid_convert_selection'                 => 'Вибраний вами рахунок використовується в цій операції, або не існує.',
    'source_or_dest_invalid'                    => 'Неможливо знайти коректні деталі транзакції. Перетворення неможливе.',
    'convert_to_withdrawal'                     => 'Перетворити на витрату',
    'convert_to_deposit'                        => 'Перетворити у надходження',
    'convert_to_transfer'                       => 'Перетворити на переказ',

    // create new stuff:
    'create_new_withdrawal'                     => 'Створити нову витрату',
    'create_new_deposit'                        => 'Створити новий дохід',
    'create_new_transfer'                       => 'Створити новий переказ',
    'create_new_asset'                          => 'Зберегти новий рахунок активів',
    'create_new_liabilities'                    => 'Створити нове зобов\'язання',
    'create_new_expense'                        => 'Створити новий рахунок витрат',
    'create_new_revenue'                        => 'Створити нове джерело доходу',
    'create_new_piggy_bank'                     => 'Створити нову скарбничку',
    'create_new_bill'                           => 'Створити нову підписку',
    'create_new_subscription'                   => 'Створити нову підписку',
    'create_new_rule'                           => 'Створити нове правило',

    // currencies:
    'create_currency'                           => 'Створити нову валюту',
    'store_currency'                            => 'Зберегти нову валюту',
    'update_currency'                           => 'Оновити валюту',
    'new_default_currency'                      => '":name" тепер є валютою за замовчуванням.',
    'default_currency_failed'                   => 'Не вдалося створити валюту за замовчуванням ":name. Будь ласка, перевірте логи.',
    'cannot_delete_currency'                    => 'Неможливо видалити валюту :name, оскільки вона використовується.',
    'cannot_delete_fallback_currency'           => ':name є системною резервною валютою і не може бути видалена.',
    'cannot_disable_currency_journals'          => 'Не вдалося вимкнути :name , тому що операції все ще використовують його.',
    'cannot_disable_currency_last_left'         => 'Не можна вимкнути :name , оскільки вона є останньою ввімкненою валютою.',
    'cannot_disable_currency_account_meta'      => 'Не вдається відключити :name , тому що він використовується в рахунках активів.',
    'cannot_disable_currency_bills'             => 'Cannot disable :name because it is used in subscriptions.',
    'cannot_disable_currency_recurring'         => 'Не вдається вимкнути :name , оскільки він використовується в повторюваних операціях.',
    'cannot_disable_currency_available_budgets' => 'Не вдалося відключити :name , тому що він використовується в доступних бюджетах.',
    'cannot_disable_currency_budget_limits'     => 'Не вдалося вимкнути :name , тому що він використовується в бюджетних обмеженнях.',
    'cannot_disable_currency_current_default'   => 'Не вдалося вимкнути :name , оскільки це поточна валюта за замовчуванням.',
    'cannot_disable_currency_system_fallback'   => 'Не можна вимкнути :name , оскільки це валюта за замовчуванням.',
    'disable_EUR_side_effects'                  => 'Євро є резервною валютою системи для надзвичайних ситуацій. Його вимкнення може призвести до небажаних побічних ефектів і призвести до втрати гарантії.',
    'deleted_currency'                          => 'Валюта :name видалена',
    'created_currency'                          => 'Валюта :name створена',
    'could_not_store_currency'                  => 'Не вдалося зберегти нову валюту.',
    'updated_currency'                          => 'Валюта :name оновлена',
    'ask_site_owner'                            => 'Будь ласка, попросіть :owner додати, видалити або відредагувати валюти.',
    'currencies_intro'                          => 'Firefly III підтримує різні валюти, які ви можете встановити та ввімкнути тут.',
    'currencies_switch_default'                 => 'You can switch the primary currency for your current administration on the "Financial administrations"-page.',
    'make_default_currency'                     => 'Зробити основним',
    'default_currency'                          => 'за замовчуванням',
    'primary_currency_button'                   => 'primary',
    'currency_is_disabled'                      => 'Вимкнено',
    'enable_currency'                           => 'Увімкнути',
    'disable_currency'                          => 'Вимкнути',
    'currencies_default_disabled'               => 'Більшість із цих валют вимкнено за замовчуванням. Щоб використовувати їх, ви повинні спочатку їх увімкнути.',
    'currency_is_now_enabled'                   => 'Валюту ":name" увімкнено',
    'could_not_enable_currency'                 => 'Не вдалося включити валюту ":name". Будь ласка, перегляньте журнали.',
    'currency_is_now_disabled'                  => 'Валюту ":name" вимкнено',
    'could_not_disable_currency'                => 'Не вдалося відключити валюту ":name". Можливо, вона все ще використовується?',

    // forms:
    'mandatoryFields'                           => 'Обов\'язкові поля',
    'optionalFields'                            => 'Необов\'язкові поля',
    'options'                                   => 'Опції',

    // budgets:
    'daily_budgets'                             => 'Щоденні бюджети',
    'weekly_budgets'                            => 'Тижневі бюджети',
    'monthly_budgets'                           => 'Місячні бюджети',
    'quarterly_budgets'                         => 'Квартальні бюджети',
    'half_year_budgets'                         => 'Піврічні бюджети',
    'yearly_budgets'                            => 'Річні бюджети',
    'other_budgets'                             => 'Спеціальні тимчасові бюджети',
    'budget_limit_not_in_range'                 => 'Ця сума застосовується від :start до :end:',
    'total_available_budget'                    => 'Загальний бюджет (між :start і :end)',
    'total_available_budget_in_currency'        => 'Загальний обсяг бюджету в :currency',
    'see_below'                                 => 'дивіться нижче',
    'create_new_budget'                         => 'Створити новий бюджет',
    'store_new_budget'                          => 'Зберегти новий бюджет',
    'stored_new_budget'                         => 'Збережено новий бюджет ":name"',
    'available_between'                         => 'Доступно між :start і :end',
    'transactionsWithoutBudget'                 => 'Витрати без бюджету',
    'transactions_no_budget'                    => 'Витрати без бюджету між :start і :end',
    'spent_between'                             => 'Уже витрачено між :start і :end',
    'spent_between_left'                        => 'Витрачено :spent між :start та :end, залишивши :left.',
    'set_available_amount'                      => 'Встановити доступну суму',
    'update_available_amount'                   => 'Оновити доступну суму',
    'ab_basic_modal_explain'                    => 'Скористайтеся цією формою, щоб вказати, скільки ви очікуєте від бюджету (загалом, у :currency) у вказаний період.',
    'createBudget'                              => 'Новий бюджет',
    'invalid_currency'                          => 'Ця валюта недійсна',
    'invalid_amount'                            => 'Будь ласка, введіть суму',
    'set_ab'                                    => 'Доступна сума бюджету була встановлена',
    'updated_ab'                                => 'Доступну суму бюджету оновлено',
    'deleted_ab'                                => 'Доступну суму бюджету видалено',
    'deleted_bl'                                => 'Зазначену в бюджеті суму видалено',
    'alt_currency_ab_create'                    => 'Встановіть доступний бюджет в іншій валюті',
    'bl_create_btn'                             => 'Вказати бюджет в іншій валюті',
    'inactiveBudgets'                           => 'Неактивні бюджети',
    'without_budget_between'                    => 'Транзакції без бюджету між :start і :end',
    'delete_budget'                             => 'Видалити бюджет ":name"',
    'deleted_budget'                            => 'Видалений бюджет ":name"',
    'edit_budget'                               => 'Редагувати бюджет ":name"',
    'updated_budget'                            => 'Оновлений бюджет ":name"',
    'update_amount'                             => 'Оновити суму',
    'update_budget'                             => 'Оновити бюджет',
    'update_budget_amount_range'                => 'Оновлення (очікувало) доступна сума між :start і :end',
    'set_budget_limit_title'                    => 'Встановіть бюджетну суму для бюджету :budget між :start і :end',
    'set_budget_limit'                          => 'Встановити суму в бюджеті',
    'budget_period_navigator'                   => 'Огляд періоду',
    'info_on_available_amount'                  => 'Що я маю в наявності?',
    'available_amount_indication'               => 'Використовуйте ці суми, щоб отримати вказівки на ваш загальний бюджет.',
    'suggested'                                 => 'Запропоновано',
    'average_between'                           => 'В середньому між :start і :end',
    'transferred_in'                            => 'Переведено (у)',
    'transferred_away'                          => 'Передається (геть)',
    'auto_budget_none'                          => 'Без авто-бюджету',
    'auto_budget_reset'                         => 'Встановити фіксовану суму кожного періоду',
    'auto_budget_rollover'                      => 'Додати суму за кожен період',
    'auto_budget_adjusted'                      => 'Додавати суму кожного періоду та коригувати для перевитрат',
    'auto_budget_period_daily'                  => 'Щоденно',
    'auto_budget_period_weekly'                 => 'Щотижня',
    'auto_budget_period_monthly'                => 'Щомісячно',
    'auto_budget_period_quarterly'              => 'Щоквартально',
    'auto_budget_period_half_year'              => 'Щопівроку',
    'auto_budget_period_yearly'                 => 'Щорічно',
    'auto_budget_help'                          => 'Ви можете прочитати більше про цю функцію в довідці. Натисніть праворуч (?).',
    'auto_budget_reset_icon'                    => 'Цей бюджет буде періодично встановлено',
    'auto_budget_rollover_icon'                 => 'Сума бюджету буде періодично збільшуватися',
    'auto_budget_adjusted_icon'                 => 'Сума бюджету буде періодично збільшуватися та виправляти перевитрати',
    'remove_budgeted_amount'                    => 'Видалити бюджетну суму в :currency',

    // bills:
    'left_to_pay_active_bills'                  => 'active, expected and not yet paid subscriptions',
    'left_to_pay_lc'                            => 'left to pay',
    'less_than_expected'                        => 'less than expected',
    'more_than_expected'                        => 'more than expected',
    'skip_help_text'                            => 'Use the skip field to create bi-monthly (skip = 1) or other custom intervals.',
    'subscription'                              => 'Підписка',
    'not_expected_period'                       => 'Неочікуваний період',
    'subscriptions_in_group'                    => 'Subscriptions in group "{{title}}"',
    'subscr_expected_x_times'                   => 'Expect to pay {{amount}} {{times}} times this period',
    'not_or_not_yet'                            => 'Ні (поки що)',
    'visit_bill'                                => 'Visit subscription ":name" at Firefly III',
    'visit_bills'                               => 'Visit subscriptions at Firefly III',
    'match_between_amounts'                     => 'Subscription matches transactions between :low and :high.',
    'running_again_loss'                        => 'Previously linked transactions to this subscription may lose their connection, if they (no longer) match the rule(s).',
    'bill_related_rules'                        => 'Rules related to this subscription',
    'repeats'                                   => 'Повтор',
    'bill_end_date_help'                        => 'Optional field. The subscription is expected to end on this date.',
    'bill_extension_date_help'                  => 'Optional field. The subscription must be extended (or cancelled) on or before this date.',
    'bill_end_index_line'                       => 'This subscription ends on :date',
    'bill_extension_index_line'                 => 'This subscription must be extended or cancelled on :date',
    'connected_journals'                        => 'Підключені транзакції',
    'auto_match_on'                             => 'Автоматично відповідає Firefly III',
    'auto_match_off'                            => 'Не підбирається автоматично Firefly III',
    'next_expected_match'                       => 'Наступний очікуваний збіг',
    'delete_bill'                               => 'Видалити підписку ":name"',
    'deleted_bill'                              => 'Deleted subscription ":name"',
    'edit_bill'                                 => 'Edit subscription ":name"',
    'more'                                      => 'Докладніше',
    'rescan_old'                                => 'Повторно запустіть правила для всіх транзакцій',
    'update_bill'                               => 'Update subscription',
    'updated_bill'                              => 'Updated subscription ":name"',
    'store_new_bill'                            => 'Store new subscription',
    'stored_new_bill'                           => 'Stored new subscription ":name"',
    'cannot_scan_inactive_bill'                 => 'Inactive subscriptions cannot be scanned.',
    'rescanned_bill'                            => 'Rescanned everything, and linked :count transaction to the subscription.|Rescanned everything, and linked :count transactions to the subscription.',
    'average_bill_amount_year'                  => 'Average subscription amount (:year)',
    'average_bill_amount_overall'               => 'Average subscription amount (overall)',
    'bill_is_active'                            => 'Subscription is active',
    'bill_expected_between'                     => 'Очікується між :start і :end',
    'bill_will_automatch'                       => 'Subscription will automatically linked to matching transactions',
    'skips_over'                                => 'пропускає',
    'bill_store_error'                          => 'An unexpected error occurred while storing your new subscription. Please check the log files',
    'list_inactive_rule'                        => 'неактивне правило',
    'bill_edit_rules'                           => 'Firefly III will attempt to edit the rule related to this subscription as well. If you\'ve edited this rule yourself however, Firefly III won\'t change anything.|Firefly III will attempt to edit the :count rules related to this subscription as well. If you\'ve edited these rules yourself however, Firefly III won\'t change anything.',
    'bill_expected_date'                        => 'Очікується :date',
    'bill_expected_date_js'                     => 'Очікується {date}',
    'expected_amount'                           => '(Очікувана) сума',
    'bill_paid_on'                              => 'Сплачено {date}',
    'bill_repeats_weekly'                       => 'Повторюється щотижня',
    'bill_repeats_monthly'                      => 'Повторюється щомісяця',
    'bill_repeats_quarterly'                    => 'Повторюється щокварталу',
    'bill_repeats_half-year'                    => 'Повторюється кожні півроку',
    'bill_repeats_yearly'                       => 'Повторюється щороку',
    'bill_repeats_weekly_other'                 => 'Повторюється через тиждень',
    'bill_repeats_monthly_other'                => 'Повторюється через місяць',
    'bill_repeats_quarterly_other'              => 'Повторюється через квартал',
    'bill_repeats_half-year_other'              => 'Повторюється щороку',
    'bill_repeats_yearly_other'                 => 'Повторюється через рік',
    'bill_repeats_weekly_skip'                  => 'Повторюється кожні {skip} тижнів',
    'bill_repeats_monthly_skip'                 => 'Повторює кожні {skip} місяців',
    'bill_repeats_quarterly_skip'               => 'Повторюється кожні {skip} кварталів',
    'bill_repeats_half-year_skip'               => 'Повторюється кожні {skip} півроку',
    'bill_repeats_yearly_skip'                  => 'Повторюється кожні {skip} років',
    'subscriptions'                             => 'Підписки',
    'go_to_subscriptions'                       => 'Перейти до своїх підписок',
    'forever'                                   => 'Назавжди',
    'extension_date_is'                         => 'Дата подовження {date}',

    // accounts:
    'account_locked_currency'                   => 'The currency of this account must remain :name as long as piggy banks are linked to it.',
    'i_am_owed_amount'                          => 'Мені заборгували суму',
    'i_owe_amount'                              => 'Я винен суму',
    'inactive_account_link'                     => 'Ви маєте :count неактивний (архівований) рахунок, який ви можете переглянути на цій окремій сторінці. У вас є :count неактивних (архівних) облікових записів, які ви можете переглядати на цій окремій сторінці.',
    'all_accounts_inactive'                     => 'Це ваші неактивні рахунки.',
    'active_account_link'                       => 'Це посилання повертається до ваших активних рахунків.',
    'account_missing_transaction'               => 'Рахунок #:id (":name") не може бути переглянутий безпосередньо, але в Firefly відсутня інформація для перенаправлення.',
    'cc_monthly_payment_date_help'              => 'Вибрані будь-який рік та будь-який місяць будуть проігноровані. Важливий лише день місяця.',
    'details_for_asset'                         => 'Деталі активів рахунку ":name"',
    'details_for_expense'                       => 'Деталі по рахунку витрат ":name"',
    'details_for_revenue'                       => 'Подробиці джерела доходу ":name"',
    'details_for_cash'                          => 'Деталі готівкового рахунку ":name"',
    'store_new_asset_account'                   => 'Зберегти новий рахунок активів',
    'store_new_expense_account'                 => 'Зберегти новий рахунок витрат',
    'store_new_revenue_account'                 => 'Зберегти нове джерело доходу',
    'edit_asset_account'                        => 'Редагувати рахунок активів ":name"',
    'edit_expense_account'                      => 'Редагувати рахунок витрат ":name"',
    'edit_revenue_account'                      => 'Редагувати джерело доходу ":name"',
    'delete_asset_account'                      => 'Видалити рахунок активів ":name"',
    'delete_expense_account'                    => 'Видалити рахунок витрат ":name"',
    'delete_revenue_account'                    => 'Видалити джерело доходу ":name"',
    'delete_liabilities_account'                => 'Видалити відповідальність ":name"',
    'asset_deleted'                             => 'Рахунок активів ":name" успішно видалено',
    'account_deleted'                           => 'Успішно видалено рахунок ":name"',
    'expense_deleted'                           => 'Успішно видалено обліковий запис витрат ":name"',
    'revenue_deleted'                           => 'Успішно видалено джерело доходів ":name"',
    'update_asset_account'                      => 'Оновити обліковий запис медіафайлів',
    'update_undefined_account'                  => 'Оновити обліковий запис',
    'update_liabilities_account'                => 'Оновити зобов\'язання',
    'update_expense_account'                    => 'Оновити рахунок витрат',
    'update_revenue_account'                    => 'Оновити джерело доходу',
    'make_new_asset_account'                    => 'Створити новий обліковий запис медіафайлів',
    'make_new_expense_account'                  => 'Створити новий рахунок витрат',
    'make_new_revenue_account'                  => 'Створити нове джерело доходу',
    'make_new_liabilities_account'              => 'Створити нове зобов\'язання',
    'asset_accounts'                            => 'Основні рахунки',
    'undefined_accounts'                        => 'Рахунки',
    'asset_accounts_inactive'                   => 'Основні рахунки (неактивні)',
    'expense_account'                           => 'Рахунок витрат',
    'expense_accounts'                          => 'Рахунки витрат',
    'expense_accounts_inactive'                 => 'Витрати рахунки (неактивні)',
    'revenue_account'                           => 'Джерело доходів',
    'revenue_accounts'                          => 'Джерела доходів',
    'revenue_accounts_inactive'                 => 'Облікові записи про доходи (неактивні)',
    'cash_accounts'                             => 'Готівкові рахунки',
    'Cash account'                              => 'Готівка',
    'liabilities_accounts'                      => 'Пасиви',
    'liabilities_accounts_inactive'             => 'Зобов\'язання (неактивні)',
    'reconcile_account'                         => 'Звірка рахунку ":account"',
    'overview_of_reconcile_modal'               => 'Огляд результатів звірки',
    'delete_reconciliation'                     => 'Видалити звірку',
    'update_reconciliation'                     => 'Оновити узгодження',
    'amount_cannot_be_zero'                     => 'Сума не може бути нульовою',
    'end_of_reconcile_period'                   => 'Кінець періоду звірки: :period',
    'start_of_reconcile_period'                 => 'Початок періоду звірки: :period',
    'start_balance'                             => 'Початковий баланс',
    'end_balance'                               => 'Кінцевий баланс',
    'update_balance_dates_instruction'          => 'Порівняйте суми та дати, вказані вище, з вашою банківською випискою та натисніть "Почати звірку"',
    'select_transactions_instruction'           => 'Виберіть транзакції, які з\'являються на вашій банківській виписці.',
    'select_range_and_balance'                  => 'Спочатку перевірте діапазон дат і залишки. Потім натисніть "Почати звірку"',
    'date_change_instruction'                   => 'Якщо ви зміните діапазон дат зараз, будь-який прогрес буде втрачено.',
    'update_selection'                          => 'Оновити вибране',
    'store_reconcile'                           => 'Улагодження магазину',
    'reconciliation_transaction'                => 'Операція примирення',
    'Reconciliation'                            => 'Звірування',
    'reconciliation'                            => 'Звірування',
    'reconcile_options'                         => 'Варіанти звірки',
    'reconcile_range'                           => 'Діапазон звірки',
    'start_reconcile'                           => 'Почати звірку',
    'cash_account_type'                         => 'Готівка',
    'cash'                                      => 'готівка',
    'cant_find_redirect_account'                => 'Firefly III намагався перенаправити вас, але не зміг. Вибачте за це.',
    'account_type'                              => 'Тип рахунку',
    'save_transactions_by_moving'               => 'Збережіть цю операцію, перемістивши її в інший рахунок: |Зберегти ці операції, перемістивши їх на інший рахунок:',
    'save_transactions_by_moving_js'            => 'Збережіть цю операцію, перемістивши її на інший рахунок. |Зберегти ці транзакції, перемістивши їх до іншого рахунку.',
    'stored_new_account'                        => 'Новий обліковий запис ":name" збережено!',
    'stored_new_account_js'                     => 'Новий обліковий запис "<a href="accounts/show/{ID}">{name}</a>"зберігається!',
    'updated_account'                           => 'Оновлений обліковий запис ":name"',
    'updated_account_js'                        => 'Оновлений обліковий запис "<a href="accounts/show/{ID}">{title}</a>".',
    'credit_card_options'                       => 'Налаштування кредитної картки',
    'no_transactions_account'                   => 'Немає транзакцій (у цьому періоді) для рахунку активу «:name».',
    'no_transactions_period'                    => 'Операцій немає (в цьому періоді).',
    'no_data_for_chart'                         => 'Недостатньо інформації (поки що) для створення цього графіку.',
    'select_at_least_one_account'               => 'Будь ласка, оберіть хоча б один обліковий запис активів',
    'select_at_least_one_category'              => 'Будь ласка, оберіть хоча б одну категорію',
    'select_at_least_one_budget'                => 'Будь ласка, оберіть хоча б один бюджет',
    'select_at_least_one_tag'                   => 'Будь ласка, виберіть принаймні один тег',
    'select_at_least_one_expense'               => 'Будь ласка, виберіть принаймні одну комбінацію рахунку витрат/доходів. Якщо у вас немає нічого (список порожній) цей звіт недоступний.',
    'account_default_currency'                  => 'Це буде типова валюта, асоційована з цим рахунку.',
    'piggy_default_currency'                    => 'Piggy banks can only save money in a single currency.',
    'piggy_account_currency_match'              => 'Only accounts that use the previously selected currency will be accepted.',
    'reconcile_has_more'                        => 'Ваш "Firefly III працює" має більше грошей, ніж Ваш банк може вам стверджувати. Є кілька варіантів. Будь ласка, виберіть що робити. Потім натисніть "Підтвердити примирення".',
    'reconcile_has_less'                        => 'Ваш подарунковий журнал Firefly III має менше грошей, ніж Ваш банк може вам стверджувати. Є кілька варіантів. Будь ласка, виберіть що робити. Потім натисніть "Підтвердити примирення".',
    'reconcile_is_equal'                        => 'Ваш журнал Firefly III і Ваш банківський виписки збігаються. Будь ласка, натисніть "Підтвердити примирення", щоб підтвердити своє введення.',
    'create_pos_reconcile_transaction'          => 'Очистити вибрані транзакції і створити корекцію додавання :amount до цього активу.',
    'create_neg_reconcile_transaction'          => 'Очистити вибрані транзакції і створити виправлення :amount з цього акаунта активу.',
    'reconcile_do_nothing'                      => 'Очистити вибрані транзакції, але не правильні.',
    'reconcile_go_back'                         => 'Ви завжди можете змінити або видалити виправлення пізніше.',
    'must_be_asset_account'                     => 'Ви можете узгоджувати тільки рахунки активів',
    'reconciliation_stored'                     => 'Урегулювання збережено',
    'reconciliation_error'                      => 'Через помилку транзакції були позначені як звірені, але виправлення не було збережено: :error.',
    'reconciliation_transaction_title'          => 'Звірення (:from до :to)',
    'sum_of_reconciliation'                     => 'Сума звірення',
    'reconcile_this_account'                    => 'Звірити цей рахунок',
    'reconcile'                                 => 'Звірити',
    'show'                                      => 'Показати',
    'confirm_reconciliation'                    => 'Підтвердити звірення',
    'submitted_start_balance'                   => 'Представлений початковий баланс',
    'selected_transactions'                     => 'Вибрані транзакції (:count)',
    'already_cleared_transactions'              => 'Вже очищено транзакції (:count)',
    'submitted_end_balance'                     => 'Вказаний кінцевий баланс',
    'initial_balance_description'               => 'Початковий баланс для ":account"',
    'liability_credit_description'              => 'Кредит відповідальності для ":account"',
    'interest_calc_'                            => 'невідомо',
    'interest_calc_daily'                       => 'За день',
    'interest_calc_monthly'                     => 'За місяць',
    'interest_calc_yearly'                      => 'За рік',
    'interest_calc_weekly'                      => 'За тиждень',
    'interest_calc_half-year'                   => 'За півроку',
    'interest_calc_quarterly'                   => 'За квартал',
    'initial_balance_account'                   => 'Початковий баланс рахунку :account',
    'list_options'                              => 'Параметри списку',
    'account_column_opt_drag_and_drop'          => 'Drag and drop',
    'account_column_opt_active'                 => 'Active',
    'account_column_opt_name'                   => 'Name',
    'account_column_opt_type'                   => 'Тип',
    'account_column_opt_liability_type'         => 'Liability type',
    'account_column_opt_liability_direction'    => 'Liability direction',
    'account_column_opt_liability_interest'     => 'Liability interest',
    'account_column_opt_number'                 => 'Account number',
    'account_column_opt_current_balance'        => 'Current balance',
    'account_column_opt_amount_due'             => 'Amount due',
    'account_column_opt_last_activity'          => 'Last activity',
    'account_column_opt_balance_difference'     => 'Balance difference',
    'account_column_opt_menu'                   => 'Меню',

    // categories:
    'new_category'                              => 'Нова категорія',
    'create_new_category'                       => 'Створити нову категорію',
    'without_category'                          => 'Без категорії',
    'update_category'                           => 'Оновити категорію',
    'updated_category'                          => 'Оновлена категорія ":name"',
    'categories'                                => 'Категорії',
    'edit_category'                             => 'Редагувати категорію ":name"',
    'no_category'                               => '(без категорії)',
    'unknown_category_plain'                    => 'Без категорії',
    'category'                                  => 'Категорія',
    'delete_category'                           => 'Видалити категорію ":name"',
    'deleted_category'                          => 'Категорія ":name" видалена',
    'store_category'                            => 'Зберегти нову категорію',
    'stored_category'                           => 'Збережено нову категорію ":name"',
    'without_category_between'                  => 'Без категорії між :start і :end',


    // transactions:
    'wait_loading_transaction'                  => 'Дочекайтеся завантаження форми',
    'wait_loading_data'                         => 'Будь ласка, зачекайте завантаження інформації...',
    'wait_attachments'                          => 'Будь ласка, зачекайте на вкладення для завантаження.',
    'errors_upload'                             => 'Не вдалося виконати завантаження. Будь ласка, перевірте консоль браузера.',
    'amount_foreign_if'                         => 'Сума в іноземній валюті, якщо є',
    'amount_destination_account'                => 'Сума в валюті цільового рахунку',
    'edit_transaction_title'                    => 'Редагувати транзакцію ":description"',
    'unreconcile'                               => 'Скасувати звірку',
    'update_withdrawal'                         => 'Оновити зняття',
    'update_deposit'                            => 'Оновити депозит',
    'update_transaction'                        => 'Оновити операцію',
    'update_transfer'                           => 'Оновити',
    'updated_withdrawal'                        => 'Оновлено виведення ":description"',
    'updated_deposit'                           => 'Оновлено депозит ":description"',
    'updated_transfer'                          => 'Оновлено переказ ":description"',
    'no_changes_withdrawal'                     => 'Зняття ":description" не було змінено.',
    'no_changes_deposit'                        => 'Депозит ":description" не було змінено.',
    'no_changes_transfer'                       => 'Переказ ":description" не змінено.',
    'delete_withdrawal'                         => 'Видалити виведення ":description"',
    'delete_deposit'                            => 'Видалити депозит ":description"',
    'delete_transfer'                           => 'Видалити переказ ":description"',
    'deleted_withdrawal'                        => 'Успішно видалено зняття ":description"',
    'deleted_deposit'                           => 'Успішно видалено депозит ":description"',
    'deleted_transfer'                          => 'Успішно видалено передачу ":description"',
    'deleted_reconciliation'                    => 'Транзакція примирення успішно видалена ":description"',
    'stored_journal'                            => 'Успішно створено нову транзакцію ":description"',
    'stored_journal_js'                         => 'Successfully created new transaction "{{description}}"',
    'stored_journal_no_descr'                   => 'Нова операція успішно створена',
    'updated_journal_no_descr'                  => 'Операцію успішно оновлено',
    'select_transactions'                       => 'Вибрати транзакції',
    'rule_group_select_transactions'            => 'Застосувати ":title" до транзакцій',
    'rule_select_transactions'                  => 'Застосувати ":title" до транзакцій',
    'stop_selection'                            => 'Зупинити вибір операцій',
    'reconcile_selected'                        => 'Звірити',
    'mass_delete_journals'                      => 'Видалити декілька операцій',
    'mass_edit_journals'                        => 'Редагувати кілька операцій',
    'mass_bulk_journals'                        => 'Масове редагування декількох транзакцій',
    'mass_bulk_journals_explain'                => 'Ця форма дозволяє вам змінювати властивості трансакцій, перерахованих нижче в одному широкому оновленні. Всі транзакції в таблиці будуть оновлені, коли ви зміните параметри, які ви бачите тут.',
    'part_of_split'                             => 'Ця транзакція є частиною розділеної транзакції. Якщо Ви не вибрали усі сплайни, Ви можете внести лише половину транзакції.',
    'bulk_set_new_values'                       => 'Використовуйте вхідні дані для встановлення нових значень. Якщо їх залишити порожніми, вони будуть зроблені порожніми для всіх. Також зверніть увагу, що виведення коштів буде отриманий бюджет.',
    'no_bulk_category'                          => 'Не оновлювати категорію',
    'no_bulk_budget'                            => 'Не оновлювати бюджет',
    'no_bulk_tags'                              => 'Не оновлювати мітку(и)',
    'replace_with_these_tags'                   => 'Замінити цими мітками',
    'append_these_tags'                         => 'Додати ці теги',
    'mass_edit'                                 => 'Редагувати вибрані індивідуально',
    'bulk_edit'                                 => 'Редагувати вибрані серед повних',
    'mass_delete'                               => 'Видалити вибране',
    'cannot_edit_other_fields'                  => 'Ви не можете редагувати інші поля, ніж ті, які тут, тому що немає місця, щоб показати їх. Будь ласка, перейдіть за посиланням і відредагуйте їх один за одним, якщо вам необхідно відредагувати ці поля.',
    'cannot_change_amount_reconciled'           => 'You can\'t change the amount or account(s) of reconciled transactions.',
    'no_budget'                                 => '(поза бюджетом)',
    'no_bill'                                   => '(немає підписки)',
    'account_per_budget'                        => 'Рахунки на бюджет',
    'account_per_category'                      => 'Рахунок в категорії',
    'create_new_object'                         => 'Створити',
    'empty'                                     => '(порожньо)',
    'all_other_budgets'                         => '(всі інші бюджети)',
    'all_other_accounts'                        => '(всі інші облікові записи)',
    'expense_per_source_account'                => 'Витрати на вихідний рахунок',
    'expense_per_destination_account'           => 'Витрати за цільовий рахунок',
    'income_per_destination_account'            => 'Дохід за цільовим рахунком',
    'spent_in_specific_category'                => 'Витрачено в категорії ":category"',
    'earned_in_specific_category'               => 'Зароблено в категорії ":category"',
    'spent_in_specific_tag'                     => 'Витрачено за тегом ":tag"',
    'earned_in_specific_tag'                    => 'Зароблено за тегом ":tag"',
    'income_per_source_account'                 => 'Доходи за джерелом рахунку',
    'average_spending_per_destination'          => 'Середні витрати за рахунок призначення',
    'average_spending_per_source'               => 'Середні витрати за джерелом',
    'average_earning_per_source'                => 'Середній заробіток за рахунок',
    'average_earning_per_destination'           => 'Середній заробіток за цільовий рахунок',
    'account_per_tag'                           => 'Обліковий запис на тег',
    'tag_report_expenses_listed_once'           => 'Витрати та доходи ніколи не перераховані двічі. Якщо транзакція має кілька тегів, вона може відображатися лише в одному з його тегів. Цей список може здаватися відсутнім даними, але суми будуть правильними.',
    'double_report_expenses_charted_once'       => 'Витрати та доходи ніколи не показуються двічі. Якщо транзакція має кілька тегів, вона може відображатися лише в одному з його тегів. Ця діаграма може здатися відсутніми, але суми будуть правильні.',
    'tag_report_chart_single_tag'               => 'Ця діаграма застосовується до одного тегу. Якщо в транзакції є кілька тегів, те, що ви тут бачите, може відображатися і в діаграмах інших тегах.',
    'tag'                                       => 'Тег',
    'no_budget_squared'                         => '(поза бюджетом)',
    'perm-delete-many'                          => 'Видалення багатьох елементів в одному ходу може бути дуже руйнівним. Будь ласка, будьте обережні. Ви можете видалити частину спільного запису з цієї сторінки, так що будьте обережні.',
    'mass_deleted_transactions_success'         => 'Видалено :count транзакцій.|Видалено транзакції :count.',
    'mass_edited_transactions_success'          => 'Оновлено :count транзакцій.|Оновлено :count транзакцій.',
    'opt_group_'                                => '(без типу рахунку)',
    'opt_group_no_account_type'                 => '(без типу рахунку)',
    'opt_group_defaultAsset'                    => 'Основний рахунок за замовчуванням',
    'opt_group_savingAsset'                     => 'Накопичувальні рахунки',
    'opt_group_sharedAsset'                     => 'Спільні рахунки',
    'opt_group_ccAsset'                         => 'Кредитні картки',
    'opt_group_cashWalletAsset'                 => 'Готівкові гаманці',
    'opt_group_expense_account'                 => 'Рахунки витрат',
    'opt_group_revenue_account'                 => 'Рахунки доходів',
    'opt_group_l_Loan'                          => 'Зобов\'язання: Позика',
    'opt_group_cash_account'                    => 'Готівка',
    'opt_group_l_Debt'                          => 'Зобов\'язання: Борг',
    'opt_group_l_Mortgage'                      => 'Осередня здатність: Моргаж',
    'opt_group_l_Credit card'                   => 'Оплата: кредитна картка',
    'notes'                                     => 'Примітки',
    'view_notes'                                => 'View notes',
    'set_budget_limit_notes'                    => 'View the notes for this budgeted amount',
    'edit_bl_notes'                             => 'Edit notes',
    'update_bl_notes'                           => 'Update notes',
    'unknown_journal_error'                     => 'Не вдалося зберегти транзакцію. Будь ласка, перевірте файли журналу.',
    'attachment_not_found'                      => 'Цей прикріплення не знайдено.',
    'journal_link_bill'                         => 'This transaction is linked to subscription <a href=":route">:name</a>. To remove the connection, uncheck the checkbox. Use rules to connect it to another subscription.',
    'transaction_stored_link'                   => '<a href="transactions/show/{ID}">Транзакція #{ID} ("{title}")</a> була збережена.',
    'transaction_new_stored_link'               => '<a href="transactions/show/{ID}">Транзакція #{ID}</a> була збережена.',
    'transaction_updated_link'                  => '<a href="transactions/show/{ID}">Транзакція #{ID}</a> ("{title}") була оновлена.',
    'transaction_updated_no_changes'            => '<a href="transactions/show/{ID}">Транзакція #{ID}</a> ("{title}") не отримала жодних змін.',
    'first_split_decides'                       => 'Перший поділ визначає значення цього поля',
    'first_split_overrules_source'              => 'Перший поділ може перевиконувати вихідний рахунок',
    'first_split_overrules_destination'         => 'Перший поділ може перевизначити цільовий рахунок',
    'spent_x_of_y'                              => 'Витрачено {amount} з {total}',

    // new user:
    'welcome'                                   => 'Вітаємо у Firefly III!',
    'submit'                                    => 'Підтвердити',
    'submission'                                => 'Подання',
    'submit_yes_really'                         => 'Представити (я знаю, що я роблю)',
    'getting_started'                           => 'Починаємо',
    'to_get_started'                            => 'Гарно побачити, що ви успішно встановили Firefly III. Щоб почати з цього інструменту, будь ласка, введіть ім\'я банку і баланс вашого основного контрольного рахунку. Ще не хвилюйтеся, якщо у вас є кілька облікових записів. Ви можете додати їх пізніше. Це просто те, що Firefly III потребує ще чогось.',
    'savings_balance_text'                      => 'Firefly III автоматично створить для вас ощадний обліковий запис. За замовчуванням, гроші не будуть на вашому ощадному рахунку, але якщо ви скажете "Firefly І" баланс, він буде збережений як такий.',
    'finish_up_new_user'                        => 'Це все! Ви можете продовжити, натиснувши <strong>Надіслати</strong>. Ви будете перенаправлені до індексу Firefly III.',
    'stored_new_accounts_new_user'              => 'Ура! Ваші нові облікові записи збережено.',
    'set_preferred_language'                    => 'Якщо ви надаєте перевагу використовувати Firefly III в іншій мові, вкажіть таке значення.',
    'language'                                  => 'Мова',
    'new_savings_account'                       => ':bank_name ощадний рахунок',
    'cash_wallet'                               => 'Гаманець',
    'currency_not_present'                      => 'Якщо валюта, якою ви зазвичай користуєтесь відсутня, не хвилюйтеся. Ви можете створити власну валюту у розділі Опції > Валюти.',

    // home page:
    'transaction_table_description'             => 'Таблиця з вашими операціями',
    'opposing_account'                          => 'Протилежний рахунок',
    'yourAccounts'                              => 'Ваш рахунок',
    'your_accounts'                             => 'Огляд вашого рахунку',
    'category_overview'                         => 'Огляд категорії',
    'expense_overview'                          => 'Огляд рахунку витрат',
    'revenue_overview'                          => 'Огляд по виплатам',
    'budgetsAndSpending'                        => 'Бюджети та витрати',
    'budgets_and_spending'                      => 'Бюджети та витрати',
    'go_to_budget'                              => 'Перейти до бюджету "{budget}"',
    'go_to_deposits'                            => 'Перейти до депозитів',
    'go_to_expenses'                            => 'Перейти до витрат',
    'savings'                                   => 'Заощадження',
    'newWithdrawal'                             => 'Нові витрати',
    'newDeposit'                                => 'Нові надходження',
    'newTransfer'                               => 'Новий переказ',
    'bills_to_pay'                              => 'Subscriptions to pay',
    'per_day'                                   => 'За день',
    'left_to_spend_per_day'                     => 'Залишилося на день',
    'bills_paid'                                => 'Subscriptions paid',
    'custom_period'                             => 'В заданий час',
    'reset_to_current'                          => 'Скинути до поточного періоду',
    'select_period'                             => 'Оберіть період',

    // menu and titles, should be recycled as often as possible:
    'currency'                                  => 'Валюта',
    'preferences'                               => 'Налаштування',
    'logout'                                    => 'Вихід із системи',
    'logout_other_sessions'                     => 'Вийти з усіх інших сеансів',
    'toggleNavigation'                          => 'Переключити навігацію',
    'toggle_dropdown'                           => 'Toggle dropdown',
    'searchPlaceholder'                         => 'Пошук...',
    'version'                                   => 'Версія',
    'dashboard'                                 => 'Головна панель',
    'income_and_expense'                        => 'Доходи та витрати',
    'all_money'                                 => 'Усі ваші гроші',
    'unknown_source_plain'                      => 'Невідомий вихідний рахунок',
    'unknown_dest_plain'                        => 'Невідомий рахунок призначення',
    'unknown_any_plain'                         => 'Невідомий рахункок',
    'unknown_budget_plain'                      => 'Немає бюджету',
    'available_budget'                          => 'Доступний бюджет ({currency})',
    'currencies'                                => 'Валюти',
    'activity'                                  => 'Активність',
    'usage'                                     => 'Використання',
    'accounts'                                  => 'Рахунки',
    'Asset account'                             => 'Активний рахунок',
    'Default account'                           => 'Основний рахунок',
    'Expense account'                           => 'Рахунок витрат',
    'Revenue account'                           => 'Джерело доходів',
    'Initial balance account'                   => 'Початковий баланс на рахунок',
    'account_type_Asset account'                => 'Рахунок активів',
    'account_type_Expense account'              => 'Рахунок витрат',
    'account_type_Revenue account'              => 'Джерело доходів',
    'account_type_Debt'                         => 'Дебіт',
    'account_type_Loan'                         => 'Позика',
    'account_type_Mortgage'                     => 'Іпотека',
    'account_type_debt'                         => 'Дебіт',
    'account_type_loan'                         => 'Позика',
    'account_type_mortgage'                     => 'Іпотека',
    'account_type_Credit card'                  => 'Кредитна картка',
    'credit_card_type_monthlyFull'              => 'Повна оплата щомісяця',
    'liability_direction_credit'                => 'Я в боргу перед вами',
    'liability_direction_debit'                 => 'Я винен цьому боргу комусь іншому',
    'liability_direction_credit_short'          => 'Заборгував цей борг',
    'liability_direction_debit_short'           => 'Винен цей борг',
    'liability_direction__short'                => 'Невідомо',
    'liability_direction_null_short'            => 'Невідомо',
    'Liability credit'                          => 'Кредит відповідальності',
    'budgets'                                   => 'Бюджети',
    'tags'                                      => 'Теги',
    'reports'                                   => 'Звіти',
    'transactions'                              => 'Транзакції',
    'expenses'                                  => 'Витрати',
    'income'                                    => 'Дохід / прихід',
    'transfers'                                 => 'Перекази',
    'moneyManagement'                           => 'Управління фінансами',
    'money_management'                          => 'Управління фінансами',
    'tools'                                     => 'Інструменти',
    'piggyBanks'                                => 'Скарбнички',
    'piggy_banks'                               => 'Скарбнички',
    'amount_x_of_y'                             => '{current} {total}',
    'bills'                                     => 'Підписки',
    'withdrawal'                                => 'Витрата',
    'opening_balance'                           => 'Початковий баланс',
    'deposit'                                   => 'Депозит',
    'account'                                   => 'Рахунок',
    'transfer'                                  => 'Переказ',
    'Withdrawal'                                => 'Витрата',
    'Deposit'                                   => 'Депозит',
    'Transfer'                                  => 'Переказ',
    'bill'                                      => 'Підписка',
    'yes'                                       => 'Так',
    'no'                                        => 'Ні',
    'amount'                                    => 'Сума',
    'overview'                                  => 'Огляд',
    'saveOnAccount'                             => 'Зберегти на рахунок',
    'saveOnAccounts'                            => 'Save on account(s)',
    'unknown'                                   => 'Невідомо',
    'monthly'                                   => 'Щомісячно',
    'profile'                                   => 'Профіль',
    'errors'                                    => 'Помилки',
    'debt_start_date'                           => 'Дата початку боргу',
    'debt_start_amount'                         => 'Початкова сума боргу',
    'debt_start_amount_help'                    => 'Завжди краще встановлювати це значення як негативну суму. Для отримання додаткової інформації перегляньте сторінки довідки (значок у верхньому правому куті (?)).',
    'interest_period_help'                      => 'Це поле є чисто косметичним і не буде розраховане для вас. Як виявляється, банки дуже напідступні, так Firefly III ніколи не отримує це правильно.',
    'store_new_liabilities_account'             => 'Зберегти нове зобов\'язання',
    'edit_liabilities_account'                  => 'Редагувати зобов\'язання ":name"',
    'financial_control'                         => 'Фінансовий контроль',
    'accounting'                                => 'Облік',
    'automation'                                => 'Автоматизація',
    'others'                                    => 'Інше',
    'classification'                            => 'Класифікація',
    'store_transaction'                         => 'Зберегти операцію',


    // reports:
    'quick_link_needs_accounts'                 => 'In order to generate reports, you need to add at least one asset account to Firefly III.',
    'report_default'                            => 'Фінансовий звіт за замовчуванням між :start та :end',
    'report_audit'                              => 'Огляд історії транзакцій між :start та :end',
    'report_category'                           => 'Звіт по категоріях між :start і :end',
    'report_double'                             => 'Звіт по рахунках витрат/доходів між :start і :end',
    'report_budget'                             => 'Звіт про бюджет між :start та :end',
    'report_tag'                                => 'Звіт по тегам між :start і :end',
    'quick_link_reports'                        => 'Швидкі посилання',
    'quick_link_examples'                       => 'Ось лише декілька прикладів посилань, які можна почати. Перегляньте довідкові сторінки під (?)-кнопкою для отримання інформації про всі звіти та магічні слова, які ви можете використовувати.',
    'quick_link_default_report'                 => 'Фінансовий звіт за замовчуванням',
    'quick_link_audit_report'                   => 'Огляд історії транзакцій',
    'report_this_month_quick'                   => 'Поточний місяць, всі рахунки',
    'report_last_month_quick'                   => 'Минулого місяця всі рахунки',
    'report_this_year_quick'                    => 'Поточний рік, всі рахунки',
    'report_this_fiscal_year_quick'             => 'Поточний фінансовий рік, всі рахунки',
    'report_all_time_quick'                     => 'Усіх частин, всі акаунти',
    'reports_can_bookmark'                      => 'Пам\'ятайте, що звіти можуть бути в закладках.',
    'incomeVsExpenses'                          => 'Порівняння доходів та витрат',
    'accountBalances'                           => 'Залишки рахунків',
    'balanceStart'                              => 'Баланс на початку періоду',
    'balanceEnd'                                => 'Баланс в кінці періоду',
    'splitByAccount'                            => 'Розділити на аккаунті',
    'coveredWithTags'                           => 'Обкрито тегами',
    'leftInBudget'                              => 'Ліворуч в бюджеті',
    'left_in_debt'                              => 'Сума боргу',
    'sumOfSums'                                 => 'Сума сум',
    'noCategory'                                => '(без категорії)',
    'notCharged'                                => 'Не стягнуто (поки що)',
    'inactive'                                  => 'Неактивний',
    'active'                                    => 'Активно',
    'difference'                                => 'Баланс',
    'money_flowing_in'                          => 'В',
    'money_flowing_out'                         => 'Витрати',
    'topX'                                      => 'топ :number',
    'show_full_list'                            => 'Показати весь список',
    'show_only_top'                             => 'Показати тільки верхнє :number',
    'report_type'                               => 'Тип звіту',
    'report_type_default'                       => 'Фінансовий звіт за замовчуванням',
    'report_type_audit'                         => 'Огляд історії транзакцій (аудит)',
    'report_type_category'                      => 'Звіт категорії',
    'report_type_budget'                        => 'Звіт про бюджет',
    'report_type_tag'                           => 'Мітка звіту',
    'report_type_double'                        => 'Звіт про доходи/витрати',
    'more_info_help'                            => 'Більше інформації про ці типи звітів можна знайти на сторінках довідки. Натисніть (?) значок у верхньому правому куті.',
    'report_included_accounts'                  => 'Включені рахунки',
    'report_date_range'                         => 'Період',
    'report_preset_ranges'                      => 'Попередньо встановлені діапазони',
    'shared'                                    => 'Спільні',
    'fiscal_year'                               => 'Фінансовий рік',
    'income_entry'                              => 'Доходи з рахунку ":name" між :start і :end',
    'expense_entry'                             => 'Витрати на рахунок ":name" між :start і :end',
    'category_entry'                            => 'Витрати і дохід в категорії ":name" між :start і :end',
    'budget_spent_amount'                       => 'Витрати в бюджеті ":budget" між :start і :end',
    'balance_amount'                            => 'Витрати в бюджеті ":budget" сплачені з рахунку ":account" між :start і :end',
    'no_audit_activity'                         => 'Не було зафіксовано жодної активності на рахунку <a href=":url" title=":account_name">:account_name</a> між :start і :end.',
    'audit_end_balance'                         => 'Баланс рахунку <a href=":url" title=":account_name">:account_name</a> в кінці :end був: :balance',
    'reports_extra_options'                     => 'Додаткові опції',
    'report_has_no_extra_options'               => 'Цей звіт не має додаткових параметрів',
    'reports_submit'                            => 'Переглянути звіт',
    'end_after_start_date'                      => 'Дата закінчення звіту повинна бути після початкової дати.',
    'select_category'                           => 'Вибрати категорію(iй)',
    'select_budget'                             => 'Виберіть бюджет(и).',
    'select_tag'                                => 'Виберіть тег(и).',
    'income_per_category'                       => 'Дохід в категорії',
    'expense_per_category'                      => 'Витрати за категорію',
    'expense_per_budget'                        => 'Витрати на бюджет',
    'income_per_account'                        => 'Дохід на рахунок',
    'expense_per_account'                       => 'Витрати на рахунок',
    'expense_per_tag'                           => 'Витрати на тег',
    'income_per_tag'                            => 'Дохід за ярликом',
    'include_expense_not_in_budget'             => 'Включені витрати не в вибрані бюджет(и)',
    'include_expense_not_in_account'            => 'Включені витрати не в обраному рахунку(и)',
    'include_expense_not_in_category'           => 'Включені витрати не в вибраній категорії(iй)',
    'include_income_not_in_category'            => 'Включений дохід не в вибраній категорії(iй)',
    'include_income_not_in_account'             => 'Включений дохід не в обраному обліковому записі(х)',
    'include_income_not_in_tags'                => 'Включено дохід не в обраний тег(и)',
    'include_expense_not_in_tags'               => 'Включені витрати не у вибраних тегах',
    'everything_else'                           => 'Всі інші',
    'income_and_expenses'                       => 'Доходи і витрати',
    'spent_average'                             => 'Витрачено (середньо)',
    'income_average'                            => 'Дохід (середній)',
    'transaction_count'                         => 'Кількість транзакцій',
    'average_spending_per_account'              => 'Середні витрати на рахунок',
    'average_income_per_account'                => 'Середній дохід на рахунок',
    'total'                                     => 'Всього',
    'description'                               => 'Опис',
    'sum_of_period'                             => 'Сума періоду',
    'average_in_period'                         => 'Середній у періоді',
    'no_account_role'                           => '(немає ролі)',
    'account_role_defaultAsset'                 => 'Рахунок активів за замовчуванням',
    'account_role_sharedAsset'                  => 'Спільний рахунок',
    'account_role_savingAsset'                  => 'Рахунок для накопичення',
    'account_role_ccAsset'                      => 'Кредитна картка',
    'account_role_cashWalletAsset'              => 'Гаманець',
    'budget_chart_click'                        => 'Будь ласка, натисніть на назву бюджету в звітності, щоб побачити діаграму.',
    'category_chart_click'                      => 'Будь ласка, натисніть на назву категорії в наведеній таблиці, щоб побачити діаграму.',
    'in_out_accounts'                           => 'Отримано та витратили за комбінацію',
    'in_out_accounts_per_asset'                 => 'Зароблено і витрачено (на рахунок)',
    'in_out_per_category'                       => 'Зароблено і витрачено за категорію',
    'out_per_budget'                            => 'Витрачено на бюджет',
    'select_expense_revenue'                    => 'Вибрати витрати / джерело доходу',
    'multi_currency_report_sum'                 => 'Оскільки у цьому списку рахунки з декількома валютами, сума, яку ви бачите, може не мати сенсу. Звіт завжди повернеться до типової валюти.',
    'sum_in_default_currency'                   => 'Сума буде завжди вказана за замовчуванням.',
    'net_filtered_prefs'                        => 'На цій діаграмі ви не будете враховувати рахунки, що мають "Включити в чистому вартості "-опції не відмічено".',


    // charts:
    'chart'                                     => 'Графік',
    'month'                                     => 'Місяць',
    'budget'                                    => 'Бюджет',
    'spent'                                     => 'Витрачено',
    'spent_capped'                              => 'Витрачено (ліміт)',
    'spent_in_budget'                           => 'Витрачено бюджету',
    'left_to_spend'                             => 'Залишилось',
    'earned'                                    => 'Зароблено',
    'overspent'                                 => 'Перевитрата',
    'left'                                      => 'Ліворуч',
    'max-amount'                                => 'Максимальна сума',
    'min-amount'                                => 'Мінімальна сума',
    'journal-amount'                            => 'Current subscription entry',
    'name'                                      => 'Назва',
    'expires_at'                                => 'Expires at',
    'date'                                      => 'Дата',
    'date_and_time'                             => 'Дата і час',
    'time'                                      => 'Час',
    'paid'                                      => 'Сплачено',
    'unpaid'                                    => 'Несплачено',
    'day'                                       => 'День',
    'budgeted'                                  => 'Бюджет встановлено',
    'period'                                    => 'Період',
    'balance'                                   => 'Баланс',
    'in_out_period'                             => 'Понад цим періодом',
    'sum'                                       => 'Сума',
    'summary'                                   => 'Підсумок',
    'average'                                   => 'Середнє',
    'balanceFor'                                => 'Баланс для :name',
    'no_tags'                                   => '(немає тегів)',
    'nothing_found'                             => '(нічого не знайдено)',

    // page settings and wizard dialogs

    'page_settings_header'          => 'Налаштування сторінки',
    'visible_columns'               => 'Видимі стовпці',
    'accounts_to_show'              => 'Рахунки для відображення',
    'active_accounts_only'          => 'Active accounts only',
    'in_active_accounts_only'       => 'Inactive accounts only',
    'show_all_accounts'             => 'Показати всі рахунки',
    'group_accounts'                => 'Group accounts',

    // piggy banks:
    'event_history'                 => 'Історія подій',
    'add_money_to_piggy'            => 'Додайте гроші в скарбничку ":name"',
    'piggy_bank'                    => 'Скарбничка',
    'new_piggy_bank'                => 'Нова скарбничка',
    'store_piggy_bank'              => 'Зберегти нову скарбничку',
    'stored_piggy_bank'             => 'Зберегти нову скарбничку ":name"',
    'account_status'                => 'Статус рахунку',
    'left_for_piggy_banks'          => 'Залишок для скарбничок',
    'sum_of_piggy_banks'            => 'Сума скарбничок',
    'saved_so_far'                  => 'Збережено до цих пір',
    'saved_so_far_total'            => 'Saved so far in total',
    'reset_history'                 => 'reset history',
    'reset_history_confirm'         => 'Are you sure you want to reset the history of this piggy bank? This will make the chart match the piggy bank\'s amount again.',
    'piggy_history_reset'           => 'The piggy bank history has been reset',
    'left_to_save'                  => 'Зберегти ліворуч',
    'suggested_amount'              => 'Пропонована місячна сума для збереження',
    'add_money_to_piggy_title'      => 'Додайте гроші в скарбничку ":name"',
    'remove_money_from_piggy_title' => 'Зніміть гроші зі скарбнички ":name"',
    'add'                           => 'Додати',
    'no_money_for_piggy'            => 'У вас немає грошей, щоб покласти в цю скарбничку.',
    'suggested_savings_per_month'   => 'Запропоновано за місяць',

    'remove'                    => 'Видалити',
    'max_amount_add'            => 'Максимальна сума, яку ви можете додати',
    'max_amount_remove'         => 'Максимальна сума, яку ви можете видалити, є',
    'update_piggy_button'       => 'Оновити скарбничку',
    'update_piggy_title'        => 'Оновити скарбничку "":name"',
    'updated_piggy_bank'        => 'Оновлено скарбничку ":name"',
    'details'                   => 'Деталі',
    'events'                    => 'Події',
    'target_amount'             => 'Сума накопичення',
    'start_date'                => 'Дата початку',
    'no_start_date'             => 'Немає дати початку',
    'target_date'               => 'Кінцева дата',
    'no_target_date'            => 'Немає цільової дати',
    'table'                     => 'Таблиця',
    'delete_piggy_bank'         => 'Видалити скарбничку ":name"',
    'cannot_add_amount_piggy'   => 'Не вдалося додати :amount до ":name.',
    'cannot_remove_from_piggy'  => 'Не вдалося зняти :amount з :name".',
    'deleted_piggy_bank'        => 'Видалено скарбничку ":name"',
    'added_amount_to_piggy'     => 'Додано :amount до ":name"',
    'removed_amount_from_piggy' => 'Знято :amount з ":name"',
    'piggy_events'              => 'Пов\'язані скарбнички',

    // tags
    'delete_tag'                => 'Видалити мітку ":tag"',
    'deleted_tag'               => 'Видалено тег ":tag"',
    'new_tag'                   => 'Зробити новий тег',
    'edit_tag'                  => 'Редагувати мітку ":tag"',
    'updated_tag'               => 'Оновлено тег ":tag"',
    'created_tag'               => 'Тег ":tag" був створений!',

    'transaction_journal_information'               => 'Інформація про платіж',
    'transaction_journal_amount'                    => 'Інформація про суму',
    'transaction_journal_meta'                      => 'Мета інформація',
    'transaction_journal_more'                      => 'Більше інформації',
    'basic_journal_information'                     => 'Основна інформація про транзакцію',
    'transaction_journal_extra'                     => 'Додаткова інформація',
    'att_part_of_journal'                           => 'Збережено під ":journal"',
    'total_amount'                                  => 'Загальна сума',
    'number_of_decimals'                            => 'Кількість десяткових знаків',


    // administration
    'invite_is_already_redeemed'                    => 'Запрошення до ":address" вже було використано.',
    'invite_is_deleted'                             => 'Запрошення до ":address" було видалено.',
    'invite_new_user_title'                         => 'Запросити нового користувача',
    'invite_new_user_text'                          => 'As an administrator, you can invite users to register to your Firefly III installation. Using the direct link you can share with them, they will be able to register an account. The invited user and their invite link will appear in the table below. You are free to share the invitation link with them.',
    'invited_user_mail'                             => 'Адреса електронної пошти',
    'invite_user'                                   => 'Запросити користувача',
    'user_is_invited'                               => 'Email адреса ":address" був запрошений до Firefly III',
    'administration'                                => 'Адміністрування',
    'system_settings'                               => 'Налаштування системи',
    'code_already_used'                             => 'Код запрошення вже було використано',
    'user_administration'                           => 'Адміністрування користувача',
    'list_all_users'                                => 'Усі користувачі',
    'all_users'                                     => 'Усі користувачі',
    'instance_configuration'                        => 'Конфігурація',
    'firefly_instance_configuration'                => 'Конфігурація Firefly III',
    'setting_single_user_mode'                      => 'Режим одного користувача',
    'setting_single_user_mode_explain'              => 'За замовчуванням Firefly III приймає лише одну (1) реєстрацію. Це захід безпеки, який заважає іншим користуватися вашим екземпляром, якщо ви не дозволите їм. Майбутні реєстрації заблоковані. Коли ви знімаєте цей прапорець, інші можуть використовувати вашу примірку, за умови, що вони можуть дістатися до неї (коли вона підключена до Інтернету).',
    'store_configuration'                           => 'Конфігурація магазину',
    'single_user_administration'                    => 'Адміністрування користувача :email',
    'edit_user'                                     => 'Редагувати користувача :email',
    'hidden_fields_preferences'                     => 'Ви можете увімкнути більше опцій транзакції у вашому <a href="preferences">налаштування</a>.',
    'user_data_information'                         => 'Дані користувача',
    'user_information'                              => 'Особисті дані',
    'total_size'                                    => 'загальний розмір',
    'budget_or_budgets'                             => ':count бюджет|:count бюджети',
    'budgets_with_limits'                           => ':count бюджет з налаштованою сумою|:count бюджетів з налаштованою сумою',
    'nr_of_rules_in_total_groups'                   => ':count_rules правило(а) у :count_groups групі(ах) правил',
    'tag_or_tags'                                   => ':count тег|:count теги',
    'configuration_updated'                         => 'Конфігурацію оновлено',
    'setting_is_demo_site'                          => 'Демо сайт',
    'setting_is_demo_site_explain'                  => 'Якщо ви відмітите цей ящик, то ця установка буде поводитися так, ніби це демо-сайт, який може мати дивні побічні ефекти.',
    'block_code_bounced'                            => 'Листа(і) повідомлення відправлені',
    'block_code_expired'                            => 'Термін демо-версії закінчився',
    'no_block_code'                                 => 'Немає причин для блокування або користувача не заблоковано',
    'demo_user_export'                              => 'Демо користувач не може експортувати дані',
    'block_code_email_changed'                      => 'Користувач ще не підтвердив нову адресу електронної пошти',
    'admin_update_email'                            => 'На відміну від сторінки профілю, користувач НЕ буде повідомлений про їхню електронну адресу!',
    'update_user'                                   => 'Оновити користувача',
    'updated_user'                                  => 'Дані користувача було змінено.',
    'delete_user'                                   => 'Видалити користувача :email',
    'user_deleted'                                  => 'Користувача видалено',
    'send_test_email'                               => 'Надіслати тестове повідомлення',
    'send_test_email_text'                          => 'To see if your installation is capable of sending a notification, please press this button. You will not see an error here (if any), <strong>the log files will reflect any errors</strong>. You can press this button as many times as you like. There is no spam control. The message will be sent to <code>:email</code> and should arrive shortly.',
    'send_message'                                  => 'Відправити повідомлення',
    'send_test_triggered'                           => 'Тест було запущено. Перевірте вхідні та файли журналу.',
    'give_admin_careful'                            => 'Користувачі, які надають права адміністратора, можуть забрати вас. Будьте обережні.',
    'admin_maintanance_title'                       => 'Ремонт',
    'admin_maintanance_expl'                        => 'Деякі тонкі кнопки для обслуговування Firefly III',
    'admin_maintenance_clear_cache'                 => 'Очистити кеш',
    'owner_notifications'                           => 'Сповіщення адміністратора',
    'owner_notifications_expl'                      => 'The following notifications can be enabled or disabled by the administrator. It will be sent over ALL configured channels. Some channels are configured in your environment variables, others can be set here.',
    'channel_settings'                              => 'Settings for notification channels',
    'notification_test_failed'                      => 'Notification test for channel ":channel" failed. The logs will have more details.',
    'notification_test_executed'                    => 'Notification test for channel ":channel" executed. Check your logs for details.',
    'settings_notifications'                        => 'Settings for notifications',
    'title_owner_notifications'                     => 'Сповіщення власника',
    'owner_notification_check_user_new_reg'         => 'User gets post-registration welcome message',
    'owner_notification_check_admin_new_reg'        => 'Administrator(s) get new user registration notification',
    'owner_notification_check_new_version'          => 'Доступна нова версія',
    'owner_notification_check_invite_created'       => 'Користувача запрошено до Firefly III',
    'owner_notification_check_invite_redeemed'      => 'A user invitation is redeemed',
    'owner_notification_check_unknown_user_attempt' => 'An unknown user tries to login',
    'all_invited_users'                             => 'Всі запрошені користувачі',
    'save_notification_settings'                    => 'Зберегти налаштування',
    'notification_settings'                         => 'Налаштування сповіщень',
    'notification_settings_saved'                   => 'Налаштування сповіщень були збережені',
    'available_channels_title'                      => 'Available channels',
    'available_channels_expl'                       => 'These channels are available to send notifications over. To test your configuration, use the buttons below. Please note that the buttons have no spam control.',
    'notification_channel_name_email'               => 'Електронна пошта',
    'slack_discord_double'                          => 'The Slack notification channel can also send notifications to Discord.',
    'notification_channel_name_slack'               => 'Slack',
    'notification_channel_name_ntfy'                => 'Ntfy.sh',
    'notification_channel_name_pushover'            => 'Pushover',
    'notification_channel_name_gotify'              => 'Gotify',
    'notification_channel_name_pushbullet'          => 'Pushbullet',
    'channel_not_available'                         => 'not available',
    'configure_channel_in_env'                      => 'needs environment variables',
    'test_notification_channel_name_email'          => 'Test email',
    'test_notification_channel_name_slack'          => 'Test Slack',
    'test_notification_channel_name_ntfy'           => 'Test Ntfy.sh',
    'test_notification_channel_name_pushover'       => 'Test Pushover',
    'test_notification_channel_name_gotify'         => 'Test Gotify',
    'test_notification_channel_name_pushbullet'     => 'Test Pushbullet',

    'split_transaction_title'               => 'Опис транзакції розділення',
    'split_transaction_title_help'          => 'Якщо ви створите розподілену транзакцію, то повинні бути глобальні описи для всіх розділених транзакцій.',
    'split_title_help'                      => 'Якщо ви створите розподілену транзакцію, то повинні бути глобальні описи для всіх розділених транзакцій.',
    'you_create_transfer'                   => 'Ви створюєте переказ.',
    'you_create_withdrawal'                 => 'Ви створюєте відкликання.',
    'you_create_deposit'                    => 'Ви створюєте депозит.',

    // links
    'journal_link_configuration'            => 'Конфігурація посилань на транзакції',
    'create_new_link_type'                  => 'Створити новий тип посилання',
    'store_new_link_type'                   => 'Зберегти новий тип посилання',
    'update_link_type'                      => 'Оновити тип посилання',
    'edit_link_type'                        => 'Редагувати тип посилання ":name"',
    'updated_link_type'                     => 'Оновлений тип посилання ":name"',
    'delete_link_type'                      => 'Видалити тип посилання ":name"',
    'deleted_link_type'                     => 'Видалено тип посилання ":name"',
    'stored_new_link_type'                  => 'Зберегти новий тип посилання ":name"',
    'cannot_edit_link_type'                 => 'Не можна редагувати тип посилання ":name"',
    'link_type_help_name'                   => 'Тобто, "Дублікат"',
    'link_type_help_inward'                 => 'Тобто, "дублікати"',
    'link_type_help_outward'                => 'Тобто, "дублікується за допомогою"',
    'save_connections_by_moving'            => 'Збережіть посилання між цими транзакціями, переміщаючи їх на інший тип посилання:',
    'do_not_save_connection'                => '(не зберігати підключення)',
    'link_transaction'                      => 'Транзакція посилання',
    'link_to_other_transaction'             => 'Прив\'язати цю операцію з іншою',
    'select_transaction_to_link'            => 'Select a transaction to link this transaction to. The links are currently unused in Firefly III (apart from being shown), but I plan to change this in the future. Use the search box to select a transaction either by title or by ID. If you want to add custom link types, check out the settings.',
    'this_transaction'                      => 'Ця операція',
    'transaction'                           => 'Транзакція',
    'comments'                              => 'Коментарі',
    'link_notes'                            => 'Будь-які нотатки, які ви хочете зберегти за допомогою посилання.',
    'invalid_link_selection'                => 'Неможливо зв\'язати ці операції',
    'selected_transaction'                  => 'Вибрана транзакція',
    'journals_linked'                       => 'Транзакції пов\'язані.',
    'journals_error_linked'                 => 'Ці операції вже пов\'язані.',
    'journals_link_to_self'                 => 'Не можна пов\'язати транзакцію з самим собою',
    'journal_links'                         => 'Пов\'язані транзакції',
    'this_withdrawal'                       => 'Виведення коштів',
    'this_deposit'                          => 'Цей депозит',
    'this_transfer'                         => 'Це перенесення',
    'overview_for_link'                     => 'Огляд для типу посилання ":name"',
    'source_transaction'                    => 'Вихідна транзакція',
    'link_description'                      => 'Опис посилання',
    'destination_transaction'               => 'Операція призначення',
    'delete_journal_link'                   => 'Видалити зв\'язок між <a href=":source_link">:source</a> і <a href=":destination_link">:destination</a>',
    'deleted_link'                          => 'Видалено посилання',

    // link translations:
    'Paid_name'                             => 'Сплачено',
    'Refund_name'                           => 'Повернути',
    'Reimbursement_name'                    => 'Відшкодування',
    'Related_name'                          => 'Схожі',
    'relates to_inward'                     => 'стосується',
    'is (partially) refunded by_inward'     => 'є (частково) повернено',
    'is (partially) paid for by_inward'     => 'є (частково) оплачено за',
    'is (partially) reimbursed by_inward'   => 'є (частково) компенсація',
    'inward_transaction'                    => 'Внутрішня транзакція',
    'outward_transaction'                   => 'Вихідна транзакція',
    'relates to_outward'                    => 'стосується',
    '(partially) refunds_outward'           => '(частково) повернень',
    '(partially) pays for_outward'          => '(частково) оплачує за',
    '(partially) reimburses_outward'        => '(частково) компенсації',
    'is (partially) refunded by'            => 'є (частково) повернено',
    'is (partially) paid for by'            => 'є (частково) оплачено за',
    'is (partially) reimbursed by'          => 'є (частково) компенсація',
    'relates to'                            => 'стосується',
    '(partially) refunds'                   => '(частково) повернень',
    '(partially) pays for'                  => '(частково) оплачує за',
    '(partially) reimburses'                => '(частково) компенсації',

    // split a transaction:
    'splits'                                => 'Розділення',
    'add_another_split'                     => 'Додати ще частину',
    'cannot_edit_opening_balance'           => 'Ви не можете редагувати початковий баланс рахунку.',
    'no_edit_multiple_left'                 => 'Ви обрали не дійсні транзакції для редагування.',
    'breadcrumb_convert_group'              => 'Перетворити транзакцію',
    'convert_invalid_source'                => 'Вихідна інформація є недійсною для транзакції #%d.',
    'convert_invalid_destination'           => 'Інформація про призначення недійсна для транзакції #%d.',
    'create_another'                        => 'Після збереження, повернутися сюди.',
    'after_update_create_another'           => 'Після оновлення поверніться сюди для продовження редагування.',
    'store_as_new'                          => 'Зберігати в якості нової операції, а не оновлювати.',
    'reset_after'                           => 'Очистити форму після ухвалення',
    'errors_submission'                     => 'Щось не так з вашою пропозицією. Будь ласка, перевірте помилки нижче.',
    'errors_submission_v2'                  => 'There was something wrong with your submission. Please check out the errors below: {{errorMessage}}',
    'transaction_expand_split'              => 'Розгорнути коло',
    'transaction_remove_split'              => 'Remove split',
    'transaction_collapse_split'            => 'Згорнути розділ',

    // object groups
    'default_group_title_name'              => '(ungrouped)',
    'default_group_title_name_plain'        => 'ungrouped',

    // empty lists? no objects? instructions:
    'no_accounts_title_asset'               => 'Створімо рахунок активів!',
    'no_accounts_intro_asset'               => 'Ви ще не маєте активів акцій. Облікові записи у ваших основних рахунках: ваш чековий рахунок, ощадний рахунок, спільний рахунок або навіть ваша кредитна картка.',
    'no_accounts_imperative_asset'          => 'Щоб розпочати використання Firefly III, ви повинні створити принаймні один рахунок активів. Давайте зробимо це зараз:',
    'no_accounts_create_asset'              => 'Створити обліковий запис медіафайлів',
    'no_accounts_title_expense'             => 'Створимо рахунок витрат!',
    'no_accounts_intro_expense'             => 'У вас поки що немає облікових записів. Рахунки витрат - це місця, де ви витрачаєте гроші, наприклад магазини та супермаркети.',
    'no_accounts_imperative_expense'        => 'Рахунки витрат створюються автоматично при створенні транзакцій, але якщо ви хочете створити їх вручну теж. Створімо одне зараз:',
    'no_accounts_create_expense'            => 'Створіть рахунок витрат',
    'no_accounts_title_revenue'             => 'Створімо нове джерело доходу!',
    'no_accounts_intro_revenue'             => 'У вас немає створених джерел доходів. Джерел доходів - це місця, де ви отримуєте гроші, напр. Ваш роботодавець, банківський депозит, рента тощо.',
    'no_accounts_imperative_revenue'        => 'Джерела доходів створюються автоматично під час створення транзакцій, але їх можна створити вручну теж. Створімо одне зараз? :',
    'no_accounts_create_revenue'            => 'Створити нове джерело доходу',
    'no_accounts_title_liabilities'         => 'Давайте створимо зобов\'язання!',
    'no_accounts_intro_liabilities'         => 'У вас поки що немає зобов\'язань. Доходи – це акаунти, які реєструють ваші (учні) позики та інші борги.',
    'no_accounts_imperative_liabilities'    => 'Ви не мусите використовувати цю функцію, але вона може бути корисною, якщо ви захочете відслідковувати ці речі.',
    'no_accounts_create_liabilities'        => 'Створити відповідальність',
    'no_budgets_title_default'              => 'Давайте створимо бюджет',
    'no_rules_title_default'                => 'Давайте створимо правило',
    'no_budgets_intro_default'              => 'У вас поки що немає бюджетів. Бюджети використовуються для організації ваших витрат у логічні групи, яким ви можете надати м’яке обмеження, щоб обмежити свої витрати.',
    'no_rules_intro_default'                => 'У вас поки немає правил. Правила - це потужна автоматизація, яка може обробляти транзакції для вас.',
    'no_rules_imperative_default'           => 'Правила можуть бути дуже корисними при управлінні транзакціями. Створімо один зараз:',
    'no_budgets_imperative_default'         => 'Бюджети - це основні інструменти фінансового управління. Створимо зараз:',
    'no_budgets_create_default'             => 'Створити бюджет',
    'no_rules_create_default'               => 'Створити правило',
    'no_categories_title_default'           => 'Створимо категорію!',
    'no_categories_intro_default'           => 'У вас поки що немає категорій. Категорії використовуються для налаштування ваших транзакцій і позначки їх з їх визначеною категорією.',
    'no_categories_imperative_default'      => 'Категорії створюються автоматично під час створення транзакцій, але ви можете створити і вручну. Зараз створимо:',
    'no_categories_create_default'          => 'Створити категорію',
    'no_tags_title_default'                 => 'Давайте створимо тег!',
    'no_tags_intro_default'                 => 'У вас поки що немає тегів. Теги використовуються для налаштування ваших транзакцій і позначки їх певними ключовими словами.',
    'no_tags_imperative_default'            => 'Теги створюються автоматично під час створення транзакцій, але ви можете створити і вручну. Давайте створимо заново:',
    'no_tags_create_default'                => 'Створити тег',
    'no_transactions_title_withdrawal'      => 'Давайте створимо витрат!',
    'no_transactions_intro_withdrawal'      => 'У вас поки що немає витрат. Ви повинні створити витрати, щоб почати керувати своїми фінансами.',
    'no_transactions_imperative_withdrawal' => 'Ти витратив трохи грошей? Тоді запишеш:',
    'no_transactions_create_withdrawal'     => 'Створити витрату',
    'no_transactions_title_deposit'         => 'Давайте створимо дохід!',
    'no_transactions_intro_deposit'         => 'У вас ще немає записаного доходу. Ви повинні створити записи в доходах, щоб почати управління вашими фінансами.',
    'no_transactions_imperative_deposit'    => 'Ви отримали трохи грошей? Тоді ви повинні записати наступне:',
    'no_transactions_create_deposit'        => 'Створити депозит',
    'no_transactions_title_transfers'       => 'Давайте створимо переказ!',
    'no_transactions_intro_transfers'       => 'У вас поки немає переказів. Коли ви переміщуєте гроші між рахунками активів, вони записуються як переказ.',
    'no_transactions_imperative_transfers'  => 'Ти переїхала трохи грошей? Тоді ти повинен написати:',
    'no_transactions_create_transfers'      => 'Створити переказ',
    'no_piggies_title_default'              => 'Давайте створимо скарбничку!',
    'no_piggies_intro_default'              => 'У вас поки що немає жодних скарбниць. Ви можете створити скарбниці, щоб розділити заощадження і відслідковувати ваші заощадження.',
    'no_piggies_imperative_default'         => 'У вас є речі, на які ви відкладаєте гроші? Створіть скарбничку і стежте за цим:',
    'no_piggies_create_default'             => 'Створити нову скарбничку',
    'no_bills_title_default'                => 'Let\'s create a subscription!',
    'no_bills_intro_default'                => 'You have no subscriptions yet. You can create subscriptions to keep track of regular expenses, like your rent or insurance.',
    'no_bills_imperative_default'           => 'Do you have such regular subscriptions? Create a subscription and keep track of your payments:',
    'no_bills_create_default'               => 'Створити підписку',

    // recurring transactions
    'recurrence_max_count'                  => 'This recurring transactions will be created at most :max time(s), and has been created :count time(s) already.',
    'create_right_now'                      => 'Створити прямо зараз',
    'no_new_transaction_in_recurrence'      => 'Немає нової трансакції. Можливо, вона вже була випущена за цю дату?',
    'recurrences'                           => 'Повторювані операції',
    'repeat_until_in_past'                  => 'Ця повторювана транзакція припинила повторювати :date.',
    'recurring_calendar_view'               => 'Календар',
    'no_recurring_title_default'            => 'Давайте створимо повторювану операцію!',
    'no_recurring_intro_default'            => 'У вас поки що немає повторюваних транзакцій. Ви можете використовувати їх для автоматичного створення транзакцій Firefly III.',
    'no_recurring_imperative_default'       => 'Це досить просунута функція, але вона може бути надзвичайно корисною. Переконайтеся, що ви прочитали документацію (?)-значок у верхньому правому кутку) перед продовженням.',
    'no_recurring_create_default'           => 'Створити повторювану операцію',
    'make_new_recurring'                    => 'Створити повторювану операцію',
    'recurring_daily'                       => 'Щодня',
    'recurring_weekly'                      => 'Щотижня в :weekday',
    'recurring_weekly_skip'                 => 'Кожного :skip(st/nd/rd/th) тижня у :weekday',
    'recurring_monthly'                     => 'Щомісяця в день :dayOfMonth(st/nd/rd/th)',
    'recurring_monthly_skip'                => 'Кожні :skip(st/nd/rd/th) місяць на :dayOfMonth(st/nd/rd/th) день',
    'recurring_ndom'                        => 'Щомісяця на :dayOfMonth(st/nd/rd/th) :weekday',
    'recurring_ndom_skip'                   => 'Every :skip(st/nd/rd/th) month on the :dayOfMonth(st/nd/rd/th) :weekday',
    'recurring_yearly'                      => 'Щороку на :date',
    'overview_for_recurrence'               => 'Огляд повторюваної транзакції ":title"',
    'warning_duplicates_repetitions'        => 'У рідкісних екземплярах дані з\'являються двічі в цьому списку. Може статися, коли кілька повторних відповідей зіткнуться. Firefly III завжди буде генерувати одну операцію на день.',
    'created_transactions'                  => 'Пов\'язані транзакції',
    'expected_withdrawals'                  => 'Очікувані витрати',
    'expected_deposits'                     => 'Очікувані депозити',
    'expected_transfers'                    => 'Очікувані перекази',
    'created_withdrawals'                   => 'Створено зняття коштів',
    'created_deposits'                      => 'Створені депозити',
    'created_transfers'                     => 'Створені перекази',
    'recurring_info'                        => 'Повторювана транзакція :count / :total',
    'created_from_recurrence'               => 'Створено з повторюваної транзакції ":title" (#:id)',
    'recurring_never_cron'                  => 'Здається, завдання з планувальника, необхідне для підтримки повторюваних транзакцій, ніколи не виконується. Це нормально, коли ви щойно встановили Firefly III, але це має бути щось для того, щоб якнайшвидше встановити. Будь ласка, перевірте сторінки довідки, використовуючи (?)-icon у верхньому правому куті сторінки.',
    'recurring_cron_long_ago'               => 'Схоже, що минуло більше 36 годин з моменту завдання cron для підтримки повторюваних транзакцій вистрілюється востаннє. Ви впевнені, що все налаштовано правильно? Будь ласка, перевірте сторінки довідки, використовуючи (?)-icon у верхньому правому куті сторінки.',

    'create_new_recurrence'              => 'Створити нову повторювану операцію',
    'help_first_date'                    => 'Вкажіть першу очікувану рекурсію. Це має бути в майбутньому.',
    'help_first_date_no_past'            => 'Вкажіть першу очікувану рекурсію Firefly III не створить угоди в минулому.',
    'no_currency'                        => '(немає валюти)',
    'mandatory_for_recurring'            => 'Обов\'язкова інформація повторення',
    'mandatory_for_transaction'          => 'Обов\'язкова інформація про транзакцію',
    'optional_for_recurring'             => 'Необов\'язкова інформація повторення',
    'optional_for_transaction'           => 'Необов\'язкова інформація про транзакцію',
    'change_date_other_options'          => 'Змініть "першу дату", щоб побачити більше параметрів.',
    'mandatory_fields_for_tranaction'    => 'Значення тут будуть використані у транзакціях, що створюються',
    'click_for_calendar'                 => 'Натисніть тут для календаря, який показує вас, коли транзакція буде повторена.',
    'repeat_forever'                     => 'Повторювати нескінченно',
    'repeat_until_date'                  => 'Повторювати до дати',
    'repeat_times'                       => 'Повторює кілька разів',
    'recurring_skips_one'                => 'Раз на плечі',
    'recurring_skips_more'               => 'Пропустити :count входження',
    'store_new_recurrence'               => 'Зберігати повторювану операцію',
    'stored_new_recurrence'              => 'Успішно збережено повторну транзакцію ":title".',
    'edit_recurrence'                    => 'Редагувати повторювану операцію ":title"',
    'recurring_repeats_until'            => 'Повторюється до :date',
    'recurring_repeats_forever'          => 'Повторює завжди',
    'recurring_repeats_x_times'          => 'Повторює :count раз|Повторює :count разів',
    'update_recurrence'                  => 'Оновити повторювану операцію',
    'updated_recurrence'                 => 'Оновлено повторювану транзакцію ":title"',
    'recurrence_is_inactive'             => 'Ця повторювана транзакція не активна і не буде генерувати нові операції.',
    'delete_recurring'                   => 'Видалити повторювану транзакцію ":title"',
    'new_recurring_transaction'          => 'Нова повторювана операція',
    'help_weekend'                       => 'Що робити Firefly III під час повторюваних транзакцій припадає на суботу чи неділю?',
    'do_nothing'                         => 'Просто створити транзакцію',
    'skip_transaction'                   => 'Пропустити',
    'jump_to_friday'                     => 'Створити транзакцію на попередню п\'ятницю, натомість',
    'jump_to_monday'                     => 'Створити транзакцію тільки в наступний понеділок',
    'will_jump_friday'                   => 'Буде створено у п\'ятницю замість вихідних.',
    'will_jump_monday'                   => 'Буде створено в понеділок замість вихідних.',
    'except_weekends'                    => 'За винятком вихідних',
    'recurrence_deleted'                 => 'Повторювану транзакцію ":title" видалено',


    // new lines for summary controller.
    'box_balance_in_currency'            => 'Баланс (:currency)',
    'box_spent_in_currency'              => 'Витрачено (:currency)',
    'box_earned_in_currency'             => 'Зароблено (:currency)',
    'box_budgeted_in_currency'           => 'Бюджет (:currency)',
    'box_bill_paid_in_currency'          => 'Subscriptions paid (:currency)',
    'box_bill_unpaid_in_currency'        => 'Subscriptions unpaid (:currency)',
    'box_left_to_spend_in_currency'      => 'Залишилося витратити (:currency)',
    'box_net_worth_in_currency'          => 'Чистий капітал (:currency)',
    'box_spend_per_day'                  => 'Залишилося витратити в день: :amount',

    // debug page
    'debug_page'                         => 'Debug page',
    'debug_submit_instructions'          => 'Якщо ви зіткнетесь з проблемами, ви можете використовувати цю інформацію в цьому полі як зневадження. Будь ласка, скопіюйте і вставте в нову чи існуючу <a href="https://github.com/firefly-iii/firefly-iii/issues">GitHub проблема</a>. Він створить красиву таблицю, яка буде використовуватися для швидкого діагностування вашої проблеми.',
    'debug_pretty_table'                 => 'Якщо ви скопіюєте / вставте поле нижче в проблему з GitHub, то він згенерує таблицю. Будь ласка, не об\'єднайте цей текст за допомогою backticks або лапки.',
    'debug_additional_data'              => 'Також ви можете поширити вміст нижченаведеного поля зображення. Ви також можете скопіювати і вставити це в нову чи існуючу <a href="https://github.com/firefly-iii/firefly-iii/issues">GitHub задачу</a>. Тим не менш, вміст цього ящика може містити приватну інформацію, таку як імена рахунків, дані транзакції або адреси електронної пошти.',

    // object groups
    'object_groups_menu_bar'             => 'Групи',
    'object_groups_page_title'           => 'Групи',
    'object_groups_breadcrumb'           => 'Групи',
    'object_groups_index'                => 'Огляд',
    'object_groups'                      => 'Групи',
    'object_groups_empty_explain'        => 'Деякі речі з Firefly III можуть бути розділені на групи. Наприклад, банки "Групи" з функцією "Групи" в редакції та створення екранів. Якщо ви встановите це поле, ви можете редагувати імена та порядок груп на цій сторінці. Для отримання додаткової інформації зверніться до довідкових сторінок у верхньому правому куті, під знаком (?).',
    'object_group_title'                 => 'Назва',
    'edit_object_group'                  => 'Редагувати групу ":title"',
    'delete_object_group'                => 'Видалити групу ":title"',
    'update_object_group'                => 'Оновити групу',
    'updated_object_group'               => 'Групу:title успішно оновлено',
    'deleted_object_group'               => 'Успішно видалена група ":title"',
    'object_group'                       => 'Група',

    // other stuff
    'placeholder'                        => '[Placeholder]',

    // audit log entries
    'audit_log_entries'                  => 'Журнал повідомлень',
    'ale_action_log_add'                 => 'Додано :amount до скарбнички ":name"',
    'ale_action_log_remove'              => 'Знято :amount зі скарбнички ":name"',
    'ale_action_clear_budget'            => 'Видалено з бюджету',
    'ale_action_update_group_title'      => 'Заголовок групи операцій оновлено',
    'ale_action_update_date'             => 'Дата операції',
    'ale_action_update_order'            => 'Оновлено замовлення',
    'ale_action_clear_category'          => 'Видалено з категорії',
    'ale_action_clear_notes'             => 'Вилучені нотатки',
    'ale_action_clear_tag'               => 'Видалено тег',
    'ale_action_clear_all_tags'          => 'Очищено всі теги',
    'ale_action_set_bill'                => 'Linked to subscription',
    'ale_action_switch_accounts'         => 'Перемикання облікового запису джерела і призначення',
    'ale_action_set_budget'              => 'Створити бюджет',
    'ale_action_set_category'            => 'Встановити категорію',
    'ale_action_set_source'              => 'Встановити вихідний обліковий запис',
    'ale_action_set_destination'         => 'Вказати обліковий запис призначення',
    'ale_action_update_transaction_type' => 'Змінений тип транзакції',
    'ale_action_update_notes'            => 'Змінені нотатки',
    'ale_action_update_description'      => 'Опис змінено',
    'ale_action_add_to_piggy'            => 'Скарбничка',
    'ale_action_remove_from_piggy'       => 'Скарбничка',
    'ale_action_add_tag'                 => 'Додано тег',
    'ale_action_update_amount'           => 'Updated amount',

    // dashboard
    'enable_auto_convert'                => 'Увімкнути перетворення валюти',
    'disable_auto_convert'               => 'Вимкнути перетворення валюти',
];
