<?php

/**
 * intro.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */



declare(strict_types=1);

return [
    // index
    'index_intro'                                                     => 'ยินดีต้อนรับสู่หน้าหลักของ Firefly III โปรดสละเวลาอ่านบทแนะนำนี้เพื่อทำความเข้าใจว่า Firefly III ทำงานอย่างไร',
    'index_accounts-chart'                                            => 'กราฟนี้แสดงยอดคงเหลือปัจจุบันของบัญชีสินทรัพย์ของคุณ คุณสามารถเลือกบัญชีที่แสดงได้ที่นี่ในการตั้งค่าของคุณ',
    'index_box_out_holder'                                            => 'กล่องเล็กๆ นี้และกล่องข้างๆ จะทำให้คุณเห็นภาพรวมโดยย่อเกี่ยวกับสถานการณ์ทางการเงินของคุณ',
    'index_help'                                                      => 'หากคุณต้องการความช่วยเหลือเกี่ยวกับหน้าหรือแบบฟอร์ม ให้กดปุ่มนี้',
    'index_outro'                                                     => 'หน้าเพจส่วนใหญ่ของ Firefly III จะเริ่มต้นด้วยการทัวร์เล็กๆ น้อยๆ แบบนี้ โปรดติดต่อฉันเมื่อคุณมีคำถามหรือความคิดเห็น Enjoy!',
    'index_sidebar-toggle'                                            => 'หากต้องการสร้างธุรกรรม บัญชี หรือสิ่งอื่นๆ ใหม่ ให้ใช้เมนูใต้ไอคอนนี้',
    'index_cash_account'                                              => 'นี่คือบัญชีที่สร้างขึ้นจนถึงตอนนี้ คุณสามารถใช้บัญชีเงินสดเพื่อติดตามค่าใช้จ่ายเงินสดได้ แต่ไม่ได้บังคับแน่นอน',

    // transactions
    'transactions_create_basic_info'                                  => 'ป้อนข้อมูลพื้นฐานของการทำธุรกรรมของคุณ อย่างเช่น แหล่งที่มา ปลายทาง วันที่ และคำอธิบาย',
    'transactions_create_amount_info'                                 => 'ป้อนจำนวนเงินของธุรกรรม หากจำเป็น ฟิลด์จะอัปเดตอัตโนมัติสำหรับข้อมูลจำนวนเงินต่างประเทศ',
    'transactions_create_optional_info'                               => 'ฟิลด์ทั้งหมดนี้ไม่จำเป็นต้องกรอก การเพิ่มข้อมูลเมตาที่นี่จะทำให้ธุรกรรมของคุณจัดระเบียบได้ดีขึ้น',
    'transactions_create_split'                                       => 'หากคุณต้องการแยกธุรกรรม ให้เพิ่มด้วยปุ่มนี้',

    // create account:
    'accounts_create_iban'                                            => 'ให้ IBAN ที่ถูกต้องแก่บัญชีของคุณ ซึ่งอาจทำให้การนำเข้าข้อมูลในอนาคตเป็นเรื่องง่ายมาก',
    'accounts_create_asset_opening_balance'                           => 'บัญชีสินทรัพย์อาจมี "ยอดดุลยกมา" ซึ่งบ่งบอกถึงจุดเริ่มต้นของประวัติของบัญชีนี้ใน Firefly III',
    'accounts_create_asset_currency'                                  => 'Firefly III รองรับหลายสกุลเงิน บัญชีสินทรัพย์จำเป็นต้องมีสกุลเงินหลักหนึ่งสกุล ซึ่งคุณต้องตั้งค่าที่นี่',
    'accounts_create_asset_virtual'                                   => 'บางครั้งการมอบยอดเสมือนให้กับบัญชีของคุณอาจช่วยได้: จำนวนเงินพิเศษจะถูกบวกเข้าหรือลบออกจากยอดจริงเสมอ',

    // budgets index
    'budgets_index_intro'                                             => 'งบประมาณใช้เพื่อจัดการการเงินของคุณคือหนึ่งในหน้าที่หลักของ Firefly III',
    'budgets_index_see_expenses_bar'                                  => 'การใช้จ่ายเงินจะค่อยๆทำให้แถบนี้เต็ม',
    'budgets_index_navigate_periods'                                  => 'เลื่อนไปตามช่วงเวลาเพื่อตั้งงบประมาณล่วงหน้าได้อย่างง่ายดาย',
    'budgets_index_new_budget'                                        => 'สร้างงบประมาณใหม่ตามที่คุณต้องการ',
    'budgets_index_list_of_budgets'                                   => 'ใช้ตารางนี้เพื่อกำหนดจำนวนเงินสำหรับงบประมาณแต่ละอย่างและดูว่าคุณใช้จ่ายไปแล้วเท่าไร',
    'budgets_index_outro'                                             => 'To learn more about budgeting, checkout the help icon in the top right corner.',



    // reports (index)
    'reports_index_intro'                                             => 'Use these reports to get detailed insights in your finances.',
    'reports_index_inputReportType'                                   => 'Pick a report type. Check out the help pages to see what each report shows you.',
    'reports_index_inputAccountsSelect'                               => 'You can exclude or include asset accounts as you see fit.',
    'reports_index_inputDateRange'                                    => 'The selected date range is entirely up to you: from one day to 10 years or more.',
    'reports_index_extra-options-box'                                 => 'Depending on the report you have selected, you can select extra filters and options here. Watch this box when you change report types.',

    // reports (reports)
    'reports_report_default_intro'                                    => 'This report will give you a quick and comprehensive overview of your finances. If you wish to see anything else, please don\'t hestitate to contact me!',
    'reports_report_audit_intro'                                      => 'This report will give you detailed insights in your asset accounts.',
    'reports_report_audit_optionsBox'                                 => 'Use these check boxes to show or hide the columns you are interested in.',

    'reports_report_category_intro'                                   => 'This report will give you insight in one or multiple categories.',
    'reports_report_category_pieCharts'                               => 'These charts will give you insight in expenses and income per category or per account.',
    'reports_report_category_incomeAndExpensesChart'                  => 'This chart shows your expenses and income per category.',

    'reports_report_tag_intro'                                        => 'This report will give you insight in one or multiple tags.',
    'reports_report_tag_pieCharts'                                    => 'These charts will give you insight in expenses and income per tag, account, category or budget.',
    'reports_report_tag_incomeAndExpensesChart'                       => 'This chart shows your expenses and income per tag.',

    'reports_report_budget_intro'                                     => 'This report will give you insight in one or multiple budgets.',
    'reports_report_budget_pieCharts'                                 => 'These charts will give you insight in expenses per budget or per account.',
    'reports_report_budget_incomeAndExpensesChart'                    => 'This chart shows your expenses per budget.',

    // create transaction
    'transactions_create_switch_box'                                  => 'Use these buttons to quickly switch the type of transaction you wish to save.',
    'transactions_create_ffInput_category'                            => 'You can freely type in this field. Previously created categories will be suggested.',
    'transactions_create_withdrawal_ffInput_budget'                   => 'Link your withdrawal to a budget for better financial control.',
    'transactions_create_withdrawal_currency_dropdown_amount'         => 'Use this dropdown when your withdrawal is in another currency.',
    'transactions_create_deposit_currency_dropdown_amount'            => 'Use this dropdown when your deposit is in another currency.',
    'transactions_create_transfer_ffInput_piggy_bank_id'              => 'Select a piggy bank and link this transfer to your savings.',

    // piggy banks index:
    'piggy-banks_index_saved'                                         => 'This field shows you how much you\'ve saved in each piggy bank.',
    'piggy-banks_index_button'                                        => 'Next to this progress bar are two buttons (+ and -) to add or remove money from each piggy bank.',
    'piggy-banks_index_accountStatus'                                 => 'For each asset account with at least one piggy bank the status is listed in this table.',



    // create piggy
    'piggy-banks_create_name'                                         => 'What is your goal? A new couch, a camera, money for emergencies?',
    'piggy-banks_create_date'                                         => 'You can set a target date or a deadline for your piggy bank.',

    // show piggy
    'piggy-banks_show_piggyChart'                                     => 'This chart will show the history of this piggy bank.',
    'piggy-banks_show_piggyDetails'                                   => 'Some details about your piggy bank',
    'piggy-banks_show_piggyEvents'                                    => 'Any additions or removals are also listed here.',

    // bill index
    'bills_index_rules'                                               => 'Here you see which rules will check if this subscription is hit',
    'bills_index_paid_in_period'                                      => 'This field indicates when the subscription was last paid.',
    'bills_index_expected_in_period'                                  => 'This field indicates for each subscription if and when the next subscription is expected to hit.',

    'subscriptions_index_rules'                                       => 'Here you see which rules will check if this subscription is hit',
    'subscriptions_index_paid_in_period'                              => 'This field indicates when the subscription was last paid.',
    'subscriptions_index_expected_in_period'                          => 'This field indicates for each subscription if and when the next subscription is expected to hit.',

    // show bill
    'bills_show_billInfo'                                             => 'This table shows some general information about this subscription.',
    'bills_show_billButtons'                                          => 'Use this button to re-scan old transactions so they will be matched to this subscription.',
    'bills_show_billChart'                                            => 'This chart shows the transactions linked to this subscription.',
    'subscriptions_show_billInfo'                                     => 'This table shows some general information about this subscription.',
    'subscriptions_show_billButtons'                                  => 'Use this button to re-scan old transactions so they will be matched to this subscription.',
    'subscriptions_show_billChart'                                    => 'This chart shows the transactions linked to this subscription.',

    // create bill
    'bills_create_intro'                                              => 'Use subscriptions to track the amount of money you\'re due every period. Think about expenses like rent, insurance or mortgage payments.',
    'bills_create_name'                                               => 'Use a descriptive name such as "Rent" or "Health insurance".',
    // 'bills_create_match'                                      => 'To match transactions, use terms from those transactions or the expense account involved. All words must match.',
    'bills_create_amount_min_holder'                                  => 'Select a minimum and maximum amount for this subscription.',
    'bills_create_repeat_freq_holder'                                 => 'Most subscriptions repeat monthly, but you can set another frequency here.',
    'bills_create_skip_holder'                                        => 'If a subscription repeats every 2 weeks, the "skip"-field should be set to "1" to skip every other week.',

    // rules index
    'rules_index_intro'                                               => 'Firefly III allows you to manage rules, that will automagically be applied to any transaction you create or edit.',
    'rules_index_new_rule_group'                                      => 'You can combine rules in groups for easier management.',
    'rules_index_new_rule'                                            => 'Create as many rules as you like.',
    'rules_index_prio_buttons'                                        => 'Order them any way you see fit.',
    'rules_index_test_buttons'                                        => 'You can test your rules or apply them to existing transactions.',
    'rules_index_rule-triggers'                                       => 'Rules have "triggers" and "actions" that you can order by drag-and-drop.',
    'rules_index_outro'                                               => 'Be sure to check out the help pages using the (?) icon in the top right!',

    // create rule:
    'rules_create_mandatory'                                          => 'Choose a descriptive title, and set when the rule should be fired.',
    'rules_create_ruletriggerholder'                                  => 'Add as many triggers as you like, but remember that ALL triggers must match before any actions are fired.',
    'rules_create_test_rule_triggers'                                 => 'Use this button to see which transactions would match your rule.',
    'rules_create_actions'                                            => 'Set as many actions as you like.',



    // preferences
    'preferences_index_tabs'                                          => 'More options are available behind these tabs.',

    // currencies
    'currencies_index_intro'                                          => 'Firefly III supports multiple currencies, which you can change on this page.',
    'currencies_index_default'                                        => 'Firefly III has one default currency.',
    'currencies_index_buttons'                                        => 'Use these buttons to change the default currency or enable other currencies.',

    // create currency
    'currencies_create_code'                                          => 'This code should be ISO compliant (Google it for your new currency).',
];
