<?php

/**
 * form.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */



declare(strict_types=1);

return [
    // new user:
    'administration_currency'      => 'Primary currency',
    'bank_name'                    => 'Bankens namn',
    'bank_balance'                 => 'Saldo',
    'current_balance'              => 'Current balance',
    'savings_balance'              => 'Sparesaldo',
    'credit_card_limit'            => 'Kredittkortgrense',
    'automatch'                    => 'Finn automatisk',
    'skip'                         => 'Hopp over',
    'enabled'                      => 'Aktivert',
    'name'                         => 'Namn',
    'active'                       => 'Aktiv',
    'amount_min'                   => 'Minimumsbeløp',
    'amount_max'                   => 'Maksimumsbeløp',
    'match'                        => 'Passar med',
    'strict'                       => 'Streng modus',
    'repeat_freq'                  => 'Gjentas',
    'object_group'                 => 'Gruppe',
    'location'                     => 'Sted',
    'update_channel'               => 'Oppdater kanal',
    'currency_id'                  => 'Valuta',
    'transaction_currency_id'      => 'Valuta',
    'auto_budget_currency_id'      => 'Valuta',
    'external_ip'                  => 'Serverens eksterne IP',
    'attachments'                  => 'Vedlegg',
    'BIC'                          => 'BIC',
    'verify_password'              => 'Bekreft passordsikkerhet',
    'source_account'               => 'Kjeldekonto',
    'destination_account'          => 'Målkonto',
    'asset_destination_account'    => 'Destinasjonskonto',
    'include_net_worth'            => 'Inkluder i formue',
    'asset_source_account'         => 'Kjeldekonto',
    'journal_description'          => 'Beskrivelse',
    'note'                         => 'Notat',
    'currency'                     => 'Valuta',
    'account_id'                   => 'Aktivakonto',
    'budget_id'                    => 'Budsjett',
    'bill_id'                      => 'Subscription',
    'opening_balance'              => 'Inngående balanse',
    'tag_mode'                      => 'Tag mode',
    'virtual_balance'              => 'Virtuell balanse',
    'run_after_form' => 'Run this rule',



    'targetamount'                 => 'Målbeløp',
    'target_amount'                => 'Target amount',
    'account_role'                 => 'Konto rolle',
    'opening_balance_date'         => 'Dato inngående saldo',
    'cc_type'                      => 'Betalingsplan for kredittkort',
    'cc_monthly_payment_date'      => 'Månadleg betalingsdato for kredittkort',
    'piggy_bank_id'                => 'Sparegris',
    'returnHere'                   => 'Gå tilbake hit',
    'returnHereExplanation'        => 'Gå tilbake hit etter lagring for å legga til på nytt.',
    'returnHereUpdateExplanation'  => 'Gå tilbake hit etter endring.',
    'description'                  => 'Beskriving',
    'expense_account'              => 'Utgiftskonto',
    'revenue_account'              => 'Inntektskonto',
    'decimal_places'               => 'Desimaler',
    'destination_amount'           => 'Beløp (destinasjon)',
    'new_email_address'            => 'Ny epostadresse',
    'verification'                 => 'Bekreftelse',
    'api_key'                      => 'API-nøkkel',
    'remember_me'                  => 'Husk meg',
    'liability_type_id'            => 'Gjeldstype',
    'liability_type'               => 'Gjeldstype',
    'interest'                     => 'Rente',
    'interest_period'              => 'Renteperiode',
    'extension_date'               => 'Dato for utsettelse',
    'type'                         => 'Type',
    'convert_Withdrawal'           => 'Konverter uttak',
    'convert_Deposit'              => 'Konverter innskot',
    'convert_Transfer'             => 'Konverter overføring',
    'amount'                       => 'Beløp',
    'foreign_amount'               => 'Utenlandske beløp',
    'date'                         => 'Dato',
    'interest_date'                => 'Rentedato',
    'book_date'                    => 'Bokføringsdato',
    'process_date'                 => 'Prosesseringsdato',
    'category'                     => 'Kategori',
    'tags'                         => 'Nøkkelord',
    'deletePermanently'            => 'Slett permanent',
    'cancel'                       => 'Avbryt',
    'targetdate'                   => 'Måldato',
    'target_date'                  => 'Target date',
    'startdate'                    => 'Startdato',
    'start_date'                   => 'Start date',
    'tag'                          => 'Nøkkelord',

    // exchange rates
    'from_currency_to_currency'    => '{from} &rarr; {to}',
    'to_currency_from_currency'    => '{to} &rarr; {from}',
    'rate'                         => 'Rate',

    'under'                        => 'Under',
    'symbol'                       => 'Symbol',
    'code'                         => 'Kode',
    'iban'                         => 'IBAN',
    'account_number'               => 'Kontonummer',
    'creditCardNumber'             => 'Kredittkortnummer',
    'has_headers'                  => 'Overskrifter',
    'date_format'                  => 'Datoformat',
    'attachments[]'                => 'Vedlegg',
    'title'                        => 'Tittel',
    'notes'                        => 'Notat',
    'filename'                     => 'Filnamn',
    'mime'                         => 'Mime-type',
    'size'                         => 'Størrelse',
    'trigger'                      => 'Utløser',
    'stop_processing'              => 'Stopp prosessering',
    'end_date'                     => 'End date',
    'enddate'                      => 'Sluttdato',
    'move_rules_before_delete'     => 'Regelgruppe',
    'start'                        => 'Start område',
    'end'                          => 'Slutt område',
    'delete_account'               => 'Slett konto ":name"',
    'delete_webhook'               => 'Slett webhook ":title',
    'delete_bill'                  => 'Delete subscription ":name"',
    'delete_budget'                => 'Slett budsjett ":name"',
    'delete_category'              => 'Slett kategori ":name"',
    'delete_currency'              => 'Slett valuta ":name"',
    'delete_journal'               => 'Slett transaksjon med beskriving ":description"',
    'delete_attachment'            => 'Slett vedlegg ":name"',
    'delete_rule'                  => 'Slett regel ":title"',
    'delete_rule_group'            => 'Slett regelgruppe ":title"',
    'delete_link_type'             => 'Slett lenkjetype ":name"',
    'delete_user'                  => 'Slett brukar ":email"',
    'delete_recurring'             => 'Slett gjentakande transaksjon ":title"',
    'user_areYouSure'              => 'Om du slettar brukaren ":email", vil alt verta vekke. Det er ikkje mogleg å angre eller gjenopprette brukaren. Om du slettar din eigen brukar, vil du miste tilgongen til Firefly III.',
    'attachment_areYouSure'        => 'Er du sikker på at du vil sletta vedlegget ved namn ":name"?',
    'account_areYouSure'           => 'Er du sikker på at du vil sletta brukaren ved namn ":name"?',
    'account_areYouSure_js'        => 'Er du sikker på at du vil sletta kontoen "{name}"?',
    'bill_areYouSure'              => 'Are you sure you want to delete the subscription named ":name"?',
    'rule_areYouSure'              => 'Er du sikker på at du vil sletta regelen ved namn ":title"?',
    'object_group_areYouSure'      => 'Er du sikker på at du vil sletta gruppen ved namn ":title"?',
    'ruleGroup_areYouSure'         => 'Er du sikker på at du vil sletta regelgruppen ved namn ":title"?',
    'budget_areYouSure'            => 'Er du sikker på at du vil sletta budsjettet ved namn ":name"?',
    'webhook_areYouSure'           => 'Er du sikker på at du vil sletta webhooken ved namn ":title"?',
    'category_areYouSure'          => 'Er du sikker på at du vil sletta kategorien ved namn ":name"?',
    'recurring_areYouSure'         => 'Er du sikker på at du vil sletta gjentakande transaksjonen ved namn ":title"?',
    'currency_areYouSure'          => 'Er du sikker på at du vil sletta valutaen ved namn ":name"?',
    'piggyBank_areYouSure'         => 'Er du sikker på at du vil sletta sparegrisen som heiter ":name"?',
    'journal_areYouSure'           => 'Er du sikker på at du vil sletta transaksjonen med beskriving ":description"?',
    'mass_journal_are_you_sure'    => 'Er du sikker på at du vil sletta desse transaksjonene?',



    'tag_areYouSure'               => 'Er du sikker på at du ønskar å sletta nøkkelordet «:tag»?',
    'journal_link_areYouSure'      => 'Er du sikker på at du vil sletta koblingen mellom <a href=":source_link">:source</a> og <a href=":destination_link">:destination</a>?',
    'linkType_areYouSure'          => 'Er du sikker på at du vil sletta koblingstypen ":name" (":inward" / ":outward")?',
    'permDeleteWarning'            => 'Sletting av data frå Firefly III er permanent, og kan ikkje angres.',
    'mass_make_selection'          => 'Du kan fortsatt forhindre at element slettes ved å fjerna avkrysningen.',
    'delete_all_permanently'       => 'Slett valde element permanent',
    'update_all_journals'          => 'Oppdater desse transaksjonene',
    'also_delete_transactions'     => 'Den ene transaksjonen som er kopla til denne kontoen, vil òg verta sletta. | Alle :count transaksjonar som er kopla til denne kontoen, slettes òg.',
    'also_delete_transactions_js'  => 'Ingen transaksjonar|Den einaste transaksjonen som er knytt til denne kontoen, vil òg verta sletta| Alle {count} transaksjonar som er kopla til denne kontoen vil verta sletta.',
    'also_delete_connections'      => 'Den ene transaksjonen som er knytt til denne koblingstypen, vil miste denne forbindelsen. | Alle :count transaksjonar knytt til denne koblingstypen vil miste forbindelsen.',
    'also_delete_rules'            => 'Den ene regelen som er knytt til denne regelgruppen, vil òg verta sletta. | Alle dei :count reglane som er knytt til denne regelgruppen slettes òg.',
    'also_delete_piggyBanks'       => 'Den eine sparegrisen som er kopla til denne kontoen vil og verta sletta. | Alle dei :count sparegrisane knytt til denne kontoen vert og sletta.',
    'also_delete_piggyBanks_js'    => 'Ingen sparegrisar|Den einaste sparegrisen som er knytt til denne kontoen vil og verta sletta.|Alle {count} sparegrisane som er kopla til denne kontoen vil og verta sletta.',
    'not_delete_piggy_banks'       => 'Sparegrisen som er knytt til denne gruppen vil ikkje verta sletta.| Dei :count sparegrisane som er kopla til denne gruppen vil ikkje verta sletta.',
    'bill_keep_transactions'       => 'The only transaction connected to this subscription will not be deleted.|All :count transactions connected to this subscription will be spared deletion.',
    'budget_keep_transactions'     => 'Ingen transaksjonar knytt til dette budsjettet vert sletta.|Ingen av dei :count transaksjonane knytt til dette budsjettet vil verta sletta.',
    'category_keep_transactions'   => 'Ingen transaksjonar knytt til denne kategorien vert sletta.|Ingen av dei :count transaksjonane knytt til denne kategorien vil verta sletta.',
    'recurring_keep_transactions'  => 'Ingen transaksjonar knytt til denne gjentakande transaksjonen vert sletta.|Ingen av dei :count transaksjonane knytt til denne gjentakande transaksjonen vil verta sletta.',
    'tag_keep_transactions'        => 'Den eine transaksjonen som knytt til dette nøkkelordet vert ikkje sletta.|Ingen av dei :count transaksjonane knytt til dette nøkkelordet vil verta sletta.',
    'check_for_updates'            => 'Sjå etter oppdateringar',
    'liability_direction'          => 'Gjeld inn/ut',
    'delete_object_group'          => 'Slett gruppe ":title"',
    'email'                        => 'Epostadresse',
    'password'                     => 'Passord',
    'password_confirmation'        => 'Passord (gjenta)',
    'blocked'                      => 'Er sperret?',
    'blocked_code'                 => 'Årsak til sperring',
    'login_name'                   => 'Logg inn',
    'is_owner'                     => 'Er admin?',
    'url'                          => 'Nettadresse',
    'bill_end_date'                => 'Sluttdato',

    // import
    'apply_rules'                  => 'Bruk reglar',
    'artist'                       => 'Artist',
    'album'                        => 'Album',
    'song'                         => 'Sang',

    // admin
    'domain'                       => 'Domene',
    'single_user_mode'             => 'Deaktiver brukarregistrering',
    'is_demo_site'                 => 'Er demonettsted',

    // import
    'configuration_file'           => 'Konfigurasjonsfil',
    'csv_comma'                    => 'Et komma (,)',
    'csv_semicolon'                => 'Et semikolon (;)',
    'csv_tab'                      => 'Ein tabulator (usynlig)',
    'csv_delimiter'                => 'CSV-feltskilleteikn',
    'client_id'                    => 'Klient-ID',
    'app_id'                       => 'App ID',
    'secret'                       => 'Hemmelegheit',
    'public_key'                   => 'Offentlig nøkkel',
    'country_code'                 => 'Landskode',
    'provider_code'                => 'Bank eller dataleverandør',
    'fints_url'                    => 'FinTS API URL',
    'fints_port'                   => 'Port',
    'fints_bank_code'              => 'Bankkode',
    'fints_username'               => 'Brukarnamn',
    'fints_password'               => 'PIN / Passord',
    'fints_account'                => 'FinTS konto',
    'local_account'                => 'Firefly III konto',



    'from_date'                    => 'Dato frå',
    'to_date'                      => 'Dato til',
    'due_date'                     => 'Forfallsdato',
    'payment_date'                 => 'Betalingsdato',
    'invoice_date'                 => 'Fakturadato',
    'internal_reference'           => 'Intern referanse',
    'inward'                       => 'Innvendig beskriving',
    'outward'                      => 'Utvendig beskriving',
    'rule_group_id'                => 'Regelgruppe',
    'transaction_description'      => 'Transaksjonsbeskriving',
    'first_date'                   => 'Første dato',
    'transaction_type'             => 'Transaksjonstype',
    'repeat_until'                 => 'Gjenta til',
    'recurring_description'        => 'Gjentakande transaksjonsbeskriving',
    'repetition_type'              => 'Type repetisjon',
    'foreign_currency_id'          => 'Utenlandsk valuta',
    'repetition_end'               => 'Repetisjon avsluttar',
    'repetitions'                  => 'Repetisjoner',
    'calendar'                     => 'Kalender',
    'weekend'                      => 'Helg',
    'client_secret'                => 'Klient Hemmelegheit',
    'withdrawal_destination_id'    => 'Målkonto',
    'deposit_source_id'            => 'Kjeldekonto',
    'expected_on'                  => 'Forventet den',
    'paid'                         => 'Betalt',
    'auto_budget_type'             => 'Auto-budsjett',
    'auto_budget_amount'           => 'Auto-budsjett beløp',
    'auto_budget_period'           => 'Auto-budsjett periode',
    'collected'                    => 'Innhentet',
    'submitted'                    => 'Innsendt',
    'key'                          => 'Nøkkel',
    'value'                        => 'Innhold i registeret',
    'webhook_delivery'             => 'Levering',
    'webhook_response'             => 'Respons',
    'webhook_trigger'              => 'Utløser',
    'pushover_app_token'           => 'Pushover app token',
    'pushover_user_token'          => 'Pushover user token',
    'ntfy_server'                  => 'Ntfy server',
    'ntfy_topic'                   => 'Ntfy topic',
    'ntfy_auth'                    => 'Ntfy authentication enabled',
    'ntfy_user'                    => 'Ntfy username',
    'ntfy_pass'                    => 'Ntfy password',
];
