<?php

/**
 * firefly.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

declare(strict_types=1);


return [
    // general stuff:
    'stored_in_tz'                              => 'stored in ":timezone"',
    'displayed_in_tz'                           => 'displayed in ":timezone"',
    'close'                                     => 'Lukk',
    'actions'                                   => 'Handlinger',
    'edit'                                      => 'Rediger',
    'loading'                                   => 'Loading',
    'transaction_journal_id'                    => 'Transaction journal ID',
    'delete'                                    => 'Slett',
    'split'                                     => 'Del opp',
    'single_split'                              => 'Del opp',
    'clone'                                     => 'Klon',
    'clone_and_edit'                            => 'Klon og rediger',
    'confirm_action'                            => 'Bekreft handling',
    'last_seven_days'                           => 'Syv siste dager',
    'last_thirty_days'                          => 'Tredve siste dager',
    'last_180_days'                             => 'Siste 180 dager',
    'month_to_date'                             => 'Måned til dato',
    'year_to_date'                              => 'År til dato',
    'YTD'                                       => 'Hittil i år',
    'welcome_back'                              => 'Hvordan går det?',
    'main_dashboard_page_title'                 => 'Home',
    'everything'                                => 'Alt',
    'today'                                     => 'i dag',
    'customRange'                               => 'Egendefinert utvalg',
    'date_range'                                => 'Datointervall',
    'apply'                                     => 'Bruk',
    'select_date'                               => 'Velg dato..',
    'cancel'                                    => 'Avbryt',
    'from'                                      => 'Fra',
    'to'                                        => 'Til',
    'structure'                                 => 'Struktur',
    'help_translating'                          => 'Denne hjelpeteksten er ikke tilgjengelig i ditt språk. <a href="https://crowdin.com/project/firefly-iii-help">Vil du hjelpe å oversette?</a>',
    'showEverything'                            => 'Vis alt',
    'never'                                     => 'Aldri',
    'no_results_for_empty_search'               => 'Søket ditt var tomt, så ingenting ble funnet.',
    'removed_amount'                            => 'Fjernet :amount',
    'added_amount'                              => 'La til :amount',
    'asset_account_role_help'                   => 'Eventuelle ekstra alternativer som følge av ditt valg kan settes senere.',
    'Opening balance'                           => 'Startsaldo',
    'create_new_stuff'                          => 'Lag nye ting',
    'new_withdrawal'                            => 'Nytt uttak',
    'create_new_transaction'                    => 'Opprett ny transaksjon',
    'sidebar_frontpage_create'                  => 'Opprett',
    'new_transaction'                           => 'Ny transaksjon',
    'no_rules_for_bill'                         => 'This subscription has no rules associated to it.',
    'go_to_asset_accounts'                      => 'Se aktivakontoene dine',
    'go_to_budgets'                             => 'Gå til budsjettene dine',
    'go_to_withdrawals'                         => 'Gå til uttakene dine',
    'clones_journal_x'                          => 'Denne transaksjonen er en klone av ":description" (#:id)',
    'go_to_categories'                          => 'Gå til kategoriene dine',
    'go_to_bills'                               => 'Go to your subscriptions',
    'go_to_expense_accounts'                    => 'Se utgiftskontoene dine',
    'go_to_revenue_accounts'                    => 'Se inntektskontoene dine',
    'go_to_piggies'                             => 'Gå til sparegrisene dine',
    'new_deposit'                               => 'Nytt innskudd',
    'new_transfer'                              => 'Ny overføring',
    'new_transfers'                             => 'Ny overføring',
    'new_asset_account'                         => 'Ny aktivakonto',
    'new_expense_account'                       => 'Ny utgiftskonto',
    'new_revenue_account'                       => 'Ny inntektskonto',
    'new_liabilities_account'                   => 'Ny gjeld',
    'new_budget'                                => 'Nytt budsjett',
    'new_bill'                                  => 'New subscription',
    'block_account_logout'                      => 'Du har blitt logget ut. Blokkerte kontoer kan ikke bruke dette nettstedet. Har du registrert deg med en gyldig e-postadresse?',
    'flash_success'                             => 'Suksess!',
    'flash_info'                                => 'Melding',
    'flash_warning'                             => 'Advarsel!',
    'flash_error'                               => 'Feil!',
    'flash_danger'                              => 'Fare!',
    'flash_info_multiple'                       => 'Det finnes én melding | Det finnes :count meldinger',
    'flash_error_multiple'                      => 'Det er én feil | Det er :count feil',
    'net_worth'                                 => 'Formue',
    'help_for_this_page'                        => 'Hjelp for denne siden',
    'help_for_this_page_body'                   => 'Du finner mer informasjon om denne siden <a href="https://docs.firefly-iii.org/">i dokumentasjonen</a>.',
    'two_factor_welcome'                        => 'Hallo!',
    'two_factor_enter_code'                     => 'Vennligst skriv inn tofaktorautentiseringskoden for å fortsette. Appen på telefonen kan generere den for deg.',
    'two_factor_code_here'                      => 'Skriv koden her',
    'two_factor_title'                          => 'To-faktor autentisering',
    'authenticate'                              => 'Autentisere',
    'two_factor_forgot_title'                   => 'Mistet tofaktorautentisering',
    'two_factor_forgot'                         => 'Jeg har glemt/mistet min tofaktor-ting.',
    'two_factor_lost_header'                    => 'Mistet tofaktorautentisering?',
    'two_factor_lost_intro'                     => 'Hvis du også har mistet sikkerhetskodene din, har du dårlig hell. Noe du ikke kan fikse fra webgrensesnittet. Du har to valg.',
    'two_factor_lost_fix_self'                  => 'If you run your own instance of Firefly III, read <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">this entry in the FAQ</a> for instructions.',
    'two_factor_lost_fix_owner'                 => 'Ellers sender du e-postadressen eieren, <a href="mailto::site_owner">:site_owner</a> og ber vedkommende om å tilbakestille tofaktorautentiseringen din.',
    'mfa_backup_code'                           => 'Du har brukt en sikkerhetskode for å logge inn i Firefly III. Den kan ikke brukes igjen, så kryss den fra listen din.',
    'pref_two_factor_new_backup_codes'          => 'Få nye sikkerhetskoder',
    'pref_two_factor_backup_code_count'         => 'Du har :count gyldige backup-koder. You have :count valid backup koder.',
    '2fa_i_have_them'                           => 'Jeg lagret dem!',
    'warning_much_data'                         => ':days dager med data kan ta litt tid å laste.',
    'registered'                                => 'Registreringen var vellykket!',
    'Default asset account'                     => 'Standard aktivakonto',
    'no_budget_pointer'                         => 'Det ser ikke ut til at du har noen budsjetter ennå. Du bør opprette noen på <a href="/budgets">budsjett</a>-siden. Budsjetter kan hjelpe deg med å holde oversikt over utgifter.',
    'no_bill_pointer'                           => 'You seem to have no subscription yet. You should create some on the <a href="subscriptions">subscription</a>-page. Subscriptions can help you keep track of expenses.',
    'Savings account'                           => 'Sparekonto',
    'Credit card'                               => 'Kredittkort',
    'source_accounts'                           => 'Kilde konto|Kildekontoer',
    'destination_accounts'                      => 'Destinasjonskonto(utgiftskonto)|Destinasjonskontoer',
    'user_id_is'                                => 'Din bruker-ID er <strong>:user</strong>',
    'field_supports_markdown'                   => 'Dette feltet støtter <a href="https://en.support.wordpress.com/markdown-quick-reference/">Markdown</a>.',
    'need_more_help'                            => 'Hvis du trenger mer hjelp med å bruke Firefly III, vennligst <a href="https://github.com/firefly-iii/firefly-iii/issues">opprett en sak på Github</a>.',
    'reenable_intro_text'                       => 'Du kan også reaktivere <a href="#" id="reenableGuidance">introduksjonsveiledningen</a>.',
    'intro_boxes_after_refresh'                 => 'Innføringsboksene vil dukke opp igjen når du laster siden på nytt.',
    'show_all_no_filter'                        => 'Vis alle transaksjoner uten å gruppere dem etter dato.',
    'expenses_by_category'                      => 'Utgifter etter kategori',
    'expenses_by_budget'                        => 'Utgifter etter budsjett',
    'income_by_category'                        => 'Inntekt etter kategori',
    'expenses_by_asset_account'                 => 'Utgifter etter aktivakonto',
    'expenses_by_expense_account'               => 'Expenses by destination account',
    'cannot_redirect_to_account'                => 'Firefly III kan ikke videresende deg til riktig side. Beklager.',
    'sum_of_expenses'                           => 'Sum av utgifter',
    'sum_of_income'                             => 'Sum av inntekt',
    'liabilities'                               => 'Gjeld',
    'spent_in_specific_budget'                  => 'Brukt i budsjett ":budget"',
    'spent_in_specific_double'                  => 'Brukt i konto ":account',
    'earned_in_specific_double'                 => 'Opptjent i konto ":account',
    'source_account'                            => 'Kildekonto',
    'source_account_reconciliation'             => 'Du kan ikke redigere kildekontoen for en avstemmingstransaksjon.',
    'destination_account'                       => 'Destinasjonskonto',
    'destination_account_reconciliation'        => 'Du kan ikke redigere kildekontoen for en avstemmingstransaksjon.',
    'sum_of_expenses_in_budget'                 => 'Brukt totalt i budsjett ":budget"',
    'left_in_budget_limit'                      => 'Igjen å bruke i følge budsjett',
    'current_period'                            => 'Nåværende periode',
    'show_the_current_period_and_overview'      => 'Vis gjeldende periode og oversikt',
    'pref_languages_locale'                     => 'For at et annet språk enn engelsk skal fungere skikkelig, må operativsystemet ditt være utstyrt med riktig lokalinformasjon. Hvis dette ikke er på plass, kan valutadata, datoer og beløp bli vist feil.',
    'budget_in_period'                          => 'Alle transaksjoner for budsjett ":name" mellom :start og :end i :currency',
    'chart_budget_in_period'                    => 'Diagram for alle transaksjoner for budsjett ":name" mellom :start og :end i :currency',
    'chart_budget_in_period_only_currency'      => 'Beløpet du budsjetterte var i :currency, så dette diagrammet vil bare vise transaksjoner i :currency.',
    'chart_account_in_period'                   => 'Diagram for alle transaksjoner for konto ":name" (:balance) mellom :start og :end',
    'chart_category_in_period'                  => 'Diagram for alle transaksjoner for kategori ":name" mellom :start og :end',
    'chart_category_all'                        => 'Graf over alle transaksjoner for kategori ":name"',
    'clone_withdrawal'                          => 'Klone dette uttaket',
    'clone_deposit'                             => 'Klone dette innskuddet',
    'clone_transfer'                            => 'Klone denne overføringen',
    'multi_select_no_selection'                 => 'Ingen valgt',
    'multi_select_select_all'                   => 'Velg alle',
    'multi_select_n_selected'                   => 'valgt',
    'multi_select_all_selected'                 => 'Alle valgte',
    'multi_select_filter_placeholder'           => 'Finn..',
    'intro_next_label'                          => 'Neste',
    'intro_prev_label'                          => 'Forrige',
    'intro_skip_label'                          => 'Hopp over',
    'intro_done_label'                          => 'Ferdig',
    'between_dates_breadcrumb'                  => 'Mellom :start og :end',
    'all_journals_without_budget'               => 'Alle transaksjoner uten budsjett',
    'journals_without_budget'                   => 'Transaksjoner uten budsjett',
    'all_journals_without_category'             => 'Alle ukategoriserte transaksjoner',
    'journals_without_category'                 => 'Ukategoriserte transaksjoner',
    'all_journals_for_account'                  => 'Alle transaksjoner for konto :name',
    'chart_all_journals_for_account'            => 'Graf over alle transaksjoner for konto :name',
    'journals_in_period_for_account'            => 'Alle transaksjoner for konto :name mellom :start og :end',
    'journals_in_period_for_account_js'         => 'Alle transaksjoner for konto {title} mellom {start} og {end}',
    'transferred'                               => 'Overført',
    'all_withdrawal'                            => 'Alle utgifter',
    'all_transactions'                          => 'Alle transaksjoner',
    'title_withdrawal_between'                  => 'Alle utgifter mellom :start og :end',
    'all_deposit'                               => 'Alle inntekter',
    'title_deposit_between'                     => 'Alle inntekter mellom :start og :end',
    'all_transfers'                             => 'Alle overføringer',
    'title_transfers_between'                   => 'Alle overføringer mellom :start og :end',
    'all_transfer'                              => 'Alle overføringer',
    'all_journals_for_tag'                      => 'Alle transaksjoner for tagg ":tag"',
    'title_transfer_between'                    => 'Alle overføringer mellom :start og :end',
    'all_journals_for_category'                 => 'Alle transaksjoner for kategori :name',
    'all_journals_for_budget'                   => 'Alle transaksjoner for budsjett :name',
    'chart_all_journals_for_budget'             => 'Graf over alle transaksjoner for budsjett :name',
    'journals_in_period_for_category'           => 'Alle transaksjoner for kategori :name mellom :start og :end',
    'journals_in_period_for_tag'                => 'Alle transaksjoner for tagg :tag mellom :start og :end',
    'not_available_demo_user'                   => 'Funksjonen du prøver å få tilgang til, er ikke tilgjengelig for demobrukere.',
    'exchange_rate_instructions'                => 'Asset account "@name" only accepts transactions in @primary_currency. If you wish to use @foreign_currency instead, make sure that the amount in @primary_currency is known as well:',
    'transfer_exchange_rate_instructions'       => 'Kildekonto "@source_name" godtar kun transaksjoner i @source_currency. Destinasjonskonto "@dest_name" aksepterer bare transaksjoner i @dest_currency. Du må angi overført beløp riktig i begge valutaene.',
    'transaction_data'                          => 'Transaksjonsdata',
    'invalid_server_configuration'              => 'Ugyldig serverkonfigurasjon',
    'invalid_locale_settings'                   => 'Firefly III is unable to format monetary amounts because your server is missing the required packages. There are <a href="https://docs.firefly-iii.org/how-to/firefly-iii/advanced/locales/">instructions how to do this</a>.',
    'quickswitch'                               => 'Hurtigbryter',
    'sign_in_to_start'                          => 'Logg inn for å starte økten',
    'sign_in'                                   => 'Logg inn',
    'register_new_account'                      => 'Registrer en ny konto',
    'forgot_my_password'                        => 'Jeg har glemt passordet mitt',
    'problems_with_input'                       => 'Det var noen problemer med utfyllingen din.',
    'reset_password'                            => 'Tilbakestill passordet ditt',
    'button_reset_password'                     => 'Tilbakestill passord',
    'reset_button'                              => 'Tilbakestill',
    'want_to_login'                             => 'Jeg vil logge inn',
    'login_page_title'                          => 'Innlogging til Firefly III',
    'register_page_title'                       => 'Registrer deg på Firefly III',
    'forgot_pw_page_title'                      => 'Glemt passord for Firefly III',
    'reset_pw_page_title'                       => 'Nullstill passord for Firefly III',
    'cannot_reset_demo_user'                    => 'Du kan ikke nustille passordet til demo bruker.',
    'no_att_demo_user'                          => 'Demo brukeren kan ikke laste opp vedlegg.',
    'button_register'                           => 'Registrer',
    'authorization'                             => 'Autorisasjon',
    'active_bills_only'                         => 'active subscription only',
    'active_bills_only_total'                   => 'all active subscriptions',
    'active_exp_bills_only'                     => 'active and expected subscriptions only',
    'active_exp_bills_only_total'               => 'all active expected subscriptions only',
    'per_period_sum_1D'                         => 'Forventede daglige kostnader',
    'per_period_sum_1W'                         => 'Forventede ukentlige kostnader',
    'per_period_sum_1M'                         => 'Forventede månedlige kostnader',
    'per_period_sum_3M'                         => 'Forventede kvartalskostnader',
    'per_period_sum_6M'                         => 'Forventede halvårlige kostnader',
    'per_period_sum_1Y'                         => 'Forventede årlige kostnader',
    'average_per_bill'                          => 'average per subscription',
    'expected_total'                            => 'forventet totalt',
    'reconciliation_account_name'               => ':name avstemming (:currency)',
    'saved'                                     => 'Lagret',
    'advanced_options'                          => 'Avanserte innstillinger',
    'advanced_options_explain'                  => 'Noen sider i Firefly III har gjemt avanserte alternativer bak denne knappen. Denne siden har ikke noe fancy, men sjekk ut de andre!',
    'here_be_dragons'                           => 'Her finnes drager',
    'bad_date_transaction'                      => 'Firefly III has detected you have transactions from before the year 1970. Please correct these transactions at your earliest convenience.',
    'anonymous_warning_on'                      => 'For your privacy, all amounts are now displayed as "zero". Warning: text input boxes may still show the original amounts!',
    'anonymous_warning_off'                     => 'Amounts will be visible again. Please be mindful of your surroundings.',

    // Webhooks
    'webhooks'                                  => 'Webhooks',
    'webhooks_breadcrumb'                       => 'Webhooks',
    'webhooks_menu_disabled'                    => 'disabled',
    'no_webhook_messages'                       => 'Ingen Webhook meldinger',
    'webhook_trigger_ANY'         => 'After any event',
    'webhook_trigger_STORE_TRANSACTION'         => 'Etter transaksjons opprettelse',
    'webhook_trigger_UPDATE_TRANSACTION'        => 'Etter transaksjons oppdatering',
    'webhook_trigger_DESTROY_TRANSACTION'       => 'Etter transaksjons sletting',
    'webhook_trigger_STORE_BUDGET'              => 'After budget creation',
    'webhook_trigger_UPDATE_BUDGET'             => 'After budget update',
    'webhook_trigger_DESTROY_BUDGET'            => 'After budget delete',
    'webhook_trigger_STORE_UPDATE_BUDGET_LIMIT' => 'After budgeted amount change',
    'webhook_response_TRANSACTIONS'             => 'Transaksjonsdetaljer',
    'webhook_response_ACCOUNTS'                 => 'Kontodetaljer',
    'webhook_response_BUDGET'                   => 'Budget details',
    'webhook_response_RELEVANT'                 => 'Relevant details',
    'webhook_response_NONE'                     => 'No details',
    'webhook_delivery_JSON'                     => 'JSON',
    'inspect'                                   => 'Inspiser',
    'create_new_webhook'                        => 'Opprett ny Webhook',
    'webhooks_create_breadcrumb'                => 'Opprett ny Webhook',
    'webhook_trigger_form_help'                 => 'Hvilken hendelse skal Webhook utløse',
    'webhook_response_form_help'                => 'Hva skal Webhook sende til URL.',
    'webhook_delivery_form_help'                => 'Hvilket format skal Webhook sende data i.',
    'webhook_active_form_help'                  => 'Webhook må aktiveres for å virke.',
    'stored_new_webhook'                        => 'Lagret ny webhook ":title"',
    'delete_webhook'                            => 'Slett Webhook',
    'deleted_webhook'                           => 'Slettet Webhook ":title"',
    'edit_webhook'                              => 'Rediger Webhook ":title"',
    'updated_webhook'                           => 'Oppdatert Webhook ":title"',
    'edit_webhook_js'                           => 'Rediger Webhook "{title}"',
    'show_webhook'                              => 'Webhook «:title»',
    'webhook_was_triggered'                     => 'Webhook ble trigget på den angitte transaksjonen. Vennligst vent på resultatet.',
    'webhook_messages'                          => 'Webhook melding',
    'view_message'                              => 'Vis melding',
    'view_attempts'                             => 'Vis mislykkede forsøk',
    'message_content_title'                     => 'Webhook meldingsinnhold',
    'message_content_help'                      => 'Dette er innholdet av meldingen som ble sendt (eller forsøkt sendt) med denne Webhook.',
    'attempt_content_title'                     => 'Webhook forsøk',
    'attempt_content_help'                      => 'Dette er alle mislykkede forsøk på denne webhook-meldingen som sendes til den konfigurerte URL-en. Etter en tid vil Firefly III slutte å prøve.',
    'no_attempts'                               => 'Det er ingen mislykkede forsøk. Det er god ting!',
    'webhook_attempt_at'                        => 'Forsøk på {moment}',
    'logs'                                      => 'Logger',
    'response'                                  => 'Respons',
    'visit_webhook_url'                         => 'Besøk URL til webhook',
    'reset_webhook_secret'                      => 'Tilbakestill Webhook nøkkel',
    'webhook_stored_link'                       => '<a href="webhooks/show/{ID}">Webhook #{ID} ("{title}")</a> er lagret.',
    'webhook_updated_link'                      => '<a href="webhooks/show/{ID}">Webhook #{ID}</a> ("{title}") er oppdatert.',

    // API access
    'authorization_request'                     => 'Firefly III v:version autorisasjonsforespørsel',
    'authorization_request_intro'               => 'Applikasjon "<strong>:client</strong>" ber om tilgang til din økonomiske administrasjon. Vil du tillate <strong>:client</strong> slik at den får tilgang til dine data?',
    'authorization_request_site'                => 'Du vil bli omdirigert til <code>:url</code> som da vil gi tilgang til dine Firefly III data.',
    'authorization_request_invalid'             => 'Ugyldig adgangsforespørsel. Vennligst ikke følg denne linken igjen.',
    'scopes_will_be_able'                       => 'Denne applikasjonen vil kunne:',
    'button_authorize'                          => 'Autoriser',
    'none_in_select_list'                       => '(ingen)',
    'no_piggy_bank'                             => '(ingen sparegriser)',
    'name_in_currency'                          => ':name i :currency',
    'paid_in_currency'                          => 'Betalt i :currency',
    'unpaid_in_currency'                        => 'Ubetalt i :currency',
    'is_alpha_warning'                          => 'Du kjører en ALPHA-versjon. Vær varsom for feil og problemer.',
    'is_beta_warning'                           => 'Du kjører en BETA-versjon. Vær varsom for bugs og problemer.',
    'all_destination_accounts'                  => 'Destinasjonskonto',
    'all_source_accounts'                       => 'Kildekontoer',
    'back_to_index'                             => 'Tilbake til index',
    'cant_logout_guard'                         => 'Firefly III kan ikke logge deg ut.',
    'internal_reference'                        => 'Intern referanse',

    // check for updates:
    'update_check_title'                        => 'Se etter oppdateringer',
    'admin_update_check_title'                  => 'Se etter oppdateringer automatisk',
    'admin_update_check_explain'                => 'Firefly III kan sjekke etter oppdateringer automatisk. Når du aktiverer denne innstillingen, vil systemet kontakte Github for å se om en ny versjon av Firefly III er tilgjengelig. Når det er kommet en ny oppdatering, vil du bli varslet. Du kan teste dette varselet ved hjelp av knappen til høyre. Vennligst marker nedenfor hvis du vil at Firefly III skal se etter oppdateringer.',
    'check_for_updates_permission'              => 'Firefly III can check for updates, but it needs your permission to do so. Please go to the <a href=":link">settings</a> to indicate if you would like this feature to be enabled.',
    'updates_ask_me_later'                      => 'Spør meg senere',
    'updates_do_not_check'                      => 'Ikke se etter oppdateringer',
    'updates_enable_check'                      => 'Aktiver oppdateringssjekk',
    'admin_update_check_now_title'              => 'Se etter oppdateringer nå',
    'admin_update_check_now_explain'            => 'Hvis du trykker på knappen, vil Firefly III se om din nåværende versjon er den nyeste.',
    'check_for_updates_button'                  => 'Sjekk nå!',
    'update_new_version_alert'                  => 'En ny versjon av Firefly III er tilgjengelig. Du kjører :your_version, den nyeste versjonen er :new_version som ble utgitt den :date.',
    'update_version_beta'                       => 'Dette er en BETA versjon, du kan oppleve problemer.',
    'update_version_alpha'                      => 'Dette er en ALPHA versjon, du kan oppleve problemer.',
    'update_current_dev_older'                  => 'You are running development release ":version", which is older than the latest release :new_version. Please update!',
    'update_current_dev_newer'                  => 'You are running development release ":version", which is newer than the latest release :new_version.',
    'update_current_version_alert'              => 'Du kjører :version, som er den nyeste tilgjengelige utgivelsen.',
    'update_newer_version_alert'                => 'Du kjører :your_version, som er nyere enn den nyeste versjonen, :new_version.',
    'update_check_error'                        => 'Det oppstod en feil under søk etter oppdatering: :error',
    'unknown_error'                             => 'Ukjent feil. Beklager det.',
    'disabled_but_check'                        => 'Du har deaktivert oppdateringssjekk. Ikke glem å oppdatere selv nå og da. Tusen takk!',
    'admin_update_channel_title'                => 'Oppdater kanal',
    'admin_update_channel_explain'              => 'Firefly III har tre oppdaterings "kanaler" som bestemmer hvor mye du ønsker å ligge foran med hensyn til funksjoner, forbedringer og feil. Bruk beta-kanalen dersom du er eventyrlysten og "alfa" når du liker å leve farlig.',
    'update_channel_stable'                     => 'Stable. Alt skal fungere som forventet.',
    'update_channel_beta'                       => 'Beta. Nye funksjoner, men kan ha enkelte programfeil.',
    'update_channel_alpha'                      => 'Alfa. Vi kaster ting i, og bruker det som fester seg.',

    // search
    'search'                                    => 'Søk',
    'search_query'                              => 'Spørring',
    'search_found_transactions'                 => 'Firefly III fant :count transaksjon på :time sekunder|Firefly III fant :count transaksjoner på :time sekunder.',
    'search_found_more_transactions'            => 'Firefly III fant mer enn :count transaksjoner på :time sekunder.',
    'search_for_overview'                       => 'Firefly III is searching for transactions that fulfill <b>all</b> of the following conditions:',
    'search_for_query'                          => 'All of these words must be present: <span class="text-info">:query</span>',
    'search_for_excluded_words'                 => 'None of these words may be present: <span class="text-info">:excluded_words</span>',
    'invalid_operators_list'                    => 'Disse søkeparametrene er ikke gyldige og ble ignorert.',

    // old


    'search_modifier_date_on'                             => 'Transaksjons dato er ":value"',
    'search_modifier_not_date_on'                         => 'Transaksjonsdato er ikke ":value"',
    'search_modifier_reconciled'                          => 'Transaksjonen er avstemt',
    'search_modifier_not_reconciled'                      => 'Transaksjonen er ikke avstemt',
    'search_modifier_id'                                  => 'Transaksjons ID er ":value"',
    'search_modifier_not_id'                              => 'Transaksjons ID er ikke ":value"',
    'search_modifier_date_before'                         => 'Transaksjonsdato er før eller på ":value"',
    'search_modifier_date_after'                          => 'Transaksjons dato er etter eller på ":value"',
    'search_modifier_external_id_is'                      => 'Ekstern ID er ":value"',
    'search_modifier_not_external_id_is'                  => 'Ekstern ID er ikke ":value"',
    'search_modifier_no_external_url'                     => 'Transaksjonen har ingen ekstern URL',
    'search_modifier_no_external_id'                      => 'Transaksjonen har ingen ekstern ID',
    'search_modifier_not_any_external_url'                => 'Transaksjonen har ingen ekstern URL',
    'search_modifier_not_any_external_id'                 => 'Transaksjonen har ingen ekstern ID',
    'search_modifier_any_external_url'                    => 'Transaksjonen må ha minst en ekstern URL',
    'search_modifier_any_external_id'                     => 'Transaksjonen må ha en (hvilken som helst) ekstern ID',
    'search_modifier_not_no_external_url'                 => 'Transaksjonen må ha en (hvilken som helst) ekstern URL',
    'search_modifier_not_no_external_id'                  => 'Transaksjonen må ha en (hvilken som helst) ekstern ID',
    'search_modifier_internal_reference_is'               => 'Intern referanse er ":value"',
    'search_modifier_not_internal_reference_is'           => 'Intern referanse er ikke ":value"',
    'search_modifier_description_starts'                  => 'Beskrivelsen begynner med ":value',
    'search_modifier_not_description_starts'              => 'Beskrivelsen starter ikke med ":value"',
    'search_modifier_description_ends'                    => 'Beskrivelsen slutter på ":value',
    'search_modifier_not_description_ends'                => 'Beskrivelsen slutter ikke på ":value',
    'search_modifier_description_contains'                => 'Beskrivelsen inneholder ":value"',
    'search_modifier_not_description_contains'            => 'Beskrivelsen inneholder ikke ":value',
    'search_modifier_description_is'                      => 'Beskrivelsen er nøyaktig ":value""',
    'search_modifier_not_description_is'                  => 'Beskrivelsen er nøyaktig ikke ":value',
    'search_modifier_currency_is'                         => 'Transaksjon (fremmed) valuta er ":value"',
    'search_modifier_not_currency_is'                     => 'Transaksjon (fremmed) valuta er ikke ":value"',
    'search_modifier_foreign_currency_is'                 => 'Transaksjonen for utenlansk valuta er ":value"',
    'search_modifier_not_foreign_currency_is'             => 'Transaksjonen fremmed valuta er ikke ":value"',
    'search_modifier_has_attachments'                     => 'Transaksjonen må ha minst ett vedlegg',
    'search_modifier_has_no_category'                     => 'Transaksjonen kan ikke ha noen kategori',
    'search_modifier_not_has_no_category'                 => 'Transaksjonen må ha en (hvilken som helst) kategori',
    'search_modifier_not_has_any_category'                => 'Transaksjonen må ikke ha noen kategori',
    'search_modifier_has_any_category'                    => 'Transaksjonen må ha en (noen) kategori(er)',
    'search_modifier_has_no_budget'                       => 'Transaksjonen må ikke ha noe budsjett',
    'search_modifier_not_has_any_budget'                  => 'Transaksjonen må ikke ha noe budsjett',
    'search_modifier_has_any_budget'                      => 'Transaksjonen må ha en (noen) kategori(er)',
    'search_modifier_not_has_no_budget'                   => 'Transaksjonen må ha et (hvilket som helst) budsjett',
    'search_modifier_has_no_bill'                         => 'The transaction must have no subscription',
    'search_modifier_not_has_no_bill'                     => 'The transaction must have a (any) subscription',
    'search_modifier_has_any_bill'                        => 'The transaction must have a (any) subscription',
    'search_modifier_not_has_any_bill'                    => 'The transaction must have no subscription',
    'search_modifier_has_no_tag'                          => 'Transaksjonen må ikke ha tagger',
    'search_modifier_not_has_any_tag'                     => 'Transaksjonen kan ikke ha tagger',
    'search_modifier_not_has_no_tag'                      => 'Transaksjonen må ha en (hvilken som helst) tagg',
    'search_modifier_has_any_tag'                         => 'Transaksjonen må ha minst en tagg',
    'search_modifier_notes_contains'                      => 'Transaksjons notater inneholder ":value"',
    'search_modifier_not_notes_contains'                  => 'Transaksjons notater inneholder ikke ":value',
    'search_modifier_notes_starts'                        => 'Transaksjons notat inneholder ":value"',
    'search_modifier_not_notes_starts'                    => 'Transaksjons notater starter ikke med ":value',
    'search_modifier_notes_ends'                          => 'Transaksjons notat ender med ":value"',
    'search_modifier_not_notes_ends'                      => 'Transaksjons notater slutter ikke med ":value',
    'search_modifier_notes_is'                            => 'Transaksjons notater er eksakt ":value"',
    'search_modifier_not_notes_is'                        => 'Transaksjons notater er nøyaktig ikke ":value',
    'search_modifier_no_notes'                            => 'Transaksjonen har ingen notater',
    'search_modifier_not_no_notes'                        => 'Transaksjonen må ha notater',
    'search_modifier_any_notes'                           => 'Transaksjonen må ha notater',
    'search_modifier_not_any_notes'                       => 'Transaksjonen har ingen notater',
    'search_modifier_amount_is'                           => 'Beløpet er nøyaktig :value',
    'search_modifier_not_amount_is'                       => 'Beløpet er ikke :value',
    'search_modifier_amount_less'                         => 'Beløpet er mindre enn eller lik :value',
    'search_modifier_not_amount_more'                     => 'Beløpet er mindre enn eller lik :value',
    'search_modifier_amount_more'                         => 'Beløpet er mer enn eller lik :value',
    'search_modifier_not_amount_less'                     => 'Beløpet er mer enn eller lik :value',
    'search_modifier_source_account_is'                   => 'Kilde konto er eksakt ":value"',
    'search_modifier_not_source_account_is'               => 'Kildekonto navn er ikke ":value"',
    'search_modifier_source_account_contains'             => 'Kildekonto navn inneholder ":value"',
    'search_modifier_not_source_account_contains'         => 'Kildekonto navn inneholder ikke ":value"',
    'search_modifier_source_account_starts'               => 'Kildekonto navn starter med ":value"',
    'search_modifier_not_source_account_starts'           => 'Kildekonto navn starter ikke med ":value"',
    'search_modifier_source_account_ends'                 => 'Kild konto navn slutter med ":value"',
    'search_modifier_not_source_account_ends'             => 'Kildekonto navn slutter ikke med ":value"',
    'search_modifier_source_account_id'                   => 'Kildekonto ID er :value',
    'search_modifier_not_source_account_id'               => 'Kildekonto ID er ikke :value',
    'search_modifier_source_account_nr_is'                => 'Kilde kontonummer (IBAN) er ":value"',
    'search_modifier_not_source_account_nr_is'            => 'Kildekonto nummer (IBAN) er ikke ":value"',
    'search_modifier_source_account_nr_contains'          => 'Kilde kontonummer (IBAN) inneholder ":value"',
    'search_modifier_not_source_account_nr_contains'      => 'Kildekonto nummer (IBAN) inneholder ikke ":value"',
    'search_modifier_source_account_nr_starts'            => 'Kilde kontonummer (IBAN) starter med ":value"',
    'search_modifier_not_source_account_nr_starts'        => 'Kildekonto nummer (IBAN) starter ikke med ":value"',
    'search_modifier_source_account_nr_ends'              => 'Kildekonto nummer (IBAN) slutter på ":value"',
    'search_modifier_not_source_account_nr_ends'          => 'Kildekonto nummer (IBAN) slutter ikke på ":value"',
    'search_modifier_destination_account_is'              => 'Målkontonavn er eksakt ":value"',
    'search_modifier_not_destination_account_is'          => 'Målkonto navn er ikke ":value"',
    'search_modifier_destination_account_contains'        => 'Målkontonavnet inneholder ":value"',
    'search_modifier_not_destination_account_contains'    => 'Målkonto navn inneholder ikke ":value"',
    'search_modifier_destination_account_starts'          => 'Målkontonavnet starter med ":value"',
    'search_modifier_not_destination_account_starts'      => 'Målkonto navn starter ikke med ":value"',
    'search_modifier_destination_account_ends'            => 'Målkonto navn slutter på ":value"',
    'search_modifier_not_destination_account_ends'        => 'Målkonto navn slutter ikke på ":value"',
    'search_modifier_destination_account_id'              => 'Målkonto ID er :value',
    'search_modifier_not_destination_account_id'          => 'Målkonto ID er ikke :value',
    'search_modifier_destination_is_cash'                 => 'Målkonto er "(cash)"-kontoen',
    'search_modifier_not_destination_is_cash'             => 'Målkonto er ikke "(cash)"-kontoen',
    'search_modifier_source_is_cash'                      => 'Kildekonto er "(cash)"-kontoen',
    'search_modifier_not_source_is_cash'                  => 'Kildekonto er ikke "(cash)"-kontoen',
    'search_modifier_destination_account_nr_is'           => 'Målkontonummer (IBAN) er ":value"',
    'search_modifier_not_destination_account_nr_is'       => 'Målkonto nummer (IBAN) er ":value"',
    'search_modifier_destination_account_nr_contains'     => 'Målkontonummer (IBAN) inneholder ":value"',
    'search_modifier_not_destination_account_nr_contains' => 'Målkonto nummer (CIBAN) inneholder ikke ":value"',
    'search_modifier_destination_account_nr_starts'       => 'Målkontonummer (CIBAN) starter med ":value"',
    'search_modifier_not_destination_account_nr_starts'   => 'Målkonto nummer (CIBAN) starter ikke med ":value"',
    'search_modifier_destination_account_nr_ends'         => 'Kildekontonummer (IBAN) slutter med ":value"',
    'search_modifier_not_destination_account_nr_ends'     => 'Målkonto nummer (CIBAN) ender ikke med ":value"',
    'search_modifier_account_id'                          => 'Kilde eller målkonto-IDer er: :value',
    'search_modifier_not_account_id'                      => 'Kilde eller målkonto ID er/er ikke: :value',
    'search_modifier_category_is'                         => 'Kategorien er ":value"',
    'search_modifier_not_category_is'                     => 'Kategorien er ikke ":value"',
    'search_modifier_budget_is'                           => 'Budsjettet er ":value"',
    'search_modifier_not_budget_is'                       => 'Budsjettet er ikke ":value"',
    'search_modifier_bill_is'                             => 'Subscription is ":value"',
    'search_modifier_not_bill_is'                         => 'Subscription is not ":value"',
    'search_modifier_transaction_type'                    => 'Transaksjonstype er ":value"',
    'search_modifier_not_transaction_type'                => 'Transaksjonstype er ikke ":value"',
    'search_modifier_tag_is'                              => 'Taggen er ":value"',
    'search_modifier_tag_contains'                        => 'Tag contains ":value"',
    'search_modifier_not_tag_contains'                    => 'Tag does not contain ":value"',
    'search_modifier_tag_ends'                            => 'Tag ends with ":value"',
    'search_modifier_tag_starts'                          => 'Tag starts with ":value"',
    'search_modifier_not_tag_is'                          => 'Ingen tagg er ":value"',
    'search_modifier_date_on_year'                        => 'Transaksjonen er i år ":value"',
    'search_modifier_not_date_on_year'                    => 'Transaksjonen er ikke i året ":value"',
    'search_modifier_date_on_month'                       => 'Transaksjonen er i måned ":value"',
    'search_modifier_not_date_on_month'                   => 'Transaksjonen er ikke i måneden ":value"',
    'search_modifier_date_on_day'                         => 'Transaksjonen er på dagen i måneden ":value"',
    'search_modifier_not_date_on_day'                     => 'Transaksjonen er ikke på dagen for måned ":value"',
    'search_modifier_date_before_year'                    => 'Transaksjonen er før eller i år ":value"',
    'search_modifier_date_before_month'                   => 'Transaksjonen er før eller i måned ":value"',
    'search_modifier_date_before_day'                     => 'Transaksjonen er før eller på dagen i måned ":value"',
    'search_modifier_date_after_year'                     => 'Transaksjonen er i eller etter år ":value"',
    'search_modifier_date_after_month'                    => 'Transaksjonen er i eller etter måned ":value"',
    'search_modifier_date_after_day'                      => 'Transaksjonen er etter eller på dagen i måned ":value"',

    // new
    'search_modifier_tag_is_not'                          => 'Ingen tagg er ":value"',
    'search_modifier_not_tag_is_not'                      => 'Taggen er ":value"',
    'search_modifier_account_is'                          => 'Alle kontoene er ":value"',
    'search_modifier_not_account_is'                      => 'Ingen av kontoene er ":value"',
    'search_modifier_account_contains'                    => 'Alle kontoene inneholder ":value"',
    'search_modifier_not_account_contains'                => 'Ingen av kontoene inneholder ":value"',
    'search_modifier_account_ends'                        => 'Alle kontoenene slutter med ":value"',
    'search_modifier_not_account_ends'                    => 'Ingen av kontoene slutter med ":value"',
    'search_modifier_account_starts'                      => 'Alle kontoene starter med ":value"',
    'search_modifier_not_account_starts'                  => 'Ingen av kontoene begynner med ":value"',
    'search_modifier_account_nr_is'                       => 'Alle kontonummer / IBAN er ":value"',
    'search_modifier_not_account_nr_is'                   => 'Ingen kontonummer / IBAN er ":value"',
    'search_modifier_account_nr_contains'                 => 'Alle kontonummer / IBAN inneholder ":value"',
    'search_modifier_not_account_nr_contains'             => 'Ingen kontonummer / IBAN inneholder ":value"',
    'search_modifier_account_nr_ends'                     => 'Alle kontonummer / IBAN slutter med ":value"',
    'search_modifier_not_account_nr_ends'                 => 'Ingen kontonummer / IBAN slutter med ":value"',
    'search_modifier_account_nr_starts'                   => 'Alle kontonummer / IBAN starter med ":value"',
    'search_modifier_not_account_nr_starts'               => 'Ingen kontonummer / IBAN starter med ":value"',
    'search_modifier_category_contains'                   => 'Kategorien inneholder ":value"',
    'search_modifier_not_category_contains'               => 'Kategorien inneholder ikke ":value"',
    'search_modifier_category_ends'                       => 'Kategorien slutter på ":value"',
    'search_modifier_not_category_ends'                   => 'Kategorien slutter ikke på ":value"',
    'search_modifier_category_starts'                     => 'Kategorien starter med ":value"',
    'search_modifier_not_category_starts'                 => 'Kategorien starter ikke med ":value"',
    'search_modifier_budget_contains'                     => 'Budsjettet inneholder ":value"',
    'search_modifier_not_budget_contains'                 => 'Budsjettet inneholder ikke ":value"',
    'search_modifier_budget_ends'                         => 'Budsjettet slutter med ":value"',
    'search_modifier_not_budget_ends'                     => 'Budsjettet slutter ikke på ":value"',
    'search_modifier_budget_starts'                       => 'Budsjettet begynner med ":value"',
    'search_modifier_not_budget_starts'                   => 'Budsjettet starter ikke med ":value"',
    'search_modifier_bill_contains'                       => 'Subscription contains ":value"',
    'search_modifier_not_bill_contains'                   => 'Subscription does not contain ":value"',
    'search_modifier_bill_ends'                           => 'Subscription ends with ":value"',
    'search_modifier_not_bill_ends'                       => 'Subscription does not end on ":value"',
    'search_modifier_bill_starts'                         => 'Subscription starts with ":value"',
    'search_modifier_not_bill_starts'                     => 'Subscription does not start with ":value"',
    'search_modifier_external_id_contains'                => 'Ekstern ID inneholder ":value"',
    'search_modifier_not_external_id_contains'            => 'Ekstern ID inneholder ikke ":value"',
    'search_modifier_external_id_ends'                    => 'Ekstern ID slutter med ":value"',
    'search_modifier_not_external_id_ends'                => 'Ekstern ID slutter ikke med ":value"',
    'search_modifier_external_id_starts'                  => 'Ekstern ID starter med ":value"',
    'search_modifier_not_external_id_starts'              => 'Ekstern ID starter ikke med ":value"',
    'search_modifier_internal_reference_contains'         => 'Intern referanse inneholder ":value"',
    'search_modifier_not_internal_reference_contains'     => 'Intern referanse inneholder ikke ":value"',
    'search_modifier_internal_reference_ends'             => 'Intern referanse slutter med ":value"',
    'search_modifier_internal_reference_starts'           => 'Intern referanse starter med ":value"',
    'search_modifier_not_internal_reference_ends'         => 'Intern referanse slutter ikke med ":value"',
    'search_modifier_not_internal_reference_starts'       => 'Intern referanse begynner ikke med ":value"',
    'search_modifier_external_url_is'                     => 'Ekstern URL er ":value"',
    'search_modifier_not_external_url_is'                 => 'Ekstern URL er ikke ":value"',
    'search_modifier_external_url_contains'               => 'Ekstern URL inneholder ":value"',
    'search_modifier_not_external_url_contains'           => 'Ekstern URL inneholder ikke ":value"',
    'search_modifier_external_url_ends'                   => 'Ekstern URL slutter med ":value"',
    'search_modifier_not_external_url_ends'               => 'Ekstern URL slutter ikke med ":value"',
    'search_modifier_external_url_starts'                 => 'Ekstern URL starter med ":value"',
    'search_modifier_not_external_url_starts'             => 'Ekstern URL starter ikke med ":value"',
    'search_modifier_has_no_attachments'                  => 'Transaksjonen har ingen vedlegg',
    'search_modifier_not_has_no_attachments'              => 'Transaksjonen har vedlegg',
    'search_modifier_not_has_attachments'                 => 'Transaksjonen har ingen vedlegg',
    'search_modifier_account_is_cash'                     => 'Alle konti er "(cash)"-konto.',
    'search_modifier_not_account_is_cash'                 => 'Ingen konti er "(cash)"-kontoen.',
    'search_modifier_journal_id'                          => 'Journal ID er ":value"',
    'search_modifier_not_journal_id'                      => 'Journal ID er ikke ":value"',
    'search_modifier_recurrence_id'                       => 'Den gjentakende transaksjons ID er ":value"',
    'search_modifier_not_recurrence_id'                   => 'Den gjentakende transaksjons ID er ikke ":value"',
    'search_modifier_foreign_amount_is'                   => 'Det utenlandske beløpet er ":value"',
    'search_modifier_not_foreign_amount_is'               => 'Det utenlandske beløpet er ikke ":value"',
    'search_modifier_foreign_amount_less'                 => 'Det utenlandske beløpet er mindre enn ":value"',
    'search_modifier_not_foreign_amount_more'             => 'Det utenlandske beløpet er mindre enn ":value"',
    'search_modifier_not_foreign_amount_less'             => 'Det utenlandske beløpet er mer enn ":value"',
    'search_modifier_foreign_amount_more'                 => 'Det utenlandske beløpet er mer enn ":value"',
    'search_modifier_exists'                              => 'Transaksjon eksisterer (hvilken som helst transaksjon)',
    'search_modifier_not_exists'                          => 'Transaksjonen eksisterer ikke (alle transaksjoner)',

    // date fields
    'search_modifier_interest_date_on'                    => 'Transaksjonens rentedato er ":value"',
    'search_modifier_not_interest_date_on'                => 'Transaksjonens rentedato er ikke ":value"',
    'search_modifier_interest_date_on_year'               => 'Transaksjonsrentens dato er i år ":value"',
    'search_modifier_not_interest_date_on_year'           => 'Transaksjonens rentedato er ikke i år ":value"',
    'search_modifier_interest_date_on_month'              => 'Transaksjonsrentens dato er i måned ":value"',
    'search_modifier_not_interest_date_on_month'          => 'Transaksjonens rentedato er ikke i måned ":value"',
    'search_modifier_interest_date_on_day'                => 'Transaksjonsrentens dato er på dagen i måned ":value"',
    'search_modifier_not_interest_date_on_day'            => 'Transaksjonens rentedato er ikke på dag i måned ":value"',
    'search_modifier_interest_date_before_year'           => 'Transaksjonsrentens dato er før eller i år ":value"',
    'search_modifier_interest_date_before_month'          => 'Transaksjonsrentens dato er før eller i måned ":value"',
    'search_modifier_interest_date_before_day'            => 'Transaksjonsrentenedato er før eller på dagen i måned ":value',
    'search_modifier_interest_date_after_year'            => 'Transaksjonsrentens dato er etter eller i år ":value"',
    'search_modifier_interest_date_after_month'           => 'Transaksjonsrentens dato er etter eller i måned ":value"',
    'search_modifier_interest_date_after_day'             => 'Transaksjonsrentens dato er etter eller på dagen i måned ":value',
    'search_modifier_book_date_on_year'                   => 'Bokføringsdato for transaksjonen er i år ":value"',
    'search_modifier_book_date_on_month'                  => 'Bokføringsdato for transaksjonen er i måned ":value"',
    'search_modifier_book_date_on_day'                    => 'Bokføringsdato for transaksjonen er på dagen i måned ":value"',
    'search_modifier_not_book_date_on_year'               => 'Bokføringsdato for transaksjonen er ikke i år ":value"',
    'search_modifier_not_book_date_on_month'              => 'Bokføringsdato for transaksjonen er ikke i måned ":value"',
    'search_modifier_not_book_date_on_day'                => 'Bokføringsdato for transaksjonen er ikke på dag i måned ":value"',
    'search_modifier_book_date_before_year'               => 'Transaksjons bokdato er før eller i år ":value"',
    'search_modifier_book_date_before_month'              => 'Bokføringsdato for transaksjonen er før eller i måned ":value"',
    'search_modifier_book_date_before_day'                => 'Bokføringsdato for transaksjonen er før eller på dagen i måned ":value"',
    'search_modifier_book_date_after_year'                => 'Bokføringsdato for transaksjonen er etter eller i år ":value"',
    'search_modifier_book_date_after_month'               => 'Bokføringsdato for transaksjonen er etter eller i måned ":value"',
    'search_modifier_book_date_after_day'                 => 'Bokføringsdato for transaksjonen er etter eller på dagen i måned ":value"',
    'search_modifier_process_date_on_year'                => 'Transaksjonsprosessdato er i år ":value"',
    'search_modifier_process_date_on_month'               => 'Transaksjonsprosessdato er i måned ":value"',
    'search_modifier_process_date_on_day'                 => 'Transaksjonsprosessdato er på dagen i måned ":value"',
    'search_modifier_not_process_date_on_year'            => 'Transaksjonens utførelsesdato er ikke i år ":value"',
    'search_modifier_not_process_date_on_month'           => 'Transaksjonens utførelsesdato er ikke i måned ":value"',
    'search_modifier_not_process_date_on_day'             => 'Transaksjonen er ikke på dagen for måned ":value',
    'search_modifier_process_date_before_year'            => 'Transaksjonsprosessdato er før eller i år ":value"',
    'search_modifier_process_date_before_month'           => 'Transaksjonsdato er før eller i måned ":value"',
    'search_modifier_process_date_before_day'             => 'Transaksjonsprosessdato er før eller på dagen i måned ":value"',
    'search_modifier_process_date_after_year'             => 'Transaksjonsprosessdato er etter eller i år ":value"',
    'search_modifier_process_date_after_month'            => 'Transaksjonsprosessdato er etter eller i måned ":value"',
    'search_modifier_process_date_after_day'              => 'Transaksjonsprosessdato er etter eller på dagen i måned ":value',
    'search_modifier_due_date_on_year'                    => 'Forfallsdato for transaksjonen er i år ":value"',
    'search_modifier_due_date_on_month'                   => 'Forfallsdato for transaksjonen er i måned ":value"',
    'search_modifier_due_date_on_day'                     => 'Forfallsdato for transaksjonen er på dagen i måned ":value"',
    'search_modifier_not_due_date_on_year'                => 'Forfallsdato for transaksjonen er ikke i år ":value"',
    'search_modifier_not_due_date_on_month'               => 'Forfallsdato for transaksjonen er ikke i måned ":value"',
    'search_modifier_not_due_date_on_day'                 => 'Forfallsdato for transaksjonen er ikke på dag i måned ":value"',
    'search_modifier_due_date_before_year'                => 'Forfallsdato for transaksjonen er før eller i år ":value"',
    'search_modifier_due_date_before_month'               => 'Forfallsdato for transaksjonen er før eller i måned ":value"',
    'search_modifier_due_date_before_day'                 => 'Forfallsdato for transaksjonen er før eller på dagen i måneden ":value"',
    'search_modifier_due_date_after_year'                 => 'Forfallsdato for transaksjonen er etter eller i år ":value"',
    'search_modifier_due_date_after_month'                => 'Forfallsdato for transaksjonen er etter eller i måned ":value"',
    'search_modifier_due_date_after_day'                  => 'Forfallsdato for transaksjonen er etter eller på dagen i måned ":value',
    'search_modifier_payment_date_on_year'                => 'Betalingsdato i år ":value"',
    'search_modifier_payment_date_on_month'               => 'Betalingsdato for transaksjonen er i måned ":value"',
    'search_modifier_payment_date_on_day'                 => 'Betalingsdato for transaksjonen er på dagen i måned ":value"',
    'search_modifier_not_payment_date_on_year'            => 'Betalingsdato for transaksjonen er ikke i år ":value"',
    'search_modifier_not_payment_date_on_month'           => 'Betalingsdato for transaksjonen er ikke i måned ":value"',
    'search_modifier_not_payment_date_on_day'             => 'Betalingsdato for transaksjonen er ikke på dagen i måned ":value"',
    'search_modifier_payment_date_before_year'            => 'Betalingsdato for transaksjonen er før eller i år ":value"',
    'search_modifier_payment_date_before_month'           => 'Betalingsdato for transaksjonen er før eller i måned ":value"',
    'search_modifier_payment_date_before_day'             => 'Betalingsdato for transaksjonen er før eller på dagen i måned ":value"',
    'search_modifier_payment_date_after_year'             => 'Betalingsdato for transaksjonen er etter eller i år ":value"',
    'search_modifier_payment_date_after_month'            => 'Bokføringsdato for transaksjonen er etter eller i måned ":value"',
    'search_modifier_payment_date_after_day'              => 'Betalingsdato for transaksjonen er etter eller på dagen i måned ":value"',
    'search_modifier_invoice_date_on_year'                => 'Fakturadato for transaksjon er i år ":value"',
    'search_modifier_invoice_date_on_month'               => 'Fakturadato for transaksjon er i måned ":value"',
    'search_modifier_invoice_date_on_day'                 => 'Fakturadato for transaksjon er på dagen i måned ":value"',
    'search_modifier_not_invoice_date_on_year'            => 'Fakturadato for transaksjonen er ikke i år ":value"',
    'search_modifier_not_invoice_date_on_month'           => 'Fakturadato for transaksjonen er ikke i måned ":value"',
    'search_modifier_not_invoice_date_on_day'             => 'Fakturadato for transaksjon er ikke på dag i måned ":value"',
    'search_modifier_invoice_date_before_year'            => 'Fakturadato for transaksjon er før eller i år ":value"',
    'search_modifier_invoice_date_before_month'           => 'Fakturadato for transaksjon er før eller i måned ":value"',
    'search_modifier_invoice_date_before_day'             => 'Fakturadato for transaksjon er før eller på dagen i måned ":value"',
    'search_modifier_invoice_date_after_year'             => 'Fakturadato for transaksjon er etter eller i år ":value"',
    'search_modifier_invoice_date_after_month'            => 'Fakturadato for transaksjon er etter eller i måned ":value"',
    'search_modifier_invoice_date_after_day'              => 'Fakturadato for transaksjon er etter eller på dagen i måned ":value"',
    // other dates
    'search_modifier_updated_at_on_year'                  => 'Transaksjonen ble oppdatert i år ":value"',
    'search_modifier_updated_at_on_month'                 => 'Transaksjonen ble oppdatert i måned ":value"',
    'search_modifier_updated_at_on_day'                   => 'Transaksjonen ble sist oppdatert på dagen i måned ":value"',
    'search_modifier_not_updated_at_on_year'              => 'Transaksjonen ble ikke oppdatert sist i år ":value"',
    'search_modifier_not_updated_at_on_month'             => 'Transaksjonen ble ikke sist oppdatert i måned ":value"',
    'search_modifier_not_updated_at_on_day'               => 'Transaksjonen ble ikke sist oppdatert på dag i måned ":value"',
    'search_modifier_updated_at_before_year'              => 'Transaksjonen ble sist oppdatert i eller før år ":value"',
    'search_modifier_updated_at_before_month'             => 'Transaksjonen ble sist oppdatert i eller før måned ":value"',
    'search_modifier_updated_at_before_day'               => 'Transaksjonen ble sist oppdatert på eller før dag i måned ":value"',
    'search_modifier_updated_at_after_year'               => 'Transaksjonen ble sist oppdatert i eller etter år ":value"',
    'search_modifier_updated_at_after_month'              => 'Transaksjonen ble sist oppdatert i eller etter måned ":value"',
    'search_modifier_updated_at_after_day'                => 'Transaksjonen ble sist oppdatert på eller etter en dag i måned ":value"',
    'search_modifier_created_at_on_year'                  => 'Transaksjonen ble opprettet i år ":value',
    'search_modifier_created_at_on_month'                 => 'Transaksjonen ble opprettet i måned ":value"',
    'search_modifier_created_at_on_day'                   => 'Transaksjonen ble opprettet på dag i måned ":value"',
    'search_modifier_not_created_at_on_year'              => 'Transaksjonen ble ikke opprettet i år ":value"',
    'search_modifier_not_created_at_on_month'             => 'Transaksjonen ble ikke opprettet i måned ":value"',
    'search_modifier_not_created_at_on_day'               => 'Transaksjonen ble ikke opprettet på dag i måneden ":value"',
    'search_modifier_created_at_before_year'              => 'Transaksjonen ble opprettet i eller før år ":value"',
    'search_modifier_created_at_before_month'             => 'Transaksjonen ble opprettet i eller før måned ":value"',
    'search_modifier_created_at_before_day'               => 'Transaksjonen ble opprettet på eller før dag i måneden ":value"',
    'search_modifier_created_at_after_year'               => 'Transaksjonen ble opprettet i eller etter år ":value"',
    'search_modifier_created_at_after_month'              => 'Transaksjonen ble opprettet i eller etter måned ":value"',
    'search_modifier_created_at_after_day'                => 'Transaksjonen ble opprettet på eller etter dag i måneden ":value',
    'search_modifier_interest_date_before'                => 'Transaksjonsrentens dato er på eller før ":value"',
    'search_modifier_interest_date_after'                 => 'Transaksjonens rentedato er på eller etter ":value"',
    'search_modifier_book_date_on'                        => 'Bokføringsdato for transaksjonen er ":value"',
    'search_modifier_not_book_date_on'                    => 'Bokføringsdato for transaksjonen er ikke ":value"',
    'search_modifier_book_date_before'                    => 'Bokføringsdato for transaksjonen er på eller før ":value"',
    'search_modifier_book_date_after'                     => 'Bokføringsdato for transaksjonen er på eller etter ":value"',
    'search_modifier_process_date_on'                     => 'Transaksjonens utførelsesdato er ":value"',
    'search_modifier_not_process_date_on'                 => 'Transaksjonens utførelsesdato er ikke ":value"',
    'search_modifier_process_date_before'                 => 'Transaksjonens utførelsesdato er på eller før ":value"',
    'search_modifier_process_date_after'                  => 'Transaksjonens utførelsesdato er på eller etter ":value"',
    'search_modifier_due_date_on'                         => 'Forfallsdato for transaksjonen er ":value"',
    'search_modifier_not_due_date_on'                     => 'Forfallsdato for transaksjonen er ikke ":value"',
    'search_modifier_due_date_before'                     => 'Forfallsdato for transaksjonen er på eller før ":value"',
    'search_modifier_due_date_after'                      => 'Forfallsdato for transaksjonen er på eller etter ":value"',
    'search_modifier_payment_date_on'                     => 'Betalingsdato for transaksjonen er ":value"',
    'search_modifier_not_payment_date_on'                 => 'Betalingsdato for transaksjonen er ikke ":value"',
    'search_modifier_payment_date_before'                 => 'Betalingsdato for transaksjonen er på eller før ":value"',
    'search_modifier_payment_date_after'                  => 'Betalingsdato for transaksjonen er på eller etter ":value"',
    'search_modifier_invoice_date_on'                     => 'Fakturadato for transaksjon er på ":value"',
    'search_modifier_not_invoice_date_on'                 => 'Fakturadato for transaksjon er ikke ":value"',
    'search_modifier_invoice_date_before'                 => 'Fakturadato for transaksjon er på eller før ":value"',
    'search_modifier_invoice_date_after'                  => 'Fakturadato for transaksjon er på eller etter ":value"',
    'search_modifier_created_at_on'                       => 'Transaksjonen ble opprettet på ":value',
    'search_modifier_not_created_at_on'                   => 'Transaksjonen ble ikke opprettet på ":value',
    'search_modifier_created_at_before'                   => 'Transaksjonen ble opprettet på eller før ":value"',
    'search_modifier_created_at_after'                    => 'Transaksjonen ble opprettet på eller etter ":value"',
    'search_modifier_updated_at_on'                       => 'Transaksjonen ble oppdatert ":value"',
    'search_modifier_not_updated_at_on'                   => 'Transaksjonen ble ikke oppdatert ":value"',
    'search_modifier_updated_at_before'                   => 'Transaksjonen ble oppdatert på dato eller før ":value"',
    'search_modifier_updated_at_after'                    => 'Transaksjonen ble oppdatert på eller etter ":value"',

    'search_modifier_attachment_name_is'            => 'Navn på vedlegg er ":value"',
    'search_modifier_attachment_name_contains'      => 'Navn på vedlegg inneholder ":value"',
    'search_modifier_attachment_name_starts'        => 'Navn på vedlegg starter med ":value"',
    'search_modifier_attachment_name_ends'          => 'Navn på vedlegg slutter med ":value"',
    'search_modifier_attachment_notes_are'          => 'Notater på vedlegg er ":value"',
    'search_modifier_attachment_notes_contains'     => 'Notater på vedlegg inneholder ":value"',
    'search_modifier_attachment_notes_starts'       => 'Notater på vedlegg starter med ":value"',
    'search_modifier_attachment_notes_ends'         => 'Notater på vedlegg slutter med ":value"',
    'search_modifier_not_attachment_name_is'        => 'Navn på vedlegg er ikke ":value"',
    'search_modifier_not_attachment_name_contains'  => 'Navn på vedlegg inneholder ikke ":value"',
    'search_modifier_not_attachment_name_starts'    => 'Navn på vedlegg starter ikke med ":value"',
    'search_modifier_not_attachment_name_ends'      => 'Navn på vedlegg slutter ikke med ":value"',
    'search_modifier_not_attachment_notes_are'      => 'Notater på vedlegg er ikke ":value"',
    'search_modifier_not_attachment_notes_contains' => 'Notater på vedlegg inneholder ikke ":value"',
    'search_modifier_not_attachment_notes_starts'   => 'Notater på vedlegg starter med ":value"',
    'search_modifier_not_attachment_notes_ends'     => 'Notater på vedlegg slutter ikke med ":value"',
    'search_modifier_sepa_ct_is'                    => 'SEPA CT er ":value"',
    'update_rule_from_query'                        => 'Oppdater regel ":rule" fra søk',
    'create_rule_from_query'                        => 'Lag ny regel fra søk',
    'rule_from_search_words'                        => 'Regelverksmotoren har problemer med søkeparameteren ":string". Den foreslåtte regeln som passer til ditt søk kan gi et annet resultat. Vennligst kontroller reglene nøye.',

    // more new stuff
    'search_modifier_destination_balance_is'        => 'Destination account balance is exactly ":value"',
    'search_modifier_not_destination_balance_is'    => 'Destination account balance is NOT exactly ":value"',
    'search_modifier_source_balance_is'             => 'Source account balance is exactly ":value"',
    'search_modifier_not_source_balance_is'         => 'Source account balance is NOT exactly ":value"',

    'search_modifier_destination_balance_lte'     => 'Destination account balance is less than or equal to ":value"',
    'search_modifier_not_destination_balance_lte' => 'Destination account balance is more than ":value"',
    'search_modifier_source_balance_lte'          => 'Source account balance is less than or equal to ":value"',
    'search_modifier_not_source_balance_lte'      => 'Source account balance is more than ":value"',

    'search_modifier_destination_balance_lt'     => 'Destination account balance is less than ":value"',
    'search_modifier_not_destination_balance_lt' => 'Destination account balance is more than or equal to ":value"',
    'search_modifier_source_balance_lt'          => 'Source account balance is less than ":value"',
    'search_modifier_not_source_balance_lt'      => 'Source account balance is more than or equal to ":value"',

    'search_modifier_destination_balance_gte'     => 'Destination account balance is more than or equal to ":value"',
    'search_modifier_not_destination_balance_gte' => 'Destination account balance is less than ":value"',
    'search_modifier_source_balance_gte'          => 'Source account balance is more than or equal to ":value"',
    'search_modifier_not_source_balance_gte'      => 'Source account balance is less than ":value"',

    'search_modifier_destination_balance_gt'              => 'Destination account balance is more than ":value"',
    'search_modifier_not_destination_balance_gt'          => 'Destination account balance is less than or equal to ":value"',
    'search_modifier_source_balance_gt'                   => 'Source account balance is more than ":value"',
    'search_modifier_not_source_balance_gt'               => 'Source account balance is less than or equal to ":value"',


    // END
    'general_search_error'                                => 'Det oppstod en feil under søking. Vennligst sjekk loggfilene for mer informasjon.',
    'search_box'                                          => 'Søk',
    'search_box_intro'                                    => 'Welcome to the search function of Firefly III. Enter your search query in the box. <a href="https://docs.firefly-iii.org/how-to/firefly-iii/features/search/">Make sure you check out the help file</a> because the search is pretty advanced.',
    'search_error'                                        => 'Feil under søking',
    'search_searching'                                    => 'Søker ...',
    'search_results'                                      => 'Søkeresultater',

    // repeat frequencies:
    'repeat_freq_yearly'                                  => 'årlig',
    'repeat_freq_half-year'                               => 'hvert halvår',
    'repeat_freq_quarterly'                               => 'kvartalsvis',
    'repeat_freq_monthly'                                 => 'månedlig',
    'repeat_freq_weekly'                                  => 'ukentlig',
    'repeat_freq_daily'                                   => 'daglig',
    'daily'                                               => 'daglig',
    'weekly'                                              => 'ukentlig',
    'quarterly'                                           => 'kvartalsvis',
    'half-year'                                           => 'hvert halvår',
    'yearly'                                              => 'årlig',

    // rules
    'is_not_rule_trigger'                                 => 'Ikke',
    'cannot_fire_inactive_rules'                          => 'Du kan ikke kjøre inaktive regler.',
    'show_triggers'                                       => 'Show triggers',
    'show_actions'                                        => 'Show actions',
    'rules'                                               => 'Regler',
    'rule_name'                                           => 'Navn på regel',
    'rule_triggers'                                       => 'Regel utløses når',
    'rule_actions'                                        => 'Regel vil',
    'new_rule'                                            => 'Ny regel',
    'new_rule_group'                                      => 'Ny regelgruppe',
    'rule_priority_up'                                    => 'Gi regel høyere prioritet',
    'rule_priority_down'                                  => 'Gi regel lavere prioritet',
    'make_new_rule_group'                                 => 'Opprett ny regelgruppe',
    'store_new_rule_group'                                => 'Lagre ny regelgruppe',
    'created_new_rule_group'                              => 'Ny regelgruppe ":title" ble lagret!',
    'updated_rule_group'                                  => 'Oppdaterte regelgruppen ":title".',
    'edit_rule_group'                                     => 'Rediger regelgruppe ":title"',
    'duplicate_rule'                                      => 'Kopier regel ":title"',
    'rule_copy_of'                                        => 'Duplikat av ":title"',
    'duplicated_rule'                                     => 'Duplisert regel:title" inn i ":newTitle"',
    'delete_rule_group'                                   => 'Slett regelgruppe ":title"',
    'deleted_rule_group'                                  => 'Slettet regelgruppe ":title"',
    'update_rule_group'                                   => 'Oppdater regelgruppe',
    'no_rules_in_group'                                   => 'Det finnes ingen regler i denne gruppen',
    'move_rule_group_up'                                  => 'Flytt regelgruppen opp',
    'move_rule_group_down'                                => 'Flytt regelgruppen ned',
    'save_rules_by_moving'                                => 'Lagre denne regelen ved å flytte den til en annen regelgruppe: Lagre disse reglene ved å flytte dem til en annen regelgruppe:',
    'make_new_rule'                                       => 'Opprett ny regel i regelgruppen ":title"',
    'make_new_rule_no_group'                              => 'Lag en ny regel',
    'instructions_rule_from_bill'                         => 'In order to match transactions to your new subscription ":name", Firefly III can create a rule that will automatically be checked against any transactions you store. Please verify the details below and store the rule to have Firefly III automatically match transactions to your new bill.',
    'instructions_rule_from_journal'                      => 'Opprett en regel basert på en av dine transaksjoner. Fullfør eller send inn skjemaet nedenfor.',
    'rule_is_strict'                                      => 'strikt regel',
    'rule_is_not_strict'                                  => 'ikke-strikt regel',
    'rule_help_stop_processing'                           => 'When you check this box, later rules in this group will not be executed if this particular rule is executed.',
    'rule_help_strict'                                    => 'I strikte regler må ALLE triggere slå til for at aksjonen skal bli utført. Ved ikke-strikt regler kan UANSETT trigger få aksjonen til å bli utført.',
    'rule_help_active'                                    => 'Inaktive regler vil aldri utløses.',
    'stored_new_rule'                                     => 'Lagret ny regel med tittel ":title"',
    'deleted_rule'                                        => 'Slettet regel med tittel ":title"',
    'store_new_rule'                                      => 'Lagre ny regel',
    'updated_rule'                                        => 'Oppdaterte regel med tittel ":title"',
    'default_rule_group_name'                             => 'Standardregler',
    'default_rule_group_description'                      => 'Alle dine regler ligger ikke i noen bestemt gruppe.',
    'trigger'                                             => 'Utløser',
    'trigger_value'                                       => 'Utløs på verdi',
    'stop_processing_other_triggers'                      => 'Slutt å prosessere andre utløsere',
    'add_rule_trigger'                                    => 'Legg til ny utløser',
    'action'                                              => 'Handling',
    'action_value'                                        => 'Handlingsverdi',
    'stop_executing_other_actions'                        => 'Slutt å utføre andre handlinger',
    'add_rule_action'                                     => 'Legg til ny handling',
    'edit_rule'                                           => 'Edit rule #:nr ":title"',
    'delete_rule'                                         => 'Slett regel ":title"',
    'update_rule'                                         => 'Oppdater regel',
    'test_rule_triggers'                                  => 'Se transaksjoner som passer',
    'warning_no_matching_transactions'                    => 'Ingen samsvarende transaksjoner funnet.',
    'warning_no_valid_triggers'                           => 'Ingen gyldige utløsere oppgitt.',
    'apply_rule_selection'                                => 'Bruk regel ":title" til et utvalg av dine transaksjoner',
    'apply_rule_selection_intro'                          => 'Regler som ":title" brukes normalt bare til nye eller oppdaterte transaksjoner, men du kan få Firefly III til å kjøre dem på et utvalg av dine eksisterende transaksjoner. Dette kan være nyttig når du har oppdatert en regel, og du trenger at endringene blir brukt på alle dine tidligere transaksjoner.',
    'include_transactions_from_accounts'                  => 'Ta med transaksjoner fra disse kontoene',
    'include'                                             => 'Inkluder?',
    'applied_rule_selection'                              => '{0} Ingen transaksjoner i ditt utvalg ble endret med regel ":title.[1] En transaksjon i ditt valg ble endret av regel ":title". [2,*] :count transaksjoner i utvalget ble endret ved regel ":title. ".',
    'execute'                                             => 'Kjør',
    'apply_rule_group_selection'                          => 'Bruk regelgruppe ":title" til et utvalg av dine transaksjoner',
    'apply_rule_group_selection_intro'                    => 'Regelgrupper som ":title" brukes normalt bare til nye eller oppdaterte transaksjoner, men du kan få Firefly III til å kjøre dem på et utvalg av dine eksisterende transaksjoner. Dette kan være nyttig når du har oppdatert en regelgruppe, og du trenger at endringene blir brukt på alle dine tidligere transaksjoner.',
    'applied_rule_group_selection'                        => 'Regelgruppe ":title" har blitt brukt på ditt utvalg.',
    'rule_run_after_creation' => 'If you check this box, you get the opportunity to run the rule after it has been created.',
    'rule_run_after_edit' => 'If you check this box, you get the opportunity to run the rule after it has been updated.',

    // actions and triggers
    'rule_trigger_store_journal'                          => 'Når en transaksjon er opprettet',
    'rule_trigger_update_journal'                         => 'Når en transaksjon er oppdatert',
    'rule_trigger_manual'                                 => 'Only when user-activated',
    'rule_trigger_user_action'                            => 'Brukerhandling er ":trigger_value"',

    // OLD values (remove non-doubles later):
    'rule_trigger_source_account_starts_choice'           => 'Kildekonto navn starter med..',
    'rule_trigger_source_account_starts'                  => 'Kildenavnet starter med ":trigger_value"',
    'rule_trigger_source_account_ends_choice'             => 'Kildenavnet slutter med..',
    'rule_trigger_source_account_ends'                    => 'Kildekontonavnet slutter med ":trigger_value"',
    'rule_trigger_source_account_is_choice'               => 'Kildekonto navn er..',
    'rule_trigger_source_account_is'                      => 'Kildekonto navnet er ":trigger_value"',
    'rule_trigger_source_account_contains_choice'         => 'Kildekonto navn inneholder..',
    'rule_trigger_source_account_contains'                => 'Kildekonto navnet inneholder ":trigger_value"',
    'rule_trigger_account_id_choice'                      => 'En av konto ID\'er, er nøyaktig.',
    'rule_trigger_account_id'                             => 'En av konto ID\'er, er nøyaktig :trigger_value',
    'rule_trigger_source_account_id_choice'               => 'Kildekonto-ID er nøyaktig..',
    'rule_trigger_source_account_id'                      => 'Kildekonto-IDen er nøyaktig :trigger_value',
    'rule_trigger_destination_account_id_choice'          => 'Målkonto ID er nøyaktig..',
    'rule_trigger_destination_account_id'                 => 'Målkonto ID er nøyaktig :trigger_value',
    'rule_trigger_account_is_cash_choice'                 => 'En av konto er kontant',
    'rule_trigger_account_is_cash'                        => 'En av konto er kontant',
    'rule_trigger_source_is_cash_choice'                  => 'Kildekonto er (kontant) konto',
    'rule_trigger_source_is_cash'                         => 'Kildekonto er (kontant) konto',
    'rule_trigger_destination_is_cash_choice'             => 'Målkonto er (kontant) konto',
    'rule_trigger_destination_is_cash'                    => 'Målkonto er (kontant) konto',
    'rule_trigger_source_account_nr_starts_choice'        => 'Kildekontonummer / IBAN starter med..',
    'rule_trigger_source_account_nr_starts'               => 'Kildekontoummer / IBAN starter med ":trigger_value"',
    'rule_trigger_source_account_nr_ends_choice'          => 'Kildekontonummer / IBAN slutter med..',
    'rule_trigger_source_account_nr_ends'                 => 'Kildekontoummer / IBAN slutter med ":trigger_value"',
    'rule_trigger_source_account_nr_is_choice'            => 'Kildekontonummer / IBAN er..',
    'rule_trigger_source_account_nr_is'                   => 'Kildekontoummer / IBAN er ":trigger_value"',
    'rule_trigger_source_account_nr_contains_choice'      => 'Kilde kontonummer / IBAN inneholder..',
    'rule_trigger_source_account_nr_contains'             => 'Kilde kontonummer / IBAN inneholder ":trigger_value"',
    'rule_trigger_destination_account_starts_choice'      => 'Målkontonavnet begynner med..',
    'rule_trigger_destination_account_starts'             => 'Målkontonavnet starter med ":trigger_value"',
    'rule_trigger_destination_account_ends_choice'        => 'Målkontonavnet slutter med..',
    'rule_trigger_destination_account_ends'               => 'Målkonto navn slutter med ":trigger_value"',
    'rule_trigger_destination_account_is_choice'          => 'Målkonto navn slutter med..',
    'rule_trigger_destination_account_is'                 => 'Målkontonavn er ":trigger_value"',
    'rule_trigger_destination_account_contains_choice'    => 'Målkontonavn inneholder..',
    'rule_trigger_destination_account_contains'           => 'Målkontonavnet inneholder ":trigger_value"',
    'rule_trigger_destination_account_nr_starts_choice'   => 'Målkontonummer / IBAN starter med..',
    'rule_trigger_destination_account_nr_starts'          => 'Målkontonummer / IBAN starter med ":trigger_value"',
    'rule_trigger_destination_account_nr_ends_choice'     => 'Målkontonummer / IBAN slutter med..',
    'rule_trigger_destination_account_nr_ends'            => 'Målkontonummer / IBAN slutter med ":trigger_value"',
    'rule_trigger_destination_account_nr_is_choice'       => 'Målkontonummer / IBAN er..',
    'rule_trigger_destination_account_nr_is'              => 'Målkontonummer / IBAN er ":trigger_value"',
    'rule_trigger_destination_account_nr_contains_choice' => 'Målkontonummer / IBAN inneholder..',
    'rule_trigger_destination_account_nr_contains'        => 'Målkontonummer / IBAN inneholder ":trigger_value"',
    'rule_trigger_transaction_type_choice'                => 'Transaksjonen er av typen..',
    'rule_trigger_transaction_type'                       => 'Transaksjonen er av typen ":trigger_value"',
    'rule_trigger_category_is_choice'                     => 'Kategori er..',
    'rule_trigger_category_is'                            => 'Kategori er ":trigger_value"',
    'rule_trigger_amount_less_choice'                     => 'Beløpet er mindre enn eller lik ..',
    'rule_trigger_amount_less'                            => 'Beløpet er mindre enn eller lik :trigger_value',
    'rule_trigger_amount_is_choice'                       => 'Beløpet er..',
    'rule_trigger_amount_is'                              => 'Beløpet er :trigger_value',
    'rule_trigger_amount_more_choice'                     => 'Beløpet er mer enn eller lik..',
    'rule_trigger_amount_more'                            => 'Beløpet er mer enn eller lik :trigger_value',
    'rule_trigger_description_starts_choice'              => 'Beskrivelse starter med..',
    'rule_trigger_description_starts'                     => 'Beskrivelse starter med ":trigger_value"',
    'rule_trigger_description_ends_choice'                => 'Beskrivelse slutter med..',
    'rule_trigger_description_ends'                       => 'Beskrivelse slutter med ":trigger_value"',
    'rule_trigger_description_contains_choice'            => 'Beskrivelse inneholder..',
    'rule_trigger_description_contains'                   => 'Beskrivelse inneholder ":trigger_value"',
    'rule_trigger_description_is_choice'                  => 'Beskrivelse er..',
    'rule_trigger_description_is'                         => 'Beskrivelse er ":trigger_value"',
    'rule_trigger_date_on_choice'                         => 'Transaksjonsdato er..',
    'rule_trigger_date_on'                                => 'Transaksjons dato er ":trigger_value"',
    'rule_trigger_date_before_choice'                     => 'Transaksjons dato er før..',
    'rule_trigger_date_before'                            => 'Transaksjons dato er før ":trigger_value"',
    'rule_trigger_date_after_choice'                      => 'Transaksjons dato er etter..',
    'rule_trigger_date_after'                             => 'Transaksjons dato er etter ":trigger_value"',
    'rule_trigger_created_at_on_choice'                   => 'Transaksjonen ble gjort på..',
    'rule_trigger_created_at_on'                          => 'Transaksjonen ble gjort på ":trigger_value"',
    'rule_trigger_updated_at_on_choice'                   => 'Transaksjonen ble sist redigert den..',
    'rule_trigger_updated_at_on'                          => 'Transaksjonen ble sist redigert den ":trigger_value"',
    'rule_trigger_budget_is_choice'                       => 'Budsjett er..',
    'rule_trigger_budget_is'                              => 'Budsjett er ":trigger_value"',
    'rule_trigger_tag_is_choice'                          => '(En) tagg er..',
    'rule_trigger_tag_is'                                 => 'Enhver tag er ":trigger_value"',
    'rule_trigger_tag_contains_choice'                    => 'Any tag contains..',
    'rule_trigger_tag_contains'                           => 'Any tag contains ":trigger_value"',
    'rule_trigger_not_tag_contains'                           => 'No tag contains ":trigger_value"',
    'rule_trigger_tag_ends_choice'                        => 'Any tag ends with..',
    'rule_trigger_tag_ends'                               => 'Any tag ends with ":trigger_value"',
    'rule_trigger_tag_starts_choice'                      => 'Any tag starts with..',
    'rule_trigger_tag_starts'                             => 'Any tag starts with ":trigger_value"',
    'rule_trigger_currency_is_choice'                     => 'Transaksjonsvaluta er..',
    'rule_trigger_currency_is'                            => 'Transaksjonsvaluta er ":trigger_value"',
    'rule_trigger_foreign_currency_is_choice'             => 'Transaksjonens fremmed valuta er..',
    'rule_trigger_foreign_currency_is'                    => 'Transaksjonens fremmed valuta er ":trigger_value"',
    'rule_trigger_has_attachments_choice'                 => 'Has any attachments',
    'rule_trigger_has_attachments'                        => 'Has any attachment(s)',
    'rule_trigger_has_no_category_choice'                 => 'Har ingen kategori',
    'rule_trigger_has_no_category'                        => 'Transaksjonen har ingen kategori',
    'rule_trigger_has_any_category_choice'                => 'Har en (hvilken som helst) kategori',
    'rule_trigger_has_any_category'                       => 'Transaksjonen har en (hvilken som helst) kategori',
    'rule_trigger_has_no_budget_choice'                   => 'Har ingen budsjett',
    'rule_trigger_has_no_budget'                          => 'Transaksjonen har ikke noe budsjett',
    'rule_trigger_has_any_budget_choice'                  => 'Har et (hvilket som helst) budsjett',
    'rule_trigger_has_any_budget'                         => 'Transaksjonen har et (hvilket som helst) budsjett',
    'rule_trigger_has_no_bill_choice'                     => 'Has no subscription',
    'rule_trigger_has_no_bill'                            => 'Transaction has no subscription',
    'rule_trigger_has_any_bill_choice'                    => 'Has a (any) subscription',
    'rule_trigger_has_any_bill'                           => 'Transaction has a (any) subscription',
    'rule_trigger_has_no_tag_choice'                      => 'Har ingen tagg(er)',
    'rule_trigger_has_no_tag'                             => 'Transaksjonen har ingen tagger',
    'rule_trigger_has_any_tag_choice'                     => 'Har en eller flere tagger',
    'rule_trigger_has_any_tag'                            => 'Transaksjonen har en eller flere tagger',
    'rule_trigger_any_notes_choice'                       => 'Har ett eller flere notater',
    'rule_trigger_any_notes'                              => 'Transaksjonen har ett eller flere notater',
    'rule_trigger_no_notes_choice'                        => 'Har ingen notater',
    'rule_trigger_no_notes'                               => 'Transaksjonen har ingen notater',
    'rule_trigger_notes_is_choice'                        => 'Notater er..',
    'rule_trigger_notes_is'                               => 'Notater er ":trigger_value"',
    'rule_trigger_notes_contains_choice'                  => 'Notater inneholder..',
    'rule_trigger_notes_contains'                         => 'Notater inneholder ":trigger_value"',
    'rule_trigger_notes_starts_choice'                    => 'Notater begynner med..',
    'rule_trigger_notes_starts'                           => 'Notater som starter med ":trigger_value"',
    'rule_trigger_notes_ends_choice'                      => 'Notater som slutter med..',
    'rule_trigger_notes_ends'                             => 'Notater som slutter med ":trigger_value"',
    'rule_trigger_bill_is_choice'                         => 'Subscription is..',
    'rule_trigger_bill_is'                                => 'Subscription is ":trigger_value"',
    'rule_trigger_external_id_is_choice'                  => 'Ekstern ID er..',
    'rule_trigger_external_id_is'                         => 'Ekstern ID er ":trigger_value"',
    'rule_trigger_internal_reference_is_choice'           => 'Intern referanse er..',
    'rule_trigger_internal_reference_is'                  => 'Ekstern referanse er ":trigger_value"',
    'rule_trigger_journal_id_choice'                      => 'Transaksjonens journal ID er..',
    'rule_trigger_journal_id'                             => 'Transaksjonens journal ID er ":trigger_value"',
    'rule_trigger_any_external_url'                       => 'Transaksjonen har en ekstern URL',
    'rule_trigger_any_external_url_choice'                => 'Has an (any) external URL',
    'rule_trigger_any_external_id'                        => 'Transaksjonen har en ekstern ID',
    'rule_trigger_any_external_id_choice'                 => 'Has an (any) external ID',
    'rule_trigger_no_external_url_choice'                 => 'Has no external URL',
    'rule_trigger_no_external_url'                        => 'Transaksjonen har ingen ekstern URL',
    'rule_trigger_no_external_id_choice'                  => 'Has no external ID',
    'rule_trigger_no_external_id'                         => 'Transaksjonen har ingen ekstern ID',
    'rule_trigger_id_choice'                              => 'Transaksjons-ID er',
    'rule_trigger_id'                                     => 'Transaksjons ID er ":trigger_value"',
    'rule_trigger_sepa_ct_is_choice'                      => 'SEPA CT er..',
    'rule_trigger_sepa_ct_is'                             => 'SEPA CT er ":trigger_value"',

    // new values:
    'rule_trigger_user_action_choice'                     => 'Brukerhandling er ":trigger_value"',
    'rule_trigger_tag_is_not_choice'                      => 'Ingen tag er..',
    'rule_trigger_tag_is_not'                             => 'Ingen tag er ":trigger_value"',
    'rule_trigger_account_is_choice'                      => 'En av kontoene er nøyaktig..',
    'rule_trigger_account_is'                             => 'En av kontoene er eksakt ":trigger_value"',
    'rule_trigger_account_contains_choice'                => 'En av kontoene inneholder..',
    'rule_trigger_account_contains'                       => 'En av kontoene inneholder ":trigger_value"',
    'rule_trigger_account_ends_choice'                    => 'En av kontoene slutter med..',
    'rule_trigger_account_ends'                           => 'Beskrivelse slutter med ":trigger_value"',
    'rule_trigger_account_starts_choice'                  => 'En av kontoene starter med..',
    'rule_trigger_account_starts'                         => 'En av kontoene starter med ":trigger_value"',
    'rule_trigger_account_nr_is_choice'                   => 'En av kontoenes nummer / IBAN er..',
    'rule_trigger_account_nr_is'                          => 'Kontonummer / IBAN er ":trigger_value"',
    'rule_trigger_account_nr_contains_choice'             => 'Kontonummer / IBAN inneholder..',
    'rule_trigger_account_nr_contains'                    => 'Alle kontonummer / IBAN inneholder ":trigger_value"',
    'rule_trigger_account_nr_ends_choice'                 => 'Alle kontonummer / IBAN slutter med..',
    'rule_trigger_account_nr_ends'                        => 'Alle kontonummer / IBAN slutter med ":trigger_value"',
    'rule_trigger_account_nr_starts_choice'               => 'Alle kontonummer / IBAN starter med..',
    'rule_trigger_account_nr_starts'                      => 'Alle kontonummer / IBAN starter med ":trigger_value"',
    'rule_trigger_category_contains_choice'               => 'Kategori inneholder..',
    'rule_trigger_category_contains'                      => 'Kategorien inneholder ":trigger_value"',
    'rule_trigger_category_ends_choice'                   => 'Kategori slutter med..',
    'rule_trigger_category_ends'                          => 'Kategorien slutter med ":trigger_value',
    'rule_trigger_category_starts_choice'                 => 'Kategori starter med..',
    'rule_trigger_category_starts'                        => 'Kategorien starter med ":trigger_value',
    'rule_trigger_budget_contains_choice'                 => 'Budsjett inneholder..',
    'rule_trigger_budget_contains'                        => 'Budsjettet inneholder ":trigger_value',
    'rule_trigger_budget_ends_choice'                     => 'Budsjettet slutter med..',
    'rule_trigger_budget_ends'                            => 'Budsjettet slutter med ":trigger_value"',
    'rule_trigger_budget_starts_choice'                   => 'Budsjettet starter med..',
    'rule_trigger_budget_starts'                          => 'Budsjettet begynner med ":trigger_value"',
    'rule_trigger_bill_contains_choice'                   => 'Subscription contains..',
    'rule_trigger_bill_contains'                          => 'Subscription contains ":trigger_value"',
    'rule_trigger_bill_ends_choice'                       => 'Subscription ends with..',
    'rule_trigger_bill_ends'                              => 'Subscription ends with ":trigger_value"',
    'rule_trigger_bill_starts_choice'                     => 'Subscription starts with..',
    'rule_trigger_bill_starts'                            => 'Subscription starts with ":trigger_value"',
    'rule_trigger_external_id_contains_choice'            => 'Ekstern ID inneholder..',
    'rule_trigger_external_id_contains'                   => 'Ekstern ID inneholder ":trigger_value"',
    'rule_trigger_external_id_ends_choice'                => 'Ekstern ID slutter med..',
    'rule_trigger_external_id_ends'                       => 'Ekstern ID slutter med ":trigger_value"',
    'rule_trigger_external_id_starts_choice'              => 'Ekstern ID starter med..',
    'rule_trigger_external_id_starts'                     => 'Ekstern ID starter med ":trigger_value"',
    'rule_trigger_internal_reference_contains_choice'     => 'Intern referanse inneholder..',
    'rule_trigger_internal_reference_contains'            => 'Ekstern referanse ":trigger_value"',
    'rule_trigger_internal_reference_ends_choice'         => 'Intern referanse ender med..',
    'rule_trigger_internal_reference_ends'                => 'Intern referanse ender med ":trigger_value"',
    'rule_trigger_internal_reference_starts_choice'       => 'Intern referanse begynner med..',
    'rule_trigger_internal_reference_starts'              => 'Intern referanse starter med ":trigger_value"',
    'rule_trigger_external_url_is_choice'                 => 'Ekstern URL er..',
    'rule_trigger_external_url_is'                        => 'Ekstern URL er ":trigger_value"',
    'rule_trigger_external_url_contains_choice'           => 'Ekstern URL inneholder..',
    'rule_trigger_external_url_contains'                  => 'Ekstern URL inneholder ":trigger_value"',
    'rule_trigger_external_url_ends_choice'               => 'Ekstern URL slutter med..',
    'rule_trigger_external_url_ends'                      => 'Ekstern URL slutter med ":trigger_value"',
    'rule_trigger_external_url_starts_choice'             => 'Ekstern URL starter med..',
    'rule_trigger_external_url_starts'                    => 'Ekstern URL starter med ":trigger_value"',
    'rule_trigger_has_no_attachments_choice'              => 'Har ingen vedlegg',
    'rule_trigger_has_no_attachments'                     => 'Transaksjonen har ingen vedlegg',
    'rule_trigger_recurrence_id_choice'                   => 'Gjentakende transaksjons ID er..',
    'rule_trigger_recurrence_id'                          => 'Gjentakende transaksjons ID er ":trigger_value"',
    'rule_trigger_interest_date_on_choice'                => 'Rentedato er..',
    'rule_trigger_interest_date_on'                       => 'Rentedato er ":trigger_value"',
    'rule_trigger_interest_date_before_choice'            => 'Rentedato er før..',
    'rule_trigger_interest_date_before'                   => 'Rentedato er før ":trigger_value"',
    'rule_trigger_interest_date_after_choice'             => 'Rentedato er etter..',
    'rule_trigger_interest_date_after'                    => 'Rentedato er etter ":trigger_value"',
    'rule_trigger_book_date_on_choice'                    => 'Bokført dato er..',
    'rule_trigger_book_date_on'                           => 'Bokført dato er ":trigger_value"',
    'rule_trigger_book_date_before_choice'                => 'Bokført dato er før..',
    'rule_trigger_book_date_before'                       => 'Bokført dato er før ":trigger_value"',
    'rule_trigger_book_date_after_choice'                 => 'Bokført dato er etter..',
    'rule_trigger_book_date_after'                        => 'Bokført dato er etter ":trigger_value"',
    'rule_trigger_process_date_on_choice'                 => 'Prosessdato er..',
    'rule_trigger_process_date_on'                        => 'Prosessdato er ":trigger_value"',
    'rule_trigger_process_date_before_choice'             => 'Prosessdato er før..',
    'rule_trigger_process_date_before'                    => 'Prosessdato er før ":trigger_value"',
    'rule_trigger_process_date_after_choice'              => 'Prosessdato er etter..',
    'rule_trigger_process_date_after'                     => 'Prosessdato er etter ":trigger_value"',
    'rule_trigger_due_date_on_choice'                     => 'Forfallsdato er..',
    'rule_trigger_due_date_on'                            => 'Forfallsdato er den ":trigger_value"',
    'rule_trigger_due_date_before_choice'                 => 'Forfallsdato er før..',
    'rule_trigger_due_date_before'                        => 'Forfallsdato er før ":trigger_value"',
    'rule_trigger_due_date_after_choice'                  => 'Forfallsdato er etter..',
    'rule_trigger_due_date_after'                         => 'Forfallsdato er etter ":trigger_value"',
    'rule_trigger_payment_date_on_choice'                 => 'Betalingsdato er på..',
    'rule_trigger_payment_date_on'                        => 'Betalingsdato er på ":trigger_value"',
    'rule_trigger_payment_date_before_choice'             => 'Betalingsdato er før..',
    'rule_trigger_payment_date_before'                    => 'Betalingsdato er før ":trigger_value"',
    'rule_trigger_payment_date_after_choice'              => 'Betalingsdato er etter..',
    'rule_trigger_payment_date_after'                     => 'Betalingsdato er etter ":trigger_value"',
    'rule_trigger_invoice_date_on_choice'                 => 'Fakturadato er på..',
    'rule_trigger_invoice_date_on'                        => 'Fakturadato er den ":trigger_value"',
    'rule_trigger_invoice_date_before_choice'             => 'Fakturadato er før..',
    'rule_trigger_invoice_date_before'                    => 'Fakturadato er før ":trigger_value"',
    'rule_trigger_invoice_date_after_choice'              => 'Fakturadato er etter..',
    'rule_trigger_invoice_date_after'                     => 'Fakturadato er etter ":trigger_value"',
    'rule_trigger_created_at_before_choice'               => 'Transaksjonen ble opprettet før..',
    'rule_trigger_created_at_before'                      => 'Transaksjonen ble opprettet før ":trigger_value"',
    'rule_trigger_created_at_after_choice'                => 'Transaksjonen ble opprettet etter..',
    'rule_trigger_created_at_after'                       => 'Transaksjonen ble opprettet etter ":trigger_value"',
    'rule_trigger_updated_at_before_choice'               => 'Transaksjonen ble sist oppdatert før..',
    'rule_trigger_updated_at_before'                      => 'Transaksjonen ble sist oppdatert før ":trigger_value"',
    'rule_trigger_updated_at_after_choice'                => 'Transaksjonen ble sist oppdatert etter..',
    'rule_trigger_updated_at_after'                       => 'Transaksjonen ble sist oppdatert etter ":trigger_value"',
    'rule_trigger_foreign_amount_is_choice'               => 'Det utenlanske beløpet er nøyaktig..',
    'rule_trigger_foreign_amount_is'                      => 'Utenlanske beløpet er nøyaktig ":trigger_value"',
    'rule_trigger_foreign_amount_less_choice'             => 'Utenlandske beløpet er mindre enn..',
    'rule_trigger_foreign_amount_less'                    => 'Utenlandske beløpet er mindre enn ":trigger_value"',
    'rule_trigger_foreign_amount_more_choice'             => 'Utenlandske beløpet er mer enn..',
    'rule_trigger_foreign_amount_more'                    => 'Utenlandske beløpet er mer enn ":trigger_value',
    'rule_trigger_attachment_name_is_choice'              => 'Ethvert vedlagte navn er..',
    'rule_trigger_attachment_name_is'                     => 'Ethvert vedlagte navn er ":trigger_value"',
    'rule_trigger_attachment_name_contains_choice'        => 'Eventuelle vedlagte navn inneholder..',
    'rule_trigger_attachment_name_contains'               => 'Eventuelle vedlagte navn inneholder ":trigger_value"',
    'rule_trigger_attachment_name_starts_choice'          => 'Ethvert vedlagte navn starter med..',
    'rule_trigger_attachment_name_starts'                 => 'Eventuelle vedlagte navn starter med ":trigger_value"',
    'rule_trigger_attachment_name_ends_choice'            => 'Eventuelle vedlegg slutter med..',
    'rule_trigger_attachment_name_ends'                   => 'Eventuelle vedlagte navn slutter med ":trigger_value"',
    'rule_trigger_attachment_notes_are_choice'            => 'Eventuelle vedlagte notater er..',
    'rule_trigger_attachment_notes_are'                   => 'Eventuelle vedlagte notater er ":trigger_value"',
    'rule_trigger_attachment_notes_contains_choice'       => 'Eventuelle vedlagte notater inneholder..',
    'rule_trigger_attachment_notes_contains'              => 'Eventuelle vedlagte notater inneholder ":trigger_value"',
    'rule_trigger_attachment_notes_starts_choice'         => 'Eventuelle vedlagte notater starter med..',
    'rule_trigger_attachment_notes_starts'                => 'Eventuelle vedlagte notater starter med ":trigger_value"',
    'rule_trigger_attachment_notes_ends_choice'           => 'Eventuelle vedlagte notater slutter med..',
    'rule_trigger_attachment_notes_ends'                  => 'Eventuelle vedlagte notater ferdig med ":trigger_value"',
    'rule_trigger_reconciled_choice'                      => 'Transaksjonen er avstemt',
    'rule_trigger_reconciled'                             => 'Transaksjonen er avstemt',
    'rule_trigger_exists_choice'                          => 'Alle transaksjoner matcher(!)',
    'rule_trigger_exists'                                 => 'Alle transaksjoner matcher',

    // more values for new types:
    'rule_trigger_not_account_id'                         => 'Konto ID er ikke ":trigger_value"',
    'rule_trigger_not_source_account_id'                  => 'Kildekonto ID er ikke ":trigger_value"',
    'rule_trigger_not_destination_account_id'             => 'Målkonto ID er ikke ":trigger_value"',
    'rule_trigger_not_transaction_type'                   => 'Transaksjonstype er ikke ":trigger_value"',
    'rule_trigger_not_tag_is'                             => 'Taggen er ikke ":trigger_value"',
    'rule_trigger_not_tag_is_not'                         => 'Taggen er ":trigger_value"',
    'rule_trigger_not_description_is'                     => 'Beskrivelsen er ikke ":trigger_value"',
    'rule_trigger_not_description_contains'               => 'Description does not contain ":trigger_value"',
    'rule_trigger_not_description_ends'                   => 'Beskrivelsen slutter ikke med ":trigger_value"',
    'rule_trigger_not_description_starts'                 => 'Beskrivelsen starter ikke med ":trigger_value"',
    'rule_trigger_not_notes_is'                           => 'Notatene er ikke ":trigger_value"',
    'rule_trigger_not_notes_contains'                     => 'Notatene inneholder ikke ":trigger_value"',
    'rule_trigger_not_notes_ends'                         => 'Notatene slutter ikke på ":trigger_value"',
    'rule_trigger_not_notes_starts'                       => 'Notatene begynner ikke med ":trigger_value"',
    'rule_trigger_not_source_account_is'                  => 'Kildekonto er ikke ":trigger_value"',
    'rule_trigger_not_source_account_contains'            => 'Kildekonto inneholder ikke ":trigger_value"',
    'rule_trigger_not_source_account_ends'                => 'Kildekontoen inneholder ":trigger_value"',
    'rule_trigger_not_source_account_starts'              => 'Kildekontoen starter ikke med ":trigger_value"',
    'rule_trigger_not_source_account_nr_is'               => 'Kilde kontonummer / IBAN er ikke ":trigger_value"',
    'rule_trigger_not_source_account_nr_contains'         => 'Kilde kontonummer / IBAN inneholder ikke ":trigger_value"',
    'rule_trigger_not_source_account_nr_ends'             => 'Kilde kontonummer / IBAN slutter ikke på ":trigger_value"',
    'rule_trigger_not_source_account_nr_starts'           => 'Kilde kontoummer / IBAN starter ikke med ":trigger_value"',
    'rule_trigger_not_destination_account_is'             => 'Målkonto er ikke ":trigger_value"',
    'rule_trigger_not_destination_account_contains'       => 'Målkonto inneholder ikke ":trigger_value"',
    'rule_trigger_not_destination_account_ends'           => 'Målkonto slutter ikke på ":trigger_value"',
    'rule_trigger_not_destination_account_starts'         => 'Målkonto starter ikke med ":trigger_value"',
    'rule_trigger_not_destination_account_nr_is'          => 'Målkonto nummer / IBAN er ikke ":trigger_value"',
    'rule_trigger_not_destination_account_nr_contains'    => 'Målkonto nummer / IBAN inneholder ikke ":trigger_value"',
    'rule_trigger_not_destination_account_nr_ends'        => 'Målkonto nummer / IBAN slutter ikke på ":trigger_value"',
    'rule_trigger_not_destination_account_nr_starts'      => 'Målkonto nummer / IBAN begynner ikke med ":trigger_value"',
    'rule_trigger_not_account_is'                         => 'Ingen konto er ":trigger_value"',
    'rule_trigger_not_account_contains'                   => 'Ingen konto inneholder ":trigger_value"',
    'rule_trigger_not_account_ends'                       => 'Ingen konto slutter på ":trigger_value"',
    'rule_trigger_not_account_starts'                     => 'Ingen konto begynner med ":trigger_value"',
    'rule_trigger_not_account_nr_is'                      => 'Ingen kontonummer / IBAN er ":trigger_value"',
    'rule_trigger_not_account_nr_contains'                => 'Ingen kontonummer / IBAN inneholder ":trigger_value"',
    'rule_trigger_not_account_nr_ends'                    => 'Ingen kontonummer / IBAN slutter på":trigger_value"',
    'rule_trigger_not_account_nr_starts'                  => 'Ingen kontonummer / IBAN starter med ":trigger_value"',
    'rule_trigger_not_category_is'                        => 'Kategori er ikke ":trigger_value"',
    'rule_trigger_not_category_contains'                  => 'Kategori inneholder ikke ":trigger_value"',
    'rule_trigger_not_category_ends'                      => 'Kategori slutter ikke på ":trigger_value"',
    'rule_trigger_not_category_starts'                    => 'Kategori starter ikke med ":trigger_value"',
    'rule_trigger_not_budget_is'                          => 'Budsjett er ikke ":trigger_value"',
    'rule_trigger_not_budget_contains'                    => 'Budsjett inneholder ikke ":trigger_value"',
    'rule_trigger_not_budget_ends'                        => 'Budsjett slutter ikke på ":trigger_value"',
    'rule_trigger_not_budget_starts'                      => 'Budsjettet starter ikke med ":trigger_value"',
    'rule_trigger_not_bill_is'                            => 'Subscription is not is ":trigger_value"',
    'rule_trigger_not_bill_contains'                      => 'Subscription does not contain ":trigger_value"',
    'rule_trigger_not_bill_ends'                          => 'Subscription does not end on ":trigger_value"',
    'rule_trigger_not_bill_starts'                        => 'Subscription does not end with ":trigger_value"',
    'rule_trigger_not_external_id_is'                     => 'Ekstern ID er ikke ":trigger_value"',
    'rule_trigger_not_external_id_contains'               => 'Ekstern ID inneholder ikke ":trigger_value"',
    'rule_trigger_not_external_id_ends'                   => 'Ekstern ID slutter ikke på ":trigger_value"',
    'rule_trigger_not_external_id_starts'                 => 'Ekstern ID starter ikke med ":trigger_value"',
    'rule_trigger_not_internal_reference_is'              => 'Intern referanse er ikke ":trigger_value"',
    'rule_trigger_not_internal_reference_contains'        => 'Intern referanse inneholder ikke ":trigger_value"',
    'rule_trigger_not_internal_reference_ends'            => 'Intern referanse slutter ikke på ":trigger_value"',
    'rule_trigger_not_internal_reference_starts'          => 'Intern referanse begynner ikke med ":trigger_value"',
    'rule_trigger_not_external_url_is'                    => 'Ekstern URL er ikke ":trigger_value"',
    'rule_trigger_not_external_url_contains'              => 'Ekstern URL inneholder ikke ":trigger_value"',
    'rule_trigger_not_external_url_ends'                  => 'Ekstern URL slutter ikke på ":trigger_value"',
    'rule_trigger_not_external_url_starts'                => 'Ekstern URL starter ikke med ":trigger_value"',
    'rule_trigger_not_currency_is'                        => 'Valuta er ikke ":trigger_value"',
    'rule_trigger_not_foreign_currency_is'                => 'Fremmed valuta er ikke ":trigger_value"',
    'rule_trigger_not_id'                                 => 'Transaksjons ID er ikke ":trigger_value"',
    'rule_trigger_not_journal_id'                         => 'Transaksjonens journal ID er ikke ":trigger_value"',
    'rule_trigger_not_recurrence_id'                      => 'Gjentakende ID er ikke ":trigger_value"',
    'rule_trigger_not_date_on'                            => 'Datoen er ikke på ":trigger_value"',
    'rule_trigger_not_date_before'                        => 'Dato er ikke før ":trigger_value"',
    'rule_trigger_not_date_after'                         => 'Datoen er ikke etter ":trigger_value"',
    'rule_trigger_not_interest_date_on'                   => 'Rentedato er ikke på ":trigger_value"',
    'rule_trigger_not_interest_date_before'               => 'Rentedato er ikke før ":trigger_value"',
    'rule_trigger_not_interest_date_after'                => 'Rentedato er ikke etter ":trigger_value"',
    'rule_trigger_not_book_date_on'                       => 'Bokføringsdato er ikke på ":trigger_value"',
    'rule_trigger_not_book_date_before'                   => 'Bokføringsdato er ikke før ":trigger_value"',
    'rule_trigger_not_book_date_after'                    => 'Bokføringsdato er ikke etter ":trigger_value"',
    'rule_trigger_not_process_date_on'                    => 'Prosessdato er ikke på ":trigger_value"',
    'rule_trigger_not_process_date_before'                => 'Prosessdato er ikke før ":trigger_value"',
    'rule_trigger_not_process_date_after'                 => 'Prosessdato er ikke etter ":trigger_value"',
    'rule_trigger_not_due_date_on'                        => 'Forfallsdato er ikke den ":trigger_value"',
    'rule_trigger_not_due_date_before'                    => 'Forfallsdato er ikke før ":trigger_value"',
    'rule_trigger_not_due_date_after'                     => 'Forfallsdato er ikke etter ":trigger_value"',
    'rule_trigger_not_payment_date_on'                    => 'Betalingsdato er ikke på ":trigger_value"',
    'rule_trigger_not_payment_date_before'                => 'Betalingsdato er ikke før ":trigger_value"',
    'rule_trigger_not_payment_date_after'                 => 'Betalingsdato er ikke etter ":trigger_value"',
    'rule_trigger_not_invoice_date_on'                    => 'Fakturadato er ikke på ":trigger_value"',
    'rule_trigger_not_invoice_date_before'                => 'Fakturadato er ikke før ":trigger_value"',
    'rule_trigger_not_invoice_date_after'                 => 'Fakturadato er ikke etter ":trigger_value"',
    'rule_trigger_not_created_at_on'                      => 'Transaksjonen er ikke opprettet på ":trigger_value"',
    'rule_trigger_not_created_at_before'                  => 'Transaksjonen er ikke opprettet før ":trigger_value"',
    'rule_trigger_not_created_at_after'                   => 'Transaksjonen er ikke opprettet etter ":trigger_value"',
    'rule_trigger_not_updated_at_on'                      => 'Transaksjonen er ikke oppdatert på ":trigger_value"',
    'rule_trigger_not_updated_at_before'                  => 'Transaksjonen er ikke oppdatert før ":trigger_value"',
    'rule_trigger_not_updated_at_after'                   => 'Transaksjonen er ikke oppdatert etter ":trigger_value"',
    'rule_trigger_not_amount_is'                          => 'Transaksjonsbeløp er ikke ":trigger_value"',
    'rule_trigger_not_amount_less'                        => 'Transaksjonsbeløp er mer enn ":trigger_value"',
    'rule_trigger_not_amount_more'                        => 'Transaksjonsbeløp er mindre enn ":trigger_value"',
    'rule_trigger_not_foreign_amount_is'                  => 'Utenlandsk transaksjonsbeløp er ikke ":trigger_value"',
    'rule_trigger_not_foreign_amount_less'                => 'Utenlandsk transaksjonsbeløp er mer enn ":trigger_value"',
    'rule_trigger_not_foreign_amount_more'                => 'Utenlandsk transaksjonsbeløp er mindre enn ":trigger_value"',
    'rule_trigger_not_attachment_name_is'                 => 'Ingen vedlegg heter ":trigger_value"',
    'rule_trigger_not_attachment_name_contains'           => 'Intet vedleggsnavn inneholder ":trigger_value"',
    'rule_trigger_not_attachment_name_starts'             => 'Ingen vedleggsnavn starter med ":trigger_value"',
    'rule_trigger_not_attachment_name_ends'               => 'Ingen vedleggsnavn slutter på ":trigger_value"',
    'rule_trigger_not_attachment_notes_are'               => 'Ingen vedlagte notater er ":trigger_value"',
    'rule_trigger_not_attachment_notes_contains'          => 'Ingen vedlagte notater inneholder ":trigger_value"',
    'rule_trigger_not_attachment_notes_starts'            => 'Ingen vedlagte notater starter med ":trigger_value"',
    'rule_trigger_not_attachment_notes_ends'              => 'Ingen vedlagte notater slutter på ":trigger_value"',
    'rule_trigger_not_reconciled'                         => 'Transaksjonen er ikke avstemt',
    'rule_trigger_not_exists'                             => 'Transaksjonen eksisterer ikke',
    'rule_trigger_not_has_attachments'                    => 'Transaksjonen har ingen vedlegg',
    'rule_trigger_not_has_any_category'                   => 'Transaksjonen har ingen kategori',
    'rule_trigger_not_has_any_budget'                     => 'Transaction has no budget',
    'rule_trigger_not_has_any_bill'                       => 'Transaction has no subscription',
    'rule_trigger_not_has_any_tag'                        => 'Transaksjonen har ingen tagger',
    'rule_trigger_not_any_notes'                          => 'Transaksjonen har ingen notater',
    'rule_trigger_not_any_external_url'                   => 'Transaksjonen har ingen ekstern URL',
    'rule_trigger_not_has_no_attachments'                 => 'Transaksjonen har et (hvilket som helst) vedlegg',
    'rule_trigger_not_has_no_category'                    => 'Transaksjonen har en (hvem som helst) kategori',
    'rule_trigger_not_has_no_budget'                      => 'Transaksjonen har et (hvilket som helst) budsjett',
    'rule_trigger_not_has_no_bill'                        => 'Transaction has a (any) subscription',
    'rule_trigger_not_has_no_tag'                         => 'Transaksjonen har en (hvilken som helst) tagg',
    'rule_trigger_not_no_notes'                           => 'Transaksjonen har notater',
    'rule_trigger_not_no_external_url'                    => 'Transaksjonen har en ekstern URL',
    'rule_trigger_not_source_is_cash'                     => 'Kildekonto er ikke en kontantkonto',
    'rule_trigger_not_destination_is_cash'                => 'Målkonto er ikke en kontantkonto',
    'rule_trigger_not_account_is_cash'                    => 'Ingen konto er en kontantkonto',

    // new account balance things.
    'rule_trigger_destination_balance_gt_choice'          => 'Destination account balance is more than..',
    'rule_trigger_destination_balance_gte_choice'         => 'Destination account balance is more than or equal to..',
    'rule_trigger_destination_balance_is_choice'          => 'Destination account balance is exactly..',
    'rule_trigger_destination_balance_lt_choice'          => 'Destination account balance is less than..',
    'rule_trigger_destination_balance_lte_choice'         => 'Destination account balance is less than or equal to..',

    'rule_trigger_source_balance_gt_choice'  => 'Source account balance is more than..',
    'rule_trigger_source_balance_gte_choice' => 'Source account balance is more than or equal to..',
    'rule_trigger_source_balance_is_choice'  => 'Source account balance is exactly..',
    'rule_trigger_source_balance_lt_choice'  => 'Source account balance is less than..',
    'rule_trigger_source_balance_lte_choice' => 'Source account balance is less than or equal to..',

    'rule_trigger_destination_balance_gt'  => 'Destination account balance is more than :trigger_value',
    'rule_trigger_destination_balance_gte' => 'Destination account balance is more than or equal to :trigger_value',
    'rule_trigger_destination_balance_is'  => 'Destination account balance is exactly :trigger_value',
    'rule_trigger_destination_balance_lt'  => 'Destination account balance is less than :trigger_value',
    'rule_trigger_destination_balance_lte' => 'Destination account balance is less than or equal to :trigger_value',

    'rule_trigger_source_balance_gt'           => 'Source account balance is more than :trigger_value',
    'rule_trigger_source_balance_gte'          => 'Source account balance is more than or equal to :trigger_value',
    'rule_trigger_source_balance_is'           => 'Source account balance is exactly :trigger_value',
    'rule_trigger_source_balance_lt'           => 'Source account balance is less than :trigger_value',
    'rule_trigger_source_balance_lte'          => 'Source account balance is less than or equal to :trigger_value',

    // NOT
    'rule_trigger_not_destination_balance_gt'  => 'Destination account balance is less than or equal to :trigger_value',
    'rule_trigger_not_destination_balance_gte' => 'Destination account balance is less than :trigger_value',
    'rule_trigger_not_destination_balance_is'  => 'Destination account balance is not :trigger_value',
    'rule_trigger_not_destination_balance_lt'  => 'Destination account balance is more than or equal to :trigger_value',
    'rule_trigger_not_destination_balance_lte' => 'Destination account balance is more than :trigger_value',

    'rule_trigger_not_source_balance_gt'         => 'Source account balance is less than or equal to :trigger_value',
    'rule_trigger_not_source_balance_gte'        => 'Source account balance is less than :trigger_value',
    'rule_trigger_not_source_balance_is'         => 'Source account balance is not :trigger_value',
    'rule_trigger_not_source_balance_lt'         => 'Source account balance is more than or equal to :trigger_value',
    'rule_trigger_not_source_balance_lte'        => 'Source account balance is more than :trigger_value',


    // actions
    // set, clear, add, remove, append/prepend
    'rule_action_delete_transaction_choice'      => 'SLETT transaksjon(!)',
    'rule_action_delete_transaction'             => 'SLETT transaksjon(!)',
    'rule_action_set_category'                   => 'Sett kategori til ":action_value"',
    'rule_action_clear_category'                 => 'Tøm kategori',
    'rule_action_set_budget'                     => 'Sett budsjett til ":action_value"',
    'rule_action_clear_budget'                   => 'Tøm budsjett',
    'rule_action_add_tag'                        => 'Legg til tagg ":action_value"',
    'rule_action_remove_tag'                     => 'Fjern tagg ":action_value"',
    'rule_action_remove_all_tags'                => 'Fjern alle tagger',
    'rule_action_set_description'                => 'Sett beskrivelse til ":action_value"',
    'rule_action_append_description'             => 'Legg til ":action_value" på slutten av beskrivelsen',
    'rule_action_prepend_description'            => 'Legg til ":action_value" på begynnelsen av beskrivelsen',
    'rule_action_set_category_choice'            => 'Sett kategori til ..',
    'rule_action_clear_category_choice'          => 'Tøm alle kategorier',
    'rule_action_set_budget_choice'              => 'Sett budsjett til ..',
    'rule_action_clear_budget_choice'            => 'Tøm alle budsjetter',
    'rule_action_add_tag_choice'                 => 'Legg til tagg ..',
    'rule_action_remove_tag_choice'              => 'Fjern tagg ..',
    'rule_action_remove_all_tags_choice'         => 'Fjern alle tagger',
    'rule_action_set_description_choice'         => 'Sett beskrivelse til ..',
    'rule_action_update_piggy_choice'            => 'Legg til / fjern transaksjonsbeløp i sparegris ..',
    'rule_action_update_piggy'                   => 'Legg til / fjern transaksjonsbeløp i sparegrisen ":action_value"',
    'rule_action_append_description_choice'      => 'Legg til i beskrivelse ..',
    'rule_action_prepend_description_choice'     => 'Legg til foran beskrivelsen med ..',
    'rule_action_set_source_account_choice'      => 'Sett kildekonto til ..',
    'rule_action_set_source_account'             => 'Sett kildekonto til :action_value',
    'rule_action_set_destination_account_choice' => 'Sett målkonto til ..',
    'rule_action_set_destination_account'        => 'Sett målkonto til :action_value',
    'rule_action_append_notes_choice'            => 'Legg til i notater med ..',
    'rule_action_append_notes'                   => 'Legg til notater med ":action_value"',
    'rule_action_prepend_notes_choice'           => 'Legg til foran i notater med ..',
    'rule_action_prepend_notes'                  => 'Legg til notater med ":action_value"',
    'rule_action_clear_notes_choice'             => 'Fjern notater',
    'rule_action_clear_notes'                    => 'Fjern notater',
    'rule_action_set_notes_choice'               => 'Sett notater til ..',
    'rule_action_link_to_bill_choice'            => 'Link to a subscription ..',
    'rule_action_link_to_bill'                   => 'Link to subscription ":action_value"',
    'rule_action_switch_accounts_choice'         => 'Bytt kilde- og destinasjonskontoer (kun for overføringer)',
    'rule_action_switch_accounts'                => 'Bytt kilde og destinasjon',
    'rule_action_set_notes'                      => 'Sett notater til ":action_value"',
    'rule_action_convert_deposit_choice'         => 'Konverter transaksjonen til et innskudd',
    'rule_action_convert_deposit'                => 'Konverter transaksjonen til et innskudd fra ":action_value"',
    'rule_action_convert_withdrawal_choice'      => 'Konverter denne transaksjonen til et uttak',
    'rule_action_convert_withdrawal'             => 'Konverter transaksjonen til et uttak til ":action_value"',
    'rule_action_convert_transfer_choice'        => 'Konverter transaksjonen til en overføring',
    'rule_action_convert_transfer'               => 'Konverter transaksjonen til en overføring med ":action_value"',
    'rule_action_append_descr_to_notes_choice'   => 'Legg til beskrivelsen på transaksjonsnotatene',
    'rule_action_append_notes_to_descr_choice'   => 'Legg transaksjonsnotater til beskrivelsen',
    'rule_action_move_descr_to_notes_choice'     => 'Erstatt gjeldende transaksjonsnotater med beskrivelsen',
    'rule_action_move_notes_to_descr_choice'     => 'Erstatt gjeldende beskrivelse med transaksjonsnotatene',
    'rule_action_append_descr_to_notes'          => 'Legg beskrivelsen til notatene',
    'rule_action_append_notes_to_descr'          => 'Legg notater til beskrivelsen',
    'rule_action_move_descr_to_notes'            => 'Erstatt notater med beskrivelse',
    'rule_action_move_notes_to_descr'            => 'Erstatt beskrivelse med notater',
    'rule_action_set_amount_choice'              => 'Set amount to ..',
    'rule_action_set_amount'                     => 'Set amount to ":action_value"',
    'rule_action_set_destination_to_cash_choice' => 'Set destination account to (cash)',
    'rule_action_set_source_to_cash_choice'      => 'Set source account to (cash)',
    'rulegroup_for_bills_title'                  => 'Rule group for subscriptions',
    'rulegroup_for_bills_description'            => 'A special rule group for all the rules that involve subscriptions.',
    'rule_for_bill_title'                        => 'Auto-generated rule for subscription ":name"',
    'rule_for_bill_description'                  => 'This rule is auto-generated to try to match subscription ":name".',
    'create_rule_for_bill'                       => 'Create a new rule for subscription ":name"',
    'create_rule_for_bill_txt'                   => 'You have just created a new subscription called ":name", congratulations! Firefly III can automagically match new withdrawals to this subscription. For example, whenever you pay your rent, the subscription "rent" will be linked to the expense. This way, Firefly III can accurately show you which subscriptions are due and which ones aren\'t. In order to do so, a new rule must be created. Firefly III has filled in some sensible defaults for you. Please make sure these are correct. If these values are correct, Firefly III will automatically link the correct withdrawal to the correct subscription. Please check out the triggers to see if they are correct, and add some if they\'re wrong.',
    'new_rule_for_bill_title'                    => 'Rule for subscription ":name"',
    'new_rule_for_bill_description'              => 'This rule marks transactions for subscription ":name".',

    'new_rule_for_journal_title'                => 'Regel basert på transaksjon ":description"',
    'new_rule_for_journal_description'          => 'Denne regelen er basert på transaksjon ":description. Det vil matche transaksjoner som er nøyaktig de samme.',

    // tags
    'store_new_tag'                             => 'Lagre ny tagg',
    'update_tag'                                => 'Oppdater tagg',
    'no_location_set'                           => 'Ingen plassering spesifisert.',
    'meta_data'                                 => 'Metadata',
    'location'                                  => 'Sted',
    'location_first_split'                      => 'The location for this transaction can be set on the first split of this transaction.',
    'without_date'                              => 'Uten dato',
    'result'                                    => 'Resultat',
    'sums_apply_to_range'                       => 'Alle beløp gjelder for det valgte området',
    'mapbox_api_key'                            => 'For å bruke kart, få en API-nøkkel fra <a href="https://www.mapbox.com/">Mapbox</a>. Åpne <code>.env</code> filen og angi denne koden etter <code>MAPBOX_API_KEY =</code>.',
    'press_object_location'                     => 'Høyreklikk eller trykk lenge for å angi objektets plassering.',
    'click_tap_location'                        => 'Click or tap the map to add a location',
    'clear_location'                            => 'Tøm lokasjon',
    'delete_all_selected_tags'                  => 'Slett alle valgte tagger',
    'select_tags_to_delete'                     => 'Ikke glem å velge noen tagger.',
    'deleted_x_tags'                            => 'Slettet :count tagg.|Slettet :count tagger.',
    'create_rule_from_transaction'              => 'Opprett regel basert på transaksjon',
    'create_recurring_from_transaction'         => 'Opprett gjentakende transaksjon basert på transaksjon',

    // preferences
    'test_notifications_buttons'                => 'To test your configuration, use the buttons below. Please note that the buttons have no spam control.',
    'dark_mode_option_browser'                  => 'La nettleseren din avgjøre',
    'dark_mode_option_light'                    => 'Alltid lys',
    'dark_mode_option_dark'                     => 'Alltid mørk',
    'equal_to_language'                         => '(likt språk)',
    'dark_mode_preference'                      => 'Mørk modus',
    'dark_mode_preference_help'                 => 'Fortell Firefly III når den skal bruke mørk modus.',
    'pref_home_screen_accounts'                 => 'Startskjermkontoer',
    'pref_home_screen_accounts_help'            => 'Hvilke kontoer skal vises på startsiden?',
    'pref_view_range'                           => 'Visningsgrense',
    'pref_view_range_help'                      => 'Noen diagrammer er automatisk gruppert i perioder. Budsjettene grupperes også i perioder. Hvilken periode foretrekker du?',
    'pref_1D'                                   => 'Én dag',
    'pref_1W'                                   => 'Én uke',
    'pref_1M'                                   => 'En måned',
    'pref_3M'                                   => 'Tre måneder (kvartal)',
    'pref_6M'                                   => 'Seks måneder',
    'pref_1Y'                                   => 'Ett år',
    'pref_last365'                              => 'I fjor',
    'pref_last90'                               => 'Siste 90 dager',
    'pref_last30'                               => 'Siste 30 dagene',
    'pref_last7'                                => 'Siste 7 dager',
    'pref_YTD'                                  => 'År til dato',
    'pref_QTD'                                  => 'Kvartal til dato',
    'pref_MTD'                                  => 'Måned til dato',
    'pref_languages'                            => 'Språk',
    'pref_locale'                               => 'Instillinger for språk',
    'pref_languages_help'                       => 'Firefly III støtter flere språk. Hvilket foretrekker du?',
    'pref_locale_help'                          => 'Firefly III lar deg velge andre lokale innstillinger, som hvordan valutaer, tall og datoer er formatert. Oppføringer i denne listen støttes kanskje ikke av systemet ditt. Firefly III har ikke riktig dato innstillinger for alle steder; kontakt meg gjerne for forbedringer.',
    'pref_locale_no_demo'                       => 'Denne funksjonen vil ikke fungere for demo-bruker.',
    'pref_convert_to_primary'                   => 'Display amounts in your primary currency',
    'pref_convert_to_primary_help'              => 'This option will make Firefly III try to display and show your primary currency in as many places as possible, converting amounts where necessary. This sacrifices accuracy for ease of use, because conversion is not always exact. Please verify that Firefly III has the necessary conversion rates on the "exchange rates"-page.',
    'pref_convert_primary_help'                 => 'Display primary amounts',
    'pref_custom_fiscal_year'                   => 'Innstillinger for regnskapsår',
    'pref_custom_fiscal_year_label'             => 'Aktivert',
    'pref_custom_fiscal_year_help'              => 'I land som bruker et annet regnskapsår enn 1. januar til 31. desember, kan du slå på dette og angi start- og sluttdager for regnskapsåret',
    'pref_fiscal_year_start_label'              => 'Regnskapsårets startdato',
    'pref_two_factor_auth'                      => 'Multi-factor authentication',
    'pref_two_factor_auth_help'                 => 'When you enable multi-factor authentication (also known as two-factor authentication), you add an extra layer of security to your account. You sign in with something you know (your password) and something you have (a verification code). Verification codes are generated by an application on your phone, such as Authy or Google Authenticator.',
    'pref_enable_two_factor_auth'               => 'Enable multi-factor authentication',
    'pref_two_factor_auth_disabled'             => 'Multi-factor authentication verification code removed and disabled',
    'pref_two_factor_auth_remove_it'            => 'Ikke glem å fjerne kontoen fra godkjenningsappen din!',
    'pref_two_factor_auth_code'                 => 'Bekreftelseskode',
    'pref_two_factor_auth_code_help'            => 'Scan the QR code with an application on your phone such as Authy or Google Authenticator and enter the generated code. The QR code changes every time you visit this page. Make sure you use the most recent one.',
    'pref_two_factor_auth_reset_code'           => 'Tilbakestill verifiseringskoden',
    'pref_two_factor_auth_disable_2fa'          => 'Disable MFA',
    '2fa_use_secret_instead'                    => 'Hvis du ikke kan skanne QR- koden, bruk gjerne "secret" i stedet: <code>:secret</code>.',
    '2fa_backup_codes'                          => 'Lagre disse sikkerhetskodene for å få tilgang i tilfelle du mister enheten.',
    '2fa_already_enabled'                       => 'Multi-factor authentication verification is already enabled.',
    'wrong_mfa_code'                            => 'Denne MFA-koden er ikke gyldig.',
    'pref_save_settings'                        => 'Lagre innstillinger',
    'saved_preferences'                         => 'Innstillinger lagret!',
    'preferences_general'                       => 'Generelt',
    'preferences_frontpage'                     => 'Startskjermen',
    'preferences_security'                      => 'Sikkerhet',
    'preferences_layout'                        => 'Oppsett',
    'preferences_notifications'                 => 'Varsler',
    'pref_home_show_deposits'                   => 'Vis innskudd på startskjermen',
    'pref_home_show_deposits_info'              => 'Startskjermen viser allerede kostnadskontoene dine. Skal den også vise inntektskontoene dine?',
    'pref_home_do_show_deposits'                => 'Ja, vis dem',
    'successful_count'                          => 'hvorav :count var vellykket',
    'list_page_size_title'                      => 'Sidestørrelse',
    'list_page_size_help'                       => 'En liste over ting (kontoer, transaksjoner osv.). Viser maksimalt dette antall elementer per side.',
    'list_page_size_label'                      => 'Sidestørrelse',
    'between_dates'                             => '(:start og :end)',
    'pref_optional_fields_transaction'          => 'Valgfrie felt for transaksjoner',
    'pref_optional_fields_transaction_help'     => 'Som standard er ikke alle felt aktivert når du oppretter en ny transaksjon (for å unngå forvirring). Nedenfor kan du aktivere disse feltene hvis du tror de kan være nyttige for deg. Selvfølgelig vil et felt som er deaktivert, men allerede fylt inn, være synlig, uavhengig av innstillingen.',
    'optional_tj_date_fields'                   => 'Datofelter',
    'optional_tj_other_fields'                  => 'Andre felt',
    'optional_tj_attachment_fields'             => 'Vedleggsfelter',
    'pref_optional_tj_interest_date'            => 'Rentedato',
    'pref_optional_tj_book_date'                => 'Bokføringsdato',
    'pref_optional_tj_process_date'             => 'Prosesseringsdato',
    'pref_optional_tj_due_date'                 => 'Forfallsdato',
    'pref_optional_tj_payment_date'             => 'Betalingsdato',
    'pref_optional_tj_invoice_date'             => 'Fakturadato',
    'pref_optional_tj_internal_reference'       => 'Intern referanse',
    'pref_optional_tj_notes'                    => 'Notater',
    'pref_optional_tj_attachments'              => 'Vedlegg',
    'pref_optional_tj_external_url'             => 'Ekstern URL',
    'pref_optional_tj_location'                 => 'Sted',
    'pref_optional_tj_links'                    => 'Transaksjons linker',
    'optional_field_meta_dates'                 => 'Datoer',
    'optional_field_meta_business'              => 'Bedrift',
    'optional_field_attachments'                => 'Vedlegg',
    'optional_field_meta_data'                  => 'Valgfri metadata',
    'external_url'                              => 'Ekstern URL',
    'pref_notification_login_failure'           => 'Login failure',
    'pref_notification_bill_reminder'           => 'Reminder about expiring subscriptions',
    'pref_notification_new_access_token'        => 'Varsle når et nytt API tilgangstoken er opprettet',
    'pref_notification_transaction_creation'    => 'Varsle når en transaksjon opprettes automatisk',
    'pref_notification_user_login'              => 'Varsle når du logger inn fra et nytt sted',
    'pref_notification_rule_action_failures'    => 'Alert when rule actions fail to execute (not over email)',
    'pref_notification_new_password'            => 'Your password changed',
    'pref_notification_enabled_mfa'             => 'Multi factor authentication is enabled',
    'pref_notification_disabled_mfa'            => 'Multi factor authentication is disabled',
    'pref_notification_few_left_mfa'            => 'You have just a few backup codes left',
    'pref_notification_no_left_mfa'             => 'You have no backup codes left',
    'pref_notification_many_failed_mfa'         => 'The multi factor authentication check keeps failing',
    'pref_notification_new_backup_codes'        => 'New backup codes have been generated',
    'pref_notifications'                        => 'Varslinger',
    'pref_notifications_help'                   => 'Angi om dette er varsler du ønsker å få. Noen meldinger kan inneholde sensitiv økonomisk informasjon.',
    'pref_notifications_settings'               => 'Notifications settings',
    'pref_notifications_settings_help'          => 'Use these settings to configure your notification channels. Please note that notifications will be sent to ALL channels. Please save your settings FIRST.',
    'slack_url_label'                           => 'Slack "innkommende webhook" URL',
    'discord_url_label'                         => 'Discord webhook URL',

    // exchange rates
    'menu_exchange_rates_index'                 => 'Exchange rates',
    'header_exchange_rates'                     => 'Exchange rates',
    'exchange_rates_intro'                      => 'Firefly III supports downloading and using exchange rates. Read more about this in <a href="https://docs.firefly-iii.org/explanation/financial-concepts/exchange-rates/">the documentation</a>.',
    'exchange_rates_from_to'                    => 'Between {from} and {to} (and the other way around)',
    'header_exchange_rates_rates'               => 'Exchange rates',
    'exchange_rates_intro_rates'                => 'Firefly III uses the following exchange rates. The inverse is automatically calculated when it is not provided. If no exchange rate exists for the date of the transaction, Firefly III will go back in time to find one. If none are present, the rate "1" will be used.',
    'header_exchange_rates_table'               => 'Table with exchange rates',
    'help_rate_form'                            => 'On this day, how many {to} will you get for one {from}?',
    'save_new_rate'                             => 'Save new rate',
    'add_new_rate'                              => 'Add a new exchange rate',
    'not_enough_currencies'                     => 'Not enough currencies',
    'not_enough_currencies_enabled'             => 'If you have just one currency enabled, there is no need to add exchange rates.',

    // Financial administrations
    'administration_index'                      => 'Økonomisk administrasjon',
    'administrations_breadcrumb'                => 'Financial administrations',
    'administrations_page_title'                => 'Financial administrations',
    'administrations_index_menu'                => 'Financial administrations',
    'administrations_page_sub_title'            => 'Overview',
    'create_administration'                     => 'Create new administration',
    'administration_owner'                      => 'Administration owner: {{email}}',
    'administration_you'                        => 'Your role: {{role}}',
    'other_users_in_admin'                      => 'Other users in this administration',
    'administrations_create_breadcrumb'         => 'Create new financial administration',
    'administrations_page_create_sub_title'     => 'Create new financial administration',
    'basic_administration_information'          => 'Basic administration information',
    'new_administration_created'                => 'New financial administration "{{title}}" has been created',
    'edit_administration_breadcrumb'            => 'Edit financial administration ":title"',
    'administrations_page_edit_sub_title'       => 'Edit financial administration ":title"',
    'administrations_page_edit_sub_title_js'    => 'Edit financial administration "{title}"',
    'temp_administrations_introduction'         => 'Firefly III will soon get the ability to manage multiple financial administrations. Right now, you only have the one. You can set the title of this administration and its primary currency. This replaces the previous setting where you would set your "default currency". This setting is now tied to the financial administration and can be different per administration.',
    'temp_administrations_introduction_edit'    => 'Currently, you can only set the "primary currency" of the default financial administration. This replaces the "default currency" setting. This setting is now tied to the financial administration and can be different per administration.',
    'administration_currency_form_help'         => 'It may take a long time for the page to load if you change the primary currency because transaction may need to be converted to your (new) primary currency.',
    'flash_administration_updated'              => 'Administration ":title" has been updated',
    'flash_administration_created'              => 'Administration ":title" has been created',
    'flash_administration_deleted'              => 'Administration ":title" has been deleted',

    // roles
    'administration_role_owner'                 => 'Owner',
    'administration_role_ro'                    => 'Read-only',
    'administration_role_mng_trx'               => 'Manage transactions',
    'administration_role_mng_meta'              => 'Manage classification and meta-data',
    'administration_role_mng_budgets'           => 'Manage budgets',
    'administration_role_mng_piggies'           => 'Manage piggy banks',
    'administration_role_mng_subscriptions'     => 'Manage subscriptions',
    'administration_role_mng_rules'             => 'Manage rules',
    'administration_role_mng_recurring'         => 'Manage recurring transactions',
    'administration_role_mng_webhooks'          => 'Manage webhooks',
    'administration_role_mng_currencies'        => 'Manage currencies',
    'administration_role_view_reports'          => 'View reports',
    'administration_role_full'                  => 'Full access',

    // mfa
    'enable_mfa'                                => 'Enable multi-factor authentication',
    'mfa_index_title'                           => 'Multi-factor authentication',
    'mfa_index_intro'                           => 'Firefly III supports multi-factor authentication (MFA). You can enable MFA for your account to add an extra layer of security. Applications like Authy, Google Authenticator and FreeOTP can be used to generate the codes you need to log in. Security keys are not supported by Firefly III but you can use a security key as a storage device for your MFA secret.',
    'mfa_index_enabled'                         => 'Multi-factor authentication is enabled for your account.',
    'mfa_index_disabled'                        => 'Multi-factor authentication is not enabled for your account.',
    'mfa_index_owner'                           => 'The owner of this instance will always be able to disable multi-factor authentication for your account.',
    'current_password_confirm_mfa'              => 'Enter your current password',
    'mfa_warning_code_changes'                  => 'You may get a MFA dialog after you entered your password and a MFA code. In that case, please wait for your application to generate a new MFA code, and do not recycle the one you just used.',
    'mfa_already_disabled'                      => 'Multi-factor authentication is not enabled, so you cannot disable it.',
    'disable_mfa_page'                          => 'Disable multi-factor authentication',
    'disable_mfa_intro'                         => 'You can disable multi-factor authentication. To do so, please enter your password and a multi-factor authentication code. If you want to disable multi-factor authentication because you have lost access to your code generator, <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">please refer to the documentation instead</a>.',
    'pref_disable_mfa'                          => 'Disable multi-factor authentication',
    'mfa_not_enabled'                           => 'Multi-factor authentication is not enabled.',
    'mfa_backup_codes_intro'                    => 'Firefly III can generate backup codes for you. These codes can be used to log in when you cannot use your code generator. You can generate a new set of codes at any time. If you generate a new set, the old set will be invalidated.',
    'mfa_backup_codes_quick'                    => 'If you are very fast coming from the setup page of multi-factor authentication, your app may not have generated a new code yet. Please know that MFA codes can only be used once. Make sure you use a different code from the previous one.',
    'mfa_backup_codes_title'                    => 'Multi-factor authentication backup codes',
    'mfa_backup_codes_post_title'               => 'Multi-factor authentication backup codes',

    // profile:
    'manage_mfa_settings'                       => 'Manage multi-factor authentication settings',
    'purge_data_title'                          => 'Fjern data fra Firefly III',
    'purge_data_expl'                           => '"Purging / fjerning" betyr "slett det som allerede er slettet". I normale omstendigheter sletter Firefly III ingenting permanent. Det gjemmer det. Knappen under sletter alle disse tidligere "slettet" oppføringene FOR ALLTID.',
    'delete_stuff_header'                       => 'Slett og fjern data',
    'purge_all_data'                            => 'Fjern alle slettede poster',
    'purge_data'                                => 'Fjern data',
    'purged_all_records'                        => 'Alle slettede poster har blitt fjernet.',
    'delete_data_title'                         => 'Slett data fra Firefly III',
    'permanent_delete_stuff'                    => 'Du kan slette ting fra Firefly III. Ved å bruke knappene under betyr at oppføringene dine vil bli fjernet fra visning og skjult. Det er ikke mulig å angre på dette, men elementene kan forbli i databasen hvor du kan hente dem tilbake om nødvendig.',
    'other_sessions_logged_out'                 => 'Alle dine andre økter har blitt logget ut.',
    'delete_unused_accounts'                    => 'Sletting av ubrukte kontoer vil tømme auto-fullfør listene dine.',
    'delete_all_unused_accounts'                => 'Slette ubrukte kontoer',
    'deleted_all_unused_accounts'               => 'Alle ubrukte kontoer er slettet',
    'delete_all_budgets'                        => 'Slett ALLE budsjetter',
    'delete_all_categories'                     => 'Slett ALLE kategoriene dine',
    'delete_all_tags'                           => 'Slett ALLE taggene dine',
    'delete_all_bills'                          => 'Delete ALL your subscriptions',
    'delete_all_piggy_banks'                    => 'Slett ALLE sparegriser',
    'delete_all_rules'                          => 'Slett ALLE reglene dine',
    'delete_all_recurring'                      => 'Slett ALLE gjentakende transaksjoner',
    'delete_all_object_groups'                  => 'Slett ALLE objektgrupper',
    'delete_all_accounts'                       => 'Slett ALLE kontoene dine',
    'delete_all_asset_accounts'                 => 'Slett ALLE aktivakontoene dine',
    'delete_all_expense_accounts'               => 'Slett ALLE utgiftskontoene dine',
    'delete_all_revenue_accounts'               => 'Slett ALLE inntektskontoene dine',
    'delete_all_liabilities'                    => 'Slett ALLE forpliktelser',
    'delete_all_transactions'                   => 'Slett ALLE transaksjonene dine',
    'delete_all_withdrawals'                    => 'Slett ALLE uttakene dine',
    'delete_all_deposits'                       => 'Slett ALLE innskudd',
    'delete_all_transfers'                      => 'Slett ALLE overføringer',
    'also_delete_transactions'                  => 'Å slette kontoer vil også slette ALLE assosierte uttak, innskudd og overføringer!',
    'deleted_all_budgets'                       => 'Alle budsjetter har blitt slettet',
    'deleted_all_categories'                    => 'Alle kategorier har blitt slettet',
    'deleted_all_tags'                          => 'Alle tagger har blitt slettet',
    'deleted_all_bills'                         => 'All subscriptions have been deleted',
    'deleted_all_piggy_banks'                   => 'Alle sparegriser er slettet',
    'deleted_all_rules'                         => 'Alle regler og regelgrupper er slettet',
    'deleted_all_object_groups'                 => 'Alle grupper har blitt slettet',
    'deleted_all_accounts'                      => 'Alle kontoer er slettet',
    'deleted_all_asset_accounts'                => 'Alle aktivakontoer har blitt slettet',
    'deleted_all_expense_accounts'              => 'Alle utgiftskontoer er slettet',
    'deleted_all_revenue_accounts'              => 'Alle inntektskontoer er slettet',
    'deleted_all_liabilities'                   => 'Alle forpliktelser har blitt slettet',
    'deleted_all_transactions'                  => 'Alle transaksjoner har blitt slettet',
    'deleted_all_withdrawals'                   => 'Alle uttak er slettet',
    'deleted_all_deposits'                      => 'Alle innskudd er slettet',
    'deleted_all_transfers'                     => 'Alle overføringer er slettet',
    'deleted_all_recurring'                     => 'Alle gjentakende transaksjoner har blitt slettet',
    'change_your_password'                      => 'Endre passord',
    'delete_account'                            => 'Slett konto',
    'current_password'                          => 'Nåværende passord',
    'new_password'                              => 'Nytt passord',
    'new_password_again'                        => 'Nytt passord (gjenta)',
    'delete_your_account'                       => 'Slett din konto',
    'delete_your_account_help'                  => 'Hvis du sletter brukerkontoen din, slettes også alle kontoer, transaksjoner, <em>og alt annet</em> du har lagret i Firefly III. Det blir BORTE.',
    'delete_your_account_password'              => 'Skriv inn passordet ditt for å fortsette.',
    'password'                                  => 'Passord',
    'are_you_sure'                              => 'Er du sikker? Du kan ikke angre på dette.',
    'are_you_sure_confirm'                      => 'Are you sure?',
    'delete_account_button'                     => 'SLETT din konto',
    'invalid_current_password'                  => 'Ugyldig nåværende passord!',
    'password_changed'                          => 'Passord endret!',
    'should_change'                             => 'Tanken er å endre passordet ditt.',
    'invalid_password'                          => 'Ugyldig passord!',
    'what_is_pw_security'                       => 'Hva er "sjekk passordsikkerhet"?',
    'secure_pw_title'                           => 'Hvordan velge et sikkert passord',
    'forgot_password_response'                  => 'Takk skal du ha. Hvis det finnes en konto med denne e-postadressen, finner du instruksjoner i innboksen din.',
    'secure_pw_history'                         => 'Ikke en uke går uten at du leser i nyhetene om et nettsted som har mistet passord for brukerne sine. Hackere og tyver bruker disse passordene for å prøve å stjele din private informasjon. Denne informasjonen er verdifull.',
    'secure_pw_ff'                              => 'Bruker du det samme passordet over alt på Internett? Hvis bare ett nettsted mister passordet, har hackere tilgang til alle dataene dine. Firefly III er avhengig av at du velger et sterkt og unikt passord for å beskytte dine finansielle data.',
    'secure_pw_check_box'                       => 'For å hjelpe deg kan Firefly III sjekke om passordet du vil bruke har blitt stjålet tidligere. Hvis dette er tilfelle, råder Firefly III deg til ikke å bruke dette passordet.',
    'secure_pw_working_title'                   => 'Hvordan virker det?',
    'secure_pw_working'                         => 'Ved å huke av denne boksen vil Firefly III sende de fem første tegnene til SHA1-hashen av passordet ditt til <a href="https://www.troyhunt.com/introducing-306-million-freely-downloadable-pwned-passwords/">nettsiden til Troy Hunt</a> for å se om det er på listen hans. Dette vil stoppe deg fra å bruke usikre passord som anbefalt i den siste <a href="https://pages.nist.gov/800-63-3/sp800-63b.html">spesialpublikasjonen fra NIST</a> om dette emnet.',
    'secure_pw_should'                          => 'Bør jeg huke av boksen?',
    'secure_pw_long_password'                   => 'Ja. Alltid bekreft at passordet ditt er trygt.',
    'command_line_token'                        => 'Kommandolinjenøkkel',
    'explain_command_line_token'                => 'Du trenger dette "token" for å utføre kommander på kommandolinje som f. eks. importere eller eksportere. Uten dette tegnet fungerer ikke kommandoene. Ikke del din kommandolinje token. Ingen vil spørre deg om dette spesialtegnet, ikke engang meg. Hvis du frykter at du har mistet dette, eller ved paranoia, trykk på knappen for å generere et nytt "token".',
    'regenerate_command_line_token'             => 'Regenerer kommandolinjenøkkel',
    'token_regenerated'                         => 'En ny kommandolinjenøkkel ble generert',
    'change_your_email'                         => 'Endre din epostadresse',
    'email_verification'                        => 'An email message will be sent to your old AND new email address. For security purposes, you will not be able to login until you verify your new email address. If you are unsure if your Firefly III installation is capable of sending email, please do not use this feature. If you are an administrator, you can test this in the <a href="settings">settings</a>.',
    'email_changed_logout'                      => 'Inntil du bekrefter e-postadressen din, kan du ikke logge inn.',
    'login_with_new_email'                      => 'Du kan nå logge inn med din nye e-postadresse.',
    'login_with_old_email'                      => 'Du kan nå logge inn med din gamle e-postadresse igjen.',
    'login_provider_local_only'                 => 'Denne handlingen er ikke tilgjengelig ved godkjenning gjennom ":login_provider".',
    'external_user_mgt_disabled'                => 'Denne handlingen er ikke tilgjengelig når Firefly III ikke er ansvarlig for brukerstyring eller autentiseringshåndtering.',
    'external_auth_disabled'                    => 'Denne handlingen er ikke tilgjengelig når Firefly III ikke er ansvarlig for autentiseringshåndtering.',
    'delete_local_info_only'                    => "Fordi Firefly III ikke er ansvarlig for brukerstyring eller autentiseringshåndtering, vil denne funksjonen bare slette lokal informasjon om Firefly III.",
    'oauth'                                     => 'OAuth',
    'profile_oauth_clients'                     => 'OAuth klienter',
    'profile_oauth_no_clients'                  => 'Du har ikke opprettet noen OAuth klienter.',
    'profile_oauth_clients_external_auth'       => 'Hvis du bruker en ekstern autentiseringsleverandør, som Authelia, vil ikke OAuth klienter fungere. Du kan bare bruke personlige tilgangstokener.',
    'profile_oauth_clients_header'              => 'Klienter',
    'profile_oauth_client_id'                   => 'Klient-ID',
    'profile_oauth_client_name'                 => 'Navn',
    'profile_oauth_client_secret'               => 'Secret',
    'profile_oauth_create_new_client'           => 'Opprett Ny Klient',
    'profile_oauth_create_client'               => 'Opprett Klient',
    'profile_oauth_edit_client'                 => 'Rediger Klient',
    'profile_oauth_name_help'                   => 'Noe brukerne dine vil gjenkjenne og stole på.',
    'profile_oauth_redirect_url'                => 'Videresendings-URL',
    'profile_oauth_redirect_url_help'           => 'Programmets tilbakekallingslenke til din adresse.',
    'profile_authorized_apps'                   => 'Dine autoriserte applikasjoner',
    'profile_authorized_clients'                => 'Autoriserte klienter',
    'profile_scopes'                            => 'Omfang',
    'profile_revoke'                            => 'Tilbakekall',
    'profile_oauth_client_secret_title'         => 'Klient hemmilghet',
    'profile_oauth_client_secret_expl'          => 'Her er din nye klient hemmelighet. Dette er den eneste tiden det blir vist så ikke mister den! Du kan nå bruke denne hemmeligheten til å lage API-forespørsler.',
    'profile_personal_access_tokens'            => 'Personlig tilgangsnøkkel (Tokens)',
    'profile_personal_access_token'             => 'Personlig tilgangsnøkkel (Token)',
    'profile_oauth_confidential'                => 'Konfidensiell',
    'profile_oauth_confidential_help'           => 'Require the client to authenticate with a secret. Confidential clients can hold credentials in a secure way without exposing them to unauthorized parties. Public applications, such as native desktop or JavaScript SPA applications, are unable to hold secrets securely.',
    'profile_personal_access_token_explanation' => 'Her er din nye klient "secret". Dette er den eneste tiden det blir vist så ikke mister den! Du kan nå bruke denne token til å lage API-forespørsler.',
    'profile_no_personal_access_token'          => 'Du har ikke opprettet noen personlig tilgangsnøkkel (tokens).',
    'profile_create_new_token'                  => 'Opprette nytt token',
    'profile_create_token'                      => 'Opprett token',
    'profile_create'                            => 'Opprett',
    'profile_save_changes'                      => 'Lagre endringer',
    'profile_whoops'                            => 'Whoops!',
    'profile_something_wrong'                   => 'Noe gikk galt!',
    'profile_try_again'                         => 'Noe gikk galt. Prøv på nytt.',
    'amounts'                                   => 'Beløp',
    'multi_account_warning_unknown'             => 'Avhengig av hvilken type transaksjon du oppretter, Kilden og/eller destinasjonskonto for etterfølgende delinger kan overstyres av det som er definert i transaksjonens første del.',
    'multi_account_warning_withdrawal'          => 'Husk at kildekontoen for etterfølgende oppsplitting skal overlates av hva som defineres i den første delen av uttrekket.',
    'multi_account_warning_deposit'             => 'Husk at mottakerkontoen for etterfølgende oppsplitting skal overstyres av det som er definert i den første delen av depositumet.',
    'multi_account_warning_transfer'            => 'Husk at kildens pluss destinasjonskonto med etterfølgende oppdeling overstyres av det som er definert i en første del av overføringen.',


    // export data:
    'export_data_title'                         => 'Eksportere data fra Firefly III',
    'export_data_menu'                          => 'Eksporter data',
    'export_data_bc'                            => 'Eksportere data fra Firefly III',
    'export_data_main_title'                    => 'Importer data til Firefly III',
    'export_data_expl'                          => 'Denne lenken lar deg eksportere alle transaksjoner + metadata fra Firefly III. Referer til hjelp (øverst til høyre (?)-ikon) for mer informasjon om prosessen.',
    'export_data_all_transactions'              => 'Eksportere alle transaksjoner',
    'export_data_advanced_expl'                 => 'Dersom du trenger en mer avansert eller spesifikk type eksport, les "hjelpen" om hvordan man bruker konsollkommandoen <code>php artisan help firefly-ii:export-data</code>.',

    // attachments
    'nr_of_attachments'                         => 'Ett vedlegg|:count vedlegg',
    'attachments'                               => 'Vedlegg',
    'edit_attachment'                           => 'Rediger vedlegg ":name"',
    'update_attachment'                         => 'Oppdater vedlegget',
    'delete_attachment'                         => 'Slett vedlegg ":name"',
    'attachment_deleted'                        => 'Slettet vedlegg ":name"',
    'liabilities_deleted'                       => 'Slettet gjeld ":name"',
    'attachment_updated'                        => 'Oppdatert vedlegg ":name"',
    'upload_max_file_size'                      => 'Maks filstørrelse: :size',
    'list_all_attachments'                      => 'Liste over alle vedlegg',

    // transaction index
    'is_reconciled_fields_dropped'              => 'Because this transaction is reconciled, you will not be able to update the accounts, nor the amount(s) unless you remove the reconciliation flag.',
    'is_reconciled'                             => 'Is reconciled',
    'title_expenses'                            => 'Utgifter',
    'title_withdrawal'                          => 'Utgifter',
    'title_revenue'                             => 'Inntekt',
    'title_deposit'                             => 'Inntekt',
    'title_transfer'                            => 'Overføringer',
    'title_transfers'                           => 'Overføringer',
    'submission_options'                        => 'Alternativer for innsending',
    'apply_rules_checkbox'                      => 'Bruk regler',
    'fire_webhooks_checkbox'                    => 'Fire webhooks',
    'select_source_account'                     => 'Please select or type a valid source account name',
    'select_dest_account'                       => 'Please select or type a valid destination account name',

    // convert stuff:
    'convert_is_already_type_Withdrawal'        => 'Denne transaksjonen er allerede et uttak',
    'convert_is_already_type_Deposit'           => 'Denne transaksjonen er allerede et innskudd',
    'convert_is_already_type_Transfer'          => 'Denne transaksjonen er allerede en overføring',
    'convert_to_Withdrawal'                     => 'Konverter ":description" til et uttak',
    'convert_to_Deposit'                        => 'Konverter ":description" til et innskudd',
    'convert_to_Transfer'                       => 'Konverter ":description" til en overføring',
    'convert_options_WithdrawalDeposit'         => 'Konverter et uttak til et innskudd',
    'convert_options_WithdrawalTransfer'        => 'Konverter et uttak til en overføring',
    'convert_options_DepositTransfer'           => 'Konverter et innskudd til en overføring',
    'convert_options_DepositWithdrawal'         => 'Konverter et innskudd til et uttak',
    'convert_options_TransferWithdrawal'        => 'Konverter en overføring til et uttak',
    'convert_options_TransferDeposit'           => 'Konverter en overføring til et innskudd',
    'convert_Withdrawal_to_deposit'             => 'Konverter dette uttaket til et innskudd',
    'convert_Withdrawal_to_transfer'            => 'Konverter dette uttaket til en overføring',
    'convert_Deposit_to_withdrawal'             => 'Konverter dette innskuddet til et uttak',
    'convert_Deposit_to_transfer'               => 'Konverter dette innskuddet til en overføring',
    'convert_Transfer_to_deposit'               => 'Konverter denne overføringen til et innskudd',
    'convert_Transfer_to_withdrawal'            => 'Konverter denne overføringen til et uttak',
    'convert_please_set_revenue_source'         => 'Vennligst velg inntektskontoen pengene vil komme fra.',
    'convert_please_set_asset_destination'      => 'Vennligst velg aktivakontoen pengene skal gå til.',
    'convert_please_set_expense_destination'    => 'Vennligst velg utgiftsskontoen pengene skal gå til.',
    'convert_please_set_asset_source'           => 'Vennligst velg aktivakontoen pengene kommer fra.',
    'convert_expl_w_d'                          => 'Når du konverterer fra et uttak til et innskudd, blir pengene deponert på den angitte målkontoen, i stedet for å bli trukket ut av den. |Når du går over fra et uttak til et innskudd, vil pengene bli deponert til målkontoene som er vist, i stedet for å bli trukket fra dem.',
    'convert_expl_w_t'                          => 'Ved konvertering fra uttak til overføring, vil pengene overføres fra kildekontoen til andre aktiva eller gjeld i stedet for å bli brukt på den opprinnelige utgiftskontoen.|Ved konvertering fra uttak til overføring, vil pengene overføres fra kildekontoene til andre aktiva eller gjeldskontoer i stedet for å bli brukt på den opprinnelige utgiftskontoen.',
    'convert_expl_d_w'                          => 'Når et innskudd blir konvertert til et uttak, vil pengene tas ut fra den viste kildekontoen i stedet for å bli satt inn på den.|Når et innskudd blir konvertert til et uttak, vil pengene tas ut fra de viste kildekontoene i stedet for å bli satt inn på dem.',
    'convert_expl_d_t'                          => 'When you convert a deposit into a transfer, the money will be deposited into the listed destination account from any of your asset or liability account.|When you convert a deposit into a transfer, the money will be deposited into the listed destination accounts from any of your asset or liability accounts.',
    'convert_expl_t_w'                          => 'When you convert a transfer into a withdrawal, the money will be spent on the destination account you set here, instead of being transferred away.|When you convert a transfer into a withdrawal, the money will be spent on the destination accounts you set here, instead of being transferred away.',
    'convert_expl_t_d'                          => 'When you convert a transfer into a deposit, the money will be deposited into the destination account you see here, instead of being transferred into it.|When you convert a transfer into a deposit, the money will be deposited into the destination accounts you see here, instead of being transferred into them.',
    'convert_select_sources'                    => 'For å fullføre konverteringen, vennligst angi den nye kildekontoen under. For å fullføre konverteringen, må du angi de nye kildekontoene nedenfor.',
    'convert_select_destinations'               => 'For å fullføre konverteringen må du velge den nye destinasjonskontoen under. For å fullføre konverteringen, velg de nye destinasjonskontoene nedenfor.',
    'converted_to_Withdrawal'                   => 'Transaksjonen er konvertert til et uttak',
    'converted_to_Deposit'                      => 'Transaksjonen er konvertert til et innskudd',
    'converted_to_Transfer'                     => 'Transaksjonen er konvertert til en overføring',
    'invalid_convert_selection'                 => 'Kontoen du har valgt er allerede brukt i denne transaksjonen eller finnes ikke.',
    'source_or_dest_invalid'                    => 'Finner ikke riktig transaksjonsdetaljer. Konvertering er ikke mulig.',
    'convert_to_withdrawal'                     => 'Konverter til et uttak',
    'convert_to_deposit'                        => 'Konverter til et innskudd',
    'convert_to_transfer'                       => 'Konverter til en overføring',

    // create new stuff:
    'create_new_withdrawal'                     => 'Opprett nytt uttak',
    'create_new_deposit'                        => 'Opprett nytt innskudd',
    'create_new_transfer'                       => 'Opprett ny overføring',
    'create_new_asset'                          => 'Opprett ny aktivakonto',
    'create_new_liabilities'                    => 'Opprett ny gjeld',
    'create_new_expense'                        => 'Opprett ny utgiftskonto',
    'create_new_revenue'                        => 'Opprett ny inntektskonto',
    'create_new_piggy_bank'                     => 'Opprett ny sparegris',
    'create_new_bill'                           => 'Create new subscription',
    'create_new_subscription'                   => 'Opprett nytt abonnement',
    'create_new_rule'                           => 'Opprett ny regel',

    // currencies:
    'create_currency'                           => 'Opprett en ny valuta',
    'store_currency'                            => 'Lagre ny valuta',
    'update_currency'                           => 'Oppdater valuta',
    'new_default_currency'                      => '":name" er nå standardvaluta.',
    'default_currency_failed'                   => 'Kunne ikke sette ":name" til standard valuta. Vennligst sjekk loggene.',
    'cannot_delete_currency'                    => 'Kan ikke slette :name fordi det er fortsatt i bruk.',
    'cannot_delete_fallback_currency'           => ':name er systemet standardvaluta og kan ikke slettes.',
    'cannot_disable_currency_journals'          => 'Kan ikke deaktivere :name fordi det er transaksjoner som fortsatt bruker den.',
    'cannot_disable_currency_last_left'         => 'Kan ikke deaktivere :name fordi det er ingen andre aktiverte valutaer.',
    'cannot_disable_currency_account_meta'      => 'Kan ikke deaktivere :name fordi den brukes i aktivakontoer.',
    'cannot_disable_currency_bills'             => 'Cannot disable :name because it is used in subscriptions.',
    'cannot_disable_currency_recurring'         => 'Kan ikke deaktivere :name fordi den brukes i gjentakende transaksjoner.',
    'cannot_disable_currency_available_budgets' => 'Kan ikke deaktivere :name fordi det brukes i tilgjengelige budsjetter.',
    'cannot_disable_currency_budget_limits'     => 'Kan ikke deaktivere :name fordi det brukes i budsjettgrensene.',
    'cannot_disable_currency_current_default'   => 'Kan ikke deaktivere :name fordi den er den gjeldende standardvalutaen.',
    'cannot_disable_currency_system_fallback'   => 'Kan ikke deaktivere :name fordi den er systemets standardvaluta.',
    'disable_EUR_side_effects'                  => 'Euro er systemets nødvaluta. Å deaktivere den kan føre til utilsiktede bivirkninger og kan gjøre garantien ugyldig.',
    'deleted_currency'                          => 'Valuta :name slettet',
    'created_currency'                          => 'Valuta :name opprettet',
    'could_not_store_currency'                  => 'Kan ikke lagre den nye valutaen.',
    'updated_currency'                          => 'Valuta :name oppdatert',
    'ask_site_owner'                            => 'Spør :owner om å legge til, fjerne eller redigere valutaer.',
    'currencies_intro'                          => 'Firefly III støtter ulike valutaer som du kan definere og aktivere her.',
    'currencies_switch_default'                 => 'You can switch the primary currency for your current administration on the "Financial administrations"-page.',
    'make_default_currency'                     => 'Sett som standard',
    'default_currency'                          => 'standard',
    'primary_currency_button'                   => 'primary',
    'currency_is_disabled'                      => 'Deaktivert',
    'enable_currency'                           => 'Aktiver',
    'disable_currency'                          => 'Deaktiver',
    'currencies_default_disabled'               => 'De fleste valutaene er deaktivert som standard. For å bruke dem, må du aktivere dem først.',
    'currency_is_now_enabled'                   => 'Valuta ":name" er aktivert',
    'could_not_enable_currency'                 => 'Kunne ikke aktivere valuta ":name". Vennligst se gjennom loggene.',
    'currency_is_now_disabled'                  => 'Valuta ":name" er deaktivert',
    'could_not_disable_currency'                => 'Kan ikke deaktivere valuta ":name". Kanskje den fortsatt er i bruk?',

    // forms:
    'mandatoryFields'                           => 'Obligatoriske felter',
    'optionalFields'                            => 'Valgfrie felter',
    'options'                                   => 'Alternativer',

    // budgets:
    'daily_budgets'                             => 'Daglige budsjetter',
    'weekly_budgets'                            => 'Ukentlige budsjetter',
    'monthly_budgets'                           => 'Månedlige budsjetter',
    'quarterly_budgets'                         => 'Kvartalsvise budsjetter',
    'half_year_budgets'                         => 'Halvårlige budsjetter',
    'yearly_budgets'                            => 'Årlige budsjetter',
    'other_budgets'                             => 'Egne tidsinnstilte budsjetter',
    'budget_limit_not_in_range'                 => 'Dette beløpet gjelder fra :start til :end:',
    'total_available_budget'                    => 'Totalt tilgjengelig budsjett (mellom :start og :end)',
    'total_available_budget_in_currency'        => 'Totalt tilgjengelig budsjett i :currency',
    'see_below'                                 => 'se nedenfor',
    'create_new_budget'                         => 'Opprett et nytt budsjett',
    'store_new_budget'                          => 'Lagre nytt budsjett',
    'stored_new_budget'                         => 'Lagret nytt budsjett ":name"',
    'available_between'                         => 'Tilgjengelig mellom :start og :end',
    'transactionsWithoutBudget'                 => 'Utgifter uten budsjett',
    'transactions_no_budget'                    => 'Utgifter uten budsjett mellom :start og :end',
    'spent_between'                             => 'Allerede brukt mellom :start og :end',
    'spent_between_left'                        => 'Spent :spent between :start and :end, leaving :left.',
    'set_available_amount'                      => 'Sett tilgjengelig beløp',
    'update_available_amount'                   => 'Oppdater tilgjengelig beløp',
    'ab_basic_modal_explain'                    => 'Bruk dette skjemaet til å angi hvor mye du forventer å kunne budsjettere (i :currency) i den angitte perioden.',
    'createBudget'                              => 'Nytt budsjett',
    'invalid_currency'                          => 'Dette er en ugyldig valuta',
    'invalid_amount'                            => 'Vennligst skriv inn et beløp',
    'set_ab'                                    => 'Det tilgjengelige budsjettbeløpet er satt',
    'updated_ab'                                => 'Det tilgjengelige budsjettbeløpet har blitt oppdatert',
    'deleted_ab'                                => 'Det tilgjengelige budsjettbeløpet har blitt slettet',
    'deleted_bl'                                => 'Det budsjetterte beløpet er fjernet',
    'alt_currency_ab_create'                    => 'Sett tilgjengelig budsjett i annen valuta',
    'bl_create_btn'                             => 'Angi budsjett i annen valuta',
    'inactiveBudgets'                           => 'Inaktive budsjetter',
    'without_budget_between'                    => 'Transaksjoner uten et budsjett mellom :start og :end',
    'delete_budget'                             => 'Slett budsjett ":name"',
    'deleted_budget'                            => 'Slett budsjett ":name"',
    'edit_budget'                               => 'Rediger budsjett ":name"',
    'updated_budget'                            => 'Oppdater budsjett ":name"',
    'update_amount'                             => 'Oppdater beløp',
    'update_budget'                             => 'Oppdater budsjett',
    'update_budget_amount_range'                => 'Oppdater (forventet) tilgjengelig beløp mellom :start og :end',
    'set_budget_limit_title'                    => 'Sett budsjettert beløp for budsjett :budget mellom :start og :end',
    'set_budget_limit'                          => 'Angi budsjettert beløp',
    'budget_period_navigator'                   => 'Periodenavigatør',
    'info_on_available_amount'                  => 'Hva har jeg tilgjengelig?',
    'available_amount_indication'               => 'Bruk disse beløpene for å få en indikasjon på hva ditt totale budsjett kan være.',
    'suggested'                                 => 'Foreslått',
    'average_between'                           => 'Gjennomsnitt mellom :start og :end',
    'transferred_in'                            => 'Overført (in)',
    'transferred_away'                          => 'Overført (borte)',
    'auto_budget_none'                          => 'Ingen automatisk budsjett',
    'auto_budget_reset'                         => 'Angi et fast beløp hver periode',
    'auto_budget_rollover'                      => 'Legg til et fast beløp hver periode',
    'auto_budget_adjusted'                      => 'Add an amount every period and correct for overspending',
    'auto_budget_period_daily'                  => 'Daglig',
    'auto_budget_period_weekly'                 => 'Ukentlig',
    'auto_budget_period_monthly'                => 'Månedlig',
    'auto_budget_period_quarterly'              => 'Kvartalsvis',
    'auto_budget_period_half_year'              => 'Hvert halvår',
    'auto_budget_period_yearly'                 => 'Årlig',
    'auto_budget_help'                          => 'Du kan lese mer om denne funksjonen under hjelp. Klikk ikonet øverst til høyre (?).',
    'auto_budget_reset_icon'                    => 'Budsjettet blir fastsatt periodisk',
    'auto_budget_rollover_icon'                 => 'Budsjettbeløpet vil øke periodisk',
    'auto_budget_adjusted_icon'                 => 'The budget amount will increase periodically and will correct for overspending',
    'remove_budgeted_amount'                    => 'Fjern budsjettert beløp i :currency',

    // bills:
    'left_to_pay_active_bills'                  => 'active, expected and not yet paid subscriptions',
    'left_to_pay_lc'                            => 'left to pay',
    'less_than_expected'                        => 'less than expected',
    'more_than_expected'                        => 'more than expected',
    'skip_help_text'                            => 'Use the skip field to create bi-monthly (skip = 1) or other custom intervals.',
    'subscription'                              => 'Abonnement',
    'not_expected_period'                       => 'Ikke forventet denne perioden',
    'subscriptions_in_group'                    => 'Subscriptions in group "{{title}}"',
    'subscr_expected_x_times'                   => 'Expect to pay {{amount}} {{times}} times this period',
    'not_or_not_yet'                            => 'Ikke (enda)',
    'visit_bill'                                => 'Visit subscription ":name" at Firefly III',
    'visit_bills'                               => 'Visit subscriptions at Firefly III',
    'match_between_amounts'                     => 'Subscription matches transactions between :low and :high.',
    'running_again_loss'                        => 'Previously linked transactions to this subscription may lose their connection, if they (no longer) match the rule(s).',
    'bill_related_rules'                        => 'Rules related to this subscription',
    'repeats'                                   => 'Gjentas',
    'bill_end_date_help'                        => 'Optional field. The subscription is expected to end on this date.',
    'bill_extension_date_help'                  => 'Optional field. The subscription must be extended (or cancelled) on or before this date.',
    'bill_end_index_line'                       => 'This subscription ends on :date',
    'bill_extension_index_line'                 => 'This subscription must be extended or cancelled on :date',
    'connected_journals'                        => 'Tilknyttede transaksjoner',
    'auto_match_on'                             => 'Automatisk funnet av Firefly III',
    'auto_match_off'                            => 'Ikke automatisk funnet av Firefly III',
    'next_expected_match'                       => 'Neste forventede treff',
    'delete_bill'                               => 'Delete subscription ":name"',
    'deleted_bill'                              => 'Deleted subscription ":name"',
    'edit_bill'                                 => 'Edit subscription ":name"',
    'more'                                      => 'Mer',
    'rescan_old'                                => 'Kjør regler igjen, på alle transaksjoner',
    'update_bill'                               => 'Update subscription',
    'updated_bill'                              => 'Updated subscription ":name"',
    'store_new_bill'                            => 'Store new subscription',
    'stored_new_bill'                           => 'Stored new subscription ":name"',
    'cannot_scan_inactive_bill'                 => 'Inactive subscriptions cannot be scanned.',
    'rescanned_bill'                            => 'Rescanned everything, and linked :count transaction to the subscription.|Rescanned everything, and linked :count transactions to the subscription.',
    'average_bill_amount_year'                  => 'Average subscription amount (:year)',
    'average_bill_amount_overall'               => 'Average subscription amount (overall)',
    'bill_is_active'                            => 'Subscription is active',
    'bill_expected_between'                     => 'Forventet mellom :start og :end',
    'bill_will_automatch'                       => 'Subscription will automatically linked to matching transactions',
    'skips_over'                                => 'hopper over',
    'bill_store_error'                          => 'An unexpected error occurred while storing your new subscription. Please check the log files',
    'list_inactive_rule'                        => 'inaktiv regel',
    'bill_edit_rules'                           => 'Firefly III will attempt to edit the rule related to this subscription as well. If you\'ve edited this rule yourself however, Firefly III won\'t change anything.|Firefly III will attempt to edit the :count rules related to this subscription as well. If you\'ve edited these rules yourself however, Firefly III won\'t change anything.',
    'bill_expected_date'                        => 'Forventet :date',
    'bill_expected_date_js'                     => 'Forventet {date}',
    'expected_amount'                           => '(Forventet) beløp',
    'bill_paid_on'                              => 'Betalt den {date}',
    'bill_repeats_weekly'                       => 'Gjentas ukentlig',
    'bill_repeats_monthly'                      => 'Gjentas månedlig',
    'bill_repeats_quarterly'                    => 'Gjentas kvartalsvis',
    'bill_repeats_half-year'                    => 'Gjentas hvert halvår',
    'bill_repeats_yearly'                       => 'Gjentas årlig',
    'bill_repeats_weekly_other'                 => 'Gjentas annenhver uke',
    'bill_repeats_monthly_other'                => 'Gjentas annenhver måned',
    'bill_repeats_quarterly_other'              => 'Gjentas annenhver kvartal',
    'bill_repeats_half-year_other'              => 'Gjentas årlig',
    'bill_repeats_yearly_other'                 => 'Gjentas annenhver år',
    'bill_repeats_weekly_skip'                  => 'Gjentas hver {skip} uke',
    'bill_repeats_monthly_skip'                 => 'Gjentas hver {skip} måned',
    'bill_repeats_quarterly_skip'               => 'Gjentas annenhver {skip} kvartal',
    'bill_repeats_half-year_skip'               => 'Gjentas hvert {skip} halvår',
    'bill_repeats_yearly_skip'                  => 'Gjentas hvert {skip} år',
    'subscriptions'                             => 'Abonnementer',
    'go_to_subscriptions'                       => 'Gå til dine abonnementer',
    'forever'                                   => 'For alltid',
    'extension_date_is'                         => 'Forlengelsesdato er {date}',

    // accounts:
    'account_locked_currency'                   => 'The currency of this account must remain :name as long as piggy banks are linked to it.',
    'i_am_owed_amount'                          => 'Jeg er skyldig beløp',
    'i_owe_amount'                              => 'Jeg skylder beløp',
    'inactive_account_link'                     => 'Du har :count inaktiv (arkivert) konto, som du kan se på denne separate siden. Du har :count inaktive (arkiverte) kontoer som du kan se på denne separate siden.',
    'all_accounts_inactive'                     => 'Dette er dine inaktive kontoer.',
    'active_account_link'                       => 'Denne lenken går tilbake til de aktive kontoene.',
    'account_missing_transaction'               => 'Konto #:id (":name") kan ikke bli vist direkte, Firefly mangler omdirigerings informasjon.',
    'cc_monthly_payment_date_help'              => 'Velg et år og en måned, det ignoreres likevel. Bare dagen i måneden er relevant.',
    'details_for_asset'                         => 'Detaljer for brukskonto ":name"',
    'details_for_expense'                       => 'Detaljer for utgiftskonto ":name"',
    'details_for_revenue'                       => 'Detaljer for inntektskonto ":name"',
    'details_for_cash'                          => 'Detaljer for kontantkonto ":name"',
    'store_new_asset_account'                   => 'Lagre ny brukskonto',
    'store_new_expense_account'                 => 'Lagre ny utgiftskonto',
    'store_new_revenue_account'                 => 'Lagre ny inntektskonto',
    'edit_asset_account'                        => 'Rediger brukskonto ":name"',
    'edit_expense_account'                      => 'Rediger utgiftskonto ":name"',
    'edit_revenue_account'                      => 'Rediger inntektskonto ":name"',
    'delete_asset_account'                      => 'Slett brukskonto ":name"',
    'delete_expense_account'                    => 'Slett utgiftskonto ":name"',
    'delete_revenue_account'                    => 'Slett inntektskonto ":name"',
    'delete_liabilities_account'                => 'Slett gjeld ":name"',
    'asset_deleted'                             => 'Sletting av brukskonto ":name" var vellykket',
    'account_deleted'                           => 'Sletting av konto ":name" var vellykket',
    'expense_deleted'                           => 'Sletting av utgiftskonto ":name" var vellykket',
    'revenue_deleted'                           => 'Sletting av inntekskonto ":name" var vellykket',
    'update_asset_account'                      => 'Oppdater aktivakonto',
    'update_undefined_account'                  => 'Oppdater konto',
    'update_liabilities_account'                => 'Oppdater gjeld',
    'update_expense_account'                    => 'Oppdater utgiftskonto',
    'update_revenue_account'                    => 'Oppdater inntektskonto',
    'make_new_asset_account'                    => 'Opprett en ny aktivakonto',
    'make_new_expense_account'                  => 'Opprett en ny utgiftskonto',
    'make_new_revenue_account'                  => 'Opprett en ny inntektskonto',
    'make_new_liabilities_account'              => 'Opprett ny gjeld',
    'asset_accounts'                            => 'Aktivakontoer',
    'undefined_accounts'                        => 'Kontoer',
    'asset_accounts_inactive'                   => 'Eiendelskontoer (inaktive)',
    'expense_account'                           => 'Utgiftskonto',
    'expense_accounts'                          => 'Utgiftskontoer',
    'expense_accounts_inactive'                 => 'Utgiftskontoer (inaktive)',
    'revenue_account'                           => 'Inntektskonto',
    'revenue_accounts'                          => 'Inntektskontoer',
    'revenue_accounts_inactive'                 => 'Inntektskontoer (inaktive)',
    'cash_accounts'                             => 'Kontantkontoer',
    'Cash account'                              => 'Kontantkonto',
    'liabilities_accounts'                      => 'Gjeldskonto',
    'liabilities_accounts_inactive'             => 'Gjeldskonto (inaktive)',
    'reconcile_account'                         => 'Avstem konto ":account"',
    'overview_of_reconcile_modal'               => 'Balanseoversikt',
    'delete_reconciliation'                     => 'Slett avstemming',
    'update_reconciliation'                     => 'Oppdater avstemming',
    'amount_cannot_be_zero'                     => 'Beløpet kan ikke være null',
    'end_of_reconcile_period'                   => 'Slutten av balanse perioden :period',
    'start_of_reconcile_period'                 => 'Starten av balanse perioden :period',
    'start_balance'                             => 'Startsaldo',
    'end_balance'                               => 'Sluttsaldo',
    'update_balance_dates_instruction'          => 'Koble beløpene og datoene over til kontoutskriften, og trykk på "Start avstemning"',
    'select_transactions_instruction'           => 'Velg transaksjonene som vises på kontoutskriften.',
    'select_range_and_balance'                  => 'Kontroller først datoperiode og saldo. Deretter trykker du på "Start avstemning"',
    'date_change_instruction'                   => 'Hvis du endrer datointervallet nå, vil du miste all foreløpig framdrift.',
    'update_selection'                          => 'Oppdater utvalg',
    'store_reconcile'                           => 'Lagre avstemming',
    'reconciliation_transaction'                => 'Avstemmingstransaksjon',
    'Reconciliation'                            => 'Avstemming',
    'reconciliation'                            => 'Avstemming',
    'reconcile_options'                         => 'Avstemmingsalternativer',
    'reconcile_range'                           => 'Avstemningsområde',
    'start_reconcile'                           => 'Start avstemming',
    'cash_account_type'                         => 'Kontanter',
    'cash'                                      => 'kontanter',
    'cant_find_redirect_account'                => 'Firefly III prøvde å omdirigere deg, men kan ikke. Beklager det. Tilbake til indeksen.',
    'account_type'                              => 'Kontotype',
    'save_transactions_by_moving'               => 'Lagre denne transaksjonen ved å flytte den til en annen konto:|Lagre disse transaksjonene ved å flytte dem til en annen konto:',
    'save_transactions_by_moving_js'            => 'Ingen transaksjoner|Lagre denne transaksjonen ved å flytte den til en annen konto. |Lagre disse transaksjonene ved å flytte dem til en annen konto.',
    'stored_new_account'                        => 'Ny konto:name: lagret!',
    'stored_new_account_js'                     => 'Ny konto "<a href="accounts/show/{ID}">{name}</a>" lagret!',
    'updated_account'                           => 'Oppdatert konto ":name"',
    'updated_account_js'                        => 'Oppdatert konto "<a href="accounts/show/{ID}">{title}</a>".',
    'credit_card_options'                       => 'Kredittkortvalg',
    'no_transactions_account'                   => 'Det finnes ingen transaksjoner (i denne perioden) for brukskonto ":name".',
    'no_transactions_period'                    => 'Det finnes ingen transaksjoner (i denne perioden).',
    'no_data_for_chart'                         => 'Det er ikke nok informasjon (ennå) til å generere dette diagrammet.',
    'select_at_least_one_account'               => 'Velg minst en brukskonto',
    'select_at_least_one_category'              => 'Velg minst én kategori',
    'select_at_least_one_budget'                => 'Velg minst ett budsjett',
    'select_at_least_one_tag'                   => 'Velg minst én tag',
    'select_at_least_one_expense'               => 'Velg minst en kombinasjon av utgift/inntekts konto. Hvis du ikke har en (listen er tom) så vil ikke denne rapporten være tilgjengelig.',
    'account_default_currency'                  => 'Dette blir standard valuta for denne kontoen.',
    'piggy_default_currency'                    => 'Piggy banks can only save money in a single currency.',
    'piggy_account_currency_match'              => 'Only accounts that use the previously selected currency will be accepted.',
    'reconcile_has_more'                        => 'Din Firefly III-hovedbok har mer penger i seg enn banken hevder du burde ha. Det finnes flere alternativer. Vennligst velg hva du skal gjøre. Deretter trykker du på "Bekreft avstemming".',
    'reconcile_has_less'                        => 'Din Firefly III-hovedbok har mindre penger i seg enn banken hevder du burde ha. Det finnes flere alternativer. Vennligst velg hva du skal gjøre. Deretter trykker du på "Bekreft avstemming".',
    'reconcile_is_equal'                        => 'Din Firefly III-hovedbok og dine kontoutskrifter samsvarer. Det er ingenting du trenger å gjøre. Vennligst trykk "Bekreft avstemming" for å fortsette.',
    'create_pos_reconcile_transaction'          => 'Fjern de valgte transaksjonene, og opprett en korreksjon som legger til :amount til denne aktivakontoen.',
    'create_neg_reconcile_transaction'          => 'Fjern de valgte transaksjonene, og opprett en korreksjon som tar bort :amount fra denne aktivakontoen.',
    'reconcile_do_nothing'                      => 'Fjern de valgte transaksjonene, men ikke korriger.',
    'reconcile_go_back'                         => 'Du kan alltid redigere eller slette en korreksjon senere.',
    'must_be_asset_account'                     => 'Du kan bare avstemme aktivakontoer',
    'reconciliation_stored'                     => 'Avstemming lagret',
    'reconciliation_error'                      => 'På grunn av en feil ble transaksjonene markert som avstemt, men korrigeringen har ikke blitt lagret: :error.',
    'reconciliation_transaction_title'          => 'Avstemming (:from til :to)',
    'sum_of_reconciliation'                     => 'Sum av avstemming',
    'reconcile_this_account'                    => 'Avstem denne kontoen',
    'reconcile'                                 => 'Avstem',
    'show'                                      => 'Vis',
    'confirm_reconciliation'                    => 'Bekreft avstemming',
    'submitted_start_balance'                   => 'Innsendt startsaldo',
    'selected_transactions'                     => 'Valgte transaksjoner (:count)',
    'already_cleared_transactions'              => 'Tidligere ryddet transaksjoner (:count)',
    'submitted_end_balance'                     => 'Innsendt sluttsaldo',
    'initial_balance_description'               => 'Start saldo for ":account"',
    'liability_credit_description'              => 'Gjeld på lån ":account"',
    'interest_calc_'                            => 'ukjent',
    'interest_calc_daily'                       => 'Per dag',
    'interest_calc_monthly'                     => 'Per måned',
    'interest_calc_yearly'                      => 'Per år',
    'interest_calc_weekly'                      => 'Per uke',
    'interest_calc_half-year'                   => 'Per halvår',
    'interest_calc_quarterly'                   => 'Per kvartal',
    'initial_balance_account'                   => 'Inngående balanse for :account',
    'list_options'                              => 'Listealternativer',
    'account_column_opt_drag_and_drop'          => 'Drag and drop',
    'account_column_opt_active'                 => 'Active',
    'account_column_opt_name'                   => 'Name',
    'account_column_opt_type'                   => 'Type',
    'account_column_opt_liability_type'         => 'Liability type',
    'account_column_opt_liability_direction'    => 'Liability direction',
    'account_column_opt_liability_interest'     => 'Liability interest',
    'account_column_opt_number'                 => 'Account number',
    'account_column_opt_current_balance'        => 'Current balance',
    'account_column_opt_amount_due'             => 'Amount due',
    'account_column_opt_last_activity'          => 'Last activity',
    'account_column_opt_balance_difference'     => 'Balance difference',
    'account_column_opt_menu'                   => 'Menu',

    // categories:
    'new_category'                              => 'Ny kategori',
    'create_new_category'                       => 'Opprett en ny kategori',
    'without_category'                          => 'Uten kategori',
    'update_category'                           => 'Oppdater kategori',
    'updated_category'                          => 'Oppdatert kategori ":name"',
    'categories'                                => 'Kategorier',
    'edit_category'                             => 'Rediger kategori ":name"',
    'no_category'                               => '(ingen kategori)',
    'unknown_category_plain'                    => 'Ingen kategori',
    'category'                                  => 'Kategori',
    'delete_category'                           => 'Slett kategori ":name"',
    'deleted_category'                          => 'Slettet kategori ":name"',
    'store_category'                            => 'Lagre ny kategori',
    'stored_category'                           => 'Lagret ny kategori ":name"',
    'without_category_between'                  => 'Uten kategori mellom :start og :end',


    // transactions:
    'wait_loading_transaction'                  => 'Please wait for the form to load',
    'wait_loading_data'                         => 'Please wait for your information to load...',
    'wait_attachments'                          => 'Please wait for the attachments to upload.',
    'errors_upload'                             => 'The upload has failed. Please check your browser console for the error.',
    'amount_foreign_if'                         => 'Amount in foreign currency, if any',
    'amount_destination_account'                => 'Amount in the currency of the destination account',
    'edit_transaction_title'                    => 'Edit transaction ":description"',
    'unreconcile'                               => 'Angre avstemming',
    'update_withdrawal'                         => 'Oppdater uttak',
    'update_deposit'                            => 'Oppdater innskudd',
    'update_transaction'                        => 'Oppdater transaksjonen',
    'update_transfer'                           => 'Oppdater overføring',
    'updated_withdrawal'                        => 'Oppdatert uttak ":description"',
    'updated_deposit'                           => 'Oppdatert innskudd ":description"',
    'updated_transfer'                          => 'Oppdatert overføring ":description"',
    'no_changes_withdrawal'                     => 'Uttak ":description" ble ikke endret.',
    'no_changes_deposit'                        => 'Innskudd ":description" ble ikke endret.',
    'no_changes_transfer'                       => 'Overføring ":description" ble ikke endret.',
    'delete_withdrawal'                         => 'Slett uttak ":description"',
    'delete_deposit'                            => 'Slett innskudd ":description"',
    'delete_transfer'                           => 'Slett overføring ":description"',
    'deleted_withdrawal'                        => 'Slettet uttak ":description"',
    'deleted_deposit'                           => 'Slettet innskudd ":description"',
    'deleted_transfer'                          => 'Slettet overføring ":description"',
    'deleted_reconciliation'                    => 'Slettet avstemmingstransaksjon ":description"',
    'stored_journal'                            => 'Opprettet ny transaksjon ":description"',
    'stored_journal_js'                         => 'Successfully created new transaction "{{description}}"',
    'stored_journal_no_descr'                   => 'Vellykket! Ny transaksjon er opprettet',
    'updated_journal_no_descr'                  => 'Transaksjonen din ble oppdatert',
    'select_transactions'                       => 'Velg transaksjoner',
    'rule_group_select_transactions'            => 'Påfør ":title" på transaksjonene',
    'rule_select_transactions'                  => 'Påfør ":title" på transaksjonene',
    'stop_selection'                            => 'Stop valg av transaksjoner',
    'reconcile_selected'                        => 'Avstem',
    'mass_delete_journals'                      => 'Slett flere transaksjoner',
    'mass_edit_journals'                        => 'Rediger flere transaksjoner',
    'mass_bulk_journals'                        => 'Rediger flere transaksjoner samtidig',
    'mass_bulk_journals_explain'                => 'Dette skjemaet lar deg endre egenskaper for transaksjonene nedenfor i en oppdatering. Alle transaksjonene i tabellen vil bli oppdatert når du endrer parametrene du ser her.',
    'part_of_split'                             => 'Denne transaksjonen er en del av en delt transaksjon. Hvis du ikke har valgt alle delene, kan du ende opp med å endre bare halvparten av transaksjonen.',
    'bulk_set_new_values'                       => 'Bruk innstillingene nedenfor for å angi nye verdier. Hvis du lar dem stå tomme, forblir de tomme. Vær også oppmerksom på at kun uttak vil bli gitt et budsjett.',
    'no_bulk_category'                          => 'Ikke oppdater kategori',
    'no_bulk_budget'                            => 'Ikke oppdater budsjett',
    'no_bulk_tags'                              => 'Ikke oppdater tagg(er)',
    'replace_with_these_tags'                   => 'Erstatt med disse taggene',
    'append_these_tags'                         => 'Legg til disse taggene',
    'mass_edit'                                 => 'Rediger individuelt valgte',
    'bulk_edit'                                 => 'Rediger valgte i bulk',
    'mass_delete'                               => 'Slett valgte',
    'cannot_edit_other_fields'                  => 'Du kan ikke masseredigere andre felt enn de som er her, fordi det er ikke plass til å vise dem. Vennligst følg linken og rediger disse en om gangen hvis du må redigere disse feltene.',
    'cannot_change_amount_reconciled'           => 'You can\'t change the amount or account(s) of reconciled transactions.',
    'no_budget'                                 => '(ingen budsjett)',
    'no_bill'                                   => '(no subscription)',
    'account_per_budget'                        => 'Konto per budsjett',
    'account_per_category'                      => 'Konto per kategori',
    'create_new_object'                         => 'Opprett',
    'empty'                                     => '(tom)',
    'all_other_budgets'                         => '(alle andre budsjetter)',
    'all_other_accounts'                        => '(alle andre kontoer)',
    'expense_per_source_account'                => 'Utgifter per kildekonto',
    'expense_per_destination_account'           => 'Utgifter per målkonto',
    'income_per_destination_account'            => 'Inntekter per destinasjonskonto',
    'spent_in_specific_category'                => 'Brukt i kategori ":category"',
    'earned_in_specific_category'               => 'Opptjent i kategori ":category"',
    'spent_in_specific_tag'                     => 'Brukt i taggen ":tag"',
    'earned_in_specific_tag'                    => 'Opptjent i tag ":tag"',
    'income_per_source_account'                 => 'Inntekter per kildekonto',
    'average_spending_per_destination'          => 'Gjennomsnittlig utgift per målkonto',
    'average_spending_per_source'               => 'Gjennomsnittlig utgift per kildekonto',
    'average_earning_per_source'                => 'Gjennomsnittlig opptjente per kildekonto',
    'average_earning_per_destination'           => 'Gjennomsnittlig opptjente per målkonto',
    'account_per_tag'                           => 'Konto per tagg',
    'tag_report_expenses_listed_once'           => 'Expenses and income are never listed twice. If a transaction has multiple tags, it may only show up under one of its tags. This list may appear to be missing data, but the amounts will be correct.',
    'double_report_expenses_charted_once'       => 'Expenses and income are never displayed twice. If a transaction has multiple tags, it may only show up under one of its tags. This chart may appear to be missing data, but the amounts will be correct.',
    'tag_report_chart_single_tag'               => 'This chart applies to a single tag. If a transaction has multiple tags, what you see here may be reflected in the charts of other tags as well.',
    'tag'                                       => 'Tagg',
    'no_budget_squared'                         => '(ingen budsjett)',
    'perm-delete-many'                          => 'Deleting many items in one go can be very disruptive. Please be cautious. You can delete part of a split transaction from this page, so take care.',
    'mass_deleted_transactions_success'         => 'Deleted :count transaction.|Deleted :count transactions.',
    'mass_edited_transactions_success'          => 'Updated :count transaction.|Updated :count transactions.',
    'opt_group_'                                => '(ingen kontotype)',
    'opt_group_no_account_type'                 => '(ingen kontotype)',
    'opt_group_defaultAsset'                    => 'Standard aktivakontoer',
    'opt_group_savingAsset'                     => 'Sparekontoer',
    'opt_group_sharedAsset'                     => 'Delte aktivakontoer',
    'opt_group_ccAsset'                         => 'Kredittkort',
    'opt_group_cashWalletAsset'                 => 'Kontant lommebok',
    'opt_group_expense_account'                 => 'Utgiftskontoer',
    'opt_group_revenue_account'                 => 'Inntektskontoer',
    'opt_group_l_Loan'                          => 'Gjeld: Lån',
    'opt_group_cash_account'                    => 'Kontantkonto',
    'opt_group_l_Debt'                          => 'Gjeld: Gjeld',
    'opt_group_l_Mortgage'                      => 'Gjeld: Huslån',
    'opt_group_l_Credit card'                   => 'Gjeld: Kredittkort',
    'notes'                                     => 'Notater',
    'view_notes'                                => 'View notes',
    'set_budget_limit_notes'                    => 'View the notes for this budgeted amount',
    'edit_bl_notes'                             => 'Edit notes',
    'update_bl_notes'                           => 'Update notes',
    'unknown_journal_error'                     => 'Kunne ikke lagre transaksjonen. Vennligst sjekk loggfilene.',
    'attachment_not_found'                      => 'Finner ikke dette vedlegget.',
    'journal_link_bill'                         => 'This transaction is linked to subscription <a href=":route">:name</a>. To remove the connection, uncheck the checkbox. Use rules to connect it to another subscription.',
    'transaction_stored_link'                   => '<a href="transactions/show/{ID}">Transaksjon #{ID} ("{title}")</a> har blitt lagret.',
    'transaction_new_stored_link'               => '<a href="transactions/show/{ID}">Transaksjon #{ID}</a> har blitt lagret.',
    'transaction_updated_link'                  => '<a href="transactions/show/{ID}">Transaksjon #{ID} ("{title}")</a> har blitt oppdatert.',
    'transaction_updated_no_changes'            => '<a href="transactions/show/{ID}">Transaksjon #{ID} ("{title}")</a> fikk ingen endringer.',
    'first_split_decides'                       => 'The first split determines the value of this field',
    'first_split_overrules_source'              => 'The first split may overrule the source account',
    'first_split_overrules_destination'         => 'The first split may overrule the destination account',
    'spent_x_of_y'                              => 'Brukt {amount} av {total}',

    // new user:
    'welcome'                                   => 'Velkommen til Firefly III!',
    'submit'                                    => 'Send inn',
    'submission'                                => 'Innlevering',
    'submit_yes_really'                         => 'Registrer (Jeg vet hva jeg gjør)',
    'getting_started'                           => 'Kom igang',
    'to_get_started'                            => 'Det er godt å se at du har installert Firefly III. Vennligst skriv inn bankens navn og saldo på hovedkontoen din for å komme i gang. Du trenger Ikke bekymre deg hvis du har flere kontoer. Du kan legge dem til senere. Dette er bare for at Firefly III skal få noe data å arbeide med.',
    'savings_balance_text'                      => 'Firefly III vil automatisk opprette en sparekonto for deg. Som standard vil det ikke være penger på sparekontoen din, men hvis du oppgir saldoen din til Firefly III så blir den lagt inn for deg.',
    'finish_up_new_user'                        => 'Det var alt! Du kan fortsette ved å trykke <strong>Send</strong>. Deretter vil du bli tatt til startskjermen til Firefly III.',
    'stored_new_accounts_new_user'              => 'Jippi! De nye kontoene dine ble lagret.',
    'set_preferred_language'                    => 'Hvis du foretrekker å bruke Firefly III med et annet språk, vennligst indiker det her.',
    'language'                                  => 'Språk',
    'new_savings_account'                       => ':bank_name sparekonto',
    'cash_wallet'                               => 'Kontanter lommebok',
    'currency_not_present'                      => 'Hvis valutaen du vanligvis bruker ikke vises, ikke fortvil. Du kan opprette din egen valuta under Alternativer > valuta.',

    // home page:
    'transaction_table_description'             => 'En tabell som inneholder transaksjonene dine',
    'opposing_account'                          => 'Opposing account',
    'yourAccounts'                              => 'Dine kontoer',
    'your_accounts'                             => 'Din konto oversikt',
    'category_overview'                         => 'Kategori oversikt',
    'expense_overview'                          => 'Utgiftskonto oversikt',
    'revenue_overview'                          => 'Inntektskonto oversikt',
    'budgetsAndSpending'                        => 'Budsjetter og utgifter',
    'budgets_and_spending'                      => 'Budsjetter og utgifter',
    'go_to_budget'                              => 'Gå til budsjett "{budget}"',
    'go_to_deposits'                            => 'Gå til innskudd',
    'go_to_expenses'                            => 'Gå til utgifter',
    'savings'                                   => 'Oppspart',
    'newWithdrawal'                             => 'Ny utgift',
    'newDeposit'                                => 'Nytt innskudd',
    'newTransfer'                               => 'Ny overføring',
    'bills_to_pay'                              => 'Subscriptions to pay',
    'per_day'                                   => 'Per dag',
    'left_to_spend_per_day'                     => 'Igjen å bruke per dag',
    'bills_paid'                                => 'Subscriptions paid',
    'custom_period'                             => 'Tilpasset periode',
    'reset_to_current'                          => 'Tilbakestill til gjeldende periode',
    'select_period'                             => 'Velg en periode',

    // menu and titles, should be recycled as often as possible:
    'currency'                                  => 'Valuta',
    'preferences'                               => 'Innstillinger',
    'logout'                                    => 'Logg ut',
    'logout_other_sessions'                     => 'Logg ut alle andre økter',
    'toggleNavigation'                          => 'Vis/Skjul navigation',
    'toggle_dropdown'                           => 'Toggle dropdown',
    'searchPlaceholder'                         => 'Søk...',
    'version'                                   => 'Versjon',
    'dashboard'                                 => 'Startskjerm',
    'income_and_expense'                        => 'Inntekter og utgifter',
    'all_money'                                 => 'Alle pengene dine',
    'unknown_source_plain'                      => 'Ukjent kilde-konto',
    'unknown_dest_plain'                        => 'Ukjent destinasjonskonto',
    'unknown_any_plain'                         => 'Ukjent konto',
    'unknown_budget_plain'                      => 'Mangler budsjett',
    'available_budget'                          => 'Tilgjengelige budsjett ({currency})',
    'currencies'                                => 'Valutaer',
    'activity'                                  => 'Aktivitet',
    'usage'                                     => 'Bruk',
    'accounts'                                  => 'Kontoer',
    'Asset account'                             => 'Aktivakonto',
    'Default account'                           => 'Aktivakonto',
    'Expense account'                           => 'Utgiftskonto',
    'Revenue account'                           => 'Inntektskonto',
    'Initial balance account'                   => 'Startsaldokonto',
    'account_type_Asset account'                => 'Aktivakonto',
    'account_type_Expense account'              => 'Utgiftskonto',
    'account_type_Revenue account'              => 'Inntektskonto',
    'account_type_Debt'                         => 'Gjeld',
    'account_type_Loan'                         => 'Lån',
    'account_type_Mortgage'                     => 'Boliglån',
    'account_type_debt'                         => 'Gjeld',
    'account_type_loan'                         => 'Lån',
    'account_type_mortgage'                     => 'Boliglån',
    'account_type_Credit card'                  => 'Kredittkort',
    'credit_card_type_monthlyFull'              => 'Full betaling hver måned',
    'liability_direction_credit'                => 'Jeg skylder denne gjelden',
    'liability_direction_debit'                 => 'Jeg skylder denne gjelden til en annen',
    'liability_direction_credit_short'          => 'Jeg skuldet denne gjelden',
    'liability_direction_debit_short'           => 'Skylder denne gjelden',
    'liability_direction__short'                => 'Ukjent',
    'liability_direction_null_short'            => 'Ukjent',
    'Liability credit'                          => 'Lån kreditt',
    'budgets'                                   => 'Budsjetter',
    'tags'                                      => 'Tagger',
    'reports'                                   => 'Rapporter',
    'transactions'                              => 'Transaksjoner',
    'expenses'                                  => 'Utgifter',
    'income'                                    => 'Inntekt',
    'transfers'                                 => 'Overføringer',
    'moneyManagement'                           => 'Pengestyring',
    'money_management'                          => 'Pengestyring',
    'tools'                                     => 'Verktøy',
    'piggyBanks'                                => 'Sparegriser',
    'piggy_banks'                               => 'Sparegriser',
    'amount_x_of_y'                             => '{current} av {total}',
    'bills'                                     => 'Subscriptions',
    'withdrawal'                                => 'Uttak',
    'opening_balance'                           => 'Startsaldo',
    'deposit'                                   => 'Innskudd',
    'account'                                   => 'Konto',
    'transfer'                                  => 'Overføring',
    'Withdrawal'                                => 'Uttak',
    'Deposit'                                   => 'Innskudd',
    'Transfer'                                  => 'Overføring',
    'bill'                                      => 'Subscription',
    'yes'                                       => 'Ja',
    'no'                                        => 'Nei',
    'amount'                                    => 'Beløp',
    'overview'                                  => 'Oversikt',
    'saveOnAccount'                             => 'Spar på konto',
    'saveOnAccounts'                            => 'Save on account(s)',
    'unknown'                                   => 'Ukjent',
    'monthly'                                   => 'Månedlig',
    'profile'                                   => 'Profil',
    'errors'                                    => 'Feil',
    'debt_start_date'                           => 'Startdato for gjeld',
    'debt_start_amount'                         => 'Start beløp for gjeld',
    'debt_start_amount_help'                    => 'Det er alltid best å sette denne verdien til et negativt beløp. Les hjelpesidene (topp til høyre (?)-ikonet) for mer informasjon.',
    'interest_period_help'                      => 'Dette feltet er rent kosmetisk og vil ikke bli beregnet for deg. Siden det viser seg at bankene er svært sneaky så Firefly III aldri får det riktig.',
    'store_new_liabilities_account'             => 'Lagre ny gjeld',
    'edit_liabilities_account'                  => 'Rediger gjeld ":name"',
    'financial_control'                         => 'Finansiell kontroll',
    'accounting'                                => 'Regnskap',
    'automation'                                => 'Automatisering',
    'others'                                    => 'Andre',
    'classification'                            => 'Klassifisering',
    'store_transaction'                         => 'Lagre transaksjon',


    // reports:
    'quick_link_needs_accounts'                 => 'In order to generate reports, you need to add at least one asset account to Firefly III.',
    'report_default'                            => 'Standard finansiell rapport mellom :start og :end',
    'report_audit'                              => 'Transaksjonshistorikk og oversikt mellom :start og :end',
    'report_category'                           => 'Kategori rapport mellom :start og :end',
    'report_double'                             => 'Utgift/Inntekt kontorapport mellom :start og :end',
    'report_budget'                             => 'Budsjettrapport mellom :start og :end',
    'report_tag'                                => 'Tag-rapport mellom :start og :end',
    'quick_link_reports'                        => 'Hurtiglenker',
    'quick_link_examples'                       => 'Dette er bare noen eksempel linker for å komme i gang. Sjekk ut hjelpesidene under (?) -knappen for informasjon om alle rapporter og de magiske ordene som du kan bruke.',
    'quick_link_default_report'                 => 'Standard finansiell rapport',
    'quick_link_audit_report'                   => 'Oversikt over transaksjonshistorikk',
    'report_this_month_quick'                   => 'Inneværende måned, alle kontoer',
    'report_last_month_quick'                   => 'Forrige måned, alle kontoer',
    'report_this_year_quick'                    => 'Inneværende år, alle kontoer',
    'report_this_fiscal_year_quick'             => 'Inneværende regnskapsår, alle kontoer',
    'report_all_time_quick'                     => 'Fra tidenes morgen, alle kontoer',
    'reports_can_bookmark'                      => 'Husk at rapporter kan bokmerkes.',
    'incomeVsExpenses'                          => 'Inntekter vs. utgifter',
    'accountBalances'                           => 'Saldo',
    'balanceStart'                              => 'Saldo ved starten av periode',
    'balanceEnd'                                => 'Saldo ved utgangen av perioden',
    'splitByAccount'                            => 'Del opp på konto',
    'coveredWithTags'                           => 'Dekket med tagger',
    'leftInBudget'                              => 'Igjen i budsjett',
    'left_in_debt'                              => 'Skyldig beløp',
    'sumOfSums'                                 => 'Sum av summer',
    'noCategory'                                => '(ingen kategori)',
    'notCharged'                                => 'Ikke belastet (ennå)',
    'inactive'                                  => 'Inaktiv',
    'active'                                    => 'Aktiv',
    'difference'                                => 'Differanse',
    'money_flowing_in'                          => 'Inn',
    'money_flowing_out'                         => 'Ut',
    'topX'                                      => 'topp :number',
    'show_full_list'                            => 'Vis hele listen',
    'show_only_top'                             => 'Vis bare topp :number',
    'report_type'                               => 'Rapporttype',
    'report_type_default'                       => 'Standard finansiell rapport',
    'report_type_audit'                         => 'Transaksjonshistorikk (revisjon)',
    'report_type_category'                      => 'Kategorirapport',
    'report_type_budget'                        => 'Budsjettrapport',
    'report_type_tag'                           => 'Taggrapport',
    'report_type_double'                        => 'Rapport for kostnader / inntekter',
    'more_info_help'                            => 'Mer informasjon om disse rapportene finner du på hjelpesidene. Trykk på (?) -ikonet øverst til høyre.',
    'report_included_accounts'                  => 'Inkluderte kontoer',
    'report_date_range'                         => 'Datointervall',
    'report_preset_ranges'                      => 'Forhåndsinnstilte områder',
    'shared'                                    => 'Delt',
    'fiscal_year'                               => 'Regnskapsår',
    'income_entry'                              => 'Inntekter fra konto ":name" mellom :start og :end',
    'expense_entry'                             => 'Utgifter til konto ":name" mellom :start og :end',
    'category_entry'                            => 'Utgifter og inntekter i kategori ":name" mellom :start og :end',
    'budget_spent_amount'                       => 'Utgifter i budsjett ":budget" mellom :start og :end',
    'balance_amount'                            => 'Utgifter i budsjett ":budget" betalt fra konto ":account" mellom :start og :end',
    'no_audit_activity'                         => 'Ingen aktivitet er registrert på konto <a href=":url" title=":account_name">:account_name</a> mellom :start og :end.',
    'audit_end_balance'                         => 'Kontobalanse fra <a href=":url" title=":account_name">:account_name</a> ved slutten av :end var: :balance',
    'reports_extra_options'                     => 'Ekstra alternativer',
    'report_has_no_extra_options'               => 'Denne rapporten har ingen ekstra alternativer',
    'reports_submit'                            => 'Vis rapport',
    'end_after_start_date'                      => 'Sluttdato for rapport må være etter startdato.',
    'select_category'                           => 'Velg kategori(er)',
    'select_budget'                             => 'Velg budsjett(er).',
    'select_tag'                                => 'Velg tagg(er).',
    'income_per_category'                       => 'Inntekter per kategori',
    'expense_per_category'                      => 'Utgifter per kategori',
    'expense_per_budget'                        => 'Utgifter per budsjett',
    'income_per_account'                        => 'Inntekter per konto',
    'expense_per_account'                       => 'Utgifter per konto',
    'expense_per_tag'                           => 'Utgifter per tagg',
    'income_per_tag'                            => 'Inntekter per tagg',
    'include_expense_not_in_budget'             => 'Inkluderte utgifter ikke med i de valgte budsjettene',
    'include_expense_not_in_account'            => 'Inkluderte utgifter ikke med i de valgte kontoene',
    'include_expense_not_in_category'           => 'Inkluderte utgifter ikke med i de valgte kategoriene',
    'include_income_not_in_category'            => 'Inkluderte inntekter ikke med i de valgte kategoriene',
    'include_income_not_in_account'             => 'Inkluderte inntekter ikke med i de valgte kontoene',
    'include_income_not_in_tags'                => 'Inkludert inntekt ikke i de valgte tag\'ene',
    'include_expense_not_in_tags'               => 'Inkluderte utgifter ikke med i de valgte tag\'ene',
    'everything_else'                           => 'Alt annet',
    'income_and_expenses'                       => 'Inntekter og utgifter',
    'spent_average'                             => 'Brukt (gjennomsnittlig)',
    'income_average'                            => 'Inntekt (gjennomsnittlig)',
    'transaction_count'                         => 'Transaksjonsantall',
    'average_spending_per_account'              => 'Gjennomsnittlig bruk per konto',
    'average_income_per_account'                => 'Gjennomsnittlig inntekt per konto',
    'total'                                     => 'Totalt',
    'description'                               => 'Beskrivelse',
    'sum_of_period'                             => 'Sum for perioden',
    'average_in_period'                         => 'Gjennomsnitt for periode',
    'no_account_role'                           => '(no role)',
    'account_role_defaultAsset'                 => 'Standard aktivakonto',
    'account_role_sharedAsset'                  => 'Delt aktivakonto',
    'account_role_savingAsset'                  => 'Sparekonto',
    'account_role_ccAsset'                      => 'Kredittkort',
    'account_role_cashWalletAsset'              => 'Kontant lommebok',
    'budget_chart_click'                        => 'Vennligst trykk på et budsjettnavn i tabellen ovenfor for å se et diagram.',
    'category_chart_click'                      => 'Vennligst trykk på et kategorinavn i tabellen ovenfor for å se et diagram.',
    'in_out_accounts'                           => 'Tjent og brukt pr. kombinasjon',
    'in_out_accounts_per_asset'                 => 'Opptjent og brukt (per aktivakonto)',
    'in_out_per_category'                       => 'Tjent og brukt pr. kategori',
    'out_per_budget'                            => 'Brukt per budsjett',
    'select_expense_revenue'                    => 'Velg utgifts-/inntektskonto',
    'multi_currency_report_sum'                 => 'Siden denne listen inneholder kontoer med forskjellige valutaer vil summen mest sannsynlig ikke gi noen mening. Rapporten vil alltid falle tilbake på din standarde valuta.',
    'sum_in_default_currency'                   => 'Summen vil alltid be i din standard valuta.',
    'net_filtered_prefs'                        => 'Dette diagrammet vil aldri inkludere kontoer som ikke har "Inkluder i nettoverdi"-valget avkrysset.',


    // charts:
    'chart'                                     => 'Diagram',
    'month'                                     => 'Måned',
    'budget'                                    => 'Budsjett',
    'spent'                                     => 'Brukt',
    'spent_capped'                              => 'Spent (capped)',
    'spent_in_budget'                           => 'Brukt i budsjett',
    'left_to_spend'                             => 'Igjen å bruke',
    'earned'                                    => 'Opptjent',
    'overspent'                                 => 'Overforbruk',
    'left'                                      => 'Gjenværende',
    'max-amount'                                => 'Maksimumsbeløp',
    'min-amount'                                => 'Minimumsbeløp',
    'journal-amount'                            => 'Current subscription entry',
    'name'                                      => 'Navn',
    'expires_at'                                => 'Expires at',
    'date'                                      => 'Dato',
    'date_and_time'                             => 'Dato og klokkeslett',
    'time'                                      => 'Tid',
    'paid'                                      => 'Betalt',
    'unpaid'                                    => 'Ikke betalt',
    'day'                                       => 'Dag',
    'budgeted'                                  => 'Budsjettert',
    'period'                                    => 'Periode',
    'balance'                                   => 'Saldo',
    'in_out_period'                             => 'Inn + ut denne perioden',
    'sum'                                       => 'Sum',
    'summary'                                   => 'Oppsummering',
    'average'                                   => 'Gjennomsnitt',
    'balanceFor'                                => 'Saldo for :name',
    'no_tags'                                   => '(ingen tagger)',
    'nothing_found'                             => '(nothing found)',

    // page settings and wizard dialogs

    'page_settings_header'          => 'Page settings',
    'visible_columns'               => 'Visible columns',
    'accounts_to_show'              => 'Accounts to show',
    'active_accounts_only'          => 'Active accounts only',
    'in_active_accounts_only'       => 'Inactive accounts only',
    'show_all_accounts'             => 'Show all accounts',
    'group_accounts'                => 'Group accounts',

    // piggy banks:
    'event_history'                 => 'Hendelseshistorikk',
    'add_money_to_piggy'            => 'Legg til penger i sparegris ":name"',
    'piggy_bank'                    => 'Sparegris',
    'new_piggy_bank'                => 'Ny sparegris',
    'store_piggy_bank'              => 'Opprett ny sparegris',
    'stored_piggy_bank'             => 'Lagre ny sparegris ":name"',
    'account_status'                => 'Kontostatus',
    'left_for_piggy_banks'          => 'Gjenstår i sparegriser',
    'sum_of_piggy_banks'            => 'Sum i sparegriser',
    'saved_so_far'                  => 'Spart til nå',
    'saved_so_far_total'            => 'Saved so far in total',
    'reset_history'                 => 'reset history',
    'reset_history_confirm'         => 'Are you sure you want to reset the history of this piggy bank? This will make the chart match the piggy bank\'s amount again.',
    'piggy_history_reset'           => 'The piggy bank history has been reset',
    'left_to_save'                  => 'Igjen å spare',
    'suggested_amount'              => 'Foreslått månedlig beløp for å spare',
    'add_money_to_piggy_title'      => 'Legg til penger i sparegris ":name"',
    'remove_money_from_piggy_title' => 'Fjern penger fra sparegris ":name"',
    'add'                           => 'Legg til',
    'no_money_for_piggy'            => 'Du har ikke flere penger å legge i denne sparegrisen.',
    'suggested_savings_per_month'   => 'Foreslått pr. måned',

    'remove'                    => 'Fjern',
    'max_amount_add'            => 'Maksimumsbeløpet du kan legge til er',
    'max_amount_remove'         => 'Maksimumsbeløpet du kan fjerne er',
    'update_piggy_button'       => 'Oppdater sparegris',
    'update_piggy_title'        => 'Oppdater sparegris ":name"',
    'updated_piggy_bank'        => 'Oppdatert sparegris ":name"',
    'details'                   => 'Detaljer',
    'events'                    => 'Hendelser',
    'target_amount'             => 'Målbeløp',
    'start_date'                => 'Startdato',
    'no_start_date'             => 'Ingen start dato',
    'target_date'               => 'Måldato',
    'no_target_date'            => 'Ingen måldato',
    'table'                     => 'Tabell',
    'delete_piggy_bank'         => 'Slett sparegris ":name"',
    'cannot_add_amount_piggy'   => 'Kan ikke legge :amount til i ":name".',
    'cannot_remove_from_piggy'  => 'Kan ikke fjerne :amount fra ":name".',
    'deleted_piggy_bank'        => 'Slettet sparegris ":name"',
    'added_amount_to_piggy'     => 'La til :amount i ":name"',
    'removed_amount_from_piggy' => 'Fjernet :amount fra ":name"',
    'piggy_events'              => 'Tilhørende sparegriser',

    // tags
    'delete_tag'                => 'Slett tag ":tag"',
    'deleted_tag'               => 'Slettet tag ":tag"',
    'new_tag'                   => 'Lag ny tag',
    'edit_tag'                  => 'Rediger tag ":tag"',
    'updated_tag'               => 'Oppdatert tag ":tag"',
    'created_tag'               => 'Tag ":tag" er opprettet!',

    'transaction_journal_information'               => 'Transaksjonsinformasjon',
    'transaction_journal_amount'                    => 'Informasjon om beløp',
    'transaction_journal_meta'                      => 'Metainformasjon',
    'transaction_journal_more'                      => 'Mer informasjon',
    'basic_journal_information'                     => 'Grunnleggende transaksjonsinformasjon',
    'transaction_journal_extra'                     => 'Ekstra informasjon',
    'att_part_of_journal'                           => 'Lagret under «:journal»',
    'total_amount'                                  => 'Totalbeløp',
    'number_of_decimals'                            => 'Antall desimaler',


    // administration
    'invite_is_already_redeemed'                    => 'Invitasjonen til «:address» har allerede blitt innløst.',
    'invite_is_deleted'                             => 'Invitasjonen til «:address» har blitt slettet.',
    'invite_new_user_title'                         => 'Inviter ny bruker',
    'invite_new_user_text'                          => 'As an administrator, you can invite users to register to your Firefly III installation. Using the direct link you can share with them, they will be able to register an account. The invited user and their invite link will appear in the table below. You are free to share the invitation link with them.',
    'invited_user_mail'                             => 'E-postadresse',
    'invite_user'                                   => 'Inviter bruker',
    'user_is_invited'                               => 'E-postadressen «:address» ble invitert til Firefly III',
    'administration'                                => 'Administrasjon',
    'system_settings'                               => 'Systeminnstillinger',
    'code_already_used'                             => 'Invitasjonskoden er allerede brukt',
    'user_administration'                           => 'Brukeradministrasjon',
    'list_all_users'                                => 'Alle brukere',
    'all_users'                                     => 'Alle brukere',
    'instance_configuration'                        => 'Konfigurasjon',
    'firefly_instance_configuration'                => 'Firefly III configuration',
    'setting_single_user_mode'                      => 'Enkeltbrukermodus',
    'setting_single_user_mode_explain'              => 'Som standard godtar Firefly III bare en (1) registrering: deg. Dette er et sikkerhetstiltak, som hindrer andre i å bruke din instans hvis du ikke tillater dem det. Fremtidige registreringer er blokkert. Når du krysser av denne ruten kan andre bruke din forekomst, forutsatt at de kan nå serveren (når den er koblet til Internett).',
    'store_configuration'                           => 'Lagre konfigurasjon',
    'single_user_administration'                    => 'Brukeradministrasjon for :email',
    'edit_user'                                     => 'Rediger bruker :email',
    'hidden_fields_preferences'                     => 'You can enable more transaction options in your <a href="preferences">preferences</a>.',
    'user_data_information'                         => 'Brukerdata',
    'user_information'                              => 'Brukerinformasjon',
    'total_size'                                    => 'totalstørrelse',
    'budget_or_budgets'                             => ':count budsjett|:count budsjetter',
    'budgets_with_limits'                           => ':count budget with configured amount|:count budgets with configured amount',
    'nr_of_rules_in_total_groups'                   => ':count_rules regler i :count_groups regel gruppe(r)',
    'tag_or_tags'                                   => ':count tagg|:count tagger',
    'configuration_updated'                         => 'Konfigurasjonen er oppdatert',
    'setting_is_demo_site'                          => 'Demo nettsted',
    'setting_is_demo_site_explain'                  => 'Hvis du avhuker denne boksen, vil installasjonen oppføre seg som om det er en demo site, som kan ha rare bivirkninger.',
    'block_code_bounced'                            => 'Epostmelding(er) kunne ikke leveres',
    'block_code_expired'                            => 'Demo-konto utløpt',
    'no_block_code'                                 => 'Ingen grunn for utestengelse eller brukeren er ikke utestengt',
    'demo_user_export'                              => 'The demo user cannot export data',
    'block_code_email_changed'                      => 'Brukeren har ikke bekreftet ny e-postadresse ennå',
    'admin_update_email'                            => 'I motsetning til profilsiden, vil brukeren IKKE bli varslet om at e-postadressen er endret!',
    'update_user'                                   => 'Oppdater bruker',
    'updated_user'                                  => 'Brukerdata er endret.',
    'delete_user'                                   => 'Slett bruker :email',
    'user_deleted'                                  => 'Brukeren er slettet',
    'send_test_email'                               => 'Send test-epostmelding',
    'send_test_email_text'                          => 'To see if your installation is capable of sending a notification, please press this button. You will not see an error here (if any), <strong>the log files will reflect any errors</strong>. You can press this button as many times as you like. There is no spam control. The message will be sent to <code>:email</code> and should arrive shortly.',
    'send_message'                                  => 'Send melding',
    'send_test_triggered'                           => 'Test ble utløst. Sjekk innboksen din og loggfilene.',
    'give_admin_careful'                            => 'Brukere som får administrative rettigheter kan ta bort din. Vær forsiktig.',
    'admin_maintanance_title'                       => 'Vedlikehold',
    'admin_maintanance_expl'                        => 'Noen smarte knapper for Firefly III vedlikehold',
    'admin_maintenance_clear_cache'                 => 'Tøm hurtigminne',
    'owner_notifications'                           => 'Admin notifications',
    'owner_notifications_expl'                      => 'The following notifications can be enabled or disabled by the administrator. It will be sent over ALL configured channels. Some channels are configured in your environment variables, others can be set here.',
    'channel_settings'                              => 'Settings for notification channels',
    'notification_test_failed'                      => 'Notification test for channel ":channel" failed. The logs will have more details.',
    'notification_test_executed'                    => 'Notification test for channel ":channel" executed. Check your logs for details.',
    'settings_notifications'                        => 'Settings for notifications',
    'title_owner_notifications'                     => 'Owner notifications',
    'owner_notification_check_user_new_reg'         => 'User gets post-registration welcome message',
    'owner_notification_check_admin_new_reg'        => 'Administrator(s) get new user registration notification',
    'owner_notification_check_new_version'          => 'A new version is available',
    'owner_notification_check_invite_created'       => 'A user is invited to Firefly III',
    'owner_notification_check_invite_redeemed'      => 'A user invitation is redeemed',
    'owner_notification_check_unknown_user_attempt' => 'An unknown user tries to login',
    'all_invited_users'                             => 'Alle inviterte brukere',
    'save_notification_settings'                    => 'Lagre innstillinger',
    'notification_settings'                         => 'Settings for notifications',
    'notification_settings_saved'                   => 'Varslingsinnstillingene har blitt lagret',
    'available_channels_title'                      => 'Available channels',
    'available_channels_expl'                       => 'These channels are available to send notifications over. To test your configuration, use the buttons below. Please note that the buttons have no spam control.',
    'notification_channel_name_email'               => 'Email',
    'slack_discord_double'                          => 'The Slack notification channel can also send notifications to Discord.',
    'notification_channel_name_slack'               => 'Slack',
    'notification_channel_name_ntfy'                => 'Ntfy.sh',
    'notification_channel_name_pushover'            => 'Pushover',
    'notification_channel_name_gotify'              => 'Gotify',
    'notification_channel_name_pushbullet'          => 'Pushbullet',
    'channel_not_available'                         => 'not available',
    'configure_channel_in_env'                      => 'needs environment variables',
    'test_notification_channel_name_email'          => 'Test email',
    'test_notification_channel_name_slack'          => 'Test Slack',
    'test_notification_channel_name_ntfy'           => 'Test Ntfy.sh',
    'test_notification_channel_name_pushover'       => 'Test Pushover',
    'test_notification_channel_name_gotify'         => 'Test Gotify',
    'test_notification_channel_name_pushbullet'     => 'Test Pushbullet',

    'split_transaction_title'               => 'Beskrivelse av den splittende transaksjon',
    'split_transaction_title_help'          => 'Hvis du oppretter en splittet transaksjon, må du ha en hoved beskrivelse for alle deler av transaksjonen.',
    'split_title_help'                      => 'Hvis du oppretter en splittet transaksjon, må du ha en global beskrivelse for alle deler av transaksjonen.',
    'you_create_transfer'                   => 'Du lager en overføring.',
    'you_create_withdrawal'                 => 'Du lager et uttak.',
    'you_create_deposit'                    => 'Du lager en innskud.',

    // links
    'journal_link_configuration'            => 'Konfigurasjon av transaksjonslenker',
    'create_new_link_type'                  => 'Opprett ny lenktype',
    'store_new_link_type'                   => 'Lagre ny koblingstype',
    'update_link_type'                      => 'Oppdater koblingstype',
    'edit_link_type'                        => 'Rediger lenketype ":name"',
    'updated_link_type'                     => 'Oppdatert lenketype ":name"',
    'delete_link_type'                      => 'Slett lenketype ":name"',
    'deleted_link_type'                     => 'Slettet lenketype ":name"',
    'stored_new_link_type'                  => 'Lagre ny lenketype ":name"',
    'cannot_edit_link_type'                 => 'Kan ikke redigere lenketype ":name"',
    'link_type_help_name'                   => 'Dvs. "Duplikater"',
    'link_type_help_inward'                 => 'Dvs. "duplikater"',
    'link_type_help_outward'                => 'Dvs. "dupliseres av"',
    'save_connections_by_moving'            => 'Lagre koblingen mellom disse transaksjonene ved å flytte dem til en annen lenktype:',
    'do_not_save_connection'                => '(ikke lagre kobling)',
    'link_transaction'                      => 'Sammenkoble transaksjon',
    'link_to_other_transaction'             => 'Koble denne transaksjonen til en annen transaksjon',
    'select_transaction_to_link'            => 'Select a transaction to link this transaction to. The links are currently unused in Firefly III (apart from being shown), but I plan to change this in the future. Use the search box to select a transaction either by title or by ID. If you want to add custom link types, check out the settings.',
    'this_transaction'                      => 'Denne transaksjonen',
    'transaction'                           => 'Transaksjon',
    'comments'                              => 'Kommentarer',
    'link_notes'                            => 'Eventuelle notater du vil lagre med lenken.',
    'invalid_link_selection'                => 'Kan ikke koble disse transaksjonene sammen',
    'selected_transaction'                  => 'Velg transaksjoner',
    'journals_linked'                       => 'Transaksjonene er knyttet sammen.',
    'journals_error_linked'                 => 'Disse transaksjonene er allerede knyttet sammen.',
    'journals_link_to_self'                 => 'Du kan ikke koble en transaksjon til seg selv',
    'journal_links'                         => 'Transaksjonskoblinger',
    'this_withdrawal'                       => 'Dette uttaket',
    'this_deposit'                          => 'Dette innskuddet',
    'this_transfer'                         => 'Denne overføringen',
    'overview_for_link'                     => 'Oversikt for linktype ":name"',
    'source_transaction'                    => 'Kildetransaksjon',
    'link_description'                      => 'Lenkebeskrivelse',
    'destination_transaction'               => 'Destinasjonstransaksjon',
    'delete_journal_link'                   => 'Slett koblingen mellom <a href=":source_link">:source</a> og <a href=":destination_link">:destination</a>',
    'deleted_link'                          => 'Slettet kobling',

    // link translations:
    'Paid_name'                             => 'Betalt',
    'Refund_name'                           => 'Refusjon',
    'Reimbursement_name'                    => 'Tilbakebetaling',
    'Related_name'                          => 'Relatert',
    'relates to_inward'                     => 'relatert til',
    'is (partially) refunded by_inward'     => 'er (delvis) refundert av',
    'is (partially) paid for by_inward'     => 'er (delvis) betalt av',
    'is (partially) reimbursed by_inward'   => 'er (delvis) tilbakebetalt av',
    'inward_transaction'                    => 'Innlands transaksjon',
    'outward_transaction'                   => 'Utenland transaksjon',
    'relates to_outward'                    => 'relatert til',
    '(partially) refunds_outward'           => '(delvise) refusjoner',
    '(partially) pays for_outward'          => 'betaler (delvis) for',
    '(partially) reimburses_outward'        => 'tilbakebetaler (delvis)',
    'is (partially) refunded by'            => 'er (delvis) refundert av',
    'is (partially) paid for by'            => 'er (delvis) betalt av',
    'is (partially) reimbursed by'          => 'er (delvis) tilbakebetalt av',
    'relates to'                            => 'relatert til',
    '(partially) refunds'                   => '(delvise) refusjoner',
    '(partially) pays for'                  => 'betaler (delvis) for',
    '(partially) reimburses'                => 'tilbakebetaler (delvis)',

    // split a transaction:
    'splits'                                => 'Deler opp',
    'add_another_split'                     => 'Legg til en oppdeling til',
    'cannot_edit_opening_balance'           => 'Du kan ikke redigere åpningssaldoen til en konto.',
    'no_edit_multiple_left'                 => 'Du har ikke valgt en tillatt transaksjon for redigering.',
    'breadcrumb_convert_group'              => 'Konverter transaksjonen',
    'convert_invalid_source'                => 'Kildeinformasjon er ugyldig for transaksjon #%d.',
    'convert_invalid_destination'           => 'Målinformasjon er ugyldig for transaksjon #%d.',
    'create_another'                        => 'Gå tilbake hit etter lagring for å opprette en ny.',
    'after_update_create_another'           => 'Gå tilbake hit etter oppdatering, for å fortsette å redigere.',
    'store_as_new'                          => 'Lagre som en ny transaksjon istedenfor å oppdatere.',
    'reset_after'                           => 'Nullstill skjema etter innsending',
    'errors_submission'                     => 'There was something wrong with your submission. Please check out the errors below.',
    'errors_submission_v2'                  => 'There was something wrong with your submission. Please check out the errors below: {{errorMessage}}',
    'transaction_expand_split'              => 'Utvid splitt',
    'transaction_remove_split'              => 'Remove split',
    'transaction_collapse_split'            => 'Kollaps deling',

    // object groups
    'default_group_title_name'              => '(ikke gruppert)',
    'default_group_title_name_plain'        => 'ikke gruppert',

    // empty lists? no objects? instructions:
    'no_accounts_title_asset'               => 'La oss opprette en aktivakonto!',
    'no_accounts_intro_asset'               => 'Du har ingen aktivakontoer ennå. Aktivakontoer er hovedkontoene dine: brukskonto, sparekonto, delt konto eller til og med kredittkortet ditt.',
    'no_accounts_imperative_asset'          => 'For å begynne å bruke Firefly III må du opprette minst én aktivakonto. La oss gjøre det nå:',
    'no_accounts_create_asset'              => 'Opprett en aktivakonto',
    'no_accounts_title_expense'             => 'La oss lage en utgiftskonto!',
    'no_accounts_intro_expense'             => 'Du har ingen utgiftskonto ennå. Utgiftskontoer er de stedene du bruker penger, for eksempel butikker og supermarkeder.',
    'no_accounts_imperative_expense'        => 'Utgiftskontoer opprettes automatisk når du oppretter transaksjoner, men du kan også opprette dem manuelt, hvis du vil. La oss lage en nå:',
    'no_accounts_create_expense'            => 'Opprett en utgiftskonto',
    'no_accounts_title_revenue'             => 'La oss opprette en inntektskonto!',
    'no_accounts_intro_revenue'             => 'Du har ingen inntektskonto ennå. Inntektskontoer er de stedene du mottar penger fra, for eksempel arbeidsgiveren din.',
    'no_accounts_imperative_revenue'        => 'Inntektsskontoer opprettes automatisk når du oppretter transaksjoner, men du kan også opprette dem manuelt, hvis du vil. La oss lage en nå:',
    'no_accounts_create_revenue'            => 'Opprett en inntektskonto',
    'no_accounts_title_liabilities'         => 'La oss lage et lån!',
    'no_accounts_intro_liabilities'         => 'Du har ingen gjeld ennå. "Gjeldskonto" er kontoer som du registrerer (studie) lån og andre former for gjeld på.',
    'no_accounts_imperative_liabilities'    => 'Du behøver ikke bruke denne funksjonen, men den kan være fornuftig å bruke når du vil ha kontroll på disse tingene.',
    'no_accounts_create_liabilities'        => 'Opprett gjeld',
    'no_budgets_title_default'              => 'La oss lage et budsjett',
    'no_rules_title_default'                => 'La oss lage en regel',
    'no_budgets_intro_default'              => 'Du har ingen budsjett ennå. Budsjett brukes til å organisere utgiftene i logiske grupper, som du kan sette tak på for å begrense utgiftene dine.',
    'no_rules_intro_default'                => 'Du har ingen regler ennå. Regler er kraftfulle automatiseringer som kan håndtere transaksjoner for deg.',
    'no_rules_imperative_default'           => 'Regler kan være veldig nyttige når du håndterer transaksjoner. La oss lage en nå:',
    'no_budgets_imperative_default'         => 'Budsjett er et basis verktøy for finansiell administrasjon. La oss lage et nå:',
    'no_budgets_create_default'             => 'Opprett et budsjett',
    'no_rules_create_default'               => 'Opprett en regel',
    'no_categories_title_default'           => 'La oss lage en kategori!',
    'no_categories_intro_default'           => 'Du har ingen kategorier ennå. Kategorier brukes til å finjustere dine transaksjoner og merke dem med sin egen kategori.',
    'no_categories_imperative_default'      => 'Kategorier opprettes automatisk når du oppretter transaksjoner, men du kan opprette en manuelt også. La oss opprette en nå:',
    'no_categories_create_default'          => 'Opprett en kategori',
    'no_tags_title_default'                 => 'La oss lage en tagg!',
    'no_tags_intro_default'                 => 'Du har ingen tagger enda. Tagger benyttes for å finjustere transaksjonene dine og merke dem med spesifikke nøkkelord.',
    'no_tags_imperative_default'            => 'Tags blir opprettet automatisk når du lager transaksjoner, men du kan lage de manuelt også. La oss lage en nå:',
    'no_tags_create_default'                => 'Opprett en tagg',
    'no_transactions_title_withdrawal'      => 'La oss lage en utgift!',
    'no_transactions_intro_withdrawal'      => 'Du har ingen utgifter ennå. Du kan legge inn utgifter for å begynne å administrere din økonomi.',
    'no_transactions_imperative_withdrawal' => 'Har du brukt penger? Da bør du skrive det ned:',
    'no_transactions_create_withdrawal'     => 'Opprett en utgift',
    'no_transactions_title_deposit'         => 'La oss legge inn noen inntekter!',
    'no_transactions_intro_deposit'         => 'Du har ingen registrert inntekt ennå. Du kan legge inn inntekter for å begynne å administrere din økonomi.',
    'no_transactions_imperative_deposit'    => 'Har du mottatt penger? Da bør du skrive det ned:',
    'no_transactions_create_deposit'        => 'Opprett et innskudd',
    'no_transactions_title_transfers'       => 'La oss legge inn en overføring!',
    'no_transactions_intro_transfers'       => 'Du har ingen overføringer ennå. Når du flytter penger mellom aktivakontoer, registreres dette som en overføring.',
    'no_transactions_imperative_transfers'  => 'Har du flyttet penger rundt? Da bør du skrive det ned:',
    'no_transactions_create_transfers'      => 'Opprett en overføring',
    'no_piggies_title_default'              => 'La oss lage en sparegris!',
    'no_piggies_intro_default'              => 'Du har ingen sparegriser ennå. Du kan opprette sparegriser for å forenkle sparing og holde oversikt over hva du sparer til.',
    'no_piggies_imperative_default'         => 'Har du ting du sparer penger til? Lag en sparegris for å få kontroll på sparingen:',
    'no_piggies_create_default'             => 'Lag en ny sparegris',
    'no_bills_title_default'                => 'Let\'s create a subscription!',
    'no_bills_intro_default'                => 'You have no subscriptions yet. You can create subscriptions to keep track of regular expenses, like your rent or insurance.',
    'no_bills_imperative_default'           => 'Do you have such regular subscriptions? Create a subscription and keep track of your payments:',
    'no_bills_create_default'               => 'Create a subscription',

    // recurring transactions
    'recurrence_max_count'                  => 'This recurring transactions will be created at most :max time(s), and has been created :count time(s) already.',
    'create_right_now'                      => 'Opprett med en gang',
    'no_new_transaction_in_recurrence'      => 'Ingen ny transaksjon ble opprettet. Kanskje de allerede var utført for denne datoen?',
    'recurrences'                           => 'Gjentakende transaksjoner',
    'repeat_until_in_past'                  => 'Denne gjentakende transaksjonen sluttet å gjenta :date.',
    'recurring_calendar_view'               => 'Kalender',
    'no_recurring_title_default'            => 'La oss opprette en gjentakende transaksjon!',
    'no_recurring_intro_default'            => 'Du har ingen gjentakende transaksjoner ennå. Du kan bruke disse for å få Firefly III til å automatisk opprette transaksjoner for deg.',
    'no_recurring_imperative_default'       => 'Dette er en ganske avansert funksjon, men det kan være svært nyttig. Husk å lese dokumentasjonen ((?)-ikonet øverst til høyre) før du fortsetter.',
    'no_recurring_create_default'           => 'Opprett en gjentakende transaksjon',
    'make_new_recurring'                    => 'Opprett en gjentakende transaksjon',
    'recurring_daily'                       => 'Daglig',
    'recurring_weekly'                      => 'Hver uke på :weekday',
    'recurring_weekly_skip'                 => 'Every :skip(st/nd/rd/th) week on :weekday',
    'recurring_monthly'                     => 'Hver måned på :dayOfMonth :weekday',
    'recurring_monthly_skip'                => 'Every :skip(st/nd/rd/th) month on the :dayOfMonth(st/nd/rd/th) day',
    'recurring_ndom'                        => 'Hver måned på :dayOfMonth :weekday',
    'recurring_ndom_skip'                   => 'Every :skip(st/nd/rd/th) month on the :dayOfMonth(st/nd/rd/th) :weekday',
    'recurring_yearly'                      => 'Hvert år den :date',
    'overview_for_recurrence'               => 'Oversikt for gjentakende transaksjon ":title"',
    'warning_duplicates_repetitions'        => 'I sjeldne tilfeller vises datoene to ganger i listen. Dette kan skje når flere gjentakelser kolliderer. Firefly III genererer alltid én transaksjon per dag.',
    'created_transactions'                  => 'Relaterte transaksjoner',
    'expected_withdrawals'                  => 'Forventede uttak',
    'expected_deposits'                     => 'Forventede innskudd',
    'expected_transfers'                    => 'Forventede overføringer',
    'created_withdrawals'                   => 'Opprettede uttak',
    'created_deposits'                      => 'Opprettede innskudd',
    'created_transfers'                     => 'Opprettede overføringer',
    'recurring_info'                        => 'Gjentagende transaksjon :count / :total',
    'created_from_recurrence'               => 'Opprettet fra gjentakende transaksjon ":title" (#:id)',
    'recurring_never_cron'                  => 'Det synes at cron jobben som er nødvendig for å støtte gjentakende transaksjoner har aldri kjørt. Dette er selvfølgelig normalt når du nettopp har installert Firefly III, men dette bør settes opp så snart som mulig. Sjekk ut hjelp-sidene ved å bruke (?) -ikonet i øverste høyre hjørne på siden.',
    'recurring_cron_long_ago'               => 'Det ser ut som det har gått mer enn 36 timer siden cron job\'en for å støtte gjentakende transaksjoner har kjørt. Er du sikker på at den er satt opp riktig? Sjekk ut hjelpe-sidene ved å bruke (?) -ikonet i øverste høyre hjørne på siden.',

    'create_new_recurrence'              => 'Lag ny gjentakende transaksjon',
    'help_first_date'                    => 'Spesifiser den første forventede gjentakelse, det må være i fremtiden.',
    'help_first_date_no_past'            => 'Spesifiser den første forventede gjentakelse. Firefly III vil ikke opprette transaksjoner i fortiden.',
    'no_currency'                        => '(ingen valuta)',
    'mandatory_for_recurring'            => 'Pålagt gjentakelses informasjon',
    'mandatory_for_transaction'          => 'Pålagt transaksjons informasjon',
    'optional_for_recurring'             => 'Valgfritt gjentakelses informasjon',
    'optional_for_transaction'           => 'Valgfritt transaksjons informasjon',
    'change_date_other_options'          => 'Ved å endre på "første dato" får du flere valg.',
    'mandatory_fields_for_tranaction'    => 'Verdiene her vil ende opp i transaksjonene som blir opprettet',
    'click_for_calendar'                 => 'Trykk her for å få en kalender som viser deg når transaksjonen vil gjenta seg.',
    'repeat_forever'                     => 'Gjenta for alltid',
    'repeat_until_date'                  => 'Gjenta til dato',
    'repeat_times'                       => 'Gjenta antall ganger',
    'recurring_skips_one'                => 'Annen hver',
    'recurring_skips_more'               => 'Hopper over :count forekomster',
    'store_new_recurrence'               => 'Lagre gjentakende transaksjon',
    'stored_new_recurrence'              => 'Gjentakende transaksjon ":title" lagret.',
    'edit_recurrence'                    => 'Rediger gjentakende transaksjon ":title"',
    'recurring_repeats_until'            => 'Gjenta til :date',
    'recurring_repeats_forever'          => 'Gjenta for alltid',
    'recurring_repeats_x_times'          => 'Gjentas om :count|Gjentar seg :count ganger',
    'update_recurrence'                  => 'Oppdater gjentakende transaksjon',
    'updated_recurrence'                 => 'Oppdatert gjentakende transaksjon ":title"',
    'recurrence_is_inactive'             => 'Denne gjentakende transaksjonen er ikke aktiv og vil ikke generere nye transaksjoner.',
    'delete_recurring'                   => 'Slett gjentakende transaksjon ":title"',
    'new_recurring_transaction'          => 'Opprett gjentakende transaksjon',
    'help_weekend'                       => 'Hva skal Firefly III gjøre når gjentakende transaksjon faller på en Lørdag eller Søndag?',
    'do_nothing'                         => 'Bare opprett transaksjonen',
    'skip_transaction'                   => 'Hopp over forekomsten',
    'jump_to_friday'                     => 'Opprett transaksjonen på foregående Fredag istedet',
    'jump_to_monday'                     => 'Opprett transaksjonen på neste Mandag istedet',
    'will_jump_friday'                   => 'Opprettes på Fredag i stedet for i helgene.',
    'will_jump_monday'                   => 'Opprettes på Mandag i stedet for i helgene.',
    'except_weekends'                    => 'Unntatt helger',
    'recurrence_deleted'                 => 'Gjentakende transaksjon ":title" slettet',


    // new lines for summary controller.
    'box_balance_in_currency'            => 'Balanse i (:currency)',
    'box_spent_in_currency'              => 'Brukt (:currency)',
    'box_earned_in_currency'             => 'Opptjent (:currency)',
    'box_budgeted_in_currency'           => 'Budsjettert (:currency)',
    'box_bill_paid_in_currency'          => 'Subscriptions paid (:currency)',
    'box_bill_unpaid_in_currency'        => 'Subscriptions unpaid (:currency)',
    'box_left_to_spend_in_currency'      => 'Igjen å bruke (:currency)',
    'box_net_worth_in_currency'          => 'Nettoverdi (:currency)',
    'box_spend_per_day'                  => 'Igjen å bruke per dag: :amount',

    // debug page
    'debug_page'                         => 'Feilsøk side',
    'debug_submit_instructions'          => 'Hvis du støter på problemer, kan du bruke informasjonen i denne boksen som feilsøkingsinformasjon. Kopier og lim inn i en ny eller eksisterende <a href="https://github.com/firefly-iii/firefly-iii/issues">GitHub issue</a>. Den vil generere en tabell som kan brukes til å diagnostisere problemet.',
    'debug_pretty_table'                 => 'Hvis du kopierer/limer inn boksen under i et GitHub issue, vil det generere en tabell. Ikke omgi denne teksten med aksentsymboler eller anførselstegn.',
    'debug_additional_data'              => 'Du kan også dele innholdet i boksen nedenfor. Du kan kopiere og lime inn dette i en ny eller eksisterende <a href="https://github.com/firefly-iii/firefly-iii/issues">GitHub-sak</a>. Vær imidlertid oppmerksom på at innholdet i denne boksen kan inneholde privat informasjon som kontonavn, transaksjonsdetaljer og/eller e-postadresser.',

    // object groups
    'object_groups_menu_bar'             => 'Grupper',
    'object_groups_page_title'           => 'Grupper',
    'object_groups_breadcrumb'           => 'Grupper',
    'object_groups_index'                => 'Oversikt',
    'object_groups'                      => 'Grupper',
    'object_groups_empty_explain'        => 'Noen elementer i Firefly III kan deles inn i grupper. Sparegriser, for eksempel, har et "Gruppe"-felt på redigerings- og opprettelsesskjermene. Når du angir dette feltet, kan du redigere navnene og rekkefølgen på gruppene på denne siden. For mer informasjon, sjekk hjelpesidene i øverste høyre hjørne, under (?)-ikonet.',
    'object_group_title'                 => 'Tittel',
    'edit_object_group'                  => 'Rediger gruppen «:title»',
    'delete_object_group'                => 'Slett gruppen «:title»',
    'update_object_group'                => 'Oppdater gruppe',
    'updated_object_group'               => 'Gruppen «:title» ble oppdatert',
    'deleted_object_group'               => 'Gruppen «:title» ble slettet',
    'object_group'                       => 'Gruppe',

    // other stuff
    'placeholder'                        => '[Placeholder]',

    // audit log entries
    'audit_log_entries'                  => 'Gjennomgå loggoppføringer',
    'ale_action_log_add'                 => 'La til :amount i sparegrisen «:name»',
    'ale_action_log_remove'              => 'Fjernet :amount fra sparegrisen «:name»',
    'ale_action_clear_budget'            => 'Fjernet fra budsjett',
    'ale_action_update_group_title'      => 'Oppdatert transaksjonsgruppens tittel',
    'ale_action_update_date'             => 'Oppdatert transaksjonsdato',
    'ale_action_update_order'            => 'Oppdatert transaksjonsrekkefølge',
    'ale_action_clear_category'          => 'Fjernet fra kategori',
    'ale_action_clear_notes'             => 'Fjernet notater',
    'ale_action_clear_tag'               => 'Fjernet tagg',
    'ale_action_clear_all_tags'          => 'Fjernet alle tagger',
    'ale_action_set_bill'                => 'Linked to subscription',
    'ale_action_switch_accounts'         => 'Byttet kilde og målkonto',
    'ale_action_set_budget'              => 'Sett budsjett',
    'ale_action_set_category'            => 'Sett kategori',
    'ale_action_set_source'              => 'Sett kildekonto',
    'ale_action_set_destination'         => 'Sett målkonto',
    'ale_action_update_transaction_type' => 'Endret transaksjonstype',
    'ale_action_update_notes'            => 'Endret notater',
    'ale_action_update_description'      => 'Endret beskrivelse',
    'ale_action_add_to_piggy'            => 'Sparegris',
    'ale_action_remove_from_piggy'       => 'Sparegris',
    'ale_action_add_tag'                 => 'La til tagg',
    'ale_action_update_amount'           => 'Updated amount',

    // dashboard
    'enable_auto_convert'                => 'Aktiver valutakonvertering',
    'disable_auto_convert'               => 'Deaktiver valutakonvertering',
];
