<?php

/**
 * form.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */



declare(strict_types=1);

return [
    // new user:
    'administration_currency'      => 'Moneda Principal',
    'bank_name'                    => 'Banco',
    'bank_balance'                 => 'Saldo',
    'current_balance'              => 'Balance actual',
    'savings_balance'              => 'Saldo de ahorro',
    'credit_card_limit'            => 'Límite de la tarjeta de crédito',
    'automatch'                    => 'Coinciden automáticamente',
    'skip'                         => 'Saltar',
    'enabled'                      => 'Habilitado',
    'name'                         => 'Nombre',
    'active'                       => 'Activo',
    'amount_min'                   => 'Importe mínimo',
    'amount_max'                   => 'Importe máximo',
    'match'                        => 'Encontrado en',
    'strict'                       => 'Modo estricto',
    'repeat_freq'                  => 'Repetición',
    'object_group'                 => 'Grupo',
    'location'                     => 'Ubicación',
    'update_channel'               => 'Canal de actualizaciones',
    'currency_id'                  => 'Divisa',
    'transaction_currency_id'      => 'Moneda',
    'auto_budget_currency_id'      => 'Moneda',
    'external_ip'                  => 'IP externa de su servidor',
    'attachments'                  => 'Adjuntos',
    'BIC'                          => 'BIC',
    'verify_password'              => 'Verificar la seguridad de contraseña',
    'source_account'               => 'Cuenta origen',
    'destination_account'          => 'Cuenta destino',
    'asset_destination_account'    => 'Cuenta de destino',
    'include_net_worth'            => 'Incluir en valor neto',
    'asset_source_account'         => 'Cuenta de origen',
    'journal_description'          => 'Descripción',
    'note'                         => 'Notas',
    'currency'                     => 'Divisa',
    'account_id'                   => 'Cuenta',
    'budget_id'                    => 'Presupuesto',
    'bill_id'                      => 'Suscripción',
    'opening_balance'              => 'Saldo inicial',
    'tag_mode'                      => 'Modo de etiqueta',
    'virtual_balance'              => 'Saldo virtual',
    'run_after_form' => 'Run this rule',



    'targetamount'                 => 'Cantidad objetivo',
    'target_amount'                => 'Cantidad objetivo',
    'account_role'                 => 'Rol de cuenta',
    'opening_balance_date'         => 'Fecha del saldo inicial',
    'cc_type'                      => 'Plan de pagos con tarjeta de crédito',
    'cc_monthly_payment_date'      => 'Fecha de pago mensual de la tarjeta de crédito',
    'piggy_bank_id'                => 'Hucha',
    'returnHere'                   => 'Volver aquí',
    'returnHereExplanation'        => 'Después de guardar, vuelve aquí para crear otro.',
    'returnHereUpdateExplanation'  => 'Después de actualizar, vuelve aquí.',
    'description'                  => 'Descripción',
    'expense_account'              => 'Cuenta de gastos',
    'revenue_account'              => 'Cuenta de ingresos',
    'decimal_places'               => 'Lugares decimales',
    'destination_amount'           => 'Importe (destino)',
    'new_email_address'            => 'Nueva dirección de email',
    'verification'                 => 'Verificación',
    'api_key'                      => 'Clave de API',
    'remember_me'                  => 'Recordarme',
    'liability_type_id'            => 'Tipo de pasivo',
    'liability_type'               => 'Tipo de pasivo',
    'interest'                     => 'Interés',
    'interest_period'              => 'Período de interés',
    'extension_date'               => 'Fecha de extensión',
    'type'                         => 'Tipo',
    'convert_Withdrawal'           => 'Convertir extracción',
    'convert_Deposit'              => 'Convertir depósito',
    'convert_Transfer'             => 'Convertir transferencia',
    'amount'                       => 'Importe',
    'foreign_amount'               => 'Cantidad extranjera',
    'date'                         => 'Fecha',
    'interest_date'                => 'Fecha de interés',
    'book_date'                    => 'Fecha de registro',
    'process_date'                 => 'Fecha de procesamiento',
    'category'                     => 'Categoría',
    'tags'                         => 'Etiquetas',
    'deletePermanently'            => 'Borrar permanentemente',
    'cancel'                       => 'Cancelar',
    'targetdate'                   => 'Fecha límite',
    'target_date'                  => 'Fecha objetivo',
    'startdate'                    => 'Fecha de inicio',
    'start_date'                   => 'Fecha de inicio',
    'tag'                          => 'Etiqueta',

    // exchange rates
    'from_currency_to_currency'    => '{from} &rarr; {to}',
    'to_currency_from_currency'    => '{to} &rarr; {from}',
    'rate'                         => 'Denos su evaluación',

    'under'                        => 'Debajo',
    'symbol'                       => 'Símbolo',
    'code'                         => 'Código',
    'iban'                         => 'IBAN',
    'account_number'               => 'Número de cuenta',
    'creditCardNumber'             => 'Número de la tarjeta de crédito',
    'has_headers'                  => 'Encabezados',
    'date_format'                  => 'Formato de fecha',
    'attachments[]'                => 'Adjuntos',
    'title'                        => 'Título',
    'notes'                        => 'Notas',
    'filename'                     => 'Nombre de fichero',
    'mime'                         => 'Tipo Mime',
    'size'                         => 'Tamaño',
    'trigger'                      => 'Disparador',
    'stop_processing'              => 'Detener el procesamiento',
    'end_date'                     => 'Fecha final',
    'enddate'                      => 'Fecha fin',
    'move_rules_before_delete'     => 'Grupo de reglas',
    'start'                        => 'Inicio del rango',
    'end'                          => 'Final del rango',
    'delete_account'               => 'Borrar cuenta ":name"',
    'delete_webhook'               => 'Eliminar webhook ":title"',
    'delete_bill'                  => 'Borrar suscripción ":name"',
    'delete_budget'                => 'Eliminar presupuesto ":name"',
    'delete_category'              => 'Eliminar categoría ":name"',
    'delete_currency'              => 'Eliminar divisa ":name"',
    'delete_journal'               => 'Eliminar la transacción con descripción ":description"',
    'delete_attachment'            => 'Eliminar adjunto ":name"',
    'delete_rule'                  => 'Eliminar regla ":title"',
    'delete_rule_group'            => 'Eliminar grupo de reglas ":title"',
    'delete_link_type'             => 'Eliminar tipo de enlace ":name"',
    'delete_user'                  => 'Eliminar usuario ":email"',
    'delete_recurring'             => 'Eliminar transacción recurrente ":title"',
    'user_areYouSure'              => 'Si elimina usuario ":email", todo desaparecerá. No hay deshacer, recuperar ni nada. Si te eliminas, perderás el acceso a esta instancia de Firefly III.',
    'attachment_areYouSure'        => '¿Seguro que quieres eliminar el archivo adjunto llamado "name"?',
    'account_areYouSure'           => '¿Seguro que quieres eliminar la cuenta llamada ":name"?',
    'account_areYouSure_js'        => '¿Está seguro que desea eliminar la cuenta llamada "{name}"?',
    'bill_areYouSure'              => '¿Está seguro que desea eliminar la suscripción llamada ":name"?',
    'rule_areYouSure'              => '¿Seguro que quieres eliminar la regla titulada ":title"?',
    'object_group_areYouSure'      => '¿Seguro que quieres eliminar el grupo titulado ":title"?',
    'ruleGroup_areYouSure'         => '¿Seguro que quieres eliminar el grupo de reglas titulado ":title"?',
    'budget_areYouSure'            => '¿Seguro que quieres eliminar el presupuesto llamado ":name"?',
    'webhook_areYouSure'           => '¿Seguro que quieres eliminar el webhook llamado ":title"?',
    'category_areYouSure'          => '¿Seguro que quieres eliminar la categoría llamada ":name"?',
    'recurring_areYouSure'         => '¿Está seguro de que desea eliminar la transacción recurrente ":title"?',
    'currency_areYouSure'          => '¿Está seguro que desea eliminar la moneda denominada ":name"?',
    'piggyBank_areYouSure'         => '¿Está seguro que desea eliminar la hucha llamada ":name"?',
    'journal_areYouSure'           => '¿Estás seguro de que deseas eliminar la transacción descrita ":description"?',
    'mass_journal_are_you_sure'    => '¿Usted esta seguro de querer eliminar estas transacciones?',



    'tag_areYouSure'               => '¿Seguro que quieres eliminar la etiqueta ":tag"?',
    'journal_link_areYouSure'      => '¿Seguro que quieres eliminar el vínculo entre <a href=":source_link">:source</a> y <a href=":destination_link">:destination</a>?',
    'linkType_areYouSure'          => '¿Estás seguro de que deseas eliminar el tipo de vínculo ":name" (":inward" / ":outward")?',
    'permDeleteWarning'            => 'Eliminar cosas de Firefly III es permanente y no se puede deshacer.',
    'mass_make_selection'          => 'Aún puede evitar que se eliminen elementos quitando la casilla de verificación.',
    'delete_all_permanently'       => 'Eliminar selección permanentemente',
    'update_all_journals'          => 'Actualiza estas transacciones',
    'also_delete_transactions'     => 'La única transacción conectada a esta cuenta también se eliminará. | Todas las :count transacciones conectadas a esta cuenta también se eliminarán.',
    'also_delete_transactions_js'  => 'Ninguna transacción|La única transacción conectada a esta cuenta se eliminará también.|Todas las {count} transacciones conectadas a esta cuenta también se eliminarán.',
    'also_delete_connections'      => 'La única transacción vinculada con este tipo de enlace perderá esta conexión. | Todas las :count transacciones vinculadas con este tipo de enlace perderán su conexión.',
    'also_delete_rules'            => 'La única regla conectada a este grupo de reglas también se eliminará. | Todas las :count reglas conectadas a este grupo de reglas también se eliminarán.',
    'also_delete_piggyBanks'       => 'La hucha conectada a esta cuenta también se eliminará.|Las :count huchas conectadas a esta cuenta también se eliminarán.',
    'also_delete_piggyBanks_js'    => 'Ninguna alcancía|La única alcancía conectada a esta cuenta también será borrada. También se eliminarán todas {count} alcancías conectados a esta cuenta.',
    'not_delete_piggy_banks'       => 'La alcancía conectada a este grupo no será eliminada.|Las :count alcancías conectados a este grupo no serán eliminados.',
    'bill_keep_transactions'       => 'La única transacción conectada a esta suscripción no se eliminará.|Todas las transacciones :count conectadas a esta suscripción se eliminarán por separado.',
    'budget_keep_transactions'     => 'La transacción conectada a este presupuesto no se eliminará.|Las :count transacciones conectadas a este presupuesto no serán eliminadas.',
    'category_keep_transactions'   => 'La transacción conectada a esta categoría no se eliminará.|Las :count transacciones conectadas a esta categoría no serán eliminadas.',
    'recurring_keep_transactions'  => 'La transacción conectada a esta transacción recurrente no se eliminará.|Las :count transacciones conectadas a esta transacción recurrente no serán eliminadas.',
    'tag_keep_transactions'        => 'La transacción conectada a esta etiqueta no se eliminará.|Las :count transacciones conectadas a esta etiqueta no serán eliminadas.',
    'check_for_updates'            => 'Buscar actualizaciones',
    'liability_direction'          => 'Pasivo entrada/salida',
    'delete_object_group'          => 'Eliminar grupo ":title"',
    'email'                        => 'Correo electrónico',
    'password'                     => 'Contraseña',
    'password_confirmation'        => 'Contraseña (otra vez)',
    'blocked'                      => '¿Está bloqueado?',
    'blocked_code'                 => 'Razón del bloqueo',
    'login_name'                   => 'Iniciar sesión',
    'is_owner'                     => '¿Es el administrador?',
    'url'                          => 'URL',
    'bill_end_date'                => 'Fecha final',

    // import
    'apply_rules'                  => 'Aplicar reglas',
    'artist'                       => 'Artista',
    'album'                        => 'Álbum',
    'song'                         => 'Canción',

    // admin
    'domain'                       => 'Dominio',
    'single_user_mode'             => 'Deshabilitar registro de usuario',
    'is_demo_site'                 => 'Está en modo demostración',

    // import
    'configuration_file'           => 'Archivo de configuración',
    'csv_comma'                    => 'Una coma (,)',
    'csv_semicolon'                => 'Un punto y coma (;)',
    'csv_tab'                      => 'Un tabulador (invisible)',
    'csv_delimiter'                => 'Delimitador de campo CSV',
    'client_id'                    => 'Identificación del cliente',
    'app_id'                       => 'ID de la App',
    'secret'                       => 'Secreto',
    'public_key'                   => 'Llave pública',
    'country_code'                 => 'Código del país',
    'provider_code'                => 'Banco o proveedor de datos',
    'fints_url'                    => 'URL de la API de FinTS',
    'fints_port'                   => 'Puerto',
    'fints_bank_code'              => 'Código bancario',
    'fints_username'               => 'Usuario',
    'fints_password'               => 'PIN / Contraseña',
    'fints_account'                => 'Cuenta FinTS',
    'local_account'                => 'Cuenta Firefly III',



    'from_date'                    => 'Fecha desde',
    'to_date'                      => 'Fecha hasta',
    'due_date'                     => 'Fecha de vencimiento',
    'payment_date'                 => 'Fecha de pago',
    'invoice_date'                 => 'Fecha de la factura',
    'internal_reference'           => 'Referencia interna',
    'inward'                       => 'Descripción interna',
    'outward'                      => 'Descripción externa',
    'rule_group_id'                => 'Grupo de reglas',
    'transaction_description'      => 'Descripción de la transacción',
    'first_date'                   => 'Primera fecha',
    'transaction_type'             => 'Tipo de transacción',
    'repeat_until'                 => 'Repetir hasta',
    'recurring_description'        => 'Descripción de transacción recurrente',
    'repetition_type'              => 'Tipo de repetición',
    'foreign_currency_id'          => 'Moneda extranjera',
    'repetition_end'               => 'Termina la repetición',
    'repetitions'                  => 'Repeticiones',
    'calendar'                     => 'Calendario',
    'weekend'                      => 'Fin de semana',
    'client_secret'                => 'Secreto del cliente',
    'withdrawal_destination_id'    => 'Cuenta de destino',
    'deposit_source_id'            => 'Cuenta de origen',
    'expected_on'                  => 'Esperado para',
    'paid'                         => 'Pagado',
    'auto_budget_type'             => 'Autopresupuesto',
    'auto_budget_amount'           => 'Importe del autopresupuesto',
    'auto_budget_period'           => 'Período del autopresupuesto',
    'collected'                    => 'Cobrado',
    'submitted'                    => 'Enviado',
    'key'                          => 'Clave',
    'value'                        => 'Contenido del registro',
    'webhook_delivery'             => 'Entrega',
    'webhook_response'             => 'Respuesta',
    'webhook_trigger'              => 'Disparador',
    'pushover_app_token'           => 'Token de aplicación Pushover',
    'pushover_user_token'          => 'Token de usuario de Pushover',
    'ntfy_server'                  => 'Servidor Ntfy',
    'ntfy_topic'                   => 'Ntficar tema',
    'ntfy_auth'                    => 'Autenticación Ntfy habilitada',
    'ntfy_user'                    => 'Ntfy nombre de usuario',
    'ntfy_pass'                    => 'Contraseña Ntfy',
];
