<?php

/**
 * firefly.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

declare(strict_types=1);


return [
    // general stuff:
    'stored_in_tz'                              => 'uloženo v ":timezone"',
    'displayed_in_tz'                           => 'zobrazeno v ":timezone"',
    'close'                                     => 'Zavřít',
    'actions'                                   => 'Akce',
    'edit'                                      => 'Upravit',
    'loading'                                   => 'Loading',
    'transaction_journal_id'                    => 'Transaction journal ID',
    'delete'                                    => 'Odstranit',
    'split'                                     => 'Rozdělit',
    'single_split'                              => 'Rozdělit',
    'clone'                                     => 'Klonovat',
    'clone_and_edit'                            => 'Klonovat a upravit',
    'confirm_action'                            => 'Potvrdit akci',
    'last_seven_days'                           => 'Posledních sedm dní',
    'last_thirty_days'                          => '',
    'last_180_days'                             => 'Posledních 180 dní',
    'month_to_date'                             => 'Měsíc k dnešnímu dni',
    'year_to_date'                              => 'Rok k dnešnímu dni',
    'YTD'                                       => 'Tento rok',
    'welcome_back'                              => 'Jak to jde?',
    'main_dashboard_page_title'                 => 'Domů',
    'everything'                                => 'Vše',
    'today'                                     => 'dnes',
    'customRange'                               => 'Vlastní rozsah',
    'date_range'                                => 'Časové období',
    'apply'                                     => 'Použít',
    'select_date'                               => 'Vyberte datum…',
    'cancel'                                    => 'Storno',
    'from'                                      => 'Od',
    'to'                                        => 'Komu',
    'structure'                                 => 'Struktura',
    'help_translating'                          => 'Text této nápovědy ještě není k dispozici ve vašem jazyce. <a href="https://crowdin.com/project/firefly-iii-help">Pomůžete s překladem?</a>',
    'showEverything'                            => 'Zobrazit vše',
    'never'                                     => 'Nikdy',
    'no_results_for_empty_search'               => 'Nezadali jste žádné parametry vyhledávání, takže nebylo co hledat.',
    'removed_amount'                            => 'Odebráno :amount',
    'added_amount'                              => 'Přidáno :amount',
    'asset_account_role_help'                   => 'Jakékoliv další možnosti, vyplývající z vaší volby lze nastavit později.',
    'Opening balance'                           => 'Počáteční zůstatek',
    'create_new_stuff'                          => 'Vytvořit novou věc',
    'new_withdrawal'                            => 'Nový výběr',
    'create_new_transaction'                    => 'Vytvořit novou transakci',
    'sidebar_frontpage_create'                  => 'Vytvořit',
    'new_transaction'                           => 'Nová transakce',
    'no_rules_for_bill'                         => 'This subscription has no rules associated to it.',
    'go_to_asset_accounts'                      => 'Zobrazit účty s aktivy',
    'go_to_budgets'                             => 'Přejít k rozpočtům',
    'go_to_withdrawals'                         => 'Přejít na výběry',
    'clones_journal_x'                          => 'Tato transakce je kopií „:description“ (#:id)',
    'go_to_categories'                          => 'Přejít ke kategoriím',
    'go_to_bills'                               => 'Přejít k pravidelným platbám',
    'go_to_expense_accounts'                    => 'Zobrazit výdajové účty',
    'go_to_revenue_accounts'                    => 'Zobrazit výnosové účty',
    'go_to_piggies'                             => 'Přejít k pokladničkám',
    'new_deposit'                               => 'Nový vklad',
    'new_transfer'                              => 'Nový převod',
    'new_transfers'                             => 'Nový převod',
    'new_asset_account'                         => 'Nový účet s aktivy',
    'new_expense_account'                       => 'Nový výdajový účet',
    'new_revenue_account'                       => 'Nový výnosový účet',
    'new_liabilities_account'                   => 'Nový závazek',
    'new_budget'                                => 'Nový rozpočet',
    'new_bill'                                  => 'Nová pravidelná platba',
    'block_account_logout'                      => 'Byli jste odhlášeni. Zablokované účty nemohou tuto stránku používat. Zaregistrovali jste se pomocí platné e-mailové adresy?',
    'flash_success'                             => 'Výborně!',
    'flash_info'                                => 'Zpráva',
    'flash_warning'                             => 'Varování!',
    'flash_error'                               => 'Chyba!',
    'flash_danger'                              => 'Pozor!',
    'flash_info_multiple'                       => 'Jedna zpráva | :count zpráv',
    'flash_error_multiple'                      => 'Jedna chyba | :count chyb',
    'net_worth'                                 => 'Čisté jmění',
    'help_for_this_page'                        => 'Nápověda pro tuto stránku',
    'help_for_this_page_body'                   => 'Více informací o této stránce <a href="https://docs.firefly-iii.org/">naleznete v dokumentaci</a>.',
    'two_factor_welcome'                        => 'Zdravíme!',
    'two_factor_enter_code'                     => 'Pro pokračování zadejte kód pro dvoufázové ověření. Vaše aplikace ho pro vás může vytvořit.',
    'two_factor_code_here'                      => 'Sem zadejte kód',
    'two_factor_title'                          => 'Dvoufázové ověření',
    'authenticate'                              => 'Ověřit',
    'two_factor_forgot_title'                   => 'Ztratil(a) jsem dvoufázové ověřování',
    'two_factor_forgot'                         => 'Zapomněl(a) jsem si nástroj pro dvoufázové ověření.',
    'two_factor_lost_header'                    => 'Ztratili jste své dvoufázové ověření?',
    'two_factor_lost_intro'                     => 'Pokud jste ztratili i své záložní kódy, máte smůlu. Toto se pak už nedá napravit z webového rozhraní. Máte dvě možnosti:',
    'two_factor_lost_fix_self'                  => 'Pokud si sami provozujete instanci Firefly III, přečtěte si <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working> tento záznam v FAQ</a> pro instrukce.',
    'two_factor_lost_fix_owner'                 => 'V ostatních případech napište provozovateli, <a href="mailto::site_owner">:site_owner</a> a požádejte ho o resetování svého dvoufázového ověřování.',
    'mfa_backup_code'                           => 'Použitím záložního kódu, umožňujícího přihlášení do Firefly III, platnost kódu zaniká. Takže kód, kterým jste se už přihlásili, už k ničemu není (není možné ho použít opakovaně) proto si ho ze seznamu vyškrtněte.',
    'pref_two_factor_new_backup_codes'          => 'Získat nové záložní kódy',
    'pref_two_factor_backup_code_count'         => 'Máte :count platný kód zálohy.|Máte :count platných záložních kódů.',
    '2fa_i_have_them'                           => 'Uložil jsem je!',
    'warning_much_data'                         => ':days dnů dat může chvíli trvat načíst.',
    'registered'                                => 'Úspěšně jste se zaregistrovali!',
    'Default asset account'                     => 'Výchozí účet s aktivy',
    'no_budget_pointer'                         => '<a href="budgets">Zde</a> si můžete spravovat rozpočty, které vám mohou pomoci sledovat výdaje.',
    'no_bill_pointer'                           => 'Zdá se, že ještě nemáte žádné pravidelné platby. Měli byste některé vytvořit na <a href="subscriptions">pravidelné platby</a>-. Pravidelné platby vám mohou pomoci sledovat výdaje.',
    'Savings account'                           => 'Spořicí účet',
    'Credit card'                               => 'Kreditní karta',
    'source_accounts'                           => 'Zdrojový účet|Zdrojové účty',
    'destination_accounts'                      => 'Cílový účet|Cílové účty',
    'user_id_is'                                => 'Vaše ID uživatele je <strong>:user</strong>',
    'field_supports_markdown'                   => 'Text v této kolonce je možné formátovat pomocí <a href="https://en.support.wordpress.com/markdown-quick-reference/">Markdown</a>.',
    'need_more_help'                            => 'Pokud potřebujete další pomoc s používáním Firefly III, <a href="https://github.com/firefly-iii/firefly-iii/issues">vytvořte problém na GitHubu</a>.',
    'reenable_intro_text'                       => 'Můžete si také znovu spustit <a href="#" id="reenableGuidance">úvodního průvodce</a>.',
    'intro_boxes_after_refresh'                 => 'Oblasti s úvodem se znovu objeví po opětovném načtení stránky.',
    'show_all_no_filter'                        => 'Zobrazit všechny transakce bez seskupení je podle data.',
    'expenses_by_category'                      => 'Výdaje podle kategorie',
    'expenses_by_budget'                        => 'Výdaje podle rozpočtu',
    'income_by_category'                        => 'Příjem podle kategorie',
    'expenses_by_asset_account'                 => 'Výdaje podle účtů aktiv',
    'expenses_by_expense_account'               => 'Expenses by destination account',
    'cannot_redirect_to_account'                => 'Firefly III se nedaří přesměrovat vás na správnou stránku. Omlouváme se.',
    'sum_of_expenses'                           => 'Souhrn výdajů',
    'sum_of_income'                             => 'Souhrn příjmů',
    'liabilities'                               => 'Závazky',
    'spent_in_specific_budget'                  => 'Utraceno v rozpočtu „:budget“',
    'spent_in_specific_double'                  => 'Utraceno v účtu „:account“',
    'earned_in_specific_double'                 => 'Vyděláno v účtu „:account“',
    'source_account'                            => 'Zdrojový účet',
    'source_account_reconciliation'             => 'Nemůžete upravovat zdrojový účet srovnávací transakce.',
    'destination_account'                       => 'Cílový účet',
    'destination_account_reconciliation'        => 'Cílový účet odsouhlasené transakce nelze upravit.',
    'sum_of_expenses_in_budget'                 => 'Celkem utraceno v rozpočtu „:budget“',
    'left_in_budget_limit'                      => 'Ponecháno k utracení dle rozpočtu',
    'current_period'                            => 'Stávající období',
    'show_the_current_period_and_overview'      => 'Zobrazit aktuální období a přehled',
    'pref_languages_locale'                     => 'Aby správně fungovaly i jiné jazyky, než je angličtina, je třeba, aby byl operační systém vybaven správnými údaji o místních a jazykových nastaveních. Pokud nejsou přítomné, data o měnách, datech a částkách mohou být chybně formátovaná.',
    'budget_in_period'                          => 'Všechny transakce pro rozpočet „:name“ mezi :start a :end v :currency',
    'chart_budget_in_period'                    => 'Graf všech transakcí pro rozpočet „:name“ mezi :start a :end v :currency',
    'chart_budget_in_period_only_currency'      => 'Částka rozpočtu byla v :currency, takže tento graf bude zobrazovat pouze transakce v :currency.',
    'chart_account_in_period'                   => 'Graf veškerých transakcí pro účet ":name" (:balance) mezi :start a :end',
    'chart_category_in_period'                  => 'Graf veškerých transakcí pro kategorii „:name“ mezi :start a :end',
    'chart_category_all'                        => 'Graf veškerých transakcí pro kategoii „:name“',
    'clone_withdrawal'                          => 'Klonovat tento výběr',
    'clone_deposit'                             => 'Klonovat tento vklad',
    'clone_transfer'                            => 'Klonovat tento převod',
    'multi_select_no_selection'                 => 'Nic nevybráno',
    'multi_select_select_all'                   => 'Vybrat vše',
    'multi_select_n_selected'                   => 'vybráno',
    'multi_select_all_selected'                 => 'Všechny vybrané',
    'multi_select_filter_placeholder'           => 'Najít…',
    'intro_next_label'                          => 'Následující',
    'intro_prev_label'                          => 'Předchozí',
    'intro_skip_label'                          => 'Přeskočit',
    'intro_done_label'                          => 'Hotovo',
    'between_dates_breadcrumb'                  => 'Mezi :start a :end',
    'all_journals_without_budget'               => 'Všechny transakce bez rozpočtu',
    'journals_without_budget'                   => 'Transakce bez rozpočtu',
    'all_journals_without_category'             => 'Všechny transakce bez kategorie',
    'journals_without_category'                 => 'Transakce bez kategorie',
    'all_journals_for_account'                  => 'Všechny transakce pro účet :name',
    'chart_all_journals_for_account'            => 'Graf veškerých transakcí pro účet „:name“',
    'journals_in_period_for_account'            => 'Veškeré transakce pro účet „:name“ mezi :start a :end',
    'journals_in_period_for_account_js'         => 'Veškeré transakce pro účet {title} mezi {start} a {end}',
    'transferred'                               => 'Přeneseno',
    'all_withdrawal'                            => 'Všechny výdaje',
    'all_transactions'                          => 'Všechny transakce',
    'title_withdrawal_between'                  => 'Všechny výdaje mezi :start a :end',
    'all_deposit'                               => 'Veškeré výnosy',
    'title_deposit_between'                     => 'Všechny výnosy mezi :start a :end',
    'all_transfers'                             => 'Všechny převody',
    'title_transfers_between'                   => 'Všechny převody mezi :start a :end',
    'all_transfer'                              => 'Všechny převody',
    'all_journals_for_tag'                      => 'Všechny transakce pro značku „:tag“',
    'title_transfer_between'                    => 'Všechny převody mezi :start a :end',
    'all_journals_for_category'                 => 'Všechny transakce pro kategorii :name',
    'all_journals_for_budget'                   => 'Všechny transakce pro rozpočet :name',
    'chart_all_journals_for_budget'             => 'Graf veškerých transakcí pro rozpočet „:name“',
    'journals_in_period_for_category'           => 'Veškeré transakce pro kategorii „:name“ mezi :start a :end',
    'journals_in_period_for_tag'                => 'Veškeré transakce pro štítek :tag mezi :start a :end',
    'not_available_demo_user'                   => 'Funkce, kterou se snažíte použít není uživatelům ukázky k dispozici.',
    'exchange_rate_instructions'                => 'Asset account "@name" only accepts transactions in @primary_currency. If you wish to use @foreign_currency instead, make sure that the amount in @primary_currency is known as well:',
    'transfer_exchange_rate_instructions'       => 'Zdrojový účet aktiv "@source_name" přijímá pouze transakce v @source_currency. Cílový účet aktiv „@dest_name“ přijímá pouze transakce v @dest_currency. V obou měnách musíte uvést převedenou částku správně.',
    'transaction_data'                          => 'Data transakce',
    'invalid_server_configuration'              => 'Neplatné nastavení serveru',
    'invalid_locale_settings'                   => 'Firefly III is unable to format monetary amounts because your server is missing the required packages. There are <a href="https://docs.firefly-iii.org/how-to/firefly-iii/advanced/locales/">instructions how to do this</a>.',
    'quickswitch'                               => 'Rychlé přepnutí',
    'sign_in_to_start'                          => 'Pro zahájení vaší relace se přihlaste',
    'sign_in'                                   => 'Přihlásit',
    'register_new_account'                      => 'Zaregistrovat nový účet',
    'forgot_my_password'                        => 'Zapomněl(a) jsem své heslo',
    'problems_with_input'                       => 'Vyskytly se problémy se vstupními údaji.',
    'reset_password'                            => 'Resetovat své heslo',
    'button_reset_password'                     => 'Resetovat heslo',
    'reset_button'                              => 'Resetovat',
    'want_to_login'                             => 'Chci se přihlásit',
    'login_page_title'                          => 'Přihlášení do Firefly III',
    'register_page_title'                       => 'Registrace do Firefly III',
    'forgot_pw_page_title'                      => 'Zapomenuté heslo do Firefly III',
    'reset_pw_page_title'                       => 'Reset hesla do Firefly III',
    'cannot_reset_demo_user'                    => 'Heslo uživatele pro ukázku (demo) nelze resetovat.',
    'no_att_demo_user'                          => 'Demo uživatel nemůže nahrát přílohy.',
    'button_register'                           => 'Zaregistrovat se',
    'authorization'                             => 'Pověření',
    'active_bills_only'                         => 'pouze aktivní pravidelné platby',
    'active_bills_only_total'                   => 'všechny aktivní pravidelné platby',
    'active_exp_bills_only'                     => 'aktivní a očekávané pravidelné platby',
    'active_exp_bills_only_total'               => 'všechny aktivní očekávané pravidelné platby',
    'per_period_sum_1D'                         => 'Očekávané denní výdaje',
    'per_period_sum_1W'                         => 'Očekávané týdenní výdaje',
    'per_period_sum_1M'                         => 'Očekávané měsíční výdaje',
    'per_period_sum_3M'                         => 'Očekávané čtvrtletní výdaje',
    'per_period_sum_6M'                         => 'Očekávané pololetní výdaje',
    'per_period_sum_1Y'                         => 'Očekávané roční výdaje',
    'average_per_bill'                          => 'average per subscription',
    'expected_total'                            => 'očekávaný celkový součet',
    'reconciliation_account_name'               => ':name sesouhlasení (:currency)',
    'saved'                                     => 'Uloženo',
    'advanced_options'                          => 'Rozšířené možnosti',
    'advanced_options_explain'                  => 'Některé stránky ve Firefly III mají za tímto tlačítkem skryté rozšířené možnosti. Tato stránka zde nemá nic krásného, ale podívejte se na ostatní!',
    'here_be_dragons'                           => 'Hic sunt dracones',
    'bad_date_transaction'                      => 'Firefly III detekuje transakce, které proběhly před rokem 1970. Prosíme, opravte je co nejdříve.',
    'anonymous_warning_on'                      => 'For your privacy, all amounts are now displayed as "zero". Warning: text input boxes may still show the original amounts!',
    'anonymous_warning_off'                     => 'Amounts will be visible again. Please be mindful of your surroundings.',

    // Webhooks
    'webhooks'                                  => 'Webhooky',
    'webhooks_breadcrumb'                       => 'Webhooky',
    'webhooks_menu_disabled'                    => 'zakázáno',
    'no_webhook_messages'                       => 'Neexistují žádné zprávy webhooku',
    'webhook_trigger_ANY'         => 'After any event',
    'webhook_trigger_STORE_TRANSACTION'         => 'Po vytvoření transakce',
    'webhook_trigger_UPDATE_TRANSACTION'        => 'Po aktualizaci transakce',
    'webhook_trigger_DESTROY_TRANSACTION'       => 'Po odstranění transakce',
    'webhook_trigger_STORE_BUDGET'              => 'After budget creation',
    'webhook_trigger_UPDATE_BUDGET'             => 'After budget update',
    'webhook_trigger_DESTROY_BUDGET'            => 'After budget delete',
    'webhook_trigger_STORE_UPDATE_BUDGET_LIMIT' => 'After budgeted amount change',
    'webhook_response_TRANSACTIONS'             => 'Podrobnosti transakce',
    'webhook_response_ACCOUNTS'                 => 'Podrobnosti účtu',
    'webhook_response_BUDGET'                   => 'Budget details',
    'webhook_response_RELEVANT'                 => 'Relevant details',
    'webhook_response_NONE'                     => 'No details',
    'webhook_delivery_JSON'                     => 'JSON',
    'inspect'                                   => 'Prozkoumat',
    'create_new_webhook'                        => 'Vytvořit nový webhook',
    'webhooks_create_breadcrumb'                => 'Vytvořit nový webhook',
    'webhook_trigger_form_help'                 => 'Určit, na kterou událost se spustí webhook',
    'webhook_response_form_help'                => 'Určete, co musí webhook odeslat do URL.',
    'webhook_delivery_form_help'                => 'V jakém formátu musí webhook posílat data.',
    'webhook_active_form_help'                  => 'Webhook musí být aktivní, nebo nebude zavolán.',
    'stored_new_webhook'                        => 'Uložený nový webhook ":title"',
    'delete_webhook'                            => 'Smazat webhook',
    'deleted_webhook'                           => 'Smazán webhook ":title"',
    'edit_webhook'                              => 'Upravit webhook ":title"',
    'updated_webhook'                           => 'Aktualizován webhook ":title"',
    'edit_webhook_js'                           => 'Upravit webhook "{title}"',
    'show_webhook'                              => 'Webhook ":title"',
    'webhook_was_triggered'                     => 'Webhook byl spuštěn na určené transakci. Prosím počkejte, než se objeví výsledky.',
    'webhook_messages'                          => 'Zpráva webhooku',
    'view_message'                              => 'Zobrazit zprávu',
    'view_attempts'                             => 'Zobrazit neúspěšné pokusy',
    'message_content_title'                     => 'Obsah zprávy webhooku',
    'message_content_help'                      => 'Toto je obsah zprávy, která byla odeslána (nebo vyzkoušena) pomocí tohoto webhooku.',
    'attempt_content_title'                     => 'Pokusy webhooku',
    'attempt_content_help'                      => 'To vše jsou neúspěšné pokusy této zpravy webhooku o odeslání na nakonfigurovanou URL. Po nějaké době, Firefly III přestane zkoušet odesílat zprávu.',
    'no_attempts'                               => 'Nebyly nalezeny žádné neúspěšné pokusy. To je dobrá věc!',
    'webhook_attempt_at'                        => 'Pokus v {moment}',
    'logs'                                      => 'Logy',
    'response'                                  => 'Odpověď',
    'visit_webhook_url'                         => 'Navštívit URL webhooku',
    'reset_webhook_secret'                      => 'Restartovat tajný klíč webhooku',
    'webhook_stored_link'                       => '<a href="webhooks/show/{ID}">Webhook #{ID} ("{title}")</a> byl uložen.',
    'webhook_updated_link'                      => '<a href="webhooks/show/{ID}">Webhook #{ID}</a> ("{title}") byl aktualizován.',

    // API access
    'authorization_request'                     => 'Požadavek na ověření – Firefly III verze :version',
    'authorization_request_intro'               => 'Aplikace <strong>:client</strong> žádá oprávnění pro přístup k vaší finanční správě. Chcete autorizovat <strong>:client</strong> pro přístup k těmto záznamům?',
    'authorization_request_site'                => 'Budete přesměrováni na <code>:url</code>, na které pak budete mít přístup k vašim údajům Firefly III.',
    'authorization_request_invalid'             => 'Tento požadavek na přístup je neplatný. Prosím, nikdy nezkoušejte tento odkaz znovu.',
    'scopes_will_be_able'                       => 'Tato aplikace bude moci:',
    'button_authorize'                          => 'Autorizovat',
    'none_in_select_list'                       => '(žádné)',
    'no_piggy_bank'                             => '(žádná pokladnička)',
    'name_in_currency'                          => ':name v :currency',
    'paid_in_currency'                          => 'Zaplaceno v :currency',
    'unpaid_in_currency'                        => 'Nezaplaceno v :currency',
    'is_alpha_warning'                          => 'Používáte ALPHA verzi. Buďte ostražití před chybami a problémy.',
    'is_beta_warning'                           => 'Používáte BETA verzi. Buďte ostražití před chybami a problémy.',
    'all_destination_accounts'                  => 'Cílové účty',
    'all_source_accounts'                       => 'Zdrojové účty',
    'back_to_index'                             => 'Zpět na index',
    'cant_logout_guard'                         => 'Firefly III Vás nemůže odhlásit.',
    'internal_reference'                        => 'Interní odkaz',

    // check for updates:
    'update_check_title'                        => 'Zjistit dostupnost případných aktualizací',
    'admin_update_check_title'                  => 'Zjišťovat dostupnost případných aktualizací automaticky',
    'admin_update_check_explain'                => 'Firefly III může automaticky zjišťovat dostupnost aktualizací. Pokud toto nastavení zapnete, Firefly III kontaktuje aktualizační server a zjistí, zda je k dispozici nová verze Firefly III. Pokud ano, budete na to upozorněni. Fungování tohoto oznámení je možné si vyzkoušet pomocí tlačítka vpravo. Označte níže, zda si přejete, aby Firefly III zjišťovalo dostupnost aktualizací.',
    'check_for_updates_permission'              => 'Firefly III can check for updates, but it needs your permission to do so. Please go to the <a href=":link">settings</a> to indicate if you would like this feature to be enabled.',
    'updates_ask_me_later'                      => 'Zeptat se znovu později',
    'updates_do_not_check'                      => 'Nezjišťovat dostupnost případných aktualizací',
    'updates_enable_check'                      => 'Zjišťovat dostupnost případných aktualizací',
    'admin_update_check_now_title'              => 'Zjistit dostupno případných aktualizací nyní',
    'admin_update_check_now_explain'            => 'Stisknutím tohoto tlačítka Firefly III ověří, zda používáte nejnovější verzi.',
    'check_for_updates_button'                  => 'Zkontrolovat nyní!',
    'update_new_version_alert'                  => 'Je k dispozici nová verze Firefly III. Nyní provozujete verzi :your_version, nejnovější verze je :new_version, která byla vydaná :date.',
    'update_version_beta'                       => 'Tato verze je BETA verze. Můžete narazit na problémy.',
    'update_version_alpha'                      => 'Tato verze je ALFA verze. Můžete narazit na problémy.',
    'update_current_dev_older'                  => 'You are running development release ":version", which is older than the latest release :new_version. Please update!',
    'update_current_dev_newer'                  => 'You are running development release ":version", which is newer than the latest release :new_version.',
    'update_current_version_alert'              => 'Provozujete verzi :version, která je nejnovější dostupnou verzí.',
    'update_newer_version_alert'                => 'Používáte verzi :your_version, která je novější než poslední stabilní verze :new_version.',
    'update_check_error'                        => 'Došlo k chybě při kontrole aktualizací: :error',
    'unknown_error'                             => 'Neznámá chyba. Omlouváme se.',
    'disabled_but_check'                        => 'Zakázali jste kontrolu aktualizací. Nezapomeňte tedy občas zkontrolovat aktualizace sami. Děkujeme!',
    'admin_update_channel_title'                => 'Kanál aktualizací',
    'admin_update_channel_explain'              => 'Firefly III má tři aktualizační "kanály", které určují, jak moc jste napřed, jde-li o funkce, vylepšení a chyby. Použijte "beta" kanál, pokud jste dobrodružný a "alfa", když chcete žít nebezpečně.',
    'update_channel_stable'                     => 'Stabilní. Vše by mělo fungovat podle očekávání.',
    'update_channel_beta'                       => 'Beta verze. Jsou zde nové funkce, ale nemusí vše fungovat.',
    'update_channel_alpha'                      => 'Alfa. Míchame všechno dohromady a používáme vše, co se osvědčí.',

    // search
    'search'                                    => 'Hledat',
    'search_query'                              => 'Dotaz',
    'search_found_transactions'                 => 'Firefly III nalezl :count transakci během :time sekund.|Firefly III nalezl :count transakcí během :time sekund.',
    'search_found_more_transactions'            => 'Firefly III nalezlo vice než :count transakcí za :time sekund.',
    'search_for_overview'                       => 'Firefly III hledá transakce které splňují <b>všechny</b> z následujících podmínek:',
    'search_for_query'                          => 'Všechna tato slova musí být obsažena: <span class="text-info">:query</span>',
    'search_for_excluded_words'                 => 'Žádné z těchto slov nesmí být obsaženo: <span class="text-info">:excluded_words</span>',
    'invalid_operators_list'                    => 'Tyto vyhledávací parametry nejsou platné a byly ignorovány.',

    // old


    'search_modifier_date_on'                             => 'Datum transakce je ":value"',
    'search_modifier_not_date_on'                         => 'Datum transakce není ":value"',
    'search_modifier_reconciled'                          => 'Transakce je odsouhlasena',
    'search_modifier_not_reconciled'                      => 'Transaction is not reconciled',
    'search_modifier_id'                                  => 'Číslo transakce je „:value“',
    'search_modifier_not_id'                              => 'ID transakce není ":value"',
    'search_modifier_date_before'                         => 'Datum transakce je před (včetně) ":value"',
    'search_modifier_date_after'                          => 'Datum transakce je po (včetně) ":value"',
    'search_modifier_external_id_is'                      => 'Externí ID je ":value"',
    'search_modifier_not_external_id_is'                  => 'Externí ID není ":value"',
    'search_modifier_no_external_url'                     => 'Transakce nemá žádnou externí URL',
    'search_modifier_no_external_id'                      => 'Transakce nemá žádnou externí ID',
    'search_modifier_not_any_external_url'                => 'Transakce nemá žádnou externí URL',
    'search_modifier_not_any_external_id'                 => 'Transakce nemá žádnou externí ID',
    'search_modifier_any_external_url'                    => 'Transakce musí mít (libovolnou) externí URL',
    'search_modifier_any_external_id'                     => 'Transakce musí mít (libovolnou) externí ID',
    'search_modifier_not_no_external_url'                 => 'Transakce musí mít (libovolnou) externí URL',
    'search_modifier_not_no_external_id'                  => 'Transakce musí mít (libovolnou) externí ID',
    'search_modifier_internal_reference_is'               => 'Interní reference je ":value"',
    'search_modifier_not_internal_reference_is'           => 'Interní reference není ":value"',
    'search_modifier_description_starts'                  => 'Popis začíná na ":value"',
    'search_modifier_not_description_starts'              => 'Popis nezačíná na ":value"',
    'search_modifier_description_ends'                    => 'Popis končí na ":value"',
    'search_modifier_not_description_ends'                => 'Popis nekončí na ":value"',
    'search_modifier_description_contains'                => 'Popis obsahuje ":value"',
    'search_modifier_not_description_contains'            => 'Popis neobsahuje ":value"',
    'search_modifier_description_is'                      => 'Popis je přesně ":value"',
    'search_modifier_not_description_is'                  => 'Popis není přesně ":value"',
    'search_modifier_currency_is'                         => '(Zahraniční) měna transakce je ":value"',
    'search_modifier_not_currency_is'                     => '(Zahraniční) měna transakce není ":value"',
    'search_modifier_foreign_currency_is'                 => 'Zahraniční měna transakce je ":value"',
    'search_modifier_not_foreign_currency_is'             => 'Zahraniční měna transakce není ":value"',
    'search_modifier_has_attachments'                     => 'Transakce musí mít přílohu',
    'search_modifier_has_no_category'                     => 'Transakce nesmí mít žádnou kategorii',
    'search_modifier_not_has_no_category'                 => 'Transakce musí mít (libovolnou) kategorii',
    'search_modifier_not_has_any_category'                => 'Transakce nesmí mít žádnou kategorii',
    'search_modifier_has_any_category'                    => 'Transakce musí mít (libovolnou) kategorii',
    'search_modifier_has_no_budget'                       => 'Transakce nesmí mít žádný rozpočet',
    'search_modifier_not_has_any_budget'                  => 'Transakce nesmí mít žádný rozpočet',
    'search_modifier_has_any_budget'                      => 'Transakce musí mít (libovolný) rozpočet',
    'search_modifier_not_has_no_budget'                   => 'Transakce musí mít (libovolný) rozpočet',
    'search_modifier_has_no_bill'                         => 'The transaction must have no subscription',
    'search_modifier_not_has_no_bill'                     => 'The transaction must have a (any) subscription',
    'search_modifier_has_any_bill'                        => 'The transaction must have a (any) subscription',
    'search_modifier_not_has_any_bill'                    => 'The transaction must have no subscription',
    'search_modifier_has_no_tag'                          => 'Transakce nesmí mít žádné štítky',
    'search_modifier_not_has_any_tag'                     => 'Transakce nesmí mít žádné štítky',
    'search_modifier_not_has_no_tag'                      => 'Transakce musí mít (libovolný) štítek',
    'search_modifier_has_any_tag'                         => 'Transakce musí mít (libovolný) štítek',
    'search_modifier_notes_contains'                      => 'Poznámky k transakci obsahují ":value"',
    'search_modifier_not_notes_contains'                  => 'Poznámky k transakci neobsahují ":value"',
    'search_modifier_notes_starts'                        => 'Poznámky k transakci začínají na ":value"',
    'search_modifier_not_notes_starts'                    => 'Poznámky k transakci nezačínají na ":value"',
    'search_modifier_notes_ends'                          => 'Poznámky k transakci končí na ":value"',
    'search_modifier_not_notes_ends'                      => 'Poznámky k transakci nekončí na ":value"',
    'search_modifier_notes_is'                            => 'Poznámky k transakci jsou přesně ":value"',
    'search_modifier_not_notes_is'                        => 'Poznámky k transakci nejsou přesně ":value"',
    'search_modifier_no_notes'                            => 'Transakce nemá žádné poznámky',
    'search_modifier_not_no_notes'                        => 'Transakce musí mít poznámky',
    'search_modifier_any_notes'                           => 'Transakce musí mít poznámky',
    'search_modifier_not_any_notes'                       => 'Transakce nemá žádné poznámky',
    'search_modifier_amount_is'                           => 'Částka je přesně :value',
    'search_modifier_not_amount_is'                       => 'Částka není přesně :value',
    'search_modifier_amount_less'                         => 'Částka je menší nebo rovna :value',
    'search_modifier_not_amount_more'                     => 'Částka je menší nebo rovna :value',
    'search_modifier_amount_more'                         => 'Částka je větší nebo rovna :value',
    'search_modifier_not_amount_less'                     => 'Částka je větší nebo rovna :value',
    'search_modifier_source_account_is'                   => 'Název zdrojového účtu je přesně ":value"',
    'search_modifier_not_source_account_is'               => 'Název zdrojového účtu není ":value"',
    'search_modifier_source_account_contains'             => 'Název zdrojového účtu obsahuje ":value"',
    'search_modifier_not_source_account_contains'         => 'Název zdrojového účtu neobsahuje ":value"',
    'search_modifier_source_account_starts'               => 'Název zdrojového účtu začíná na ":value"',
    'search_modifier_not_source_account_starts'           => 'Název zdrojového účtu nezačíná na ":value"',
    'search_modifier_source_account_ends'                 => 'Název zdrojového účtu končí na ":value"',
    'search_modifier_not_source_account_ends'             => 'Název zdrojového účtu nekončí na ":value"',
    'search_modifier_source_account_id'                   => 'ID zdrojového účtu je :value',
    'search_modifier_not_source_account_id'               => 'ID zdrojového účtu není :value',
    'search_modifier_source_account_nr_is'                => 'Číslo zdrojového účtu (IBAN) je ":value"',
    'search_modifier_not_source_account_nr_is'            => 'Číslo zdrojového účtu (IBAN) není ":value"',
    'search_modifier_source_account_nr_contains'          => 'Číslo zdrojového účtu (IBAN) obsahuje ":value"',
    'search_modifier_not_source_account_nr_contains'      => 'Číslo zdrojového účtu (IBAN) neobsahuje ":value"',
    'search_modifier_source_account_nr_starts'            => 'Číslo zdrojového účtu (IBAN) začíná na ":value"',
    'search_modifier_not_source_account_nr_starts'        => 'Číslo zdrojového účtu (IBAN) nezačíná na ":value"',
    'search_modifier_source_account_nr_ends'              => 'Číslo zdrojového účtu (IBAN) končí na ":value"',
    'search_modifier_not_source_account_nr_ends'          => 'Číslo zdrojového účtu (IBAN) nekončí na ":value"',
    'search_modifier_destination_account_is'              => 'Název cílového účtu je přesně ":value"',
    'search_modifier_not_destination_account_is'          => 'Název cílového účtu není ":value"',
    'search_modifier_destination_account_contains'        => 'Název cílového účtu obsahuje ":value"',
    'search_modifier_not_destination_account_contains'    => 'Název cílového účtu neobsahuje ":value"',
    'search_modifier_destination_account_starts'          => 'Název cílového účtu začíná na ":value"',
    'search_modifier_not_destination_account_starts'      => 'Název cílového účtu nezačíná na ":value"',
    'search_modifier_destination_account_ends'            => 'Název cílového účtu končí na ":value"',
    'search_modifier_not_destination_account_ends'        => 'Název cílového účtu nekončí na ":value"',
    'search_modifier_destination_account_id'              => 'ID cílového účtu je :value',
    'search_modifier_not_destination_account_id'          => 'ID cílového účtu není :value',
    'search_modifier_destination_is_cash'                 => 'Cílový účet je (hotovostní) účet',
    'search_modifier_not_destination_is_cash'             => 'Cílový účet není (hotovostní) účet',
    'search_modifier_source_is_cash'                      => 'Zdrojový účet je (hotovostní) účet',
    'search_modifier_not_source_is_cash'                  => 'Zdrojový účet není (hotovostní) účet',
    'search_modifier_destination_account_nr_is'           => 'ČÍslo cílového účtu (IBAN) je ":value"',
    'search_modifier_not_destination_account_nr_is'       => 'Číslo cílového účtu (IBAN) je ":value"',
    'search_modifier_destination_account_nr_contains'     => 'Číslo cílového účtu (IBAN) obsahuje ":value"',
    'search_modifier_not_destination_account_nr_contains' => 'Číslo cílového účtu (IBAN) neobsahuje ":value"',
    'search_modifier_destination_account_nr_starts'       => 'Číslo cílového účtu (IBAN) začíná na ":value"',
    'search_modifier_not_destination_account_nr_starts'   => 'Číslo cílového účtu (IBAN) nezačíná na ":value"',
    'search_modifier_destination_account_nr_ends'         => 'Číslo cílového účtu (IBAN) končí na ":value"',
    'search_modifier_not_destination_account_nr_ends'     => 'Číslo cílového účtu (IBAN) nekončí na ":value"',
    'search_modifier_account_id'                          => 'ID zdrojového nebo cílového účtu je/jsou: :value',
    'search_modifier_not_account_id'                      => 'ID zdrojového nebo cílového účtu není/nejsou: :value',
    'search_modifier_category_is'                         => 'Kategorie je „:value“',
    'search_modifier_not_category_is'                     => 'Kategorie není „:value“',
    'search_modifier_budget_is'                           => 'Rozpočet je „:value“',
    'search_modifier_not_budget_is'                       => 'Rozpočet není „:value“',
    'search_modifier_bill_is'                             => 'Subscription is ":value"',
    'search_modifier_not_bill_is'                         => 'Subscription is not ":value"',
    'search_modifier_transaction_type'                    => 'Typ transakce je ":value"',
    'search_modifier_not_transaction_type'                => 'Typ transakce není ":value"',
    'search_modifier_tag_is'                              => 'Štítek je ":value“',
    'search_modifier_tag_contains'                        => 'Štítek obsahuje ":value"',
    'search_modifier_not_tag_contains'                    => 'Štítek neobsahuje ":value"',
    'search_modifier_tag_ends'                            => 'Štítek končí na ":value"',
    'search_modifier_tag_starts'                          => 'Štítek začíná na ":value"',
    'search_modifier_not_tag_is'                          => 'Žádný štítek není ":value"',
    'search_modifier_date_on_year'                        => 'Transakce je v roce ":value"',
    'search_modifier_not_date_on_year'                    => 'Transakce není v roce ":value"',
    'search_modifier_date_on_month'                       => 'Transakce je v měsíci ":value"',
    'search_modifier_not_date_on_month'                   => 'Transakce není v měsíci ":value"',
    'search_modifier_date_on_day'                         => 'Transakce je v :value. dni měsíce',
    'search_modifier_not_date_on_day'                     => 'Transakce není v :value. dni měsíce',
    'search_modifier_date_before_year'                    => 'Transakce je před nebo v roce ":value"',
    'search_modifier_date_before_month'                   => 'Transakce je před nebo v měsíci ":value"',
    'search_modifier_date_before_day'                     => 'Transakce je před nebo v :value. dni měsíce',
    'search_modifier_date_after_year'                     => 'Transakce je v roce nebo po roce ":value"',
    'search_modifier_date_after_month'                    => 'Transakce je v měsící nebo po měsíci ":value"',
    'search_modifier_date_after_day'                      => 'Transakce je po nebo v :value. dni měsíce',

    // new
    'search_modifier_tag_is_not'                          => 'Žádný štítek není ":value"',
    'search_modifier_not_tag_is_not'                      => 'Štítek je ":value“',
    'search_modifier_account_is'                          => 'Alespoň jeden účet je ":value"',
    'search_modifier_not_account_is'                      => 'Ani jeden účet není ":value"',
    'search_modifier_account_contains'                    => 'Alespoň jeden účet obsahuje ":value"',
    'search_modifier_not_account_contains'                => 'Ani jeden účet neobsahuje ":value"',
    'search_modifier_account_ends'                        => 'Alespoň jeden účet končí na ":value"',
    'search_modifier_not_account_ends'                    => 'Ani jeden účet nekončí na ":value"',
    'search_modifier_account_starts'                      => 'Alespoň jeden účet začíná na ":value"',
    'search_modifier_not_account_starts'                  => 'Ani jeden účet nezačíná na ":value"',
    'search_modifier_account_nr_is'                       => 'Alespoň jedno číslo účtu / IBAN je ":value"',
    'search_modifier_not_account_nr_is'                   => 'Ani jedno číslo účtu / IBAN není ":value"',
    'search_modifier_account_nr_contains'                 => 'Alespoň jedno číslo účtu / IBAN obsahuje ":value"',
    'search_modifier_not_account_nr_contains'             => 'Ani jedno číslo účtu / IBAN neobsahuje ":value"',
    'search_modifier_account_nr_ends'                     => 'Alespoň jedno číslo účtu / IBAN končí na ":value"',
    'search_modifier_not_account_nr_ends'                 => 'Ani jedno číslo účtu / IBAN nekončí na ":value"',
    'search_modifier_account_nr_starts'                   => 'Alespoň jedno číslo účtu / IBAN začíná na ":value"',
    'search_modifier_not_account_nr_starts'               => 'Ani jedno číslo účtu / IBAN nezačíná na ":value"',
    'search_modifier_category_contains'                   => 'Kategorie obsahuje ":value"',
    'search_modifier_not_category_contains'               => 'Kategorie neobsahuje ":value"',
    'search_modifier_category_ends'                       => 'Kategorie končí na ":value"',
    'search_modifier_not_category_ends'                   => 'Kategorie nekončí na ":value"',
    'search_modifier_category_starts'                     => 'Kategorie začíná na ":value"',
    'search_modifier_not_category_starts'                 => 'Kategorie nezačíná na ":value"',
    'search_modifier_budget_contains'                     => 'Rozpočet obsahuje ":value"',
    'search_modifier_not_budget_contains'                 => 'Rozpočet neobsahuje ":value"',
    'search_modifier_budget_ends'                         => 'Rozpočet končí na ":value"',
    'search_modifier_not_budget_ends'                     => 'Rozpočet nekončí na ":value"',
    'search_modifier_budget_starts'                       => 'Rozpočet začíná na ":value"',
    'search_modifier_not_budget_starts'                   => 'Rozpočet nezačíná na ":value"',
    'search_modifier_bill_contains'                       => 'Subscription contains ":value"',
    'search_modifier_not_bill_contains'                   => 'Subscription does not contain ":value"',
    'search_modifier_bill_ends'                           => 'Subscription ends with ":value"',
    'search_modifier_not_bill_ends'                       => 'Subscription does not end on ":value"',
    'search_modifier_bill_starts'                         => 'Subscription starts with ":value"',
    'search_modifier_not_bill_starts'                     => 'Subscription does not start with ":value"',
    'search_modifier_external_id_contains'                => 'Externí ID obsahuje ":value"',
    'search_modifier_not_external_id_contains'            => 'Externí ID neobsahuje ":value"',
    'search_modifier_external_id_ends'                    => 'Externí ID končí na ":value"',
    'search_modifier_not_external_id_ends'                => 'Externí ID nekončí na ":value"',
    'search_modifier_external_id_starts'                  => 'Externí ID začíná na ":value"',
    'search_modifier_not_external_id_starts'              => 'Externí ID nezačíná na ":value"',
    'search_modifier_internal_reference_contains'         => 'Interní reference obsahuje ":value"',
    'search_modifier_not_internal_reference_contains'     => 'Interní reference neobsahuje ":value"',
    'search_modifier_internal_reference_ends'             => 'Interní reference končí na ":value"',
    'search_modifier_internal_reference_starts'           => 'Interní reference začíná na ":value"',
    'search_modifier_not_internal_reference_ends'         => 'Interní reference nekončí na ":value"',
    'search_modifier_not_internal_reference_starts'       => 'Interní reference nezačíná na ":value"',
    'search_modifier_external_url_is'                     => 'Externí URL je ":value"',
    'search_modifier_not_external_url_is'                 => 'Externí URL není ":value"',
    'search_modifier_external_url_contains'               => 'Externí URL obsahuje ":value"',
    'search_modifier_not_external_url_contains'           => 'Externí URL neobsahuje ":value"',
    'search_modifier_external_url_ends'                   => 'Externí URL končí na ":value"',
    'search_modifier_not_external_url_ends'               => 'Externí URL nekončí na ":value"',
    'search_modifier_external_url_starts'                 => 'Externí URL začíná na ":value"',
    'search_modifier_not_external_url_starts'             => 'Externí URL nezačíná na ":value"',
    'search_modifier_has_no_attachments'                  => 'Transakce nemá žádné přílohy',
    'search_modifier_not_has_no_attachments'              => 'Transakce má přílohy',
    'search_modifier_not_has_attachments'                 => 'Transakce nemá žádné přílohy',
    'search_modifier_account_is_cash'                     => 'Alespoň jeden účet je hotovostní.',
    'search_modifier_not_account_is_cash'                 => 'Ani jeden účet není hotovostní účet.',
    'search_modifier_journal_id'                          => 'The journal ID is ":value"',
    'search_modifier_not_journal_id'                      => 'The journal ID is not ":value"',
    'search_modifier_recurrence_id'                       => 'ID opakované transakce je ":value"',
    'search_modifier_not_recurrence_id'                   => 'ID opakované transakce není ":value"',
    'search_modifier_foreign_amount_is'                   => 'Zahraniční částka je ":value"',
    'search_modifier_not_foreign_amount_is'               => 'Zahraniční částka není ":value"',
    'search_modifier_foreign_amount_less'                 => 'Zahraniční částka je menší než ":value"',
    'search_modifier_not_foreign_amount_more'             => 'Zahraniční částka je menší než ":value"',
    'search_modifier_not_foreign_amount_less'             => 'Zahraniční částka je vyšší než ":value"',
    'search_modifier_foreign_amount_more'                 => 'Zahraniční částka je vyšší než ":value"',
    'search_modifier_exists'                              => 'Transakce existuje (jakákoli transakce)',
    'search_modifier_not_exists'                          => 'Transakce neexistuje (žádná transakce)',

    // date fields
    'search_modifier_interest_date_on'                    => 'Datum zúročení transakce je ":value"',
    'search_modifier_not_interest_date_on'                => 'Datum zúročení transakce není ":value"',
    'search_modifier_interest_date_on_year'               => 'Transaction interest date is in year ":value"',
    'search_modifier_not_interest_date_on_year'           => 'Transaction interest date is not in year ":value"',
    'search_modifier_interest_date_on_month'              => 'Transaction interest date is in month ":value"',
    'search_modifier_not_interest_date_on_month'          => 'Transaction interest date is not in month ":value"',
    'search_modifier_interest_date_on_day'                => 'Transaction interest date is on day of month ":value"',
    'search_modifier_not_interest_date_on_day'            => 'Transaction interest date is not on day of month ":value"',
    'search_modifier_interest_date_before_year'           => 'Transaction interest date is before or in year ":value"',
    'search_modifier_interest_date_before_month'          => 'Transaction interest date is before or in month ":value"',
    'search_modifier_interest_date_before_day'            => 'Transaction interest date is before or on day of month ":value"',
    'search_modifier_interest_date_after_year'            => 'Transaction interest date is after or in year ":value"',
    'search_modifier_interest_date_after_month'           => 'Transaction interest date is after or in month ":value"',
    'search_modifier_interest_date_after_day'             => 'Transaction interest date is after or on day of month ":value"',
    'search_modifier_book_date_on_year'                   => 'Datum rezervace transakce je v roce ":value"',
    'search_modifier_book_date_on_month'                  => 'Datum rezervace transakce je v měsíci ":value"',
    'search_modifier_book_date_on_day'                    => 'Datum rezervace transakce je v ":value" dni v měsíci',
    'search_modifier_not_book_date_on_year'               => 'Datum rezervace transakce není v roce ":value"',
    'search_modifier_not_book_date_on_month'              => 'Datum rezervace transakce není v měsíci ":value"',
    'search_modifier_not_book_date_on_day'                => 'Datum rezervace transakce není v ":value" dni v měsíci',
    'search_modifier_book_date_before_year'               => 'Datum rezervace transakce je nejpozději v roce ":value"',
    'search_modifier_book_date_before_month'              => 'Datum rezervace transakce je nejpozději v měsíci ":value"',
    'search_modifier_book_date_before_day'                => 'Datum rezervace transakce nejpozději v ":value" dni v měsíci',
    'search_modifier_book_date_after_year'                => 'Datum rezervace transakce je nejdříve v roce ":value"',
    'search_modifier_book_date_after_month'               => 'Datum rezervace transakce je nejdříve v měsíci ":value"',
    'search_modifier_book_date_after_day'                 => 'Datum rezervace transakce je nejdříve v ":value" dni v měsíci',
    'search_modifier_process_date_on_year'                => 'Transaction process date is in year ":value"',
    'search_modifier_process_date_on_month'               => 'Transaction process date is in month ":value"',
    'search_modifier_process_date_on_day'                 => 'Transaction process date is on day of month ":value"',
    'search_modifier_not_process_date_on_year'            => 'Transaction process date is not in year ":value"',
    'search_modifier_not_process_date_on_month'           => 'Transaction process date is not in month ":value"',
    'search_modifier_not_process_date_on_day'             => 'Transaction process date is not on day of month ":value"',
    'search_modifier_process_date_before_year'            => 'Transaction process date is before or in year ":value"',
    'search_modifier_process_date_before_month'           => 'Transaction process date is before or in month ":value"',
    'search_modifier_process_date_before_day'             => 'Transaction process date is before or on day of month ":value"',
    'search_modifier_process_date_after_year'             => 'Transaction process date is after or in year ":value"',
    'search_modifier_process_date_after_month'            => 'Transaction process date is after or in month ":value"',
    'search_modifier_process_date_after_day'              => 'Transaction process date is after or on day of month ":value"',
    'search_modifier_due_date_on_year'                    => 'Datum splatnosti transakce je v roce ":value"',
    'search_modifier_due_date_on_month'                   => 'Datum splatnosti transakce je v měsíci ":value"',
    'search_modifier_due_date_on_day'                     => 'Datum splatnosti transakce je v ":value". dni měsíce',
    'search_modifier_not_due_date_on_year'                => 'Datum splatnosti transakce není v roce ":value"',
    'search_modifier_not_due_date_on_month'               => 'Datum splatnosti transakce není v měsíci ":value"',
    'search_modifier_not_due_date_on_day'                 => 'Datum splatnosti transakce není v ":value". dni měsíce',
    'search_modifier_due_date_before_year'                => 'Datum splatnosti transakce je před nebo v roce ":value"',
    'search_modifier_due_date_before_month'               => 'Datum splatnosti transakce je před nebo v měsíci ":value"',
    'search_modifier_due_date_before_day'                 => 'Datum splatnosti transakce je před nebo v ":value". dni měsíce',
    'search_modifier_due_date_after_year'                 => 'Datum splatnosti transakce je po nebo v roce ":value"',
    'search_modifier_due_date_after_month'                => 'Datum splatnosti transakce je po nebo v měsíci ":value"',
    'search_modifier_due_date_after_day'                  => 'Datum splatnosti transakce je po nebo v ":value". dni měsíce',
    'search_modifier_payment_date_on_year'                => 'Datum platby transakce je v roce ":value"',
    'search_modifier_payment_date_on_month'               => 'Datum platby transakce je v měsíci ":value"',
    'search_modifier_payment_date_on_day'                 => 'Datum platby transakce je v ":value". dni měsíce',
    'search_modifier_not_payment_date_on_year'            => 'Datum platby transakce není v roce ":value"',
    'search_modifier_not_payment_date_on_month'           => 'Datum platby transakce není v měsíci ":value"',
    'search_modifier_not_payment_date_on_day'             => 'Datum platby transakce není v ":value". den měsíce',
    'search_modifier_payment_date_before_year'            => 'Datum platby transakce je před nebo v roce ":value"',
    'search_modifier_payment_date_before_month'           => 'Datum platby transakce je před nebo v měsíci ":value"',
    'search_modifier_payment_date_before_day'             => 'Datum platby transakce je před nebo v ":value". dni měsíce',
    'search_modifier_payment_date_after_year'             => 'Datum platby transakce je po nebo v roce ":value"',
    'search_modifier_payment_date_after_month'            => 'Datum platby transakce je po nebo v měsíci ":value"',
    'search_modifier_payment_date_after_day'              => 'Datum platby transakce je po nebo v ":value". dni měsíce',
    'search_modifier_invoice_date_on_year'                => 'Datum vystavení faktury transakce je v roce ":value"',
    'search_modifier_invoice_date_on_month'               => 'Datum vystavení faktury transakce je v měsíci ":value"',
    'search_modifier_invoice_date_on_day'                 => 'Datum vystavení faktury transakce je v ":value". dni měsíce',
    'search_modifier_not_invoice_date_on_year'            => 'Datum vystavení faktury transakce není v roce ":value"',
    'search_modifier_not_invoice_date_on_month'           => 'Datum vystavení faktury transakce není v měsíci ":value"',
    'search_modifier_not_invoice_date_on_day'             => 'Datum vystavení faktury transakce není v ":value". dni měsíce',
    'search_modifier_invoice_date_before_year'            => 'Datum vystavení faktury transakce je před nebo v roce ":value"',
    'search_modifier_invoice_date_before_month'           => 'Datum vystavení faktury transakce je před nebo v měsíci ":value"',
    'search_modifier_invoice_date_before_day'             => 'Datum vystavení faktury transakce je před nebo v ":value". dni měsíce',
    'search_modifier_invoice_date_after_year'             => 'Datum vystavení faktury transakce je po nebo v roce ":value"',
    'search_modifier_invoice_date_after_month'            => 'Datum vystavení faktury transakce je po nebo v měsíci ":value"',
    'search_modifier_invoice_date_after_day'              => 'Datum vystavení faktury transakce je po nebo v ":value". dni měsíce',
    // other dates
    'search_modifier_updated_at_on_year'                  => 'Transakce byla naposledy aktualizována v roce ":value"',
    'search_modifier_updated_at_on_month'                 => 'Transakce byla naposledy aktualizována v měsíci ":value"',
    'search_modifier_updated_at_on_day'                   => 'Transakce byla naposledy aktualizována v ":value". dni měsíce',
    'search_modifier_not_updated_at_on_year'              => 'Transakce nebyla naposledy aktualizována v roce ":value"',
    'search_modifier_not_updated_at_on_month'             => 'Transakce nebyla naposledy aktualizována v měsíci ":value"',
    'search_modifier_not_updated_at_on_day'               => 'Transakce nebyla naposledy aktualizována v ":value". dni měsíce',
    'search_modifier_updated_at_before_year'              => 'Transakce byla naposledy aktualizována v roce nebo před rokem ":value"',
    'search_modifier_updated_at_before_month'             => 'Transakce byla naposledy aktualizována v měsíci nebo dříve ":value"',
    'search_modifier_updated_at_before_day'               => 'Transakce byla naposledy aktualizována před nebo v ":value". dni měsíce',
    'search_modifier_updated_at_after_year'               => 'Transakce byla naposledy aktualizována v roce nebo po roce ":value"',
    'search_modifier_updated_at_after_month'              => 'Transakce byla naposledy aktualizována v měsíci nebo po měsíci ":value"',
    'search_modifier_updated_at_after_day'                => 'Transakce byla naposledy aktualizována po nebo v ":value". dni měsíce',
    'search_modifier_created_at_on_year'                  => 'Transakce byla vytvořena v roce ":value"',
    'search_modifier_created_at_on_month'                 => 'Transakce byla vytvořena v měsíci ":value"',
    'search_modifier_created_at_on_day'                   => 'Transakce byla vytvořena ":value" dne v měsíci',
    'search_modifier_not_created_at_on_year'              => 'Transakce nebyla vytvořena v roce ":value"',
    'search_modifier_not_created_at_on_month'             => 'Transakce nebyla vytvořena v měsíci ":value"',
    'search_modifier_not_created_at_on_day'               => 'Transakce nebyla vytvořena ":value" dne v měsíci',
    'search_modifier_created_at_before_year'              => 'Transakce byla vytvořena nejpozději v roce ":value"',
    'search_modifier_created_at_before_month'             => 'Transakce byla vytvořena nejpozději v měsíci ":value"',
    'search_modifier_created_at_before_day'               => 'Transakce byla vytvořena nejpozději v ":value" dne v měsíci',
    'search_modifier_created_at_after_year'               => 'Transakce byla vytvořena v roce nebo po roce ":value"',
    'search_modifier_created_at_after_month'              => 'Transakce byla vytvořena v měsíci nebo po měsíci ":value"',
    'search_modifier_created_at_after_day'                => 'Transakce byla vytvořena v nebo po :value. dni měsíce',
    'search_modifier_interest_date_before'                => 'Datum zúročení je v nebo před ":value"',
    'search_modifier_interest_date_after'                 => 'Datum zúročení transakce je v nebo po ":value"',
    'search_modifier_book_date_on'                        => 'Datum rezervace transakce je ":value"',
    'search_modifier_not_book_date_on'                    => 'Datum rezervace transakce není ":value"',
    'search_modifier_book_date_before'                    => 'Datum rezervace transakce je nejpozději ":value"',
    'search_modifier_book_date_after'                     => 'Datum rezervace transakce je nejdříve ":value"',
    'search_modifier_process_date_on'                     => 'Transaction process date is on ":value"',
    'search_modifier_not_process_date_on'                 => 'Transaction process date is not on ":value"',
    'search_modifier_process_date_before'                 => 'Transaction process date is on or before ":value"',
    'search_modifier_process_date_after'                  => 'Transaction process date is on or after ":value"',
    'search_modifier_due_date_on'                         => 'Datum splatnosti transakce je ":value"',
    'search_modifier_not_due_date_on'                     => 'Datum splatnosti transakce není v ":value"',
    'search_modifier_due_date_before'                     => 'Datum splatnosti transakce je nejpozději ":value"',
    'search_modifier_due_date_after'                      => 'Datum splatnosti transakce je nejdříve ":value"',
    'search_modifier_payment_date_on'                     => 'Transaction payment date is on ":value"',
    'search_modifier_not_payment_date_on'                 => 'Transaction payment date is not on ":value"',
    'search_modifier_payment_date_before'                 => 'Transaction payment date is on or before ":value"',
    'search_modifier_payment_date_after'                  => 'Transaction payment date is on or after ":value"',
    'search_modifier_invoice_date_on'                     => 'Transaction invoice date is on ":value"',
    'search_modifier_not_invoice_date_on'                 => 'Transaction invoice date is not on ":value"',
    'search_modifier_invoice_date_before'                 => 'Transaction invoice date is on or before ":value"',
    'search_modifier_invoice_date_after'                  => 'Transaction invoice date is on or after ":value"',
    'search_modifier_created_at_on'                       => 'Transakce byla vytvořena ":value"',
    'search_modifier_not_created_at_on'                   => 'Transakce nebyla vytvořena ":value"',
    'search_modifier_created_at_before'                   => 'Transakce byla vytvořena nejpozději ":value"',
    'search_modifier_created_at_after'                    => 'Transakce byla vytvořena nejdříve ":value"',
    'search_modifier_updated_at_on'                       => 'Transakce byla upravena ":value"',
    'search_modifier_not_updated_at_on'                   => 'Transakce nebyla upravena ":value"',
    'search_modifier_updated_at_before'                   => 'Transakce byla upravena nejpozději ":value"',
    'search_modifier_updated_at_after'                    => 'Transakce byla upravena nejdříve ":value"',

    'search_modifier_attachment_name_is'            => 'Název přílohy je ":value"',
    'search_modifier_attachment_name_contains'      => 'Název přílohy obsahuje ":value"',
    'search_modifier_attachment_name_starts'        => 'Název přílohy začíná na ":value"',
    'search_modifier_attachment_name_ends'          => 'Název přílohy končí na ":value"',
    'search_modifier_attachment_notes_are'          => 'Poznámka přílohy je ":value"',
    'search_modifier_attachment_notes_contains'     => 'Poznámka přílohy obsahuje ":value"',
    'search_modifier_attachment_notes_starts'       => 'Poznámka přílohy začíná na ":value"',
    'search_modifier_attachment_notes_ends'         => 'Poznámka přílohy končí na ":value"',
    'search_modifier_not_attachment_name_is'        => 'Poznámka přílohy není ":value"',
    'search_modifier_not_attachment_name_contains'  => 'Poznámka přílohy neobsahuje ":value"',
    'search_modifier_not_attachment_name_starts'    => 'Název přílohy nezačíná na ":value"',
    'search_modifier_not_attachment_name_ends'      => 'Název přílohy nekončí na ":value“',
    'search_modifier_not_attachment_notes_are'      => 'Poznámka přílohy není ":value"',
    'search_modifier_not_attachment_notes_contains' => 'Poznámka přílohy neobsahuje ":value"',
    'search_modifier_not_attachment_notes_starts'   => 'Poznámka přílohy začíná na ":value"',
    'search_modifier_not_attachment_notes_ends'     => 'Poznámka přílohy nekončí na ":value"',
    'search_modifier_sepa_ct_is'                    => 'SEPA CT is ":value"',
    'update_rule_from_query'                        => 'Update rule ":rule" from search query',
    'create_rule_from_query'                        => 'Create new rule from search query',
    'rule_from_search_words'                        => 'The rule engine has a hard time handling ":string". The suggested rule that fits your search query may give different results. Please verify the rule triggers carefully.',

    // more new stuff
    'search_modifier_destination_balance_is'        => 'Zůstatek cílového účtu je ":value"',
    'search_modifier_not_destination_balance_is'    => 'Zůstatek cílového účtu není ":value"',
    'search_modifier_source_balance_is'             => 'Source account balance is exactly ":value"',
    'search_modifier_not_source_balance_is'         => 'Source account balance is NOT exactly ":value"',

    'search_modifier_destination_balance_lte'     => 'Zůstatek cílového účtu je nejvýše ":value"',
    'search_modifier_not_destination_balance_lte' => 'Zůstatek cílového účtu je více než ":value"',
    'search_modifier_source_balance_lte'          => 'Source account balance is less than or equal to ":value"',
    'search_modifier_not_source_balance_lte'      => 'Source account balance is more than ":value"',

    'search_modifier_destination_balance_lt'     => 'Zůstatek cílového účtu je méně než ":value"',
    'search_modifier_not_destination_balance_lt' => 'Zůstatek cílového účtu je nejméně ":value"',
    'search_modifier_source_balance_lt'          => 'Source account balance is less than ":value"',
    'search_modifier_not_source_balance_lt'      => 'Source account balance is more than or equal to ":value"',

    'search_modifier_destination_balance_gte'     => 'Zůstatek cílového účtu je nejméně ":value"',
    'search_modifier_not_destination_balance_gte' => 'Zůstatek cílového účtu je méně než ":value"',
    'search_modifier_source_balance_gte'          => 'Source account balance is more than or equal to ":value"',
    'search_modifier_not_source_balance_gte'      => 'Source account balance is less than ":value"',

    'search_modifier_destination_balance_gt'              => 'Zůstatek cílového účtu je více než ":value"',
    'search_modifier_not_destination_balance_gt'          => 'Zůstatek cílového účtu je nejvíce ":value"',
    'search_modifier_source_balance_gt'                   => 'Source account balance is more than ":value"',
    'search_modifier_not_source_balance_gt'               => 'Source account balance is less than or equal to ":value"',


    // END
    'general_search_error'                                => 'An error occurred while searching. Please check the log files for more information.',
    'search_box'                                          => 'Hledat',
    'search_box_intro'                                    => 'Welcome to the search function of Firefly III. Enter your search query in the box. <a href="https://docs.firefly-iii.org/how-to/firefly-iii/features/search/">Make sure you check out the help file</a> because the search is pretty advanced.',
    'search_error'                                        => 'Chyba při hledání',
    'search_searching'                                    => 'Hledání…',
    'search_results'                                      => 'Výsledky hledání',

    // repeat frequencies:
    'repeat_freq_yearly'                                  => 'ročně',
    'repeat_freq_half-year'                               => 'půloročně',
    'repeat_freq_quarterly'                               => 'čtvrtletně',
    'repeat_freq_monthly'                                 => 'měsíčně',
    'repeat_freq_weekly'                                  => 'týdně',
    'repeat_freq_daily'                                   => 'denně',
    'daily'                                               => 'denně',
    'weekly'                                              => 'týdně',
    'quarterly'                                           => 'čtvrtletně',
    'half-year'                                           => 'půlročně',
    'yearly'                                              => 'ročně',

    // rules
    'is_not_rule_trigger'                                 => 'Ne',
    'cannot_fire_inactive_rules'                          => 'Neaktivní pravidla nelze spouštět.',
    'show_triggers'                                       => 'Zobrazit spouštěče',
    'show_actions'                                        => 'Zobrazit akce',
    'rules'                                               => 'Pravidla',
    'rule_name'                                           => 'Název pravidla',
    'rule_triggers'                                       => 'Pravidlo se uplatní když',
    'rule_actions'                                        => 'Pravidlo bude',
    'new_rule'                                            => 'Nové pravidlo',
    'new_rule_group'                                      => 'Nová skupina pravidel',
    'rule_priority_up'                                    => 'Zvýšit prioritu pravidla',
    'rule_priority_down'                                  => 'Snížit prioritu pravidla',
    'make_new_rule_group'                                 => 'Vytvořit novou skupinu pravidel',
    'store_new_rule_group'                                => 'Uložit novou skupinu pravidel',
    'created_new_rule_group'                              => 'Nová skupina pravidel „:title“ uložena!',
    'updated_rule_group'                                  => 'Skupina pravidel „:title“ úspěšně aktualizována.',
    'edit_rule_group'                                     => 'Upravit skupinu pravidel „:title“',
    'duplicate_rule'                                      => 'Duplikovat pravidlo ":title"',
    'rule_copy_of'                                        => 'Kopie ":title"',
    'duplicated_rule'                                     => 'Pravidlo ":title" bylo zduplikováno jako ":newTitle"',
    'delete_rule_group'                                   => 'Smazat skupinu pravidel „:title“',
    'deleted_rule_group'                                  => 'Skupina pravidel „:title“ smazána',
    'update_rule_group'                                   => 'Aktualizovat skupinu pravidel',
    'no_rules_in_group'                                   => 'Tato skupina neobsahuje žádná pravidla',
    'move_rule_group_up'                                  => 'Posunout skupinu pravidel nahoru',
    'move_rule_group_down'                                => 'Posunout skupinu pravidel dolů',
    'save_rules_by_moving'                                => 'Save this rule by moving it to another rule group:|Save these rules by moving them to another rule group:',
    'make_new_rule'                                       => 'Vytvořit nové pravidlo ve skupině pravidel „:title“',
    'make_new_rule_no_group'                              => 'Vytvořit nové pravidlo',
    'instructions_rule_from_bill'                         => 'In order to match transactions to your new subscription ":name", Firefly III can create a rule that will automatically be checked against any transactions you store. Please verify the details below and store the rule to have Firefly III automatically match transactions to your new bill.',
    'instructions_rule_from_journal'                      => 'Create a rule based on one of your transactions. Complement or submit the form below.',
    'rule_is_strict'                                      => 'striktní pravidlo',
    'rule_is_not_strict'                                  => 'nestriktní pravidlo',
    'rule_help_stop_processing'                           => 'Při zaškrtnutí tohoto políčka se při aktivaci tohoto pravidla vykonávání pozdějších pravidel v této skupině zastaví.',
    'rule_help_strict'                                    => 'Ve striktním režimu musí všechna pravidla projít aby se akce vykonala. V nestriktním režimu stačí aby prošlo alespoň jedno.',
    'rule_help_active'                                    => 'Neaktivní pravidla nebudou nikdy spuštěna.',
    'stored_new_rule'                                     => 'Uloženo nové pravidlo nazvané „:title“',
    'deleted_rule'                                        => 'Smazáno pravidlo nazvané „:title“',
    'store_new_rule'                                      => 'Uložit nové pravidlo',
    'updated_rule'                                        => 'Pravidlo nazvané „:title“ aktualizováno',
    'default_rule_group_name'                             => 'Výchozí pravidla',
    'default_rule_group_description'                      => 'Všechna vaše pravidla nenacházející se v konkrétní skupině.',
    'trigger'                                             => 'Spouštěč',
    'trigger_value'                                       => 'Spouštěč při hodnotě',
    'stop_processing_other_triggers'                      => 'Zastavit zpracovávání ostatních spouštěčů',
    'add_rule_trigger'                                    => 'Přidat nový spouštěč',
    'action'                                              => 'Akce',
    'action_value'                                        => 'Hodnota akce',
    'stop_executing_other_actions'                        => 'Zastavit vykonávání ostatních akcí',
    'add_rule_action'                                     => 'Přidat novou akci',
    'edit_rule'                                           => 'Edit rule #:nr ":title"',
    'delete_rule'                                         => 'Smazat pravidlo „:title“',
    'update_rule'                                         => 'Aktualizovat pravidlo',
    'test_rule_triggers'                                  => 'Zobrazit odpovídající transakce',
    'warning_no_matching_transactions'                    => 'No matching transactions found.',
    'warning_no_valid_triggers'                           => 'Nebyly poskytnuty platné spouštěče.',
    'apply_rule_selection'                                => 'Uplatnit pravidlo „:title“ na vybrané transakce',
    'apply_rule_selection_intro'                          => 'Rules like ":title" are normally only applied to new or updated transactions, but you can tell Firefly III to run it on a selection of your existing transactions. This can be useful when you have updated a rule and you need the changes to be applied to all of your other transactions.',
    'include_transactions_from_accounts'                  => 'Zahrnout transakce z těchto účtů',
    'include'                                             => 'Include?',
    'applied_rule_selection'                              => '{0} No transactions in your selection were changed by rule ":title".|[1] One transaction in your selection was changed by rule ":title".|[2,*] :count transactions in your selection were changed by rule ":title".',
    'execute'                                             => 'Vykonat',
    'apply_rule_group_selection'                          => 'Uplatnit skupinu pravidel „:title“ na vybrané transakce',
    'apply_rule_group_selection_intro'                    => 'Rule groups like ":title" are normally only applied to new or updated transactions, but you can tell Firefly III to run all the rules in this group on a selection of your existing transactions. This can be useful when you have updated a group of rules and you need the changes to be applied to all of your other transactions.',
    'applied_rule_group_selection'                        => 'Skupina pravidel „:title“ byla uplatněna na váš výběr.',
    'rule_run_after_creation' => 'If you check this box, you get the opportunity to run the rule after it has been created.',
    'rule_run_after_edit' => 'If you check this box, you get the opportunity to run the rule after it has been updated.',

    // actions and triggers
    'rule_trigger_store_journal'                          => 'Kdy je transakce vytvořena',
    'rule_trigger_update_journal'                         => 'Kdy je transakce aktualizována',
    'rule_trigger_manual'                                 => 'Pouze ručně',
    'rule_trigger_user_action'                            => 'Uživatelská akce je „:trigger_value“',

    // OLD values (remove non-doubles later):
    'rule_trigger_source_account_starts_choice'           => 'Název zdrojového účtu začíná na..',
    'rule_trigger_source_account_starts'                  => 'Název zdrojového účtu začíná na ":trigger_value"',
    'rule_trigger_source_account_ends_choice'             => 'Název zdrojového účtu končí na..',
    'rule_trigger_source_account_ends'                    => 'Název zdrojového účtu končí na ":trigger_value"',
    'rule_trigger_source_account_is_choice'               => 'Název zdrojového účtu je..',
    'rule_trigger_source_account_is'                      => 'Název zdrojového účtu je ":trigger_value"',
    'rule_trigger_source_account_contains_choice'         => 'Název zdrojového účtu obsahuje..',
    'rule_trigger_source_account_contains'                => 'Název zdrojového účtu obsahuje ":trigger_value"',
    'rule_trigger_account_id_choice'                      => 'ID jednoho z účtů je..',
    'rule_trigger_account_id'                             => 'ID jednoho z účtů je ":trigger_value"',
    'rule_trigger_source_account_id_choice'               => 'ID zdrojového účtu je..',
    'rule_trigger_source_account_id'                      => 'ID zdrojového účtu je ":trigger_value"',
    'rule_trigger_destination_account_id_choice'          => 'ID cílového účtu je..',
    'rule_trigger_destination_account_id'                 => 'ID cílového účtu je ":trigger_value"',
    'rule_trigger_account_is_cash_choice'                 => 'Jeden z účtů je hotovostní',
    'rule_trigger_account_is_cash'                        => 'Jeden z účtů je hotovostní',
    'rule_trigger_source_is_cash_choice'                  => 'Zdrojový účet je hotovostní',
    'rule_trigger_source_is_cash'                         => 'Zdrojový účet je hotovostní',
    'rule_trigger_destination_is_cash_choice'             => 'Cílový účet je hotovostní',
    'rule_trigger_destination_is_cash'                    => 'Cílový účet je hotovostní',
    'rule_trigger_source_account_nr_starts_choice'        => 'IBAN zdrojového účtu začíná na..',
    'rule_trigger_source_account_nr_starts'               => 'IBAN zdrojového účtu začíná na ":trigger_value"',
    'rule_trigger_source_account_nr_ends_choice'          => 'IBAN zdrojového účtu končí na..',
    'rule_trigger_source_account_nr_ends'                 => 'IBAN zdrojového účtu končí na ":trigger_value"',
    'rule_trigger_source_account_nr_is_choice'            => 'IBAN zdrojového účtu je..',
    'rule_trigger_source_account_nr_is'                   => 'IBAN zdrojového účtu je ":trigger_value"',
    'rule_trigger_source_account_nr_contains_choice'      => 'IBAN zdrojového účtu obsahuje..',
    'rule_trigger_source_account_nr_contains'             => 'IBAN zdrojového účtu obsahuje ":trigger_value"',
    'rule_trigger_destination_account_starts_choice'      => 'Název cílového účtu začíná na..',
    'rule_trigger_destination_account_starts'             => 'Název cílového účtu začíná na ":trigger_value"',
    'rule_trigger_destination_account_ends_choice'        => 'Název cílového účtu končí na..',
    'rule_trigger_destination_account_ends'               => 'Název cílového účtu končí na ":trigger_value"',
    'rule_trigger_destination_account_is_choice'          => 'Název cílového účtu je..',
    'rule_trigger_destination_account_is'                 => 'Název cílového účtu je „:trigger_value“',
    'rule_trigger_destination_account_contains_choice'    => 'Název cílového účtu obsahuje..',
    'rule_trigger_destination_account_contains'           => 'Název cílového účtu obsahuje ":trigger_value"',
    'rule_trigger_destination_account_nr_starts_choice'   => 'IBAN cílového účtu začíná na..',
    'rule_trigger_destination_account_nr_starts'          => 'IBAN cílového účtu začíná na ":trigger_value"',
    'rule_trigger_destination_account_nr_ends_choice'     => 'IBAN cílového účtu končí na..',
    'rule_trigger_destination_account_nr_ends'            => 'IBAN cílového účtu končí na ":trigger_value"',
    'rule_trigger_destination_account_nr_is_choice'       => 'IBAN cílového účtu je..',
    'rule_trigger_destination_account_nr_is'              => 'IBAN cílového účtu je ":trigger_value"',
    'rule_trigger_destination_account_nr_contains_choice' => 'IBAN cílového účtu obsahuje..',
    'rule_trigger_destination_account_nr_contains'        => 'IBAN cílového účtu obsahuje ":trigger_value"',
    'rule_trigger_transaction_type_choice'                => 'Transakce je typu…',
    'rule_trigger_transaction_type'                       => 'Transakce je typu „:trigger_value“',
    'rule_trigger_category_is_choice'                     => 'Kategorie je…',
    'rule_trigger_category_is'                            => 'Kategorie je „:trigger_value“',
    'rule_trigger_amount_less_choice'                     => 'Částka je menší nebo rovna..',
    'rule_trigger_amount_less'                            => 'Částka je menší nebo rovna :trigger_value',
    'rule_trigger_amount_is_choice'                       => 'Částka je..',
    'rule_trigger_amount_is'                              => 'Částka je :trigger_value',
    'rule_trigger_amount_more_choice'                     => 'Částka je více nebo rovna..',
    'rule_trigger_amount_more'                            => 'Částka je více nebo rovna :trigger_value',
    'rule_trigger_description_starts_choice'              => 'Popis začíná na…',
    'rule_trigger_description_starts'                     => 'Popis začíná na „:trigger_value“',
    'rule_trigger_description_ends_choice'                => 'Popis končí na…',
    'rule_trigger_description_ends'                       => 'Popis končí na „:trigger_value“',
    'rule_trigger_description_contains_choice'            => 'Popis obsahuje…',
    'rule_trigger_description_contains'                   => 'Popis obsahuje „:trigger_value“',
    'rule_trigger_description_is_choice'                  => 'Popis je…',
    'rule_trigger_description_is'                         => 'Popis je „:trigger_value“',
    'rule_trigger_date_on_choice'                         => 'Datum transakce je..',
    'rule_trigger_date_on'                                => 'Datum transakce je ":trigger_value"',
    'rule_trigger_date_before_choice'                     => 'Datum transakce je před..',
    'rule_trigger_date_before'                            => 'Datum transakce je před „:trigger_value“',
    'rule_trigger_date_after_choice'                      => 'Datum transakce je po..',
    'rule_trigger_date_after'                             => 'Datum transakce je po „:trigger_value“',
    'rule_trigger_created_at_on_choice'                   => 'Transakce byla vytvořena..',
    'rule_trigger_created_at_on'                          => 'Transakce byla vytvořena ":trigger_value"',
    'rule_trigger_updated_at_on_choice'                   => 'Transakce byla naposledy upravena..',
    'rule_trigger_updated_at_on'                          => 'Transakce byla naposledy upravena ":trigger_value"',
    'rule_trigger_budget_is_choice'                       => 'Rozpočet je…',
    'rule_trigger_budget_is'                              => 'Rozpočet je „:trigger_value“',
    'rule_trigger_tag_is_choice'                          => 'Štítek je..',
    'rule_trigger_tag_is'                                 => 'Štítek je ":trigger_value"',
    'rule_trigger_tag_contains_choice'                    => 'Štítek obsahuje..',
    'rule_trigger_tag_contains'                           => 'Štítek obsahuje ":trigger_value"',
    'rule_trigger_not_tag_contains'                           => 'No tag contains ":trigger_value"',
    'rule_trigger_tag_ends_choice'                        => 'Štítek končí na..',
    'rule_trigger_tag_ends'                               => 'Štítek končí na ":trigger_value"',
    'rule_trigger_tag_starts_choice'                      => 'Štítek začíná na..',
    'rule_trigger_tag_starts'                             => 'Štítek končí na ":trigger_value"',
    'rule_trigger_currency_is_choice'                     => 'Měna transakce je…',
    'rule_trigger_currency_is'                            => 'Měna transakce je „:trigger_value“',
    'rule_trigger_foreign_currency_is_choice'             => 'Zahraniční měna je..',
    'rule_trigger_foreign_currency_is'                    => 'Zahraniční měna je ":trigger_value"',
    'rule_trigger_has_attachments_choice'                 => 'Má přílohy',
    'rule_trigger_has_attachments'                        => 'Má přílohy',
    'rule_trigger_has_no_category_choice'                 => 'Nemá žádnou kategorii',
    'rule_trigger_has_no_category'                        => 'Transakce nemá žádnou kategorii',
    'rule_trigger_has_any_category_choice'                => 'Má (libovolnou) kategorii',
    'rule_trigger_has_any_category'                       => 'Transakce má (libovolnou) kategorii',
    'rule_trigger_has_no_budget_choice'                   => 'Nemá žádný rozpočet',
    'rule_trigger_has_no_budget'                          => 'Transakce nemá žádný rozpočet',
    'rule_trigger_has_any_budget_choice'                  => 'Má (libovolný) rozpočet',
    'rule_trigger_has_any_budget'                         => 'Transakce má (libovolný) rozpočet',
    'rule_trigger_has_no_bill_choice'                     => 'Has no subscription',
    'rule_trigger_has_no_bill'                            => 'Transaction has no subscription',
    'rule_trigger_has_any_bill_choice'                    => 'Has a (any) subscription',
    'rule_trigger_has_any_bill'                           => 'Transaction has a (any) subscription',
    'rule_trigger_has_no_tag_choice'                      => 'Nemá žádné štítky',
    'rule_trigger_has_no_tag'                             => 'Transakce nemá žádné štítky',
    'rule_trigger_has_any_tag_choice'                     => 'Má jeden a více štítků',
    'rule_trigger_has_any_tag'                            => 'Transakce má jeden a více štítků',
    'rule_trigger_any_notes_choice'                       => 'Má (jakékoli) poznámky',
    'rule_trigger_any_notes'                              => 'Transakce má (jakékoli) poznámky',
    'rule_trigger_no_notes_choice'                        => 'Nemá žádné poznámky',
    'rule_trigger_no_notes'                               => 'Transakce nemá žádné poznámky',
    'rule_trigger_notes_is_choice'                        => 'Poznámka je..',
    'rule_trigger_notes_is'                               => 'Poznámka je ":trigger_value"',
    'rule_trigger_notes_contains_choice'                  => 'Poznámka obsahuje..',
    'rule_trigger_notes_contains'                         => 'Poznámka obsahuje ":trigger_value"',
    'rule_trigger_notes_starts_choice'                    => 'Poznámka začíná na..',
    'rule_trigger_notes_starts'                           => 'Poznámka začíná na ":trigger_value"',
    'rule_trigger_notes_ends_choice'                      => 'Poznámka končí na..',
    'rule_trigger_notes_ends'                             => 'Poznámka končí na ":trigger_value"',
    'rule_trigger_bill_is_choice'                         => 'Pravidelná plaba je..',
    'rule_trigger_bill_is'                                => 'Pravidelná platba je ":trigger_value"',
    'rule_trigger_external_id_is_choice'                  => 'Externí ID je..',
    'rule_trigger_external_id_is'                         => 'Externí ID je ":trigger_value"',
    'rule_trigger_internal_reference_is_choice'           => 'Internal reference is..',
    'rule_trigger_internal_reference_is'                  => 'Internal reference is ":trigger_value"',
    'rule_trigger_journal_id_choice'                      => 'Transaction journal ID is..',
    'rule_trigger_journal_id'                             => 'Transaction journal ID is ":trigger_value"',
    'rule_trigger_any_external_url'                       => 'Transakce má (jakoukoli) externí URL',
    'rule_trigger_any_external_url_choice'                => 'Má (jakoukoliv) externí URL',
    'rule_trigger_any_external_id'                        => 'Transakce má (jakoukoliv) externí URL',
    'rule_trigger_any_external_id_choice'                 => 'Má (jakoukoliv) externí URL',
    'rule_trigger_no_external_url_choice'                 => 'Nemá externí URL',
    'rule_trigger_no_external_url'                        => 'Transakce nemá externí adresu URL',
    'rule_trigger_no_external_id_choice'                  => 'Nemá externí ID',
    'rule_trigger_no_external_id'                         => 'Transakce nemá externí ID',
    'rule_trigger_id_choice'                              => 'ID transakce je..',
    'rule_trigger_id'                                     => 'ID transakce je ":trigger_value"',
    'rule_trigger_sepa_ct_is_choice'                      => 'SEPA CT is..',
    'rule_trigger_sepa_ct_is'                             => 'SEPA CT is ":trigger_value"',

    // new values:
    'rule_trigger_user_action_choice'                     => 'Akce uživatele je ":trigger_value"',
    'rule_trigger_tag_is_not_choice'                      => 'Štítek není..',
    'rule_trigger_tag_is_not'                             => 'Štítek není ":trigger_value"',
    'rule_trigger_account_is_choice'                      => 'Jeden z účtů je..',
    'rule_trigger_account_is'                             => 'Jeden z účtů je ":trigger_value"',
    'rule_trigger_account_contains_choice'                => 'Jeden z účtů obsahuje..',
    'rule_trigger_account_contains'                       => 'Jeden z účtů obsahuje ":trigger_value"',
    'rule_trigger_account_ends_choice'                    => 'Jeden z účtů končí na..',
    'rule_trigger_account_ends'                           => 'Jeden z účtů končí na ":trigger_value"',
    'rule_trigger_account_starts_choice'                  => 'Jeden z účtů začíná na..',
    'rule_trigger_account_starts'                         => 'Jeden z účtů začíná na ":trigger_value"',
    'rule_trigger_account_nr_is_choice'                   => 'IBAN jednoho z účtů je..',
    'rule_trigger_account_nr_is'                          => 'IBAN jednoho z účtů je ":trigger_value"',
    'rule_trigger_account_nr_contains_choice'             => 'IBAN jednoho z účtů obsahuje..',
    'rule_trigger_account_nr_contains'                    => 'IBAN jednoho z účtů obsahuje ":trigger_value"',
    'rule_trigger_account_nr_ends_choice'                 => 'IBAN jednoho z účtů končí na..',
    'rule_trigger_account_nr_ends'                        => 'IBAN jednoho z účtů končí na ":trigger_value"',
    'rule_trigger_account_nr_starts_choice'               => 'IBAN jednoho z účtů začíná na..',
    'rule_trigger_account_nr_starts'                      => 'IBAN jednoho z účtů začíná na ":trigger_value"',
    'rule_trigger_category_contains_choice'               => 'Kategorie obsahuje..',
    'rule_trigger_category_contains'                      => 'Kategorie obsahuje ":trigger_value"',
    'rule_trigger_category_ends_choice'                   => 'Kategorie končí na..',
    'rule_trigger_category_ends'                          => 'Kategorie končí na ":trigger_value"',
    'rule_trigger_category_starts_choice'                 => 'Kategorie začíná na..',
    'rule_trigger_category_starts'                        => 'Kategorie začíná na ":trigger_value"',
    'rule_trigger_budget_contains_choice'                 => 'Rozpočet obsahuje..',
    'rule_trigger_budget_contains'                        => 'Rozpočet obsahuje ":trigger_value"',
    'rule_trigger_budget_ends_choice'                     => 'Rozpočet končí na..',
    'rule_trigger_budget_ends'                            => 'Rozpočet končí na ":trigger_value"',
    'rule_trigger_budget_starts_choice'                   => 'Rozpočet začíná na..',
    'rule_trigger_budget_starts'                          => 'Rozpočet začíná na ":trigger_value"',
    'rule_trigger_bill_contains_choice'                   => 'Subscription contains..',
    'rule_trigger_bill_contains'                          => 'Subscription contains ":trigger_value"',
    'rule_trigger_bill_ends_choice'                       => 'Subscription ends with..',
    'rule_trigger_bill_ends'                              => 'Subscription ends with ":trigger_value"',
    'rule_trigger_bill_starts_choice'                     => 'Subscription starts with..',
    'rule_trigger_bill_starts'                            => 'Subscription starts with ":trigger_value"',
    'rule_trigger_external_id_contains_choice'            => 'Externí ID obsahuje..',
    'rule_trigger_external_id_contains'                   => 'Externí ID obsahuje ":trigger_value"',
    'rule_trigger_external_id_ends_choice'                => 'Externí ID končí na..',
    'rule_trigger_external_id_ends'                       => 'Externí ID končí na ":trigger_value"',
    'rule_trigger_external_id_starts_choice'              => 'Externí ID začíná na..',
    'rule_trigger_external_id_starts'                     => 'Externí ID začíná na ":trigger_value"',
    'rule_trigger_internal_reference_contains_choice'     => 'Internal reference contains..',
    'rule_trigger_internal_reference_contains'            => 'Internal reference contains ":trigger_value"',
    'rule_trigger_internal_reference_ends_choice'         => 'Internal reference ends with..',
    'rule_trigger_internal_reference_ends'                => 'Internal reference ends with ":trigger_value"',
    'rule_trigger_internal_reference_starts_choice'       => 'Internal reference starts with..',
    'rule_trigger_internal_reference_starts'              => 'Internal reference starts with ":trigger_value"',
    'rule_trigger_external_url_is_choice'                 => 'Externí adresa URL je..',
    'rule_trigger_external_url_is'                        => 'Externí adresa URL je „:trigger_value“',
    'rule_trigger_external_url_contains_choice'           => 'Externí adresa URL obsahuje..',
    'rule_trigger_external_url_contains'                  => 'Externí adresa URL obsahuje „:trigger_value“',
    'rule_trigger_external_url_ends_choice'               => 'Externí adresa URL končí textem..',
    'rule_trigger_external_url_ends'                      => 'Externí adresa URL končí textem „:trigger_value“',
    'rule_trigger_external_url_starts_choice'             => 'Externí adresa URL začíná textem..',
    'rule_trigger_external_url_starts'                    => 'Externí adresa URL končí textem „:trigger_value“',
    'rule_trigger_has_no_attachments_choice'              => 'Nemá přílohy',
    'rule_trigger_has_no_attachments'                     => 'Transakce nemá přílohy',
    'rule_trigger_recurrence_id_choice'                   => 'ID opakující se transakce je..',
    'rule_trigger_recurrence_id'                          => 'ID opakující se transakce je ":trigger_value"',
    'rule_trigger_interest_date_on_choice'                => 'Datum úroku je..',
    'rule_trigger_interest_date_on'                       => 'Datum úroku je ":trigger_value"',
    'rule_trigger_interest_date_before_choice'            => 'Datum úroku je před..',
    'rule_trigger_interest_date_before'                   => 'Datum úroku je před ":trigger_value"',
    'rule_trigger_interest_date_after_choice'             => 'Datum úroku je po..',
    'rule_trigger_interest_date_after'                    => 'Datum úroku je po ":trigger_value"',
    'rule_trigger_book_date_on_choice'                    => 'Datum rezervace je..',
    'rule_trigger_book_date_on'                           => 'Datum rezervace je ":trigger_value"',
    'rule_trigger_book_date_before_choice'                => 'Datum rezervace je před..',
    'rule_trigger_book_date_before'                       => 'Datum rezervace je před ":trigger_value"',
    'rule_trigger_book_date_after_choice'                 => 'Datum rezervace je po..',
    'rule_trigger_book_date_after'                        => 'Datum rezervace je po ":trigger_value"',
    'rule_trigger_process_date_on_choice'                 => 'Datum zpracování je..',
    'rule_trigger_process_date_on'                        => 'Datum zpracování je ":trigger_value"',
    'rule_trigger_process_date_before_choice'             => 'Datum zpracování je před..',
    'rule_trigger_process_date_before'                    => 'Datum zpracování je před ":trigger_value"',
    'rule_trigger_process_date_after_choice'              => 'Datum zpracování je po..',
    'rule_trigger_process_date_after'                     => 'Datum zpracování je po ":trigger_value"',
    'rule_trigger_due_date_on_choice'                     => 'Datum splatnosti je..',
    'rule_trigger_due_date_on'                            => 'Datum splatnosti je ":trigger_value"',
    'rule_trigger_due_date_before_choice'                 => 'Datum splatnosti je před..',
    'rule_trigger_due_date_before'                        => 'Datum splatnosti je před ":trigger_value"',
    'rule_trigger_due_date_after_choice'                  => 'Datum splatnosti je po..',
    'rule_trigger_due_date_after'                         => 'Datum splatnosti je po ":trigger_value"',
    'rule_trigger_payment_date_on_choice'                 => 'Datum platby je..',
    'rule_trigger_payment_date_on'                        => 'Datum platby je ":trigger_value"',
    'rule_trigger_payment_date_before_choice'             => 'Datum platby je před..',
    'rule_trigger_payment_date_before'                    => 'Datum platby je před ":trigger_value"',
    'rule_trigger_payment_date_after_choice'              => 'Datum platby je po..',
    'rule_trigger_payment_date_after'                     => 'Datum platby je po ":trigger_value"',
    'rule_trigger_invoice_date_on_choice'                 => 'Invoice date is on..',
    'rule_trigger_invoice_date_on'                        => 'Invoice date is on ":trigger_value"',
    'rule_trigger_invoice_date_before_choice'             => 'Invoice date is before..',
    'rule_trigger_invoice_date_before'                    => 'Invoice date is before ":trigger_value"',
    'rule_trigger_invoice_date_after_choice'              => 'Invoice date is after..',
    'rule_trigger_invoice_date_after'                     => 'Invoice date is after ":trigger_value"',
    'rule_trigger_created_at_before_choice'               => 'Transakce byla vytvořena před..',
    'rule_trigger_created_at_before'                      => 'Transakce byla vytvořena před ":trigger_value"',
    'rule_trigger_created_at_after_choice'                => 'Transakcee byla vytvořena po..',
    'rule_trigger_created_at_after'                       => 'Transakce byla vytvořena po ":trigger_value"',
    'rule_trigger_updated_at_before_choice'               => 'Transakce byla naposledy upravena před..',
    'rule_trigger_updated_at_before'                      => 'Transakce byla naposledy upravena před ":trigger_value"',
    'rule_trigger_updated_at_after_choice'                => 'Transakce byla naposledy upravena po..',
    'rule_trigger_updated_at_after'                       => 'Transakce byla naposledy upravena po ":trigger_value"',
    'rule_trigger_foreign_amount_is_choice'               => 'Částka v cizí měně je..',
    'rule_trigger_foreign_amount_is'                      => 'Částka v cizí měně je :trigger_value',
    'rule_trigger_foreign_amount_less_choice'             => 'Částka v cizí měně je méně než..',
    'rule_trigger_foreign_amount_less'                    => 'Částka v cizí měně je méně než :trigger_value',
    'rule_trigger_foreign_amount_more_choice'             => 'Částka v cizí měně je více než..',
    'rule_trigger_foreign_amount_more'                    => 'Částka v cizí měně je více než :trigger_value',
    'rule_trigger_attachment_name_is_choice'              => 'Název přílohy je..',
    'rule_trigger_attachment_name_is'                     => 'Název přílohy je ":trigger_value"',
    'rule_trigger_attachment_name_contains_choice'        => 'Název přílohy obsahuje..',
    'rule_trigger_attachment_name_contains'               => 'Název přílohy obsahuje ":trigger_value"',
    'rule_trigger_attachment_name_starts_choice'          => 'Název přílohy začíná na..',
    'rule_trigger_attachment_name_starts'                 => 'Název přílohy začíná na ":trigger_value"',
    'rule_trigger_attachment_name_ends_choice'            => 'Název přílohy končí na..',
    'rule_trigger_attachment_name_ends'                   => 'Název přílohy končí na ":trigger_value"',
    'rule_trigger_attachment_notes_are_choice'            => 'Poznámka k příloze je..',
    'rule_trigger_attachment_notes_are'                   => 'Poznámka k příloze je ":trigger_value"',
    'rule_trigger_attachment_notes_contains_choice'       => 'Poznámka k příloze obsahuje..',
    'rule_trigger_attachment_notes_contains'              => 'Poznámka k příloze obsahuje ":trigger_value"',
    'rule_trigger_attachment_notes_starts_choice'         => 'Poznámka k příloze začíná na..',
    'rule_trigger_attachment_notes_starts'                => 'Poznámka k příloze začíná na ":trigger_value"',
    'rule_trigger_attachment_notes_ends_choice'           => 'Poznámka k příloze končí na..',
    'rule_trigger_attachment_notes_ends'                  => 'Poznámka k příloze končí na ":trigger_value"',
    'rule_trigger_reconciled_choice'                      => 'Transaction is reconciled',
    'rule_trigger_reconciled'                             => 'Transaction is reconciled',
    'rule_trigger_exists_choice'                          => 'Každá transakce',
    'rule_trigger_exists'                                 => 'Každá transakce',

    // more values for new types:
    'rule_trigger_not_account_id'                         => 'Account ID is not ":trigger_value"',
    'rule_trigger_not_source_account_id'                  => 'Source account ID is not ":trigger_value"',
    'rule_trigger_not_destination_account_id'             => 'ID cílového účtu není ":trigger_value"',
    'rule_trigger_not_transaction_type'                   => 'Transaction type is not ":trigger_value"',
    'rule_trigger_not_tag_is'                             => 'Štítek není ":trigger_value"',
    'rule_trigger_not_tag_is_not'                         => 'Štítek je ":trigger_value"',
    'rule_trigger_not_description_is'                     => 'Description is not ":trigger_value"',
    'rule_trigger_not_description_contains'               => 'Description does not contain ":trigger_value"',
    'rule_trigger_not_description_ends'                   => 'Description does not end with ":trigger_value"',
    'rule_trigger_not_description_starts'                 => 'Description does not start with ":trigger_value"',
    'rule_trigger_not_notes_is'                           => 'Notes are not ":trigger_value"',
    'rule_trigger_not_notes_contains'                     => 'Notes do not contain ":trigger_value"',
    'rule_trigger_not_notes_ends'                         => 'Notes do not end on ":trigger_value"',
    'rule_trigger_not_notes_starts'                       => 'Notes do not start with ":trigger_value"',
    'rule_trigger_not_source_account_is'                  => 'Source account is not ":trigger_value"',
    'rule_trigger_not_source_account_contains'            => 'Source account does not contain ":trigger_value"',
    'rule_trigger_not_source_account_ends'                => 'Source account does not end on ":trigger_value"',
    'rule_trigger_not_source_account_starts'              => 'Source account does not start with ":trigger_value"',
    'rule_trigger_not_source_account_nr_is'               => 'Source account number / IBAN is not ":trigger_value"',
    'rule_trigger_not_source_account_nr_contains'         => 'Source account number / IBAN does not contain ":trigger_value"',
    'rule_trigger_not_source_account_nr_ends'             => 'Source account number / IBAN does not end on ":trigger_value"',
    'rule_trigger_not_source_account_nr_starts'           => 'Source account number / IBAN does not start with ":trigger_value"',
    'rule_trigger_not_destination_account_is'             => 'Cílový účet není ":trigger_value"',
    'rule_trigger_not_destination_account_contains'       => 'Cílový účet neobsahuje ":trigger_value"',
    'rule_trigger_not_destination_account_ends'           => 'Cílový účet nekončí na ":trigger_value"',
    'rule_trigger_not_destination_account_starts'         => 'Cílový účet nezačíná na ":trigger_value"',
    'rule_trigger_not_destination_account_nr_is'          => 'Destination account number / IBAN is not ":trigger_value"',
    'rule_trigger_not_destination_account_nr_contains'    => 'Destination account number / IBAN does not contain ":trigger_value"',
    'rule_trigger_not_destination_account_nr_ends'        => 'Destination account number / IBAN does not end on ":trigger_value"',
    'rule_trigger_not_destination_account_nr_starts'      => 'Destination account number / IBAN does not start with ":trigger_value"',
    'rule_trigger_not_account_is'                         => 'Neither account is ":trigger_value"',
    'rule_trigger_not_account_contains'                   => 'Neither account contains ":trigger_value"',
    'rule_trigger_not_account_ends'                       => 'Neither account ends on ":trigger_value"',
    'rule_trigger_not_account_starts'                     => 'Neither account starts with ":trigger_value"',
    'rule_trigger_not_account_nr_is'                      => 'Neither account number / IBAN is ":trigger_value"',
    'rule_trigger_not_account_nr_contains'                => 'Neither account number / IBAN contains ":trigger_value"',
    'rule_trigger_not_account_nr_ends'                    => 'Neither account number / IBAN ends on ":trigger_value"',
    'rule_trigger_not_account_nr_starts'                  => 'Neither account number / IBAN starts with ":trigger_value"',
    'rule_trigger_not_category_is'                        => 'Category is not ":trigger_value"',
    'rule_trigger_not_category_contains'                  => 'Kategorie neobsahuje ":trigger_value"',
    'rule_trigger_not_category_ends'                      => 'Kategorie nekončí na ":trigger_value"',
    'rule_trigger_not_category_starts'                    => 'Kategorie nezačíná na ":trigger_value"',
    'rule_trigger_not_budget_is'                          => 'Budget is not ":trigger_value"',
    'rule_trigger_not_budget_contains'                    => 'Rozpočet neobsahuje ":trigger_value"',
    'rule_trigger_not_budget_ends'                        => 'Budget does not end on ":trigger_value"',
    'rule_trigger_not_budget_starts'                      => 'Budget does not start with ":trigger_value"',
    'rule_trigger_not_bill_is'                            => 'Subscription is not is ":trigger_value"',
    'rule_trigger_not_bill_contains'                      => 'Subscription does not contain ":trigger_value"',
    'rule_trigger_not_bill_ends'                          => 'Subscription does not end on ":trigger_value"',
    'rule_trigger_not_bill_starts'                        => 'Subscription does not end with ":trigger_value"',
    'rule_trigger_not_external_id_is'                     => 'External ID is not ":trigger_value"',
    'rule_trigger_not_external_id_contains'               => 'External ID does not contain ":trigger_value"',
    'rule_trigger_not_external_id_ends'                   => 'External ID does not end on ":trigger_value"',
    'rule_trigger_not_external_id_starts'                 => 'External ID does not start with ":trigger_value"',
    'rule_trigger_not_internal_reference_is'              => 'Internal reference is not ":trigger_value"',
    'rule_trigger_not_internal_reference_contains'        => 'Internal reference does not contain ":trigger_value"',
    'rule_trigger_not_internal_reference_ends'            => 'Internal reference does not end on ":trigger_value"',
    'rule_trigger_not_internal_reference_starts'          => 'Internal reference does not start with ":trigger_value"',
    'rule_trigger_not_external_url_is'                    => 'Externí adresa URL není „:trigger_value“',
    'rule_trigger_not_external_url_contains'              => 'Externí adresa URL neobsahuje „:trigger_value“',
    'rule_trigger_not_external_url_ends'                  => 'Externí adresa URL nekončí textem „:trigger_value“',
    'rule_trigger_not_external_url_starts'                => 'Externí adresa URL nezačíná textem „:trigger_value“',
    'rule_trigger_not_currency_is'                        => 'Currency is not ":trigger_value"',
    'rule_trigger_not_foreign_currency_is'                => 'Foreign currency is not ":trigger_value"',
    'rule_trigger_not_id'                                 => 'Transaction ID is not ":trigger_value"',
    'rule_trigger_not_journal_id'                         => 'Transaction journal ID is not ":trigger_value"',
    'rule_trigger_not_recurrence_id'                      => 'Recurrence ID is not ":trigger_value"',
    'rule_trigger_not_date_on'                            => 'Date is not on ":trigger_value"',
    'rule_trigger_not_date_before'                        => 'Date is not before ":trigger_value"',
    'rule_trigger_not_date_after'                         => 'Date is not after ":trigger_value"',
    'rule_trigger_not_interest_date_on'                   => 'Interest date is not on ":trigger_value"',
    'rule_trigger_not_interest_date_before'               => 'Interest date is not before ":trigger_value"',
    'rule_trigger_not_interest_date_after'                => 'Interest date is not after ":trigger_value"',
    'rule_trigger_not_book_date_on'                       => 'Datum rezervace není ":trigger_value"',
    'rule_trigger_not_book_date_before'                   => 'Datum rezervace není před ":trigger_value"',
    'rule_trigger_not_book_date_after'                    => 'Datum rezervace není po ":trigger_value"',
    'rule_trigger_not_process_date_on'                    => 'Process date is not on ":trigger_value"',
    'rule_trigger_not_process_date_before'                => 'Process date is not before ":trigger_value"',
    'rule_trigger_not_process_date_after'                 => 'Process date is not after ":trigger_value"',
    'rule_trigger_not_due_date_on'                        => 'Datum splatnosti není ":trigger_value"',
    'rule_trigger_not_due_date_before'                    => 'Datum splatnosti není před ":trigger_value"',
    'rule_trigger_not_due_date_after'                     => 'Datum splatnosti není po ":trigger_value"',
    'rule_trigger_not_payment_date_on'                    => 'Payment date is not on ":trigger_value"',
    'rule_trigger_not_payment_date_before'                => 'Payment date is not before ":trigger_value"',
    'rule_trigger_not_payment_date_after'                 => 'Payment date is not after ":trigger_value"',
    'rule_trigger_not_invoice_date_on'                    => 'Invoice date is not on ":trigger_value"',
    'rule_trigger_not_invoice_date_before'                => 'Invoice date is not before ":trigger_value"',
    'rule_trigger_not_invoice_date_after'                 => 'Invoice date is not after ":trigger_value"',
    'rule_trigger_not_created_at_on'                      => 'Transaction is not created on ":trigger_value"',
    'rule_trigger_not_created_at_before'                  => 'Transaction is not created before ":trigger_value"',
    'rule_trigger_not_created_at_after'                   => 'Transaction is not created after ":trigger_value"',
    'rule_trigger_not_updated_at_on'                      => 'Transakce nebyla upravena ":trigger_value"',
    'rule_trigger_not_updated_at_before'                  => 'Transakce nebyla upravena před ":trigger_value"',
    'rule_trigger_not_updated_at_after'                   => 'Transakce nebyla upravena po ":trigger_value"',
    'rule_trigger_not_amount_is'                          => 'Částka transakce není :trigger_value',
    'rule_trigger_not_amount_less'                        => 'Částka transakce je více než :trigger_value',
    'rule_trigger_not_amount_more'                        => 'Částka transakce je méně než :trigger_value',
    'rule_trigger_not_foreign_amount_is'                  => 'Částka transakce v cizí měně není :trigger_value',
    'rule_trigger_not_foreign_amount_less'                => 'Částka transakce v cizí měně je více než :trigger_value',
    'rule_trigger_not_foreign_amount_more'                => 'Částka transakce v cizí měně je méně než :trigger_value',
    'rule_trigger_not_attachment_name_is'                 => 'No attachment is named ":trigger_value"',
    'rule_trigger_not_attachment_name_contains'           => 'No attachment name contains ":trigger_value"',
    'rule_trigger_not_attachment_name_starts'             => 'No attachment name starts with ":trigger_value"',
    'rule_trigger_not_attachment_name_ends'               => 'No attachment name ends on ":trigger_value"',
    'rule_trigger_not_attachment_notes_are'               => 'No attachment notes are ":trigger_value"',
    'rule_trigger_not_attachment_notes_contains'          => 'No attachment notes contain ":trigger_value"',
    'rule_trigger_not_attachment_notes_starts'            => 'No attachment notes start with ":trigger_value"',
    'rule_trigger_not_attachment_notes_ends'              => 'No attachment notes end on ":trigger_value"',
    'rule_trigger_not_reconciled'                         => 'Transaction is not reconciled',
    'rule_trigger_not_exists'                             => 'Transaction does not exist',
    'rule_trigger_not_has_attachments'                    => 'Transaction has no attachments',
    'rule_trigger_not_has_any_category'                   => 'Transaction has no category',
    'rule_trigger_not_has_any_budget'                     => 'Transaction has no budget',
    'rule_trigger_not_has_any_bill'                       => 'Transaction has no subscription',
    'rule_trigger_not_has_any_tag'                        => 'Transakce neobsahuje štítky',
    'rule_trigger_not_any_notes'                          => 'Transaction has no notes',
    'rule_trigger_not_any_external_url'                   => 'Transakce nemá externí adresu URL',
    'rule_trigger_not_has_no_attachments'                 => 'Transakce má (jakékoliv) přílohy',
    'rule_trigger_not_has_no_category'                    => 'Transakce má (jakoukoliv) kategorii',
    'rule_trigger_not_has_no_budget'                      => 'Transakce má (jakýkoliv) rozpočet',
    'rule_trigger_not_has_no_bill'                        => 'Transaction has a (any) subscription',
    'rule_trigger_not_has_no_tag'                         => 'Transakce obsahuje štítky',
    'rule_trigger_not_no_notes'                           => 'Transakce má (jakoukoliv) poznámku',
    'rule_trigger_not_no_external_url'                    => 'Transakce má externí URL',
    'rule_trigger_not_source_is_cash'                     => 'Zdrojový účet není hotovostní',
    'rule_trigger_not_destination_is_cash'                => 'Cílový účet není hotovostní',
    'rule_trigger_not_account_is_cash'                    => 'Ani jeden účet není hotovostní',

    // new account balance things.
    'rule_trigger_destination_balance_gt_choice'          => 'Zůstatek cílového účtu je více než..',
    'rule_trigger_destination_balance_gte_choice'         => 'Zůstatek cílového účtu je alespoň..',
    'rule_trigger_destination_balance_is_choice'          => 'Zůstatek cílového účtu je..',
    'rule_trigger_destination_balance_lt_choice'          => 'Zůstatek cílového účtu je méně než..',
    'rule_trigger_destination_balance_lte_choice'         => 'Zůstatek cílového účtu je nejvýše..',

    'rule_trigger_source_balance_gt_choice'  => 'Source account balance is more than..',
    'rule_trigger_source_balance_gte_choice' => 'Source account balance is more than or equal to..',
    'rule_trigger_source_balance_is_choice'  => 'Source account balance is exactly..',
    'rule_trigger_source_balance_lt_choice'  => 'Source account balance is less than..',
    'rule_trigger_source_balance_lte_choice' => 'Source account balance is less than or equal to..',

    'rule_trigger_destination_balance_gt'  => 'Zůstatek cílového účtu je více než ":trigger_value"',
    'rule_trigger_destination_balance_gte' => 'Zůstatek cílového účtu je neméně ":trigger_value"',
    'rule_trigger_destination_balance_is'  => 'Zůstatek cílového účtu je ":trigger_value"',
    'rule_trigger_destination_balance_lt'  => 'Zůstatek cílového účtu je méně než ":trigger_value"',
    'rule_trigger_destination_balance_lte' => 'Zůstatek cílového účtu je nejvýše ":trigger_value"',

    'rule_trigger_source_balance_gt'           => 'Source account balance is more than :trigger_value',
    'rule_trigger_source_balance_gte'          => 'Source account balance is more than or equal to :trigger_value',
    'rule_trigger_source_balance_is'           => 'Source account balance is exactly :trigger_value',
    'rule_trigger_source_balance_lt'           => 'Source account balance is less than :trigger_value',
    'rule_trigger_source_balance_lte'          => 'Source account balance is less than or equal to :trigger_value',

    // NOT
    'rule_trigger_not_destination_balance_gt'  => 'Zůstatek cílového účtu je nejvýše ":trigger_value"',
    'rule_trigger_not_destination_balance_gte' => 'Zůstatek cílového účtu je méně než ":trigger_value"',
    'rule_trigger_not_destination_balance_is'  => 'Zůstatek cílového účtu není ":trigger_value"',
    'rule_trigger_not_destination_balance_lt'  => 'Zůstatek cílového účtu je nejméně ":trigger_value"',
    'rule_trigger_not_destination_balance_lte' => 'Zůstatek cílového účtu je více než ":trigger_value"',

    'rule_trigger_not_source_balance_gt'         => 'Source account balance is less than or equal to :trigger_value',
    'rule_trigger_not_source_balance_gte'        => 'Source account balance is less than :trigger_value',
    'rule_trigger_not_source_balance_is'         => 'Source account balance is not :trigger_value',
    'rule_trigger_not_source_balance_lt'         => 'Source account balance is more than or equal to :trigger_value',
    'rule_trigger_not_source_balance_lte'        => 'Source account balance is more than :trigger_value',


    // actions
    // set, clear, add, remove, append/prepend
    'rule_action_delete_transaction_choice'      => 'DELETE transaction(!)',
    'rule_action_delete_transaction'             => 'DELETE transaction(!)',
    'rule_action_set_category'                   => 'Nastavit kategorii na „:action_value“',
    'rule_action_clear_category'                 => 'Vyčistit kategorii',
    'rule_action_set_budget'                     => 'Nastavit rozpočet na „:action_value“',
    'rule_action_clear_budget'                   => 'Vyčistit rozpočet',
    'rule_action_add_tag'                        => 'Přidat štítek „:action_value“',
    'rule_action_remove_tag'                     => 'Odebrat štítek „:action_value“',
    'rule_action_remove_all_tags'                => 'Odstranit všechny štítky',
    'rule_action_set_description'                => 'Nastavit pospis na „:action_value“',
    'rule_action_append_description'             => 'Připojit popis s „:action_value“',
    'rule_action_prepend_description'            => 'Před popis přidat „:action_value“',
    'rule_action_set_category_choice'            => 'Set category to ..',
    'rule_action_clear_category_choice'          => 'Vyčistit jakékoli kategorie',
    'rule_action_set_budget_choice'              => 'Set budget to ..',
    'rule_action_clear_budget_choice'            => 'Vyčistit jakýkoli rozpočet',
    'rule_action_add_tag_choice'                 => 'Přidat štítek..',
    'rule_action_remove_tag_choice'              => 'Odebrat štítek..',
    'rule_action_remove_all_tags_choice'         => 'Odebrat všechny štítky',
    'rule_action_set_description_choice'         => 'Set description to ..',
    'rule_action_update_piggy_choice'            => 'Add / remove transaction amount in piggy bank ..',
    'rule_action_update_piggy'                   => 'Add / remove transaction amount in piggy bank ":action_value"',
    'rule_action_append_description_choice'      => 'Append description with ..',
    'rule_action_prepend_description_choice'     => 'Prepend description with ..',
    'rule_action_set_source_account_choice'      => 'Set source account to ..',
    'rule_action_set_source_account'             => 'Nastavit účet na :action_value',
    'rule_action_set_destination_account_choice' => 'Nastavit cílový účet na..',
    'rule_action_set_destination_account'        => 'Nastavit cílový účet na :action_value',
    'rule_action_append_notes_choice'            => 'Append notes with ..',
    'rule_action_append_notes'                   => 'Přidat za poznámky „:action_value“',
    'rule_action_prepend_notes_choice'           => 'Prepend notes with ..',
    'rule_action_prepend_notes'                  => 'Přidat před poznámky „:action_value“',
    'rule_action_clear_notes_choice'             => 'Odstranit všechny poznámky',
    'rule_action_clear_notes'                    => 'Odstranit všechny poznámky',
    'rule_action_set_notes_choice'               => 'Set notes to ..',
    'rule_action_link_to_bill_choice'            => 'Link to a subscription ..',
    'rule_action_link_to_bill'                   => 'Připojit k pravidelné platbě ":action_value"',
    'rule_action_switch_accounts_choice'         => 'Prohodit zdrojový a cílový účet (pouze převody)',
    'rule_action_switch_accounts'                => 'Prohodit zdrojový a cílový účet',
    'rule_action_set_notes'                      => 'Nastavit poznámky na „:action_value“',
    'rule_action_convert_deposit_choice'         => 'Přeměnit tuto transakci na vklad',
    'rule_action_convert_deposit'                => 'Přeměnit tuto transakci z vkladu na „:action_value“',
    'rule_action_convert_withdrawal_choice'      => 'Přeměnit transakci na výběr',
    'rule_action_convert_withdrawal'             => 'Přeměnit tuto transakci na vklad do „:action_value“',
    'rule_action_convert_transfer_choice'        => 'Přeměnit tuto transakci na převod',
    'rule_action_convert_transfer'               => 'Přeměnit tuto transakci na převod s „:action_value“',
    'rule_action_append_descr_to_notes_choice'   => 'Append the description to the transaction notes',
    'rule_action_append_notes_to_descr_choice'   => 'Append the transaction notes to the description',
    'rule_action_move_descr_to_notes_choice'     => 'Replace the current transaction notes with the description',
    'rule_action_move_notes_to_descr_choice'     => 'Replace the current description with the transaction notes',
    'rule_action_append_descr_to_notes'          => 'Append description to notes',
    'rule_action_append_notes_to_descr'          => 'Append notes to description',
    'rule_action_move_descr_to_notes'            => 'Replace notes with description',
    'rule_action_move_notes_to_descr'            => 'Replace description with notes',
    'rule_action_set_amount_choice'              => 'Set amount to ..',
    'rule_action_set_amount'                     => 'Set amount to ":action_value"',
    'rule_action_set_destination_to_cash_choice' => 'Nastavit cílový účet na hotovostní',
    'rule_action_set_source_to_cash_choice'      => 'Set source account to (cash)',
    'rulegroup_for_bills_title'                  => 'Rule group for subscriptions',
    'rulegroup_for_bills_description'            => 'A special rule group for all the rules that involve subscriptions.',
    'rule_for_bill_title'                        => 'Auto-generated rule for subscription ":name"',
    'rule_for_bill_description'                  => 'This rule is auto-generated to try to match subscription ":name".',
    'create_rule_for_bill'                       => 'Create a new rule for subscription ":name"',
    'create_rule_for_bill_txt'                   => 'Právě jste vytvořili novou pravidelnou platbu s názvem ":name". Firefly III k ní může automagicky přiřazovat výběry (například předplatné "Nájem" kdykoli ho zaplatíte). Firefly III vám může přesně ukázat, které předplatné je ještě třeba zaplatit a které už ne. Pro to musíte vytvořit nové pravidlo. Firefly III předvyplnilo rozumné výchozí hodnoty, ale zkontrolujte že jsou správné.',
    'new_rule_for_bill_title'                    => 'Rule for subscription ":name"',
    'new_rule_for_bill_description'              => 'Pravidlo označuje transakce pro pravidelnou platbu ":name".',

    'new_rule_for_journal_title'                => 'Rule based on transaction ":description"',
    'new_rule_for_journal_description'          => 'This rule is based on transaction ":description". It will match transactions that are exactly the same.',

    // tags
    'store_new_tag'                             => 'Uložit nový štítek',
    'update_tag'                                => 'Aktualizovat štítek',
    'no_location_set'                           => 'Není nastaveno žádné umístění.',
    'meta_data'                                 => 'Metadata',
    'location'                                  => 'Umístění',
    'location_first_split'                      => 'The location for this transaction can be set on the first split of this transaction.',
    'without_date'                              => 'Bez data',
    'result'                                    => 'Výsledek',
    'sums_apply_to_range'                       => 'Všechny součty se vztahují na vybraný rozsah',
    'mapbox_api_key'                            => 'Pro použití mapy, získejte klíč k aplikačnímu programovému rozhraní <a href="https://www.mapbox.com/">Mapbox</a>. Otevřete soubor <code>.env</code> a tento kód zadejte za <code>MAPBOX_API_KEY=</code>.',
    'press_object_location'                     => '',
    'click_tap_location'                        => 'Click or tap the map to add a location',
    'clear_location'                            => 'Vymazat umístění',
    'delete_all_selected_tags'                  => 'Odebrat všechny vybrané štítky',
    'select_tags_to_delete'                     => 'Nezapomeňte vybrat některé štítky',
    'deleted_x_tags'                            => 'Smazán :count štítek|Smazáno :count štítků.',
    'create_rule_from_transaction'              => 'Create rule based on transaction',
    'create_recurring_from_transaction'         => 'Create recurring transaction based on transaction',

    // preferences
    'test_notifications_buttons'                => 'Pro otestování nastavení použijte tlačítka níže. Pozor, nemají protispamovou ochranu.',
    'dark_mode_option_browser'                  => 'Dle nastavení prohlížeče',
    'dark_mode_option_light'                    => 'Vždy světlý',
    'dark_mode_option_dark'                     => 'Vždy tmavý',
    'equal_to_language'                         => '(rovno jazyku)',
    'dark_mode_preference'                      => 'Tmavý režim',
    'dark_mode_preference_help'                 => 'Nastavte kdy má Firefly III používat tmavý režim.',
    'pref_home_screen_accounts'                 => 'Účty na domovské obrazovce',
    'pref_home_screen_accounts_help'            => 'Které účty zobrazit na domovské stránce?',
    'pref_view_range'                           => 'Zobrazit rozsah',
    'pref_view_range_help'                      => 'Některé grafy a rozpočty jsou vytvářeny pro určitá období. Jaké chcete používat?',
    'pref_1D'                                   => 'Jeden den',
    'pref_1W'                                   => 'Jeden týden',
    'pref_1M'                                   => 'Jeden měsíc',
    'pref_3M'                                   => 'Tři měsíce (čtvrtletí)',
    'pref_6M'                                   => 'Šest měsíců',
    'pref_1Y'                                   => 'Jeden rok',
    'pref_last365'                              => 'Poslední rok',
    'pref_last90'                               => 'Posledních 90 dní',
    'pref_last30'                               => 'Posledních 30 dní',
    'pref_last7'                                => 'Posledních 7 dní',
    'pref_YTD'                                  => 'Rok k dnešnímu dni',
    'pref_QTD'                                  => 'Období čtvrtletí k dnešnímu dni',
    'pref_MTD'                                  => 'Měsíc k dnešnímu dni',
    'pref_languages'                            => 'Jazyky',
    'pref_locale'                               => 'Místní nastavení',
    'pref_languages_help'                       => 'Firefly III podporuje několik jazyků – ve kterém ho chcete používat?',
    'pref_locale_help'                          => 'Firefly III vám umožňuje nastavit další lokální nastavení, jako je formátování měn, čísel a dat. Položky v tomto seznamu nemusí být podporovány vaším systémem. Firefly III nemá správné nastavení data pro každé lokální místo. Pro vylepšení mě kontaktujte.',
    'pref_locale_no_demo'                       => 'This feature won\'t work for the demo user.',
    'pref_convert_to_primary'                   => 'Display amounts in your primary currency',
    'pref_convert_to_primary_help'              => 'This option will make Firefly III try to display and show your primary currency in as many places as possible, converting amounts where necessary. This sacrifices accuracy for ease of use, because conversion is not always exact. Please verify that Firefly III has the necessary conversion rates on the "exchange rates"-page.',
    'pref_convert_primary_help'                 => 'Display primary amounts',
    'pref_custom_fiscal_year'                   => 'Nastavení fiskálního roku',
    'pref_custom_fiscal_year_label'             => 'Zapnuto',
    'pref_custom_fiscal_year_help'              => 'Pro země, ve kterých finanční rok nezačíná 1. ledna a tedy ani nekončí 31. prosince, je možné zapnutím tohoto určit den začátku a konce fiskálního roku',
    'pref_fiscal_year_start_label'              => 'Datum zahájení fiskálního roku',
    'pref_two_factor_auth'                      => 'Vícefaktorové ověření',
    'pref_two_factor_auth_help'                 => 'Zapnutím vícefaktorového ověřování (MFA) můžete přidat další vrstvu bezpečnosti vašemu účtu. Budete se přihlašovat něčím co znáte (heslo) a něčím co máte (ověřovací kód). Ověřovací kódy generuje aplikace jako Authy nebo Google Authenticator.',
    'pref_enable_two_factor_auth'               => 'Zapnout vícefaktorové ověřování',
    'pref_two_factor_auth_disabled'             => 'Multi-factor authentication verification code removed and disabled',
    'pref_two_factor_auth_remove_it'            => 'Nezapomeňte účet odstranit z vaší ověřovací aplikace!',
    'pref_two_factor_auth_code'                 => 'Ověřit kód',
    'pref_two_factor_auth_code_help'            => 'Scan the QR code with an application on your phone such as Authy or Google Authenticator and enter the generated code. The QR code changes every time you visit this page. Make sure you use the most recent one.',
    'pref_two_factor_auth_reset_code'           => 'Resetovat ověřovací kód',
    'pref_two_factor_auth_disable_2fa'          => 'Zakázat MFA',
    '2fa_use_secret_instead'                    => 'If you cannot scan the QR code, feel free to use the secret instead: <code>:secret</code>.',
    '2fa_backup_codes'                          => 'Store these backup codes for access in case you lose your device.',
    '2fa_already_enabled'                       => 'Vícefaktorové ověřování je na vašem účtu zapnuto.',
    'wrong_mfa_code'                            => 'This MFA code is not valid.',
    'pref_save_settings'                        => 'Uložit nastavení',
    'saved_preferences'                         => 'Předvolby uloženy!',
    'preferences_general'                       => 'Obecné',
    'preferences_frontpage'                     => 'Domovská obrazovka',
    'preferences_security'                      => 'Zabezpečení',
    'preferences_layout'                        => 'Rozvržení',
    'preferences_notifications'                 => 'Upozornění',
    'pref_home_show_deposits'                   => 'Zobrazovat vklady na domovské obrazovce',
    'pref_home_show_deposits_info'              => 'Domovská obrazovka už zobrazuje vaše výdajové účty. Mají být zobrazovány také ty příjmové?',
    'pref_home_do_show_deposits'                => 'Ano, zobrazit je',
    'successful_count'                          => 'z toho :count úspěšné',
    'list_page_size_title'                      => 'Velikost stránky',
    'list_page_size_help'                       => 'Jakýkoli seznam věcí (účty, transakce, atd) zobrazuje nejvýše tolik na stránku.',
    'list_page_size_label'                      => 'Velikost stránky',
    'between_dates'                             => '(:start a :end)',
    'pref_optional_fields_transaction'          => 'Volitelné kolonky pro transakce',
    'pref_optional_fields_transaction_help'     => 'Ve výchozím nastavení nejsou při vytváření nové transakce povolena všechna pole (z důvodu nepořádku). Níže můžete tato pole povolit, pokud si myslíte, že by pro vás mohla být užitečná. Jakékoli pole, které je zakázané ale již vyplněné, bude samozřejmě viditelné nezávisle na nastavení.',
    'optional_tj_date_fields'                   => 'Kolonky pro datum',
    'optional_tj_other_fields'                  => 'Další pole',
    'optional_tj_attachment_fields'             => 'Kolonky příloh',
    'pref_optional_tj_interest_date'            => 'Úrokové datum',
    'pref_optional_tj_book_date'                => 'Datum rezervace',
    'pref_optional_tj_process_date'             => 'Datum zpracování',
    'pref_optional_tj_due_date'                 => 'Datum splatnosti',
    'pref_optional_tj_payment_date'             => 'Datum zaplacení',
    'pref_optional_tj_invoice_date'             => 'Datum vystavení',
    'pref_optional_tj_internal_reference'       => 'Interní reference',
    'pref_optional_tj_notes'                    => 'Poznámky',
    'pref_optional_tj_attachments'              => 'Přílohy',
    'pref_optional_tj_external_url'             => 'Externí adresa URL',
    'pref_optional_tj_location'                 => 'Poloha',
    'pref_optional_tj_links'                    => 'Odkazy transakcí',
    'optional_field_meta_dates'                 => 'Data',
    'optional_field_meta_business'              => 'Business',
    'optional_field_attachments'                => 'Přílohy',
    'optional_field_meta_data'                  => 'Volitelná metadata',
    'external_url'                              => 'Externí URL adresa',
    'pref_notification_login_failure'           => 'Selhání přihlášení',
    'pref_notification_bill_reminder'           => 'Upozornění na expirující pravidelné platby',
    'pref_notification_new_access_token'        => 'Upozornit, když je vytvořen nový přístupový token API',
    'pref_notification_transaction_creation'    => 'Upozornit při automatickém vytvoření transakce',
    'pref_notification_user_login'              => 'Upozornit při oznámení z nové lokace',
    'pref_notification_rule_action_failures'    => 'Upozornit, pokud se akce pravidla nevykoná (ne přes e-mail)',
    'pref_notification_new_password'            => 'Změna vašeho hesla',
    'pref_notification_enabled_mfa'             => 'Povoleno vícefaktorové ověření',
    'pref_notification_disabled_mfa'            => 'Zakázáno vícefaktorové ověření',
    'pref_notification_few_left_mfa'            => 'Zbývá jen pár záložních kódů',
    'pref_notification_no_left_mfa'             => 'Nezbývají žádné záložní kódy',
    'pref_notification_many_failed_mfa'         => 'Kontrola vícefaktorového ověření opakovaně selhává',
    'pref_notification_new_backup_codes'        => 'Vygenerovány nové záložní kódy',
    'pref_notifications'                        => 'Upozornění',
    'pref_notifications_help'                   => 'Zde si můžete vybrat druhy upozornění. Některé z nich mohou obsahovat soukromé finanční informace.',
    'pref_notifications_settings'               => 'Nastavení upozornění',
    'pref_notifications_settings_help'          => 'Zde můžete nastavit jednotlivé způsoby posílání upozornění. Upozornění bude posláno do všech nastavených míst. Před použitím uložte nastavení.',
    'slack_url_label'                           => 'Adresa „příchozího webhooku“ Slack',
    'discord_url_label'                         => 'Discord webhook URL',

    // exchange rates
    'menu_exchange_rates_index'                 => 'Směnné kurzy',
    'header_exchange_rates'                     => 'Směnné kurzy',
    'exchange_rates_intro'                      => 'Firefly III podporuje stahování a používání směnných kurzů. Více informací o této funkci najdete <a href="https://docs.firefly-iii.org/explanation/financial-concepts/exchange-rates/">v dokumentaci</a>.',
    'exchange_rates_from_to'                    => 'Mezi {from} a {to} (a opačně)',
    'header_exchange_rates_rates'               => 'Směnné kurzy',
    'exchange_rates_intro_rates'                => 'Firefly III používá následující směnné kurzy. Inverzní kurz je automaticky vypočítán, pokud není zadán. Pokud pro datum transakce neexistuje směnný kurz, Firefly III se vrátí zpět v čase a pokusí se nějaký najít. Pokud žádný nenajde, použije se kurz „1“.',
    'header_exchange_rates_table'               => 'Tabulka se směnnými kurzy',
    'help_rate_form'                            => 'On this day, how many {to} will you get for one {from}?',
    'save_new_rate'                             => 'Save new rate',
    'add_new_rate'                              => 'Add a new exchange rate',
    'not_enough_currencies'                     => 'Not enough currencies',
    'not_enough_currencies_enabled'             => 'Pokud máte povolenou pouze jednu měnu, nemusíte přidávat směnné kurzy.',

    // Financial administrations
    'administration_index'                      => 'Financial administration',
    'administrations_breadcrumb'                => 'Správa financí',
    'administrations_page_title'                => 'Správa financí',
    'administrations_index_menu'                => 'Správa financí',
    'administrations_page_sub_title'            => 'Přehled',
    'create_administration'                     => 'Create new administration',
    'administration_owner'                      => 'Majitel administrace: {{email}}',
    'administration_you'                        => 'Your role: {{role}}',
    'other_users_in_admin'                      => 'Other users in this administration',
    'administrations_create_breadcrumb'         => 'Vytvořit novou správu financí',
    'administrations_page_create_sub_title'     => 'Vytvořit novou správu financí',
    'basic_administration_information'          => 'Basic administration information',
    'new_administration_created'                => 'New financial administration "{{title}}" has been created',
    'edit_administration_breadcrumb'            => 'Edit financial administration ":title"',
    'administrations_page_edit_sub_title'       => 'Upravit správu financí „:title“',
    'administrations_page_edit_sub_title_js'    => 'Upravit správu financí „{title}“',
    'temp_administrations_introduction'         => 'Firefly III will soon get the ability to manage multiple financial administrations. Right now, you only have the one. You can set the title of this administration and its primary currency. This replaces the previous setting where you would set your "default currency". This setting is now tied to the financial administration and can be different per administration.',
    'temp_administrations_introduction_edit'    => 'Currently, you can only set the "primary currency" of the default financial administration. This replaces the "default currency" setting. This setting is now tied to the financial administration and can be different per administration.',
    'administration_currency_form_help'         => 'It may take a long time for the page to load if you change the primary currency because transaction may need to be converted to your (new) primary currency.',
    'flash_administration_updated'              => 'Administration ":title" has been updated',
    'flash_administration_created'              => 'Administration ":title" has been created',
    'flash_administration_deleted'              => 'Administration ":title" has been deleted',

    // roles
    'administration_role_owner'                 => 'Owner',
    'administration_role_ro'                    => 'Read-only',
    'administration_role_mng_trx'               => 'Manage transactions',
    'administration_role_mng_meta'              => 'Manage classification and meta-data',
    'administration_role_mng_budgets'           => 'Manage budgets',
    'administration_role_mng_piggies'           => 'Spravovat pokladničky',
    'administration_role_mng_subscriptions'     => 'Spravovat pravidelné platby',
    'administration_role_mng_rules'             => 'Manage rules',
    'administration_role_mng_recurring'         => 'Manage recurring transactions',
    'administration_role_mng_webhooks'          => 'Manage webhooks',
    'administration_role_mng_currencies'        => 'Manage currencies',
    'administration_role_view_reports'          => 'View reports',
    'administration_role_full'                  => 'Full access',

    // mfa
    'enable_mfa'                                => 'Zapnout vícefaktorové ověřování',
    'mfa_index_title'                           => 'Vícefaktorové ověření',
    'mfa_index_intro'                           => 'Firefly III podporuje vícefaktorové ověřování (MFA). Zapnutím MFA můžete přidat další vrstvu bezpečnosti vašemu účtu. Aplikace jako Authy, Google Authenticator nebo FreeOTP generují kód který použijete k ověření. Bezpečnostní klíče nejsou Firefly III podporovány, ale můžete ho použít pro uložení vašeho MFA.',
    'mfa_index_enabled'                         => 'Vícefaktorové ověření je pro váš účet zapnuté.',
    'mfa_index_disabled'                        => 'Vícefaktorová authenzace je pro váš účet vypnutá.',
    'mfa_index_owner'                           => 'Majitel této instance bude moci u vašeho účtu vždy zakázat vícefaktorové ověření.',
    'current_password_confirm_mfa'              => 'Zadejte své aktuální heslo',
    'mfa_warning_code_changes'                  => 'You may get a MFA dialog after you entered your password and a MFA code. In that case, please wait for your application to generate a new MFA code, and do not recycle the one you just used.',
    'mfa_already_disabled'                      => 'Vícefaktorové ověření je pro váš účet vypnuté, takže ho vypnout nemůžete.',
    'disable_mfa_page'                          => 'Disable multi-factor authentication',
    'disable_mfa_intro'                         => 'You can disable multi-factor authentication. To do so, please enter your password and a multi-factor authentication code. If you want to disable multi-factor authentication because you have lost access to your code generator, <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">please refer to the documentation instead</a>.',
    'pref_disable_mfa'                          => 'Disable multi-factor authentication',
    'mfa_not_enabled'                           => 'Vícefaktorové ověření je zapnuté.',
    'mfa_backup_codes_intro'                    => 'Firefly III vám může vygenerovat záložní kódy. Tyto kódy lze použít k přihlášení, pokud nemůžete použít váš generátor kódů. Kdykoli můžete vygenerovat novou sadu kódů. Pokud vygenerujete novou sadu, bude ta stará zneplatněna.',
    'mfa_backup_codes_quick'                    => 'Pokud jste velmi rychle přešli ze stránky nastavení vícefaktorového ověření, vaše aplikace možná ještě nevygenerovala nový kód. Každý MFA kód lze použít pouze jednou. Ujistěte se, že jste použili jiný kód, než předtím.',
    'mfa_backup_codes_title'                    => 'Záložní kódy vícefaktorového ověření',
    'mfa_backup_codes_post_title'               => 'Záložní kódy vícefaktorového ověření',

    // profile:
    'manage_mfa_settings'                       => 'Spravovat nastavení vícefaktorového ověření',
    'purge_data_title'                          => 'Vyčistit data z Firefly III',
    'purge_data_expl'                           => '„Vyčištění“ znamená „smazání smazaného“. Za normálních podmínek Firefly III nic nemaže úplně, data pouze schová. Toto tlačítko dříve „smazaná“ data smaže nadobro.',
    'delete_stuff_header'                       => 'Smazat a vyčistit data',
    'purge_all_data'                            => 'Vyčistit všechna smazaná data',
    'purge_data'                                => 'Purge data',
    'purged_all_records'                        => 'Všechna smazaná data byla vyčištěna.',
    'delete_data_title'                         => 'Smazat data z Firefly III',
    'permanent_delete_stuff'                    => 'Obsah Firefly III můžete smazat. Použijte tlačítka níže abyste ho skryli. Tuto akci nelze vrátit, ale data zůstanou v databázi pro případ že je budete potřebovat zachovat.',
    'other_sessions_logged_out'                 => 'All your other sessions have been logged out.',
    'delete_unused_accounts'                    => 'Smazání nepoužívaných účtů vymaže vaše seznamy automatického dokončování.',
    'delete_all_unused_accounts'                => 'Smazat nepoužívané účty',
    'deleted_all_unused_accounts'               => 'Všechny nepoužívané účty byly smazány',
    'delete_all_budgets'                        => 'Smazat VŠECNY rozpočty',
    'delete_all_categories'                     => 'Smazat VŠECHNY vaše kategorie',
    'delete_all_tags'                           => 'Smazat VŠECHNY vaše štítky',
    'delete_all_bills'                          => 'Smazat VŠECHNY pravidelné platby',
    'delete_all_piggy_banks'                    => 'Smazat VŠECHNY pokladničky',
    'delete_all_rules'                          => 'Smazat VŠECHNA pravidla',
    'delete_all_recurring'                      => 'Smazat VŠECHNY opakované transakce',
    'delete_all_object_groups'                  => 'Smazat VŠECHNY vaše skupiny objektů',
    'delete_all_accounts'                       => 'Smazat VŠECHNY účty',
    'delete_all_asset_accounts'                 => 'Smazat VŠECHNY majetkové účty',
    'delete_all_expense_accounts'               => 'Smazat VŠECHNY výdajové účty',
    'delete_all_revenue_accounts'               => 'Smazat VŠECHNY příjmové účty',
    'delete_all_liabilities'                    => 'Smazat VŠECHNY závazky',
    'delete_all_transactions'                   => 'Smazat VŠECHNY transakce',
    'delete_all_withdrawals'                    => 'Smazat VŠECHNY výběry',
    'delete_all_deposits'                       => 'Smazat VŠECHNY vklady',
    'delete_all_transfers'                      => 'Smazat VŠECHNY převody',
    'also_delete_transactions'                  => 'Smazání účtu taky smaže VŠECHNY výběry, vklady a převody!',
    'deleted_all_budgets'                       => 'Všechny rozpočty byly smazány',
    'deleted_all_categories'                    => 'Všechny kategorie byly smazány',
    'deleted_all_tags'                          => 'Všechny štítky byly smazány',
    'deleted_all_bills'                         => 'Všechny pravidelné platby byly odstraněny',
    'deleted_all_piggy_banks'                   => 'Všechny pokladničky byly smazány',
    'deleted_all_rules'                         => 'All rules and rule groups have been deleted',
    'deleted_all_object_groups'                 => 'All groups have been deleted',
    'deleted_all_accounts'                      => 'All accounts have been deleted',
    'deleted_all_asset_accounts'                => 'All asset accounts have been deleted',
    'deleted_all_expense_accounts'              => 'All expense accounts have been deleted',
    'deleted_all_revenue_accounts'              => 'All revenue accounts have been deleted',
    'deleted_all_liabilities'                   => 'All liabilities have been deleted',
    'deleted_all_transactions'                  => 'All transactions have been deleted',
    'deleted_all_withdrawals'                   => 'All withdrawals have been deleted',
    'deleted_all_deposits'                      => 'All deposits have been deleted',
    'deleted_all_transfers'                     => 'All transfers have been deleted',
    'deleted_all_recurring'                     => 'All recurring transactions have been deleted',
    'change_your_password'                      => 'Změnit heslo',
    'delete_account'                            => 'Smazat účet',
    'current_password'                          => 'Stávající heslo',
    'new_password'                              => 'Nové heslo',
    'new_password_again'                        => 'Nové heslo (zopakování)',
    'delete_your_account'                       => 'Smazat svůj účet',
    'delete_your_account_help'                  => 'Smazání vašeho účtu smaže také všechny účty, transakce, <em>vše</em>, co jste ve Firefly III uložili. Bude to PRYČ.',
    'delete_your_account_password'              => 'Pokračujte zadáním svého hesla.',
    'password'                                  => 'Heslo',
    'are_you_sure'                              => 'Opravdu provést? Není možné vzít zpět.',
    'are_you_sure_confirm'                      => 'Are you sure?',
    'delete_account_button'                     => 'SMAZAT svůj účet',
    'invalid_current_password'                  => 'Neplatné stávající heslo!',
    'password_changed'                          => 'Heslo změněno.',
    'should_change'                             => 'Myšlenka je změnit si heslo.',
    'invalid_password'                          => 'Neplatné heslo.',
    'what_is_pw_security'                       => 'Co je „ověřit odolnost hesla“.',
    'secure_pw_title'                           => 'Jak zvolit odolné heslo',
    'forgot_password_response'                  => 'Děkujeme. Pokud existuje účet s touto e-mailovou adresou, najdete instrukce ve vaší schránce.',
    'secure_pw_history'                         => 'Nemine týden, abychom neviděli zprávy o stránkách, ze kterých unikly hesla jejich uživatelů. Hackeři a zloději tato hesla používají pro pokus o ukradení vašich soukromých informací. Informace jsou cenné.',
    'secure_pw_ff'                              => 'Používáte stejná hesla napříč webem? Pokud jedna ze stránek ztratí vaše heslo, hackeři mají přístup ke všem vašim datům. Firefly III spoléhá na to, že zvolíte silné a jinde nepoužívané heslo pro ochranu vašich finančních záznamů.',
    'secure_pw_check_box'                       => 'Jako pomoc Firefly III může zkontrolovat heslo které chcete použít, zda v minulosti nebylo ukradeno (včetně jeho otisku). V takovém případě aplikace NEdoporučí používat takové heslo.',
    'secure_pw_working_title'                   => 'Jak to funguje?',
    'secure_pw_working'                         => 'By checking the box, Firefly III will send the first five characters of the SHA1 hash of your password to <a href="https://www.troyhunt.com/introducing-306-million-freely-downloadable-pwned-passwords/">the website of Troy Hunt</a> to see if it is on the list. This will stop you from using unsafe passwords as is recommended in the latest <a href="https://pages.nist.gov/800-63-3/sp800-63b.html">NIST Special Publication</a> on this subject.',
    'secure_pw_should'                          => 'Mám tuto kolonku zaškrtnout?',
    'secure_pw_long_password'                   => 'Ano, vždy ověřit že je heslo bezpečné.',
    'command_line_token'                        => 'Token pro příkazový řádek',
    'explain_command_line_token'                => 'Tento token potřebujete pro provádění možností z příkazového řádku, jako je export dat. Bez něj nebude daný citlivý příkaz fungovat. Tento token nesdílejte. Nebude vás o něj nikdo žádat, ani já. Pokud se bojíte, že jste jej ztratili, nebo pokud jste paranoidní, vygenerujte si token znovu pomocí tlačítka.',
    'regenerate_command_line_token'             => 'Znovu vygenerovat token pro příkazový řádek',
    'token_regenerated'                         => 'Byl vytvořen nový token pro příkazový řádek',
    'change_your_email'                         => 'Změnit e-mailovou adresu',
    'email_verification'                        => 'Emailové upozornění bude posláno na vaši starou a novou emailovou adresu. Z bezpečnostních důvodů se nebudete moci přihlásit dokud neověříte novou adresu. Pokud si nejste jisti jestli vaše instalace Firefly III podporuje odesílání emailů, tuto funkci prosím nepoužívejte. Pokud jste administrátor, můžete si ji vyzkoušet <a href="settings">v nastavení</a>.',
    'email_changed_logout'                      => 'Dokud neověříte svou emailovou adresu, nemůžete se přihlásit.',
    'login_with_new_email'                      => 'Nyní se můžete přihlásit pomocí nové e-mailové adresy.',
    'login_with_old_email'                      => 'Nyní se můžete přihlásit pomocí původní e-mailové adresy.',
    'login_provider_local_only'                 => 'This action is not available when authenticating through ":login_provider".',
    'external_user_mgt_disabled'                => 'This action is not available when Firefly III isn\'t responsible for user management or authentication handling.',
    'external_auth_disabled'                    => 'This action is not available when Firefly III isn\'t responsible for authentication handling.',
    'delete_local_info_only'                    => "Because Firefly III isn't responsible for user management or authentication handling, this function will only delete local Firefly III information.",
    'oauth'                                     => 'OAuth',
    'profile_oauth_clients'                     => 'Klienti OAuth',
    'profile_oauth_no_clients'                  => 'Zatím jste nevytvořili OAuth klienty.',
    'profile_oauth_clients_external_auth'       => 'Pokud pro ověřování používáte externí službu, například Authelia, OAuth klienti nemusí fungovat správně. Místo toho můžete použít osobní přístupový token.',
    'profile_oauth_clients_header'              => 'Klienti',
    'profile_oauth_client_id'                   => 'ID klienta',
    'profile_oauth_client_name'                 => 'Jméno',
    'profile_oauth_client_secret'               => 'Tajné',
    'profile_oauth_create_new_client'           => 'Vytvořit nového klienta',
    'profile_oauth_create_client'               => 'Vytvořit klienta',
    'profile_oauth_edit_client'                 => 'Upravit klienta',
    'profile_oauth_name_help'                   => 'Něco čemu vaši uživatelé budou důvěřovat.',
    'profile_oauth_redirect_url'                => 'Přesměrovat URL adresu',
    'profile_oauth_redirect_url_help'           => 'Callback URL vaší aplikace.',
    'profile_authorized_apps'                   => 'Authorized applications',
    'profile_authorized_clients'                => 'Autorizovaní klienti',
    'profile_scopes'                            => 'Scopes',
    'profile_revoke'                            => 'Revoke',
    'profile_oauth_client_secret_title'         => 'Client Secret',
    'profile_oauth_client_secret_expl'          => 'Here is your new client secret. This is the only time it will be shown so don\'t lose it! You may now use this secret to make API requests.',
    'profile_personal_access_tokens'            => 'Osobní přístupový token',
    'profile_personal_access_token'             => 'Osobní přístupové tokeny',
    'profile_oauth_confidential'                => 'Soukromá aplikace',
    'profile_oauth_confidential_help'           => 'Require the client to authenticate with a secret. Confidential clients can hold credentials in a secure way without exposing them to unauthorized parties. Public applications, such as native desktop or JavaScript SPA applications, are unable to hold secrets securely.',
    'profile_personal_access_token_explanation' => 'Zde je váš nový osobní přístupový token. Toto je jediný okamžik, kdy jej uvidíte, takže ho neztraťte! Nyní můžete tento token použít k odesílání požadavků na API.',
    'profile_no_personal_access_token'          => 'Zatím jste nevytvořili žádné osobní přístupové tokeny.',
    'profile_create_new_token'                  => 'Vytvořit nový token',
    'profile_create_token'                      => 'Vytvořit token',
    'profile_create'                            => 'Vytvořit',
    'profile_save_changes'                      => 'Uložit změny',
    'profile_whoops'                            => 'Omlouváme se, tohle nějak nefunguje',
    'profile_something_wrong'                   => 'Something went wrong!',
    'profile_try_again'                         => 'Something went wrong. Please try again.',
    'amounts'                                   => 'Amounts',
    'multi_account_warning_unknown'             => 'Depending on the type of transaction you create, the source and/or destination account of subsequent splits may be overruled by whatever is defined in the first split of the transaction.',
    'multi_account_warning_withdrawal'          => 'Zdrojový účet celé transakce je ovládaný prvním rozdělením.',
    'multi_account_warning_deposit'             => 'Cílový účel všech následujících rozdělení je ovládaný cílovým účtem prvního rozdělení transakce.',
    'multi_account_warning_transfer'            => 'Zdrojový i cílový účet všech následujících rozdělení jsou ovládány zdrojovým a cílovým účtem prvního rozdělení transakce.',


    // export data:
    'export_data_title'                         => 'Export dat z Firefly III',
    'export_data_menu'                          => 'Exportovat data',
    'export_data_bc'                            => 'Export dat z Firefly III',
    'export_data_main_title'                    => 'Export dat z Firefly III',
    'export_data_expl'                          => 'Tento odkaz vám umožňuje exportovat všechny transakce + metadata ze služby Firefly III. Pro více informací o procesu navštivte nápovědu (ikona (?) v pravém horním rohu).',
    'export_data_all_transactions'              => 'Exportovat všechny transakce',
    'export_data_advanced_expl'                 => 'Pokud potřebujete pokročilejší nebo specifičtější typ exportu, přečtěte si nápovědu, jak použít konzolový příkaz <code>php artisan help firefly-iii:export-data</code>.',

    // attachments
    'nr_of_attachments'                         => 'Jedna příloha|:count příloh',
    'attachments'                               => 'Přílohy',
    'edit_attachment'                           => 'Upravit přílohu ":name"',
    'update_attachment'                         => 'Aktualizovat přílohu',
    'delete_attachment'                         => 'Smazat přílohu „:name“',
    'attachment_deleted'                        => 'Příloha „:name“ smazána',
    'liabilities_deleted'                       => 'Smazán závazek „:name“',
    'attachment_updated'                        => 'Příloha „:name“ smazána',
    'upload_max_file_size'                      => 'Nejvyšší umožněná velikost souboru: :size',
    'list_all_attachments'                      => 'Seznam všech příloh',

    // transaction index
    'is_reconciled_fields_dropped'              => 'Because this transaction is reconciled, you will not be able to update the accounts, nor the amount(s) unless you remove the reconciliation flag.',
    'is_reconciled'                             => 'Is reconciled',
    'title_expenses'                            => 'Výdaje',
    'title_withdrawal'                          => 'Výdaje',
    'title_revenue'                             => 'Výnos/příjem',
    'title_deposit'                             => 'Výnos/příjem',
    'title_transfer'                            => 'Převody',
    'title_transfers'                           => 'Převody',
    'submission_options'                        => 'Možnosti položky',
    'apply_rules_checkbox'                      => 'Aplikovat pravidla',
    'fire_webhooks_checkbox'                    => 'Spustit webhooky',
    'select_source_account'                     => 'Please select or type a valid source account name',
    'select_dest_account'                       => 'Please select or type a valid destination account name',

    // convert stuff:
    'convert_is_already_type_Withdrawal'        => 'Tato transakce už je výběrem',
    'convert_is_already_type_Deposit'           => 'Tato transakce už je vkladem',
    'convert_is_already_type_Transfer'          => 'Tato transakce už je převodem',
    'convert_to_Withdrawal'                     => 'Přeměnit „:description“ na výběr',
    'convert_to_Deposit'                        => 'Přeměnit „:description“ na vklad',
    'convert_to_Transfer'                       => 'Přeměnit „:description“ na přenos',
    'convert_options_WithdrawalDeposit'         => 'Přeměnit výběr na vklad',
    'convert_options_WithdrawalTransfer'        => 'Přeměnit výběr na převod',
    'convert_options_DepositTransfer'           => 'Přeměnit výběr na přenos',
    'convert_options_DepositWithdrawal'         => 'Přeměnit vklad na výběr',
    'convert_options_TransferWithdrawal'        => 'Přeměnit převod na výběr',
    'convert_options_TransferDeposit'           => 'Přeměnit převod na vklad',
    'convert_Withdrawal_to_deposit'             => 'Přeměnit tento výběr na vklad',
    'convert_Withdrawal_to_transfer'            => 'Přeměnit tento výběr na převod',
    'convert_Deposit_to_withdrawal'             => 'Přeměnit tento vklad na výběr',
    'convert_Deposit_to_transfer'               => 'Přeměnit tento výběr na přenos',
    'convert_Transfer_to_deposit'               => 'Přeměnit tento převod na vklad',
    'convert_Transfer_to_withdrawal'            => 'Přeměnit tento převod výběr',
    'convert_please_set_revenue_source'         => 'Please pick the revenue account where the money will come from.',
    'convert_please_set_asset_destination'      => 'Vyberte účet aktiv, na který peníze půjdou.',
    'convert_please_set_expense_destination'    => 'Vyberte výdajový účet, na který peníze půjdou.',
    'convert_please_set_asset_source'           => 'Vyberte účet aktiv, ze kterého peníze půjdou.',
    'convert_expl_w_d'                          => 'When converting from a withdrawal to a deposit, the money will be deposited into the displayed destination account, instead of being withdrawn from it.|When converting from a withdrawal to a deposit, the money will be deposited into the displayed destination accounts, instead of being withdrawn from them.',
    'convert_expl_w_t'                          => 'When converting a withdrawal into a transfer, the money will be transferred away from the source account into other asset or liability account instead of being spent on the original expense account.|When converting a withdrawal into a transfer, the money will be transferred away from the source accounts into other asset or liability accounts instead of being spent on the original expense accounts.',
    'convert_expl_d_w'                          => 'When converting a deposit into a withdrawal, the money will be withdrawn from the displayed source account, instead of being deposited into it.|When converting a deposit into a withdrawal, the money will be withdrawn from the displayed source accounts, instead of being deposited into them.',
    'convert_expl_d_t'                          => 'When you convert a deposit into a transfer, the money will be deposited into the listed destination account from any of your asset or liability account.|When you convert a deposit into a transfer, the money will be deposited into the listed destination accounts from any of your asset or liability accounts.',
    'convert_expl_t_w'                          => 'When you convert a transfer into a withdrawal, the money will be spent on the destination account you set here, instead of being transferred away.|When you convert a transfer into a withdrawal, the money will be spent on the destination accounts you set here, instead of being transferred away.',
    'convert_expl_t_d'                          => 'When you convert a transfer into a deposit, the money will be deposited into the destination account you see here, instead of being transferred into it.|When you convert a transfer into a deposit, the money will be deposited into the destination accounts you see here, instead of being transferred into them.',
    'convert_select_sources'                    => 'To complete the conversion, please set the new source account below.|To complete the conversion, please set the new source accounts below.',
    'convert_select_destinations'               => 'To complete the conversion, please select the new destination account below.|To complete the conversion, please select the new destination accounts below.',
    'converted_to_Withdrawal'                   => 'The transaction has been converted to a withdrawal',
    'converted_to_Deposit'                      => 'The transaction has been converted to a deposit',
    'converted_to_Transfer'                     => 'The transaction has been converted to a transfer',
    'invalid_convert_selection'                 => 'The account you have selected is already used in this transaction or does not exist.',
    'source_or_dest_invalid'                    => 'Cannot find the correct transaction details. Conversion is not possible.',
    'convert_to_withdrawal'                     => 'Přeměnit na výběr',
    'convert_to_deposit'                        => 'Přeměnit na vklad',
    'convert_to_transfer'                       => 'Přeměnit na převod',

    // create new stuff:
    'create_new_withdrawal'                     => 'Vytvořit nový výběr',
    'create_new_deposit'                        => 'Vytvořit nový vklad',
    'create_new_transfer'                       => 'Vytvořit nový převod',
    'create_new_asset'                          => 'Vytvořit nový účet aktiv',
    'create_new_liabilities'                    => 'Create new liability',
    'create_new_expense'                        => 'Vytvořit výdajový účet',
    'create_new_revenue'                        => 'Vytvořit nový příjmový účet',
    'create_new_piggy_bank'                     => 'Vytvořit novou pokladničku',
    'create_new_bill'                           => 'Vytvořit novou pravidelnou platbu',
    'create_new_subscription'                   => 'Vytvořit novou pravidelnou platbu',
    'create_new_rule'                           => 'Create new rule',

    // currencies:
    'create_currency'                           => 'Vytvořit novou měnu',
    'store_currency'                            => 'Uložit novou měnu',
    'update_currency'                           => 'Aktualizovat měnu',
    'new_default_currency'                      => '":name" is now the default currency.',
    'default_currency_failed'                   => 'Could not make ":name" the default currency. Please check the logs.',
    'cannot_delete_currency'                    => ':name nelze odstranit, protože je v aplikaci stále pro něco používáno.',
    'cannot_delete_fallback_currency'           => ':name is the system fallback currency and can\'t be deleted.',
    'cannot_disable_currency_journals'          => 'Cannot disable :name because transactions are still using it.',
    'cannot_disable_currency_last_left'         => 'Cannot disable :name because it is the last enabled currency.',
    'cannot_disable_currency_account_meta'      => 'Cannot disable :name because it is used in asset accounts.',
    'cannot_disable_currency_bills'             => 'Cannot disable :name because it is used in subscriptions.',
    'cannot_disable_currency_recurring'         => 'Cannot disable :name because it is used in recurring transactions.',
    'cannot_disable_currency_available_budgets' => 'Cannot disable :name because it is used in available budgets.',
    'cannot_disable_currency_budget_limits'     => 'Cannot disable :name because it is used in budget limits.',
    'cannot_disable_currency_current_default'   => 'Cannot disable :name because it is the current default currency.',
    'cannot_disable_currency_system_fallback'   => 'Cannot disable :name because it is the system default currency.',
    'disable_EUR_side_effects'                  => 'The Euro is the system\'s emergency fallback currency. Disabling it may have unintended side-effects and may void your warranty.',
    'deleted_currency'                          => 'Měna :name smazána',
    'created_currency'                          => 'Měna :name vytvořena',
    'could_not_store_currency'                  => 'Novou měnu se nepodařilo uložit.',
    'updated_currency'                          => 'Měna :name aktualizována',
    'ask_site_owner'                            => 'Please ask :owner to add, remove or edit currencies.',
    'currencies_intro'                          => 'Firefly III podporuje různé měny, které můžete nastavit a zpřístupnit zde.',
    'currencies_switch_default'                 => 'You can switch the primary currency for your current administration on the "Financial administrations"-page.',
    'make_default_currency'                     => 'Nastavit jako výchozí',
    'default_currency'                          => 'výchozí',
    'primary_currency_button'                   => 'primary',
    'currency_is_disabled'                      => 'Vypnuto',
    'enable_currency'                           => 'Zapnout',
    'disable_currency'                          => 'Vypnout',
    'currencies_default_disabled'               => 'Většina těchto měn je ve výchozím stavu vypnutá. Pro jejich použití, je třeba je nejdříve zapnout.',
    'currency_is_now_enabled'                   => 'Měna „:name“ byla zapnuta',
    'could_not_enable_currency'                 => 'Could not enable currency ":name". Please review the logs.',
    'currency_is_now_disabled'                  => 'Měna „:name“ byla vypnuta',
    'could_not_disable_currency'                => 'Could not disable currency ":name". Perhaps it is still in use?',

    // forms:
    'mandatoryFields'                           => 'Povinné kolonky',
    'optionalFields'                            => 'Volitelné kolonky',
    'options'                                   => 'Možnosti',

    // budgets:
    'daily_budgets'                             => 'Denní rozpočty',
    'weekly_budgets'                            => 'Týdenní rozpočty',
    'monthly_budgets'                           => 'Měsíční rozpočty',
    'quarterly_budgets'                         => 'Čtvrtletní rozpočty',
    'half_year_budgets'                         => 'Pololetní rozpočty',
    'yearly_budgets'                            => 'Roční rozpočty',
    'other_budgets'                             => 'Custom timed budgets',
    'budget_limit_not_in_range'                 => 'This amount applies from :start to :end:',
    'total_available_budget'                    => 'Total available budget (between :start and :end)',
    'total_available_budget_in_currency'        => 'Celkový rozpočet k dispozici v :currency',
    'see_below'                                 => 'viz níže',
    'create_new_budget'                         => 'Vytvořit nový rozpočet',
    'store_new_budget'                          => 'Uložit nový rozpočet',
    'stored_new_budget'                         => 'Uložen novým rozpočet „:name“',
    'available_between'                         => 'Dostupné mezi :start a :end',
    'transactionsWithoutBudget'                 => 'Výdaje bez rozpočtu',
    'transactions_no_budget'                    => 'Výdaje bez rozpočtu mezi :start a :end',
    'spent_between'                             => 'Už utraceno mezi :start a :end',
    'spent_between_left'                        => 'Mezi :start a :end jste utratili :spent, zbyvá :left.',
    'set_available_amount'                      => 'Nastavit částku k dispozici',
    'update_available_amount'                   => 'Aktualizovat částku k dispozici',
    'ab_basic_modal_explain'                    => 'Use this form to indicate how much you expect to be able to budget (in total, in :currency) in the indicated period.',
    'createBudget'                              => 'Nový rozpočet',
    'invalid_currency'                          => 'Toto není platná měna',
    'invalid_amount'                            => 'Prosím, zadejte částku',
    'set_ab'                                    => 'The available budget amount has been set',
    'updated_ab'                                => 'The available budget amount has been updated',
    'deleted_ab'                                => 'The available budget amount has been deleted',
    'deleted_bl'                                => 'The budgeted amount has been removed',
    'alt_currency_ab_create'                    => 'Set the available budget in another currency',
    'bl_create_btn'                             => 'Set budget in another currency',
    'inactiveBudgets'                           => 'Neaktivní rozpočty',
    'without_budget_between'                    => 'Transakce bez rozpočtu mezi :start a :end',
    'delete_budget'                             => 'Smazat rozpočet „:name“',
    'deleted_budget'                            => 'Smazán rozpočet „:name“',
    'edit_budget'                               => 'Upravit rozpočet „:name“',
    'updated_budget'                            => 'Aktualizován rozpočet „:name“',
    'update_amount'                             => 'Aktualizovat částku',
    'update_budget'                             => 'Aktualizovat rozpočet',
    'update_budget_amount_range'                => 'Update (expected) available amount between :start and :end',
    'set_budget_limit_title'                    => 'Set budgeted amount for budget :budget between :start and :end',
    'set_budget_limit'                          => 'Nastavte částku rozpočtu',
    'budget_period_navigator'                   => 'Navigátor',
    'info_on_available_amount'                  => 'Co mám(e) k dispozici?',
    'available_amount_indication'               => 'Use these amounts to get an indication of what your total budget could be.',
    'suggested'                                 => 'Navrhované',
    'average_between'                           => 'Průměr mezi :start a :end',
    'transferred_in'                            => 'Převedeno (k nám)',
    'transferred_away'                          => 'Převedeno (pryč)',
    'auto_budget_none'                          => 'Bez automatického rozpočtu',
    'auto_budget_reset'                         => 'Nastavit pravidelnou částku každé období',
    'auto_budget_rollover'                      => 'Přidat částku každé období',
    'auto_budget_adjusted'                      => 'Přidat částku každé období a opravit ji při přečerpání',
    'auto_budget_period_daily'                  => 'Denně',
    'auto_budget_period_weekly'                 => 'Týdně',
    'auto_budget_period_monthly'                => 'Měsíčně',
    'auto_budget_period_quarterly'              => 'Čtvrletně',
    'auto_budget_period_half_year'              => 'Každého půl roku',
    'auto_budget_period_yearly'                 => 'Ročně',
    'auto_budget_help'                          => 'Více informací o této funkci zjistíte v nápovědě. Klikněte na ikonu vpravo nahoře (?).',
    'auto_budget_reset_icon'                    => 'This budget will be set periodically',
    'auto_budget_rollover_icon'                 => 'The budget amount will increase periodically',
    'auto_budget_adjusted_icon'                 => 'The budget amount will increase periodically and will correct for overspending',
    'remove_budgeted_amount'                    => 'Remove budgeted amount in :currency',

    // bills:
    'left_to_pay_active_bills'                  => 'active, expected and not yet paid subscriptions',
    'left_to_pay_lc'                            => 'left to pay',
    'less_than_expected'                        => 'less than expected',
    'more_than_expected'                        => 'more than expected',
    'skip_help_text'                            => 'Použijte toho pole pro ob-měsíční (1) nebo vyšší interval.',
    'subscription'                              => 'Pravidelná platba',
    'not_expected_period'                       => 'Ve vybraném období neočekáváno',
    'subscriptions_in_group'                    => 'Subscriptions in group "{{title}}"',
    'subscr_expected_x_times'                   => 'Expect to pay {{amount}} {{times}} times this period',
    'not_or_not_yet'                            => 'Zatím ne',
    'visit_bill'                                => 'Visit subscription ":name" at Firefly III',
    'visit_bills'                               => 'Visit subscriptions at Firefly III',
    'match_between_amounts'                     => 'Pravidelná platba odpovídá transakcím mezi :low a :high.',
    'running_again_loss'                        => 'Previously linked transactions to this subscription may lose their connection, if they (no longer) match the rule(s).',
    'bill_related_rules'                        => 'Rules related to this subscription',
    'repeats'                                   => 'Opakuje se',
    'bill_end_date_help'                        => 'Volitelné pole. Pravidelná platba bude končit v tomtu datu.',
    'bill_extension_date_help'                  => 'Volitelné pole. Pravidelná platba musí být prodloužena nebo zrušena nejpozději v toto datum.',
    'bill_end_index_line'                       => 'This subscription ends on :date',
    'bill_extension_index_line'                 => 'This subscription must be extended or cancelled on :date',
    'connected_journals'                        => 'Propojené transakce',
    'auto_match_on'                             => 'Automaticky spárováno Firefly III',
    'auto_match_off'                            => 'Not automatically matched by Firefly III',
    'next_expected_match'                       => 'Příští očekávaná shoda',
    'delete_bill'                               => 'Delete subscription ":name"',
    'deleted_bill'                              => 'Deleted subscription ":name"',
    'edit_bill'                                 => 'Edit subscription ":name"',
    'more'                                      => 'Více',
    'rescan_old'                                => 'Spustit pravidla znovu, na všechny transakce',
    'update_bill'                               => 'Aktualizovat pravidelnou platbu',
    'updated_bill'                              => 'Pravidelná platba ":name" byla aktualizována',
    'store_new_bill'                            => 'Uložit novou pravidelnou platbu',
    'stored_new_bill'                           => 'Uložit novou pravidelnou platbu „:name“',
    'cannot_scan_inactive_bill'                 => 'Inactive subscriptions cannot be scanned.',
    'rescanned_bill'                            => 'Rescanned everything, and linked :count transaction to the subscription.|Rescanned everything, and linked :count transactions to the subscription.',
    'average_bill_amount_year'                  => 'Průměrná částka (:year:)',
    'average_bill_amount_overall'               => 'Průměrná částka (celkem)',
    'bill_is_active'                            => 'Pravidelná platba je aktivní',
    'bill_expected_between'                     => 'Očekáváno mezi :start a :end',
    'bill_will_automatch'                       => 'Subscription will automatically linked to matching transactions',
    'skips_over'                                => 'přeskočí přes',
    'bill_store_error'                          => 'An unexpected error occurred while storing your new subscription. Please check the log files',
    'list_inactive_rule'                        => 'neaktivní pravidlo',
    'bill_edit_rules'                           => 'Firefly III will attempt to edit the rule related to this subscription as well. If you\'ve edited this rule yourself however, Firefly III won\'t change anything.|Firefly III will attempt to edit the :count rules related to this subscription as well. If you\'ve edited these rules yourself however, Firefly III won\'t change anything.',
    'bill_expected_date'                        => 'Očekáváme :date',
    'bill_expected_date_js'                     => 'Expected {date}',
    'expected_amount'                           => '(Expected) amount',
    'bill_paid_on'                              => 'Paid on {date}',
    'bill_repeats_weekly'                       => 'Repeats weekly',
    'bill_repeats_monthly'                      => 'Repeats monthly',
    'bill_repeats_quarterly'                    => 'Repeats quarterly',
    'bill_repeats_half-year'                    => 'Repeats every half year',
    'bill_repeats_yearly'                       => 'Repeats yearly',
    'bill_repeats_weekly_other'                 => 'Repeats every other week',
    'bill_repeats_monthly_other'                => 'Opakuje se každý druhý měsíc',
    'bill_repeats_quarterly_other'              => 'Repeats every other quarter',
    'bill_repeats_half-year_other'              => 'Repeats yearly',
    'bill_repeats_yearly_other'                 => 'Repeats every other year',
    'bill_repeats_weekly_skip'                  => 'Repeats every {skip} weeks',
    'bill_repeats_monthly_skip'                 => 'Opakuje se každých {skip} měsíců',
    'bill_repeats_quarterly_skip'               => 'Repeats every {skip} quarters',
    'bill_repeats_half-year_skip'               => 'Repeats every {skip} half years',
    'bill_repeats_yearly_skip'                  => 'Repeats every {skip} years',
    'subscriptions'                             => 'Pravidelné platby',
    'go_to_subscriptions'                       => 'Jít k pravidelným platbám',
    'forever'                                   => 'Forever',
    'extension_date_is'                         => 'Extension date is {date}',

    // accounts:
    'account_locked_currency'                   => 'Měna pro tento účet musí zůstat :name, protože je k němu propojena pokladnička.',
    'i_am_owed_amount'                          => 'Je mi dlužena částka',
    'i_owe_amount'                              => 'I owe amount',
    'inactive_account_link'                     => 'Máte :count neaktivní (archivovaný) účet, který si můžete zobrazit na samostatné stránce.|Máte :count neaktivních (archivovaných) účtů, které si můžete zobrazit na samostatné stránce.',
    'all_accounts_inactive'                     => 'These are your inactive accounts.',
    'active_account_link'                       => 'This link goes back to your active accounts.',
    'account_missing_transaction'               => 'Account #:id (":name") cannot be viewed directly, but Firefly is missing redirect information.',
    'cc_monthly_payment_date_help'              => 'Select any year and any month, it will be ignored anyway. Only the day of the month is relevant.',
    'details_for_asset'                         => 'Podrobnosti o účtu aktiv „:name“',
    'details_for_expense'                       => 'Podrobnosti pro výdajový účet „:name“',
    'details_for_revenue'                       => 'Details for revenue account ":name"',
    'details_for_cash'                          => 'Podrobnosti o hotovostním účtu „:name“',
    'store_new_asset_account'                   => 'Uložit nový účet aktiv',
    'store_new_expense_account'                 => 'Uložit nový výdajový účet',
    'store_new_revenue_account'                 => 'Uložit nový příjmový účet',
    'edit_asset_account'                        => 'Upravit účet aktiv „:name“',
    'edit_expense_account'                      => 'Upravit výdajový účet „:name“',
    'edit_revenue_account'                      => 'Upravit účet odměn „:name“',
    'delete_asset_account'                      => 'Smazat účet aktiv „:name“',
    'delete_expense_account'                    => 'Delete expense account ":name"',
    'delete_revenue_account'                    => 'Delete revenue account ":name"',
    'delete_liabilities_account'                => 'Smazat závazek „:name“',
    'asset_deleted'                             => 'Successfully deleted asset account ":name"',
    'account_deleted'                           => 'Successfully deleted account ":name"',
    'expense_deleted'                           => 'Successfully deleted expense account ":name"',
    'revenue_deleted'                           => 'Successfully deleted revenue account ":name"',
    'update_asset_account'                      => 'Aktualizovat výdajový účet',
    'update_undefined_account'                  => 'Update account',
    'update_liabilities_account'                => 'Aktualizovat závazek',
    'update_expense_account'                    => 'Aktualizovat výdajový účet',
    'update_revenue_account'                    => 'Aktualizovat příjmový účet',
    'make_new_asset_account'                    => 'Vytvořit nový účet aktiv',
    'make_new_expense_account'                  => 'Vytvořit výdajový účet',
    'make_new_revenue_account'                  => 'Vytvořit nový příjmový účet',
    'make_new_liabilities_account'              => 'Vytvořit nový závazek',
    'asset_accounts'                            => 'Účty aktiv',
    'undefined_accounts'                        => 'Accounts',
    'asset_accounts_inactive'                   => 'Asset accounts (inactive)',
    'expense_account'                           => 'Expense account',
    'expense_accounts'                          => 'Výdajové účty',
    'expense_accounts_inactive'                 => 'Výdajové účty (neaktivní)',
    'revenue_account'                           => 'Revenue account',
    'revenue_accounts'                          => 'Příjmové účty',
    'revenue_accounts_inactive'                 => 'Příjmové účty (neaktivní)',
    'cash_accounts'                             => 'Hotovostní účty',
    'Cash account'                              => 'Hotovostní účet',
    'liabilities_accounts'                      => 'Závazky',
    'liabilities_accounts_inactive'             => 'Závazky (neaktivní)',
    'reconcile_account'                         => 'Vyúčtovat účet ":account"',
    'overview_of_reconcile_modal'               => 'Přehled rekonciliace',
    'delete_reconciliation'                     => 'Odstranit vyúčtování',
    'update_reconciliation'                     => 'Upravit vyúčtování',
    'amount_cannot_be_zero'                     => 'Částka nemůže být nula',
    'end_of_reconcile_period'                   => 'Konec zúčtovacího období: :period',
    'start_of_reconcile_period'                 => 'Začátek zúčtovacího období: :period',
    'start_balance'                             => 'Počáteční zůstatek',
    'end_balance'                               => 'Konečný zůstatek',
    'update_balance_dates_instruction'          => 'Vyberte data a zůstatky a klikněte na "Spustit vyúčtování"',
    'select_transactions_instruction'           => 'Select the transactions that appear on your bank statement.',
    'select_range_and_balance'                  => 'Vyplňte data a zůstatky. Poté klikněte na "Spustit vyúčtování"',
    'date_change_instruction'                   => 'If you change the date range now, any progress will be lost.',
    'update_selection'                          => 'Aktualizovat výběr',
    'store_reconcile'                           => 'Uložit vyúčtování',
    'reconciliation_transaction'                => 'Reconciliation transaction',
    'Reconciliation'                            => 'Vyúčtování',
    'reconciliation'                            => 'Vyúčtování',
    'reconcile_options'                         => 'Možnosti vyúčtování',
    'reconcile_range'                           => 'Rozsah vyúčtování',
    'start_reconcile'                           => 'Spustit vyúčtování',
    'cash_account_type'                         => 'Hotovost',
    'cash'                                      => 'hotovost',
    'cant_find_redirect_account'                => 'Firefly III tried to redirect you but couldn\'t. Sorry about that. Back to the index.',
    'account_type'                              => 'Typ účtu',
    'save_transactions_by_moving'               => 'Save this transaction by moving it to another account:|Save these transactions by moving them to another account:',
    'save_transactions_by_moving_js'            => 'No transactions|Save this transaction by moving it to another account. |Save these transactions by moving them to another account.',
    'stored_new_account'                        => 'Nový účet „:name“ uložen!',
    'stored_new_account_js'                     => 'New account "<a href="accounts/show/{ID}">{name}</a>" stored!',
    'updated_account'                           => 'Aktualizován účet „:name“',
    'updated_account_js'                        => 'Updated account "<a href="accounts/show/{ID}">{title}</a>".',
    'credit_card_options'                       => 'Předvolby kreditní karty',
    'no_transactions_account'                   => 'Ve vybraném období neproběhly na majetkovém účtu ":name" žádné transakce.',
    'no_transactions_period'                    => 'Neexistují žádné transakce (v tomto období).',
    'no_data_for_chart'                         => 'Pro vytvoření tohoto grafu zatím není dostatek informací.',
    'select_at_least_one_account'               => 'Vyberte alespoň jeden účet aktiv',
    'select_at_least_one_category'              => 'Vyberte alespoň jednu kategorii',
    'select_at_least_one_budget'                => 'Vyberte alespoň jeden rozpočet',
    'select_at_least_one_tag'                   => 'Vyberte alespoň jeden štítek',
    'select_at_least_one_expense'               => 'Please select at least one combination of expense/revenue accounts. If you have none (the list is empty) this report is not available.',
    'account_default_currency'                  => 'Toto bude výchozí měna přiřazená k tomuto účtu.',
    'piggy_default_currency'                    => 'Pokladničky mohou obsahovat jen jednu měnu.',
    'piggy_account_currency_match'              => 'Budou přijaty pouze účty, které používají dříve vybranou měnu.',
    'reconcile_has_more'                        => 'Your Firefly III ledger has more money in it than your bank claims you should have. There are several options. Please choose what to do. Then, press "Confirm reconciliation".',
    'reconcile_has_less'                        => 'Your Firefly III ledger has less money in it than your bank claims you should have. There are several options. Please choose what to do. Then, press "Confirm reconciliation".',
    'reconcile_is_equal'                        => 'Your Firefly III ledger and your bank statements match. There is nothing to do. Please press "Confirm reconciliation" to confirm your input.',
    'create_pos_reconcile_transaction'          => 'Clear the selected transactions, and create a correction adding :amount to this asset account.',
    'create_neg_reconcile_transaction'          => 'Clear the selected transactions, and create a correction removing :amount from this asset account.',
    'reconcile_do_nothing'                      => 'Clear the selected transactions, but do not correct.',
    'reconcile_go_back'                         => 'Opravu můžete kdykoli upravit nebo odstranit.',
    'must_be_asset_account'                     => 'You can only reconcile asset accounts',
    'reconciliation_stored'                     => 'Vyúčtování uloženo',
    'reconciliation_error'                      => 'Due to an error the transactions were marked as reconciled but the correction has not been stored: :error.',
    'reconciliation_transaction_title'          => 'Reconciliation (:from to :to)',
    'sum_of_reconciliation'                     => 'Sum of reconciliation',
    'reconcile_this_account'                    => 'Vyúčtovat tento účet',
    'reconcile'                                 => 'Reconcile',
    'show'                                      => 'Show',
    'confirm_reconciliation'                    => 'Potvrdit vyúčtování',
    'submitted_start_balance'                   => 'Předložený počáteční zůstatek',
    'selected_transactions'                     => 'Vybrané transakce (:count)',
    'already_cleared_transactions'              => 'Already cleared transactions (:count)',
    'submitted_end_balance'                     => 'Předložený konečný zůstatek',
    'initial_balance_description'               => 'Počáteční zůstatek pro „:account“',
    'liability_credit_description'              => 'Liability credit for ":account"',
    'interest_calc_'                            => 'neznámé',
    'interest_calc_daily'                       => 'Za den',
    'interest_calc_monthly'                     => 'Za měsíc',
    'interest_calc_yearly'                      => 'Za rok',
    'interest_calc_weekly'                      => 'Per week',
    'interest_calc_half-year'                   => 'Per half year',
    'interest_calc_quarterly'                   => 'Per quarter',
    'initial_balance_account'                   => 'Initial balance account of :account',
    'list_options'                              => 'Seznam možností',
    'account_column_opt_drag_and_drop'          => 'Drag and drop',
    'account_column_opt_active'                 => 'Active',
    'account_column_opt_name'                   => 'Name',
    'account_column_opt_type'                   => 'Type',
    'account_column_opt_liability_type'         => 'Liability type',
    'account_column_opt_liability_direction'    => 'Liability direction',
    'account_column_opt_liability_interest'     => 'Liability interest',
    'account_column_opt_number'                 => 'Account number',
    'account_column_opt_current_balance'        => 'Current balance',
    'account_column_opt_amount_due'             => 'Amount due',
    'account_column_opt_last_activity'          => 'Last activity',
    'account_column_opt_balance_difference'     => 'Balance difference',
    'account_column_opt_menu'                   => 'Menu',

    // categories:
    'new_category'                              => 'Nová kategorie',
    'create_new_category'                       => 'Vytvořit novou kategorii',
    'without_category'                          => 'Bez kategorie',
    'update_category'                           => 'Aktualizovat kategorii',
    'updated_category'                          => 'Aktualizována kategorie „:name“',
    'categories'                                => 'Kategorie',
    'edit_category'                             => 'Upravit kategorii „:name“',
    'no_category'                               => '(žádná kategorie)',
    'unknown_category_plain'                    => 'No category',
    'category'                                  => 'Kategorie',
    'delete_category'                           => 'Smazat kategorii „:name“',
    'deleted_category'                          => 'Kategorie „:name“ smazána',
    'store_category'                            => 'Uložit novou kategori',
    'stored_category'                           => 'Uložena nová kategorie „:name“',
    'without_category_between'                  => 'Bez kategorie mezi :start a :end',


    // transactions:
    'wait_loading_transaction'                  => 'Please wait for the form to load',
    'wait_loading_data'                         => 'Please wait for your information to load...',
    'wait_attachments'                          => 'Please wait for the attachments to upload.',
    'errors_upload'                             => 'The upload has failed. Please check your browser console for the error.',
    'amount_foreign_if'                         => 'Amount in foreign currency, if any',
    'amount_destination_account'                => 'Amount in the currency of the destination account',
    'edit_transaction_title'                    => 'Edit transaction ":description"',
    'unreconcile'                               => 'Undo reconciliation',
    'update_withdrawal'                         => 'Aktualizovat výběr',
    'update_deposit'                            => 'Aktualizovat vklad',
    'update_transaction'                        => 'Aktualizovat transakci',
    'update_transfer'                           => 'Aktualizovat převod',
    'updated_withdrawal'                        => 'Aktualizován výběr „:description“',
    'updated_deposit'                           => 'Aktualizován vklad „:description“',
    'updated_transfer'                          => 'Aktualizován převod „:description“',
    'no_changes_withdrawal'                     => 'Withdrawal ":description" was not changed.',
    'no_changes_deposit'                        => 'Deposit ":description" was not changed.',
    'no_changes_transfer'                       => 'Transfer ":description" was not changed.',
    'delete_withdrawal'                         => 'Smazat výběr „:description“',
    'delete_deposit'                            => 'Smazat vklad „:description“',
    'delete_transfer'                           => 'Smazat převod „:description“',
    'deleted_withdrawal'                        => 'Úspěšně smazán výběr „:description“',
    'deleted_deposit'                           => 'Úspěšně smazán vklad „:description“',
    'deleted_transfer'                          => 'Úspěšně smazán převod „:description“',
    'deleted_reconciliation'                    => 'Successfully deleted reconciliation transaction ":description"',
    'stored_journal'                            => 'Úspěšně vytvořena nová transakce „:description“',
    'stored_journal_js'                         => 'Successfully created new transaction "{{description}}"',
    'stored_journal_no_descr'                   => 'Successfully created your new transaction',
    'updated_journal_no_descr'                  => 'Successfully updated your transaction',
    'select_transactions'                       => 'Vybrat transakce',
    'rule_group_select_transactions'            => 'Apply ":title" to transactions',
    'rule_select_transactions'                  => 'Apply ":title" to transactions',
    'stop_selection'                            => 'Zastavit označování transakcí',
    'reconcile_selected'                        => 'Reconcile',
    'mass_delete_journals'                      => 'Smazat počet transakcí',
    'mass_edit_journals'                        => 'Upravit počet transakcí',
    'mass_bulk_journals'                        => 'Hromadná úprava počtu transakcí',
    'mass_bulk_journals_explain'                => 'This form allows you to change properties of the transactions listed below in one sweeping update. All the transactions in the table will be updated when you change the parameters you see here.',
    'part_of_split'                             => 'This transaction is part of a split transaction. If you have not selected all the splits, you may end up with changing only half the transaction.',
    'bulk_set_new_values'                       => 'Zde můžete nastavit nové hodnoty. Vyprázdnit je můžete nevyplněným polem. Výběrům můžete přiřadit rozpočet.',
    'no_bulk_category'                          => 'Neaktualizovat kategorii',
    'no_bulk_budget'                            => 'Neaktualizovat rozpočet',
    'no_bulk_tags'                              => 'Neaktualizovat štítky',
    'replace_with_these_tags'                   => 'Nahradit těmito štítky',
    'append_these_tags'                         => 'Přidat tyto štítky',
    'mass_edit'                                 => 'Edit selected individually',
    'bulk_edit'                                 => 'Hromadná úprava označeného',
    'mass_delete'                               => 'Smazat označené',
    'cannot_edit_other_fields'                  => 'Více hodnot nejde upravovat najednou, protože by se sem nevešly. Transakce upravte jednu po druhé.',
    'cannot_change_amount_reconciled'           => 'Není možné měnit hodnoty transakcí které jsou již zúčtované.',
    'no_budget'                                 => '(žádný rozpočet)',
    'no_bill'                                   => '(bez pravidelné platby)',
    'account_per_budget'                        => 'Účty pro jednotlivé rozpočty',
    'account_per_category'                      => 'Účty pro jednotlivé kategorie',
    'create_new_object'                         => 'Vytvořit',
    'empty'                                     => '(prázdné)',
    'all_other_budgets'                         => '(všechny ostatní rozpočty)',
    'all_other_accounts'                        => '(všechny ostatní účty)',
    'expense_per_source_account'                => 'Výdaje podle zdrojového účtu',
    'expense_per_destination_account'           => 'Výdaje podle cílového účtu',
    'income_per_destination_account'            => 'Příjmy podle cílového účtu',
    'spent_in_specific_category'                => 'Utraceno v kategorii „:category“',
    'earned_in_specific_category'               => 'Získáno v kategorii „:category“',
    'spent_in_specific_tag'                     => 'Utraceno pod štítkem „:tag“',
    'earned_in_specific_tag'                    => 'Získáno pod štítkem „:tag“',
    'income_per_source_account'                 => 'Příjem podle zdrojového účtu',
    'average_spending_per_destination'          => 'Průměrný výdaj podle cílového účtu',
    'average_spending_per_source'               => 'Průměrný výdaj podle zdrojového účtu',
    'average_earning_per_source'                => 'Průměrný příjem v jednotlivých zdrojových účtech',
    'average_earning_per_destination'           => 'Průměrný příjem v jednotlivých cílových účtech',
    'account_per_tag'                           => 'Účty pod jednotlivými štítky',
    'tag_report_expenses_listed_once'           => 'Výdaje a příjmy nikdy nejsou vypsány dvakrát. Pokud má transakce vícero štítků, zobrazí se pouze pod jedním z nich. Může se zdát, že na seznamu chybí údaje, ale částky budou správné.',
    'double_report_expenses_charted_once'       => 'Výdaje a příjmy nikdy nejsou zobrazeny dvakrát. Pokud má transakce vícero štítků, zobrazí se pouze pod jedním z nich. Může se zdát, že tento graf postrádá některé údaje, ale částky budou správné.',
    'tag_report_chart_single_tag'               => 'This chart applies to a single tag. If a transaction has multiple tags, what you see here may be reflected in the charts of other tags as well.',
    'tag'                                       => 'Štítek',
    'no_budget_squared'                         => '(žádný rozpočet)',
    'perm-delete-many'                          => 'Deleting many items in one go can be very disruptive. Please be cautious. You can delete part of a split transaction from this page, so take care.',
    'mass_deleted_transactions_success'         => 'Deleted :count transaction.|Deleted :count transactions.',
    'mass_edited_transactions_success'          => 'Updated :count transaction.|Updated :count transactions.',
    'opt_group_'                                => '(žádný typ účtu)',
    'opt_group_no_account_type'                 => '(žádný typ účtu)',
    'opt_group_defaultAsset'                    => 'Výchozí majetkový účet',
    'opt_group_savingAsset'                     => 'Spořicí účty',
    'opt_group_sharedAsset'                     => 'Sdílené účty aktiv',
    'opt_group_ccAsset'                         => 'Kreditní karty',
    'opt_group_cashWalletAsset'                 => 'Peněženky',
    'opt_group_expense_account'                 => 'Účty pro výdaje',
    'opt_group_revenue_account'                 => 'Účty pro příjmy',
    'opt_group_l_Loan'                          => 'Závazek: Půjčka',
    'opt_group_cash_account'                    => 'Hotovostní účet',
    'opt_group_l_Debt'                          => 'Závazek: Dluh',
    'opt_group_l_Mortgage'                      => 'Závazek: hypotéka',
    'opt_group_l_Credit card'                   => 'Závazek: kreditní karta',
    'notes'                                     => 'Poznámky',
    'view_notes'                                => 'View notes',
    'set_budget_limit_notes'                    => 'View the notes for this budgeted amount',
    'edit_bl_notes'                             => 'Edit notes',
    'update_bl_notes'                           => 'Update notes',
    'unknown_journal_error'                     => 'Transakci se nedaří uložit. Podívejte se do souborů se záznamy událostí.',
    'attachment_not_found'                      => 'Tuto přílohu se nepodařilo najít.',
    'journal_link_bill'                         => 'This transaction is linked to subscription <a href=":route">:name</a>. To remove the connection, uncheck the checkbox. Use rules to connect it to another subscription.',
    'transaction_stored_link'                   => '<a href="transactions/show/{ID}">Transakce #{ID} ("{title}")</a> byla uložena.',
    'transaction_new_stored_link'               => '<a href="transactions/show/{ID}">Transakce #{ID}</a> byla uložena.',
    'transaction_updated_link'                  => '<a href="transactions/show/{ID}">Transaction #{ID}</a> ("{title}") has been updated.',
    'transaction_updated_no_changes'            => '<a href="transactions/show/{ID}">Transaction #{ID}</a> ("{title}") did not receive any changes.',
    'first_split_decides'                       => 'The first split determines the value of this field',
    'first_split_overrules_source'              => 'The first split may overrule the source account',
    'first_split_overrules_destination'         => 'The first split may overrule the destination account',
    'spent_x_of_y'                              => 'Spent {amount} of {total}',

    // new user:
    'welcome'                                   => 'Vítejte ve Firefly III!',
    'submit'                                    => 'Potvrdit',
    'submission'                                => 'Položka',
    'submit_yes_really'                         => 'Potvrdit (vím, co dělám)',
    'getting_started'                           => 'Začínáme',
    'to_get_started'                            => 'Jsme rádi, že jste úspěšně nainstalovali Firefly III. Začněte přidáním názvu vaší banky a zůstatek na vašem hlavním běžném účtu. Nebojte se, pokud máte více účtů – budete je moci přidat později. Firefly III jen potřebuje něco, s čím může začít.',
    'savings_balance_text'                      => 'Firefly III pro vás automaticky vytvoří spořicí účet. Ve výchozím nastavení v něm nebudou žádné peníze – to můžete změnit níže.',
    'finish_up_new_user'                        => 'To je vše! Pokračujte stisknutím tlačítka <strong>Potvrdit</strong>. Budete předměrováni na hlavní stránku Firefly III.',
    'stored_new_accounts_new_user'              => 'Yay! Your new accounts have been stored.',
    'set_preferred_language'                    => 'Pokud si přejete používat Firefly III v jiném jazyce, můžete si jej zde zvolit.',
    'language'                                  => 'Jazyk',
    'new_savings_account'                       => ':bank_name spořící účet',
    'cash_wallet'                               => 'Peněženka',
    'currency_not_present'                      => 'Pokud nevidíte měnu, kterou běžně používáte, nebojte se. V nabídce Možnosti > Měny si můžete vytvořit vlastní měny.',

    // home page:
    'transaction_table_description'             => 'A table containing your transactions',
    'opposing_account'                          => 'Protiúčet',
    'yourAccounts'                              => 'Vaše účty',
    'your_accounts'                             => 'Přehled vašeho účtu',
    'category_overview'                         => 'Přehled kategorie',
    'expense_overview'                          => 'Přehled výdajových účtů',
    'revenue_overview'                          => 'Přehled příjmových účtů',
    'budgetsAndSpending'                        => 'Rozpočty a útraty',
    'budgets_and_spending'                      => 'Rozpočty a útraty',
    'go_to_budget'                              => 'Přejít na rozpočet „{budget}“',
    'go_to_deposits'                            => 'Přejít na vklady',
    'go_to_expenses'                            => 'Přejít na výdaje',
    'savings'                                   => 'Úspory',
    'newWithdrawal'                             => 'Nový výdaj',
    'newDeposit'                                => 'Nový vklad',
    'newTransfer'                               => 'Nový převod',
    'bills_to_pay'                              => 'Pravidelné platby k zaplacení',
    'per_day'                                   => 'Za den',
    'left_to_spend_per_day'                     => 'Zbývá na denní útratu',
    'bills_paid'                                => 'Zaplacené pravidelné platby',
    'custom_period'                             => 'Vlastní období',
    'reset_to_current'                          => 'Obnovit aktuální období',
    'select_period'                             => 'Vyberte období',

    // menu and titles, should be recycled as often as possible:
    'currency'                                  => 'Měna',
    'preferences'                               => 'Předvolby',
    'logout'                                    => 'Odhlásit se',
    'logout_other_sessions'                     => 'Odhlásit na všech ostatních zařízeních',
    'toggleNavigation'                          => 'Vyp/zap. navigaci',
    'toggle_dropdown'                           => 'Toggle dropdown',
    'searchPlaceholder'                         => 'Hledat…',
    'version'                                   => 'Verze',
    'dashboard'                                 => 'Přehled',
    'income_and_expense'                        => 'Income and expense',
    'all_money'                                 => 'All your money',
    'unknown_source_plain'                      => 'Unknown source account',
    'unknown_dest_plain'                        => 'Unknown destination account',
    'unknown_any_plain'                         => 'Unknown account',
    'unknown_budget_plain'                      => 'No budget',
    'available_budget'                          => 'Rozpočet k dispozici ({currency})',
    'currencies'                                => 'Měny',
    'activity'                                  => 'Aktivita',
    'usage'                                     => 'Použití',
    'accounts'                                  => 'Účty',
    'Asset account'                             => 'Účet aktiv',
    'Default account'                           => 'Účet aktiv',
    'Expense account'                           => 'Výdajový účet',
    'Revenue account'                           => 'Příjmový účet',
    'Initial balance account'                   => 'Účet počátečního zůstatku',
    'account_type_Asset account'                => 'Asset account',
    'account_type_Expense account'              => 'Expense account',
    'account_type_Revenue account'              => 'Revenue account',
    'account_type_Debt'                         => 'Dluh',
    'account_type_Loan'                         => 'Půjčka',
    'account_type_Mortgage'                     => 'Hypotéka',
    'account_type_debt'                         => 'Debt',
    'account_type_loan'                         => 'Loan',
    'account_type_mortgage'                     => 'Mortgage',
    'account_type_Credit card'                  => 'Kreditní karta',
    'credit_card_type_monthlyFull'              => 'Plná platba každý měsíc',
    'liability_direction_credit'                => 'Je mi dlužen tento dluh',
    'liability_direction_debit'                 => 'Dlužím tento dluh někomu jinému',
    'liability_direction_credit_short'          => 'Tento dluh je mi dlužen',
    'liability_direction_debit_short'           => 'Tento dluh dlužím',
    'liability_direction__short'                => 'Unknown',
    'liability_direction_null_short'            => 'Unknown',
    'Liability credit'                          => 'Liability credit',
    'budgets'                                   => 'Rozpočty',
    'tags'                                      => 'Štítky',
    'reports'                                   => 'Přehledy',
    'transactions'                              => 'Transakce',
    'expenses'                                  => 'Výdaje',
    'income'                                    => 'Výnos/příjem',
    'transfers'                                 => 'Převody',
    'moneyManagement'                           => 'Správa peněz',
    'money_management'                          => 'Správa peněz',
    'tools'                                     => 'Nástroje',
    'piggyBanks'                                => 'Pokladničky',
    'piggy_banks'                               => 'Pokladničky',
    'amount_x_of_y'                             => '{current} z {total}',
    'bills'                                     => 'Pravidelné platby',
    'withdrawal'                                => 'Výběr',
    'opening_balance'                           => 'Počáteční zůstatek',
    'deposit'                                   => 'Vklad',
    'account'                                   => 'Účet',
    'transfer'                                  => 'Převod',
    'Withdrawal'                                => 'Výběr',
    'Deposit'                                   => 'Vklad',
    'Transfer'                                  => 'Převod',
    'bill'                                      => 'Pravidelná platba',
    'yes'                                       => 'Ano',
    'no'                                        => 'Ne',
    'amount'                                    => 'Částka',
    'overview'                                  => 'Přehled',
    'saveOnAccount'                             => 'Uložit na účet',
    'saveOnAccounts'                            => 'Save on account(s)',
    'unknown'                                   => 'Neznámé',
    'monthly'                                   => 'Měsíčně',
    'profile'                                   => 'Profil',
    'errors'                                    => 'Chyby',
    'debt_start_date'                           => 'Datum začátku dluhu',
    'debt_start_amount'                         => 'Počáteční výše dluhu',
    'debt_start_amount_help'                    => 'Doporučujeme tuto hodnotu nastavit na negativnÍ částku. Pro více informací klikněte na nápovědu (ikona (?) v pravém horním rohu).',
    'interest_period_help'                      => 'Toto pole je zde pro ozdobu a nebude pro vás vypočítáváno. Zjistili jsme že banky jsou nepředvídatelné a Firefly III ho nikdy nezvládne spočítat správně.',
    'store_new_liabilities_account'             => 'Uložit nový závazek',
    'edit_liabilities_account'                  => 'Upravit závazek „:name“',
    'financial_control'                         => 'Finanční kontrola',
    'accounting'                                => 'Účetnictví',
    'automation'                                => 'Automatizace',
    'others'                                    => 'Ostatní',
    'classification'                            => 'Klasifikace',
    'store_transaction'                         => 'Store transaction',


    // reports:
    'quick_link_needs_accounts'                 => 'In order to generate reports, you need to add at least one asset account to Firefly III.',
    'report_default'                            => 'Výchozí finanční výkaz v období :start a :end',
    'report_audit'                              => 'Přehled historie transakcí mezi :start a :end',
    'report_category'                           => 'Výkaz kategorie z rozmezí :start a :end',
    'report_double'                             => 'Přehled výdajů/příjmů v účtu mezi :start a :end',
    'report_budget'                             => 'Budget report between :start and :end',
    'report_tag'                                => 'Tag report between :start and :end',
    'quick_link_reports'                        => 'Rychlé odkazy',
    'quick_link_examples'                       => 'Toto jsou pouze příklady pro začátek. Pro informace o všech přehledech a slovech, která můžete použít, navštivte nápovědu pod ikonou (?).',
    'quick_link_default_report'                 => 'Výchozí výkaz o financích',
    'quick_link_audit_report'                   => 'Přehled historie transakcí',
    'report_this_month_quick'                   => 'Stávající měsíc, všechny účty',
    'report_last_month_quick'                   => 'Minulý měsíc, všechny účty',
    'report_this_year_quick'                    => 'Stávající rok, všechny účty',
    'report_this_fiscal_year_quick'             => 'Stávající fiskální rok, všechny účty',
    'report_all_time_quick'                     => 'Kdykoli, všechny účty',
    'reports_can_bookmark'                      => 'Pamatujte, že výkazy je možné si ukládat do záložek.',
    'incomeVsExpenses'                          => 'Příjmy a výdaje',
    'accountBalances'                           => 'Zůstatky účtů',
    'balanceStart'                              => 'Zůstatek na začátku období',
    'balanceEnd'                                => 'Zůstatek na konci období',
    'splitByAccount'                            => 'Rozúčtování podle účtů',
    'coveredWithTags'                           => 'Pokryto štítky',
    'leftInBudget'                              => 'Zbývá v rozpočtu',
    'left_in_debt'                              => 'Amount due',
    'sumOfSums'                                 => 'Souhrn součtů',
    'noCategory'                                => '(bez kategorie)',
    'notCharged'                                => 'Zatím nestrženo',
    'inactive'                                  => 'Neaktivní',
    'active'                                    => 'Aktivní',
    'difference'                                => 'Rozdíl',
    'money_flowing_in'                          => 'Vstup',
    'money_flowing_out'                         => 'Výstup',
    'topX'                                      => 'nej :number',
    'show_full_list'                            => 'Zobrazit celý seznam',
    'show_only_top'                             => 'Zobrazit pouze :number nej',
    'report_type'                               => 'Typ přehledu',
    'report_type_default'                       => 'Výchozí výkaz o financích',
    'report_type_audit'                         => 'Přehled historie transakcí (audit)',
    'report_type_category'                      => 'Výkaz o kategorii',
    'report_type_budget'                        => 'Sestava rozpočtu',
    'report_type_tag'                           => 'Přehled značek',
    'report_type_double'                        => 'Přehled výdajů/příjmů v účtu',
    'more_info_help'                            => 'Další informace o těchto typech přehledů najdete na stránkách nápovědy. Stiskněte ikonu (?) v pravém horním rohu.',
    'report_included_accounts'                  => 'Zahrnuté účty',
    'report_date_range'                         => 'Období',
    'report_preset_ranges'                      => 'Přednastavené rozsahy',
    'shared'                                    => 'Sdíleno',
    'fiscal_year'                               => 'Fiskální rok',
    'income_entry'                              => 'Příjmy z účtu „:name“ mezi :start a :end',
    'expense_entry'                             => 'Výdaje z účtu „:name“ v rozmezí :start a :end',
    'category_entry'                            => 'Výdaje a příjmy na účtu „:name“ v rozmezí :start a :end',
    'budget_spent_amount'                       => 'Výdaje z rozpočtu „:budget“ v rozmezí :start a :end',
    'balance_amount'                            => 'Výdaje z rozpočtu „:budget“ placené z účtu „:account“ v období :start a :end',
    'no_audit_activity'                         => 'No activity was recorded on account <a href=":url" title=":account_name">:account_name</a> between :start and :end.',
    'audit_end_balance'                         => 'Zůstatek účtu <a href=":url" title=":account_name">:account_name</a> ke konci :end byl :balance',
    'reports_extra_options'                     => 'Další volby',
    'report_has_no_extra_options'               => 'Tento výkaz nemá žádné další volby',
    'reports_submit'                            => 'Zobrazit výkaz',
    'end_after_start_date'                      => 'Je třeba, aby konečné datum výkazu bylo později, než to počáteční.',
    'select_category'                           => 'Vybrat kategorie',
    'select_budget'                             => 'Vybrat rozpočty',
    'select_tag'                                => 'Vybrat štítky',
    'income_per_category'                       => 'Příjem podle kategorie',
    'expense_per_category'                      => 'Výdaje podle kategorie',
    'expense_per_budget'                        => 'Výdaje podle rozpočtu',
    'income_per_account'                        => 'Příjem podle účtu',
    'expense_per_account'                       => 'Výdaj podle účtu',
    'expense_per_tag'                           => 'Výdaje podle štítku',
    'income_per_tag'                            => 'Příjmy podle štítku',
    'include_expense_not_in_budget'             => 'Included expenses not in the selected budget(s)',
    'include_expense_not_in_account'            => 'Included expenses not in the selected account(s)',
    'include_expense_not_in_category'           => 'Included expenses not in the selected category(ies)',
    'include_income_not_in_category'            => 'Included income not in the selected category(ies)',
    'include_income_not_in_account'             => 'Included income not in the selected account(s)',
    'include_income_not_in_tags'                => 'Included income not in the selected tag(s)',
    'include_expense_not_in_tags'               => 'Included expenses not in the selected tag(s)',
    'everything_else'                           => 'Všechno ostatní',
    'income_and_expenses'                       => 'Příjmy a výdaje',
    'spent_average'                             => 'Utraceno (průměrně)',
    'income_average'                            => 'Získáno (průměrně)',
    'transaction_count'                         => 'Počet transakcí',
    'average_spending_per_account'              => 'Průměrné výdaje na účet',
    'average_income_per_account'                => 'Průměrný příjem v jednotlivých účtech',
    'total'                                     => 'Celkem',
    'description'                               => 'Popis',
    'sum_of_period'                             => 'Souhrn období',
    'average_in_period'                         => 'Průměr období',
    'no_account_role'                           => '(no role)',
    'account_role_defaultAsset'                 => 'Výchozí účet aktiv',
    'account_role_sharedAsset'                  => 'Sdílený účet aktiv',
    'account_role_savingAsset'                  => 'Spořicí účet',
    'account_role_ccAsset'                      => 'Kreditní karta',
    'account_role_cashWalletAsset'              => 'Peněženka',
    'budget_chart_click'                        => 'Graf zobrazíte kliknutím na název rozpočtu ve výše uvedené tabulce.',
    'category_chart_click'                      => 'Graf zobrazíte kliknutím na název kategorie ve výše uvedené tabulce.',
    'in_out_accounts'                           => 'Earned and spent per combination',
    'in_out_accounts_per_asset'                 => 'Earned and spent (per asset account)',
    'in_out_per_category'                       => 'Získáno a vydáno v jednotlivých kategoriích',
    'out_per_budget'                            => 'Vydáno v jednotlivých rozpočtech',
    'select_expense_revenue'                    => 'Vybrat účet výdajů/odměn',
    'multi_currency_report_sum'                 => 'Protože tento seznam obsahuje účty v různých měnách, nedávají zobrazované součty smysl. Výkaz vždy náhradně použije měnu, kterou máte nastavenou jako výchozí.',
    'sum_in_default_currency'                   => 'Souhrn vždy bude v měně, kterou jste nastavili jako výchozí.',
    'net_filtered_prefs'                        => 'This chart will never include accounts that have the "Include in net worth"-option unchecked.',


    // charts:
    'chart'                                     => 'Graf',
    'month'                                     => 'Měsíc',
    'budget'                                    => 'Rozpočet',
    'spent'                                     => 'Utraceno',
    'spent_capped'                              => 'Spent (capped)',
    'spent_in_budget'                           => 'Utraceno v rozpočtu',
    'left_to_spend'                             => 'Zbývá k utracení',
    'earned'                                    => 'Vyděláno',
    'overspent'                                 => 'Překročeny výdaje',
    'left'                                      => 'Zbývá',
    'max-amount'                                => 'Maximální částka',
    'min-amount'                                => 'Minimální částka',
    'journal-amount'                            => 'Current subscription entry',
    'name'                                      => 'Název',
    'expires_at'                                => 'Expires at',
    'date'                                      => 'Datum',
    'date_and_time'                             => 'Datum a čas',
    'time'                                      => 'Čas',
    'paid'                                      => 'Zaplaceno',
    'unpaid'                                    => 'Nezaplaceno',
    'day'                                       => 'Den',
    'budgeted'                                  => 'Rozpočet',
    'period'                                    => 'Období',
    'balance'                                   => 'Zůstatek',
    'in_out_period'                             => 'Za toto období',
    'sum'                                       => 'Součet',
    'summary'                                   => 'Souhrn',
    'average'                                   => 'Průměr',
    'balanceFor'                                => 'Zůstatek na :name',
    'no_tags'                                   => '(žádné štítky)',
    'nothing_found'                             => '(nothing found)',

    // page settings and wizard dialogs

    'page_settings_header'          => 'Page settings',
    'visible_columns'               => 'Visible columns',
    'accounts_to_show'              => 'Accounts to show',
    'active_accounts_only'          => 'Active accounts only',
    'in_active_accounts_only'       => 'Inactive accounts only',
    'show_all_accounts'             => 'Show all accounts',
    'group_accounts'                => 'Group accounts',

    // piggy banks:
    'event_history'                 => 'Event history',
    'add_money_to_piggy'            => 'Vložit peníze do pokladničky ":name"',
    'piggy_bank'                    => 'Pokladnička',
    'new_piggy_bank'                => 'Nová pokladnička',
    'store_piggy_bank'              => 'Uložit novou pokladničku',
    'stored_piggy_bank'             => 'Uložit novou pokladničku „:name“',
    'account_status'                => 'Stav účtu',
    'left_for_piggy_banks'          => 'Zbývá pro pokladničky',
    'sum_of_piggy_banks'            => 'Součet pokladniček',
    'saved_so_far'                  => 'Doposud naspořeno',
    'saved_so_far_total'            => 'Saved so far in total',
    'reset_history'                 => 'reset history',
    'reset_history_confirm'         => 'Are you sure you want to reset the history of this piggy bank? This will make the chart match the piggy bank\'s amount again.',
    'piggy_history_reset'           => 'The piggy bank history has been reset',
    'left_to_save'                  => 'Zbývá pro spoření',
    'suggested_amount'              => 'Doporučené měsíční částka do úspor',
    'add_money_to_piggy_title'      => 'Vložit peníze do pokladničky ":name"',
    'remove_money_from_piggy_title' => 'Vybrat peníze z pokladničky ":name"',
    'add'                           => 'Přidat',
    'no_money_for_piggy'            => 'Nejsou žádné peníze, které by se daly vložit do této pokladničky.',
    'suggested_savings_per_month'   => 'Doporučeno na měsíc',

    'remove'                    => 'Odebrat',
    'max_amount_add'            => 'Nejvyšší částka, kterou je možné přidat je',
    'max_amount_remove'         => 'Nejvyšší částka, kterou je možné odebrat je',
    'update_piggy_button'       => 'Aktualizovat pokladničku',
    'update_piggy_title'        => 'Aktualizovat pokladničku ":name"',
    'updated_piggy_bank'        => 'Aktualizována pokladnička „:name“',
    'details'                   => 'Podrobnosti',
    'events'                    => 'Události',
    'target_amount'             => 'Cílová částka',
    'start_date'                => 'Datum zahájení',
    'no_start_date'             => 'Žádné datum začátku',
    'target_date'               => 'Cílové datum',
    'no_target_date'            => 'Žádné cílové datum',
    'table'                     => 'Tabulka',
    'delete_piggy_bank'         => 'Smazat pokladničku ":name"',
    'cannot_add_amount_piggy'   => 'Nedaří se přidat :amount do „:name“.',
    'cannot_remove_from_piggy'  => 'Could not remove :amount from ":name".',
    'deleted_piggy_bank'        => 'Pokladnička ":name" smazána',
    'added_amount_to_piggy'     => ':amount přidáno do „:name“',
    'removed_amount_from_piggy' => ':amount odebráno z „:name“',
    'piggy_events'              => 'Související pokladničky',

    // tags
    'delete_tag'                => 'Smazat štítek „:tag“',
    'deleted_tag'               => 'Smazán štítek „:tag“',
    'new_tag'                   => 'Vytvořit nový štítek',
    'edit_tag'                  => 'Upravit štítek „:tag“',
    'updated_tag'               => 'Aktualizován štítek „:tag“',
    'created_tag'               => 'Štítek „:tag“ byl vytvořen.',

    'transaction_journal_information'               => 'Informace o transakci',
    'transaction_journal_amount'                    => 'Amount information',
    'transaction_journal_meta'                      => 'Meta informace',
    'transaction_journal_more'                      => 'Další informace',
    'basic_journal_information'                     => 'Basic transaction information',
    'transaction_journal_extra'                     => 'Více informací',
    'att_part_of_journal'                           => 'Uloženo pod „:journal“',
    'total_amount'                                  => 'Celková částka',
    'number_of_decimals'                            => 'Počet desetinných míst',


    // administration
    'invite_is_already_redeemed'                    => 'The invite to ":address" has already been redeemed.',
    'invite_is_deleted'                             => 'The invite to ":address" has been deleted.',
    'invite_new_user_title'                         => 'Invite new user',
    'invite_new_user_text'                          => 'As an administrator, you can invite users to register to your Firefly III installation. Using the direct link you can share with them, they will be able to register an account. The invited user and their invite link will appear in the table below. You are free to share the invitation link with them.',
    'invited_user_mail'                             => 'E-mailová adresa',
    'invite_user'                                   => 'Invite user',
    'user_is_invited'                               => 'E-mailová adresa „:address“ byla pozvána do Firefly III',
    'administration'                                => 'Správa',
    'system_settings'                               => 'Nastavení aplikace',
    'code_already_used'                             => 'Invite code has been used',
    'user_administration'                           => 'Správa uživatelů',
    'list_all_users'                                => 'Všichni uživatelé',
    'all_users'                                     => 'Všichni uživatelé',
    'instance_configuration'                        => 'Nastavení',
    'firefly_instance_configuration'                => 'Nastavení Firefly III',
    'setting_single_user_mode'                      => 'Režim pro jediného uživatele',
    'setting_single_user_mode_explain'              => 'Ve výchozím stavu Firefly III přijme pouze jednu (1) registraci – vás. Toto je bezpečnostní opatření, bránící ostatním použít vaši instanci, dokud jim to nepovolíte. Další registrace jsou blokovány. Pokud tuto volbu deaktivujete, budou moci tuto instanci použít i jiní uživatelé, za předpokladu, že je jim dostupná (když je připojena k internetu).',
    'store_configuration'                           => 'Uložit nastavení',
    'single_user_administration'                    => 'Správa uživatele pro :email',
    'edit_user'                                     => 'Upravit uživatele :email',
    'hidden_fields_preferences'                     => 'Další vlastnosti transakcí můžete zaznamenat když je zapnete v <a href="preferences">nastavení</a>.',
    'user_data_information'                         => 'Uživatelská data',
    'user_information'                              => 'Informace o uživateli',
    'total_size'                                    => 'celková velikost',
    'budget_or_budgets'                             => ':count budget|:count budgets',
    'budgets_with_limits'                           => ':count budget with configured amount|:count budgets with configured amount',
    'nr_of_rules_in_total_groups'                   => ':count_rules rule(s) in :count_groups rule group(s)',
    'tag_or_tags'                                   => ':count tag|:count tags',
    'configuration_updated'                         => 'Nastavení bylo aktualizováno',
    'setting_is_demo_site'                          => 'Demostránka',
    'setting_is_demo_site_explain'                  => 'Při zapnutí této možnosti se bude Firefly III chovat jako demo, což může mít zvláštní vedlejší efekty.',
    'block_code_bounced'                            => 'E-mailové zprávy se vrátily jako nedoručitelné',
    'block_code_expired'                            => 'Platnost demoúčtu skončila',
    'no_block_code'                                 => 'Není důvod pro blokování nebo uživatel není blokován',
    'demo_user_export'                              => 'The demo user cannot export data',
    'block_code_email_changed'                      => 'Uživatel ještě nepotvrdil svou e-mailovou adresu',
    'admin_update_email'                            => 'Narozdíl od profilové stránky uživatel NEBUDE upozorněn na změnu své e-mailové adresy!',
    'update_user'                                   => 'Aktualizovat uživatele',
    'updated_user'                                  => 'Data uživatele byla změněna.',
    'delete_user'                                   => 'Smazat uživatele :email',
    'user_deleted'                                  => 'Uživatel byl smazán',
    'send_test_email'                               => 'Poslat zkušební e-mail',
    'send_test_email_text'                          => 'To see if your installation is capable of sending a notification, please press this button. You will not see an error here (if any), <strong>the log files will reflect any errors</strong>. You can press this button as many times as you like. There is no spam control. The message will be sent to <code>:email</code> and should arrive shortly.',
    'send_message'                                  => 'Poslat zprávu',
    'send_test_triggered'                           => 'Test was triggered. Check your inbox and the log files.',
    'give_admin_careful'                            => 'Users who are given admin rights can take away yours. Be careful.',
    'admin_maintanance_title'                       => 'Údržba',
    'admin_maintanance_expl'                        => 'Několik šikovných tlačítek pro údržbu Firefly III',
    'admin_maintenance_clear_cache'                 => 'Vymazat mezipaměť',
    'owner_notifications'                           => 'Administrátorská upozornění',
    'owner_notifications_expl'                      => 'The following notifications can be enabled or disabled by the administrator. It will be sent over ALL configured channels. Some channels are configured in your environment variables, others can be set here.',
    'channel_settings'                              => 'Settings for notification channels',
    'notification_test_failed'                      => 'Test upozornění pro kanál „:channel“ selhal. Více informací najdete v protokolech.',
    'notification_test_executed'                    => 'Test upozornění pro kanál „:channel“ byl vykonán. Více informací najdete v protokolech.',
    'settings_notifications'                        => 'Nastavení upozornění',
    'title_owner_notifications'                     => 'Upozornění majiteli',
    'owner_notification_check_user_new_reg'         => 'User gets post-registration welcome message',
    'owner_notification_check_admin_new_reg'        => 'Administrator(s) get new user registration notification',
    'owner_notification_check_new_version'          => 'Je dostupná nová verze',
    'owner_notification_check_invite_created'       => 'A user is invited to Firefly III',
    'owner_notification_check_invite_redeemed'      => 'A user invitation is redeemed',
    'owner_notification_check_unknown_user_attempt' => 'An unknown user tries to login',
    'all_invited_users'                             => 'All invited users',
    'save_notification_settings'                    => 'Save settings',
    'notification_settings'                         => 'Nastavení upozornění',
    'notification_settings_saved'                   => 'The notification settings have been saved',
    'available_channels_title'                      => 'Available channels',
    'available_channels_expl'                       => 'Zde je seznam způsobů posílání upozornění. Pro otestování nastavení použijte tlačítka níže. Pozor, nemají protispamovou ochranu.',
    'notification_channel_name_email'               => 'E-mail',
    'slack_discord_double'                          => 'Nastavení pro Slack funguje také pro Discord.',
    'notification_channel_name_slack'               => 'Slack',
    'notification_channel_name_ntfy'                => 'Ntfy.sh',
    'notification_channel_name_pushover'            => 'Pushover',
    'notification_channel_name_gotify'              => 'Gotify',
    'notification_channel_name_pushbullet'          => 'Pushbullet',
    'channel_not_available'                         => 'nedostupné',
    'configure_channel_in_env'                      => 'potřebuje proměnné prostředí',
    'test_notification_channel_name_email'          => 'Otestovat e-mail',
    'test_notification_channel_name_slack'          => 'Otestovat Slack',
    'test_notification_channel_name_ntfy'           => 'Test Ntfy.sh',
    'test_notification_channel_name_pushover'       => 'Otestovat Pushover',
    'test_notification_channel_name_gotify'         => 'Test Gotify',
    'test_notification_channel_name_pushbullet'     => 'Test Pushbullet',

    'split_transaction_title'               => 'Popis rozúčtování',
    'split_transaction_title_help'          => 'Každá rozdělená transakce musí mít společný popis.',
    'split_title_help'                      => 'Pokud vytvoříte rozúčtování, je třeba, aby zde byl celkový popis pro všechna rozúčtování dané transakce.',
    'you_create_transfer'                   => 'Vytváříte převod.',
    'you_create_withdrawal'                 => 'Vytváříte výběr.',
    'you_create_deposit'                    => 'Vytváříte vklad.',

    // links
    'journal_link_configuration'            => 'Nastavení odkazů transakcí',
    'create_new_link_type'                  => 'Vytvořit nový typ odkazu',
    'store_new_link_type'                   => 'Uložit nový typ odkazu',
    'update_link_type'                      => 'Aktualizovat typ propojení',
    'edit_link_type'                        => 'Upravit odkaz typu „:name“',
    'updated_link_type'                     => 'Updated link type ":name"',
    'delete_link_type'                      => 'Delete link type ":name"',
    'deleted_link_type'                     => 'Deleted link type ":name"',
    'stored_new_link_type'                  => 'Store new link type ":name"',
    'cannot_edit_link_type'                 => 'Cannot edit link type ":name"',
    'link_type_help_name'                   => 'Ie. "Duplicates"',
    'link_type_help_inward'                 => 'tj. „duplicity“',
    'link_type_help_outward'                => 'Ie. "is duplicated by"',
    'save_connections_by_moving'            => 'Save the link between these transactions by moving them to another link type:',
    'do_not_save_connection'                => '(neukládat spojení)',
    'link_transaction'                      => 'Propojit transakci',
    'link_to_other_transaction'             => 'Propojit tuto transakci s jinou',
    'select_transaction_to_link'            => 'Select a transaction to link this transaction to. The links are currently unused in Firefly III (apart from being shown), but I plan to change this in the future. Use the search box to select a transaction either by title or by ID. If you want to add custom link types, check out the settings.',
    'this_transaction'                      => 'Tato transakce',
    'transaction'                           => 'Transakce',
    'comments'                              => 'Komentáře',
    'link_notes'                            => 'Any notes you wish to store with the link.',
    'invalid_link_selection'                => 'Tyto transakce nelze propojit',
    'selected_transaction'                  => 'Vybraná transakce',
    'journals_linked'                       => 'Transakce jsou propojeny.',
    'journals_error_linked'                 => 'Tyto transakce už jsou propojené.',
    'journals_link_to_self'                 => 'Není možné propojit transakci s ní samotnou',
    'journal_links'                         => 'Odkazy transakcí',
    'this_withdrawal'                       => 'Tento výběr',
    'this_deposit'                          => 'Tento vklad',
    'this_transfer'                         => 'Tento převod',
    'overview_for_link'                     => 'Přehled pro typ odkazu „:name“',
    'source_transaction'                    => 'Zdrojová transakce',
    'link_description'                      => 'Popis odkazu',
    'destination_transaction'               => 'Cílová transakce',
    'delete_journal_link'                   => 'Delete the link between <a href=":source_link">:source</a> and <a href=":destination_link">:destination</a>',
    'deleted_link'                          => 'Smazaný odkaz',

    // link translations:
    'Paid_name'                             => 'Zaplaceno',
    'Refund_name'                           => 'Vrácení peněz',
    'Reimbursement_name'                    => 'Náhrada',
    'Related_name'                          => 'Související',
    'relates to_inward'                     => 'souvisí s',
    'is (partially) refunded by_inward'     => 'is (partially) refunded by',
    'is (partially) paid for by_inward'     => 'is (partially) paid for by',
    'is (partially) reimbursed by_inward'   => 'is (partially) reimbursed by',
    'inward_transaction'                    => 'Inward transaction',
    'outward_transaction'                   => 'Outward transaction',
    'relates to_outward'                    => 'souvisí s',
    '(partially) refunds_outward'           => '(partially) refunds',
    '(partially) pays for_outward'          => '(partially) pays for',
    '(partially) reimburses_outward'        => '(partially) reimburses',
    'is (partially) refunded by'            => 'is (partially) refunded by',
    'is (partially) paid for by'            => 'is (partially) paid for by',
    'is (partially) reimbursed by'          => 'is (partially) reimbursed by',
    'relates to'                            => 'souvisí s',
    '(partially) refunds'                   => '(partially) refunds',
    '(partially) pays for'                  => '(partially) pays for',
    '(partially) reimburses'                => '(partially) reimburses',

    // split a transaction:
    'splits'                                => 'Rozúčtování',
    'add_another_split'                     => 'Přidat další rozúčtování',
    'cannot_edit_opening_balance'           => 'You cannot edit the opening balance of an account.',
    'no_edit_multiple_left'                 => 'You have selected no valid transactions to edit.',
    'breadcrumb_convert_group'              => 'Převést transakci',
    'convert_invalid_source'                => 'Zdrojové informace jsou neplatné pro transakci #%d.',
    'convert_invalid_destination'           => 'Cílové informace jsou neplatné pro transakci #%d.',
    'create_another'                        => 'Po uložení se vrátit sem pro vytvoření další.',
    'after_update_create_another'           => 'Po aktualizaci se vrátit sem pro pokračování v úpravách.',
    'store_as_new'                          => 'Vytvořit novou transakci místo aktualizování té současné.',
    'reset_after'                           => 'Po odeslání vymazat obsah formuláře',
    'errors_submission'                     => 'There was something wrong with your submission. Please check out the errors below.',
    'errors_submission_v2'                  => 'There was something wrong with your submission. Please check out the errors below: {{errorMessage}}',
    'transaction_expand_split'              => 'Expand split',
    'transaction_remove_split'              => 'Remove split',
    'transaction_collapse_split'            => 'Collapse split',

    // object groups
    'default_group_title_name'              => '(neseskupeno)',
    'default_group_title_name_plain'        => 'ungrouped',

    // empty lists? no objects? instructions:
    'no_accounts_title_asset'               => 'Vytvořme účet aktiv!',
    'no_accounts_intro_asset'               => 'Zatím nemáte žádné účty aktiv. Jedná se o vaše hlavní účty: váš běžný účet, spořicí účet, sdílený účet i vaši kreditní kartu.',
    'no_accounts_imperative_asset'          => 'Abyste mohli začít používat Firefly III, musíte si vytvořit alespoň jeden účet aktiv. Pojďme na to:',
    'no_accounts_create_asset'              => 'Vytvořit nový účet',
    'no_accounts_title_expense'             => 'Vytvořme výdajový účet!',
    'no_accounts_intro_expense'             => 'Doposud jste nevytvořily žádné účty pro výdaje. Tyto účty jsou tím, kde utrácíte peníze, jako například obchody a supermarkety.',
    'no_accounts_imperative_expense'        => 'Expense accounts are created automatically when you create transactions, but you can create one manually too, if you want. Let\'s create one now:',
    'no_accounts_create_expense'            => 'Vytvořit výdajový účet',
    'no_accounts_title_revenue'             => 'Vytvořme příjmový účet!',
    'no_accounts_intro_revenue'             => 'Doposud jste ještě nevytvořili žádné příjmové účty. Příjmové účty jsou místa, ze kterých dostáváte peníze – například váš zaměstnavatel.',
    'no_accounts_imperative_revenue'        => 'Revenue accounts are created automatically when you create transactions, but you can create one manually too, if you want. Let\'s create one now:',
    'no_accounts_create_revenue'            => 'Vytvořit příjmový účet',
    'no_accounts_title_liabilities'         => 'Pojďme vytvořit závazek!',
    'no_accounts_intro_liabilities'         => 'Zatím nemáte žádné závazky. Ty jsou účty které registrují vaše půjčky a ostatní dluhy.',
    'no_accounts_imperative_liabilities'    => 'Tuto funkci nemusíte používat, ale hodí se pokud si chcete držet přehled v těchto věcech.',
    'no_accounts_create_liabilities'        => 'Vytvořit závazek',
    'no_budgets_title_default'              => 'Pojďme vytvořit rozpočet',
    'no_rules_title_default'                => 'Pojďme vytvořit pravidlo',
    'no_budgets_intro_default'              => 'Zatím nemáte žádné rozpočty. Rozpočty slouží k organizaci vašich výdajů do logických skupin, kterým můžete nastavit posouvatelný limit, kterým omezíte své výdaje.',
    'no_rules_intro_default'                => 'You have no rules yet. Rules are powerful automations that can handle transactions for you.',
    'no_rules_imperative_default'           => 'Rules can be very useful when you\'re managing transactions. Let\'s create one now:',
    'no_budgets_imperative_default'         => 'Rozpočty jsou základní nástroje správy financí. Pojďme takový vytvořit:',
    'no_budgets_create_default'             => 'Vytvořit rozpočet',
    'no_rules_create_default'               => 'Vytvořit pravidlo',
    'no_categories_title_default'           => 'Pojďme vytvořit kategorii!',
    'no_categories_intro_default'           => 'Zatím nemáte žádné kategorie. Můžete je použít k doladění vašich transakcí a jejich rozřazení do nastavených kategorií.',
    'no_categories_imperative_default'      => 'Kategorie jsou vytvářeny automaticky po vytvoření transakce, můžete ji ale přidat i ručně. Pojďme na to:',
    'no_categories_create_default'          => 'Vytvořit kategorii',
    'no_tags_title_default'                 => 'Pojďme vytvořit štítek!',
    'no_tags_intro_default'                 => 'Zatím jste nezadali nevytvořili žádné štítky. Ty slouží k doladění vašich transakcí a označují je konkrétními klíčovými slovy.',
    'no_tags_imperative_default'            => 'Štítky jsou vytvořeny automaticky při vytvoření transkace, můžete je ale vytvořit i ručně. Pojďme na to:',
    'no_tags_create_default'                => 'Vytvořit štítek',
    'no_transactions_title_withdrawal'      => 'Pojďme vytvořit výdaj!',
    'no_transactions_intro_withdrawal'      => 'You have no expenses yet. You should create expenses to start managing your finances.',
    'no_transactions_imperative_withdrawal' => 'Have you spent some money? Then you should write it down:',
    'no_transactions_create_withdrawal'     => 'Vytvořit výdaj',
    'no_transactions_title_deposit'         => 'Pojďme vytvořit nějaký příjem!',
    'no_transactions_intro_deposit'         => 'You have no recorded income yet. You should create income entries to start managing your finances.',
    'no_transactions_imperative_deposit'    => 'Have you received some money? Then you should write it down:',
    'no_transactions_create_deposit'        => 'Vytvořit vklad',
    'no_transactions_title_transfers'       => 'Pojďme vytvořit převod!',
    'no_transactions_intro_transfers'       => 'You have no transfers yet. When you move money between asset accounts, it is recorded as a transfer.',
    'no_transactions_imperative_transfers'  => 'Have you moved some money around? Then you should write it down:',
    'no_transactions_create_transfers'      => 'Vytvořit převod',
    'no_piggies_title_default'              => 'Pojďme vytvořit pokladničku!',
    'no_piggies_intro_default'              => 'Zatím nemáte žádné pokladničky. Můžete si je vytvořit pro rozdělení svých úspor tak abyste věděli na co si šetříte.',
    'no_piggies_imperative_default'         => 'Máte si na co šetřit? Vytvořte si pokladničku a sledujte ji:',
    'no_piggies_create_default'             => 'Vytvořit novou pokladničku',
    'no_bills_title_default'                => 'Pojďme vytvořit pravidelnou platbu!',
    'no_bills_intro_default'                => 'Zatím nemáte žádné pravidelné platby. Můžete si je vytvořit pro sledování svých pravidelných výdajů, jako je nájem nebo pojištění.',
    'no_bills_imperative_default'           => 'Máte nějaký pravidelný výdaj? Vytvořte si jej zde a sledujte své platby:',
    'no_bills_create_default'               => 'Vytvořit pravidelnou platbu',

    // recurring transactions
    'recurrence_max_count'                  => 'This recurring transactions will be created at most :max time(s), and has been created :count time(s) already.',
    'create_right_now'                      => 'Create right now',
    'no_new_transaction_in_recurrence'      => 'No new transaction was created. Perhaps it was already fired for this date?',
    'recurrences'                           => 'Opakované transakce',
    'repeat_until_in_past'                  => 'This recurring transaction stopped repeating on :date.',
    'recurring_calendar_view'               => 'Kalendář',
    'no_recurring_title_default'            => 'Pojďme vytvořit opakovanou transakci!',
    'no_recurring_intro_default'            => 'Zatím nemáte žádné opakované transakce. Můžete je použít pro automatické vytváření transakcí.',
    'no_recurring_imperative_default'       => 'Jedná se o poměrně pokročilou funkci, která ale může být nesmírně užitečná. Před pokračováním si nezapomeňte přečíst dokumentaci (ikona (?) v pravém horním rohu).',
    'no_recurring_create_default'           => 'Vytvořit opakovanou transakci',
    'make_new_recurring'                    => 'Vytvořit opakovanou transakci',
    'recurring_daily'                       => 'Každý den',
    'recurring_weekly'                      => 'Každý týden v :weekday',
    'recurring_weekly_skip'                 => 'Every :skip(st/nd/rd/th) week on :weekday',
    'recurring_monthly'                     => 'Každý měsíc :dayOfMonth.',
    'recurring_monthly_skip'                => 'Každý :skip. měsíc :dayOfMonth. dne',
    'recurring_ndom'                        => 'Každý měsíc v :weekday :dayOfMonth.',
    'recurring_ndom_skip'                   => 'Every :skip(st/nd/rd/th) month on the :dayOfMonth(st/nd/rd/th) :weekday',
    'recurring_yearly'                      => 'Každý rok v :date',
    'overview_for_recurrence'               => 'Přehled pro opakovanou transakci „:title“',
    'warning_duplicates_repetitions'        => 'In rare instances, dates appear twice in this list. This can happen when multiple repetitions collide. Firefly III will always generate one transaction per day.',
    'created_transactions'                  => 'Související transakce',
    'expected_withdrawals'                  => 'Očekávané výběry',
    'expected_deposits'                     => 'Očekávané vklady',
    'expected_transfers'                    => 'Očekávané převody',
    'created_withdrawals'                   => 'Vytvořené výběry',
    'created_deposits'                      => 'Vytvořené vklady',
    'created_transfers'                     => 'Vytvořené převody',
    'recurring_info'                        => 'Recurring transaction :count / :total',
    'created_from_recurrence'               => 'Created from recurring transaction ":title" (#:id)',
    'recurring_never_cron'                  => 'Vypadá to že cron job, který je potřebný pro opakované transakce, nebyl nikdy spuštěn. To je normální pokud jste zrovna Firefly III nainstalovali, ale jde o věc na kterou byste se měli co nejdříve podívat. Prosím, zkontrolujte nápovědu použitím tlačítka (?) vpravo nahoře.',
    'recurring_cron_long_ago'               => 'It looks like it has been more than 36 hours since the cron job to support recurring transactions has fired for the last time. Are you sure it has been set up correctly? Please check out the help-pages using the (?)-icon in the top right corner of the page.',

    'create_new_recurrence'              => 'Vytvořit novou opakovanou transakci',
    'help_first_date'                    => 'Indicate the first expected recurrence. This must be in the future.',
    'help_first_date_no_past'            => 'Indicate the first expected recurrence. Firefly III will not create transactions in the past.',
    'no_currency'                        => '(žádná měna)',
    'mandatory_for_recurring'            => 'Nezbytné informace k opakovanosti',
    'mandatory_for_transaction'          => 'Povinné informace o transakci',
    'optional_for_recurring'             => 'Volitelné informace o opakovanosti',
    'optional_for_transaction'           => 'Volitelné informace o transakci',
    'change_date_other_options'          => 'Pro zobrazení více možností změňte „datum první“.',
    'mandatory_fields_for_tranaction'    => 'Hodnoty zadané zde se uloží do vytvořených transakcí',
    'click_for_calendar'                 => 'Klikněte sem pro zobrazení kalendáře, který vám zobrazí, kdy se transkace bude opakovat.',
    'repeat_forever'                     => 'Opakovat donekonečna',
    'repeat_until_date'                  => 'Opakovat do data',
    'repeat_times'                       => 'Zopakovat tolikrát',
    'recurring_skips_one'                => 'Každý druhý',
    'recurring_skips_more'               => 'Přeskočí :count výskytů',
    'store_new_recurrence'               => 'Uložit opakovanou transakci',
    'stored_new_recurrence'              => 'Recurring transaction ":title" stored successfully.',
    'edit_recurrence'                    => 'Edit recurring transaction ":title"',
    'recurring_repeats_until'            => 'Opakuje se do :date',
    'recurring_repeats_forever'          => 'Opakuje navždy',
    'recurring_repeats_x_times'          => 'Repeats :count time|Repeats :count times',
    'update_recurrence'                  => 'Aktualizovat opakovanou transakci',
    'updated_recurrence'                 => 'Updated recurring transaction ":title"',
    'recurrence_is_inactive'             => 'This recurring transaction is not active and will not generate new transactions.',
    'delete_recurring'                   => 'Delete recurring transaction ":title"',
    'new_recurring_transaction'          => 'Nová opakovaná transakce',
    'help_weekend'                       => 'Co by měla služba Firefly III dělat, pokud opakovaná transakce nastane v sobotu nebo v neděli?',
    'do_nothing'                         => 'Jen vytvořit transakci',
    'skip_transaction'                   => 'Přeskočit opakování',
    'jump_to_friday'                     => 'Namísto toho vytvořit transakci v předchozí pátek',
    'jump_to_monday'                     => 'Namísto toho vytvořit transakci v předchozí pondělí',
    'will_jump_friday'                   => 'Bude vytvořeno v pátek namísto víkendů.',
    'will_jump_monday'                   => 'Will be created on Monday instead of the weekends.',
    'except_weekends'                    => 'Vyjma výkendů',
    'recurrence_deleted'                 => 'Recurring transaction ":title" deleted',


    // new lines for summary controller.
    'box_balance_in_currency'            => 'Zůstatek (:currency)',
    'box_spent_in_currency'              => 'Utraceno (:currency)',
    'box_earned_in_currency'             => 'Vyděláno (:currency)',
    'box_budgeted_in_currency'           => 'Rozpočet (:currency)',
    'box_bill_paid_in_currency'          => 'Zaplacené pravidelné platby (:currency)',
    'box_bill_unpaid_in_currency'        => 'Nezaplacené pravidelné platby (:currency)',
    'box_left_to_spend_in_currency'      => 'Zbývá k utracení (:currency)',
    'box_net_worth_in_currency'          => 'Čisté jmění (:currency)',
    'box_spend_per_day'                  => 'Zbývá pro denní útratu: :amount',

    // debug page
    'debug_page'                         => 'Ladící stránka',
    'debug_submit_instructions'          => 'If you are running into problems, you can use the information in this box as debug information. Please copy-and-paste into a new or existing <a href="https://github.com/firefly-iii/firefly-iii/issues">GitHub issue</a>. It will generate a beautiful table that can be used to quickly diagnose your problem.',
    'debug_pretty_table'                 => 'If you copy/paste the box below into a GitHub issue it will generate a table. Please do not surround this text with backticks or quotes.',
    'debug_additional_data'              => 'You may also share the content of the box below. You can also copy-and-paste this into a new or existing <a href="https://github.com/firefly-iii/firefly-iii/issues">GitHub issue</a>. However, the content of this box may contain private information such as account names, transaction details or email addresses.',

    // object groups
    'object_groups_menu_bar'             => 'Skupiny',
    'object_groups_page_title'           => 'Skupiny',
    'object_groups_breadcrumb'           => 'Skupiny',
    'object_groups_index'                => 'Přehled',
    'object_groups'                      => 'Skupiny',
    'object_groups_empty_explain'        => 'Některé věci ve službě Firefly III lze rozřadit do skupin. Například pokladničky obsahují na stránkách pro vytvoření a pro úpravu pole „Skupina“. Pokud toto pole nastavíte, na této stránce budete moci upravovat názvy a pořadí skupin. Pro více informací se podívejte na stránky nápovědy v pravém horním rohu, pod ikonou (?).',
    'object_group_title'                 => 'Název',
    'edit_object_group'                  => 'Upravit skupinu „:title“',
    'delete_object_group'                => 'Odstranit skupinu „:title“',
    'update_object_group'                => 'Aktualizovat skupinu',
    'updated_object_group'               => 'Skupina „:title“ byla úspěšně aktualizována',
    'deleted_object_group'               => 'Skupina „:title“ byla úspěšně odstraněna',
    'object_group'                       => 'Skupina',

    // other stuff
    'placeholder'                        => '[Placeholder]',

    // audit log entries
    'audit_log_entries'                  => 'Audit log entries',
    'ale_action_log_add'                 => 'Přidáno :amount do pokladničky ":name"',
    'ale_action_log_remove'              => 'Odebráno :amount z pokladničky ":name"',
    'ale_action_clear_budget'            => 'Removed from budget',
    'ale_action_update_group_title'      => 'Updated transaction group title',
    'ale_action_update_date'             => 'Updated transaction date',
    'ale_action_update_order'            => 'Updated transaction order',
    'ale_action_clear_category'          => 'Removed from category',
    'ale_action_clear_notes'             => 'Removed notes',
    'ale_action_clear_tag'               => 'Cleared tag',
    'ale_action_clear_all_tags'          => 'Cleared all tags',
    'ale_action_set_bill'                => 'Linked to subscription',
    'ale_action_switch_accounts'         => 'Switched source and destination account',
    'ale_action_set_budget'              => 'Set budget',
    'ale_action_set_category'            => 'Set category',
    'ale_action_set_source'              => 'Set source account',
    'ale_action_set_destination'         => 'Set destination account',
    'ale_action_update_transaction_type' => 'Changed transaction type',
    'ale_action_update_notes'            => 'Changed notes',
    'ale_action_update_description'      => 'Changed description',
    'ale_action_add_to_piggy'            => 'Pokladnička',
    'ale_action_remove_from_piggy'       => 'Pokladnička',
    'ale_action_add_tag'                 => 'Added tag',
    'ale_action_update_amount'           => 'Updated amount',

    // dashboard
    'enable_auto_convert'                => 'Enable currency conversion',
    'disable_auto_convert'               => 'Disable currency conversion',
];
