<?php

namespace Jsvrcek\ICS\Tests\Model;

use Jsvrcek\ICS\Model\CalendarEvent;
use Jsvrcek\ICS\Exception\CalendarEventException;
use PHPUnit\Framework\TestCase;

/**
 * Generated by PHPUnit_SkeletonGenerator on 2013-10-20 at 12:03:54.
 */
class CalendarEventTest extends TestCase
{
    /**
     * @covers Jsvrcek\ICS\Model\CalendarEvent::setStart
     */
    public function testSetStart()
    {
        $start = new \DateTime();
        $object = new CalendarEvent;
        
        $object->setStart($start);
        
        // test start
        $this->assertEquals($start, $object->getStart());
        
        //test default end
        $this->assertEquals($start->add(\DateInterval::createFromDateString('30 minutes')), $object->getEnd());
    }

    /**
     * @covers Jsvrcek\ICS\Model\CalendarEvent::setEnd
     */
    public function testSetEndDateEarlierThanStart()
    {
        $this->expectException(CalendarEventException::class);
        $this->expectExceptionMessage('End DateTime must be greater than Start DateTime');

        $object = new CalendarEvent;

        $start = new \DateTime('now');
        $end = new \DateTime('yesterday');
        
        $object->setStart($start);
        $object->setEnd($end);
    }

    /**
     * @covers Jsvrcek\ICS\Model\CalendarEvent::setEnd
     */
    public function testSetEndWithoutStart()
    {
        $this->expectException(CalendarEventException::class);
        $this->expectExceptionMessage('You must set the Start time before setting the End Time of a CalendarEvent');

        $object = new CalendarEvent;

        $end = new \DateTime('yesterday');
        
        $object->setEnd($end);
    }
}
