"use strict";App.Pages.LdapSettings=function(){function isInvalid(){try{$("#ldap-settings .is-invalid").removeClass("is-invalid");var missingRequiredFields=!1;if($("#ldap-settings .required").each(function(index,requiredField){var $requiredField=$(requiredField);$requiredField.val()||($requiredField.addClass("is-invalid"),missingRequiredFields=!0)}),missingRequiredFields)throw new Error(lang("fields_are_required"));return!1}catch(error){return App.Layouts.Backend.displayNotification(error.message),!0}}function deserialize(ldapSettings){ldapSettings.forEach(function(ldapSetting){var $field=$("[data-field=\""+ldapSetting.name+"\"]");$field.is(":checkbox")?$field.prop("checked",!!+ldapSetting.value):$field.val(ldapSetting.value)})}function serialize(){var ldapSettings=[];return $("[data-field]").each(function(index,field){var $field=$(field);ldapSettings.push({name:$field.data("field"),value:$field.is(":checkbox")?+$field.prop("checked"):$field.val()})}),ldapSettings}function getLdapFieldMapping(){var jsonLdapFieldMapping=$ldapFieldMapping.val();return JSON.parse(jsonLdapFieldMapping)}function saveSettings(){if(isInvalid())return void App.Layouts.Backend.displayNotification(lang("settings_are_invalid"));var ldapSettings=serialize();return App.Http.LdapSettings.save(ldapSettings)}function searchServer(){$searchResults.empty();var keyword=$searchKeyword.val();keyword&&App.Http.LdapSettings.search(keyword).done(function(entries){return $searchResults.empty(),null!==entries&&void 0!==entries&&entries.length?void entries.forEach(function(entry){renderEntry(entry).appendTo($searchResults)}):void renderNoRecordsFound().appendTo($searchResults)})}function onSaveSettingsClick(){saveSettings().done(function(){App.Layouts.Backend.displayNotification(lang("settings_saved"))})}function onResetFilterClick(){$ldapFilter.val(vars("ldap_default_filter"))}function onResetFieldMappingClick(){var defaultFieldMapping=vars("ldap_default_field_mapping"),jsonDefaultFieldMapping=JSON.stringify(defaultFieldMapping,null,2);$ldapFieldMapping.val(jsonDefaultFieldMapping)}function onLdapImportClick(event){var $target=$(event.target),$card=$target.closest(".card"),entry=$card.data("entry"),ldapFieldMapping=getLdapFieldMapping();App.Components.LdapImportModal.open(entry,ldapFieldMapping).done(function(){App.Layouts.Backend.displayNotification(lang("user_imported"))})}function renderNoRecordsFound(){return $("\n            <div class=\"text-muted fst-italic\">\n                ".concat(lang("no_records_found"),"\n            </div>\n        "))}function renderEntry(entry){if(null!==entry&&void 0!==entry&&entry.dn){var $entry=$("\n            <div class=\"card small mb-2\">\n                <div class=\"card-header p-2 fw-bold\">\n                    ".concat(entry.dn,"\n                </div>\n                <div class=\"card-body p-2\">\n                    <p class=\"d-block mb-2\">").concat(lang("content"),"</p>\n                    \n                    <pre class=\"overflow-y-auto bg-light rounded p-2\" style=\"max-height: 200px\">").concat(JSON.stringify(entry,null,2),"</pre>\n                    \n                    <div class=\"d-lg-flex\">\n                        <button class=\"btn btn-outline-primary btn-sm px-4 ldap-import ms-lg-auto\">\n                            ").concat(lang("import"),"\n                        </button>\n                    </div>\n                </div>\n            </div>\n        "));return $entry.data("entry",entry),$entry}}function onSearchFormSubmit(event){event.preventDefault(),saveSettings().done(function(){searchServer()})}var $saveSettings=$("#save-settings"),$searchForm=$("#ldap-search-form"),$searchKeyword=$("#ldap-search-keyword"),$searchResults=$("#ldap-search-results"),$ldapFilter=$("#ldap-filter"),$ldapFieldMapping=$("#ldap-field-mapping"),$resetFilter=$("#ldap-reset-filter"),$resetFieldMapping=$("#ldap-reset-field-mapping");return document.addEventListener("DOMContentLoaded",function(){$saveSettings.on("click",onSaveSettingsClick),$resetFilter.on("click",onResetFilterClick),$resetFieldMapping.on("click",onResetFieldMappingClick),$searchForm.on("submit",onSearchFormSubmit),$searchResults.on("click",".ldap-import",onLdapImportClick);var ldapSettings=vars("ldap_settings");deserialize(ldapSettings)}),{}}();