<?php

namespace Drupal\ai_agents\Artifact;

/**
 * The artifact is a tool output that can be referenced in the chat history.
 *
 * Artifacts are used to store and reference data generated by AI tools.
 * They can be used to provide context or results from previous tool executions.
 */
interface ArtifactInterface extends \Stringable, \JsonSerializable {

  /**
   * Returns the tool ID that created this artifact.
   */
  public function getToolId(): string;

  /**
   * Returns the incremental index for this tool.
   */
  public function getIndex(): int;

  /**
   * Returns the value stored in the artifact.
   */
  public function getValue(): mixed;

  /**
   * Returns the UNIX timestamp of when the artifact was created.
   */
  public function getTimestamp(): int;

  /**
   * Returns the placeholder string used in chat history.
   */
  public function getPlaceholder(): string;

}
