# AI Automators Types Available

The Automator Types are the rules that can generate content on a field type using specific rules. This page has collected all of them to view.

| Module Name | Field Type | Module | Description |
|-------------|------------|--------|-------------|
| [LLM: Address](llm_address.md) | address | AI Automators | Extracts structured address data from unstructured text using AI. |
| [LLM: Audio to Text (with Summary)](llm_audio_text_with_summary.md) | text_with_summary | AI Automators | Provides AI-driven transcription of audio files into text. |
| [LLM: Audio to Text (String Long)](llm_audio_to_string_long.md) | string_long | AI Automators | Allows AI-driven transcription of audio files into plain text. |
| [LLM: Audio to Text (Text Long)](llm_audio_to_text_long.md) | text_long | AI Automators | Enables AI-based transcription of audio files into plain text. |
| [LLM: Boolean](llm_boolean.md) | boolean | AI Automators | Enables AI-powered extraction of boolean (true/false) values from unstructured text content. |
| [LLM: Chart From Text](llm_chart_from_text.md) | chart_config | AI Automators | Extracts structured chart data from unstructured text using AI. |
| [LLM: Custom Field](llm_custom_field.md) | custom | AI Automators | Designed for complex field structures where AI-generated data must fill multiple subfields. |
| [LLM: Decimal](llm_decimal.md) | decimal | AI Automators | Generates and stores decimal values for decimal fields using AI. |
| [LLM: Email](llm_email.md) | email | AI Automators | Extracts valid email addresses from context text using AI and stores them in an email field. |
| [LLM: Entity Reference](llm_entity_reference.md) | entity_reference | AI Automators | Uses AI to create referenced entities dynamically based on the context text of the parent entity. |
| [LLM: FAQ Field](llm_faq_field.md) | faqfield | AI Automators | Generates FAQ entries (question and answer pairs) using AI based on provided context. |
| [LLM: Float](llm_float.md) | float | AI Automators | Generates float (decimal) values using AI based on the provided context. |
| [LLM: Image Alt Text](llm_image_alt_text.md) | image | AI Automators | Generates descriptive alternative text (alt text) for image fields using AI. |
| [LLM: Integer](llm_integer.md) | integer | AI Automators | Uses AI to extract numeric values from contextual text and store them in integer fields. |
| [LLM: JSON Field](llm_json_field.md) | json | AI Automators | Automatically generates and stores structured JSON data in json fields. |
| [LLM: JSON Field (Native Binary)](llm_json_native_binary.md) | json_native_binary | AI Automators | Generates JSON data from context text and stores it in a json_native_binary field. |
| [LLM: JSON Field (Native)](llm_json_native.md) | json_native | AI Automators | Enables automatic population of json_native fields using AI-generated structured data. |
| [LLM: Link](llm_link.md) | link | AI Automators | Enables automatic extraction of valid links (URLs) and their optional titles from text fields. |
| [LLM: List (Float)](llm_list_float.md) | list_float | AI Automators | Enables automatic selection of the most appropriate float value from a predefined list. |
| [LLM: List (Integer)](llm_list_integer.md) | list_integer | AI Automators | Enables automatic selection of the most appropriate numeric option from a predefined list. |
| [LLM: List (String)](llm_list_string.md) | list_string | AI Automators | Helps automatically choose the most appropriate value from a predefined list based on content. |
| [LLM: Media Audio Generation](llm_media_audio_generation.md) | entity_reference | AI Automators | Creates audio files based on the text content of an entity and stores them in media entities. |
| [LLM: Media Image Generation](llm_media_image_generation.md) | entity_reference | AI Automators | Automatically creates media images based on the content's context using AI-powered text-to-image models. |
| [LLM: Metatag](llm_metatag.md) | metatag | AI Automators | Uses a large language model to automatically generate values for various metatag fields. |
| [LLM: Moderation State](llm_moderation_state.md) | string | AI Automators | Analyzes content and automatically determines the appropriate moderation state for an entity. |
| [LLM: Office Hours](llm_office_hours.md) | office_hours | AI Automators | Extracts and normalizes office hours from free-text context using AI chat models. |
| [LLM: Text (simple, String Long)](llm_simple_string_long.md) | string_long | AI Automators | Generates or transforms longer plain text strings using a simple language model chat interface. |
| [LLM: Text (simple, String)](llm_simple_string.md) | string | AI Automators | Designed for plain string fields, generating or processing short text values using a simple language model. |
| [LLM: Text (simple, Text Long)](llm_simple_text_long.md) | text_long | AI Automators | Generates or transforms long-form text using a simple language model chat interface. |
| [LLM: Text (simple, Text with Summary)](llm_simple_text_with_summary.md) | text_with_summary | AI Automators | Uses a simple text-to-text language model to generate or transform text with optional summary. |
| [LLM: Audio Generation](llm_speech_generation.md) | file | AI Automators | Converts provided text into speech using a language model's text-to-speech capability. |
| [LLM: Text (String Long)](llm_string_long.md) | string_long | AI Automators | Generates text content for string_long fields using a language model chat interaction. |
| [LLM: Text (String)](llm_string.md) | string | AI Automators | Generates short text content for string fields using a language model chat interaction. |
| [LLM: Taxonomy](llm_taxonomy.md) | entity_reference | AI Automators | Helps identify, select, or create taxonomy terms from context text using AI chat models. |
