<?php

declare(strict_types=1);

namespace Drupal\Tests\user\Kernel\Views;

use Drupal\language\Entity\ConfigurableLanguage;
use Drupal\Tests\views\Kernel\Handler\FieldFieldAccessTestBase;
use Drupal\user\Entity\User;
use PHPUnit\Framework\Attributes\Group;
use PHPUnit\Framework\Attributes\RunTestsInSeparateProcesses;

/**
 * Tests base field access in Views for the user entity.
 */
#[Group('user')]
#[RunTestsInSeparateProcesses]
class UserViewsFieldAccessTest extends FieldFieldAccessTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['user', 'entity_test', 'language'];

  /**
   * {@inheritdoc}
   */
  protected function setUp($import_test_views = TRUE): void {
    parent::setUp($import_test_views);

    $this->installEntitySchema('user');
  }

  /**
   * Tests the user fields.
   */
  public function testUserFields(): void {
    ConfigurableLanguage::createFromLangcode('es')->save();
    ConfigurableLanguage::createFromLangcode('fr')->save();

    $user = User::create([
      'name' => 'test user',
      'mail' => 'druplicon@drop.org',
      'status' => 1,
      'preferred_langcode' => 'es',
      'preferred_admin_langcode' => 'fr',
      'timezone' => 'ut1',
      'created' => 123456,
    ]);

    $user->save();

    // @todo Expand the test coverage in https://www.drupal.org/node/2464635

    $this->assertFieldAccess('user', 'uid', $user->id());
    $this->assertFieldAccess('user', 'uuid', $user->uuid());
    $this->assertFieldAccess('user', 'langcode', $user->language()->getName());
    $this->assertFieldAccess('user', 'preferred_langcode', 'Spanish');
    $this->assertFieldAccess('user', 'preferred_admin_langcode', 'French');
    $this->assertFieldAccess('user', 'name', 'test user');
    // $this->assertFieldAccess('user', 'mail', 'druplicon@drop.org');
    $this->assertFieldAccess('user', 'timezone', 'ut1');
    $this->assertFieldAccess('user', 'status', 'On');
    // $this->assertFieldAccess('user', 'created', \Drupal::service('date.formatter')->format(123456));
    // $this->assertFieldAccess('user', 'changed', \Drupal::service('date.formatter')->format(\Drupal::time()->getRequestTime()));
  }

}
