<?php

declare(strict_types=1);

namespace Drupal\Tests\language\Unit\process;

use Drupal\language\Plugin\migrate\process\LanguageTypes;
use Drupal\migrate\MigrateException;
use Drupal\Tests\migrate\Unit\process\MigrateProcessTestCase;
use PHPUnit\Framework\Attributes\CoversClass;
use PHPUnit\Framework\Attributes\Group;
use PHPUnit\Framework\Attributes\IgnoreDeprecations;

/**
 * Tests Drupal\language\Plugin\migrate\process\LanguageTypes.
 */
#[CoversClass(LanguageTypes::class)]
#[Group('language')]
#[IgnoreDeprecations]
class LanguageTypesTest extends MigrateProcessTestCase {

  /**
   * Tests successful transformation of all language types.
   */
  public function testTransformAll(): void {
    $this->plugin = new LanguageTypes([], 'map', []);
    $source = [
      'language' => TRUE,
      'language_url' => FALSE,
      'language_content' => FALSE,
    ];
    $expected = [
      0 => 'language_url',
      1 => 'language_content',
      2 => 'language_interface',
    ];
    $value = $this->plugin->transform($source, $this->migrateExecutable, $this->row, 'destination_property');
    $this->assertSame($value, $expected);
  }

  /**
   * Tests successful transformation of configurable language types.
   */
  public function testTransformConfigurable(): void {
    $this->plugin = new LanguageTypes(['filter_configurable' => TRUE], 'map', []);
    $source = [
      'language' => TRUE,
      'language_url' => FALSE,
      'language_content' => FALSE,
    ];
    $expected = [
      0 => 'language_interface',
    ];
    $value = $this->plugin->transform($source, $this->migrateExecutable, $this->row, 'destination_property');
    $this->assertSame($value, $expected);
  }

  /**
   * Tests string input.
   */
  public function testStringInput(): void {
    $this->plugin = new LanguageTypes([], 'map', []);
    $this->expectException(MigrateException::class);
    $this->expectExceptionMessage('The input should be an array');
    $this->plugin->transform('foo', $this->migrateExecutable, $this->row, 'destination_property');
  }

}
