
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `drupal1060`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]batch`
--

CREATE TABLE `[[dbprefix]]batch` (
  `bid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key: Unique batch ID.',
  `token` varchar(64) CHARACTER SET ascii NOT NULL COMMENT 'A string token generated against the current user''s session id and the batch id, used to ensure that only the user who submitted the batch can effectively access it.',
  `timestamp` int(11) NOT NULL COMMENT 'A Unix timestamp indicating when this batch was submitted for processing. Stale batches are purged at cron time.',
  `batch` longblob COMMENT 'A serialized array containing the processing data for the batch.',
  PRIMARY KEY (`bid`),
  KEY `token` (`token`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COMMENT='Stores details about batches (processes that run in…' AUTO_INCREMENT=2 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]block_content`
--

CREATE TABLE `[[dbprefix]]block_content` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `revision_id` int(10) unsigned DEFAULT NULL,
  `type` varchar(32) CHARACTER SET ascii NOT NULL COMMENT 'The ID of the target entity.',
  `uuid` varchar(128) CHARACTER SET ascii NOT NULL,
  `langcode` varchar(12) CHARACTER SET ascii NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `block_content_field__uuid__value` (`uuid`),
  UNIQUE KEY `block_content__revision_id` (`revision_id`),
  KEY `block_content_field__type__target_id` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The base table for block_content entities.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]block_content_field_data`
--

CREATE TABLE `[[dbprefix]]block_content_field_data` (
  `id` int(10) unsigned NOT NULL,
  `revision_id` int(10) unsigned NOT NULL,
  `type` varchar(32) CHARACTER SET ascii NOT NULL COMMENT 'The ID of the target entity.',
  `langcode` varchar(12) CHARACTER SET ascii NOT NULL,
  `status` tinyint(4) NOT NULL,
  `info` varchar(255) DEFAULT NULL,
  `changed` int(11) DEFAULT NULL,
  `reusable` tinyint(4) DEFAULT NULL,
  `default_langcode` tinyint(4) NOT NULL,
  `revision_translation_affected` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`id`,`langcode`),
  KEY `block_content__id__default_langcode__langcode` (`id`,`default_langcode`,`langcode`),
  KEY `block_content__revision_id` (`revision_id`),
  KEY `block_content_field__type__target_id` (`type`),
  KEY `block_content_field__reusable` (`reusable`),
  KEY `block_content__status_type` (`status`,`type`,`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The data table for block_content entities.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]block_content_field_revision`
--

CREATE TABLE `[[dbprefix]]block_content_field_revision` (
  `id` int(10) unsigned NOT NULL,
  `revision_id` int(10) unsigned NOT NULL,
  `langcode` varchar(12) CHARACTER SET ascii NOT NULL,
  `status` tinyint(4) NOT NULL,
  `info` varchar(255) DEFAULT NULL,
  `changed` int(11) DEFAULT NULL,
  `default_langcode` tinyint(4) NOT NULL,
  `revision_translation_affected` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`revision_id`,`langcode`),
  KEY `block_content__id__default_langcode__langcode` (`id`,`default_langcode`,`langcode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The revision data table for block_content entities.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]block_content_revision`
--

CREATE TABLE `[[dbprefix]]block_content_revision` (
  `id` int(10) unsigned NOT NULL,
  `revision_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `langcode` varchar(12) CHARACTER SET ascii NOT NULL,
  `revision_user` int(10) unsigned DEFAULT NULL COMMENT 'The ID of the target entity.',
  `revision_created` int(11) DEFAULT NULL,
  `revision_log` longtext,
  `revision_default` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`revision_id`),
  KEY `block_content__id` (`id`),
  KEY `block_content_field__revision_user__target_id` (`revision_user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The revision table for block_content entities.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]block_content_revision__body`
--

CREATE TABLE `[[dbprefix]]block_content_revision__body` (
  `bundle` varchar(128) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `body_value` longtext NOT NULL,
  `body_summary` longtext,
  `body_format` varchar(255) CHARACTER SET ascii DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `body_format` (`body_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Revision archive storage for block_content field body.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]block_content__body`
--

CREATE TABLE `[[dbprefix]]block_content__body` (
  `bundle` varchar(128) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `body_value` longtext NOT NULL,
  `body_summary` longtext,
  `body_format` varchar(255) CHARACTER SET ascii DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `body_format` (`body_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Data storage for block_content field body.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cachetags`
--

CREATE TABLE `[[dbprefix]]cachetags` (
  `tag` varchar(255) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'Namespace-prefixed tag string.',
  `invalidations` int(11) NOT NULL DEFAULT '0' COMMENT 'Number incremented when the tag is invalidated.',
  PRIMARY KEY (`tag`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Cache table for tracking cache tag invalidations.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_access_policy`
--

CREATE TABLE `[[dbprefix]]cache_access_policy` (
  `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` bigint(20) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',
  `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',
  `checksum` varchar(255) CHARACTER SET ascii NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Storage for the cache API.';

--
-- Dumping data for table `[[dbprefix]]cache_access_policy`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_bootstrap`
--

CREATE TABLE `[[dbprefix]]cache_bootstrap` (
  `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` bigint(20) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',
  `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',
  `checksum` varchar(255) CHARACTER SET ascii NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Storage for the cache API.';

--
-- Dumping data for table `[[dbprefix]]cache_bootstrap`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_config`
--

CREATE TABLE `[[dbprefix]]cache_config` (
  `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` bigint(20) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',
  `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',
  `checksum` varchar(255) CHARACTER SET ascii NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Storage for the cache API.';

--
-- Dumping data for table `[[dbprefix]]cache_config`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_container`
--

CREATE TABLE `[[dbprefix]]cache_container` (
  `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` bigint(20) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',
  `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',
  `checksum` varchar(255) CHARACTER SET ascii NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Storage for the cache API.';

--
-- Dumping data for table `[[dbprefix]]cache_container`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_data`
--

CREATE TABLE `[[dbprefix]]cache_data` (
  `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` bigint(20) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',
  `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',
  `checksum` varchar(255) CHARACTER SET ascii NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Storage for the cache API.';

--
-- Dumping data for table `[[dbprefix]]cache_data`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_default`
--

CREATE TABLE `[[dbprefix]]cache_default` (
  `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` bigint(20) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',
  `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',
  `checksum` varchar(255) CHARACTER SET ascii NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Storage for the cache API.';

--
-- Dumping data for table `[[dbprefix]]cache_default`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_discovery`
--

CREATE TABLE `[[dbprefix]]cache_discovery` (
  `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` bigint(20) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',
  `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',
  `checksum` varchar(255) CHARACTER SET ascii NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Storage for the cache API.';

--
-- Dumping data for table `[[dbprefix]]cache_discovery`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_dynamic_page_cache`
--

CREATE TABLE `[[dbprefix]]cache_dynamic_page_cache` (
  `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` bigint(20) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',
  `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',
  `checksum` varchar(255) CHARACTER SET ascii NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Storage for the cache API.';

--
-- Dumping data for table `[[dbprefix]]cache_dynamic_page_cache`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_entity`
--

CREATE TABLE `[[dbprefix]]cache_entity` (
  `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` bigint(20) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',
  `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',
  `checksum` varchar(255) CHARACTER SET ascii NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Storage for the cache API.';

--
-- Dumping data for table `[[dbprefix]]cache_entity`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_menu`
--

CREATE TABLE `[[dbprefix]]cache_menu` (
  `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` bigint(20) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',
  `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',
  `checksum` varchar(255) CHARACTER SET ascii NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Storage for the cache API.';

--
-- Dumping data for table `[[dbprefix]]cache_menu`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_render`
--

CREATE TABLE `[[dbprefix]]cache_render` (
  `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` bigint(20) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',
  `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',
  `checksum` varchar(255) CHARACTER SET ascii NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Storage for the cache API.';

--
-- Dumping data for table `[[dbprefix]]cache_render`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]comment`
--

CREATE TABLE `[[dbprefix]]comment` (
  `cid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `comment_type` varchar(32) CHARACTER SET ascii NOT NULL COMMENT 'The ID of the target entity.',
  `uuid` varchar(128) CHARACTER SET ascii NOT NULL,
  `langcode` varchar(12) CHARACTER SET ascii NOT NULL,
  PRIMARY KEY (`cid`),
  UNIQUE KEY `comment_field__uuid__value` (`uuid`),
  KEY `comment_field__comment_type__target_id` (`comment_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The base table for comment entities.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]comment_entity_statistics`
--

CREATE TABLE `[[dbprefix]]comment_entity_statistics` (
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The entity_id of the entity for which the statistics are compiled.',
  `entity_type` varchar(32) CHARACTER SET ascii NOT NULL DEFAULT 'node' COMMENT 'The entity_type of the entity to which this comment is a reply.',
  `field_name` varchar(32) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'The field_name of the field that was used to add this comment.',
  `cid` int(11) NOT NULL DEFAULT '0' COMMENT 'The "[[dbprefix]]comment".cid of the last comment.',
  `last_comment_timestamp` bigint(20) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp of the last comment that was posted within this node, from "[[dbprefix]]comment".changed.',
  `last_comment_name` varchar(60) DEFAULT NULL COMMENT 'The name of the latest author to post a comment on this node, from "[[dbprefix]]comment".name.',
  `last_comment_uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The user ID of the latest author to post a comment on this node, from "[[dbprefix]]comment".uid.',
  `comment_count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The total number of comments on this entity.',
  PRIMARY KEY (`entity_id`,`entity_type`,`field_name`),
  KEY `last_comment_timestamp` (`last_comment_timestamp`),
  KEY `comment_count` (`comment_count`),
  KEY `last_comment_uid` (`last_comment_uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Maintains statistics of entity and comments posts to show …';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]comment_field_data`
--

CREATE TABLE `[[dbprefix]]comment_field_data` (
  `cid` int(10) unsigned NOT NULL,
  `comment_type` varchar(32) CHARACTER SET ascii NOT NULL COMMENT 'The ID of the target entity.',
  `langcode` varchar(12) CHARACTER SET ascii NOT NULL,
  `status` tinyint(4) NOT NULL,
  `uid` int(10) unsigned NOT NULL COMMENT 'The ID of the target entity.',
  `pid` int(10) unsigned DEFAULT NULL COMMENT 'The ID of the target entity.',
  `entity_id` int(10) unsigned DEFAULT NULL COMMENT 'The ID of the target entity.',
  `subject` varchar(64) DEFAULT NULL,
  `name` varchar(60) DEFAULT NULL,
  `mail` varchar(254) DEFAULT NULL,
  `homepage` varchar(255) DEFAULT NULL,
  `hostname` varchar(128) DEFAULT NULL,
  `created` int(11) NOT NULL,
  `changed` int(11) DEFAULT NULL,
  `thread` varchar(255) NOT NULL,
  `entity_type` varchar(32) CHARACTER SET ascii NOT NULL,
  `field_name` varchar(32) CHARACTER SET ascii NOT NULL,
  `default_langcode` tinyint(4) NOT NULL,
  PRIMARY KEY (`cid`,`langcode`),
  KEY `comment__id__default_langcode__langcode` (`cid`,`default_langcode`,`langcode`),
  KEY `comment_field__comment_type__target_id` (`comment_type`),
  KEY `comment_field__uid__target_id` (`uid`),
  KEY `comment_field__created` (`created`),
  KEY `comment__status_comment_type` (`status`,`comment_type`,`cid`),
  KEY `comment__status_pid` (`pid`,`status`),
  KEY `comment__num_new` (`entity_id`,`entity_type`,`comment_type`,`status`,`created`,`cid`,`thread`(191)),
  KEY `comment__entity_langcode` (`entity_id`,`entity_type`,`comment_type`,`default_langcode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The data table for comment entities.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]comment__comment_body`
--

CREATE TABLE `[[dbprefix]]comment__comment_body` (
  `bundle` varchar(128) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to, which for an unversioned entity type is the same as the entity id',
  `langcode` varchar(32) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `comment_body_value` longtext NOT NULL,
  `comment_body_format` varchar(255) CHARACTER SET ascii DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `comment_body_format` (`comment_body_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Data storage for comment field comment_body.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]config`
--

CREATE TABLE `[[dbprefix]]config` (
  `collection` varchar(255) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'Primary Key: Config object collection.',
  `name` varchar(255) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'Primary Key: Config object name.',
  `data` longblob COMMENT 'A serialized configuration object data.',
  PRIMARY KEY (`collection`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The base table for configuration data.';

--
-- Dumping data for table `[[dbprefix]]config`
--

INSERT INTO `[[dbprefix]]config` VALUES
('', 'announcements_feed.settings', 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"0G5pZBcxbg8ONYzNLd1RJIsvuFFewm9htnS4I-ABKJ8";}s:7:"max_age";i:86400;s:13:"cron_interval";i:21600;s:5:"limit";i:10;}'),
('', 'automated_cron.settings', 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"fUksROt4FfkAU9BV4hV2XvhTBSS2nTNrZS4U7S-tKrs";}s:8:"interval";i:10800;}'),
('', 'block.block.claro_breadcrumbs', 'a:13:{s:4:"uuid";s:36:"d848e9a2-e342-49dc-9b4b-5ceab0782d77";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"NjcxOBrPOiK5-38t56DwFBDVY4yer7YSlbRWXFuHe7A";}s:2:"id";s:17:"claro_breadcrumbs";s:5:"theme";s:5:"claro";s:6:"region";s:10:"breadcrumb";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:23:"system_breadcrumb_block";s:8:"settings";a:4:{s:2:"id";s:23:"system_breadcrumb_block";s:5:"label";s:11:"Breadcrumbs";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}'),
('', 'block.block.claro_content', 'a:13:{s:4:"uuid";s:36:"5ae771ce-6cc2-4a52-8b47-89c9bbfca2d1";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"a0Yyx1GeyKarZ4T_yXQBR_ZFKnXiFLtxAb6gWLd8nr0";}s:2:"id";s:13:"claro_content";s:5:"theme";s:5:"claro";s:6:"region";s:7:"content";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:17:"system_main_block";s:8:"settings";a:4:{s:2:"id";s:17:"system_main_block";s:5:"label";s:17:"Main page content";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}'),
('', 'block.block.claro_help', 'a:13:{s:4:"uuid";s:36:"bd6fa43a-d797-49b9-9258-fa963529f976";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:4:"help";}s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"jccFSSVqV0WCDb6NtML1VWAWTtDbZ-zn5YgTRMgMrIM";}s:2:"id";s:10:"claro_help";s:5:"theme";s:5:"claro";s:6:"region";s:4:"help";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:10:"help_block";s:8:"settings";a:4:{s:2:"id";s:10:"help_block";s:5:"label";s:4:"Help";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"help";}s:10:"visibility";a:0:{}}'),
('', 'block.block.claro_help_search', 'a:13:{s:4:"uuid";s:36:"9f752564-93c8-4dd3-a106-364587e7b78a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:3:{s:6:"module";a:2:{i:0;s:6:"search";i:1;s:6:"system";}s:5:"theme";a:1:{i:0;s:5:"claro";}s:8:"enforced";a:1:{s:6:"config";a:1:{i:0;s:23:"search.page.help_search";}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"2ToeZLvlHKTeFY74gpgu1PejLoFyCECLO_gw6rAZwqw";}s:2:"id";s:17:"claro_help_search";s:5:"theme";s:5:"claro";s:6:"region";s:4:"help";s:6:"weight";i:-4;s:8:"provider";N;s:6:"plugin";s:17:"search_form_block";s:8:"settings";a:5:{s:2:"id";s:17:"search_form_block";s:5:"label";s:11:"Search help";s:13:"label_display";s:7:"visible";s:8:"provider";s:6:"search";s:7:"page_id";s:11:"help_search";}s:10:"visibility";a:1:{s:12:"request_path";a:4:{s:2:"id";s:12:"request_path";s:6:"negate";b:0;s:15:"context_mapping";a:0:{}s:5:"pages";s:11:"/admin/help";}}}'),
('', 'block.block.claro_local_actions', 'a:13:{s:4:"uuid";s:36:"6fd7aa3c-ed97-4c3a-a804-0ffc6da19541";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"CdXfDmRgAvms7EQovxxWPdYi0GitxeRbVtScYK16ZH0";}s:2:"id";s:19:"claro_local_actions";s:5:"theme";s:5:"claro";s:6:"region";s:7:"content";s:6:"weight";i:-10;s:8:"provider";N;s:6:"plugin";s:19:"local_actions_block";s:8:"settings";a:4:{s:2:"id";s:19:"local_actions_block";s:5:"label";s:21:"Primary admin actions";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";}s:10:"visibility";a:0:{}}'),
('', 'block.block.claro_messages', 'a:13:{s:4:"uuid";s:36:"2f19ffb4-3576-4856-8130-a9ce43bbc333";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"-Ac3ISpIT0PQ-whzD7_dw0SdKi6dAbRFNWdSjOiVDqg";}s:2:"id";s:14:"claro_messages";s:5:"theme";s:5:"claro";s:6:"region";s:11:"highlighted";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:21:"system_messages_block";s:8:"settings";a:4:{s:2:"id";s:21:"system_messages_block";s:5:"label";s:15:"Status messages";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}'),
('', 'block.block.claro_page_title', 'a:13:{s:4:"uuid";s:36:"f3032d55-475f-4e35-bc60-e4669f360cb4";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"fNwDdW063tk_ktzSWzZVeQS9wzvLooVO280BQ9WrsIs";}s:2:"id";s:16:"claro_page_title";s:5:"theme";s:5:"claro";s:6:"region";s:6:"header";s:6:"weight";i:-30;s:8:"provider";N;s:6:"plugin";s:16:"page_title_block";s:8:"settings";a:4:{s:2:"id";s:16:"page_title_block";s:5:"label";s:10:"Page title";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";}s:10:"visibility";a:0:{}}'),
('', 'block.block.claro_primary_local_tasks', 'a:13:{s:4:"uuid";s:36:"42548e43-6e06-4867-8818-2bf5559740d0";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ACjBZI5shAMiiUpsz-inLYVXDqNNXRnSzAWV3kV_8Hw";}s:2:"id";s:25:"claro_primary_local_tasks";s:5:"theme";s:5:"claro";s:6:"region";s:6:"header";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:17:"local_tasks_block";s:8:"settings";a:6:{s:2:"id";s:17:"local_tasks_block";s:5:"label";s:12:"Primary tabs";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";s:7:"primary";b:1;s:9:"secondary";b:0;}s:10:"visibility";a:0:{}}'),
('', 'block.block.claro_secondary_local_tasks', 'a:13:{s:4:"uuid";s:36:"ed57d2c1-c856-4afe-8d4a-53f7c222dc35";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"2L0geP-ixCbCkEpW6BVF6H7vDUZN4ea07_Y9CociQm4";}s:2:"id";s:27:"claro_secondary_local_tasks";s:5:"theme";s:5:"claro";s:6:"region";s:11:"pre_content";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:17:"local_tasks_block";s:8:"settings";a:6:{s:2:"id";s:17:"local_tasks_block";s:5:"label";s:14:"Secondary tabs";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";s:7:"primary";b:0;s:9:"secondary";b:1;}s:10:"visibility";a:0:{}}'),
('', 'block.block.olivero_account_menu', 'a:13:{s:4:"uuid";s:36:"5194eb45-b39a-492b-84a7-609f8802cafb";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:3:{s:6:"config";a:1:{i:0;s:19:"system.menu.account";}s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"gmxYWWHmgbe0Pnv8y48ZLSLH5mEHejOjAP6RLxUfdzU";}s:2:"id";s:20:"olivero_account_menu";s:5:"theme";s:7:"olivero";s:6:"region";s:14:"secondary_menu";s:6:"weight";i:-4;s:8:"provider";N;s:6:"plugin";s:25:"system_menu_block:account";s:8:"settings";a:7:{s:2:"id";s:25:"system_menu_block:account";s:5:"label";s:17:"User account menu";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";s:5:"level";i:1;s:5:"depth";i:1;s:16:"expand_all_items";b:0;}s:10:"visibility";a:0:{}}'),
('', 'block.block.olivero_breadcrumbs', 'a:13:{s:4:"uuid";s:36:"fa54885d-1d49-43b6-ba6f-b90d01b60339";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"VhBzWb7lMRtIOg9G7VSw_0uopi-7zXeHq4vXqqV1HFE";}s:2:"id";s:19:"olivero_breadcrumbs";s:5:"theme";s:7:"olivero";s:6:"region";s:10:"breadcrumb";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:23:"system_breadcrumb_block";s:8:"settings";a:4:{s:2:"id";s:23:"system_breadcrumb_block";s:5:"label";s:11:"Breadcrumbs";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}'),
('', 'block.block.olivero_content', 'a:13:{s:4:"uuid";s:36:"2c3b003a-c72d-4c9a-9fc8-c71fa96e3089";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"erQSEZF2XUjNmgTl0uNRBzmg18ZGXwUcw2FhApoeuHk";}s:2:"id";s:15:"olivero_content";s:5:"theme";s:7:"olivero";s:6:"region";s:7:"content";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:17:"system_main_block";s:8:"settings";a:4:{s:2:"id";s:17:"system_main_block";s:5:"label";s:17:"Main page content";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}'),
('', 'block.block.olivero_help', 'a:13:{s:4:"uuid";s:36:"bda59d32-8afa-4ea3-9cd0-9dd33664427e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:4:"help";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"VfPFqqxfkomud5CO8DUijw85QIl9GIxh_nIxLOYESxg";}s:2:"id";s:12:"olivero_help";s:5:"theme";s:7:"olivero";s:6:"region";s:13:"content_above";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:10:"help_block";s:8:"settings";a:4:{s:2:"id";s:10:"help_block";s:5:"label";s:4:"Help";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"help";}s:10:"visibility";a:0:{}}'),
('', 'block.block.olivero_main_menu', 'a:13:{s:4:"uuid";s:36:"4c607e9d-fde5-42d1-a64a-e3d431234e87";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:3:{s:6:"config";a:1:{i:0;s:16:"system.menu.main";}s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"KWAiziL39uEzmOJEql_wbUP2RtqGceL3WM2CfxhMelE";}s:2:"id";s:17:"olivero_main_menu";s:5:"theme";s:7:"olivero";s:6:"region";s:12:"primary_menu";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:22:"system_menu_block:main";s:8:"settings";a:7:{s:2:"id";s:22:"system_menu_block:main";s:5:"label";s:15:"Main navigation";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";s:5:"level";i:1;s:5:"depth";i:2;s:16:"expand_all_items";b:1;}s:10:"visibility";a:0:{}}'),
('', 'block.block.olivero_messages', 'a:13:{s:4:"uuid";s:36:"473bf5c2-c3ee-456d-a65d-f1c12f4ab444";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"BZ5tpW7H8X4PVGRm3MImTIHd2tN0eF7zOtp4SpRYUA0";}s:2:"id";s:16:"olivero_messages";s:5:"theme";s:7:"olivero";s:6:"region";s:11:"highlighted";s:6:"weight";i:-5;s:8:"provider";N;s:6:"plugin";s:21:"system_messages_block";s:8:"settings";a:4:{s:2:"id";s:21:"system_messages_block";s:5:"label";s:15:"Status messages";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}'),
('', 'block.block.olivero_page_title', 'a:13:{s:4:"uuid";s:36:"acc03a58-aca2-43d7-ad35-22cc403eec25";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"6aOgWsNTXjqrDm98TXSAjP6qd2nCijD1xw45MrnbK-Y";}s:2:"id";s:18:"olivero_page_title";s:5:"theme";s:7:"olivero";s:6:"region";s:13:"content_above";s:6:"weight";i:-5;s:8:"provider";N;s:6:"plugin";s:16:"page_title_block";s:8:"settings";a:4:{s:2:"id";s:16:"page_title_block";s:5:"label";s:10:"Page title";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";}s:10:"visibility";a:0:{}}'),
('', 'block.block.olivero_powered', 'a:13:{s:4:"uuid";s:36:"2d6b8546-280a-4f58-90a9-dceaa5473570";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"eYL19CLDyinGTWYQfBD1DswWzglEotE_kHnHx3AxTXM";}s:2:"id";s:15:"olivero_powered";s:5:"theme";s:7:"olivero";s:6:"region";s:13:"footer_bottom";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:23:"system_powered_by_block";s:8:"settings";a:4:{s:2:"id";s:23:"system_powered_by_block";s:5:"label";s:17:"Powered by Drupal";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}'),
('', 'block.block.olivero_primary_admin_actions', 'a:13:{s:4:"uuid";s:36:"bb5edf28-cada-42c3-bb02-d5e6a83b54ea";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Q9_2whdOj1YIomfvsIfopROW4FT_X5pY0DjdOiOaQ5U";}s:2:"id";s:29:"olivero_primary_admin_actions";s:5:"theme";s:7:"olivero";s:6:"region";s:11:"highlighted";s:6:"weight";i:-5;s:8:"provider";N;s:6:"plugin";s:19:"local_actions_block";s:8:"settings";a:4:{s:2:"id";s:19:"local_actions_block";s:5:"label";s:21:"Primary admin actions";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";}s:10:"visibility";a:0:{}}'),
('', 'block.block.olivero_primary_local_tasks', 'a:13:{s:4:"uuid";s:36:"954ba156-95c7-456e-8eab-67c0ddd8e22e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"nGE3EoPQQaQCuqTUtZgw0-KIzmrqdKDzdNQf2JyPUt4";}s:2:"id";s:27:"olivero_primary_local_tasks";s:5:"theme";s:7:"olivero";s:6:"region";s:11:"highlighted";s:6:"weight";i:-4;s:8:"provider";N;s:6:"plugin";s:17:"local_tasks_block";s:8:"settings";a:6:{s:2:"id";s:17:"local_tasks_block";s:5:"label";s:12:"Primary tabs";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";s:7:"primary";b:1;s:9:"secondary";b:0;}s:10:"visibility";a:0:{}}'),
('', 'block.block.olivero_search_form_narrow', 'a:13:{s:4:"uuid";s:36:"6a806bed-ed08-4f8f-b0eb-9c8964aeab6c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"search";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"yEBET0cqDbk8dkWzaJw-8CKft0961VBflsISoSR6Lj8";}s:2:"id";s:26:"olivero_search_form_narrow";s:5:"theme";s:7:"olivero";s:6:"region";s:12:"primary_menu";s:6:"weight";i:-4;s:8:"provider";N;s:6:"plugin";s:17:"search_form_block";s:8:"settings";a:5:{s:2:"id";s:17:"search_form_block";s:5:"label";s:20:"Search form (narrow)";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"search";s:7:"page_id";s:0:"";}s:10:"visibility";a:0:{}}'),
('', 'block.block.olivero_search_form_wide', 'a:13:{s:4:"uuid";s:36:"3f41b923-eb7f-41ba-931e-1a96711307b1";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"search";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"imMyHD6LYci0gtXq56qr9ZKGHzbEG9uFydrN5EhKtSU";}s:2:"id";s:24:"olivero_search_form_wide";s:5:"theme";s:7:"olivero";s:6:"region";s:14:"secondary_menu";s:6:"weight";i:-5;s:8:"provider";N;s:6:"plugin";s:17:"search_form_block";s:8:"settings";a:5:{s:2:"id";s:17:"search_form_block";s:5:"label";s:18:"Search form (wide)";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"search";s:7:"page_id";s:0:"";}s:10:"visibility";a:0:{}}'),
('', 'block.block.olivero_secondary_local_tasks', 'a:13:{s:4:"uuid";s:36:"b82d2960-8189-43b5-bfa6-3f337bdf1b0d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ydSxdq7R66I8UMC460rOzlfzvlUL4VRbdwc6z9DWaUI";}s:2:"id";s:29:"olivero_secondary_local_tasks";s:5:"theme";s:7:"olivero";s:6:"region";s:11:"highlighted";s:6:"weight";i:-2;s:8:"provider";N;s:6:"plugin";s:17:"local_tasks_block";s:8:"settings";a:6:{s:2:"id";s:17:"local_tasks_block";s:5:"label";s:14:"Secondary tabs";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";s:7:"primary";b:0;s:9:"secondary";b:1;}s:10:"visibility";a:0:{}}'),
('', 'block.block.olivero_site_branding', 'a:13:{s:4:"uuid";s:36:"16638ed0-5bd9-47f5-ba23-4550b4f5b2fb";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"n_nlgjggHVfQt2H__zvLOKB2YtjPDbQ5tHijF9LE1aM";}s:2:"id";s:21:"olivero_site_branding";s:5:"theme";s:7:"olivero";s:6:"region";s:6:"header";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:21:"system_branding_block";s:8:"settings";a:7:{s:2:"id";s:21:"system_branding_block";s:5:"label";s:13:"Site branding";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";s:13:"use_site_logo";b:1;s:13:"use_site_name";b:1;s:15:"use_site_slogan";b:0;}s:10:"visibility";a:0:{}}'),
('', 'block.block.olivero_syndicate', 'a:13:{s:4:"uuid";s:36:"570ff8a4-59fc-420e-bc60-274cfe35775a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:4:"node";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"0gq3VPg-_UM69FCCWurLFIrrnIjC2HLKhwo9iQNtcUo";}s:2:"id";s:17:"olivero_syndicate";s:5:"theme";s:7:"olivero";s:6:"region";s:6:"social";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:20:"node_syndicate_block";s:8:"settings";a:5:{s:2:"id";s:20:"node_syndicate_block";s:5:"label";s:8:"RSS feed";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"node";s:11:"block_count";i:10;}s:10:"visibility";a:0:{}}'),
('', 'block_content.type.basic', 'a:9:{s:4:"uuid";s:36:"a43e9993-66f6-4fc9-97c3-89ba9069148d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"pQP5iQy4SdhAMVcjDUncCfkJmTofnHVtXrsMzx4k6Yk";}s:2:"id";s:5:"basic";s:5:"label";s:11:"Basic block";s:8:"revision";b:0;s:11:"description";s:42:"A basic block contains a title and a body.";}'),
('', 'claro.settings', 'a:1:{s:20:"third_party_settings";a:1:{s:8:"shortcut";a:1:{s:11:"module_link";b:1;}}}'),
('', 'comment.settings', 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"YNUW2Ij5uE7a4oaXp3i_2lvaFdYM1zNKPPfnEjB0jEc";}s:16:"log_ip_addresses";b:0;}'),
('', 'comment.type.comment', 'a:9:{s:4:"uuid";s:36:"86611b27-7a27-46b6-b077-c7479da5841c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"bqZsN31T2n0UjcbyCpOPi9D2iO0sAOHR7FnEs9qMvaA";}s:2:"id";s:7:"comment";s:5:"label";s:16:"Default comments";s:21:"target_entity_type_id";s:4:"node";s:11:"description";s:28:"Allows commenting on content";}'),
('', 'contact.form.feedback', 'a:12:{s:4:"uuid";s:36:"51ca1d3a-f352-463a-b529-f4139bcbda4c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"vymHlgJy26BuI5GGj9-IXjwR3dRC5C0tij4BpWJnoqw";}s:2:"id";s:8:"feedback";s:5:"label";s:16:"Website feedback";s:10:"recipients";a:1:{i:0;[[site_mail]]}s:5:"reply";s:0:"";s:6:"weight";i:0;s:7:"message";s:27:"Your message has been sent.";s:8:"redirect";s:0:"";}'),
('', 'contact.form.personal', 'a:12:{s:4:"uuid";s:36:"49120544-019a-4a16-92b0-dc034d77be37";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"jonvgt3CkUM2eMLTFwWfHileWWDC4YtXCuIlCahTk_I";}s:2:"id";s:8:"personal";s:5:"label";s:21:"Personal contact form";s:10:"recipients";a:0:{}s:5:"reply";s:0:"";s:6:"weight";i:0;s:7:"message";s:27:"Your message has been sent.";s:8:"redirect";s:0:"";}'),
('', 'contact.settings', 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"U69DBeuvXuNVOC15rVNaBjDPK2fWFbo9v4takdYSSO8";}s:12:"default_form";s:8:"feedback";s:5:"flood";a:2:{s:5:"limit";i:5;s:8:"interval";i:3600;}s:20:"user_default_enabled";b:1;}'),
('', 'core.base_field_override.node.page.promote', 'a:17:{s:4:"uuid";s:36:"5fb24dfb-4b22-4efb-9e99-405445ee016b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:1:{i:0;s:14:"node.type.page";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"fPUEnm4T5zfZRr3ttDUqq7yCDd2uW3clWD-pvos4tlQ";}s:2:"id";s:17:"node.page.promote";s:10:"field_name";s:7:"promote";s:11:"entity_type";s:4:"node";s:6:"bundle";s:4:"page";s:5:"label";s:22:"Promoted to front page";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";i:0;}}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:8:"on_label";s:2:"On";s:9:"off_label";s:3:"Off";}s:10:"field_type";s:7:"boolean";}'),
('', 'core.date_format.fallback', 'a:9:{s:4:"uuid";s:36:"bf5b161a-bbe5-4218-9e71-66e3f68d77d3";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"7klS5IWXrwzVaPpYZFAs6wcx8U2FF1X73OfrtTsvuvE";}s:2:"id";s:8:"fallback";s:5:"label";s:20:"Fallback date format";s:6:"locked";b:1;s:7:"pattern";s:14:"D, m/d/Y - H:i";}'),
('', 'core.date_format.html_date', 'a:9:{s:4:"uuid";s:36:"87e6387f-681e-4138-abfe-f282947a76c2";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"EOQltUQPmgc6UQ2rcJ4Xi_leCEJj5ui0TR-12duS-Tk";}s:2:"id";s:9:"html_date";s:5:"label";s:9:"HTML Date";s:6:"locked";b:1;s:7:"pattern";s:5:"Y-m-d";}'),
('', 'core.date_format.html_datetime', 'a:9:{s:4:"uuid";s:36:"285ca56b-52cd-49b1-a9b4-60f9ad742a47";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"jxfClwZIRXIdcvMrE--WkcZxDGUVoOIE3Sm2NRZlFuE";}s:2:"id";s:13:"html_datetime";s:5:"label";s:13:"HTML Datetime";s:6:"locked";b:1;s:7:"pattern";s:13:"Y-m-d\\TH:i:sO";}'),
('', 'core.date_format.html_month', 'a:9:{s:4:"uuid";s:36:"0510f15c-bba3-4fbe-810b-888df4093d9d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Z7KuCUwM_WdTNvLcoltuX3_8d-s-8FZkTN6KgNwF0eM";}s:2:"id";s:10:"html_month";s:5:"label";s:10:"HTML Month";s:6:"locked";b:1;s:7:"pattern";s:3:"Y-m";}'),
('', 'core.date_format.html_time', 'a:9:{s:4:"uuid";s:36:"3c610a90-945e-4017-aa14-83a196ddebe2";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"M7yqicYkU36hRy5p9drAaGBBihhUD1OyujFrAaQ93ZE";}s:2:"id";s:9:"html_time";s:5:"label";s:9:"HTML Time";s:6:"locked";b:1;s:7:"pattern";s:5:"H:i:s";}'),
('', 'core.date_format.html_week', 'a:9:{s:4:"uuid";s:36:"6337e01f-5d58-4cb6-8a01-bc8bc07649da";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"wKD4WsoV_wFgv2vgI4mcAAFSIzrye17ykzdwrnApkfY";}s:2:"id";s:9:"html_week";s:5:"label";s:9:"HTML Week";s:6:"locked";b:1;s:7:"pattern";s:5:"Y-\\WW";}'),
('', 'core.date_format.html_year', 'a:9:{s:4:"uuid";s:36:"dd26f36c-4127-4b71-babf-c4fc0eb7a9ce";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"OjekiQuX9RbVQ2_8jOHBL94RgYLePqX7wpfNGgcQzrk";}s:2:"id";s:9:"html_year";s:5:"label";s:9:"HTML Year";s:6:"locked";b:1;s:7:"pattern";s:1:"Y";}'),
('', 'core.date_format.html_yearless_date', 'a:9:{s:4:"uuid";s:36:"edaf37d5-d71f-42d8-b667-104617a02843";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"5VpawMrKPEPCkoO4YpPa0TDFO2dgiIHfTziJtwlmUxc";}s:2:"id";s:18:"html_yearless_date";s:5:"label";s:18:"HTML Yearless date";s:6:"locked";b:1;s:7:"pattern";s:3:"m-d";}'),
('', 'core.date_format.long', 'a:9:{s:4:"uuid";s:36:"677379c6-a6bb-4337-b797-5eee3a9c43f5";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"og8sWXhBuHbLMw3CoiBEZjgqSyhFBFmcbUW_wLcfNbo";}s:2:"id";s:4:"long";s:5:"label";s:17:"Default long date";s:6:"locked";b:0;s:7:"pattern";s:15:"l, F j, Y - H:i";}'),
('', 'core.date_format.medium', 'a:9:{s:4:"uuid";s:36:"0043f673-2311-47a3-8e07-9ccd3e88f515";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"nzL5d024NjXIX_8TlT6uFAu973lmfkmHklJC-2i9rAE";}s:2:"id";s:6:"medium";s:5:"label";s:19:"Default medium date";s:6:"locked";b:0;s:7:"pattern";s:14:"D, m/d/Y - H:i";}'),
('', 'core.date_format.olivero_medium', 'a:9:{s:4:"uuid";s:36:"97f8f94e-fd76-43ed-b7ce-5c39627b06c6";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:8:"enforced";a:1:{s:5:"theme";a:1:{i:0;s:7:"olivero";}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Mt6cmxUbDZ9XxD6p25WQ8tj3_JcX8ylfcddwZc8gcAE";}s:2:"id";s:14:"olivero_medium";s:5:"label";s:14:"Olivero Medium";s:6:"locked";b:0;s:7:"pattern";s:8:"j  F,  Y";}'),
('', 'core.date_format.short', 'a:9:{s:4:"uuid";s:36:"27981e09-c2dd-4ba5-a71c-d436224ea3ed";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"AlzeyytA8InBgxIG9H2UDJYs3CG98Zj6yRsDKmlbZwA";}s:2:"id";s:5:"short";s:5:"label";s:18:"Default short date";s:6:"locked";b:0;s:7:"pattern";s:11:"m/d/Y - H:i";}'),
('', 'core.entity_form_display.block_content.basic.default', 'a:11:{s:4:"uuid";s:36:"3f9273a6-2dba-4e07-b2a6-a5b3edc80c96";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:24:"block_content.type.basic";i:1;s:36:"field.field.block_content.basic.body";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"jAps3FCxvKecABS_tgExbhCZrBLQB3bNPWw18WjE3ss";}s:2:"id";s:27:"block_content.basic.default";s:16:"targetEntityType";s:13:"block_content";s:6:"bundle";s:5:"basic";s:4:"mode";s:7:"default";s:7:"content";a:2:{s:4:"body";a:5:{s:4:"type";s:26:"text_textarea_with_summary";s:6:"weight";i:-4;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:4:"rows";i:9;s:12:"summary_rows";i:3;s:11:"placeholder";s:0:"";s:12:"show_summary";b:0;}s:20:"third_party_settings";a:0:{}}s:4:"info";a:5:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-5;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:0:{}}'),
('', 'core.entity_form_display.comment.comment.default', 'a:11:{s:4:"uuid";s:36:"e759fc97-ee45-4042-99d9-4c5e6962b176";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:20:"comment.type.comment";i:1;s:40:"field.field.comment.comment.comment_body";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"I0Pa0aQvT_jawlPo9oz4FE3h_ickc55dYKTPl6gILes";}s:2:"id";s:23:"comment.comment.default";s:16:"targetEntityType";s:7:"comment";s:6:"bundle";s:7:"comment";s:4:"mode";s:7:"default";s:7:"content";a:3:{s:6:"author";a:2:{s:6:"weight";i:-2;s:6:"region";s:7:"content";}s:12:"comment_body";a:5:{s:4:"type";s:13:"text_textarea";s:6:"weight";i:11;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"rows";i:5;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:7:"subject";a:5:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:10;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:0:{}}'),
('', 'core.entity_form_display.node.article.default', 'a:11:{s:4:"uuid";s:36:"e109d8f0-aafc-4a61-9e17-6fd3bf9deda5";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:6:{i:0;s:29:"field.field.node.article.body";i:1;s:32:"field.field.node.article.comment";i:2;s:36:"field.field.node.article.field_image";i:3;s:35:"field.field.node.article.field_tags";i:4;s:21:"image.style.thumbnail";i:5;s:17:"node.type.article";}s:6:"module";a:4:{i:0;s:7:"comment";i:1;s:5:"image";i:2;s:4:"path";i:3;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ewbd6G2uX456-bgwseM2Q-KQG3RkASoyHmTh-XR3oLU";}s:2:"id";s:20:"node.article.default";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:7:"article";s:4:"mode";s:7:"default";s:7:"content";a:11:{s:4:"body";a:5:{s:4:"type";s:26:"text_textarea_with_summary";s:6:"weight";i:2;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:4:"rows";i:9;s:12:"summary_rows";i:3;s:11:"placeholder";s:0:"";s:12:"show_summary";b:0;}s:20:"third_party_settings";a:0:{}}s:7:"comment";a:5:{s:4:"type";s:15:"comment_default";s:6:"weight";i:20;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:7:"created";a:5:{s:4:"type";s:18:"datetime_timestamp";s:6:"weight";i:10;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:11:"field_image";a:5:{s:4:"type";s:11:"image_image";s:6:"weight";i:1;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:18:"progress_indicator";s:8:"throbber";s:19:"preview_image_style";s:9:"thumbnail";}s:20:"third_party_settings";a:0:{}}s:10:"field_tags";a:5:{s:4:"type";s:34:"entity_reference_autocomplete_tags";s:6:"weight";i:3;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:14:"match_operator";s:8:"CONTAINS";s:11:"match_limit";i:10;s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:4:"path";a:5:{s:4:"type";s:4:"path";s:6:"weight";i:30;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:7:"promote";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:15;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}s:6:"status";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:120;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}s:6:"sticky";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:16;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}s:5:"title";a:5:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:0;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:3:"uid";a:5:{s:4:"type";s:29:"entity_reference_autocomplete";s:6:"weight";i:5;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:14:"match_operator";s:8:"CONTAINS";s:11:"match_limit";i:10;s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:0:{}}'),
('', 'core.entity_form_display.node.page.default', 'a:11:{s:4:"uuid";s:36:"573cdfa2-7afc-4db3-a2eb-b25c42f55825";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:26:"field.field.node.page.body";i:1;s:14:"node.type.page";}s:6:"module";a:2:{i:0;s:4:"path";i:1;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"SfpLhPExzvR0MgFp0Wp7CrmgEnhcqQ-fXIWFhbf4ue0";}s:2:"id";s:17:"node.page.default";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:4:"page";s:4:"mode";s:7:"default";s:7:"content";a:8:{s:4:"body";a:5:{s:4:"type";s:26:"text_textarea_with_summary";s:6:"weight";i:31;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:4:"rows";i:9;s:12:"summary_rows";i:3;s:11:"placeholder";s:0:"";s:12:"show_summary";b:0;}s:20:"third_party_settings";a:0:{}}s:7:"created";a:5:{s:4:"type";s:18:"datetime_timestamp";s:6:"weight";i:10;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:4:"path";a:5:{s:4:"type";s:4:"path";s:6:"weight";i:30;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:7:"promote";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:15;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}s:6:"status";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:120;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}s:6:"sticky";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:16;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}s:5:"title";a:5:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-5;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:3:"uid";a:5:{s:4:"type";s:29:"entity_reference_autocomplete";s:6:"weight";i:5;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:14:"match_operator";s:8:"CONTAINS";s:11:"match_limit";i:10;s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:0:{}}'),
('', 'core.entity_form_display.user.user.default', 'a:11:{s:4:"uuid";s:36:"fe542316-8f91-42fe-a3db-18c95b2eeaab";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:34:"field.field.user.user.user_picture";i:1;s:21:"image.style.thumbnail";}s:6:"module";a:2:{i:0;s:5:"image";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"FaQ9Ptcpxpg30AtiqRDtl_8zbJArHP1LPfug_s59TOA";}s:2:"id";s:17:"user.user.default";s:16:"targetEntityType";s:4:"user";s:6:"bundle";s:4:"user";s:4:"mode";s:7:"default";s:7:"content";a:5:{s:7:"account";a:2:{s:6:"weight";i:-10;s:6:"region";s:7:"content";}s:7:"contact";a:2:{s:6:"weight";i:5;s:6:"region";s:7:"content";}s:8:"language";a:2:{s:6:"weight";i:0;s:6:"region";s:7:"content";}s:8:"timezone";a:2:{s:6:"weight";i:6;s:6:"region";s:7:"content";}s:12:"user_picture";a:5:{s:4:"type";s:11:"image_image";s:6:"weight";i:-1;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:18:"progress_indicator";s:8:"throbber";s:19:"preview_image_style";s:9:"thumbnail";}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:0:{}}'),
('', 'core.entity_form_mode.user.register', 'a:10:{s:4:"uuid";s:36:"746fb002-b357-4273-95c4-2953ec6a63fb";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"5pE_4hurqtIlZN3XDi7eTo5RG13BMG0Rh9HYlRI3h8U";}s:2:"id";s:13:"user.register";s:5:"label";s:8:"Register";s:11:"description";s:0:"";s:16:"targetEntityType";s:4:"user";s:5:"cache";b:1;}'),
('', 'core.entity_view_display.block_content.basic.default', 'a:11:{s:4:"uuid";s:36:"f6259cda-c806-4f23-94fd-bd37861e308a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:24:"block_content.type.basic";i:1;s:36:"field.field.block_content.basic.body";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"hBNNDTFwakREOTa6GGMqN899Iyrii0hInwSJtQ7Kj30";}s:2:"id";s:27:"block_content.basic.default";s:16:"targetEntityType";s:13:"block_content";s:6:"bundle";s:5:"basic";s:4:"mode";s:7:"default";s:7:"content";a:1:{s:4:"body";a:6:{s:4:"type";s:12:"text_default";s:5:"label";s:6:"hidden";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}}s:6:"hidden";a:0:{}}'),
('', 'core.entity_view_display.comment.comment.default', 'a:11:{s:4:"uuid";s:36:"2f1026d6-4c80-49f0-8a9e-2ad950cf4fb0";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:20:"comment.type.comment";i:1;s:40:"field.field.comment.comment.comment_body";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"aBQUGsQ46M4048fIlFuTXwl2zV0j2cJX89CTUobh9hA";}s:2:"id";s:23:"comment.comment.default";s:16:"targetEntityType";s:7:"comment";s:6:"bundle";s:7:"comment";s:4:"mode";s:7:"default";s:7:"content";a:2:{s:12:"comment_body";a:6:{s:4:"type";s:12:"text_default";s:5:"label";s:6:"hidden";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}s:5:"links";a:2:{s:6:"weight";i:100;s:6:"region";s:7:"content";}}s:6:"hidden";a:0:{}}'),
('', 'core.entity_view_display.node.article.default', 'a:11:{s:4:"uuid";s:36:"aa86b799-d6a4-403d-b16c-f3db0eb130c2";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:7:{i:0;s:48:"core.entity_view_display.comment.comment.default";i:1;s:29:"field.field.node.article.body";i:2;s:32:"field.field.node.article.comment";i:3;s:36:"field.field.node.article.field_image";i:4;s:35:"field.field.node.article.field_tags";i:5;s:16:"image.style.wide";i:6;s:17:"node.type.article";}s:6:"module";a:4:{i:0;s:7:"comment";i:1;s:5:"image";i:2;s:4:"text";i:3;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"br6izr-iGEu--JvNbCJNtOBpRnxpFLXfoV5y61U9Nqc";}s:2:"id";s:20:"node.article.default";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:7:"article";s:4:"mode";s:7:"default";s:7:"content";a:5:{s:4:"body";a:6:{s:4:"type";s:12:"text_default";s:5:"label";s:6:"hidden";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}s:7:"comment";a:6:{s:4:"type";s:15:"comment_default";s:5:"label";s:5:"above";s:8:"settings";a:2:{s:9:"view_mode";s:7:"default";s:8:"pager_id";i:0;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:110;s:6:"region";s:7:"content";}s:11:"field_image";a:6:{s:4:"type";s:5:"image";s:5:"label";s:6:"hidden";s:8:"settings";a:3:{s:10:"image_link";s:0:"";s:11:"image_style";s:4:"wide";s:13:"image_loading";a:1:{s:9:"attribute";s:5:"eager";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:-1;s:6:"region";s:7:"content";}s:10:"field_tags";a:6:{s:4:"type";s:22:"entity_reference_label";s:5:"label";s:5:"above";s:8:"settings";a:1:{s:4:"link";b:1;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:10;s:6:"region";s:7:"content";}s:5:"links";a:4:{s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:100;s:6:"region";s:7:"content";}}s:6:"hidden";a:0:{}}'),
('', 'core.entity_view_display.node.article.rss', 'a:11:{s:4:"uuid";s:36:"5b00507e-f0cf-4b35-baf2-742feab6db82";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:6:{i:0;s:30:"core.entity_view_mode.node.rss";i:1;s:29:"field.field.node.article.body";i:2;s:32:"field.field.node.article.comment";i:3;s:36:"field.field.node.article.field_image";i:4;s:35:"field.field.node.article.field_tags";i:5;s:17:"node.type.article";}s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"2rIr6K5Q0UQ9khg0zE_CK-PtJH76UL-BDDZcZnZzwCc";}s:2:"id";s:16:"node.article.rss";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:7:"article";s:4:"mode";s:3:"rss";s:7:"content";a:1:{s:5:"links";a:2:{s:6:"weight";i:100;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:4:"body";b:1;s:7:"comment";b:1;s:11:"field_image";b:1;s:10:"field_tags";b:1;}}'),
('', 'core.entity_view_display.node.article.teaser', 'a:11:{s:4:"uuid";s:36:"a0decd53-7f50-4aaa-861b-5c5a5cbe3e94";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:7:{i:0;s:33:"core.entity_view_mode.node.teaser";i:1;s:29:"field.field.node.article.body";i:2;s:32:"field.field.node.article.comment";i:3;s:36:"field.field.node.article.field_image";i:4;s:35:"field.field.node.article.field_tags";i:5;s:18:"image.style.medium";i:6;s:17:"node.type.article";}s:6:"module";a:3:{i:0;s:5:"image";i:1;s:4:"text";i:2;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"O8PxzfG8DOHHRu6M23kwR6TDPq_MNfYQ10Mp367ICUQ";}s:2:"id";s:19:"node.article.teaser";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:7:"article";s:4:"mode";s:6:"teaser";s:7:"content";a:4:{s:4:"body";a:6:{s:4:"type";s:23:"text_summary_or_trimmed";s:5:"label";s:6:"hidden";s:8:"settings";a:1:{s:11:"trim_length";i:600;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}s:11:"field_image";a:6:{s:4:"type";s:5:"image";s:5:"label";s:6:"hidden";s:8:"settings";a:3:{s:10:"image_link";s:7:"content";s:11:"image_style";s:6:"medium";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:-1;s:6:"region";s:7:"content";}s:10:"field_tags";a:6:{s:4:"type";s:22:"entity_reference_label";s:5:"label";s:5:"above";s:8:"settings";a:1:{s:4:"link";b:1;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:10;s:6:"region";s:7:"content";}s:5:"links";a:2:{s:6:"weight";i:100;s:6:"region";s:7:"content";}}s:6:"hidden";a:1:{s:7:"comment";b:1;}}'),
('', 'core.entity_view_display.node.page.default', 'a:11:{s:4:"uuid";s:36:"ecec50fc-1274-4acb-b529-e85b7645d115";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:26:"field.field.node.page.body";i:1;s:14:"node.type.page";}s:6:"module";a:2:{i:0;s:4:"text";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"M_Y8L5tfmhx7DR143E05YyZSpvgil6VFvqcfBWykalg";}s:2:"id";s:17:"node.page.default";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:4:"page";s:4:"mode";s:7:"default";s:7:"content";a:2:{s:4:"body";a:6:{s:4:"type";s:12:"text_default";s:5:"label";s:6:"hidden";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:100;s:6:"region";s:7:"content";}s:5:"links";a:2:{s:6:"weight";i:101;s:6:"region";s:7:"content";}}s:6:"hidden";a:0:{}}'),
('', 'core.entity_view_display.node.page.teaser', 'a:11:{s:4:"uuid";s:36:"fa477118-5ba9-4f03-9390-ee9054f09a69";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:33:"core.entity_view_mode.node.teaser";i:1;s:26:"field.field.node.page.body";i:2;s:14:"node.type.page";}s:6:"module";a:2:{i:0;s:4:"text";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"8BgdRtLbtQ0F__o0FHSH0Mx5fvXOra9tfT1GmNKbRYw";}s:2:"id";s:16:"node.page.teaser";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:4:"page";s:4:"mode";s:6:"teaser";s:7:"content";a:2:{s:4:"body";a:6:{s:4:"type";s:23:"text_summary_or_trimmed";s:5:"label";s:6:"hidden";s:8:"settings";a:1:{s:11:"trim_length";i:600;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:100;s:6:"region";s:7:"content";}s:5:"links";a:2:{s:6:"weight";i:101;s:6:"region";s:7:"content";}}s:6:"hidden";a:0:{}}'),
('', 'core.entity_view_display.user.user.compact', 'a:11:{s:4:"uuid";s:36:"f9d04153-012b-42c2-ba2a-a6ce0c512626";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:34:"core.entity_view_mode.user.compact";i:1;s:34:"field.field.user.user.user_picture";i:2;s:21:"image.style.thumbnail";}s:6:"module";a:2:{i:0;s:5:"image";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"00zr_RBdTjPjBGITD3h4c1ESQZimjdVCcHGt1trLqIY";}s:2:"id";s:17:"user.user.compact";s:16:"targetEntityType";s:4:"user";s:6:"bundle";s:4:"user";s:4:"mode";s:7:"compact";s:7:"content";a:1:{s:12:"user_picture";a:6:{s:4:"type";s:5:"image";s:5:"label";s:6:"hidden";s:8:"settings";a:3:{s:11:"image_style";s:9:"thumbnail";s:10:"image_link";s:7:"content";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}}s:6:"hidden";a:1:{s:10:"member_for";b:1;}}'),
('', 'core.entity_view_display.user.user.default', 'a:11:{s:4:"uuid";s:36:"ce65167c-0ee5-4934-b6f9-23d1c46df97f";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:34:"field.field.user.user.user_picture";i:1;s:21:"image.style.thumbnail";}s:6:"module";a:2:{i:0;s:5:"image";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"mZLyuWM9CQx2ZJVqFGSbzgFnHzudVbHBYmdU256A5Wk";}s:2:"id";s:17:"user.user.default";s:16:"targetEntityType";s:4:"user";s:6:"bundle";s:4:"user";s:4:"mode";s:7:"default";s:7:"content";a:2:{s:10:"member_for";a:2:{s:6:"weight";i:5;s:6:"region";s:7:"content";}s:12:"user_picture";a:6:{s:4:"type";s:5:"image";s:5:"label";s:6:"hidden";s:8:"settings";a:3:{s:11:"image_style";s:9:"thumbnail";s:10:"image_link";s:7:"content";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}}s:6:"hidden";a:0:{}}'),
('', 'core.entity_view_mode.block_content.full', 'a:10:{s:4:"uuid";s:36:"84be923b-209c-4e73-acde-941626b12a02";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:13:"block_content";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Q7yUUYeRLByl-MCGveKKF_KhAtNICLCMJuKWfugCvso";}s:2:"id";s:18:"block_content.full";s:5:"label";s:4:"Full";s:11:"description";s:0:"";s:16:"targetEntityType";s:13:"block_content";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.comment.full', 'a:10:{s:4:"uuid";s:36:"1d57ecb8-7bcc-49b8-aace-a390ef63dd3b";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:7:"comment";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"N4mUjXpPckUkVRY1PbKw4GGoL1i2ECU7PL3EreiKStk";}s:2:"id";s:12:"comment.full";s:5:"label";s:12:"Full comment";s:11:"description";s:0:"";s:16:"targetEntityType";s:7:"comment";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.node.full', 'a:10:{s:4:"uuid";s:36:"70432595-60ca-4a54-90e6-a64913c389a4";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"QJ2aZ1xfVf59aq6Pz5X7fyUOa2HxuCoTwQ_RQjoulAU";}s:2:"id";s:9:"node.full";s:5:"label";s:12:"Full content";s:11:"description";s:0:"";s:16:"targetEntityType";s:4:"node";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.node.rss', 'a:10:{s:4:"uuid";s:36:"7e7bd709-a7d7-4427-a954-d6b52eb8f4bb";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"l8fiAFE3Kng_6bhLlUDnVTkTDzXWxzYFrCWTrngVXEA";}s:2:"id";s:8:"node.rss";s:5:"label";s:3:"RSS";s:11:"description";s:0:"";s:16:"targetEntityType";s:4:"node";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.node.search_index', 'a:10:{s:4:"uuid";s:36:"1c982437-3da8-42e3-95c3-fa224beebc43";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"r_A0T3aTqGDwLyvoH7wLps-0PM--RHlS8UsiJe_Ac64";}s:2:"id";s:17:"node.search_index";s:5:"label";s:12:"Search index";s:11:"description";s:0:"";s:16:"targetEntityType";s:4:"node";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.node.search_result', 'a:10:{s:4:"uuid";s:36:"5b5095c4-d45b-48ec-9317-25b45bff30e7";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"d8wBEm7XvJ6H3S0IneDD9PfTBklPIH7GMpxElVemPf8";}s:2:"id";s:18:"node.search_result";s:5:"label";s:32:"Search result highlighting input";s:11:"description";s:0:"";s:16:"targetEntityType";s:4:"node";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.node.teaser', 'a:10:{s:4:"uuid";s:36:"95752d06-853f-4981-a6cb-d2f444bd6542";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"KgGJDZFpMaz_8bTv6fN1bXS3Qi5LWmRJI9R53kEGsNQ";}s:2:"id";s:11:"node.teaser";s:5:"label";s:6:"Teaser";s:11:"description";s:0:"";s:16:"targetEntityType";s:4:"node";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.taxonomy_term.full', 'a:10:{s:4:"uuid";s:36:"3c5938ef-aaf4-4833-a463-da5b2d65ec6b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:8:"taxonomy";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"iukUENpf8CFvjZbGGacKX_Ges0-lU9z6zvsd32P6kbo";}s:2:"id";s:18:"taxonomy_term.full";s:5:"label";s:18:"Taxonomy term page";s:11:"description";s:0:"";s:16:"targetEntityType";s:13:"taxonomy_term";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.user.compact', 'a:10:{s:4:"uuid";s:36:"c208d62c-bf7f-43a2-9828-631c6064d7b2";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"TtD7OuGskOsQfoGyxXkrdtllBpR37J19d5BMQDZWJgA";}s:2:"id";s:12:"user.compact";s:5:"label";s:7:"Compact";s:11:"description";s:0:"";s:16:"targetEntityType";s:4:"user";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.user.full', 'a:10:{s:4:"uuid";s:36:"dbd8d0bf-d38b-4458-8cda-4459cfe9bf0a";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ZbXunWS_xAvMZXFfinyvClDAb_RCVLt7gAzE3v16E-Q";}s:2:"id";s:9:"user.full";s:5:"label";s:12:"User account";s:11:"description";s:0:"";s:16:"targetEntityType";s:4:"user";s:5:"cache";b:1;}'),
('', 'core.extension', 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"4GIX5Esnc_umpXUBj4IIocRX7Mt5fPhm4AgXfE3E56E";}s:6:"module";a:42:{s:18:"announcements_feed";i:0;s:14:"automated_cron";i:0;s:8:"big_pipe";i:0;s:5:"block";i:0;s:13:"block_content";i:0;s:10:"breakpoint";i:0;s:9:"ckeditor5";i:0;s:7:"comment";i:0;s:6:"config";i:0;s:7:"contact";i:0;s:10:"contextual";i:0;s:8:"datetime";i:0;s:5:"dblog";i:0;s:18:"dynamic_page_cache";i:0;s:6:"editor";i:0;s:5:"field";i:0;s:8:"field_ui";i:0;s:4:"file";i:0;s:6:"filter";i:0;s:4:"help";i:0;s:7:"history";i:0;s:5:"image";i:0;s:4:"link";i:0;s:17:"menu_link_content";i:0;s:7:"menu_ui";i:0;s:5:"mysql";i:0;s:4:"node";i:0;s:7:"options";i:0;s:10:"page_cache";i:0;s:4:"path";i:0;s:10:"path_alias";i:0;s:6:"search";i:0;s:8:"shortcut";i:0;s:6:"system";i:0;s:8:"taxonomy";i:0;s:4:"text";i:0;s:7:"toolbar";i:0;s:6:"update";i:0;s:4:"user";i:0;s:8:"views_ui";i:0;s:5:"views";i:10;s:8:"standard";i:1000;}s:5:"theme";a:2:{s:7:"olivero";i:0;s:5:"claro";i:0;}s:7:"profile";s:8:"standard";}'),
('', 'core.menu.static_menu_link_overrides', 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"CXhei_vpaZk-3f_Mj2cH0YmpK-ZpKHoSzVA3yZrDq0g";}s:11:"definitions";a:1:{s:18:"contact__site_page";a:5:{s:9:"menu_name";s:6:"footer";s:6:"parent";s:0:"";s:6:"weight";i:0;s:8:"expanded";b:0;s:7:"enabled";b:1;}}}'),
('', 'dblog.settings', 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"e883aGsrt1wFrsydlYU584PZONCSfRy0DtkZ9KzHb58";}s:9:"row_limit";i:1000;}');
INSERT INTO `[[dbprefix]]config` VALUES
('', 'editor.editor.basic_html', 'a:9:{s:4:"uuid";s:36:"ea1c2d77-7e7a-4502-a955-040162a09a21";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:24:"filter.format.basic_html";}s:6:"module";a:1:{i:0;s:9:"ckeditor5";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Qi2tIe-L97EutlMmhEvhsNxZOpOoA-RH82c4BQb5n4A";}s:6:"format";s:10:"basic_html";s:6:"editor";s:9:"ckeditor5";s:8:"settings";a:2:{s:7:"toolbar";a:1:{s:5:"items";a:15:{i:0;s:4:"bold";i:1;s:6:"italic";i:2;s:1:"|";i:3;s:4:"link";i:4;s:1:"|";i:5;s:12:"bulletedList";i:6;s:12:"numberedList";i:7;s:1:"|";i:8;s:10:"blockQuote";i:9;s:17:"drupalInsertImage";i:10;s:1:"|";i:11;s:7:"heading";i:12;s:4:"code";i:13;s:1:"|";i:14;s:13:"sourceEditing";}}s:7:"plugins";a:4:{s:17:"ckeditor5_heading";a:1:{s:16:"enabled_headings";a:5:{i:0;s:8:"heading2";i:1;s:8:"heading3";i:2;s:8:"heading4";i:3;s:8:"heading5";i:4;s:8:"heading6";}}s:21:"ckeditor5_imageResize";a:1:{s:12:"allow_resize";b:1;}s:14:"ckeditor5_list";a:2:{s:10:"properties";a:2:{s:8:"reversed";b:0;s:10:"startIndex";b:1;}s:10:"multiBlock";b:1;}s:23:"ckeditor5_sourceEditing";a:1:{s:12:"allowed_tags";a:13:{i:0;s:6:"<cite>";i:1;s:4:"<dl>";i:2;s:4:"<dt>";i:3;s:4:"<dd>";i:4;s:12:"<a hreflang>";i:5;s:17:"<blockquote cite>";i:6;s:9:"<ul type>";i:7;s:9:"<ol type>";i:8;s:7:"<h2 id>";i:9;s:7:"<h3 id>";i:10;s:7:"<h4 id>";i:11;s:7:"<h5 id>";i:12;s:7:"<h6 id>";}}}}s:12:"image_upload";a:5:{s:6:"status";b:1;s:6:"scheme";s:6:"public";s:9:"directory";s:13:"inline-images";s:8:"max_size";N;s:14:"max_dimensions";a:2:{s:5:"width";N;s:6:"height";N;}}}'),
('', 'editor.editor.full_html', 'a:9:{s:4:"uuid";s:36:"5c139a2f-5770-41b1-947f-4529bcbd5c2b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:23:"filter.format.full_html";}s:6:"module";a:1:{i:0;s:9:"ckeditor5";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"lurcn8yf33g3Dkzdc55cTfJa9salGp9ytSYyG1s7QMI";}s:6:"format";s:9:"full_html";s:6:"editor";s:9:"ckeditor5";s:8:"settings";a:2:{s:7:"toolbar";a:1:{s:5:"items";a:21:{i:0;s:4:"bold";i:1;s:6:"italic";i:2;s:13:"strikethrough";i:3;s:11:"superscript";i:4;s:9:"subscript";i:5;s:12:"removeFormat";i:6;s:1:"|";i:7;s:4:"link";i:8;s:1:"|";i:9;s:12:"bulletedList";i:10;s:12:"numberedList";i:11;s:1:"|";i:12;s:10:"blockQuote";i:13;s:17:"drupalInsertImage";i:14;s:11:"insertTable";i:15;s:14:"horizontalLine";i:16;s:1:"|";i:17;s:7:"heading";i:18;s:9:"codeBlock";i:19;s:1:"|";i:20;s:13:"sourceEditing";}}s:7:"plugins";a:5:{s:19:"ckeditor5_codeBlock";a:1:{s:9:"languages";a:14:{i:0;a:2:{s:5:"label";s:10:"Plain text";s:8:"language";s:9:"plaintext";}i:1;a:2:{s:5:"label";s:1:"C";s:8:"language";s:1:"c";}i:2;a:2:{s:5:"label";s:2:"C#";s:8:"language";s:2:"cs";}i:3;a:2:{s:5:"label";s:3:"C++";s:8:"language";s:3:"cpp";}i:4;a:2:{s:5:"label";s:3:"CSS";s:8:"language";s:3:"css";}i:5;a:2:{s:5:"label";s:4:"Diff";s:8:"language";s:4:"diff";}i:6;a:2:{s:5:"label";s:4:"HTML";s:8:"language";s:4:"html";}i:7;a:2:{s:5:"label";s:4:"Java";s:8:"language";s:4:"java";}i:8;a:2:{s:5:"label";s:10:"JavaScript";s:8:"language";s:10:"javascript";}i:9;a:2:{s:5:"label";s:3:"PHP";s:8:"language";s:3:"php";}i:10;a:2:{s:5:"label";s:6:"Python";s:8:"language";s:6:"python";}i:11;a:2:{s:5:"label";s:4:"Ruby";s:8:"language";s:4:"ruby";}i:12;a:2:{s:5:"label";s:10:"TypeScript";s:8:"language";s:10:"typescript";}i:13;a:2:{s:5:"label";s:3:"XML";s:8:"language";s:3:"xml";}}}s:17:"ckeditor5_heading";a:1:{s:16:"enabled_headings";a:5:{i:0;s:8:"heading2";i:1;s:8:"heading3";i:2;s:8:"heading4";i:3;s:8:"heading5";i:4;s:8:"heading6";}}s:21:"ckeditor5_imageResize";a:1:{s:12:"allow_resize";b:1;}s:14:"ckeditor5_list";a:2:{s:10:"properties";a:2:{s:8:"reversed";b:1;s:10:"startIndex";b:1;}s:10:"multiBlock";b:1;}s:23:"ckeditor5_sourceEditing";a:1:{s:12:"allowed_tags";a:0:{}}}}s:12:"image_upload";a:5:{s:6:"status";b:1;s:6:"scheme";s:6:"public";s:9:"directory";s:13:"inline-images";s:8:"max_size";N;s:14:"max_dimensions";a:2:{s:5:"width";N;s:6:"height";N;}}}'),
('', 'field.field.block_content.basic.body', 'a:17:{s:4:"uuid";s:36:"e15d8095-ce96-4d5e-a61a-9c9f5183b548";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:24:"block_content.type.basic";i:1;s:32:"field.storage.block_content.body";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"j00Gfs9AFqwK4x9RIsISLbPO7vA12psPR4s60wOIwQo";}s:2:"id";s:24:"block_content.basic.body";s:10:"field_name";s:4:"body";s:11:"entity_type";s:13:"block_content";s:6:"bundle";s:5:"basic";s:5:"label";s:4:"Body";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:3:{s:15:"display_summary";b:0;s:16:"required_summary";b:0;s:15:"allowed_formats";a:0:{}}s:10:"field_type";s:17:"text_with_summary";}'),
('', 'field.field.comment.comment.comment_body', 'a:17:{s:4:"uuid";s:36:"d2d25b18-74e6-47b7-82ce-6d8674ccbe47";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:20:"comment.type.comment";i:1;s:34:"field.storage.comment.comment_body";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"62rlTOx3sPVrYhBnSBHZStXwiO02v1UpHSMrhWDsuG8";}s:2:"id";s:28:"comment.comment.comment_body";s:10:"field_name";s:12:"comment_body";s:11:"entity_type";s:7:"comment";s:6:"bundle";s:7:"comment";s:5:"label";s:7:"Comment";s:11:"description";s:0:"";s:8:"required";b:1;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:1:{s:15:"allowed_formats";a:0:{}}s:10:"field_type";s:9:"text_long";}'),
('', 'field.field.node.article.body', 'a:17:{s:4:"uuid";s:36:"5adf333c-dae8-4b4b-9cb1-e8d0ad326588";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:23:"field.storage.node.body";i:1;s:17:"node.type.article";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"4Wxs1LseZ8JsNwD9uJVIbzZqG35yQXN8Eo1Hub6NMuI";}s:2:"id";s:17:"node.article.body";s:10:"field_name";s:4:"body";s:11:"entity_type";s:4:"node";s:6:"bundle";s:7:"article";s:5:"label";s:4:"Body";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:3:{s:15:"display_summary";b:1;s:16:"required_summary";b:0;s:15:"allowed_formats";a:0:{}}s:10:"field_type";s:17:"text_with_summary";}'),
('', 'field.field.node.article.comment', 'a:17:{s:4:"uuid";s:36:"228a5a1c-ed15-4682-a5e2-700a29bb5c5f";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:26:"field.storage.node.comment";i:1;s:17:"node.type.article";}s:6:"module";a:1:{i:0;s:7:"comment";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"UqXlkKC4v2-bDfWx4zcXQrD5YIi3d5byENEmWv-G_Uc";}s:2:"id";s:20:"node.article.comment";s:10:"field_name";s:7:"comment";s:11:"entity_type";s:4:"node";s:6:"bundle";s:7:"article";s:5:"label";s:8:"Comments";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:1:{i:0;a:6:{s:6:"status";i:2;s:3:"cid";i:0;s:22:"last_comment_timestamp";i:0;s:17:"last_comment_name";N;s:16:"last_comment_uid";i:0;s:13:"comment_count";i:0;}}s:22:"default_value_callback";s:0:"";s:8:"settings";a:5:{s:12:"default_mode";i:1;s:8:"per_page";i:50;s:9:"anonymous";i:0;s:13:"form_location";b:1;s:7:"preview";i:1;}s:10:"field_type";s:7:"comment";}'),
('', 'field.field.node.article.field_image', 'a:17:{s:4:"uuid";s:36:"6958adc6-4dfb-4ea5-b999-902e91dd1142";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:30:"field.storage.node.field_image";i:1;s:17:"node.type.article";}s:6:"module";a:1:{i:0;s:5:"image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"j0riO_-77ZFWNLtj0iJ31HnohiNjdn8HUL86RueCF-M";}s:2:"id";s:24:"node.article.field_image";s:10:"field_name";s:11:"field_image";s:11:"entity_type";s:4:"node";s:6:"bundle";s:7:"article";s:5:"label";s:5:"Image";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:12:{s:7:"handler";s:12:"default:file";s:16:"handler_settings";a:0:{}s:14:"file_directory";s:31:"[date:custom:Y]-[date:custom:m]";s:15:"file_extensions";s:21:"png gif jpg jpeg webp";s:12:"max_filesize";s:0:"";s:14:"max_resolution";s:0:"";s:14:"min_resolution";s:0:"";s:9:"alt_field";b:1;s:18:"alt_field_required";b:1;s:11:"title_field";b:0;s:20:"title_field_required";b:0;s:13:"default_image";a:5:{s:4:"uuid";N;s:3:"alt";s:0:"";s:5:"title";s:0:"";s:5:"width";N;s:6:"height";N;}}s:10:"field_type";s:5:"image";}'),
('', 'field.field.node.article.field_tags', 'a:17:{s:4:"uuid";s:36:"3ac3c85d-5ea8-4c2f-9264-f8b6f2a67719";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:3:{i:0;s:29:"field.storage.node.field_tags";i:1;s:17:"node.type.article";i:2;s:24:"taxonomy.vocabulary.tags";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"QdUgf_beeoaPiyKorFv0q1fcJpWH_uZTqe_xoVJacrw";}s:2:"id";s:23:"node.article.field_tags";s:10:"field_name";s:10:"field_tags";s:11:"entity_type";s:4:"node";s:6:"bundle";s:7:"article";s:5:"label";s:4:"Tags";s:11:"description";s:84:"Enter a comma-separated list. For example: Amsterdam, Mexico City, "Cleveland, Ohio"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:7:"handler";s:21:"default:taxonomy_term";s:16:"handler_settings";a:3:{s:14:"target_bundles";a:1:{s:4:"tags";s:4:"tags";}s:4:"sort";a:1:{s:5:"field";s:5:"_none";}s:11:"auto_create";b:1;}}s:10:"field_type";s:16:"entity_reference";}'),
('', 'field.field.node.page.body', 'a:17:{s:4:"uuid";s:36:"20b684b8-5143-4fe1-9ae8-b585cec28e00";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:23:"field.storage.node.body";i:1;s:14:"node.type.page";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"KHu9I-pR4FnP79crRJ5gVD_1mKGSZcJsdIm9bn64iFg";}s:2:"id";s:14:"node.page.body";s:10:"field_name";s:4:"body";s:11:"entity_type";s:4:"node";s:6:"bundle";s:4:"page";s:5:"label";s:4:"Body";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:3:{s:15:"display_summary";b:1;s:16:"required_summary";b:0;s:15:"allowed_formats";a:0:{}}s:10:"field_type";s:17:"text_with_summary";}'),
('', 'field.field.user.user.user_picture', 'a:17:{s:4:"uuid";s:36:"0f33a56f-376d-4758-a159-fac59f48c3fa";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:31:"field.storage.user.user_picture";}s:6:"module";a:2:{i:0;s:5:"image";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"TE3gYVzd6g0deXqUl8SEu2azHwVG-SdXm3kwbrz0kHw";}s:2:"id";s:22:"user.user.user_picture";s:10:"field_name";s:12:"user_picture";s:11:"entity_type";s:4:"user";s:6:"bundle";s:4:"user";s:5:"label";s:7:"Picture";s:11:"description";s:29:"Your virtual face or picture.";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:12:{s:7:"handler";s:12:"default:file";s:16:"handler_settings";a:0:{}s:14:"file_directory";s:40:"pictures/[date:custom:Y]-[date:custom:m]";s:15:"file_extensions";s:21:"png gif jpg jpeg webp";s:12:"max_filesize";s:0:"";s:14:"max_resolution";s:0:"";s:14:"min_resolution";s:0:"";s:9:"alt_field";b:0;s:18:"alt_field_required";b:0;s:11:"title_field";b:0;s:20:"title_field_required";b:0;s:13:"default_image";a:5:{s:4:"uuid";N;s:3:"alt";s:0:"";s:5:"title";s:0:"";s:5:"width";N;s:6:"height";N;}}s:10:"field_type";s:5:"image";}'),
('', 'field.settings', 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"nJk0TAQBzlNo52ehiHI7bIEPLGi0BYqZvPdEn7Chfu0";}s:16:"purge_batch_size";i:50;}'),
('', 'field.storage.block_content.body', 'a:17:{s:4:"uuid";s:36:"512191d6-44bb-4a2f-baef-3a1914d3b158";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:13:"block_content";i:1;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"eS0snV_L3dx9shtWRTzm5eblwOJ7qKWC9IE-4GMTDFc";}s:2:"id";s:18:"block_content.body";s:10:"field_name";s:4:"body";s:11:"entity_type";s:13:"block_content";s:4:"type";s:17:"text_with_summary";s:8:"settings";a:0:{}s:6:"module";s:4:"text";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:1;s:14:"custom_storage";b:0;}'),
('', 'field.storage.comment.comment_body', 'a:17:{s:4:"uuid";s:36:"6bc4fcb5-6b55-4bfe-9dfa-4385c9c598d5";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:7:"comment";i:1;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"swYoCch_hY8QO5uwr4FURplfnUCUlpPB4idF8WGVCpw";}s:2:"id";s:20:"comment.comment_body";s:10:"field_name";s:12:"comment_body";s:11:"entity_type";s:7:"comment";s:4:"type";s:9:"text_long";s:8:"settings";a:0:{}s:6:"module";s:4:"text";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:1;s:14:"custom_storage";b:0;}'),
('', 'field.storage.node.body', 'a:17:{s:4:"uuid";s:36:"ecaac161-1f86-469c-9653-ad36c02c1de4";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"EBUo7qOWqaiZaQ_RC9sLY5IoDKphS34v77VIHSACmVY";}s:2:"id";s:9:"node.body";s:10:"field_name";s:4:"body";s:11:"entity_type";s:4:"node";s:4:"type";s:17:"text_with_summary";s:8:"settings";a:0:{}s:6:"module";s:4:"text";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:1;s:14:"custom_storage";b:0;}'),
('', 'field.storage.node.comment', 'a:17:{s:4:"uuid";s:36:"271091f9-10d6-4330-8fe8-c53e6e398f48";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:7:"comment";i:1;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ktCna9xmWvYZIUfOCUyDQvedn5RtnS4CRmEIwNmvYjc";}s:2:"id";s:12:"node.comment";s:10:"field_name";s:7:"comment";s:11:"entity_type";s:4:"node";s:4:"type";s:7:"comment";s:8:"settings";a:1:{s:12:"comment_type";s:7:"comment";}s:6:"module";s:7:"comment";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}'),
('', 'field.storage.node.field_image', 'a:17:{s:4:"uuid";s:36:"700e4126-c5d7-4a9b-8143-78cac4abe782";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:3:{i:0;s:4:"file";i:1;s:5:"image";i:2;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"EymokncRIZ7SgQT2IdOQhQJicX4nNc0K89ik-LxmOHE";}s:2:"id";s:16:"node.field_image";s:10:"field_name";s:11:"field_image";s:11:"entity_type";s:4:"node";s:4:"type";s:5:"image";s:8:"settings";a:5:{s:11:"target_type";s:4:"file";s:13:"display_field";b:0;s:15:"display_default";b:0;s:10:"uri_scheme";s:6:"public";s:13:"default_image";a:5:{s:4:"uuid";N;s:3:"alt";s:0:"";s:5:"title";s:0:"";s:5:"width";N;s:6:"height";N;}}s:6:"module";s:5:"image";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}'),
('', 'field.storage.node.field_tags', 'a:17:{s:4:"uuid";s:36:"5b68f621-44f9-4e63-9609-e42e7878f9d1";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"node";i:1;s:8:"taxonomy";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"WpOE_bs8Bs_HY2ns7n2r__de-xno0-Bxkqep5-MsHAs";}s:2:"id";s:15:"node.field_tags";s:10:"field_name";s:10:"field_tags";s:11:"entity_type";s:4:"node";s:4:"type";s:16:"entity_reference";s:8:"settings";a:1:{s:11:"target_type";s:13:"taxonomy_term";}s:6:"module";s:4:"core";s:6:"locked";b:0;s:11:"cardinality";i:-1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}'),
('', 'field.storage.user.user_picture', 'a:17:{s:4:"uuid";s:36:"97840e9f-94a5-4a72-8a9a-62c48abe9fd6";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:3:{i:0;s:4:"file";i:1;s:5:"image";i:2;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"0q8-mw8y-Ls5I578sIPQFLp4ljpH7WvVYpzY-I9O-8E";}s:2:"id";s:17:"user.user_picture";s:10:"field_name";s:12:"user_picture";s:11:"entity_type";s:4:"user";s:4:"type";s:5:"image";s:8:"settings";a:5:{s:11:"target_type";s:4:"file";s:13:"display_field";b:0;s:15:"display_default";b:0;s:10:"uri_scheme";s:6:"public";s:13:"default_image";a:5:{s:4:"uuid";N;s:3:"alt";s:0:"";s:5:"title";s:0:"";s:5:"width";N;s:6:"height";N;}}s:6:"module";s:5:"image";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}'),
('', 'field_ui.settings', 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Q1nMi90W6YQxKzZAgJQw7Ag9U4JrsEUwkomF0lhvbIM";}s:12:"field_prefix";s:6:"field_";}'),
('', 'file.settings', 'a:5:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"2bwjZB1IjEYbppgZT3g7YW_5h_LDZYNa3DaDEfWX82U";}s:11:"description";a:2:{s:4:"type";s:9:"textfield";s:6:"length";i:128;}s:4:"icon";a:1:{s:9:"directory";s:23:"core/modules/file/icons";}s:35:"make_unused_managed_files_temporary";b:0;s:21:"filename_sanitization";a:6:{s:13:"transliterate";b:0;s:18:"replace_whitespace";b:0;s:24:"replace_non_alphanumeric";b:0;s:22:"deduplicate_separators";b:0;s:9:"lowercase";b:0;s:21:"replacement_character";s:1:"-";}}'),
('', 'filter.format.basic_html', 'a:9:{s:4:"uuid";s:36:"06976546-bf54-446d-97e6-388f71ee8c57";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:6:"editor";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"mclCbTlJwWJORez4Y1eX2MqA0aGjSMAoJb3TaBABcK8";}s:4:"name";s:10:"Basic HTML";s:6:"format";s:10:"basic_html";s:6:"weight";i:0;s:7:"filters";a:6:{s:21:"editor_file_reference";a:5:{s:2:"id";s:21:"editor_file_reference";s:8:"provider";s:6:"editor";s:6:"status";b:1;s:6:"weight";i:11;s:8:"settings";a:0:{}}s:12:"filter_align";a:5:{s:2:"id";s:12:"filter_align";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:7;s:8:"settings";a:0:{}}s:14:"filter_caption";a:5:{s:2:"id";s:14:"filter_caption";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:8;s:8:"settings";a:0:{}}s:11:"filter_html";a:5:{s:2:"id";s:11:"filter_html";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:-10;s:8:"settings";a:3:{s:12:"allowed_html";s:243:"<br> <p> <h2 id> <h3 id> <h4 id> <h5 id> <h6 id> <cite> <dl> <dt> <dd> <a hreflang href> <blockquote cite> <ul type> <ol start type> <strong> <em> <code> <li> <img src alt data-entity-uuid data-entity-type height width data-caption data-align>";s:16:"filter_html_help";b:0;s:20:"filter_html_nofollow";b:0;}}s:24:"filter_html_image_secure";a:5:{s:2:"id";s:24:"filter_html_image_secure";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:9;s:8:"settings";a:0:{}}s:22:"filter_image_lazy_load";a:5:{s:2:"id";s:22:"filter_image_lazy_load";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:15;s:8:"settings";a:0:{}}}}'),
('', 'filter.format.full_html', 'a:9:{s:4:"uuid";s:36:"7e935f33-6ca2-4b6b-9c78-221a93348706";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:6:"editor";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"vpZysv3RHJjhYzq7O_q5q8mVlHdrSzKELmXyiX6RtV0";}s:4:"name";s:9:"Full HTML";s:6:"format";s:9:"full_html";s:6:"weight";i:2;s:7:"filters";a:5:{s:21:"editor_file_reference";a:5:{s:2:"id";s:21:"editor_file_reference";s:8:"provider";s:6:"editor";s:6:"status";b:1;s:6:"weight";i:11;s:8:"settings";a:0:{}}s:12:"filter_align";a:5:{s:2:"id";s:12:"filter_align";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:8;s:8:"settings";a:0:{}}s:14:"filter_caption";a:5:{s:2:"id";s:14:"filter_caption";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:9;s:8:"settings";a:0:{}}s:20:"filter_htmlcorrector";a:5:{s:2:"id";s:20:"filter_htmlcorrector";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:10;s:8:"settings";a:0:{}}s:22:"filter_image_lazy_load";a:5:{s:2:"id";s:22:"filter_image_lazy_load";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:15;s:8:"settings";a:0:{}}}}'),
('', 'filter.format.plain_text', 'a:9:{s:4:"uuid";s:36:"eb6f80d1-ba58-42f1-b170-7c61297fcf64";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"JLMwODO0epnA_H-jFlH9ezVfa5YBJniRv3MmLqYNl_Q";}s:4:"name";s:10:"Plain text";s:6:"format";s:10:"plain_text";s:6:"weight";i:10;s:7:"filters";a:3:{s:12:"filter_autop";a:5:{s:2:"id";s:12:"filter_autop";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:0;s:8:"settings";a:0:{}}s:18:"filter_html_escape";a:5:{s:2:"id";s:18:"filter_html_escape";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:-10;s:8:"settings";a:0:{}}s:10:"filter_url";a:5:{s:2:"id";s:10:"filter_url";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:0;s:8:"settings";a:1:{s:17:"filter_url_length";i:72;}}}}'),
('', 'filter.format.restricted_html', 'a:9:{s:4:"uuid";s:36:"ef4ece88-0a04-4fe8-869f-86289b3815d5";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"QiKqQS_YGAT3Qr4vaAgZICJknm-MGCzt_xBAMqg-tRM";}s:4:"name";s:15:"Restricted HTML";s:6:"format";s:15:"restricted_html";s:6:"weight";i:1;s:7:"filters";a:3:{s:12:"filter_autop";a:5:{s:2:"id";s:12:"filter_autop";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:0;s:8:"settings";a:0:{}}s:11:"filter_html";a:5:{s:2:"id";s:11:"filter_html";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:-10;s:8:"settings";a:3:{s:12:"allowed_html";s:149:"<a href hreflang> <em> <strong> <cite> <blockquote cite> <code> <ul type> <ol start type> <li> <dl> <dt> <dd> <h2 id> <h3 id> <h4 id> <h5 id> <h6 id>";s:16:"filter_html_help";b:1;s:20:"filter_html_nofollow";b:0;}}s:10:"filter_url";a:5:{s:2:"id";s:10:"filter_url";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:0;s:8:"settings";a:1:{s:17:"filter_url_length";i:72;}}}}'),
('', 'filter.settings', 'a:3:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"FiPjM3WdB__ruFA7B6TLwni_UcZbmek5G4b2dxQItxA";}s:15:"fallback_format";s:10:"plain_text";s:27:"always_show_fallback_choice";b:0;}'),
('', 'image.settings', 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"k-yDFHbqNfpe-Srg4sdCSqaosCl2D8uwyEY5esF8gEw";}s:13:"preview_image";s:29:"core/modules/image/sample.png";s:26:"allow_insecure_derivatives";b:0;s:20:"suppress_itok_output";b:0;}'),
('', 'image.style.large', 'a:8:{s:4:"uuid";s:36:"f3415f16-f821-4c40-a7b5-cb7135df9a65";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"rDR2BOewa2UFH9yG4tVvrGxEVv8U7LQo-RLkJhFpERs";}s:4:"name";s:5:"large";s:5:"label";s:16:"Large (480×480)";s:7:"effects";a:2:{s:36:"ddd73aa7-4bd6-4c85-b600-bdf2b1628d1d";a:4:{s:4:"uuid";s:36:"ddd73aa7-4bd6-4c85-b600-bdf2b1628d1d";s:2:"id";s:11:"image_scale";s:6:"weight";i:0;s:4:"data";a:3:{s:5:"width";i:480;s:6:"height";i:480;s:7:"upscale";b:0;}}s:36:"6e8fe467-84c1-4ef0-a73b-7eccf1cc20e8";a:4:{s:4:"uuid";s:36:"6e8fe467-84c1-4ef0-a73b-7eccf1cc20e8";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.medium', 'a:8:{s:4:"uuid";s:36:"0c4b37e9-e8ed-472f-9bae-26ee077235a9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"dlar76VBuGj5iMGTruB_uMZX8VbivXt9_QLemaG2q4E";}s:4:"name";s:6:"medium";s:5:"label";s:17:"Medium (220×220)";s:7:"effects";a:2:{s:36:"bddf0d06-42f9-4c75-a700-a33cafa25ea0";a:4:{s:4:"uuid";s:36:"bddf0d06-42f9-4c75-a700-a33cafa25ea0";s:2:"id";s:11:"image_scale";s:6:"weight";i:0;s:4:"data";a:3:{s:5:"width";i:220;s:6:"height";i:220;s:7:"upscale";b:0;}}s:36:"c410ed2f-aa30-4d9c-a224-d2865d9188cd";a:4:{s:4:"uuid";s:36:"c410ed2f-aa30-4d9c-a224-d2865d9188cd";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.thumbnail', 'a:8:{s:4:"uuid";s:36:"9359162a-89f5-4e7c-bd1a-280251b65ae2";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"BgeBV-xOFINMsz-y2thm45EGesj6bRM6DTLZ6ce3V9I";}s:4:"name";s:9:"thumbnail";s:5:"label";s:20:"Thumbnail (100×100)";s:7:"effects";a:2:{s:36:"1cfec298-8620-4749-b100-ccb6c4500779";a:4:{s:4:"uuid";s:36:"1cfec298-8620-4749-b100-ccb6c4500779";s:2:"id";s:11:"image_scale";s:6:"weight";i:0;s:4:"data";a:3:{s:5:"width";i:100;s:6:"height";i:100;s:7:"upscale";b:0;}}s:36:"c4eb9942-2c9e-4a81-949f-6161a44b6559";a:4:{s:4:"uuid";s:36:"c4eb9942-2c9e-4a81-949f-6161a44b6559";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.wide', 'a:8:{s:4:"uuid";s:36:"e0ef4f25-c972-4b0e-b2b6-fbce611ec3ef";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"XHh3ATMH7z4ljwmzdndM47qNMkgLnoYsP98rGxVgCOw";}s:4:"name";s:4:"wide";s:5:"label";s:11:"Wide (1090)";s:7:"effects";a:2:{s:36:"09959c15-59ce-4f6d-90df-e2d7cf32bce5";a:4:{s:4:"uuid";s:36:"09959c15-59ce-4f6d-90df-e2d7cf32bce5";s:2:"id";s:11:"image_scale";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:1090;s:6:"height";N;s:7:"upscale";b:0;}}s:36:"294c5f76-42a4-43ce-82c2-81c2f4723da0";a:4:{s:4:"uuid";s:36:"294c5f76-42a4-43ce-82c2-81c2f4723da0";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'menu_ui.settings', 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"SqMarzIjxC3F8dZo9FEOxfqDKD_sdW1tbcFTV1BA2zU";}s:24:"override_parent_selector";b:0;}'),
('', 'node.settings', 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"W0cgFPhPJ3gAdqm06-az48BLf5MVcoZVS0HdByoofi0";}s:15:"use_admin_theme";b:1;}'),
('', 'node.type.article', 'a:12:{s:4:"uuid";s:36:"7b4ec372-1436-4e51-95a3-6d5df188958d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Fe3N1uqaAyyKJbVkqT-btXy3t98puW8GCRD822xjl10";}s:4:"name";s:7:"Article";s:4:"type";s:7:"article";s:11:"description";s:89:"Use <em>articles</em> for time-sensitive content like news, press releases or blog posts.";s:4:"help";N;s:12:"new_revision";b:1;s:12:"preview_mode";i:1;s:17:"display_submitted";b:1;}'),
('', 'node.type.page', 'a:12:{s:4:"uuid";s:36:"5de895cd-7143-4798-ae88-0620db2406c4";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"i0snV8Wj--OkRW12UdachUiYiz3FbeMwHu_pZYfzKLc";}s:4:"name";s:10:"Basic page";s:4:"type";s:4:"page";s:11:"description";s:77:"Use <em>basic pages</em> for your static content, such as an ''About us'' page.";s:4:"help";N;s:12:"new_revision";b:1;s:12:"preview_mode";i:1;s:17:"display_submitted";b:0;}'),
('', 'olivero.settings', 'a:8:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"1TswGK46jyu77aIM7Z-0JVQs5bxHmo-gtgrvrQGMXxc";}s:7:"favicon";a:1:{s:11:"use_default";b:1;}s:8:"features";a:4:{s:20:"comment_user_picture";b:1;s:25:"comment_user_verification";b:1;s:7:"favicon";b:1;s:17:"node_user_picture";b:0;}s:4:"logo";a:1:{s:11:"use_default";b:0;}s:20:"third_party_settings";a:1:{s:8:"shortcut";a:1:{s:11:"module_link";b:1;}}s:22:"mobile_menu_all_widths";i:0;s:22:"site_branding_bg_color";s:7:"default";s:18:"base_primary_color";s:7:"#1b9ae4";}'),
('', 'search.page.help_search', 'a:11:{s:4:"uuid";s:36:"93c94432-be8e-46d9-9c1d-e4092db28f48";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"help";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"RZ-bcSekNSsAbIPLW7Gmyd3uUjIOSrPvnb8RCCZYJm8";}s:2:"id";s:11:"help_search";s:5:"label";s:4:"Help";s:4:"path";s:4:"help";s:6:"weight";i:0;s:6:"plugin";s:11:"help_search";s:13:"configuration";a:0:{}}'),
('', 'search.page.node_search', 'a:11:{s:4:"uuid";s:36:"b82ff5ce-ed05-40ca-80ce-4f94b613b69b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"97tvtzGOa8_flb22CzSjgtm_YkiGMHvEBO-6q2K9V_U";}s:2:"id";s:11:"node_search";s:5:"label";s:7:"Content";s:4:"path";s:4:"node";s:6:"weight";i:-10;s:6:"plugin";s:11:"node_search";s:13:"configuration";a:1:{s:8:"rankings";a:0:{}}}'),
('', 'search.page.user_search', 'a:11:{s:4:"uuid";s:36:"338efbfd-5e2c-418e-bb8b-9b2b13d9e72e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"k3aUaZXGDuhkek2TZIee0PApOPTvYZLadziekdyHA5A";}s:2:"id";s:11:"user_search";s:5:"label";s:5:"Users";s:4:"path";s:4:"user";s:6:"weight";i:0;s:6:"plugin";s:11:"user_search";s:13:"configuration";a:0:{}}'),
('', 'search.settings', 'a:5:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"hvVxL1G-ZCxaq32IZws0YsfuhvaDiQE_np-0g35KjUk";}s:12:"and_or_limit";i:7;s:12:"default_page";s:11:"node_search";s:5:"index";a:4:{s:10:"cron_limit";i:100;s:11:"overlap_cjk";b:1;s:17:"minimum_word_size";i:3;s:11:"tag_weights";a:12:{s:2:"h1";i:25;s:2:"h2";i:18;s:2:"h3";i:15;s:2:"h4";i:14;s:2:"h5";i:9;s:2:"h6";i:6;s:1:"u";i:3;s:1:"b";i:3;s:1:"i";i:3;s:6:"strong";i:3;s:2:"em";i:3;s:1:"a";i:10;}}s:7:"logging";b:0;}'),
('', 'shortcut.set.default', 'a:7:{s:4:"uuid";s:36:"cc0036e0-36ed-4fd6-a6a9-b641cc6e5e40";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"U5VlGjd_SfV0Qm_EfnaynOfc549cNscFAx48JfYoMRI";}s:2:"id";s:7:"default";s:5:"label";s:7:"Default";}'),
('', 'system.action.comment_delete_action', 'a:10:{s:4:"uuid";s:36:"088fd079-0dc7-4d31-ad8f-eb610eceea9b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:7:"comment";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"vpBH8OmL4sdesCdeZLsW8KOutB5gkbreWJbfjhfFKaQ";}s:2:"id";s:21:"comment_delete_action";s:5:"label";s:14:"Delete comment";s:4:"type";s:7:"comment";s:6:"plugin";s:28:"entity:delete_action:comment";s:13:"configuration";a:0:{}}'),
('', 'system.action.comment_publish_action', 'a:10:{s:4:"uuid";s:36:"e782b924-3de4-4c8a-a07b-e8031fbd83a5";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:7:"comment";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"C00dyL_W_5M0nFlgUB3lWUTUs96jn51Jw1MLHVEHZD0";}s:2:"id";s:22:"comment_publish_action";s:5:"label";s:15:"Publish comment";s:4:"type";s:7:"comment";s:6:"plugin";s:29:"entity:publish_action:comment";s:13:"configuration";a:0:{}}'),
('', 'system.action.comment_save_action', 'a:10:{s:4:"uuid";s:36:"37ba85bb-3984-4adb-bb8b-6bbcbfa1bd42";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:7:"comment";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"lfyE_snmvfg_EQ3VDyhUtGAXgmqtEiqa46I3bTMg8DU";}s:2:"id";s:19:"comment_save_action";s:5:"label";s:12:"Save comment";s:4:"type";s:7:"comment";s:6:"plugin";s:26:"entity:save_action:comment";s:13:"configuration";a:0:{}}'),
('', 'system.action.comment_unpublish_action', 'a:10:{s:4:"uuid";s:36:"7df8c639-b650-49eb-8231-58ded75b5670";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:7:"comment";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"tWOIjSMobEWOFZddMkNqb9JySbOVwE1diC6NRqcfLTk";}s:2:"id";s:24:"comment_unpublish_action";s:5:"label";s:17:"Unpublish comment";s:4:"type";s:7:"comment";s:6:"plugin";s:31:"entity:unpublish_action:comment";s:13:"configuration";a:0:{}}'),
('', 'system.action.node_delete_action', 'a:10:{s:4:"uuid";s:36:"9ec4ec59-dc49-404a-a927-17bc884025e3";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"t43OqwzP3CTbcAagSsWKNy6KwMm_zShXo3c4-So6rQg";}s:2:"id";s:18:"node_delete_action";s:5:"label";s:14:"Delete content";s:4:"type";s:4:"node";s:6:"plugin";s:25:"entity:delete_action:node";s:13:"configuration";a:0:{}}'),
('', 'system.action.node_make_sticky_action', 'a:10:{s:4:"uuid";s:36:"0b2884ec-88f0-40e5-985e-bced18631d85";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"sOb26JSy3fGpWkvR0WYN6_hMqj_6d1rvbvrkzp1yya0";}s:2:"id";s:23:"node_make_sticky_action";s:5:"label";s:19:"Make content sticky";s:4:"type";s:4:"node";s:6:"plugin";s:23:"node_make_sticky_action";s:13:"configuration";a:0:{}}'),
('', 'system.action.node_make_unsticky_action', 'a:10:{s:4:"uuid";s:36:"aefb0d8d-32e3-4b6b-8f21-52f5e6b29038";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"lDM9mvIGAu8Sw8rt-uCO4Sr7yX5VPrDPxYcawkbKd6k";}s:2:"id";s:25:"node_make_unsticky_action";s:5:"label";s:21:"Make content unsticky";s:4:"type";s:4:"node";s:6:"plugin";s:25:"node_make_unsticky_action";s:13:"configuration";a:0:{}}'),
('', 'system.action.node_promote_action', 'a:10:{s:4:"uuid";s:36:"60afe495-595d-407c-b1e6-9dac2100ba52";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"N0RDBTqiK4dKoN4p4oW2j0SGWycdHyALUe9M-Ofp89U";}s:2:"id";s:19:"node_promote_action";s:5:"label";s:29:"Promote content to front page";s:4:"type";s:4:"node";s:6:"plugin";s:19:"node_promote_action";s:13:"configuration";a:0:{}}'),
('', 'system.action.node_publish_action', 'a:10:{s:4:"uuid";s:36:"edd325fe-35ab-4824-8443-4a25ad49982d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"2B9uF8NL5gutNKSdPRAhhAsDWFZZG1PJOBmx0aBGd_0";}s:2:"id";s:19:"node_publish_action";s:5:"label";s:15:"Publish content";s:4:"type";s:4:"node";s:6:"plugin";s:26:"entity:publish_action:node";s:13:"configuration";a:0:{}}'),
('', 'system.action.node_save_action', 'a:10:{s:4:"uuid";s:36:"94ba7c38-517b-49f9-ac4b-205c5cea23f9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"LhdsoZPL_pFas2fjaAWue4zvrQ_tEVofLYtcNec-JGM";}s:2:"id";s:16:"node_save_action";s:5:"label";s:12:"Save content";s:4:"type";s:4:"node";s:6:"plugin";s:23:"entity:save_action:node";s:13:"configuration";a:0:{}}'),
('', 'system.action.node_unpromote_action', 'a:10:{s:4:"uuid";s:36:"22a0db98-30bd-4af1-abf1-c2b921e3b8e2";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"JBptjnfuOMtsdKygklXxoOgeOCTMtQxlkymjnnj-cC0";}s:2:"id";s:21:"node_unpromote_action";s:5:"label";s:30:"Remove content from front page";s:4:"type";s:4:"node";s:6:"plugin";s:21:"node_unpromote_action";s:13:"configuration";a:0:{}}'),
('', 'system.action.node_unpublish_action', 'a:10:{s:4:"uuid";s:36:"3b5393d3-b935-44e5-b051-320ee2aa98b8";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"C7X8h9FWlwkQ9y5mnU2JzgaZICAdc6HFbPVbhvjlAYE";}s:2:"id";s:21:"node_unpublish_action";s:5:"label";s:17:"Unpublish content";s:4:"type";s:4:"node";s:6:"plugin";s:28:"entity:unpublish_action:node";s:13:"configuration";a:0:{}}'),
('', 'system.action.taxonomy_term_publish_action', 'a:10:{s:4:"uuid";s:36:"8109fd7b-b7ba-4857-b19c-a9cb5ec2e110";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:8:"taxonomy";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"DoVt_VGgVLcDD4XmVbSFzr0K17SJy9imFiYusKkJBgY";}s:2:"id";s:28:"taxonomy_term_publish_action";s:5:"label";s:21:"Publish taxonomy term";s:4:"type";s:13:"taxonomy_term";s:6:"plugin";s:35:"entity:publish_action:taxonomy_term";s:13:"configuration";a:0:{}}'),
('', 'system.action.taxonomy_term_unpublish_action', 'a:10:{s:4:"uuid";s:36:"48c3edac-1733-4f67-893d-599c3fec5abe";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:8:"taxonomy";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"z2sNRM3ECa7FPCGnSNje_9SmZJQgwhD_6fG_L4Mr8zI";}s:2:"id";s:30:"taxonomy_term_unpublish_action";s:5:"label";s:23:"Unpublish taxonomy term";s:4:"type";s:13:"taxonomy_term";s:6:"plugin";s:37:"entity:unpublish_action:taxonomy_term";s:13:"configuration";a:0:{}}'),
('', 'system.action.user_add_role_action.administrator', 'a:9:{s:4:"uuid";s:36:"dd6e043f-d565-4687-939b-6a7dc07cde67";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:23:"user.role.administrator";}s:6:"module";a:1:{i:0;s:4:"user";}}s:2:"id";s:34:"user_add_role_action.administrator";s:5:"label";s:50:"Add the Administrator role to the selected user(s)";s:4:"type";s:4:"user";s:6:"plugin";s:20:"user_add_role_action";s:13:"configuration";a:1:{s:3:"rid";s:13:"administrator";}}'),
('', 'system.action.user_add_role_action.content_editor', 'a:9:{s:4:"uuid";s:36:"296519cc-dac9-4b9b-9ee7-5d89d0b26956";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:24:"user.role.content_editor";}s:6:"module";a:1:{i:0;s:4:"user";}}s:2:"id";s:35:"user_add_role_action.content_editor";s:5:"label";s:51:"Add the Content editor role to the selected user(s)";s:4:"type";s:4:"user";s:6:"plugin";s:20:"user_add_role_action";s:13:"configuration";a:1:{s:3:"rid";s:14:"content_editor";}}'),
('', 'system.action.user_block_user_action', 'a:10:{s:4:"uuid";s:36:"09b2053e-4ff7-4cb7-bf30-5f110a9d3e36";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"DyypzTfThX10FFQw-399qPfEbLLyrhXgQrKPVsmAoJ4";}s:2:"id";s:22:"user_block_user_action";s:5:"label";s:26:"Block the selected user(s)";s:4:"type";s:4:"user";s:6:"plugin";s:22:"user_block_user_action";s:13:"configuration";a:0:{}}'),
('', 'system.action.user_cancel_user_action', 'a:10:{s:4:"uuid";s:36:"0635e00a-000b-4330-a736-0b6f50b82429";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"nvrL9bFilzBvm2bjO9rQnFDpBA7dBBUjShSSt6NS-DU";}s:2:"id";s:23:"user_cancel_user_action";s:5:"label";s:35:"Cancel the selected user account(s)";s:4:"type";s:4:"user";s:6:"plugin";s:23:"user_cancel_user_action";s:13:"configuration";a:0:{}}'),
('', 'system.action.user_remove_role_action.administrator', 'a:9:{s:4:"uuid";s:36:"c1ea29c6-9c9a-4393-944d-3f9b6608f8af";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:23:"user.role.administrator";}s:6:"module";a:1:{i:0;s:4:"user";}}s:2:"id";s:37:"user_remove_role_action.administrator";s:5:"label";s:55:"Remove the Administrator role from the selected user(s)";s:4:"type";s:4:"user";s:6:"plugin";s:23:"user_remove_role_action";s:13:"configuration";a:1:{s:3:"rid";s:13:"administrator";}}'),
('', 'system.action.user_remove_role_action.content_editor', 'a:9:{s:4:"uuid";s:36:"ccd6fe1c-c1ef-4a13-85c3-434e1035993a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:24:"user.role.content_editor";}s:6:"module";a:1:{i:0;s:4:"user";}}s:2:"id";s:38:"user_remove_role_action.content_editor";s:5:"label";s:56:"Remove the Content editor role from the selected user(s)";s:4:"type";s:4:"user";s:6:"plugin";s:23:"user_remove_role_action";s:13:"configuration";a:1:{s:3:"rid";s:14:"content_editor";}}'),
('', 'system.action.user_unblock_user_action', 'a:10:{s:4:"uuid";s:36:"79cf4a88-adcd-4b19-8c18-b8680c6efebf";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"SPsUXsR3Rc8d1y3gewzaAKWa1ncea_ywXX3f7LTn7k0";}s:2:"id";s:24:"user_unblock_user_action";s:5:"label";s:28:"Unblock the selected user(s)";s:4:"type";s:4:"user";s:6:"plugin";s:24:"user_unblock_user_action";s:13:"configuration";a:0:{}}'),
('', 'system.advisories', 'a:3:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"x0FuQ_7Cg81mSDQwG028_Z0CjH3R9ib5IDlHeV2BbAo";}s:7:"enabled";b:1;s:14:"interval_hours";i:6;}'),
('', 'system.cron', 'a:3:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"f3yToH8v8EaBZU0NFFw2qR8ogSCuWVmQaN0hpYR1BD8";}s:9:"threshold";a:2:{s:20:"requirements_warning";i:172800;s:18:"requirements_error";i:1209600;}s:7:"logging";b:1;}'),
('', 'system.date', 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"IVsFTD1mvR2NGBP_1myt9kFIFmGepH4PyaN5aQBYpno";}s:9:"first_day";i:0;s:7:"country";a:1:{s:7:"default";N;}s:8:"timezone";a:2:{s:7:"default";s:3:"UTC";s:4:"user";a:3:{s:12:"configurable";b:1;s:7:"default";i:0;s:4:"warn";b:0;}}}'),
('', 'system.diff', 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"1WanmaEhxW_vM8_5Ktsdntj8MaO9UBHXg0lN603PsWM";}s:7:"context";a:2:{s:13:"lines_leading";i:2;s:14:"lines_trailing";i:2;}}'),
('', 'system.feature_flags', 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ZYyVj1FtPGV40Cf65YDVTUIc7YgLH6trXlotuevfs2I";}s:16:"linkset_endpoint";b:0;}'),
('', 'system.file', 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"mguGHCYb9Dw5EcpfjwoShGV1Vjkbz3QuPRCLfxiye-g";}s:22:"allow_insecure_uploads";b:0;s:14:"default_scheme";s:6:"public";s:21:"temporary_maximum_age";i:21600;}'),
('', 'system.image', 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"durWHaKeBaq4d9Wpi4RqwADj1OufDepcnJuhVLmKN24";}s:7:"toolkit";s:2:"gd";}'),
('', 'system.image.gd', 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"eNXaHfkJJUThHeF0nvkoXyPLRrKYGxgHRjORvT4F5rQ";}s:12:"jpeg_quality";i:75;}'),
('', 'system.logging', 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"u3-njszl92FaxjrCMiq0yDcjAfcdx72w1zT1O9dx6aA";}s:11:"error_level";s:4:"hide";}'),
('', 'system.mail', 'a:3:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"5PvD9swkqWUeHkabdvbJ2SQqdhrzjkCT21wtD4BLfk4";}s:9:"interface";a:1:{s:7:"default";s:8:"php_mail";}s:10:"mailer_dsn";a:6:{s:6:"scheme";s:8:"sendmail";s:4:"host";s:7:"default";s:4:"user";N;s:8:"password";N;s:4:"port";N;s:7:"options";a:0:{}}}'),
('', 'system.maintenance', 'a:3:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"1SNdA25INsV5YjlgAJtfC-6AM8VcWe_00xneMLb2yFg";}s:8:"langcode";s:2:"en";s:7:"message";s:93:"@site is currently under maintenance. We should be back shortly. Thank you for your patience.";}'),
('', 'system.menu.account', 'a:9:{s:4:"uuid";s:36:"0e483e1d-3e9e-468c-9c3f-55f233b130b4";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"M_Bh81osDyUQ4wV0GgU_NdBNqkzM87sLxjaCdFj9mnw";}s:2:"id";s:7:"account";s:5:"label";s:17:"User account menu";s:11:"description";s:40:"Links related to the active user account";s:6:"locked";b:1;}'),
('', 'system.menu.admin', 'a:9:{s:4:"uuid";s:36:"75f33fc1-6fe2-4cc0-b526-860fe3fab452";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"sapEi2YDGoI9yQIT_WgIV2vUdQ6DScH0V3fAyTadAL0";}s:2:"id";s:5:"admin";s:5:"label";s:14:"Administration";s:11:"description";s:25:"Administrative task links";s:6:"locked";b:1;}'),
('', 'system.menu.footer', 'a:9:{s:4:"uuid";s:36:"c05ccf3a-4a4e-433a-9933-9b1762f82809";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"7yrlW5z9zdg2eBucB2GPqXKSMQfH9lSRSO4DbWF7AFc";}s:2:"id";s:6:"footer";s:5:"label";s:6:"Footer";s:11:"description";s:22:"Site information links";s:6:"locked";b:1;}'),
('', 'system.menu.main', 'a:9:{s:4:"uuid";s:36:"eac28f88-5d1c-4b10-9344-65491b60ac3b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Q2Ra3jfoIVk0f3SjxJX61byRQFVBAbpzYDQOiY-kno8";}s:2:"id";s:4:"main";s:5:"label";s:15:"Main navigation";s:11:"description";s:18:"Site section links";s:6:"locked";b:1;}'),
('', 'system.menu.tools', 'a:9:{s:4:"uuid";s:36:"3558f8a2-105d-4f80-8d70-39fb5ca5a27e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"BCM-vV1zzRaLHN18dqAR_CuGOj8AFJvTx7BKl_8Gcxc";}s:2:"id";s:5:"tools";s:5:"label";s:5:"Tools";s:11:"description";s:39:"User tool links, often added by modules";s:6:"locked";b:1;}'),
('', 'system.performance', 'a:5:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"jtno5biznHZbrIgKwzq-ze-7XaQxLCGe6PeUOR7bRiQ";}s:5:"cache";a:1:{s:4:"page";a:1:{s:7:"max_age";i:0;}}s:3:"css";a:2:{s:10:"preprocess";b:1;s:4:"gzip";b:1;}s:8:"fast_404";a:4:{s:7:"enabled";b:1;s:5:"paths";s:69:"/\\.(?:txt|png|gif|jpe?g|css|js|ico|swf|flv|cgi|bat|pl|dll|exe|asp)$/i";s:13:"exclude_paths";s:27:"/\\/(?:styles|imagecache)\\//";s:4:"html";s:162:"<!DOCTYPE html><html><head><title>404 Not Found</title></head><body><h1>Not Found</h1><p>The requested URL "@path" was not found on this server.</p></body></html>";}s:2:"js";a:2:{s:10:"preprocess";b:1;s:4:"gzip";b:1;}}'),
('', 'system.rss', 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"MIpNzlG4gPunfS7vTCwUPum6QH3GUsEBMj-qS631Jw0";}s:5:"items";a:1:{s:9:"view_mode";s:3:"rss";}}'),
('', 'system.site', 'a:11:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ijfbzDTN4CbE7Sr-6ubWzy_t1vH4OtU1doNCLssVz-4";}s:8:"langcode";s:2:"en";s:4:"uuid";s:36:"7449dfe3-03bb-4168-9968-c4aedc3130df";s:4:"name";[[ser_site_name]]s:4:"mail";[[site_mail]]s:6:"slogan";s:0:"";s:4:"page";a:3:{i:403;s:0:"";i:404;s:0:"";s:5:"front";s:5:"/node";}s:18:"admin_compact_mode";b:0;s:17:"weight_select_max";i:100;s:16:"default_langcode";s:2:"en";s:17:"mail_notification";N;}'),
('', 'system.theme', 'a:3:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"eJ529VM1gSIA_vgTy2PdiDvJuG0xhSxfQjCyl5WKlv4";}s:5:"admin";s:5:"claro";s:7:"default";s:7:"olivero";}'),
('', 'system.theme.global', 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"KZiV2LB312xgJBphfq5BTjmp16xiR5KM8InBJ-pff7Y";}s:7:"favicon";a:4:{s:8:"mimetype";s:24:"image/vnd.microsoft.icon";s:4:"path";s:0:"";s:3:"url";s:0:"";s:11:"use_default";b:1;}s:8:"features";a:4:{s:20:"comment_user_picture";b:1;s:25:"comment_user_verification";b:1;s:7:"favicon";b:1;s:17:"node_user_picture";b:1;}s:4:"logo";a:3:{s:4:"path";s:0:"";s:3:"url";N;s:11:"use_default";b:1;}}'),
('', 'taxonomy.settings', 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"zKpaWT6cJc1tVQQaTqatGELaCqU_oyRym6zTl27Yias";}s:20:"maintain_index_table";b:1;s:17:"override_selector";b:0;s:20:"terms_per_page_admin";i:100;}'),
('', 'taxonomy.vocabulary.tags', 'a:10:{s:4:"uuid";s:36:"d7d858dc-ee4a-4073-8bf0-3ddf92c9958e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"iTEzwrEQ_4JIb-OYGiqzyF2TmMgWyWayresXcWgwGWM";}s:4:"name";s:4:"Tags";s:3:"vid";s:4:"tags";s:11:"description";s:61:"Use tags to group articles on similar topics into categories.";s:6:"weight";i:0;s:12:"new_revision";b:0;}'),
('', 'text.settings', 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Bkewb77RBOK3_aXMPsp8p87gbc03NvmC5gBLzPl7hVA";}s:22:"default_summary_length";i:600;}'),
('', 'update.settings', 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"xbYr66-g0FjNgVBkGypCuN46vBI2XHntXN1URawq1s4";}s:5:"check";a:2:{s:19:"disabled_extensions";b:0;s:13:"interval_days";i:1;}s:5:"fetch";a:3:{s:3:"url";N;s:12:"max_attempts";i:2;s:7:"timeout";i:30;}s:12:"notification";a:2:{s:6:"emails";a:1:{i:0;[[site_mail]]}s:9:"threshold";s:3:"all";}}'),
('', 'user.flood', 'a:6:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"UYfMzeP1S8jKm9PSvxf7nQNe8DsNS-3bc2WSNNXBQWs";}s:8:"uid_only";b:0;s:8:"ip_limit";i:50;s:9:"ip_window";i:3600;s:10:"user_limit";i:5;s:11:"user_window";i:21600;}');
INSERT INTO `[[dbprefix]]config` VALUES
('', 'user.mail', 'a:11:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"6CZIzFifRq3qbdq3n3nDpEOO4hWIQtKOAQNPvGNGKeM";}s:8:"langcode";s:2:"en";s:14:"cancel_confirm";a:2:{s:7:"subject";s:67:"Account cancellation request for [user:display-name] at [site:name]";s:4:"body";s:376:"[user:display-name]\n\nA request to cancel your account has been made at [site:name].\n\nYou may now cancel your account on [site:url-brief] by clicking this link or copying and pasting it into your browser:\n\n[user:cancel-url]\n\nNOTE: The cancellation of your account is not reversible.\n\nThis link expires in one day and nothing will happen if it is not used.\n\n--  [site:name] team";}s:14:"password_reset";a:2:{s:7:"subject";s:68:"Replacement login information for [user:display-name] at [site:name]";s:4:"body";s:407:"[user:display-name],\n\nA request to reset the password for your account has been made at [site:name].\n\nYou may now log in by clicking this link or copying and pasting it into your browser:\n\n[user:one-time-login-url]\n\nThis link can only be used once to log in and will lead you to a page where you can set your password. It expires after one day and nothing will happen if it''s not used.\n\n--  [site:name] team";}s:22:"register_admin_created";a:2:{s:7:"subject";s:58:"An administrator created an account for you at [site:name]";s:4:"body";s:473:"[user:display-name],\n\nA site administrator at [site:name] has created an account for you. You may now log in by clicking this link or copying and pasting it into your browser:\n\n[user:one-time-login-url]\n\nThis link can only be used once to log in and will lead you to a page where you can set your password.\n\nAfter setting your password, you will be able to log in at [site:login-url] in the future using:\n\nusername: [user:name]\npassword: Your password\n\n--  [site:name] team";}s:29:"register_no_approval_required";a:2:{s:7:"subject";s:54:"Account details for [user:display-name] at [site:name]";s:4:"body";s:447:"[user:display-name],\n\nThank you for registering at [site:name]. You may now log in by clicking this link or copying and pasting it into your browser:\n\n[user:one-time-login-url]\n\nThis link can only be used once to log in and will lead you to a page where you can set your password.\n\nAfter setting your password, you will be able to log in at [site:login-url] in the future using:\n\nusername: [user:name]\npassword: Your password\n\n--  [site:name] team";}s:25:"register_pending_approval";a:2:{s:7:"subject";s:79:"Account details for [user:display-name] at [site:name] (pending admin approval)";s:4:"body";s:288:"[user:display-name],\n\nThank you for registering at [site:name]. Your application for an account is currently pending approval. Once it has been approved, you will receive another email containing information about how to log in, set your password, and other details.\n\n--  [site:name] team";}s:31:"register_pending_approval_admin";a:2:{s:7:"subject";s:79:"Account details for [user:display-name] at [site:name] (pending admin approval)";s:4:"body";s:64:"[user:display-name] has applied for an account.\n\n[user:edit-url]";}s:16:"status_activated";a:2:{s:7:"subject";s:65:"Account details for [user:display-name] at [site:name] (approved)";s:4:"body";s:462:"[user:display-name],\n\nYour account at [site:name] has been activated.\n\nYou may now log in by clicking this link or copying and pasting it into your browser:\n\n[user:one-time-login-url]\n\nThis link can only be used once to log in and will lead you to a page where you can set your password.\n\nAfter setting your password, you will be able to log in at [site:login-url] in the future using:\n\nusername: [user:account-name]\npassword: Your password\n\n--  [site:name] team";}s:14:"status_blocked";a:2:{s:7:"subject";s:64:"Account details for [user:display-name] at [site:name] (blocked)";s:4:"body";s:89:"[user:display-name],\n\nYour account on [site:name] has been blocked.\n\n--  [site:name] team";}s:15:"status_canceled";a:2:{s:7:"subject";s:65:"Account details for [user:display-name] at [site:name] (canceled)";s:4:"body";s:90:"[user:display-name],\n\nYour account on [site:name] has been canceled.\n\n--  [site:name] team";}}'),
('', 'user.role.administrator', 'a:10:{s:4:"uuid";s:36:"5f94b210-364f-4940-aae2-ed46d75923f0";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"OeKGIkmZA_c-t6QLH81WNQx8gDCc1MRmxaTuQgxBByU";}s:2:"id";s:13:"administrator";s:5:"label";s:13:"Administrator";s:6:"weight";i:3;s:8:"is_admin";b:1;s:11:"permissions";a:0:{}}'),
('', 'user.role.anonymous', 'a:10:{s:4:"uuid";s:36:"4880cb04-4407-4b43-a4ad-5ba851e7937d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:29:"filter.format.restricted_html";}s:6:"module";a:5:{i:0;s:7:"comment";i:1;s:7:"contact";i:2;s:6:"filter";i:3;s:6:"search";i:4;s:6:"system";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"6WavjUYXIegP9AAg2zXGx54MWIVoomC3SZhNiqe-Dyk";}s:2:"id";s:9:"anonymous";s:5:"label";s:14:"Anonymous user";s:6:"weight";i:0;s:8:"is_admin";b:0;s:11:"permissions";a:5:{i:0;s:15:"access comments";i:1;s:14:"access content";i:2;s:29:"access site-wide contact form";i:3;s:14:"search content";i:4;s:31:"use text format restricted_html";}}'),
('', 'user.role.authenticated', 'a:10:{s:4:"uuid";s:36:"cacfa375-dc02-487e-aae6-860a1631cdbf";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:24:"filter.format.basic_html";}s:6:"module";a:7:{i:0;s:7:"comment";i:1;s:7:"contact";i:2;s:4:"file";i:3;s:6:"filter";i:4;s:6:"search";i:5;s:8:"shortcut";i:6;s:6:"system";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"cFrlqjtkTfvY3RGccjJkPf1SGIfJ942IrxTLWAO4mgA";}s:2:"id";s:13:"authenticated";s:5:"label";s:18:"Authenticated user";s:6:"weight";i:1;s:8:"is_admin";b:0;s:11:"permissions";a:9:{i:0;s:15:"access comments";i:1;s:14:"access content";i:2;s:16:"access shortcuts";i:3;s:29:"access site-wide contact form";i:4;s:16:"delete own files";i:5;s:13:"post comments";i:6;s:14:"search content";i:7;s:21:"skip comment approval";i:8;s:26:"use text format basic_html";}}'),
('', 'user.role.content_editor', 'a:10:{s:4:"uuid";s:36:"c5e78700-dc65-4cee-9f91-0cc2458bbfa2";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:17:"node.type.article";i:1;s:14:"node.type.page";i:2;s:24:"taxonomy.vocabulary.tags";}s:6:"module";a:8:{i:0;s:7:"comment";i:1;s:10:"contextual";i:2;s:4:"file";i:3;s:4:"node";i:4;s:4:"path";i:5;s:6:"system";i:6;s:8:"taxonomy";i:7;s:7:"toolbar";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"e_wG1u7SrGaJbY2-Szgbgl-c8T3kdirU3uTNq2c_QJQ";}s:2:"id";s:14:"content_editor";s:5:"label";s:14:"Content editor";s:6:"weight";i:2;s:8:"is_admin";b:0;s:11:"permissions";a:23:{i:0;s:27:"access administration pages";i:1;s:23:"access content overview";i:2;s:23:"access contextual links";i:3;s:21:"access files overview";i:4;s:14:"access toolbar";i:5;s:22:"administer url aliases";i:6;s:22:"create article content";i:7;s:19:"create page content";i:8;s:20:"create terms in tags";i:9;s:18:"create url aliases";i:10;s:24:"delete article revisions";i:11;s:26:"delete own article content";i:12;s:16:"delete own files";i:13;s:23:"delete own page content";i:14;s:21:"delete page revisions";i:15;s:24:"edit own article content";i:16;s:17:"edit own comments";i:17;s:21:"edit own page content";i:18;s:18:"edit terms in tags";i:19;s:20:"revert all revisions";i:20;s:18:"view all revisions";i:21;s:28:"view own unpublished content";i:22;s:29:"view the administration theme";}}'),
('', 'user.settings', 'a:9:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"-htDFWUv1S4OlJMzta2nhFl4QbhJvu0D9xsJ-clxo-M";}s:8:"langcode";s:2:"en";s:9:"anonymous";s:9:"Anonymous";s:11:"verify_mail";b:1;s:6:"notify";a:8:{s:14:"cancel_confirm";b:1;s:14:"password_reset";b:1;s:16:"status_activated";b:1;s:14:"status_blocked";b:0;s:15:"status_canceled";b:0;s:22:"register_admin_created";b:1;s:29:"register_no_approval_required";b:1;s:25:"register_pending_approval";b:1;}s:8:"register";s:23:"visitors_admin_approval";s:13:"cancel_method";s:17:"user_cancel_block";s:22:"password_reset_timeout";i:86400;s:17:"password_strength";b:1;}'),
('', 'views.settings', 'a:5:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"8oDr9oPVb_ostrNnVV6V7VdphwoH_u-NqTS0u7SE7qc";}s:17:"display_extenders";a:0:{}s:13:"sql_signature";b:0;s:2:"ui";a:3:{s:4:"show";a:7:{s:18:"additional_queries";b:0;s:15:"advanced_column";b:0;s:15:"default_display";b:0;s:22:"performance_statistics";b:0;s:19:"preview_information";b:1;s:9:"sql_query";a:2:{s:7:"enabled";b:0;s:5:"where";s:5:"above";}s:13:"display_embed";b:0;}s:19:"always_live_preview";b:1;s:24:"exposed_filter_any_label";s:7:"old_any";}s:22:"field_rewrite_elements";a:29:{s:3:"div";s:3:"DIV";s:4:"span";s:4:"SPAN";s:2:"h1";s:2:"H1";s:2:"h2";s:2:"H2";s:2:"h3";s:2:"H3";s:2:"h4";s:2:"H4";s:2:"h5";s:2:"H5";s:2:"h6";s:2:"H6";s:1:"p";s:1:"P";s:6:"header";s:6:"HEADER";s:6:"footer";s:6:"FOOTER";s:7:"article";s:7:"ARTICLE";s:7:"section";s:7:"SECTION";s:5:"aside";s:5:"ASIDE";s:7:"details";s:7:"DETAILS";s:10:"blockquote";s:10:"BLOCKQUOTE";s:6:"figure";s:6:"FIGURE";s:7:"address";s:7:"ADDRESS";s:4:"code";s:4:"CODE";s:3:"pre";s:3:"PRE";s:3:"var";s:3:"VAR";s:4:"samp";s:4:"SAMP";s:3:"kbd";s:3:"KBD";s:6:"strong";s:6:"STRONG";s:2:"em";s:2:"EM";s:3:"del";s:3:"DEL";s:3:"ins";s:3:"INS";s:1:"q";s:1:"Q";s:1:"s";s:1:"S";}}'),
('', 'views.view.archive', 'a:13:{s:4:"uuid";s:36:"f0636ddf-80bf-45ab-928f-c3b40ef7d43a";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:33:"core.entity_view_mode.node.teaser";}s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"exIF08PTvYSK6tJCsAzBqMEKUBKIptPorMn74SVhevc";}s:2:"id";s:7:"archive";s:5:"label";s:7:"Archive";s:6:"module";s:4:"node";s:11:"description";s:22:"All content, by month.";s:3:"tag";s:7:"default";s:10:"base_table";s:15:"node_field_data";s:10:"base_field";s:3:"nid";s:7:"display";a:3:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:17:{s:5:"title";s:15:"Monthly archive";s:6:"fields";a:0:{}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:7:{s:6:"offset";i:0;s:24:"pagination_heading_level";s:2:"h4";s:14:"items_per_page";i:10;s:11:"total_pages";i:0;s:2:"id";i:0;s:4:"tags";a:2:{s:4:"next";s:6:"››";s:8:"previous";s:6:"‹‹";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:14:"access content";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:0:{}s:5:"sorts";a:1:{s:7:"created";a:13:{s:2:"id";s:7:"created";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"created";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:7:"created";}s:7:"exposed";b:0;s:11:"granularity";s:6:"second";}}s:9:"arguments";a:1:{s:18:"created_year_month";a:13:{s:2:"id";s:18:"created_year_month";s:5:"table";s:15:"node_field_data";s:5:"field";s:18:"created_year_month";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:15:"date_year_month";s:14:"default_action";s:7:"summary";s:9:"exception";a:1:{s:12:"title_enable";b:1;}s:12:"title_enable";b:1;s:5:"title";s:34:"{{ arguments.created_year_month }}";s:21:"default_argument_type";s:5:"fixed";s:15:"summary_options";a:2:{s:8:"override";b:1;s:14:"items_per_page";i:30;}s:7:"summary";a:2:{s:10:"sort_order";s:4:"desc";s:6:"format";s:15:"default_summary";}s:18:"specify_validation";b:1;}}s:7:"filters";a:2:{s:6:"status";a:9:{s:2:"id";s:6:"status";s:5:"table";s:15:"node_field_data";s:5:"field";s:6:"status";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:5:"value";s:1:"1";s:5:"group";i:0;s:6:"expose";a:3:{s:8:"operator";s:1:"0";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:15:"node_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:1:{s:31:"***LANGUAGE_language_content***";s:31:"***LANGUAGE_language_content***";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:13:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:7:"default";s:7:"options";a:4:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:11:"uses_fields";b:0;}}s:3:"row";a:2:{s:4:"type";s:11:"entity:node";s:7:"options";a:1:{s:9:"view_mode";s:6:"teaser";}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:0:{}s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:21:"user.node_grants:view";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:7:"block_1";a:6:{s:2:"id";s:7:"block_1";s:13:"display_title";s:5:"Block";s:14:"display_plugin";s:5:"block";s:8:"position";i:1;s:15:"display_options";a:4:{s:9:"arguments";a:1:{s:18:"created_year_month";a:13:{s:2:"id";s:18:"created_year_month";s:5:"table";s:15:"node_field_data";s:5:"field";s:18:"created_year_month";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:15:"date_year_month";s:14:"default_action";s:7:"summary";s:9:"exception";a:1:{s:12:"title_enable";b:1;}s:12:"title_enable";b:1;s:5:"title";s:34:"{{ arguments.created_year_month }}";s:21:"default_argument_type";s:5:"fixed";s:15:"summary_options";a:1:{s:14:"items_per_page";i:30;}s:7:"summary";a:1:{s:6:"format";s:15:"default_summary";}s:18:"specify_validation";b:1;}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:0:{}}s:8:"defaults";a:1:{s:9:"arguments";b:0;}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:21:"user.node_grants:view";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:2;s:15:"display_options";a:3:{s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:0:{}}s:17:"display_extenders";a:0:{}s:4:"path";s:7:"archive";}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:21:"user.node_grants:view";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}'),
('', 'views.view.block_content', 'a:13:{s:4:"uuid";s:36:"9b35c2bb-5cc1-4327-801f-b4745838dd4a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:13:"block_content";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"HfvTcWhiVuvxchoh4DjIkXhKkj9ow2TGgHkLHSvRLq8";}s:2:"id";s:13:"block_content";s:5:"label";s:14:"Content blocks";s:6:"module";s:5:"views";s:11:"description";s:31:"Find and manage content blocks.";s:3:"tag";s:7:"default";s:10:"base_table";s:24:"block_content_field_data";s:10:"base_field";s:2:"id";s:7:"display";a:2:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:17:{s:5:"title";s:14:"Content blocks";s:6:"fields";a:4:{s:4:"info";a:37:{s:2:"id";s:4:"info";s:5:"table";s:24:"block_content_field_data";s:5:"field";s:4:"info";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";N;s:12:"entity_field";s:4:"info";s:9:"plugin_id";s:5:"field";s:5:"label";s:17:"Block description";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:6:"string";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:4:"type";a:37:{s:2:"id";s:4:"type";s:5:"table";s:24:"block_content_field_data";s:5:"field";s:4:"type";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"block_content";s:12:"entity_field";s:4:"type";s:9:"plugin_id";s:5:"field";s:5:"label";s:10:"Block type";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:0;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:7:"changed";a:26:{s:2:"id";s:7:"changed";s:5:"table";s:24:"block_content_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"block_content";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:7:"Updated";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"timestamp";s:8:"settings";a:5:{s:11:"date_format";s:5:"short";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";s:7:"tooltip";a:2:{s:11:"date_format";s:4:"long";s:18:"custom_date_format";s:0:"";}s:9:"time_diff";a:5:{s:7:"enabled";b:0;s:13:"future_format";s:15:"@interval hence";s:11:"past_format";s:13:"@interval ago";s:11:"granularity";i:2;s:7:"refresh";i:60;}}}s:10:"operations";a:24:{s:2:"id";s:10:"operations";s:5:"table";s:13:"block_content";s:5:"field";s:10:"operations";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"block_content";s:9:"plugin_id";s:17:"entity_operations";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"destination";b:1;}}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:7:{s:6:"offset";i:0;s:24:"pagination_heading_level";s:2:"h4";s:14:"items_per_page";i:50;s:11:"total_pages";N;s:2:"id";i:0;s:4:"tags";a:2:{s:4:"next";s:8:"Next ›";s:8:"previous";s:12:"‹ Previous";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:1;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:20:"access block library";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:2:{s:16:"area_text_custom";a:10:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:38:"There are no content blocks available.";s:8:"tokenize";b:0;}s:27:"block_content_listing_empty";a:10:{s:2:"id";s:27:"block_content_listing_empty";s:5:"table";s:13:"block_content";s:5:"field";s:27:"block_content_listing_empty";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"block_content";s:9:"plugin_id";s:27:"block_content_listing_empty";s:5:"label";s:0:"";s:5:"empty";b:1;}}s:5:"sorts";a:0:{}s:9:"arguments";a:0:{}s:7:"filters";a:3:{s:4:"info";a:16:{s:2:"id";s:4:"info";s:5:"table";s:24:"block_content_field_data";s:5:"field";s:4:"info";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"block_content";s:12:"entity_field";s:4:"info";s:9:"plugin_id";s:6:"string";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:7:"info_op";s:5:"label";s:17:"Block description";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:7:"info_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"info";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:4:"type";a:16:{s:2:"id";s:4:"type";s:5:"table";s:24:"block_content_field_data";s:5:"field";s:4:"type";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"block_content";s:12:"entity_field";s:4:"type";s:9:"plugin_id";s:6:"bundle";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:7:"type_op";s:5:"label";s:10:"Block type";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:7:"type_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"type";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:8:"reusable";a:16:{s:2:"id";s:8:"reusable";s:5:"table";s:24:"block_content_field_data";s:5:"field";s:8:"reusable";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"block_content";s:12:"entity_field";s:8:"reusable";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:12:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:7:"columns";a:4:{s:4:"info";s:4:"info";s:4:"type";s:4:"type";s:7:"changed";s:7:"changed";s:10:"operations";s:10:"operations";}s:7:"default";s:7:"changed";s:4:"info";a:4:{s:4:"info";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:4:"type";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:7:"changed";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:10:"operations";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}}s:8:"override";b:1;s:6:"sticky";b:0;s:7:"summary";s:0:"";s:11:"empty_table";b:1;s:7:"caption";s:0:"";s:11:"description";s:0:"";}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:0:{}s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:3:{s:17:"display_extenders";a:0:{}s:4:"path";s:19:"admin/content/block";s:4:"menu";a:7:{s:4:"type";s:3:"tab";s:5:"title";s:6:"Blocks";s:11:"description";s:31:"Create and edit content blocks.";s:6:"weight";i:0;s:9:"menu_name";s:5:"admin";s:6:"parent";s:20:"system.admin_content";s:7:"context";s:1:"0";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}');
INSERT INTO `[[dbprefix]]config` VALUES
('', 'views.view.comment', 'a:13:{s:4:"uuid";s:36:"bac3a9eb-8ce7-4b32-a149-033c71af4f06";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:7:"comment";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"H6JHGXl97yOKmVaV62SoY1ki1tWVdyD44fgOkdmVyRM";}s:2:"id";s:7:"comment";s:5:"label";s:8:"Comments";s:6:"module";s:7:"comment";s:11:"description";s:25:"Find and manage comments.";s:3:"tag";s:7:"default";s:10:"base_table";s:18:"comment_field_data";s:10:"base_field";s:3:"cid";s:7:"display";a:3:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:26:{s:5:"title";s:8:"Comments";s:6:"fields";a:8:{s:17:"comment_bulk_form";a:26:{s:2:"id";s:17:"comment_bulk_form";s:5:"table";s:7:"comment";s:5:"field";s:17:"comment_bulk_form";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:9:"plugin_id";s:17:"comment_bulk_form";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:12:"action_title";s:6:"Action";s:15:"include_exclude";s:7:"include";s:16:"selected_actions";a:2:{i:0;s:21:"comment_delete_action";i:1;s:24:"comment_unpublish_action";}}s:7:"subject";a:37:{s:2:"id";s:7:"subject";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"subject";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"subject";s:9:"plugin_id";s:5:"field";s:5:"label";s:7:"Subject";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:17:"comment_permalink";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:3:"uid";a:37:{s:2:"id";s:3:"uid";s:5:"table";s:18:"comment_field_data";s:5:"field";s:3:"uid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:3:"uid";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:1;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:4:"name";a:37:{s:2:"id";s:4:"name";s:5:"table";s:18:"comment_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Author";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:9:"{{ uid }}";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:16:"comment_username";s:8:"settings";a:0:{}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:9:"entity_id";a:37:{s:2:"id";s:9:"entity_id";s:5:"table";s:18:"comment_field_data";s:5:"field";s:9:"entity_id";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:9:"entity_id";s:9:"plugin_id";s:16:"commented_entity";s:5:"label";s:9:"Posted in";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:1;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:7:"changed";a:37:{s:2:"id";s:7:"changed";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:7:"Updated";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"timestamp";s:8:"settings";a:5:{s:11:"date_format";s:5:"short";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";s:7:"tooltip";a:2:{s:11:"date_format";s:4:"long";s:18:"custom_date_format";s:0:"";}s:9:"time_diff";a:5:{s:7:"enabled";b:0;s:13:"future_format";s:15:"@interval hence";s:11:"past_format";s:13:"@interval ago";s:11:"granularity";i:2;s:7:"refresh";i:60;}}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:10:"operations";a:24:{s:2:"id";s:10:"operations";s:5:"table";s:7:"comment";s:5:"field";s:10:"operations";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:9:"plugin_id";s:17:"entity_operations";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"destination";b:1;}s:6:"name_1";a:37:{s:2:"id";s:6:"name_1";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:3:"uid";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"user_name";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}}s:5:"pager";a:2:{s:4:"type";s:4:"full";s:7:"options";a:8:{s:6:"offset";i:0;s:24:"pagination_heading_level";s:2:"h4";s:14:"items_per_page";i:50;s:11:"total_pages";N;s:2:"id";i:0;s:4:"tags";a:4:{s:4:"next";s:8:"next ›";s:8:"previous";s:12:"‹ previous";s:5:"first";s:8:"« first";s:4:"last";s:7:"last »";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}s:8:"quantity";i:9;}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:6:"Filter";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:19:"administer comments";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:1:{s:16:"area_text_custom";a:10:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:22:"No comments available.";s:8:"tokenize";b:0;}}s:5:"sorts";a:1:{s:7:"changed";a:13:{s:2:"id";s:7:"changed";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:7:"changed";}s:7:"exposed";b:0;s:11:"granularity";s:6:"second";}}s:9:"arguments";a:0:{}s:7:"filters";a:4:{s:6:"status";a:16:{s:2:"id";s:6:"status";s:5:"table";s:18:"comment_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:7:"subject";a:16:{s:2:"id";s:7:"subject";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"subject";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"subject";s:9:"plugin_id";s:6:"string";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:10:"subject_op";s:5:"label";s:7:"Subject";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:10:"subject_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:7:"subject";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:7:"combine";a:15:{s:2:"id";s:7:"combine";s:5:"table";s:5:"views";s:5:"field";s:7:"combine";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:7:"combine";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:10:"combine_op";s:5:"label";s:11:"Author name";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:10:"combine_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:11:"author_name";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:6:"fields";a:2:{s:4:"name";s:4:"name";s:6:"name_1";s:6:"name_1";}}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:18:"comment_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:11:"langcode_op";s:5:"label";s:8:"Language";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"langcode_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:8:"langcode";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:1:{i:1;s:3:"AND";}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:12:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:7:"columns";a:6:{s:17:"comment_bulk_form";s:17:"comment_bulk_form";s:7:"subject";s:7:"subject";s:3:"uid";s:3:"uid";s:9:"entity_id";s:9:"entity_id";s:7:"changed";s:7:"changed";s:10:"operations";s:10:"operations";}s:7:"default";s:7:"changed";s:4:"info";a:6:{s:17:"comment_bulk_form";a:4:{s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:7:"subject";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:3:"uid";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:9:"entity_id";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:7:"changed";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:10:"operations";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}}s:8:"override";b:1;s:6:"sticky";b:1;s:7:"summary";s:0:"";s:11:"empty_table";b:1;s:7:"caption";s:0:"";s:11:"description";s:0:"";}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:1:{s:3:"uid";a:10:{s:2:"id";s:3:"uid";s:5:"table";s:18:"comment_field_data";s:5:"field";s:3:"uid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:6:"author";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:3:"uid";s:9:"plugin_id";s:8:"standard";s:8:"required";b:0;}}s:9:"css_class";s:0:"";s:8:"use_ajax";b:0;s:8:"group_by";b:0;s:16:"show_admin_links";b:1;s:8:"use_more";b:0;s:15:"use_more_always";b:1;s:13:"use_more_text";s:4:"more";s:6:"header";a:0:{}s:6:"footer";a:0:{}s:23:"hide_attachment_summary";b:0;s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:4:{s:7:"max-age";i:0;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}s:9:"cacheable";b:0;}}s:14:"page_published";a:6:{s:2:"id";s:14:"page_published";s:13:"display_title";s:18:"Published comments";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:6:{s:19:"display_description";s:30:"The approved comments listing.";s:15:"display_comment";s:0:"";s:13:"exposed_block";b:0;s:17:"display_extenders";a:0:{}s:4:"path";s:21:"admin/content/comment";s:4:"menu";a:7:{s:4:"type";s:3:"tab";s:5:"title";s:8:"Comments";s:11:"description";s:18:"Comments published";s:6:"weight";i:0;s:9:"menu_name";s:5:"admin";s:6:"parent";s:0:"";s:7:"context";s:1:"0";}}s:14:"cache_metadata";a:4:{s:7:"max-age";i:0;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}s:9:"cacheable";b:0;}}s:15:"page_unapproved";a:6:{s:2:"id";s:15:"page_unapproved";s:13:"display_title";s:19:"Unapproved comments";s:14:"display_plugin";s:4:"page";s:8:"position";i:2;s:15:"display_options";a:8:{s:6:"fields";a:8:{s:17:"comment_bulk_form";a:26:{s:2:"id";s:17:"comment_bulk_form";s:5:"table";s:7:"comment";s:5:"field";s:17:"comment_bulk_form";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:9:"plugin_id";s:17:"comment_bulk_form";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:12:"action_title";s:6:"Action";s:15:"include_exclude";s:7:"include";s:16:"selected_actions";a:2:{i:0;s:21:"comment_delete_action";i:1;s:22:"comment_publish_action";}}s:7:"subject";a:37:{s:2:"id";s:7:"subject";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"subject";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"subject";s:9:"plugin_id";s:5:"field";s:5:"label";s:7:"Subject";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:17:"comment_permalink";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:3:"uid";a:37:{s:2:"id";s:3:"uid";s:5:"table";s:18:"comment_field_data";s:5:"field";s:3:"uid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:3:"uid";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:1;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:4:"name";a:37:{s:2:"id";s:4:"name";s:5:"table";s:18:"comment_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Author";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:9:"{{ uid }}";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:16:"comment_username";s:8:"settings";a:0:{}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:9:"entity_id";a:37:{s:2:"id";s:9:"entity_id";s:5:"table";s:18:"comment_field_data";s:5:"field";s:9:"entity_id";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:9:"entity_id";s:9:"plugin_id";s:16:"commented_entity";s:5:"label";s:9:"Posted in";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:1;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:7:"changed";a:37:{s:2:"id";s:7:"changed";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:7:"Updated";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"timestamp";s:8:"settings";a:5:{s:11:"date_format";s:5:"short";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";s:7:"tooltip";a:2:{s:11:"date_format";s:4:"long";s:18:"custom_date_format";s:0:"";}s:9:"time_diff";a:5:{s:7:"enabled";b:0;s:13:"future_format";s:15:"@interval hence";s:11:"past_format";s:13:"@interval ago";s:11:"granularity";i:2;s:7:"refresh";i:60;}}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:10:"operations";a:24:{s:2:"id";s:10:"operations";s:5:"table";s:7:"comment";s:5:"field";s:10:"operations";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:9:"plugin_id";s:17:"entity_operations";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"destination";b:1;}s:6:"name_1";a:37:{s:2:"id";s:6:"name_1";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:3:"uid";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"user_name";s:8:"settings";a:1:{s:14:"link_to_entity";b:0;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}}s:7:"filters";a:4:{s:6:"status";a:16:{s:2:"id";s:6:"status";s:5:"table";s:18:"comment_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"0";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:7:"subject";a:16:{s:2:"id";s:7:"subject";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"subject";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"subject";s:9:"plugin_id";s:6:"string";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:10:"subject_op";s:5:"label";s:7:"Subject";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:10:"subject_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:7:"subject";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:7:"combine";a:15:{s:2:"id";s:7:"combine";s:5:"table";s:5:"views";s:5:"field";s:7:"combine";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:7:"combine";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:10:"combine_op";s:5:"label";s:11:"Author Name";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:10:"combine_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:11:"author_name";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:6:"fields";a:2:{s:4:"name";s:4:"name";s:6:"name_1";s:6:"name_1";}}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:18:"comment_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:11:"langcode_op";s:5:"label";s:8:"Language";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"langcode_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:8:"langcode";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:1:{i:1;s:3:"AND";}}s:8:"defaults";a:3:{s:6:"fields";b:0;s:7:"filters";b:0;s:13:"filter_groups";b:0;}s:19:"display_description";s:32:"The unapproved comments listing.";s:17:"display_extenders";a:0:{}s:4:"path";s:30:"admin/content/comment/approval";s:4:"menu";a:7:{s:4:"type";s:3:"tab";s:5:"title";s:19:"Unapproved comments";s:11:"description";s:19:"Comments unapproved";s:6:"weight";i:1;s:9:"menu_name";s:5:"admin";s:6:"parent";s:0:"";s:7:"context";s:1:"0";}}s:14:"cache_metadata";a:4:{s:7:"max-age";i:0;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}s:9:"cacheable";b:0;}}}}'),
('', 'views.view.comments_recent', 'a:13:{s:4:"uuid";s:36:"1c08e454-3450-48f1-acb0-95cf98fd812d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:3:{i:0;s:7:"comment";i:1;s:4:"node";i:2;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"cFOucxH8PAXDQ2kViCcAHgK-JMCcxVkpIMzD56EfpZo";}s:2:"id";s:15:"comments_recent";s:5:"label";s:15:"Recent comments";s:6:"module";s:5:"views";s:11:"description";s:16:"Recent comments.";s:3:"tag";s:7:"default";s:10:"base_table";s:18:"comment_field_data";s:10:"base_field";s:3:"cid";s:7:"display";a:2:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:14:{s:5:"title";s:15:"Recent comments";s:6:"fields";a:2:{s:7:"subject";a:26:{s:2:"id";s:7:"subject";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"subject";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"subject";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:0;s:8:"ellipsis";b:0;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:6:"string";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}}s:7:"changed";a:26:{s:2:"id";s:7:"changed";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:13:"timestamp_ago";s:8:"settings";a:3:{s:13:"future_format";s:15:"@interval hence";s:11:"past_format";s:13:"@interval ago";s:11:"granularity";i:2;}}}s:5:"pager";a:2:{s:4:"type";s:4:"some";s:7:"options";a:2:{s:6:"offset";i:0;s:14:"items_per_page";i:10;}}s:12:"exposed_form";a:1:{s:4:"type";s:5:"basic";}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:15:"access comments";}}s:5:"cache";a:1:{s:4:"type";s:3:"tag";}s:5:"empty";a:1:{s:16:"area_text_custom";a:11:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"text_custom";s:5:"label";s:0:"";s:5:"empty";b:1;s:7:"content";s:22:"No comments available.";s:8:"tokenize";b:0;}}s:5:"sorts";a:2:{s:7:"created";a:12:{s:2:"id";s:7:"created";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"created";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:7:"created";}s:7:"exposed";b:0;}s:3:"cid";a:12:{s:2:"id";s:3:"cid";s:5:"table";s:18:"comment_field_data";s:5:"field";s:3:"cid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:3:"cid";s:9:"plugin_id";s:8:"standard";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:3:"cid";}s:7:"exposed";b:0;}}s:7:"filters";a:2:{s:6:"status";a:9:{s:2:"id";s:6:"status";s:5:"table";s:18:"comment_field_data";s:5:"field";s:6:"status";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:5:"value";s:1:"1";s:5:"group";i:1;s:6:"expose";a:3:{s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}}s:11:"status_node";a:10:{s:2:"id";s:11:"status_node";s:5:"table";s:15:"node_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"node";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:5:"value";s:1:"1";s:5:"group";i:1;s:6:"expose";a:3:{s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:9:"html_list";s:7:"options";a:6:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:4:"type";s:2:"ul";s:13:"wrapper_class";s:9:"item-list";s:5:"class";s:0:"";}}s:3:"row";a:2:{s:4:"type";s:6:"fields";s:7:"options";a:2:{s:22:"default_field_elements";b:1;s:10:"hide_empty";b:0;}}s:5:"query";a:1:{s:4:"type";s:11:"views_query";}s:13:"relationships";a:1:{s:4:"node";a:5:{s:2:"id";s:4:"node";s:5:"table";s:18:"comment_field_data";s:5:"field";s:4:"node";s:9:"plugin_id";s:8:"standard";s:8:"required";b:1;}}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:3:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:7:"block_1";a:6:{s:2:"id";s:7:"block_1";s:13:"display_title";s:5:"Block";s:14:"display_plugin";s:5:"block";s:8:"position";i:1;s:15:"display_options";a:4:{s:17:"display_extenders";a:0:{}s:17:"block_description";s:15:"Recent comments";s:14:"block_category";s:13:"Lists (Views)";s:5:"allow";a:1:{s:14:"items_per_page";b:1;}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:3:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}');
INSERT INTO `[[dbprefix]]config` VALUES
('', 'views.view.content', 'a:13:{s:4:"uuid";s:36:"69c63b84-5199-4745-89dd-7aa6d60d4165";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"d7p-wwJZ_Wmz1gnvla9jDtRsjOaWAhPoIoW9w3vo4R4";}s:2:"id";s:7:"content";s:5:"label";s:7:"Content";s:6:"module";s:4:"node";s:11:"description";s:24:"Find and manage content.";s:3:"tag";s:7:"default";s:10:"base_table";s:15:"node_field_data";s:10:"base_field";s:3:"nid";s:7:"display";a:2:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:17:{s:5:"title";s:7:"Content";s:6:"fields";a:8:{s:14:"node_bulk_form";a:14:{s:2:"id";s:14:"node_bulk_form";s:5:"table";s:4:"node";s:5:"field";s:14:"node_bulk_form";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:14:"node_bulk_form";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:1:{s:10:"alter_text";b:0;}s:13:"element_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}s:5:"title";a:17:{s:2:"id";s:5:"title";s:5:"table";s:15:"node_field_data";s:5:"field";s:5:"title";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";s:9:"plugin_id";s:5:"field";s:5:"label";s:5:"Title";s:7:"exclude";b:0;s:5:"alter";a:1:{s:10:"alter_text";b:0;}s:13:"element_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:6:"string";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}}s:4:"type";a:37:{s:2:"id";s:4:"type";s:5:"table";s:15:"node_field_data";s:5:"field";s:4:"type";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:4:"type";s:9:"plugin_id";s:5:"field";s:5:"label";s:12:"Content type";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:0;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:4:"name";a:17:{s:2:"id";s:4:"name";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:3:"uid";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Author";s:7:"exclude";b:0;s:5:"alter";a:1:{s:10:"alter_text";b:0;}s:13:"element_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"user_name";}s:6:"status";a:17:{s:2:"id";s:6:"status";s:5:"table";s:15:"node_field_data";s:5:"field";s:6:"status";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Status";s:7:"exclude";b:0;s:5:"alter";a:1:{s:10:"alter_text";b:0;}s:13:"element_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:7:"boolean";s:8:"settings";a:3:{s:6:"format";s:6:"custom";s:19:"format_custom_false";s:11:"Unpublished";s:18:"format_custom_true";s:9:"Published";}}s:7:"changed";a:17:{s:2:"id";s:7:"changed";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"changed";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:7:"Updated";s:7:"exclude";b:0;s:5:"alter";a:1:{s:10:"alter_text";b:0;}s:13:"element_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"timestamp";s:8:"settings";a:5:{s:11:"date_format";s:5:"short";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";s:7:"tooltip";a:2:{s:11:"date_format";s:4:"long";s:18:"custom_date_format";s:0:"";}s:9:"time_diff";a:5:{s:7:"enabled";b:0;s:13:"future_format";s:15:"@interval hence";s:11:"past_format";s:13:"@interval ago";s:11:"granularity";i:2;s:7:"refresh";i:60;}}}s:8:"langcode";a:37:{s:2:"id";s:8:"langcode";s:5:"table";s:15:"node_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:14:"field_language";s:5:"label";s:8:"Language";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:8:"language";s:8:"settings";a:2:{s:14:"link_to_entity";b:0;s:15:"native_language";b:0;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:10:"operations";a:23:{s:2:"id";s:10:"operations";s:5:"table";s:4:"node";s:5:"field";s:10:"operations";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:17:"entity_operations";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"destination";b:1;}}s:5:"pager";a:2:{s:4:"type";s:4:"full";s:7:"options";a:3:{s:24:"pagination_heading_level";s:2:"h4";s:14:"items_per_page";i:50;s:4:"tags";a:4:{s:4:"next";s:8:"Next ›";s:8:"previous";s:12:"‹ Previous";s:5:"first";s:8:"« First";s:4:"last";s:7:"Last »";}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:6:"Filter";s:12:"reset_button";b:1;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:23:"access content overview";}}s:5:"cache";a:1:{s:4:"type";s:3:"tag";}s:5:"empty";a:1:{s:16:"area_text_custom";a:6:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:21:"No content available.";}}s:5:"sorts";a:0:{}s:9:"arguments";a:0:{}s:7:"filters";a:5:{s:5:"title";a:16:{s:2:"id";s:5:"title";s:5:"table";s:15:"node_field_data";s:5:"field";s:5:"title";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";s:9:"plugin_id";s:6:"string";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:8:"title_op";s:5:"label";s:5:"Title";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:8:"title_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:5:"title";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:4:"type";a:16:{s:2:"id";s:4:"type";s:5:"table";s:15:"node_field_data";s:5:"field";s:4:"type";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:4:"type";s:9:"plugin_id";s:6:"bundle";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:7:"type_op";s:5:"label";s:12:"Content type";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:7:"type_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"type";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:6:"status";a:16:{s:2:"id";s:6:"status";s:5:"table";s:15:"node_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:6:"Status";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:9:"status_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:6:"status";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:1;s:10:"group_info";a:10:{s:5:"label";s:16:"Published status";s:11:"description";s:0:"";s:10:"identifier";s:6:"status";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:2:{i:1;a:3:{s:5:"title";s:9:"Published";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";}i:2;a:3:{s:5:"title";s:11:"Unpublished";s:8:"operator";s:1:"=";s:5:"value";s:1:"0";}}}}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:15:"node_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:11:"langcode_op";s:5:"label";s:8:"Language";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"langcode_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:8:"langcode";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:12:"status_extra";a:9:{s:2:"id";s:12:"status_extra";s:5:"table";s:15:"node_field_data";s:5:"field";s:12:"status_extra";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:11:"node_status";s:8:"operator";s:1:"=";s:5:"value";b:0;s:5:"group";i:1;s:6:"expose";a:2:{s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}}}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:1:{i:1;s:3:"AND";}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:12:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:7:"columns";a:10:{s:14:"node_bulk_form";s:14:"node_bulk_form";s:5:"title";s:5:"title";s:4:"type";s:4:"type";s:4:"name";s:4:"name";s:6:"status";s:6:"status";s:7:"changed";s:7:"changed";s:9:"edit_node";s:9:"edit_node";s:11:"delete_node";s:11:"delete_node";s:10:"dropbutton";s:10:"dropbutton";s:9:"timestamp";s:5:"title";}s:7:"default";s:7:"changed";s:4:"info";a:10:{s:14:"node_bulk_form";a:4:{s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:5:"title";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:4:"type";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:4:"name";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:6:"status";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:7:"changed";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:9:"edit_node";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:11:"delete_node";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:10:"dropbutton";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:9:"timestamp";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}}s:8:"override";b:1;s:6:"sticky";b:1;s:7:"summary";s:0:"";s:11:"empty_table";b:1;s:7:"caption";s:0:"";s:11:"description";s:0:"";}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:1:{s:4:"type";s:11:"views_query";}s:13:"relationships";a:1:{s:3:"uid";a:6:{s:2:"id";s:3:"uid";s:5:"table";s:15:"node_field_data";s:5:"field";s:3:"uid";s:11:"admin_label";s:6:"author";s:9:"plugin_id";s:8:"standard";s:8:"required";b:1;}}s:16:"show_admin_links";b:0;s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:0;s:8:"contexts";a:7:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:4:"user";i:5;s:21:"user.node_grants:view";i:6;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:4:{s:17:"display_extenders";a:0:{}s:4:"path";s:18:"admin/content/node";s:4:"menu";a:6:{s:4:"type";s:11:"default tab";s:5:"title";s:7:"Content";s:11:"description";s:0:"";s:6:"weight";i:-10;s:9:"menu_name";s:5:"admin";s:7:"context";s:0:"";}s:11:"tab_options";a:5:{s:4:"type";s:6:"normal";s:5:"title";s:7:"Content";s:11:"description";s:23:"Find and manage content";s:6:"weight";i:-10;s:9:"menu_name";s:5:"admin";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:0;s:8:"contexts";a:7:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:4:"user";i:5;s:21:"user.node_grants:view";i:6;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}'),
('', 'views.view.content_recent', 'a:13:{s:4:"uuid";s:36:"debe7784-d96f-4776-9303-a275d2a4c8a7";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"YqZN5rc7XDQcFcInc8wkzuaHJmC5YvirhTmDcrarT6M";}s:2:"id";s:14:"content_recent";s:5:"label";s:14:"Recent content";s:6:"module";s:4:"node";s:11:"description";s:15:"Recent content.";s:3:"tag";s:7:"default";s:10:"base_table";s:15:"node_field_data";s:10:"base_field";s:3:"nid";s:7:"display";a:2:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:22:{s:5:"title";s:14:"Recent content";s:6:"fields";a:2:{s:5:"title";a:26:{s:2:"id";s:5:"title";s:5:"table";s:15:"node_field_data";s:5:"field";s:5:"title";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:8:{s:10:"alter_text";b:0;s:9:"make_link";b:0;s:8:"absolute";b:0;s:13:"word_boundary";b:0;s:8:"ellipsis";b:0;s:10:"strip_tags";b:0;s:4:"trim";b:0;s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:6:"string";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}}s:7:"changed";a:37:{s:2:"id";s:7:"changed";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:13:"timestamp_ago";s:8:"settings";a:0:{}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}}s:5:"pager";a:2:{s:4:"type";s:4:"some";s:7:"options";a:2:{s:6:"offset";i:0;s:14:"items_per_page";i:10;}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:14:"access content";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:1:{s:16:"area_text_custom";a:10:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:21:"No content available.";s:8:"tokenize";b:0;}}s:5:"sorts";a:1:{s:7:"changed";a:13:{s:2:"id";s:7:"changed";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:7:"changed";}s:7:"exposed";b:0;s:11:"granularity";s:6:"second";}}s:9:"arguments";a:0:{}s:7:"filters";a:2:{s:12:"status_extra";a:15:{s:2:"id";s:12:"status_extra";s:5:"table";s:15:"node_field_data";s:5:"field";s:12:"status_extra";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:11:"node_status";s:8:"operator";s:1:"=";s:5:"value";b:0;s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:15:"node_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:1:{s:31:"***LANGUAGE_language_content***";s:31:"***LANGUAGE_language_content***";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:13:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:9:"html_list";s:7:"options";a:6:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:4:"type";s:2:"ul";s:13:"wrapper_class";s:9:"item-list";s:5:"class";s:0:"";}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:1:{s:3:"uid";a:10:{s:2:"id";s:3:"uid";s:5:"table";s:15:"node_field_data";s:5:"field";s:3:"uid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:6:"author";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:3:"uid";s:9:"plugin_id";s:8:"standard";s:8:"required";b:1;}}s:8:"use_more";b:0;s:15:"use_more_always";b:0;s:13:"use_more_text";s:4:"More";s:12:"link_display";s:1:"0";s:8:"link_url";s:0:"";s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:4:"user";i:3;s:21:"user.node_grants:view";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:7:"block_1";a:6:{s:2:"id";s:7:"block_1";s:13:"display_title";s:5:"Block";s:14:"display_plugin";s:5:"block";s:8:"position";i:1;s:15:"display_options";a:1:{s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:4:"user";i:3;s:21:"user.node_grants:view";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}');
INSERT INTO `[[dbprefix]]config` VALUES
('', 'views.view.files', 'a:13:{s:4:"uuid";s:36:"729678c2-197e-44be-970f-5d898d313f96";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"file";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"NYJWABHsIFg-cU-Qya8fiMuQSM4rirBEfPFqkgRtsKA";}s:2:"id";s:5:"files";s:5:"label";s:5:"Files";s:6:"module";s:4:"file";s:11:"description";s:22:"Find and manage files.";s:3:"tag";s:7:"default";s:10:"base_table";s:12:"file_managed";s:10:"base_field";s:3:"fid";s:7:"display";a:3:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:19:{s:5:"title";s:5:"Files";s:6:"fields";a:9:{s:3:"fid";a:24:{s:2:"id";s:3:"fid";s:5:"table";s:12:"file_managed";s:5:"field";s:3:"fid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:3:"fid";s:9:"plugin_id";s:5:"field";s:5:"label";s:3:"Fid";s:7:"exclude";b:1;s:5:"alter";a:8:{s:10:"alter_text";b:0;s:9:"make_link";b:0;s:8:"absolute";b:0;s:13:"word_boundary";b:0;s:8:"ellipsis";b:0;s:10:"strip_tags";b:0;s:4:"trim";b:0;s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}s:8:"filename";a:36:{s:2:"id";s:8:"filename";s:5:"table";s:12:"file_managed";s:5:"field";s:8:"filename";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:8:"filename";s:9:"plugin_id";s:5:"field";s:5:"label";s:4:"Name";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:0;s:8:"ellipsis";b:0;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"file_link";s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:8:"filemime";a:25:{s:2:"id";s:8:"filemime";s:5:"table";s:12:"file_managed";s:5:"field";s:8:"filemime";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:8:"filemime";s:9:"plugin_id";s:5:"field";s:5:"label";s:9:"MIME type";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:13:"file_filemime";}s:8:"filesize";a:25:{s:2:"id";s:8:"filesize";s:5:"table";s:12:"file_managed";s:5:"field";s:8:"filesize";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:8:"filesize";s:9:"plugin_id";s:5:"field";s:5:"label";s:4:"Size";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"file_size";}s:6:"status";a:26:{s:2:"id";s:6:"status";s:5:"table";s:12:"file_managed";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Status";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:7:"boolean";s:8:"settings";a:3:{s:6:"format";s:6:"custom";s:19:"format_custom_false";s:9:"Temporary";s:18:"format_custom_true";s:9:"Permanent";}}s:7:"created";a:26:{s:2:"id";s:7:"created";s:5:"table";s:12:"file_managed";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:7:"created";s:9:"plugin_id";s:5:"field";s:5:"label";s:11:"Upload date";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"timestamp";s:8:"settings";a:5:{s:11:"date_format";s:6:"medium";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";s:7:"tooltip";a:2:{s:11:"date_format";s:4:"long";s:18:"custom_date_format";s:0:"";}s:9:"time_diff";a:5:{s:7:"enabled";b:0;s:13:"future_format";s:15:"@interval hence";s:11:"past_format";s:13:"@interval ago";s:11:"granularity";i:2;s:7:"refresh";i:60;}}}s:7:"changed";a:26:{s:2:"id";s:7:"changed";s:5:"table";s:12:"file_managed";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:12:"Changed date";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"timestamp";s:8:"settings";a:5:{s:11:"date_format";s:6:"medium";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";s:7:"tooltip";a:2:{s:11:"date_format";s:4:"long";s:18:"custom_date_format";s:0:"";}s:9:"time_diff";a:5:{s:7:"enabled";b:0;s:13:"future_format";s:15:"@interval hence";s:11:"past_format";s:13:"@interval ago";s:11:"granularity";i:2;s:7:"refresh";i:60;}}}s:5:"count";a:30:{s:2:"id";s:5:"count";s:5:"table";s:10:"file_usage";s:5:"field";s:5:"count";s:12:"relationship";s:3:"fid";s:10:"group_type";s:3:"sum";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:7:"numeric";s:5:"label";s:7:"Used in";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:1;s:4:"path";s:35:"admin/content/files/usage/{{ fid }}";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:13:"set_precision";b:0;s:9:"precision";i:0;s:7:"decimal";s:1:".";s:9:"separator";s:1:",";s:13:"format_plural";b:1;s:20:"format_plural_string";s:26:"@count place@count places";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}s:10:"operations";a:24:{s:2:"id";s:10:"operations";s:5:"table";s:12:"file_managed";s:5:"field";s:10:"operations";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:9:"plugin_id";s:17:"entity_operations";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"destination";b:0;}}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:7:{s:6:"offset";i:0;s:24:"pagination_heading_level";s:2:"h4";s:14:"items_per_page";i:50;s:11:"total_pages";i:0;s:2:"id";i:0;s:4:"tags";a:2:{s:4:"next";s:8:"Next ›";s:8:"previous";s:12:"‹ Previous";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:6:"Filter";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:21:"access files overview";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:1:{s:16:"area_text_custom";a:6:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:19:"No files available.";}}s:5:"sorts";a:0:{}s:9:"arguments";a:0:{}s:7:"filters";a:3:{s:8:"filename";a:16:{s:2:"id";s:8:"filename";s:5:"table";s:12:"file_managed";s:5:"field";s:8:"filename";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:8:"filename";s:9:"plugin_id";s:6:"string";s:8:"operator";s:4:"word";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:11:"filemime_op";s:5:"label";s:8:"Filename";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"filename_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:8:"filename";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:8:"filemime";a:16:{s:2:"id";s:8:"filemime";s:5:"table";s:12:"file_managed";s:5:"field";s:8:"filemime";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:8:"filemime";s:9:"plugin_id";s:6:"string";s:8:"operator";s:4:"word";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:11:"filemime_op";s:5:"label";s:9:"MIME type";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"filemime_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:8:"filemime";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:6:"status";a:16:{s:2:"id";s:6:"status";s:5:"table";s:12:"file_managed";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:11:"file_status";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:9:"status_op";s:5:"label";s:6:"Status";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:9:"status_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:6:"status";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:12:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:7:"columns";a:8:{s:3:"fid";s:3:"fid";s:8:"filename";s:8:"filename";s:8:"filemime";s:8:"filemime";s:8:"filesize";s:8:"filesize";s:6:"status";s:6:"status";s:7:"created";s:7:"created";s:7:"changed";s:7:"changed";s:5:"count";s:5:"count";}s:7:"default";s:7:"changed";s:4:"info";a:8:{s:3:"fid";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:8:"filename";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:8:"filemime";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:15:"priority-medium";}s:8:"filesize";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:6:"status";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:7:"created";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:7:"changed";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:5:"count";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:15:"priority-medium";}}s:8:"override";b:1;s:6:"sticky";b:0;s:7:"summary";s:0:"";s:11:"empty_table";b:1;s:7:"caption";s:0:"";s:11:"description";s:0:"";}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:1:{s:3:"fid";a:7:{s:2:"id";s:3:"fid";s:5:"table";s:12:"file_managed";s:5:"field";s:3:"fid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:10:"File usage";s:8:"required";b:1;}}s:8:"group_by";b:1;s:16:"show_admin_links";b:1;s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:14:"Files overview";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:6:{s:8:"defaults";a:2:{s:5:"pager";b:1;s:13:"relationships";b:0;}s:13:"relationships";a:1:{s:3:"fid";a:7:{s:2:"id";s:3:"fid";s:5:"table";s:12:"file_managed";s:5:"field";s:3:"fid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:10:"File usage";s:8:"required";b:0;}}s:19:"display_description";s:0:"";s:17:"display_extenders";a:0:{}s:4:"path";s:19:"admin/content/files";s:4:"menu";a:6:{s:4:"type";s:3:"tab";s:5:"title";s:5:"Files";s:11:"description";s:0:"";s:6:"weight";i:0;s:9:"menu_name";s:5:"admin";s:7:"context";s:0:"";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_2";a:6:{s:2:"id";s:6:"page_2";s:13:"display_title";s:10:"File usage";s:14:"display_plugin";s:4:"page";s:8:"position";i:2;s:15:"display_options";a:15:{s:5:"title";s:10:"File usage";s:6:"fields";a:4:{s:12:"entity_label";a:23:{s:2:"id";s:12:"entity_label";s:5:"table";s:10:"file_usage";s:5:"field";s:12:"entity_label";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:12:"entity_label";s:5:"label";s:6:"Entity";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:14:"link_to_entity";b:1;}s:4:"type";a:22:{s:2:"id";s:4:"type";s:5:"table";s:10:"file_usage";s:5:"field";s:4:"type";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:8:"standard";s:5:"label";s:11:"Entity type";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}s:6:"module";a:22:{s:2:"id";s:6:"module";s:5:"table";s:10:"file_usage";s:5:"field";s:6:"module";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:8:"standard";s:5:"label";s:18:"Registering module";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}s:5:"count";a:30:{s:2:"id";s:5:"count";s:5:"table";s:10:"file_usage";s:5:"field";s:5:"count";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:7:"numeric";s:5:"label";s:9:"Use count";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:13:"set_precision";b:0;s:9:"precision";i:0;s:7:"decimal";s:1:".";s:9:"separator";s:1:",";s:13:"format_plural";b:0;s:20:"format_plural_string";s:8:"1@count";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:7:{s:6:"offset";i:0;s:24:"pagination_heading_level";s:2:"h4";s:14:"items_per_page";i:10;s:11:"total_pages";i:0;s:2:"id";i:0;s:4:"tags";a:2:{s:4:"next";s:8:"Next ›";s:8:"previous";s:12:"‹ Previous";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}}}s:5:"empty";a:0:{}s:9:"arguments";a:1:{s:3:"fid";a:22:{s:2:"id";s:3:"fid";s:5:"table";s:12:"file_managed";s:5:"field";s:3:"fid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:3:"fid";s:9:"plugin_id";s:8:"file_fid";s:14:"default_action";s:9:"not found";s:9:"exception";a:3:{s:5:"value";s:3:"all";s:12:"title_enable";b:0;s:5:"title";s:3:"All";}s:12:"title_enable";b:1;s:5:"title";s:46:"File usage information for {{ arguments.fid }}";s:21:"default_argument_type";s:5:"fixed";s:24:"default_argument_options";a:1:{s:8:"argument";s:0:"";}s:15:"summary_options";a:4:{s:9:"base_path";s:0:"";s:5:"count";b:1;s:8:"override";b:0;s:14:"items_per_page";i:25;}s:7:"summary";a:3:{s:10:"sort_order";s:3:"asc";s:17:"number_of_records";i:0;s:6:"format";s:15:"default_summary";}s:18:"specify_validation";b:0;s:8:"validate";a:2:{s:4:"type";s:4:"none";s:4:"fail";s:9:"not found";}s:16:"validate_options";a:0:{}s:12:"break_phrase";b:0;s:3:"not";b:0;}}s:7:"filters";a:0:{}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:0:{}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:12:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:7:"columns";a:4:{s:12:"entity_label";s:12:"entity_label";s:4:"type";s:4:"type";s:6:"module";s:6:"module";s:5:"count";s:5:"count";}s:7:"default";s:12:"entity_label";s:4:"info";a:4:{s:12:"entity_label";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:4:"type";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:15:"priority-medium";}s:6:"module";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:5:"count";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}}s:8:"override";b:1;s:6:"sticky";b:0;s:7:"summary";s:0:"";s:11:"empty_table";b:1;s:7:"caption";s:0:"";s:11:"description";s:0:"";}}s:3:"row";a:2:{s:4:"type";s:6:"fields";s:7:"options";a:0:{}}s:8:"defaults";a:11:{s:5:"empty";b:0;s:5:"title";b:0;s:5:"pager";b:0;s:8:"group_by";b:0;s:5:"style";b:0;s:3:"row";b:0;s:13:"relationships";b:0;s:6:"fields";b:0;s:9:"arguments";b:0;s:7:"filters";b:0;s:13:"filter_groups";b:0;}s:13:"relationships";a:1:{s:3:"fid";a:7:{s:2:"id";s:3:"fid";s:5:"table";s:12:"file_managed";s:5:"field";s:3:"fid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:10:"File usage";s:8:"required";b:1;}}s:8:"group_by";b:0;s:19:"display_description";s:0:"";s:17:"display_extenders";a:0:{}s:4:"path";s:27:"admin/content/files/usage/%";}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:4:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}'),
('', 'views.view.frontpage', 'a:13:{s:4:"uuid";s:36:"a499d4f4-11fb-49ac-b4ac-0f91eb6999b5";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:30:"core.entity_view_mode.node.rss";i:1;s:33:"core.entity_view_mode.node.teaser";}s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"OEEnRQIjfIaCFRsz8U3VqDrE82ltQKlo8wNbQJRZXu0";}s:2:"id";s:9:"frontpage";s:5:"label";s:9:"Frontpage";s:6:"module";s:4:"node";s:11:"description";s:39:"All content promoted to the front page.";s:3:"tag";s:7:"default";s:10:"base_table";s:15:"node_field_data";s:10:"base_field";s:3:"nid";s:7:"display";a:3:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:17:{s:5:"title";s:0:"";s:6:"fields";a:0:{}s:5:"pager";a:2:{s:4:"type";s:4:"full";s:7:"options";a:8:{s:6:"offset";i:0;s:24:"pagination_heading_level";s:2:"h4";s:14:"items_per_page";i:10;s:11:"total_pages";i:0;s:2:"id";i:0;s:4:"tags";a:4:{s:4:"next";s:8:"Next ›";s:8:"previous";s:12:"‹ Previous";s:5:"first";s:8:"« First";s:4:"last";s:7:"Last »";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}s:8:"quantity";i:9;}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:14:"access content";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:3:{s:16:"area_text_custom";a:11:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"text_custom";s:5:"label";s:0:"";s:5:"empty";b:1;s:7:"content";s:181:"No front page content has been created yet.<br/>Follow the <a target="_blank" href="https://www.drupal.org/docs/user_guide/en/index.html">User Guide</a> to start building your site.";s:8:"tokenize";b:0;}s:18:"node_listing_empty";a:10:{s:2:"id";s:18:"node_listing_empty";s:5:"table";s:4:"node";s:5:"field";s:18:"node_listing_empty";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:18:"node_listing_empty";s:5:"label";s:0:"";s:5:"empty";b:1;}s:5:"title";a:10:{s:2:"id";s:5:"title";s:5:"table";s:5:"views";s:5:"field";s:5:"title";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:5:"title";s:5:"label";s:0:"";s:5:"empty";b:1;s:5:"title";s:8:"Welcome!";}}s:5:"sorts";a:2:{s:6:"sticky";a:12:{s:2:"id";s:6:"sticky";s:5:"table";s:15:"node_field_data";s:5:"field";s:6:"sticky";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"sticky";s:9:"plugin_id";s:8:"standard";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:6:"sticky";}s:7:"exposed";b:0;}s:7:"created";a:13:{s:2:"id";s:7:"created";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"created";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:7:"created";}s:7:"exposed";b:0;s:11:"granularity";s:6:"second";}}s:9:"arguments";a:0:{}s:7:"filters";a:3:{s:7:"promote";a:16:{s:2:"id";s:7:"promote";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"promote";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"promote";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:6:"status";a:9:{s:2:"id";s:6:"status";s:5:"table";s:15:"node_field_data";s:5:"field";s:6:"status";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:5:"value";s:1:"1";s:5:"group";i:1;s:6:"expose";a:3:{s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:15:"node_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:1:{s:31:"***LANGUAGE_language_content***";s:31:"***LANGUAGE_language_content***";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:13:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:7:"default";s:7:"options";a:4:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:11:"uses_fields";b:0;}}s:3:"row";a:2:{s:4:"type";s:11:"entity:node";s:7:"options";a:1:{s:9:"view_mode";s:6:"teaser";}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:0:{}s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:4:{i:0;s:28:"languages:language_interface";i:1;s:14:"url.query_args";i:2;s:21:"user.node_grants:view";i:3;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"feed_1";a:6:{s:2:"id";s:6:"feed_1";s:13:"display_title";s:4:"Feed";s:14:"display_plugin";s:4:"feed";s:8:"position";i:2;s:15:"display_options";a:7:{s:5:"pager";a:2:{s:4:"type";s:4:"some";s:7:"options";a:2:{s:6:"offset";i:0;s:14:"items_per_page";i:10;}}s:5:"style";a:2:{s:4:"type";s:3:"rss";s:7:"options";a:3:{s:8:"grouping";a:0:{}s:11:"uses_fields";b:0;s:11:"description";s:0:"";}}s:3:"row";a:2:{s:4:"type";s:8:"node_rss";s:7:"options";a:2:{s:12:"relationship";s:4:"none";s:9:"view_mode";s:3:"rss";}}s:17:"display_extenders";a:0:{}s:4:"path";s:7:"rss.xml";s:14:"sitename_title";b:1;s:8:"displays";a:2:{s:6:"page_1";s:6:"page_1";s:7:"default";s:0:"";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:3:{i:0;s:28:"languages:language_interface";i:1;s:21:"user.node_grants:view";i:2;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:2:{s:17:"display_extenders";a:0:{}s:4:"path";s:4:"node";}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:4:{i:0;s:28:"languages:language_interface";i:1;s:14:"url.query_args";i:2;s:21:"user.node_grants:view";i:3;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}');
INSERT INTO `[[dbprefix]]config` VALUES
('', 'views.view.glossary', 'a:13:{s:4:"uuid";s:36:"9500e5ad-906d-49b1-9f0d-5bb691116e26";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:16:"system.menu.main";}s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"r-klgGeO4haVHqAwxW1HXZLzdzLSMUVC08OuTBrRh58";}s:2:"id";s:8:"glossary";s:5:"label";s:8:"Glossary";s:6:"module";s:4:"node";s:11:"description";s:23:"All content, by letter.";s:3:"tag";s:7:"default";s:10:"base_table";s:15:"node_field_data";s:10:"base_field";s:3:"nid";s:7:"display";a:3:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:17:{s:6:"fields";a:3:{s:5:"title";a:24:{s:2:"id";s:5:"title";s:5:"table";s:15:"node_field_data";s:5:"field";s:5:"title";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";s:9:"plugin_id";s:5:"field";s:5:"label";s:5:"Title";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}s:4:"name";a:25:{s:2:"id";s:4:"name";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:3:"uid";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Author";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"user_name";}s:7:"changed";a:26:{s:2:"id";s:7:"changed";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:11:"Last update";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"timestamp";s:8:"settings";a:5:{s:11:"date_format";s:4:"long";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";s:7:"tooltip";a:2:{s:11:"date_format";s:4:"long";s:18:"custom_date_format";s:0:"";}s:9:"time_diff";a:5:{s:7:"enabled";b:0;s:13:"future_format";s:15:"@interval hence";s:11:"past_format";s:13:"@interval ago";s:11:"granularity";i:2;s:7:"refresh";i:60;}}}}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:7:{s:6:"offset";i:0;s:24:"pagination_heading_level";s:2:"h4";s:14:"items_per_page";i:36;s:11:"total_pages";i:0;s:2:"id";i:0;s:4:"tags";a:2:{s:4:"next";s:6:"››";s:8:"previous";s:6:"‹‹";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:14:"access content";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:0:{}s:5:"sorts";a:0:{}s:9:"arguments";a:1:{s:5:"title";a:26:{s:2:"id";s:5:"title";s:5:"table";s:15:"node_field_data";s:5:"field";s:5:"title";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";s:9:"plugin_id";s:6:"string";s:14:"default_action";s:7:"default";s:9:"exception";a:1:{s:12:"title_enable";b:1;}s:12:"title_enable";b:0;s:5:"title";s:0:"";s:21:"default_argument_type";s:5:"fixed";s:24:"default_argument_options";a:1:{s:8:"argument";s:1:"a";}s:15:"summary_options";a:0:{}s:7:"summary";a:1:{s:6:"format";s:15:"default_summary";}s:18:"specify_validation";b:1;s:8:"validate";a:2:{s:4:"type";s:4:"none";s:4:"fail";s:9:"not found";}s:16:"validate_options";a:0:{}s:8:"glossary";b:1;s:5:"limit";i:1;s:4:"case";s:5:"upper";s:9:"path_case";s:5:"lower";s:14:"transform_dash";b:0;s:12:"break_phrase";b:0;}}s:7:"filters";a:2:{s:6:"status";a:9:{s:2:"id";s:6:"status";s:5:"table";s:15:"node_field_data";s:5:"field";s:6:"status";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:5:"value";s:1:"1";s:5:"group";i:1;s:6:"expose";a:3:{s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:15:"node_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:1:{s:31:"***LANGUAGE_language_content***";s:31:"***LANGUAGE_language_content***";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:13:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:12:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:11:"uses_fields";b:0;s:7:"columns";a:3:{s:5:"title";s:5:"title";s:4:"name";s:4:"name";s:7:"changed";s:7:"changed";}s:7:"default";s:5:"title";s:4:"info";a:3:{s:5:"title";a:2:{s:8:"sortable";b:1;s:9:"separator";s:0:"";}s:4:"name";a:2:{s:8:"sortable";b:1;s:9:"separator";s:0:"";}s:7:"changed";a:2:{s:8:"sortable";b:1;s:9:"separator";s:0:"";}}s:8:"override";b:1;s:6:"sticky";b:0;s:7:"summary";s:0:"";s:5:"order";s:3:"asc";s:11:"empty_table";b:0;}}s:3:"row";a:2:{s:4:"type";s:6:"fields";s:7:"options";a:4:{s:22:"default_field_elements";b:1;s:6:"inline";a:0:{}s:9:"separator";s:0:"";s:10:"hide_empty";b:0;}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:1:{s:3:"uid";a:8:{s:2:"id";s:3:"uid";s:5:"table";s:15:"node_field_data";s:5:"field";s:3:"uid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:6:"author";s:9:"plugin_id";s:8:"standard";s:8:"required";b:0;}}s:8:"use_ajax";b:1;s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:6:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:21:"user.node_grants:view";i:5;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:12:"attachment_1";a:6:{s:2:"id";s:12:"attachment_1";s:13:"display_title";s:10:"Attachment";s:14:"display_plugin";s:10:"attachment";s:8:"position";i:2;s:15:"display_options";a:7:{s:5:"pager";a:2:{s:4:"type";s:4:"none";s:7:"options";a:2:{s:6:"offset";i:0;s:14:"items_per_page";i:0;}}s:9:"arguments";a:1:{s:5:"title";a:26:{s:2:"id";s:5:"title";s:5:"table";s:15:"node_field_data";s:5:"field";s:5:"title";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";s:9:"plugin_id";s:6:"string";s:14:"default_action";s:7:"summary";s:9:"exception";a:1:{s:12:"title_enable";b:1;}s:12:"title_enable";b:0;s:5:"title";s:0:"";s:21:"default_argument_type";s:5:"fixed";s:24:"default_argument_options";a:1:{s:8:"argument";s:1:"a";}s:15:"summary_options";a:3:{s:14:"items_per_page";i:25;s:6:"inline";b:1;s:9:"separator";s:3:" | ";}s:7:"summary";a:1:{s:6:"format";s:19:"unformatted_summary";}s:18:"specify_validation";b:1;s:8:"validate";a:2:{s:4:"type";s:4:"none";s:4:"fail";s:9:"not found";}s:16:"validate_options";a:0:{}s:8:"glossary";b:1;s:5:"limit";i:1;s:4:"case";s:5:"upper";s:9:"path_case";s:5:"lower";s:14:"transform_dash";b:0;s:12:"break_phrase";b:0;}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:0:{}}s:8:"defaults";a:1:{s:9:"arguments";b:0;}s:17:"display_extenders";a:0:{}s:8:"displays";a:2:{s:7:"default";s:7:"default";s:6:"page_1";s:6:"page_1";}s:17:"inherit_arguments";b:0;}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:6:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:21:"user.node_grants:view";i:5;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:4:{s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:0:{}}s:17:"display_extenders";a:0:{}s:4:"path";s:8:"glossary";s:4:"menu";a:5:{s:4:"type";s:6:"normal";s:5:"title";s:8:"Glossary";s:6:"weight";i:0;s:9:"menu_name";s:4:"main";s:6:"parent";s:0:"";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:6:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:21:"user.node_grants:view";i:5;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}'),
('', 'views.view.taxonomy_term', 'a:13:{s:4:"uuid";s:36:"9eb48132-e8ed-4879-b829-a811fda1f0e1";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:33:"core.entity_view_mode.node.teaser";}s:6:"module";a:3:{i:0;s:4:"node";i:1;s:8:"taxonomy";i:2;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"KejdxDJQmx8SaO-t83OVekLw6ar4ldjmsJMGcotGxnQ";}s:2:"id";s:13:"taxonomy_term";s:5:"label";s:13:"Taxonomy term";s:6:"module";s:8:"taxonomy";s:11:"description";s:45:"Content belonging to a certain taxonomy term.";s:3:"tag";s:7:"default";s:10:"base_table";s:15:"node_field_data";s:10:"base_field";s:3:"nid";s:7:"display";a:3:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:18:{s:6:"fields";a:0:{}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:7:{s:6:"offset";i:0;s:24:"pagination_heading_level";s:2:"h4";s:14:"items_per_page";i:10;s:11:"total_pages";i:0;s:2:"id";i:0;s:4:"tags";a:2:{s:4:"next";s:6:"››";s:8:"previous";s:6:"‹‹";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:14:"access content";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:0:{}s:5:"sorts";a:2:{s:6:"sticky";a:10:{s:2:"id";s:6:"sticky";s:5:"table";s:14:"taxonomy_index";s:5:"field";s:6:"sticky";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:8:"standard";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:6:"sticky";}s:7:"exposed";b:0;}s:7:"created";a:11:{s:2:"id";s:7:"created";s:5:"table";s:14:"taxonomy_index";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:7:"created";}s:7:"exposed";b:0;s:11:"granularity";s:6:"second";}}s:9:"arguments";a:1:{s:3:"tid";a:22:{s:2:"id";s:3:"tid";s:5:"table";s:14:"taxonomy_index";s:5:"field";s:3:"tid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:18:"taxonomy_index_tid";s:14:"default_action";s:9:"not found";s:9:"exception";a:3:{s:5:"value";s:0:"";s:12:"title_enable";b:0;s:5:"title";s:3:"All";}s:12:"title_enable";b:1;s:5:"title";s:19:"{{ arguments.tid }}";s:21:"default_argument_type";s:5:"fixed";s:24:"default_argument_options";a:1:{s:8:"argument";s:0:"";}s:15:"summary_options";a:4:{s:9:"base_path";s:0:"";s:5:"count";b:1;s:8:"override";b:0;s:14:"items_per_page";i:25;}s:7:"summary";a:3:{s:10:"sort_order";s:3:"asc";s:17:"number_of_records";i:0;s:6:"format";s:15:"default_summary";}s:18:"specify_validation";b:1;s:8:"validate";a:2:{s:4:"type";s:20:"entity:taxonomy_term";s:4:"fail";s:9:"not found";}s:16:"validate_options";a:4:{s:7:"bundles";a:0:{}s:6:"access";b:1;s:9:"operation";s:4:"view";s:8:"multiple";i:0;}s:12:"break_phrase";b:0;s:9:"add_table";b:0;s:13:"require_value";b:0;s:17:"reduce_duplicates";b:0;}}s:7:"filters";a:2:{s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:15:"node_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:1:{s:31:"***LANGUAGE_language_content***";s:31:"***LANGUAGE_language_content***";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:13:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:6:"status";a:14:{s:2:"id";s:6:"status";s:5:"table";s:14:"taxonomy_index";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:7:"default";s:7:"options";a:4:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:11:"uses_fields";b:0;}}s:3:"row";a:2:{s:4:"type";s:11:"entity:node";s:7:"options";a:1:{s:9:"view_mode";s:6:"teaser";}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:0:{}s:12:"link_display";s:6:"page_1";s:8:"link_url";s:0:"";s:6:"header";a:1:{s:20:"entity_taxonomy_term";a:12:{s:2:"id";s:20:"entity_taxonomy_term";s:5:"table";s:5:"views";s:5:"field";s:20:"entity_taxonomy_term";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:6:"entity";s:5:"empty";b:1;s:6:"target";s:23:"{{ raw_arguments.tid }}";s:9:"view_mode";s:4:"full";s:8:"tokenize";b:1;s:13:"bypass_access";b:0;}}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:21:"user.node_grants:view";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"feed_1";a:6:{s:2:"id";s:6:"feed_1";s:13:"display_title";s:4:"Feed";s:14:"display_plugin";s:4:"feed";s:8:"position";i:2;s:15:"display_options";a:7:{s:5:"pager";a:2:{s:4:"type";s:4:"some";s:7:"options";a:2:{s:6:"offset";i:0;s:14:"items_per_page";i:10;}}s:5:"style";a:2:{s:4:"type";s:3:"rss";s:7:"options";a:3:{s:8:"grouping";a:0:{}s:11:"uses_fields";b:0;s:11:"description";s:0:"";}}s:3:"row";a:2:{s:4:"type";s:8:"node_rss";s:7:"options";a:2:{s:12:"relationship";s:4:"none";s:9:"view_mode";s:7:"default";}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:0:{}}s:17:"display_extenders";a:0:{}s:4:"path";s:20:"taxonomy/term/%/feed";s:8:"displays";a:2:{s:6:"page_1";s:6:"page_1";s:7:"default";s:1:"0";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:4:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:21:"user.node_grants:view";i:3;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:3:{s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:0:{}}s:17:"display_extenders";a:0:{}s:4:"path";s:15:"taxonomy/term/%";}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:21:"user.node_grants:view";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}'),
('', 'views.view.user_admin_people', 'a:13:{s:4:"uuid";s:36:"42860050-a189-4887-a6fb-827ba81b2f40";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"FFLg74mnzRE10lgg5fspPCZWLnIEcvCnJMlNzj8OEtw";}s:2:"id";s:17:"user_admin_people";s:5:"label";s:6:"People";s:6:"module";s:4:"user";s:11:"description";s:50:"Find and manage people interacting with your site.";s:3:"tag";s:7:"default";s:10:"base_table";s:16:"users_field_data";s:10:"base_field";s:3:"uid";s:7:"display";a:2:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:25:{s:5:"title";s:6:"People";s:6:"fields";a:8:{s:14:"user_bulk_form";a:23:{s:2:"id";s:14:"user_bulk_form";s:5:"table";s:5:"users";s:5:"field";s:14:"user_bulk_form";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:9:"plugin_id";s:14:"user_bulk_form";s:5:"label";s:11:"Bulk update";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}s:4:"name";a:25:{s:2:"id";s:4:"name";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:8:"Username";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"user_name";}s:6:"status";a:26:{s:2:"id";s:6:"status";s:5:"table";s:16:"users_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Status";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:7:"boolean";s:8:"settings";a:3:{s:6:"format";s:6:"custom";s:19:"format_custom_false";s:7:"Blocked";s:18:"format_custom_true";s:6:"Active";}}s:15:"roles_target_id";a:24:{s:2:"id";s:15:"roles_target_id";s:5:"table";s:11:"user__roles";s:5:"field";s:15:"roles_target_id";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:10:"user_roles";s:5:"label";s:5:"Roles";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:2:"ul";s:9:"separator";s:2:", ";}s:7:"created";a:26:{s:2:"id";s:7:"created";s:5:"table";s:16:"users_field_data";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:7:"created";s:9:"plugin_id";s:5:"field";s:5:"label";s:10:"Member for";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:13:"timestamp_ago";s:8:"settings";a:3:{s:13:"future_format";s:9:"@interval";s:11:"past_format";s:9:"@interval";s:11:"granularity";i:2;}}s:6:"access";a:26:{s:2:"id";s:6:"access";s:5:"table";s:16:"users_field_data";s:5:"field";s:6:"access";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:6:"access";s:9:"plugin_id";s:5:"field";s:5:"label";s:11:"Last access";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:13:"timestamp_ago";s:8:"settings";a:3:{s:13:"future_format";s:15:"@interval hence";s:11:"past_format";s:13:"@interval ago";s:11:"granularity";i:2;}}s:10:"operations";a:24:{s:2:"id";s:10:"operations";s:5:"table";s:5:"users";s:5:"field";s:10:"operations";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:9:"plugin_id";s:17:"entity_operations";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"destination";b:1;}s:4:"mail";a:37:{s:2:"id";s:4:"mail";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"mail";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"mail";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:12:"basic_string";s:8:"settings";a:0:{}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}}s:5:"pager";a:2:{s:4:"type";s:4:"full";s:7:"options";a:8:{s:6:"offset";i:0;s:24:"pagination_heading_level";s:2:"h4";s:14:"items_per_page";i:50;s:11:"total_pages";i:0;s:2:"id";i:0;s:4:"tags";a:4:{s:4:"next";s:8:"Next ›";s:8:"previous";s:12:"‹ Previous";s:5:"first";s:8:"« First";s:4:"last";s:7:"Last »";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}s:8:"quantity";i:9;}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:6:"Filter";s:12:"reset_button";b:1;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:16:"administer users";}}s:5:"cache";a:1:{s:4:"type";s:3:"tag";}s:5:"empty";a:1:{s:16:"area_text_custom";a:10:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:20:"No people available.";s:8:"tokenize";b:0;}}s:5:"sorts";a:1:{s:7:"created";a:13:{s:2:"id";s:7:"created";s:5:"table";s:16:"users_field_data";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:7:"created";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:7:"created";}s:7:"exposed";b:0;s:11:"granularity";s:6:"second";}}s:7:"filters";a:6:{s:7:"combine";a:15:{s:2:"id";s:7:"combine";s:5:"table";s:5:"views";s:5:"field";s:7:"combine";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:7:"combine";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:10:"combine_op";s:5:"label";s:22:"Name or email contains";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:10:"combine_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"user";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:6:"fields";a:2:{s:4:"name";s:4:"name";s:4:"mail";s:4:"mail";}}s:6:"status";a:16:{s:2:"id";s:6:"status";s:5:"table";s:16:"users_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:9:"status_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:6:"status";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:1;s:10:"group_info";a:10:{s:5:"label";s:6:"Status";s:11:"description";s:0:"";s:10:"identifier";s:6:"status";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:2:{i:1;a:3:{s:5:"title";s:6:"Active";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";}i:2;a:3:{s:5:"title";s:7:"Blocked";s:8:"operator";s:1:"=";s:5:"value";s:1:"0";}}}}s:15:"roles_target_id";a:15:{s:2:"id";s:15:"roles_target_id";s:5:"table";s:11:"user__roles";s:5:"field";s:15:"roles_target_id";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:10:"user_roles";s:8:"operator";s:2:"or";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:18:"roles_target_id_op";s:5:"label";s:4:"Role";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:18:"roles_target_id_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"role";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:17:"reduce_duplicates";b:0;}s:10:"permission";a:15:{s:2:"id";s:10:"permission";s:5:"table";s:11:"user__roles";s:5:"field";s:10:"permission";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:16:"user_permissions";s:8:"operator";s:2:"or";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:13:"permission_op";s:5:"label";s:10:"Permission";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:13:"permission_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:10:"permission";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:17:"reduce_duplicates";b:0;}s:16:"default_langcode";a:16:{s:2:"id";s:16:"default_langcode";s:5:"table";s:16:"users_field_data";s:5:"field";s:16:"default_langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:16:"default_langcode";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:7:"uid_raw";a:15:{s:2:"id";s:7:"uid_raw";s:5:"table";s:16:"users_field_data";s:5:"field";s:7:"uid_raw";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:9:"plugin_id";s:7:"numeric";s:8:"operator";s:2:"!=";s:5:"value";a:3:{s:3:"min";s:0:"";s:3:"max";s:0:"";s:5:"value";s:1:"0";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:1:"0";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:1:{i:1;s:3:"AND";}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:10:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:7:"columns";a:8:{s:14:"user_bulk_form";s:14:"user_bulk_form";s:4:"name";s:4:"name";s:6:"status";s:6:"status";s:3:"rid";s:3:"rid";s:7:"created";s:7:"created";s:6:"access";s:6:"access";s:9:"edit_node";s:9:"edit_node";s:10:"dropbutton";s:10:"dropbutton";}s:7:"default";s:7:"created";s:4:"info";a:8:{s:14:"user_bulk_form";a:4:{s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:4:"name";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:6:"status";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:3:"rid";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:7:"created";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:6:"access";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:9:"edit_node";a:4:{s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:10:"dropbutton";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}}s:8:"override";b:1;s:6:"sticky";b:0;s:7:"summary";s:0:"";s:11:"empty_table";b:1;}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:9:"css_class";s:0:"";s:8:"use_ajax";b:0;s:8:"group_by";b:0;s:16:"show_admin_links";b:1;s:8:"use_more";b:0;s:15:"use_more_always";b:0;s:13:"use_more_text";s:4:"more";s:12:"link_display";s:6:"page_1";s:8:"link_url";s:0:"";s:15:"display_comment";s:0:"";s:23:"hide_attachment_summary";b:0;s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:0;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:6:{s:8:"defaults";a:1:{s:16:"show_admin_links";b:0;}s:16:"show_admin_links";b:0;s:17:"display_extenders";a:0:{}s:4:"path";s:17:"admin/people/list";s:4:"menu";a:6:{s:4:"type";s:11:"default tab";s:5:"title";s:4:"List";s:11:"description";s:50:"Find and manage people interacting with your site.";s:6:"weight";i:-10;s:9:"menu_name";s:5:"admin";s:7:"context";s:0:"";}s:11:"tab_options";a:5:{s:4:"type";s:6:"normal";s:5:"title";s:6:"People";s:11:"description";s:45:"Manage user accounts, roles, and permissions.";s:6:"weight";i:0;s:9:"menu_name";s:5:"admin";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:0;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}');
INSERT INTO `[[dbprefix]]config` VALUES
('', 'views.view.watchdog', 'a:13:{s:4:"uuid";s:36:"e140ff4f-06d2-4575-9163-97977e483bcd";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:5:"dblog";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"SR5P89f0vUTPC7WY2YpLAffkDx8-Ar8LKFfowVXeqNU";}s:2:"id";s:8:"watchdog";s:5:"label";s:8:"Watchdog";s:6:"module";s:5:"views";s:11:"description";s:19:"Recent log messages";s:3:"tag";s:0:"";s:10:"base_table";s:8:"watchdog";s:10:"base_field";s:3:"wid";s:7:"display";a:2:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:19:{s:5:"title";s:19:"Recent log messages";s:6:"fields";a:8:{s:7:"nothing";a:22:{s:2:"id";s:7:"nothing";s:5:"table";s:5:"views";s:5:"field";s:7:"nothing";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:4:"Icon";s:9:"plugin_id";s:6:"custom";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:1;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:4:"icon";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:0;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:0;}s:3:"wid";a:22:{s:2:"id";s:3:"wid";s:5:"table";s:8:"watchdog";s:5:"field";s:3:"wid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:8:"standard";s:5:"label";s:3:"WID";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}s:8:"severity";a:23:{s:2:"id";s:8:"severity";s:5:"table";s:8:"watchdog";s:5:"field";s:8:"severity";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:12:"machine_name";s:5:"label";s:8:"Severity";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:12:"machine_name";b:0;}s:4:"type";a:22:{s:2:"id";s:4:"type";s:5:"table";s:8:"watchdog";s:5:"field";s:4:"type";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:8:"standard";s:5:"label";s:4:"Type";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}s:9:"timestamp";a:25:{s:2:"id";s:9:"timestamp";s:5:"table";s:8:"watchdog";s:5:"field";s:9:"timestamp";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:4:"date";s:5:"label";s:4:"Date";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"date_format";s:5:"short";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";}s:7:"message";a:23:{s:2:"id";s:7:"message";s:5:"table";s:8:"watchdog";s:5:"field";s:7:"message";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:13:"dblog_message";s:5:"label";s:7:"Message";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:1;s:4:"path";s:35:"admin/reports/dblog/event/{{ wid }}";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:13:"{{ message }}";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:56;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:1;s:4:"trim";b:1;s:13:"preserve_tags";s:0:"";s:4:"html";b:1;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"replace_variables";b:1;}s:4:"name";a:37:{s:2:"id";s:4:"name";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:3:"uid";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:4:"User";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"user_name";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:4:"link";a:22:{s:2:"id";s:4:"link";s:5:"table";s:8:"watchdog";s:5:"field";s:4:"link";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:16:"dblog_operations";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:7:{s:6:"offset";i:0;s:24:"pagination_heading_level";s:2:"h4";s:14:"items_per_page";i:50;s:11:"total_pages";N;s:2:"id";i:0;s:4:"tags";a:2:{s:4:"next";s:6:"››";s:8:"previous";s:6:"‹‹";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:6:"Filter";s:12:"reset_button";b:1;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:0;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:19:"access site reports";}}s:5:"cache";a:2:{s:4:"type";s:4:"none";s:7:"options";a:0:{}}s:5:"empty";a:1:{s:4:"area";a:10:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:26:"No log messages available.";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:26:"No log messages available.";s:8:"tokenize";b:0;}}s:5:"sorts";a:1:{s:3:"wid";a:10:{s:2:"id";s:3:"wid";s:5:"table";s:8:"watchdog";s:5:"field";s:3:"wid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:8:"standard";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:3:"wid";}s:7:"exposed";b:0;}}s:9:"arguments";a:0:{}s:7:"filters";a:2:{s:4:"type";a:14:{s:2:"id";s:4:"type";s:5:"table";s:8:"watchdog";s:5:"field";s:4:"type";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"dblog_types";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:7:"type_op";s:5:"label";s:4:"Type";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:7:"type_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"type";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:1;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:8:"severity";a:14:{s:2:"id";s:8:"severity";s:5:"table";s:8:"watchdog";s:5:"field";s:8:"severity";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"in_operator";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:11:"severity_op";s:5:"label";s:8:"Severity";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"severity_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:8:"severity";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:1;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:1:{i:1;s:3:"AND";}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:12:{s:8:"grouping";a:0:{}s:9:"row_class";s:25:"{{ type }} {{ severity }}";s:17:"default_row_class";b:1;s:7:"columns";a:8:{s:7:"nothing";s:7:"nothing";s:3:"wid";s:3:"wid";s:8:"severity";s:8:"severity";s:4:"type";s:4:"type";s:9:"timestamp";s:9:"timestamp";s:7:"message";s:7:"message";s:4:"name";s:4:"name";s:4:"link";s:4:"link";}s:7:"default";s:3:"wid";s:4:"info";a:8:{s:7:"nothing";a:4:{s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:15:"priority-medium";}s:3:"wid";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:8:"severity";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:4:"type";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:15:"priority-medium";}s:9:"timestamp";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:7:"message";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:4:"name";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:15:"priority-medium";}s:4:"link";a:4:{s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}}s:8:"override";b:1;s:6:"sticky";b:0;s:7:"summary";s:0:"";s:11:"empty_table";b:0;s:7:"caption";s:0:"";s:11:"description";s:0:"";}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:1:{s:3:"uid";a:8:{s:2:"id";s:3:"uid";s:5:"table";s:8:"watchdog";s:5:"field";s:3:"uid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:4:"User";s:9:"plugin_id";s:8:"standard";s:8:"required";b:0;}}s:9:"css_class";s:11:"admin-dblog";s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:4:"page";a:6:{s:2:"id";s:4:"page";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:2:{s:17:"display_extenders";a:0:{}s:4:"path";s:19:"admin/reports/dblog";}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}'),
('', 'views.view.who_s_new', 'a:13:{s:4:"uuid";s:36:"b7009850-90ad-4074-9490-4ebe5402fa88";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"zji0_13MyVGK7Bn1lUMDeZyyOIZedWvqpYUeM_SioPI";}s:2:"id";s:9:"who_s_new";s:5:"label";s:9:"Who''s new";s:6:"module";s:4:"user";s:11:"description";s:53:"Shows a list of the newest user accounts on the site.";s:3:"tag";s:7:"default";s:10:"base_table";s:16:"users_field_data";s:10:"base_field";s:3:"uid";s:7:"display";a:2:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:17:{s:5:"title";s:9:"Who''s new";s:6:"fields";a:1:{s:4:"name";a:25:{s:2:"id";s:4:"name";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:8:{s:10:"alter_text";b:0;s:9:"make_link";b:0;s:8:"absolute";b:0;s:13:"word_boundary";b:0;s:8:"ellipsis";b:0;s:10:"strip_tags";b:0;s:4:"trim";b:0;s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"user_name";}}s:5:"pager";a:2:{s:4:"type";s:4:"some";s:7:"options";a:2:{s:6:"offset";i:0;s:14:"items_per_page";i:5;}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:14:"access content";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:0:{}s:5:"sorts";a:1:{s:7:"created";a:13:{s:2:"id";s:7:"created";s:5:"table";s:16:"users_field_data";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:7:"created";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:7:"created";}s:7:"exposed";b:0;s:11:"granularity";s:6:"second";}}s:9:"arguments";a:0:{}s:7:"filters";a:2:{s:6:"status";a:9:{s:2:"id";s:6:"status";s:5:"table";s:16:"users_field_data";s:5:"field";s:6:"status";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:5:"value";s:1:"1";s:5:"group";i:1;s:6:"expose";a:3:{s:8:"operator";s:1:"0";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}}s:6:"access";a:16:{s:2:"id";s:6:"access";s:5:"table";s:16:"users_field_data";s:5:"field";s:6:"access";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:6:"access";s:9:"plugin_id";s:4:"date";s:8:"operator";s:1:">";s:5:"value";a:4:{s:3:"min";s:0:"";s:3:"max";s:0:"";s:5:"value";s:10:"1970-01-01";s:4:"type";s:4:"date";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:1:"0";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:1:{s:4:"type";s:9:"html_list";}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:0:{}s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:3:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:7:"block_1";a:6:{s:2:"id";s:7:"block_1";s:13:"display_title";s:9:"Who''s new";s:14:"display_plugin";s:5:"block";s:8:"position";i:1;s:15:"display_options";a:4:{s:19:"display_description";s:19:"A list of new users";s:17:"display_extenders";a:0:{}s:17:"block_description";s:9:"Who''s new";s:14:"block_category";s:4:"User";}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:3:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}'),
('', 'views.view.who_s_online', 'a:13:{s:4:"uuid";s:36:"a225e720-4826-4653-a530-520e9999cb1a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"suDsVMgawXoQt4rfmdfpr05EVX3z3KyfDDTYgeSM898";}s:2:"id";s:12:"who_s_online";s:5:"label";s:18:"Who''s online block";s:6:"module";s:4:"user";s:11:"description";s:93:"Shows the user names of the most recently active users, and the total number of active users.";s:3:"tag";s:7:"default";s:10:"base_table";s:16:"users_field_data";s:10:"base_field";s:3:"uid";s:7:"display";a:2:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:17:{s:5:"title";s:12:"Who''s online";s:6:"fields";a:1:{s:4:"name";a:25:{s:2:"id";s:4:"name";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:8:{s:10:"alter_text";b:0;s:9:"make_link";b:0;s:8:"absolute";b:0;s:13:"word_boundary";b:0;s:8:"ellipsis";b:0;s:10:"strip_tags";b:0;s:4:"trim";b:0;s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"user_name";}}s:5:"pager";a:2:{s:4:"type";s:4:"some";s:7:"options";a:2:{s:6:"offset";i:0;s:14:"items_per_page";i:10;}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:20:"access user profiles";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:1:{s:16:"area_text_custom";a:10:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:35:"There are currently 0 users online.";s:8:"tokenize";b:0;}}s:5:"sorts";a:1:{s:6:"access";a:13:{s:2:"id";s:6:"access";s:5:"table";s:16:"users_field_data";s:5:"field";s:6:"access";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:6:"access";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:6:"access";}s:7:"exposed";b:0;s:11:"granularity";s:6:"second";}}s:9:"arguments";a:0:{}s:7:"filters";a:2:{s:6:"status";a:9:{s:2:"id";s:6:"status";s:5:"table";s:16:"users_field_data";s:5:"field";s:6:"status";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:5:"value";s:1:"1";s:5:"group";i:1;s:6:"expose";a:3:{s:8:"operator";s:1:"0";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}}s:6:"access";a:16:{s:2:"id";s:6:"access";s:5:"table";s:16:"users_field_data";s:5:"field";s:6:"access";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:6:"access";s:9:"plugin_id";s:4:"date";s:8:"operator";s:2:">=";s:5:"value";a:4:{s:3:"min";s:0:"";s:3:"max";s:0:"";s:5:"value";s:11:"-15 minutes";s:4:"type";s:6:"offset";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:9:"access_op";s:5:"label";s:11:"Last access";s:11:"description";s:77:"A user is considered online for this long after they have last viewed a page.";s:12:"use_operator";b:0;s:8:"operator";s:9:"access_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:6:"access";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:9:"html_list";s:7:"options";a:6:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:4:"type";s:2:"ul";s:13:"wrapper_class";s:9:"item-list";s:5:"class";s:0:"";}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:0:{}s:6:"header";a:1:{s:6:"result";a:9:{s:2:"id";s:6:"result";s:5:"table";s:5:"views";s:5:"field";s:6:"result";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:6:"result";s:5:"empty";b:0;s:7:"content";s:40:"There are currently @total users online.";}}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:3:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:18:"who_s_online_block";a:6:{s:2:"id";s:18:"who_s_online_block";s:13:"display_title";s:12:"Who''s online";s:14:"display_plugin";s:5:"block";s:8:"position";i:1;s:15:"display_options";a:3:{s:19:"display_description";s:45:"A list of users that are currently logged in.";s:17:"display_extenders";a:0:{}s:17:"block_description";s:12:"Who''s online";}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:3:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]file_managed`
--

CREATE TABLE `[[dbprefix]]file_managed` (
  `fid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(128) CHARACTER SET ascii NOT NULL,
  `langcode` varchar(12) CHARACTER SET ascii NOT NULL,
  `uid` int(10) unsigned DEFAULT NULL COMMENT 'The ID of the target entity.',
  `filename` varchar(255) DEFAULT NULL,
  `uri` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `filemime` varchar(255) CHARACTER SET ascii DEFAULT NULL,
  `filesize` bigint(20) unsigned DEFAULT NULL,
  `status` tinyint(4) NOT NULL,
  `created` int(11) DEFAULT NULL,
  `changed` int(11) NOT NULL,
  PRIMARY KEY (`fid`),
  UNIQUE KEY `file_field__uuid__value` (`uuid`),
  KEY `file_field__uid__target_id` (`uid`),
  KEY `file_field__uri` (`uri`(191)),
  KEY `file_field__status` (`status`),
  KEY `file_field__changed` (`changed`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The base table for file entities.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]file_usage`
--

CREATE TABLE `[[dbprefix]]file_usage` (
  `fid` int(10) unsigned NOT NULL COMMENT 'File ID.',
  `module` varchar(50) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'The name of the module that is using the file.',
  `type` varchar(64) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'The name of the object type in which the file is used.',
  `id` varchar(64) CHARACTER SET ascii NOT NULL DEFAULT '0' COMMENT 'The primary key of the object using the file.',
  `count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The number of times this file is used by this object.',
  PRIMARY KEY (`fid`,`type`,`id`,`module`),
  KEY `type_id` (`type`,`id`),
  KEY `fid_count` (`fid`,`count`),
  KEY `fid_module` (`fid`,`module`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Track where a file is used.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]help_search_items`
--

CREATE TABLE `[[dbprefix]]help_search_items` (
  `sid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Numeric index of this item in the search index',
  `section_plugin_id` varchar(255) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'The help section the item comes from',
  `permission` varchar(255) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'The permission needed to view this item',
  `topic_id` varchar(255) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'The topic ID of the item',
  PRIMARY KEY (`sid`),
  KEY `section_plugin_id` (`section_plugin_id`),
  KEY `topic_id` (`topic_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COMMENT='Stores information about indexed help search items' AUTO_INCREMENT=86 ;

--
-- Dumping data for table `[[dbprefix]]help_search_items`
--

INSERT INTO `[[dbprefix]]help_search_items` VALUES
(1, 'help_topics', '', 'config.export_full'),
(2, 'help_topics', '', 'config.export_single'),
(3, 'help_topics', '', 'config.import_full'),
(4, 'help_topics', '', 'config.import_single'),
(5, 'help_topics', '', 'contact.adding_fields'),
(6, 'help_topics', '', 'contact.configuring_personal'),
(7, 'help_topics', '', 'contact.creating'),
(8, 'help_topics', '', 'contact.overview'),
(9, 'help_topics', '', 'contact.setting_default'),
(10, 'help_topics', '', 'core.appearance'),
(11, 'help_topics', '', 'core.config_overview'),
(12, 'help_topics', '', 'core.content_structure'),
(13, 'help_topics', '', 'core.cron'),
(14, 'help_topics', '', 'core.extending'),
(15, 'help_topics', '', 'core.maintenance'),
(16, 'help_topics', '', 'core.media'),
(17, 'help_topics', '', 'core.menus'),
(18, 'help_topics', '', 'core.performance'),
(19, 'help_topics', '', 'core.security'),
(20, 'help_topics', '', 'core.settings_tray'),
(21, 'help_topics', '', 'core.tracking_content'),
(22, 'help_topics', '', 'core.translations'),
(23, 'help_topics', '', 'core.ui_accessibility'),
(24, 'help_topics', '', 'core.ui_components'),
(25, 'help_topics', '', 'core.web_services'),
(26, 'help_topics', '', 'help.help_topic_search'),
(27, 'help_topics', '', 'help.overview'),
(28, 'help_topics', '', 'search.configuring'),
(29, 'help_topics', '', 'search.index'),
(30, 'help_topics', '', 'search.overview'),
(31, 'help_topics', '', 'system.cache'),
(32, 'help_topics', '', 'system.config_basic'),
(33, 'help_topics', '', 'system.config_error'),
(34, 'help_topics', '', 'system.maintenance_mode'),
(35, 'help_topics', '', 'system.module_install'),
(36, 'help_topics', '', 'system.module_uninstall'),
(37, 'help_topics', '', 'system.reports'),
(38, 'help_topics', '', 'system.theme_install'),
(39, 'help_topics', '', 'system.theme_uninstall'),
(40, 'help_topics', '', 'user.create'),
(41, 'help_topics', '', 'user.new_role'),
(42, 'help_topics', '', 'user.overview'),
(43, 'help_topics', '', 'user.permissions'),
(44, 'help_topics', '', 'user.security_account_settings'),
(45, 'help_topics', '', 'user.update'),
(46, 'help_topics', '', 'announcements_feed.overview'),
(47, 'help_topics', '', 'block.configure'),
(48, 'help_topics', '', 'block.overview'),
(49, 'help_topics', '', 'block.place'),
(50, 'help_topics', '', 'filter.overview'),
(51, 'help_topics', '', 'block_content.add'),
(52, 'help_topics', '', 'block_content.type'),
(53, 'help_topics', '', 'node.creating_content'),
(54, 'help_topics', '', 'node.creating_type'),
(55, 'help_topics', '', 'node.editing'),
(56, 'help_topics', '', 'node.overview'),
(57, 'help_topics', '', 'breakpoint.overview'),
(58, 'help_topics', '', 'editor.overview'),
(59, 'help_topics', '', 'comment.configuring'),
(60, 'help_topics', '', 'comment.creating_type'),
(61, 'help_topics', '', 'comment.disabling'),
(62, 'help_topics', '', 'comment.moderating'),
(63, 'help_topics', '', 'comment.overview'),
(64, 'help_topics', '', 'contextual.overview'),
(65, 'help_topics', '', 'field_ui.add_field'),
(66, 'help_topics', '', 'field_ui.manage_display'),
(67, 'help_topics', '', 'field_ui.manage_form'),
(68, 'help_topics', '', 'field_ui.reference_field'),
(69, 'help_topics', '', 'history.tracking_user_content'),
(70, 'help_topics', '', 'taxonomy.configuring'),
(71, 'help_topics', '', 'taxonomy.overview'),
(72, 'help_topics', '', 'image.style'),
(73, 'help_topics', '', 'views.overview'),
(74, 'help_topics', '', 'menu_ui.content_type_configuration'),
(75, 'help_topics', '', 'menu_ui.menu_item_add'),
(76, 'help_topics', '', 'menu_ui.menu_operations'),
(77, 'help_topics', '', 'menu_ui.overriding'),
(78, 'help_topics', '', 'path.creating_alias'),
(79, 'help_topics', '', 'path.editing_alias'),
(80, 'help_topics', '', 'path.overview'),
(81, 'help_topics', '', 'shortcut.overview'),
(82, 'help_topics', '', 'views_ui.add_display'),
(83, 'help_topics', '', 'views_ui.bulk_operations'),
(84, 'help_topics', '', 'views_ui.create'),
(85, 'help_topics', '', 'views_ui.edit');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]history`
--

CREATE TABLE `[[dbprefix]]history` (
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT 'The "[[dbprefix]]users".uid that read the "[[dbprefix]]node" nid.',
  `nid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The "[[dbprefix]]node".nid that was read.',
  `timestamp` bigint(20) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp at which the read occurred.',
  PRIMARY KEY (`uid`,`nid`),
  KEY `nid` (`nid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='A record of which "[[dbprefix]]users" have read which "[[dbprefix]]node…';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]key_value`
--

CREATE TABLE `[[dbprefix]]key_value` (
  `collection` varchar(128) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'A named collection of key and value pairs.',
  `name` varchar(128) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'The key of the key-value pair. As KEY is a SQL reserved keyword, name was chosen instead.',
  `value` longblob NOT NULL COMMENT 'The value.',
  PRIMARY KEY (`collection`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Generic key-value storage table. See the state system for…';

--
-- Dumping data for table `[[dbprefix]]key_value`
--

INSERT INTO `[[dbprefix]]key_value` VALUES
('config.entity.key_store.action', 'uuid:0635e00a-000b-4330-a736-0b6f50b82429', 'a:1:{i:0;s:37:"system.action.user_cancel_user_action";}'),
('config.entity.key_store.action', 'uuid:088fd079-0dc7-4d31-ad8f-eb610eceea9b', 'a:1:{i:0;s:35:"system.action.comment_delete_action";}'),
('config.entity.key_store.action', 'uuid:09b2053e-4ff7-4cb7-bf30-5f110a9d3e36', 'a:1:{i:0;s:36:"system.action.user_block_user_action";}'),
('config.entity.key_store.action', 'uuid:0b2884ec-88f0-40e5-985e-bced18631d85', 'a:1:{i:0;s:37:"system.action.node_make_sticky_action";}'),
('config.entity.key_store.action', 'uuid:22a0db98-30bd-4af1-abf1-c2b921e3b8e2', 'a:1:{i:0;s:35:"system.action.node_unpromote_action";}'),
('config.entity.key_store.action', 'uuid:296519cc-dac9-4b9b-9ee7-5d89d0b26956', 'a:1:{i:0;s:49:"system.action.user_add_role_action.content_editor";}'),
('config.entity.key_store.action', 'uuid:37ba85bb-3984-4adb-bb8b-6bbcbfa1bd42', 'a:1:{i:0;s:33:"system.action.comment_save_action";}'),
('config.entity.key_store.action', 'uuid:3b5393d3-b935-44e5-b051-320ee2aa98b8', 'a:1:{i:0;s:35:"system.action.node_unpublish_action";}'),
('config.entity.key_store.action', 'uuid:48c3edac-1733-4f67-893d-599c3fec5abe', 'a:1:{i:0;s:44:"system.action.taxonomy_term_unpublish_action";}'),
('config.entity.key_store.action', 'uuid:60afe495-595d-407c-b1e6-9dac2100ba52', 'a:1:{i:0;s:33:"system.action.node_promote_action";}'),
('config.entity.key_store.action', 'uuid:79cf4a88-adcd-4b19-8c18-b8680c6efebf', 'a:1:{i:0;s:38:"system.action.user_unblock_user_action";}'),
('config.entity.key_store.action', 'uuid:7df8c639-b650-49eb-8231-58ded75b5670', 'a:1:{i:0;s:38:"system.action.comment_unpublish_action";}'),
('config.entity.key_store.action', 'uuid:8109fd7b-b7ba-4857-b19c-a9cb5ec2e110', 'a:1:{i:0;s:42:"system.action.taxonomy_term_publish_action";}'),
('config.entity.key_store.action', 'uuid:94ba7c38-517b-49f9-ac4b-205c5cea23f9', 'a:1:{i:0;s:30:"system.action.node_save_action";}'),
('config.entity.key_store.action', 'uuid:9ec4ec59-dc49-404a-a927-17bc884025e3', 'a:1:{i:0;s:32:"system.action.node_delete_action";}'),
('config.entity.key_store.action', 'uuid:aefb0d8d-32e3-4b6b-8f21-52f5e6b29038', 'a:1:{i:0;s:39:"system.action.node_make_unsticky_action";}'),
('config.entity.key_store.action', 'uuid:c1ea29c6-9c9a-4393-944d-3f9b6608f8af', 'a:1:{i:0;s:51:"system.action.user_remove_role_action.administrator";}'),
('config.entity.key_store.action', 'uuid:ccd6fe1c-c1ef-4a13-85c3-434e1035993a', 'a:1:{i:0;s:52:"system.action.user_remove_role_action.content_editor";}'),
('config.entity.key_store.action', 'uuid:dd6e043f-d565-4687-939b-6a7dc07cde67', 'a:1:{i:0;s:48:"system.action.user_add_role_action.administrator";}'),
('config.entity.key_store.action', 'uuid:e782b924-3de4-4c8a-a07b-e8031fbd83a5', 'a:1:{i:0;s:36:"system.action.comment_publish_action";}'),
('config.entity.key_store.action', 'uuid:edd325fe-35ab-4824-8443-4a25ad49982d', 'a:1:{i:0;s:33:"system.action.node_publish_action";}'),
('config.entity.key_store.base_field_override', 'uuid:5fb24dfb-4b22-4efb-9e99-405445ee016b', 'a:1:{i:0;s:42:"core.base_field_override.node.page.promote";}'),
('config.entity.key_store.block', 'theme:claro', 'a:9:{i:0;s:31:"block.block.claro_local_actions";i:1;s:28:"block.block.claro_page_title";i:2;s:37:"block.block.claro_primary_local_tasks";i:3;s:39:"block.block.claro_secondary_local_tasks";i:4;s:22:"block.block.claro_help";i:5;s:29:"block.block.claro_help_search";i:6;s:29:"block.block.claro_breadcrumbs";i:7;s:25:"block.block.claro_content";i:8;s:26:"block.block.claro_messages";}'),
('config.entity.key_store.block', 'theme:olivero', 'a:15:{i:0;s:24:"block.block.olivero_help";i:1;s:30:"block.block.olivero_page_title";i:2;s:41:"block.block.olivero_primary_admin_actions";i:3;s:39:"block.block.olivero_primary_local_tasks";i:4;s:41:"block.block.olivero_secondary_local_tasks";i:5;s:29:"block.block.olivero_syndicate";i:6;s:38:"block.block.olivero_search_form_narrow";i:7;s:36:"block.block.olivero_search_form_wide";i:8;s:31:"block.block.olivero_breadcrumbs";i:9;s:27:"block.block.olivero_content";i:10;s:28:"block.block.olivero_messages";i:11;s:27:"block.block.olivero_powered";i:12;s:33:"block.block.olivero_site_branding";i:13;s:32:"block.block.olivero_account_menu";i:14;s:29:"block.block.olivero_main_menu";}'),
('config.entity.key_store.block', 'uuid:16638ed0-5bd9-47f5-ba23-4550b4f5b2fb', 'a:1:{i:0;s:33:"block.block.olivero_site_branding";}'),
('config.entity.key_store.block', 'uuid:2c3b003a-c72d-4c9a-9fc8-c71fa96e3089', 'a:1:{i:0;s:27:"block.block.olivero_content";}'),
('config.entity.key_store.block', 'uuid:2d6b8546-280a-4f58-90a9-dceaa5473570', 'a:1:{i:0;s:27:"block.block.olivero_powered";}'),
('config.entity.key_store.block', 'uuid:2f19ffb4-3576-4856-8130-a9ce43bbc333', 'a:1:{i:0;s:26:"block.block.claro_messages";}'),
('config.entity.key_store.block', 'uuid:3f41b923-eb7f-41ba-931e-1a96711307b1', 'a:1:{i:0;s:36:"block.block.olivero_search_form_wide";}'),
('config.entity.key_store.block', 'uuid:42548e43-6e06-4867-8818-2bf5559740d0', 'a:1:{i:0;s:37:"block.block.claro_primary_local_tasks";}'),
('config.entity.key_store.block', 'uuid:473bf5c2-c3ee-456d-a65d-f1c12f4ab444', 'a:1:{i:0;s:28:"block.block.olivero_messages";}'),
('config.entity.key_store.block', 'uuid:4c607e9d-fde5-42d1-a64a-e3d431234e87', 'a:1:{i:0;s:29:"block.block.olivero_main_menu";}'),
('config.entity.key_store.block', 'uuid:5194eb45-b39a-492b-84a7-609f8802cafb', 'a:1:{i:0;s:32:"block.block.olivero_account_menu";}'),
('config.entity.key_store.block', 'uuid:570ff8a4-59fc-420e-bc60-274cfe35775a', 'a:1:{i:0;s:29:"block.block.olivero_syndicate";}'),
('config.entity.key_store.block', 'uuid:5ae771ce-6cc2-4a52-8b47-89c9bbfca2d1', 'a:1:{i:0;s:25:"block.block.claro_content";}'),
('config.entity.key_store.block', 'uuid:6a806bed-ed08-4f8f-b0eb-9c8964aeab6c', 'a:1:{i:0;s:38:"block.block.olivero_search_form_narrow";}'),
('config.entity.key_store.block', 'uuid:6fd7aa3c-ed97-4c3a-a804-0ffc6da19541', 'a:1:{i:0;s:31:"block.block.claro_local_actions";}'),
('config.entity.key_store.block', 'uuid:954ba156-95c7-456e-8eab-67c0ddd8e22e', 'a:1:{i:0;s:39:"block.block.olivero_primary_local_tasks";}'),
('config.entity.key_store.block', 'uuid:9f752564-93c8-4dd3-a106-364587e7b78a', 'a:1:{i:0;s:29:"block.block.claro_help_search";}'),
('config.entity.key_store.block', 'uuid:acc03a58-aca2-43d7-ad35-22cc403eec25', 'a:1:{i:0;s:30:"block.block.olivero_page_title";}'),
('config.entity.key_store.block', 'uuid:b82d2960-8189-43b5-bfa6-3f337bdf1b0d', 'a:1:{i:0;s:41:"block.block.olivero_secondary_local_tasks";}'),
('config.entity.key_store.block', 'uuid:bb5edf28-cada-42c3-bb02-d5e6a83b54ea', 'a:1:{i:0;s:41:"block.block.olivero_primary_admin_actions";}'),
('config.entity.key_store.block', 'uuid:bd6fa43a-d797-49b9-9258-fa963529f976', 'a:1:{i:0;s:22:"block.block.claro_help";}'),
('config.entity.key_store.block', 'uuid:bda59d32-8afa-4ea3-9cd0-9dd33664427e', 'a:1:{i:0;s:24:"block.block.olivero_help";}'),
('config.entity.key_store.block', 'uuid:d848e9a2-e342-49dc-9b4b-5ceab0782d77', 'a:1:{i:0;s:29:"block.block.claro_breadcrumbs";}'),
('config.entity.key_store.block', 'uuid:ed57d2c1-c856-4afe-8d4a-53f7c222dc35', 'a:1:{i:0;s:39:"block.block.claro_secondary_local_tasks";}'),
('config.entity.key_store.block', 'uuid:f3032d55-475f-4e35-bc60-e4669f360cb4', 'a:1:{i:0;s:28:"block.block.claro_page_title";}'),
('config.entity.key_store.block', 'uuid:fa54885d-1d49-43b6-ba6f-b90d01b60339', 'a:1:{i:0;s:31:"block.block.olivero_breadcrumbs";}'),
('config.entity.key_store.block_content_type', 'uuid:a43e9993-66f6-4fc9-97c3-89ba9069148d', 'a:1:{i:0;s:24:"block_content.type.basic";}'),
('config.entity.key_store.comment_type', 'uuid:86611b27-7a27-46b6-b077-c7479da5841c', 'a:1:{i:0;s:20:"comment.type.comment";}'),
('config.entity.key_store.contact_form', 'uuid:49120544-019a-4a16-92b0-dc034d77be37', 'a:1:{i:0;s:21:"contact.form.personal";}'),
('config.entity.key_store.contact_form', 'uuid:51ca1d3a-f352-463a-b529-f4139bcbda4c', 'a:1:{i:0;s:21:"contact.form.feedback";}'),
('config.entity.key_store.date_format', 'uuid:0043f673-2311-47a3-8e07-9ccd3e88f515', 'a:1:{i:0;s:23:"core.date_format.medium";}'),
('config.entity.key_store.date_format', 'uuid:0510f15c-bba3-4fbe-810b-888df4093d9d', 'a:1:{i:0;s:27:"core.date_format.html_month";}'),
('config.entity.key_store.date_format', 'uuid:27981e09-c2dd-4ba5-a71c-d436224ea3ed', 'a:1:{i:0;s:22:"core.date_format.short";}'),
('config.entity.key_store.date_format', 'uuid:285ca56b-52cd-49b1-a9b4-60f9ad742a47', 'a:1:{i:0;s:30:"core.date_format.html_datetime";}'),
('config.entity.key_store.date_format', 'uuid:3c610a90-945e-4017-aa14-83a196ddebe2', 'a:1:{i:0;s:26:"core.date_format.html_time";}'),
('config.entity.key_store.date_format', 'uuid:6337e01f-5d58-4cb6-8a01-bc8bc07649da', 'a:1:{i:0;s:26:"core.date_format.html_week";}'),
('config.entity.key_store.date_format', 'uuid:677379c6-a6bb-4337-b797-5eee3a9c43f5', 'a:1:{i:0;s:21:"core.date_format.long";}'),
('config.entity.key_store.date_format', 'uuid:87e6387f-681e-4138-abfe-f282947a76c2', 'a:1:{i:0;s:26:"core.date_format.html_date";}'),
('config.entity.key_store.date_format', 'uuid:97f8f94e-fd76-43ed-b7ce-5c39627b06c6', 'a:1:{i:0;s:31:"core.date_format.olivero_medium";}'),
('config.entity.key_store.date_format', 'uuid:bf5b161a-bbe5-4218-9e71-66e3f68d77d3', 'a:1:{i:0;s:25:"core.date_format.fallback";}'),
('config.entity.key_store.date_format', 'uuid:dd26f36c-4127-4b71-babf-c4fc0eb7a9ce', 'a:1:{i:0;s:26:"core.date_format.html_year";}'),
('config.entity.key_store.date_format', 'uuid:edaf37d5-d71f-42d8-b667-104617a02843', 'a:1:{i:0;s:35:"core.date_format.html_yearless_date";}'),
('config.entity.key_store.editor', 'uuid:5c139a2f-5770-41b1-947f-4529bcbd5c2b', 'a:1:{i:0;s:23:"editor.editor.full_html";}'),
('config.entity.key_store.editor', 'uuid:ea1c2d77-7e7a-4502-a955-040162a09a21', 'a:1:{i:0;s:24:"editor.editor.basic_html";}'),
('config.entity.key_store.entity_form_display', 'uuid:3f9273a6-2dba-4e07-b2a6-a5b3edc80c96', 'a:1:{i:0;s:52:"core.entity_form_display.block_content.basic.default";}'),
('config.entity.key_store.entity_form_display', 'uuid:573cdfa2-7afc-4db3-a2eb-b25c42f55825', 'a:1:{i:0;s:42:"core.entity_form_display.node.page.default";}'),
('config.entity.key_store.entity_form_display', 'uuid:e109d8f0-aafc-4a61-9e17-6fd3bf9deda5', 'a:1:{i:0;s:45:"core.entity_form_display.node.article.default";}'),
('config.entity.key_store.entity_form_display', 'uuid:e759fc97-ee45-4042-99d9-4c5e6962b176', 'a:1:{i:0;s:48:"core.entity_form_display.comment.comment.default";}'),
('config.entity.key_store.entity_form_display', 'uuid:fe542316-8f91-42fe-a3db-18c95b2eeaab', 'a:1:{i:0;s:42:"core.entity_form_display.user.user.default";}'),
('config.entity.key_store.entity_form_mode', 'uuid:746fb002-b357-4273-95c4-2953ec6a63fb', 'a:1:{i:0;s:35:"core.entity_form_mode.user.register";}'),
('config.entity.key_store.entity_view_display', 'uuid:2f1026d6-4c80-49f0-8a9e-2ad950cf4fb0', 'a:1:{i:0;s:48:"core.entity_view_display.comment.comment.default";}'),
('config.entity.key_store.entity_view_display', 'uuid:5b00507e-f0cf-4b35-baf2-742feab6db82', 'a:1:{i:0;s:41:"core.entity_view_display.node.article.rss";}'),
('config.entity.key_store.entity_view_display', 'uuid:a0decd53-7f50-4aaa-861b-5c5a5cbe3e94', 'a:1:{i:0;s:44:"core.entity_view_display.node.article.teaser";}'),
('config.entity.key_store.entity_view_display', 'uuid:aa86b799-d6a4-403d-b16c-f3db0eb130c2', 'a:1:{i:0;s:45:"core.entity_view_display.node.article.default";}'),
('config.entity.key_store.entity_view_display', 'uuid:ce65167c-0ee5-4934-b6f9-23d1c46df97f', 'a:1:{i:0;s:42:"core.entity_view_display.user.user.default";}'),
('config.entity.key_store.entity_view_display', 'uuid:ecec50fc-1274-4acb-b529-e85b7645d115', 'a:1:{i:0;s:42:"core.entity_view_display.node.page.default";}'),
('config.entity.key_store.entity_view_display', 'uuid:f6259cda-c806-4f23-94fd-bd37861e308a', 'a:1:{i:0;s:52:"core.entity_view_display.block_content.basic.default";}'),
('config.entity.key_store.entity_view_display', 'uuid:f9d04153-012b-42c2-ba2a-a6ce0c512626', 'a:1:{i:0;s:42:"core.entity_view_display.user.user.compact";}'),
('config.entity.key_store.entity_view_display', 'uuid:fa477118-5ba9-4f03-9390-ee9054f09a69', 'a:1:{i:0;s:41:"core.entity_view_display.node.page.teaser";}'),
('config.entity.key_store.entity_view_mode', 'uuid:1c982437-3da8-42e3-95c3-fa224beebc43', 'a:1:{i:0;s:39:"core.entity_view_mode.node.search_index";}'),
('config.entity.key_store.entity_view_mode', 'uuid:1d57ecb8-7bcc-49b8-aace-a390ef63dd3b', 'a:1:{i:0;s:34:"core.entity_view_mode.comment.full";}'),
('config.entity.key_store.entity_view_mode', 'uuid:3c5938ef-aaf4-4833-a463-da5b2d65ec6b', 'a:1:{i:0;s:40:"core.entity_view_mode.taxonomy_term.full";}'),
('config.entity.key_store.entity_view_mode', 'uuid:5b5095c4-d45b-48ec-9317-25b45bff30e7', 'a:1:{i:0;s:40:"core.entity_view_mode.node.search_result";}'),
('config.entity.key_store.entity_view_mode', 'uuid:70432595-60ca-4a54-90e6-a64913c389a4', 'a:1:{i:0;s:31:"core.entity_view_mode.node.full";}'),
('config.entity.key_store.entity_view_mode', 'uuid:7e7bd709-a7d7-4427-a954-d6b52eb8f4bb', 'a:1:{i:0;s:30:"core.entity_view_mode.node.rss";}'),
('config.entity.key_store.entity_view_mode', 'uuid:84be923b-209c-4e73-acde-941626b12a02', 'a:1:{i:0;s:40:"core.entity_view_mode.block_content.full";}'),
('config.entity.key_store.entity_view_mode', 'uuid:95752d06-853f-4981-a6cb-d2f444bd6542', 'a:1:{i:0;s:33:"core.entity_view_mode.node.teaser";}'),
('config.entity.key_store.entity_view_mode', 'uuid:c208d62c-bf7f-43a2-9828-631c6064d7b2', 'a:1:{i:0;s:34:"core.entity_view_mode.user.compact";}'),
('config.entity.key_store.entity_view_mode', 'uuid:dbd8d0bf-d38b-4458-8cda-4459cfe9bf0a', 'a:1:{i:0;s:31:"core.entity_view_mode.user.full";}'),
('config.entity.key_store.field_config', 'uuid:0f33a56f-376d-4758-a159-fac59f48c3fa', 'a:1:{i:0;s:34:"field.field.user.user.user_picture";}'),
('config.entity.key_store.field_config', 'uuid:20b684b8-5143-4fe1-9ae8-b585cec28e00', 'a:1:{i:0;s:26:"field.field.node.page.body";}'),
('config.entity.key_store.field_config', 'uuid:228a5a1c-ed15-4682-a5e2-700a29bb5c5f', 'a:1:{i:0;s:32:"field.field.node.article.comment";}'),
('config.entity.key_store.field_config', 'uuid:3ac3c85d-5ea8-4c2f-9264-f8b6f2a67719', 'a:1:{i:0;s:35:"field.field.node.article.field_tags";}'),
('config.entity.key_store.field_config', 'uuid:5adf333c-dae8-4b4b-9cb1-e8d0ad326588', 'a:1:{i:0;s:29:"field.field.node.article.body";}'),
('config.entity.key_store.field_config', 'uuid:6958adc6-4dfb-4ea5-b999-902e91dd1142', 'a:1:{i:0;s:36:"field.field.node.article.field_image";}'),
('config.entity.key_store.field_config', 'uuid:d2d25b18-74e6-47b7-82ce-6d8674ccbe47', 'a:1:{i:0;s:40:"field.field.comment.comment.comment_body";}'),
('config.entity.key_store.field_config', 'uuid:e15d8095-ce96-4d5e-a61a-9c9f5183b548', 'a:1:{i:0;s:36:"field.field.block_content.basic.body";}'),
('config.entity.key_store.field_storage_config', 'uuid:271091f9-10d6-4330-8fe8-c53e6e398f48', 'a:1:{i:0;s:26:"field.storage.node.comment";}'),
('config.entity.key_store.field_storage_config', 'uuid:512191d6-44bb-4a2f-baef-3a1914d3b158', 'a:1:{i:0;s:32:"field.storage.block_content.body";}'),
('config.entity.key_store.field_storage_config', 'uuid:5b68f621-44f9-4e63-9609-e42e7878f9d1', 'a:1:{i:0;s:29:"field.storage.node.field_tags";}'),
('config.entity.key_store.field_storage_config', 'uuid:6bc4fcb5-6b55-4bfe-9dfa-4385c9c598d5', 'a:1:{i:0;s:34:"field.storage.comment.comment_body";}'),
('config.entity.key_store.field_storage_config', 'uuid:700e4126-c5d7-4a9b-8143-78cac4abe782', 'a:1:{i:0;s:30:"field.storage.node.field_image";}'),
('config.entity.key_store.field_storage_config', 'uuid:97840e9f-94a5-4a72-8a9a-62c48abe9fd6', 'a:1:{i:0;s:31:"field.storage.user.user_picture";}'),
('config.entity.key_store.field_storage_config', 'uuid:ecaac161-1f86-469c-9653-ad36c02c1de4', 'a:1:{i:0;s:23:"field.storage.node.body";}'),
('config.entity.key_store.filter_format', 'uuid:06976546-bf54-446d-97e6-388f71ee8c57', 'a:1:{i:0;s:24:"filter.format.basic_html";}'),
('config.entity.key_store.filter_format', 'uuid:7e935f33-6ca2-4b6b-9c78-221a93348706', 'a:1:{i:0;s:23:"filter.format.full_html";}'),
('config.entity.key_store.filter_format', 'uuid:eb6f80d1-ba58-42f1-b170-7c61297fcf64', 'a:1:{i:0;s:24:"filter.format.plain_text";}'),
('config.entity.key_store.filter_format', 'uuid:ef4ece88-0a04-4fe8-869f-86289b3815d5', 'a:1:{i:0;s:29:"filter.format.restricted_html";}'),
('config.entity.key_store.image_style', 'uuid:0c4b37e9-e8ed-472f-9bae-26ee077235a9', 'a:1:{i:0;s:18:"image.style.medium";}'),
('config.entity.key_store.image_style', 'uuid:9359162a-89f5-4e7c-bd1a-280251b65ae2', 'a:1:{i:0;s:21:"image.style.thumbnail";}'),
('config.entity.key_store.image_style', 'uuid:e0ef4f25-c972-4b0e-b2b6-fbce611ec3ef', 'a:1:{i:0;s:16:"image.style.wide";}'),
('config.entity.key_store.image_style', 'uuid:f3415f16-f821-4c40-a7b5-cb7135df9a65', 'a:1:{i:0;s:17:"image.style.large";}'),
('config.entity.key_store.menu', 'uuid:0e483e1d-3e9e-468c-9c3f-55f233b130b4', 'a:1:{i:0;s:19:"system.menu.account";}'),
('config.entity.key_store.menu', 'uuid:3558f8a2-105d-4f80-8d70-39fb5ca5a27e', 'a:1:{i:0;s:17:"system.menu.tools";}'),
('config.entity.key_store.menu', 'uuid:75f33fc1-6fe2-4cc0-b526-860fe3fab452', 'a:1:{i:0;s:17:"system.menu.admin";}'),
('config.entity.key_store.menu', 'uuid:c05ccf3a-4a4e-433a-9933-9b1762f82809', 'a:1:{i:0;s:18:"system.menu.footer";}'),
('config.entity.key_store.menu', 'uuid:eac28f88-5d1c-4b10-9344-65491b60ac3b', 'a:1:{i:0;s:16:"system.menu.main";}'),
('config.entity.key_store.node_type', 'uuid:5de895cd-7143-4798-ae88-0620db2406c4', 'a:1:{i:0;s:14:"node.type.page";}'),
('config.entity.key_store.node_type', 'uuid:7b4ec372-1436-4e51-95a3-6d5df188958d', 'a:1:{i:0;s:17:"node.type.article";}'),
('config.entity.key_store.search_page', 'uuid:338efbfd-5e2c-418e-bb8b-9b2b13d9e72e', 'a:1:{i:0;s:23:"search.page.user_search";}'),
('config.entity.key_store.search_page', 'uuid:93c94432-be8e-46d9-9c1d-e4092db28f48', 'a:1:{i:0;s:23:"search.page.help_search";}'),
('config.entity.key_store.search_page', 'uuid:b82ff5ce-ed05-40ca-80ce-4f94b613b69b', 'a:1:{i:0;s:23:"search.page.node_search";}'),
('config.entity.key_store.shortcut_set', 'uuid:cc0036e0-36ed-4fd6-a6a9-b641cc6e5e40', 'a:1:{i:0;s:20:"shortcut.set.default";}'),
('config.entity.key_store.taxonomy_vocabulary', 'uuid:d7d858dc-ee4a-4073-8bf0-3ddf92c9958e', 'a:1:{i:0;s:24:"taxonomy.vocabulary.tags";}'),
('config.entity.key_store.user_role', 'uuid:4880cb04-4407-4b43-a4ad-5ba851e7937d', 'a:1:{i:0;s:19:"user.role.anonymous";}'),
('config.entity.key_store.user_role', 'uuid:5f94b210-364f-4940-aae2-ed46d75923f0', 'a:1:{i:0;s:23:"user.role.administrator";}'),
('config.entity.key_store.user_role', 'uuid:c5e78700-dc65-4cee-9f91-0cc2458bbfa2', 'a:1:{i:0;s:24:"user.role.content_editor";}'),
('config.entity.key_store.user_role', 'uuid:cacfa375-dc02-487e-aae6-860a1631cdbf', 'a:1:{i:0;s:23:"user.role.authenticated";}'),
('config.entity.key_store.view', 'uuid:1c08e454-3450-48f1-acb0-95cf98fd812d', 'a:1:{i:0;s:26:"views.view.comments_recent";}'),
('config.entity.key_store.view', 'uuid:42860050-a189-4887-a6fb-827ba81b2f40', 'a:1:{i:0;s:28:"views.view.user_admin_people";}'),
('config.entity.key_store.view', 'uuid:69c63b84-5199-4745-89dd-7aa6d60d4165', 'a:1:{i:0;s:18:"views.view.content";}'),
('config.entity.key_store.view', 'uuid:729678c2-197e-44be-970f-5d898d313f96', 'a:1:{i:0;s:16:"views.view.files";}'),
('config.entity.key_store.view', 'uuid:9500e5ad-906d-49b1-9f0d-5bb691116e26', 'a:1:{i:0;s:19:"views.view.glossary";}'),
('config.entity.key_store.view', 'uuid:9b35c2bb-5cc1-4327-801f-b4745838dd4a', 'a:1:{i:0;s:24:"views.view.block_content";}'),
('config.entity.key_store.view', 'uuid:9eb48132-e8ed-4879-b829-a811fda1f0e1', 'a:1:{i:0;s:24:"views.view.taxonomy_term";}'),
('config.entity.key_store.view', 'uuid:a225e720-4826-4653-a530-520e9999cb1a', 'a:1:{i:0;s:23:"views.view.who_s_online";}'),
('config.entity.key_store.view', 'uuid:a499d4f4-11fb-49ac-b4ac-0f91eb6999b5', 'a:1:{i:0;s:20:"views.view.frontpage";}'),
('config.entity.key_store.view', 'uuid:b7009850-90ad-4074-9490-4ebe5402fa88', 'a:1:{i:0;s:20:"views.view.who_s_new";}'),
('config.entity.key_store.view', 'uuid:bac3a9eb-8ce7-4b32-a149-033c71af4f06', 'a:1:{i:0;s:18:"views.view.comment";}'),
('config.entity.key_store.view', 'uuid:debe7784-d96f-4776-9303-a275d2a4c8a7', 'a:1:{i:0;s:25:"views.view.content_recent";}'),
('config.entity.key_store.view', 'uuid:e140ff4f-06d2-4575-9163-97977e483bcd', 'a:1:{i:0;s:19:"views.view.watchdog";}'),
('config.entity.key_store.view', 'uuid:f0636ddf-80bf-45ab-928f-c3b40ef7d43a', 'a:1:{i:0;s:18:"views.view.archive";}'),
('entity.definitions.bundle_field_map', 'block_content', 'a:1:{s:4:"body";a:2:{s:4:"type";s:17:"text_with_summary";s:7:"bundles";a:1:{s:5:"basic";s:5:"basic";}}}'),
('entity.definitions.bundle_field_map', 'comment', 'a:1:{s:12:"comment_body";a:2:{s:4:"type";s:9:"text_long";s:7:"bundles";a:1:{s:7:"comment";s:7:"comment";}}}'),
('entity.definitions.bundle_field_map', 'node', 'a:4:{s:11:"field_image";a:2:{s:4:"type";s:5:"image";s:7:"bundles";a:1:{s:7:"article";s:7:"article";}}s:7:"comment";a:2:{s:4:"type";s:7:"comment";s:7:"bundles";a:1:{s:7:"article";s:7:"article";}}s:10:"field_tags";a:2:{s:4:"type";s:16:"entity_reference";s:7:"bundles";a:1:{s:7:"article";s:7:"article";}}s:4:"body";a:2:{s:4:"type";s:17:"text_with_summary";s:7:"bundles";a:2:{s:4:"page";s:4:"page";s:7:"article";s:7:"article";}}}'),
('entity.definitions.bundle_field_map', 'user', 'a:1:{s:12:"user_picture";a:2:{s:4:"type";s:5:"image";s:7:"bundles";a:1:{s:4:"user";s:4:"user";}}}'),
('entity.definitions.installed', 'action.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:5:"\0*\0id";s:6:"action";s:8:"\0*\0class";s:27:"Drupal\\system\\Entity\\Action";s:11:"\0*\0provider";s:6:"system";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:27:"Drupal\\system\\Entity\\Action";s:11:"\0*\0handlers";a:2:{s:6:"access";s:45:"Drupal\\Core\\Entity\\EntityAccessControlHandler";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";s:18:"administer actions";s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:6:"Action";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Actions";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:6:"action";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"actions";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:13:"@count action";s:6:"plural";s:14:"@count actions";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:18:"config:action_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";N;s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:5:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:4:"type";i:3;s:6:"plugin";i:4;s:13:"configuration";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'base_field_override.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:5:"\0*\0id";s:19:"base_field_override";s:8:"\0*\0class";s:42:"Drupal\\Core\\Field\\Entity\\BaseFieldOverride";s:11:"\0*\0provider";s:4:"core";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:42:"Drupal\\Core\\Field\\Entity\\BaseFieldOverride";s:11:"\0*\0handlers";a:2:{s:7:"storage";s:42:"Drupal\\Core\\Field\\BaseFieldOverrideStorage";s:6:"access";s:55:"Drupal\\Core\\Field\\BaseFieldOverrideAccessControlHandler";}s:19:"\0*\0admin_permission";N;s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:19:"Base field override";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";s:0:"";s:17:"\0*\0label_singular";s:0:"";s:15:"\0*\0label_plural";s:0:"";s:14:"\0*\0label_count";a:0:{}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:31:"config:base_field_override_list";}s:14:"\0*\0constraints";a:1:{s:19:"ImmutableProperties";a:5:{i:0;s:2:"id";i:1;s:11:"entity_type";i:2;s:6:"bundle";i:3;s:10:"field_name";i:4;s:10:"field_type";}}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";s:19:"base_field_override";s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:12:{i:0;s:2:"id";i:1;s:10:"field_name";i:2;s:11:"entity_type";i:3;s:6:"bundle";i:4;s:5:"label";i:5;s:11:"description";i:6;s:8:"required";i:7;s:12:"translatable";i:8;s:13:"default_value";i:9;s:22:"default_value_callback";i:10;s:8:"settings";i:11;s:10:"field_type";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'block.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:5:"\0*\0id";s:5:"block";s:8:"\0*\0class";s:25:"Drupal\\block\\Entity\\Block";s:11:"\0*\0provider";s:5:"block";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:6:"status";s:6:"status";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:25:"Drupal\\block\\Entity\\Block";s:11:"\0*\0handlers";a:5:{s:6:"access";s:38:"Drupal\\block\\BlockAccessControlHandler";s:12:"view_builder";s:29:"Drupal\\block\\BlockViewBuilder";s:12:"list_builder";s:29:"Drupal\\block\\BlockListBuilder";s:4:"form";a:2:{s:7:"default";s:22:"Drupal\\block\\BlockForm";s:6:"delete";s:33:"Drupal\\block\\Form\\BlockDeleteForm";}s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";s:17:"administer blocks";s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:4:{s:11:"delete-form";s:44:"/admin/structure/block/manage/{block}/delete";s:9:"edit-form";s:37:"/admin/structure/block/manage/{block}";s:6:"enable";s:44:"/admin/structure/block/manage/{block}/enable";s:7:"disable";s:45:"/admin/structure/block/manage/{block}/disable";}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"Block";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:6:"Blocks";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"block";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:6:"blocks";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:12:"@count block";s:6:"plural";s:13:"@count blocks";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:17:"config:block_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";N;s:14:"\0*\0lookup_keys";a:2:{i:0;s:5:"theme";i:1;s:4:"uuid";}s:16:"\0*\0config_export";a:8:{i:0;s:2:"id";i:1;s:5:"theme";i:2;s:6:"region";i:3;s:6:"weight";i:4;s:8:"provider";i:5;s:6:"plugin";i:6;s:8:"settings";i:7;s:10:"visibility";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'block_content.entity_type', 'O:36:"Drupal\\Core\\Entity\\ContentEntityType":41:{s:5:"\0*\0id";s:13:"block_content";s:8:"\0*\0class";s:40:"Drupal\\block_content\\Entity\\BlockContent";s:11:"\0*\0provider";s:13:"block_content";s:15:"\0*\0static_cache";b:1;s:15:"\0*\0render_cache";b:0;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:9:{s:2:"id";s:2:"id";s:8:"revision";s:11:"revision_id";s:6:"bundle";s:4:"type";s:5:"label";s:4:"info";s:8:"langcode";s:8:"langcode";s:4:"uuid";s:4:"uuid";s:9:"published";s:6:"status";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:16:"\0*\0originalClass";s:40:"Drupal\\block_content\\Entity\\BlockContent";s:11:"\0*\0handlers";a:9:{s:7:"storage";s:46:"Drupal\\Core\\Entity\\Sql\\SqlContentEntityStorage";s:14:"storage_schema";s:46:"Drupal\\block_content\\BlockContentStorageSchema";s:6:"access";s:53:"Drupal\\block_content\\BlockContentAccessControlHandler";s:12:"list_builder";s:44:"Drupal\\block_content\\BlockContentListBuilder";s:12:"view_builder";s:44:"Drupal\\block_content\\BlockContentViewBuilder";s:10:"views_data";s:42:"Drupal\\block_content\\BlockContentViewsData";s:4:"form";a:6:{s:3:"add";s:37:"Drupal\\block_content\\BlockContentForm";s:4:"edit";s:37:"Drupal\\block_content\\BlockContentForm";s:6:"delete";s:48:"Drupal\\block_content\\Form\\BlockContentDeleteForm";s:7:"default";s:37:"Drupal\\block_content\\BlockContentForm";s:15:"revision-delete";s:42:"Drupal\\Core\\Entity\\Form\\RevisionDeleteForm";s:15:"revision-revert";s:42:"Drupal\\Core\\Entity\\Form\\RevisionRevertForm";}s:14:"route_provider";a:1:{s:8:"revision";s:52:"Drupal\\Core\\Entity\\Routing\\RevisionHtmlRouteProvider";}s:11:"translation";s:51:"Drupal\\block_content\\BlockContentTranslationHandler";}s:19:"\0*\0admin_permission";s:24:"administer block content";s:24:"\0*\0collection_permission";s:20:"access block library";s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:8:{s:9:"canonical";s:36:"/admin/content/block/{block_content}";s:11:"delete-form";s:43:"/admin/content/block/{block_content}/delete";s:9:"edit-form";s:36:"/admin/content/block/{block_content}";s:10:"collection";s:20:"/admin/content/block";s:6:"create";s:6:"/block";s:20:"revision-delete-form";s:77:"/admin/content/block/{block_content}/revision/{block_content_revision}/delete";s:20:"revision-revert-form";s:77:"/admin/content/block/{block_content}/revision/{block_content_revision}/revert";s:15:"version-history";s:46:"/admin/content/block/{block_content}/revisions";}s:21:"\0*\0bundle_entity_type";s:18:"block_content_type";s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:10:"Block type";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"\0*\0base_table";s:13:"block_content";s:22:"\0*\0revision_data_table";s:28:"block_content_field_revision";s:17:"\0*\0revision_table";s:22:"block_content_revision";s:13:"\0*\0data_table";s:24:"block_content_field_data";s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:1;s:19:"\0*\0show_revision_ui";b:1;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Content block";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:14:"Content blocks";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"content block";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:14:"content blocks";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:20:"@count content block";s:6:"plural";s:21:"@count content blocks";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:7:"content";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Content";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";s:35:"entity.block_content_type.edit_form";s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:18:"block_content_list";}s:14:"\0*\0constraints";a:2:{s:26:"EntityUntranslatableFields";N;s:25:"BlockContentEntityChanged";N;}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:25:"\0*\0revision_metadata_keys";a:4:{s:13:"revision_user";s:13:"revision_user";s:16:"revision_created";s:16:"revision_created";s:20:"revision_log_message";s:12:"revision_log";s:16:"revision_default";s:16:"revision_default";}}');
INSERT INTO `[[dbprefix]]key_value` VALUES
('entity.definitions.installed', 'block_content.field_storage_definitions', 'a:16:{s:2:"id";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:16:"Content block ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:21:"The content block ID.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:13:"block_content";s:10:"field_name";s:2:"id";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:"\0*\0fieldDefinition";r:2;}s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"uuid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"UUID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:23:"The content block UUID.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:13:"block_content";s:10:"field_name";s:4:"uuid";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:15:"field_item:uuid";s:8:"settings";a:3:{s:10:"max_length";i:128;s:8:"is_ascii";b:1;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:40;}s:7:"\0*\0type";s:4:"uuid";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;}}s:11:"unique keys";a:1:{s:5:"value";a:1:{i:0;s:5:"value";}}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:11:"revision_id";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Revision ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:16:"The revision ID.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:13:"block_content";s:10:"field_name";s:11:"revision_id";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:"\0*\0fieldDefinition";r:77;}s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:8:"langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Language";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:1:{s:6:"region";s:6:"hidden";}}s:4:"form";a:1:{s:7:"options";a:2:{s:4:"type";s:15:"language_select";s:6:"weight";i:2;}}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:32:"The content block language code.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:13:"block_content";s:10:"field_name";s:8:"langcode";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:19:"field_item:language";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:115;}s:7:"\0*\0type";s:8:"language";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"type";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:10:"Block type";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:15:"The block type.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:13:"block_content";s:10:"field_name";s:4:"type";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:18:"block_content_type";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}s:18:"\0*\0fieldDefinition";r:155;}s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:16:"revision_created";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:20:"Revision create time";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:47:"The time that the current revision was created.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:8:"provider";s:13:"block_content";s:10:"field_name";s:16:"revision_created";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:created";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:193;}s:7:"\0*\0type";s:7:"created";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:13:"revision_user";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Revision user";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:50:"The user ID of the author of the current revision.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:8:"provider";s:13:"block_content";s:10:"field_name";s:13:"revision_user";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:4:"user";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}s:18:"\0*\0fieldDefinition";r:223;}s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:12:"revision_log";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:20:"Revision log message";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:54:"The log entry explaining the changes in this revision.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";s:0:"";}}s:7:"display";a:1:{s:4:"form";a:1:{s:7:"options";a:3:{s:4:"type";s:15:"string_textarea";s:6:"weight";i:25;s:8:"settings";a:1:{s:4:"rows";i:4;}}}}s:8:"provider";s:13:"block_content";s:10:"field_name";s:12:"revision_log";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:22:"field_item:string_long";s:8:"settings";a:1:{s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:260;}s:7:"\0*\0type";s:11:"string_long";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:6:"status";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"Published";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:8:"provider";s:13:"block_content";s:10:"field_name";s:6:"status";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:302;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"info";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:11:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:17:"Block description";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:34:"A brief description of your block.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:8:"required";b:1;s:7:"display";a:1:{s:4:"form";a:2:{s:7:"options";a:2:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-5;}s:12:"configurable";b:1;}}s:8:"provider";s:13:"block_content";s:10:"field_name";s:4:"info";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:341;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:7:"changed";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Changed";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:48:"The time that the content block was last edited.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:12:"revisionable";b:1;s:8:"provider";s:13:"block_content";s:10:"field_name";s:7:"changed";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:changed";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:384;}s:7:"\0*\0type";s:7:"changed";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:8:"reusable";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Reusable";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:52:"A boolean indicating whether this block is reusable.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:0;s:12:"revisionable";b:0;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:8:"provider";s:13:"block_content";s:10:"field_name";s:8:"reusable";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:415;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:16:"default_langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:19:"Default translation";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:58:"A flag indicating whether this is the default translation.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:12:"revisionable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:8:"provider";s:13:"block_content";s:10:"field_name";s:16:"default_langcode";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:458;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:16:"revision_default";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:11:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:16:"Default revision";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:72:"A flag indicating whether this was a default revision when it was saved.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:16:"storage_required";b:1;s:8:"internal";b:1;s:12:"translatable";b:0;s:12:"revisionable";b:1;s:8:"provider";s:13:"block_content";s:10:"field_name";s:16:"revision_default";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:501;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:29:"revision_translation_affected";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:29:"Revision translation affected";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:72:"Indicates if the last edit of a translation belongs to current revision.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:12:"revisionable";b:1;s:12:"translatable";b:1;s:8:"provider";s:13:"block_content";s:10:"field_name";s:29:"revision_translation_affected";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:543;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"body";O:38:"Drupal\\field\\Entity\\FieldStorageConfig":30:{s:15:"\0*\0entityTypeId";s:20:"field_storage_config";s:15:"\0*\0enforceIsNew";b:1;s:12:"\0*\0typedData";N;s:16:"\0*\0cacheContexts";a:0:{}s:12:"\0*\0cacheTags";a:0:{}s:14:"\0*\0cacheMaxAge";i:-1;s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:13:"\0*\0originalId";s:18:"block_content.body";s:9:"\0*\0status";b:1;s:7:"\0*\0uuid";s:36:"512191d6-44bb-4a2f-baef-3a1914d3b158";s:11:"\0*\0langcode";s:2:"en";s:23:"\0*\0third_party_settings";a:0:{}s:8:"\0*\0_core";a:1:{s:19:"default_config_hash";s:43:"eS0snV_L3dx9shtWRTzm5eblwOJ7qKWC9IE-4GMTDFc";}s:14:"\0*\0trustedData";b:1;s:15:"\0*\0dependencies";a:1:{s:6:"module";a:2:{i:0;s:13:"block_content";i:1;s:4:"text";}}s:12:"\0*\0isSyncing";b:0;s:5:"\0*\0id";s:18:"block_content.body";s:13:"\0*\0field_name";s:4:"body";s:14:"\0*\0entity_type";s:13:"block_content";s:7:"\0*\0type";s:17:"text_with_summary";s:9:"\0*\0module";s:4:"text";s:11:"\0*\0settings";a:0:{}s:14:"\0*\0cardinality";i:1;s:15:"\0*\0translatable";b:1;s:9:"\0*\0locked";b:0;s:25:"\0*\0persist_with_no_fields";b:1;s:14:"custom_storage";b:0;s:10:"\0*\0indexes";a:0:{}s:10:"\0*\0deleted";b:0;}}'),
('entity.definitions.installed', 'block_content_type.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:5:"\0*\0id";s:18:"block_content_type";s:8:"\0*\0class";s:44:"Drupal\\block_content\\Entity\\BlockContentType";s:11:"\0*\0provider";s:13:"block_content";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:44:"Drupal\\block_content\\Entity\\BlockContentType";s:11:"\0*\0handlers";a:5:{s:6:"access";s:50:"Drupal\\block_content\\BlockTypeAccessControlHandler";s:4:"form";a:4:{s:7:"default";s:41:"Drupal\\block_content\\BlockContentTypeForm";s:3:"add";s:41:"Drupal\\block_content\\BlockContentTypeForm";s:4:"edit";s:41:"Drupal\\block_content\\BlockContentTypeForm";s:6:"delete";s:52:"Drupal\\block_content\\Form\\BlockContentTypeDeleteForm";}s:14:"route_provider";a:2:{s:4:"html";s:49:"Drupal\\Core\\Entity\\Routing\\AdminHtmlRouteProvider";s:11:"permissions";s:49:"Drupal\\user\\Entity\\EntityPermissionsRouteProvider";}s:12:"list_builder";s:48:"Drupal\\block_content\\BlockContentTypeListBuilder";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";s:22:"administer block types";s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:4:{s:11:"delete-form";s:65:"/admin/structure/block-content/manage/{block_content_type}/delete";s:9:"edit-form";s:58:"/admin/structure/block-content/manage/{block_content_type}";s:23:"entity-permissions-form";s:70:"/admin/structure/block-content/manage/{block_content_type}/permissions";s:10:"collection";s:30:"/admin/structure/block-content";}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";s:13:"block_content";s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:10:"Block type";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Block types";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:10:"block type";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"block types";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:17:"@count block type";s:6:"plural";s:18:"@count block types";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:30:"config:block_content_type_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";s:4:"type";s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:4:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:8:"revision";i:3;s:11:"description";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'comment.entity_type', 'O:36:"Drupal\\Core\\Entity\\ContentEntityType":41:{s:5:"\0*\0id";s:7:"comment";s:8:"\0*\0class";s:29:"Drupal\\comment\\Entity\\Comment";s:11:"\0*\0provider";s:7:"comment";s:15:"\0*\0static_cache";b:1;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:10:{s:2:"id";s:3:"cid";s:6:"bundle";s:12:"comment_type";s:5:"label";s:7:"subject";s:8:"langcode";s:8:"langcode";s:4:"uuid";s:4:"uuid";s:9:"published";s:6:"status";s:5:"owner";s:3:"uid";s:8:"revision";s:0:"";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:16:"\0*\0originalClass";s:29:"Drupal\\comment\\Entity\\Comment";s:11:"\0*\0handlers";a:8:{s:7:"storage";s:29:"Drupal\\comment\\CommentStorage";s:14:"storage_schema";s:35:"Drupal\\comment\\CommentStorageSchema";s:6:"access";s:42:"Drupal\\comment\\CommentAccessControlHandler";s:12:"list_builder";s:36:"Drupal\\Core\\Entity\\EntityListBuilder";s:12:"view_builder";s:33:"Drupal\\comment\\CommentViewBuilder";s:10:"views_data";s:31:"Drupal\\comment\\CommentViewsData";s:4:"form";a:2:{s:7:"default";s:26:"Drupal\\comment\\CommentForm";s:6:"delete";s:30:"Drupal\\comment\\Form\\DeleteForm";}s:11:"translation";s:40:"Drupal\\comment\\CommentTranslationHandler";}s:19:"\0*\0admin_permission";N;s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:5:{s:9:"canonical";s:18:"/comment/{comment}";s:11:"delete-form";s:25:"/comment/{comment}/delete";s:20:"delete-multiple-form";s:29:"/admin/content/comment/delete";s:9:"edit-form";s:23:"/comment/{comment}/edit";s:6:"create";s:8:"/comment";}s:21:"\0*\0bundle_entity_type";s:12:"comment_type";s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Comment type";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"\0*\0base_table";s:7:"comment";s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";s:18:"comment_field_data";s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:1;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Comment";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";s:0:"";s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"comment";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"comments";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:14:"@count comment";s:6:"plural";s:15:"@count comments";s:7:"context";N;}s:15:"\0*\0uri_callback";s:11:"comment_uri";s:8:"\0*\0group";s:7:"content";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Content";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";s:29:"entity.comment_type.edit_form";s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:12:"comment_list";}s:14:"\0*\0constraints";a:3:{s:11:"CommentName";a:0:{}s:13:"EntityChanged";N;s:26:"EntityUntranslatableFields";N;}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:25:"\0*\0revision_metadata_keys";a:1:{s:16:"revision_default";s:16:"revision_default";}}');
INSERT INTO `[[dbprefix]]key_value` VALUES
('entity.definitions.installed', 'comment.field_storage_definitions', 'a:20:{s:3:"cid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:10:"Comment ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:15:"The comment ID.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:7:"comment";s:10:"field_name";s:3:"cid";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:"\0*\0fieldDefinition";r:2;}s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"uuid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"UUID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:17:"The comment UUID.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:7:"comment";s:10:"field_name";s:4:"uuid";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:15:"field_item:uuid";s:8:"settings";a:3:{s:10:"max_length";i:128;s:8:"is_ascii";b:1;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:40;}s:7:"\0*\0type";s:4:"uuid";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;}}s:11:"unique keys";a:1:{s:5:"value";a:1:{i:0;s:5:"value";}}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:8:"langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Language";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:1:{s:6:"region";s:6:"hidden";}}s:4:"form";a:1:{s:7:"options";a:2:{s:4:"type";s:15:"language_select";s:6:"weight";i:2;}}}s:12:"translatable";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:26:"The comment language code.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:7:"comment";s:10:"field_name";s:8:"langcode";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:19:"field_item:language";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:77;}s:7:"\0*\0type";s:8:"language";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:12:"comment_type";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Comment Type";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:17:"The comment type.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:7:"comment";s:10:"field_name";s:12:"comment_type";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:12:"comment_type";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}s:18:"\0*\0fieldDefinition";r:116;}s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:6:"status";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"Published";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:22:"default_value_callback";s:47:"Drupal\\comment\\Entity\\Comment::getDefaultStatus";s:8:"provider";s:7:"comment";s:10:"field_name";s:6:"status";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:154;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:3:"uid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"User ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:22:"default_value_callback";s:52:"Drupal\\comment\\Entity\\Comment::getDefaultEntityOwner";s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:34:"The user ID of the comment author.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:7:"comment";s:10:"field_name";s:3:"uid";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:4:"user";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}s:18:"\0*\0fieldDefinition";r:194;}s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:3:"pid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"Parent ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:54:"The parent comment ID if this is a reply to a comment.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:7:"comment";s:10:"field_name";s:3:"pid";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:7:"comment";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}s:18:"\0*\0fieldDefinition";r:232;}s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:9:"entity_id";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"Entity ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:54:"The ID of the entity of which this comment is a reply.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:8:"provider";s:7:"comment";s:10:"field_name";s:9:"entity_id";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:4:"node";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}s:18:"\0*\0fieldDefinition";r:268;}s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:7:"subject";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Subject";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:7:"display";a:1:{s:4:"form";a:2:{s:7:"options";a:2:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:10;}s:12:"configurable";b:1;}}s:8:"provider";s:7:"comment";s:10:"field_name";s:7:"subject";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:64;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:305;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:64;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"name";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"Name";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:26:"The comment author''s name.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";s:0:"";}}s:8:"provider";s:7:"comment";s:10:"field_name";s:4:"name";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:60;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:342;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:60;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"mail";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"Email";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:35:"The comment author''s email address.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:8:"provider";s:7:"comment";s:10:"field_name";s:4:"mail";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:16:"field_item:email";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:380;}s:7:"\0*\0type";s:5:"email";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:7:"varchar";s:6:"length";i:254;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:8:"homepage";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Homepage";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:39:"The comment author''s home page address.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:8:"provider";s:7:"comment";s:10:"field_name";s:8:"homepage";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:14:"field_item:uri";s:8:"settings";a:2:{s:10:"max_length";i:255;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:411;}s:7:"\0*\0type";s:3:"uri";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:8:"hostname";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Hostname";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:30:"The comment author''s hostname.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:22:"default_value_callback";s:49:"Drupal\\comment\\Entity\\Comment::getDefaultHostname";s:8:"provider";s:7:"comment";s:10:"field_name";s:8:"hostname";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:128;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:445;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:128;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:7:"created";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Created";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:38:"The time that the comment was created.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:8:"provider";s:7:"comment";s:10:"field_name";s:7:"created";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:created";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:481;}s:7:"\0*\0type";s:7:"created";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:7:"changed";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Changed";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:42:"The time that the comment was last edited.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:8:"provider";s:7:"comment";s:10:"field_name";s:7:"changed";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:changed";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:511;}s:7:"\0*\0type";s:7:"changed";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:6:"thread";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Thread place";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:144:"The alphadecimal representation of the comment''s place in a thread, consisting of a base 36 string prefixed by an integer indicating its length.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:7:"comment";s:10:"field_name";s:6:"thread";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:541;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:11:"entity_type";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Entity type";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:50:"The entity type to which this comment is attached.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:7:"comment";s:10:"field_name";s:11:"entity_type";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:32;s:8:"is_ascii";b:1;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:575;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:10:"field_name";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:18:"Comment field name";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:52:"The field name through which this comment was added.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:7:"comment";s:10:"field_name";s:10:"field_name";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:32;s:8:"is_ascii";b:1;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:610;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:16:"default_langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:19:"Default translation";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:58:"A flag indicating whether this is the default translation.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:12:"revisionable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:8:"provider";s:7:"comment";s:10:"field_name";s:16:"default_langcode";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:645;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:12:"comment_body";O:38:"Drupal\\field\\Entity\\FieldStorageConfig":30:{s:15:"\0*\0entityTypeId";s:20:"field_storage_config";s:15:"\0*\0enforceIsNew";b:1;s:12:"\0*\0typedData";N;s:16:"\0*\0cacheContexts";a:0:{}s:12:"\0*\0cacheTags";a:0:{}s:14:"\0*\0cacheMaxAge";i:-1;s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:13:"\0*\0originalId";s:20:"comment.comment_body";s:9:"\0*\0status";b:1;s:7:"\0*\0uuid";s:36:"6bc4fcb5-6b55-4bfe-9dfa-4385c9c598d5";s:11:"\0*\0langcode";s:2:"en";s:23:"\0*\0third_party_settings";a:0:{}s:8:"\0*\0_core";a:1:{s:19:"default_config_hash";s:43:"swYoCch_hY8QO5uwr4FURplfnUCUlpPB4idF8WGVCpw";}s:14:"\0*\0trustedData";b:1;s:15:"\0*\0dependencies";a:1:{s:6:"module";a:2:{i:0;s:7:"comment";i:1;s:4:"text";}}s:12:"\0*\0isSyncing";b:0;s:5:"\0*\0id";s:20:"comment.comment_body";s:13:"\0*\0field_name";s:12:"comment_body";s:14:"\0*\0entity_type";s:7:"comment";s:7:"\0*\0type";s:9:"text_long";s:9:"\0*\0module";s:4:"text";s:11:"\0*\0settings";a:0:{}s:14:"\0*\0cardinality";i:1;s:15:"\0*\0translatable";b:1;s:9:"\0*\0locked";b:0;s:25:"\0*\0persist_with_no_fields";b:1;s:14:"custom_storage";b:0;s:10:"\0*\0indexes";a:0:{}s:10:"\0*\0deleted";b:0;}}'),
('entity.definitions.installed', 'comment_type.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:5:"\0*\0id";s:12:"comment_type";s:8:"\0*\0class";s:33:"Drupal\\comment\\Entity\\CommentType";s:11:"\0*\0provider";s:7:"comment";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:33:"Drupal\\comment\\Entity\\CommentType";s:11:"\0*\0handlers";a:5:{s:4:"form";a:4:{s:7:"default";s:30:"Drupal\\comment\\CommentTypeForm";s:3:"add";s:30:"Drupal\\comment\\CommentTypeForm";s:4:"edit";s:30:"Drupal\\comment\\CommentTypeForm";s:6:"delete";s:41:"Drupal\\comment\\Form\\CommentTypeDeleteForm";}s:14:"route_provider";a:1:{s:11:"permissions";s:58:"Drupal\\user\\Entity\\EntityPermissionsRouteProviderWithCheck";}s:12:"list_builder";s:37:"Drupal\\comment\\CommentTypeListBuilder";s:6:"access";s:45:"Drupal\\Core\\Entity\\EntityAccessControlHandler";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";s:24:"administer comment types";s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:5:{s:11:"delete-form";s:53:"/admin/structure/comment/manage/{comment_type}/delete";s:9:"edit-form";s:46:"/admin/structure/comment/manage/{comment_type}";s:8:"add-form";s:34:"/admin/structure/comment/types/add";s:23:"entity-permissions-form";s:58:"/admin/structure/comment/manage/{comment_type}/permissions";s:10:"collection";s:24:"/admin/structure/comment";}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";s:7:"comment";s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Comment type";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";s:0:"";s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"comment type";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"comment types";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:19:"@count comment type";s:6:"plural";s:20:"@count comment types";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:24:"config:comment_type_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";s:4:"type";s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:4:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:21:"target_entity_type_id";i:3;s:11:"description";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'contact_form.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:5:"\0*\0id";s:12:"contact_form";s:8:"\0*\0class";s:33:"Drupal\\contact\\Entity\\ContactForm";s:11:"\0*\0provider";s:7:"contact";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:33:"Drupal\\contact\\Entity\\ContactForm";s:11:"\0*\0handlers";a:5:{s:6:"access";s:46:"Drupal\\contact\\ContactFormAccessControlHandler";s:12:"list_builder";s:37:"Drupal\\contact\\ContactFormListBuilder";s:4:"form";a:3:{s:3:"add";s:34:"Drupal\\contact\\ContactFormEditForm";s:4:"edit";s:34:"Drupal\\contact\\ContactFormEditForm";s:6:"delete";s:35:"Drupal\\Core\\Entity\\EntityDeleteForm";}s:14:"route_provider";a:1:{s:11:"permissions";s:58:"Drupal\\user\\Entity\\EntityPermissionsRouteProviderWithCheck";}s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";s:24:"administer contact forms";s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:5:{s:11:"delete-form";s:53:"/admin/structure/contact/manage/{contact_form}/delete";s:9:"edit-form";s:46:"/admin/structure/contact/manage/{contact_form}";s:23:"entity-permissions-form";s:58:"/admin/structure/contact/manage/{contact_form}/permissions";s:10:"collection";s:24:"/admin/structure/contact";s:9:"canonical";s:23:"/contact/{contact_form}";}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";s:15:"contact_message";s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Contact form";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Contact forms";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"contact form";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"contact forms";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:19:"@count contact form";s:6:"plural";s:20:"@count contact forms";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:24:"config:contact_form_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";s:4:"form";s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:7:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:10:"recipients";i:3;s:5:"reply";i:4;s:6:"weight";i:5;s:7:"message";i:6;s:8:"redirect";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'contact_message.entity_type', 'O:36:"Drupal\\Core\\Entity\\ContentEntityType":41:{s:5:"\0*\0id";s:15:"contact_message";s:8:"\0*\0class";s:29:"Drupal\\contact\\Entity\\Message";s:11:"\0*\0provider";s:7:"contact";s:15:"\0*\0static_cache";b:1;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:6:{s:6:"bundle";s:12:"contact_form";s:4:"uuid";s:4:"uuid";s:8:"langcode";s:8:"langcode";s:8:"revision";s:0:"";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:16:"\0*\0originalClass";s:29:"Drupal\\contact\\Entity\\Message";s:11:"\0*\0handlers";a:4:{s:6:"access";s:49:"Drupal\\contact\\ContactMessageAccessControlHandler";s:7:"storage";s:43:"Drupal\\Core\\Entity\\ContentEntityNullStorage";s:12:"view_builder";s:33:"Drupal\\contact\\MessageViewBuilder";s:4:"form";a:1:{s:7:"default";s:26:"Drupal\\contact\\MessageForm";}}s:19:"\0*\0admin_permission";s:24:"administer contact forms";s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:21:"\0*\0bundle_entity_type";s:12:"contact_form";s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Contact form";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:15:"Contact message";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:16:"Contact messages";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:15:"contact message";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:16:"contact messages";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:22:"@count contact message";s:6:"plural";s:23:"@count contact messages";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:7:"content";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Content";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";s:29:"entity.contact_form.edit_form";s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:20:"contact_message_list";}s:14:"\0*\0constraints";a:1:{s:26:"EntityUntranslatableFields";N;}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:25:"\0*\0revision_metadata_keys";a:1:{s:16:"revision_default";s:16:"revision_default";}}'),
('entity.definitions.installed', 'contact_message.field_storage_definitions', 'a:9:{s:4:"uuid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"UUID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:17:"The message UUID.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:7:"contact";s:10:"field_name";s:4:"uuid";s:11:"entity_type";s:15:"contact_message";s:6:"bundle";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:15:"field_item:uuid";s:8:"settings";a:3:{s:10:"max_length";i:128;s:8:"is_ascii";b:1;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:2;}s:7:"\0*\0type";s:4:"uuid";s:9:"\0*\0schema";N;s:10:"\0*\0indexes";a:0:{}}s:8:"langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Language";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:1:{s:6:"region";s:6:"hidden";}}s:4:"form";a:1:{s:7:"options";a:2:{s:4:"type";s:15:"language_select";s:6:"weight";i:2;}}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:26:"The message language code.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:7:"contact";s:10:"field_name";s:8:"langcode";s:11:"entity_type";s:15:"contact_message";s:6:"bundle";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:19:"field_item:language";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:28;}s:7:"\0*\0type";s:8:"language";s:9:"\0*\0schema";N;s:10:"\0*\0indexes";a:0:{}}s:12:"contact_form";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Form ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:30:"The ID of the associated form.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:7:"contact";s:10:"field_name";s:12:"contact_form";s:11:"entity_type";s:15:"contact_message";s:6:"bundle";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:12:"contact_form";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}s:18:"\0*\0fieldDefinition";r:58;}s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";N;s:10:"\0*\0indexes";a:0:{}}s:4:"name";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:6:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:17:"The sender''s name";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:59:"The name of the person that is sending the contact message.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:7:"contact";s:10:"field_name";s:4:"name";s:11:"entity_type";s:15:"contact_message";s:6:"bundle";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:85;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";N;s:10:"\0*\0indexes";a:0:{}}s:4:"mail";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:6:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:18:"The sender''s email";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:60:"The email of the person that is sending the contact message.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:7:"contact";s:10:"field_name";s:4:"mail";s:11:"entity_type";s:15:"contact_message";s:6:"bundle";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:16:"field_item:email";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:110;}s:7:"\0*\0type";s:5:"email";s:9:"\0*\0schema";N;s:10:"\0*\0indexes";a:0:{}}s:7:"subject";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Subject";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:7:"display";a:1:{s:4:"form";a:2:{s:7:"options";a:2:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-10;}s:12:"configurable";b:1;}}s:8:"provider";s:7:"contact";s:10:"field_name";s:7:"subject";s:11:"entity_type";s:15:"contact_message";s:6:"bundle";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:100;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:132;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";N;s:10:"\0*\0indexes";a:0:{}}s:7:"message";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Message";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:7:"display";a:2:{s:4:"form";a:2:{s:7:"options";a:3:{s:4:"type";s:15:"string_textarea";s:6:"weight";i:0;s:8:"settings";a:1:{s:4:"rows";i:12;}}s:12:"configurable";b:1;}s:4:"view";a:2:{s:7:"options";a:3:{s:4:"type";s:6:"string";s:6:"weight";i:0;s:5:"label";s:5:"above";}s:12:"configurable";b:1;}}s:8:"provider";s:7:"contact";s:10:"field_name";s:7:"message";s:11:"entity_type";s:15:"contact_message";s:6:"bundle";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:22:"field_item:string_long";s:8:"settings";a:1:{s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:160;}s:7:"\0*\0type";s:11:"string_long";s:9:"\0*\0schema";N;s:10:"\0*\0indexes";a:0:{}}s:4:"copy";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:6:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"Copy";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:52:"Whether to send a copy of the message to the sender.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:7:"contact";s:10:"field_name";s:4:"copy";s:11:"entity_type";s:15:"contact_message";s:6:"bundle";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:194;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";N;s:10:"\0*\0indexes";a:0:{}}s:9:"recipient";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:6:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Recipient ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:59:"The ID of the recipient user for personal contact messages.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:7:"contact";s:10:"field_name";s:9:"recipient";s:11:"entity_type";s:15:"contact_message";s:6:"bundle";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:4:"user";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}s:18:"\0*\0fieldDefinition";r:224;}s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";N;s:10:"\0*\0indexes";a:0:{}}}'),
('entity.definitions.installed', 'date_format.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:5:"\0*\0id";s:11:"date_format";s:8:"\0*\0class";s:38:"Drupal\\Core\\Datetime\\Entity\\DateFormat";s:11:"\0*\0provider";s:4:"core";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:38:"Drupal\\Core\\Datetime\\Entity\\DateFormat";s:11:"\0*\0handlers";a:4:{s:6:"access";s:44:"Drupal\\system\\DateFormatAccessControlHandler";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";s:4:"form";a:3:{s:3:"add";s:36:"Drupal\\system\\Form\\DateFormatAddForm";s:4:"edit";s:37:"Drupal\\system\\Form\\DateFormatEditForm";s:6:"delete";s:39:"Drupal\\system\\Form\\DateFormatDeleteForm";}s:12:"list_builder";s:35:"Drupal\\system\\DateFormatListBuilder";}s:19:"\0*\0admin_permission";s:29:"administer site configuration";s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:3:{s:9:"edit-form";s:61:"/admin/config/regional/date-time/formats/manage/{date_format}";s:11:"delete-form";s:68:"/admin/config/regional/date-time/formats/manage/{date_format}/delete";s:10:"collection";s:40:"/admin/config/regional/date-time/formats";}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Date format";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";s:0:"";s:17:"\0*\0label_singular";s:0:"";s:15:"\0*\0label_plural";s:0:"";s:14:"\0*\0label_count";a:0:{}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:8:"rendered";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";N;s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:4:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:6:"locked";i:3;s:7:"pattern";}s:21:"\0*\0mergedConfigExport";a:10:{s:4:"uuid";s:4:"uuid";s:8:"langcode";s:8:"langcode";s:6:"status";s:6:"status";s:12:"dependencies";s:12:"dependencies";s:20:"third_party_settings";s:20:"third_party_settings";s:5:"_core";s:5:"_core";s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:6:"locked";s:6:"locked";s:7:"pattern";s:7:"pattern";}}');
INSERT INTO `[[dbprefix]]key_value` VALUES
('entity.definitions.installed', 'editor.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:5:"\0*\0id";s:6:"editor";s:8:"\0*\0class";s:27:"Drupal\\editor\\Entity\\Editor";s:11:"\0*\0provider";s:6:"editor";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:7:{s:2:"id";s:6:"format";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:27:"Drupal\\editor\\Entity\\Editor";s:11:"\0*\0handlers";a:2:{s:6:"access";s:40:"Drupal\\editor\\EditorAccessControlHandler";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";N;s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Text editor";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Text editors";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"text editor";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"text editors";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:18:"@count text editor";s:6:"plural";s:19:"@count text editors";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:18:"config:editor_list";}s:14:"\0*\0constraints";a:1:{s:26:"RequiredConfigDependencies";a:1:{i:0;s:13:"filter_format";}}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";N;s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:4:{i:0;s:6:"format";i:1;s:6:"editor";i:2;s:8:"settings";i:3;s:12:"image_upload";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'entity_form_display.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:5:"\0*\0id";s:19:"entity_form_display";s:8:"\0*\0class";s:43:"Drupal\\Core\\Entity\\Entity\\EntityFormDisplay";s:11:"\0*\0provider";s:4:"core";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:6:"status";s:6:"status";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:43:"Drupal\\Core\\Entity\\Entity\\EntityFormDisplay";s:11:"\0*\0handlers";a:2:{s:6:"access";s:71:"\\Drupal\\Core\\Entity\\Entity\\Access\\EntityFormDisplayAccessControlHandler";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";N;s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:19:"Entity form display";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";s:0:"";s:17:"\0*\0label_singular";s:0:"";s:15:"\0*\0label_plural";s:0:"";s:14:"\0*\0label_count";a:0:{}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:31:"config:entity_form_display_list";}s:14:"\0*\0constraints";a:1:{s:19:"ImmutableProperties";a:4:{i:0;s:2:"id";i:1;s:16:"targetEntityType";i:2;s:6:"bundle";i:3;s:4:"mode";}}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";N;s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:6:{i:0;s:2:"id";i:1;s:16:"targetEntityType";i:2;s:6:"bundle";i:3;s:4:"mode";i:4;s:7:"content";i:5;s:6:"hidden";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'entity_form_mode.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:5:"\0*\0id";s:16:"entity_form_mode";s:8:"\0*\0class";s:40:"Drupal\\Core\\Entity\\Entity\\EntityFormMode";s:11:"\0*\0provider";s:4:"core";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:9:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:11:"description";s:11:"description";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:40:"Drupal\\Core\\Entity\\Entity\\EntityFormMode";s:11:"\0*\0handlers";a:2:{s:6:"access";s:45:"Drupal\\Core\\Entity\\EntityAccessControlHandler";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";N;s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"Form mode";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";s:0:"";s:17:"\0*\0label_singular";s:0:"";s:15:"\0*\0label_plural";s:0:"";s:14:"\0*\0label_count";a:0:{}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:28:"config:entity_form_mode_list";}s:14:"\0*\0constraints";a:1:{s:19:"ImmutableProperties";a:2:{i:0;s:2:"id";i:1;s:16:"targetEntityType";}}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";N;s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:5:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:11:"description";i:3;s:16:"targetEntityType";i:4;s:5:"cache";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'entity_view_display.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:5:"\0*\0id";s:19:"entity_view_display";s:8:"\0*\0class";s:43:"Drupal\\Core\\Entity\\Entity\\EntityViewDisplay";s:11:"\0*\0provider";s:4:"core";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:6:"status";s:6:"status";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:43:"Drupal\\Core\\Entity\\Entity\\EntityViewDisplay";s:11:"\0*\0handlers";a:2:{s:6:"access";s:71:"\\Drupal\\Core\\Entity\\Entity\\Access\\EntityViewDisplayAccessControlHandler";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";N;s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:19:"Entity view display";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";s:0:"";s:17:"\0*\0label_singular";s:0:"";s:15:"\0*\0label_plural";s:0:"";s:14:"\0*\0label_count";a:0:{}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:31:"config:entity_view_display_list";}s:14:"\0*\0constraints";a:1:{s:19:"ImmutableProperties";a:4:{i:0;s:2:"id";i:1;s:16:"targetEntityType";i:2;s:6:"bundle";i:3;s:4:"mode";}}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";N;s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:6:{i:0;s:2:"id";i:1;s:16:"targetEntityType";i:2;s:6:"bundle";i:3;s:4:"mode";i:4;s:7:"content";i:5;s:6:"hidden";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'entity_view_mode.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:5:"\0*\0id";s:16:"entity_view_mode";s:8:"\0*\0class";s:40:"Drupal\\Core\\Entity\\Entity\\EntityViewMode";s:11:"\0*\0provider";s:4:"core";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:9:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:11:"description";s:11:"description";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:40:"Drupal\\Core\\Entity\\Entity\\EntityViewMode";s:11:"\0*\0handlers";a:2:{s:6:"access";s:45:"Drupal\\Core\\Entity\\EntityAccessControlHandler";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";N;s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"View mode";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";s:0:"";s:17:"\0*\0label_singular";s:0:"";s:15:"\0*\0label_plural";s:0:"";s:14:"\0*\0label_count";a:0:{}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:28:"config:entity_view_mode_list";}s:14:"\0*\0constraints";a:1:{s:19:"ImmutableProperties";a:2:{i:0;s:2:"id";i:1;s:16:"targetEntityType";}}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";N;s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:5:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:11:"description";i:3;s:16:"targetEntityType";i:4;s:5:"cache";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'field_config.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:5:"\0*\0id";s:12:"field_config";s:8:"\0*\0class";s:31:"Drupal\\field\\Entity\\FieldConfig";s:11:"\0*\0provider";s:5:"field";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:31:"Drupal\\field\\Entity\\FieldConfig";s:11:"\0*\0handlers";a:2:{s:6:"access";s:44:"Drupal\\field\\FieldConfigAccessControlHandler";s:7:"storage";s:31:"Drupal\\field\\FieldConfigStorage";}s:19:"\0*\0admin_permission";N;s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"Field";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:6:"Fields";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"field";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:6:"fields";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:12:"@count field";s:6:"plural";s:13:"@count fields";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:24:"config:field_config_list";}s:14:"\0*\0constraints";a:2:{s:26:"RequiredConfigDependencies";a:1:{i:0;s:20:"field_storage_config";}s:19:"ImmutableProperties";a:5:{i:0;s:2:"id";i:1;s:11:"entity_type";i:2;s:10:"field_name";i:3;s:6:"bundle";i:4;s:10:"field_type";}}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";s:5:"field";s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:12:{i:0;s:2:"id";i:1;s:10:"field_name";i:2;s:11:"entity_type";i:3;s:6:"bundle";i:4;s:5:"label";i:5;s:11:"description";i:6;s:8:"required";i:7;s:12:"translatable";i:8;s:13:"default_value";i:9;s:22:"default_value_callback";i:10;s:8:"settings";i:11;s:10:"field_type";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'field_storage_config.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:5:"\0*\0id";s:20:"field_storage_config";s:8:"\0*\0class";s:38:"Drupal\\field\\Entity\\FieldStorageConfig";s:11:"\0*\0provider";s:5:"field";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:2:"id";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:38:"Drupal\\field\\Entity\\FieldStorageConfig";s:11:"\0*\0handlers";a:2:{s:6:"access";s:51:"Drupal\\field\\FieldStorageConfigAccessControlHandler";s:7:"storage";s:38:"Drupal\\field\\FieldStorageConfigStorage";}s:19:"\0*\0admin_permission";N;s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Field storage";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:14:"Field storages";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"field storage";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:14:"field storages";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:20:"@count field storage";s:6:"plural";s:21:"@count field storages";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:32:"config:field_storage_config_list";}s:14:"\0*\0constraints";a:1:{s:19:"ImmutableProperties";a:4:{i:0;s:2:"id";i:1;s:11:"entity_type";i:2;s:10:"field_name";i:3;s:4:"type";}}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";s:7:"storage";s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:12:{i:0;s:2:"id";i:1;s:10:"field_name";i:2;s:11:"entity_type";i:3;s:4:"type";i:4;s:8:"settings";i:5;s:6:"module";i:6;s:6:"locked";i:7;s:11:"cardinality";i:8;s:12:"translatable";i:9;s:7:"indexes";i:10;s:22:"persist_with_no_fields";i:11;s:14:"custom_storage";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'file.entity_type', 'O:36:"Drupal\\Core\\Entity\\ContentEntityType":41:{s:5:"\0*\0id";s:4:"file";s:8:"\0*\0class";s:23:"Drupal\\file\\Entity\\File";s:11:"\0*\0provider";s:4:"file";s:15:"\0*\0static_cache";b:1;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:9:{s:2:"id";s:3:"fid";s:5:"label";s:8:"filename";s:8:"langcode";s:8:"langcode";s:4:"uuid";s:4:"uuid";s:5:"owner";s:3:"uid";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:16:"\0*\0originalClass";s:23:"Drupal\\file\\Entity\\File";s:11:"\0*\0handlers";a:8:{s:7:"storage";s:23:"Drupal\\file\\FileStorage";s:14:"storage_schema";s:29:"Drupal\\file\\FileStorageSchema";s:6:"access";s:36:"Drupal\\file\\FileAccessControlHandler";s:10:"views_data";s:25:"Drupal\\file\\FileViewsData";s:12:"list_builder";s:36:"Drupal\\Core\\Entity\\EntityListBuilder";s:4:"form";a:1:{s:6:"delete";s:42:"Drupal\\Core\\Entity\\ContentEntityDeleteForm";}s:14:"route_provider";a:1:{s:4:"html";s:36:"Drupal\\file\\Entity\\FileRouteProvider";}s:12:"view_builder";s:36:"Drupal\\Core\\Entity\\EntityViewBuilder";}s:19:"\0*\0admin_permission";N;s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:1:{s:11:"delete-form";s:19:"/file/{file}/delete";}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";s:12:"file_managed";s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"File";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"Files";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"file";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"files";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:11:"@count file";s:6:"plural";s:12:"@count files";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:7:"content";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Content";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:9:"file_list";}s:14:"\0*\0constraints";a:2:{s:13:"EntityChanged";N;s:26:"EntityUntranslatableFields";N;}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:25:"\0*\0revision_metadata_keys";a:1:{s:16:"revision_default";s:16:"revision_default";}}'),
('entity.definitions.installed', 'file.field_storage_definitions', 'a:11:{s:3:"fid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"File ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"The file ID.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"file";s:10:"field_name";s:3:"fid";s:11:"entity_type";s:4:"file";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:"\0*\0fieldDefinition";r:2;}s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"uuid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"UUID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:14:"The file UUID.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"file";s:10:"field_name";s:4:"uuid";s:11:"entity_type";s:4:"file";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:15:"field_item:uuid";s:8:"settings";a:3:{s:10:"max_length";i:128;s:8:"is_ascii";b:1;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:40;}s:7:"\0*\0type";s:4:"uuid";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;}}s:11:"unique keys";a:1:{s:5:"value";a:1:{i:0;s:5:"value";}}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:8:"langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Language code";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:1:{s:6:"region";s:6:"hidden";}}s:4:"form";a:1:{s:7:"options";a:2:{s:4:"type";s:15:"language_select";s:6:"weight";i:2;}}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:23:"The file language code.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"file";s:10:"field_name";s:8:"langcode";s:11:"entity_type";s:4:"file";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:19:"field_item:language";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:77;}s:7:"\0*\0type";s:8:"language";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:3:"uid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"User ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:0;s:22:"default_value_callback";s:46:"Drupal\\file\\Entity\\File::getDefaultEntityOwner";s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:24:"The user ID of the file.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"file";s:10:"field_name";s:3:"uid";s:11:"entity_type";s:4:"file";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:4:"user";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}s:18:"\0*\0fieldDefinition";r:115;}s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:8:"filename";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Filename";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:41:"Name of the file with no path components.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"file";s:10:"field_name";s:8:"filename";s:11:"entity_type";s:4:"file";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:153;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:3:"uri";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"URI";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:52:"The URI to access the file (either local or remote).";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"constraints";a:1:{s:13:"FileUriUnique";N;}s:8:"provider";s:4:"file";s:10:"field_name";s:3:"uri";s:11:"entity_type";s:4:"file";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:19:"field_item:file_uri";s:8:"settings";a:2:{s:10:"max_length";i:255;s:14:"case_sensitive";b:1;}}s:18:"\0*\0fieldDefinition";r:187;}s:7:"\0*\0type";s:8:"file_uri";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:1;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:8:"filemime";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:14:"File MIME type";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:21:"The file''s MIME type.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"file";s:10:"field_name";s:8:"filemime";s:11:"entity_type";s:4:"file";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:1;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:222;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:8:"filesize";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"File size";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:30:"The size of the file in bytes.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"file";s:10:"field_name";s:8:"filesize";s:11:"entity_type";s:4:"file";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:3:"big";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:"\0*\0fieldDefinition";r:256;}s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:3:"big";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:6:"status";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:6:"Status";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:63:"The status of the file, temporary (FALSE) and permanent (TRUE).";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:0;}}s:8:"provider";s:4:"file";s:10:"field_name";s:6:"status";s:11:"entity_type";s:4:"file";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:293;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:7:"created";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Created";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:40:"The timestamp that the file was created.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"file";s:10:"field_name";s:7:"created";s:11:"entity_type";s:4:"file";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:created";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:334;}s:7:"\0*\0type";s:7:"created";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:7:"changed";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Changed";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:45:"The timestamp that the file was last changed.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"file";s:10:"field_name";s:7:"changed";s:11:"entity_type";s:4:"file";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:changed";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:363;}s:7:"\0*\0type";s:7:"changed";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}}'),
('entity.definitions.installed', 'filter_format.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:5:"\0*\0id";s:13:"filter_format";s:8:"\0*\0class";s:33:"Drupal\\filter\\Entity\\FilterFormat";s:11:"\0*\0provider";s:6:"filter";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:10:{s:2:"id";s:6:"format";s:5:"label";s:4:"name";s:6:"weight";s:6:"weight";s:6:"status";s:6:"status";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:33:"Drupal\\filter\\Entity\\FilterFormat";s:11:"\0*\0handlers";a:4:{s:4:"form";a:4:{s:3:"add";s:33:"Drupal\\filter\\FilterFormatAddForm";s:4:"edit";s:34:"Drupal\\filter\\FilterFormatEditForm";s:7:"disable";s:36:"Drupal\\filter\\Form\\FilterDisableForm";s:6:"enable";s:35:"Drupal\\filter\\Form\\FilterEnableForm";}s:12:"list_builder";s:37:"Drupal\\filter\\FilterFormatListBuilder";s:6:"access";s:46:"Drupal\\filter\\FilterFormatAccessControlHandler";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";s:18:"administer filters";s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:3:{s:9:"edit-form";s:52:"/admin/config/content/formats/manage/{filter_format}";s:7:"disable";s:60:"/admin/config/content/formats/manage/{filter_format}/disable";s:6:"enable";s:59:"/admin/config/content/formats/manage/{filter_format}/enable";}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Text format";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Text formats";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"text format";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"text formats";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:18:"@count text format";s:6:"plural";s:19:"@count text formats";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:25:"config:filter_format_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";s:6:"format";s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:5:{i:0;s:4:"name";i:1;s:6:"format";i:2;s:6:"weight";i:3;s:5:"roles";i:4;s:7:"filters";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'image_style.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:5:"\0*\0id";s:11:"image_style";s:8:"\0*\0class";s:30:"Drupal\\image\\Entity\\ImageStyle";s:11:"\0*\0provider";s:5:"image";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:4:"name";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:30:"Drupal\\image\\Entity\\ImageStyle";s:11:"\0*\0handlers";a:4:{s:4:"form";a:4:{s:3:"add";s:35:"Drupal\\image\\Form\\ImageStyleAddForm";s:4:"edit";s:36:"Drupal\\image\\Form\\ImageStyleEditForm";s:6:"delete";s:38:"Drupal\\image\\Form\\ImageStyleDeleteForm";s:5:"flush";s:37:"Drupal\\image\\Form\\ImageStyleFlushForm";}s:12:"list_builder";s:34:"Drupal\\image\\ImageStyleListBuilder";s:7:"storage";s:30:"Drupal\\image\\ImageStyleStorage";s:6:"access";s:45:"Drupal\\Core\\Entity\\EntityAccessControlHandler";}s:19:"\0*\0admin_permission";s:23:"administer image styles";s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:4:{s:10:"flush-form";s:59:"/admin/config/media/image-styles/manage/{image_style}/flush";s:9:"edit-form";s:53:"/admin/config/media/image-styles/manage/{image_style}";s:11:"delete-form";s:60:"/admin/config/media/image-styles/manage/{image_style}/delete";s:10:"collection";s:32:"/admin/config/media/image-styles";}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Image style";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Image styles";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"image style";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"image styles";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:18:"@count image style";s:6:"plural";s:19:"@count image styles";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:23:"config:image_style_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";s:5:"style";s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:3:{i:0;s:4:"name";i:1;s:5:"label";i:2;s:7:"effects";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'menu.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:5:"\0*\0id";s:4:"menu";s:8:"\0*\0class";s:25:"Drupal\\system\\Entity\\Menu";s:11:"\0*\0provider";s:6:"system";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:25:"Drupal\\system\\Entity\\Menu";s:11:"\0*\0handlers";a:2:{s:6:"access";s:38:"Drupal\\system\\MenuAccessControlHandler";s:7:"storage";s:25:"Drupal\\system\\MenuStorage";}s:19:"\0*\0admin_permission";s:15:"administer menu";s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"Menu";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"Menus";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"menu";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"menus";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:11:"@count menu";s:6:"plural";s:12:"@count menus";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:16:"config:menu_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";N;s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:4:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:11:"description";i:3;s:6:"locked";}s:21:"\0*\0mergedConfigExport";a:0:{}}');
INSERT INTO `[[dbprefix]]key_value` VALUES
('entity.definitions.installed', 'menu_link_content.entity_type', 'O:36:"Drupal\\Core\\Entity\\ContentEntityType":40:{s:5:"\0*\0id";s:17:"menu_link_content";s:8:"\0*\0class";s:47:"Drupal\\menu_link_content\\Entity\\MenuLinkContent";s:11:"\0*\0provider";s:17:"menu_link_content";s:15:"\0*\0static_cache";b:1;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:9:{s:2:"id";s:2:"id";s:8:"revision";s:11:"revision_id";s:5:"label";s:5:"title";s:8:"langcode";s:8:"langcode";s:4:"uuid";s:4:"uuid";s:6:"bundle";s:6:"bundle";s:9:"published";s:7:"enabled";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:16:"\0*\0originalClass";s:47:"Drupal\\menu_link_content\\Entity\\MenuLinkContent";s:11:"\0*\0handlers";a:7:{s:7:"storage";s:48:"\\Drupal\\menu_link_content\\MenuLinkContentStorage";s:14:"storage_schema";s:53:"Drupal\\menu_link_content\\MenuLinkContentStorageSchema";s:6:"access";s:60:"Drupal\\menu_link_content\\MenuLinkContentAccessControlHandler";s:4:"form";a:2:{s:7:"default";s:49:"Drupal\\menu_link_content\\Form\\MenuLinkContentForm";s:6:"delete";s:55:"Drupal\\menu_link_content\\Form\\MenuLinkContentDeleteForm";}s:12:"list_builder";s:44:"Drupal\\menu_link_content\\MenuLinkListBuilder";s:12:"view_builder";s:36:"Drupal\\Core\\Entity\\EntityViewBuilder";s:10:"moderation";s:0:"";}s:19:"\0*\0admin_permission";s:15:"administer menu";s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:3:{s:9:"canonical";s:51:"/admin/structure/menu/item/{menu_link_content}/edit";s:9:"edit-form";s:51:"/admin/structure/menu/item/{menu_link_content}/edit";s:11:"delete-form";s:53:"/admin/structure/menu/item/{menu_link_content}/delete";}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";s:17:"menu_link_content";s:22:"\0*\0revision_data_table";s:32:"menu_link_content_field_revision";s:17:"\0*\0revision_table";s:26:"menu_link_content_revision";s:13:"\0*\0data_table";s:22:"menu_link_content_data";s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:1;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:16:"Custom menu link";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:17:"Custom menu links";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:16:"custom menu link";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:17:"custom menu links";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:23:"@count custom menu link";s:6:"plural";s:24:"@count custom menu links";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:7:"content";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Content";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:22:"menu_link_content_list";}s:14:"\0*\0constraints";a:3:{s:17:"MenuTreeHierarchy";a:0:{}s:13:"EntityChanged";N;s:26:"EntityUntranslatableFields";N;}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:1:{s:17:"stringTranslation";s:18:"string_translation";}s:18:"\0*\0_entityStorages";a:0:{}s:25:"\0*\0revision_metadata_keys";a:4:{s:13:"revision_user";s:13:"revision_user";s:16:"revision_created";s:16:"revision_created";s:20:"revision_log_message";s:20:"revision_log_message";s:16:"revision_default";s:16:"revision_default";}}'),
('entity.definitions.installed', 'menu_link_content.field_storage_definitions', 'a:22:{s:2:"id";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"Entity ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:48:"The entity ID for this menu link content entity.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:2:"id";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:"\0*\0fieldDefinition";r:2;}s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"uuid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"UUID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:27:"The content menu link UUID.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:4:"uuid";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:15:"field_item:uuid";s:8:"settings";a:3:{s:10:"max_length";i:128;s:8:"is_ascii";b:1;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:40;}s:7:"\0*\0type";s:4:"uuid";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;}}s:11:"unique keys";a:1:{s:5:"value";a:1:{i:0;s:5:"value";}}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:11:"revision_id";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Revision ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:11:"revision_id";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:"\0*\0fieldDefinition";r:77;}s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:8:"langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Language";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:1:{s:6:"region";s:6:"hidden";}}s:4:"form";a:1:{s:7:"options";a:2:{s:4:"type";s:15:"language_select";s:6:"weight";i:2;}}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:28:"The menu link language code.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:8:"langcode";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:19:"field_item:language";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:111;}s:7:"\0*\0type";s:8:"language";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:6:"bundle";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";s:23:"Custom menu link bundle";s:8:"required";b:1;s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:29:"The content menu link bundle.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:6:"bundle";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:32;s:8:"is_ascii";b:1;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:151;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:16:"revision_created";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:20:"Revision create time";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:47:"The time that the current revision was created.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:16:"revision_created";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:created";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:184;}s:7:"\0*\0type";s:7:"created";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:13:"revision_user";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Revision user";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:50:"The user ID of the author of the current revision.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:13:"revision_user";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:4:"user";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}s:18:"\0*\0fieldDefinition";r:214;}s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:20:"revision_log_message";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:20:"Revision log message";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:43:"Briefly describe the changes you have made.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";s:0:"";}}s:7:"display";a:1:{s:4:"form";a:1:{s:7:"options";a:1:{s:6:"region";s:6:"hidden";}}}s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:20:"revision_log_message";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:22:"field_item:string_long";s:8:"settings";a:1:{s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:251;}s:7:"\0*\0type";s:11:"string_long";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:7:"enabled";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:11:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Enabled";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:12:"translatable";b:0;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:65:"A flag for whether the link should be enabled in menus or hidden.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:3:{s:5:"label";s:6:"hidden";s:4:"type";s:7:"boolean";s:6:"weight";i:0;}}s:4:"form";a:1:{s:7:"options";a:2:{s:8:"settings";a:1:{s:13:"display_label";b:1;}s:6:"weight";i:-1;}}}s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:7:"enabled";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:290;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:5:"title";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:11:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:15:"Menu link title";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:46:"The text to be used for this link in the menu.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:12:"translatable";b:1;s:12:"revisionable";b:1;s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:3:{s:5:"label";s:6:"hidden";s:4:"type";s:6:"string";s:6:"weight";i:-5;}}s:4:"form";a:2:{s:7:"options";a:2:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-5;}s:12:"configurable";b:1;}}s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:5:"title";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:344;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:11:"description";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Description";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:39:"Shown when hovering over the menu link.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:12:"revisionable";b:1;s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:3:{s:5:"label";s:6:"hidden";s:4:"type";s:6:"string";s:6:"weight";i:0;}}s:4:"form";a:1:{s:7:"options";a:2:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:0;}}}s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:11:"description";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:392;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:9:"menu_name";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"Menu name";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:93:"The menu name. All links with the same menu name (such as "tools") are part of the same menu.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";s:5:"tools";}}s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:9:"menu_name";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:1;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:438;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"link";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"Link";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:38:"The location this menu link points to.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:8:"required";b:1;s:7:"display";a:1:{s:4:"form";a:1:{s:7:"options";a:2:{s:4:"type";s:12:"link_default";s:6:"weight";i:-2;}}}s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:4:"link";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:15:"field_item:link";s:8:"settings";a:2:{s:5:"title";i:0;s:9:"link_type";i:17;}}s:18:"\0*\0fieldDefinition";r:475;}s:7:"\0*\0type";s:4:"link";s:9:"\0*\0schema";a:4:{s:7:"columns";a:3:{s:3:"uri";a:3:{s:11:"description";s:20:"The URI of the link.";s:4:"type";s:7:"varchar";s:6:"length";i:2048;}s:5:"title";a:3:{s:11:"description";s:14:"The link text.";s:4:"type";s:7:"varchar";s:6:"length";i:255;}s:7:"options";a:4:{s:11:"description";s:41:"Serialized array of options for the link.";s:4:"type";s:4:"blob";s:4:"size";s:3:"big";s:9:"serialize";b:1;}}s:7:"indexes";a:1:{s:3:"uri";a:1:{i:0;a:2:{i:0;s:3:"uri";i:1;i:30;}}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:8:"external";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"External";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:120:"A flag to indicate if the link points to a full URL starting with a protocol, like http:// (1 = external, 0 = internal).";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:0;}}s:12:"revisionable";b:1;s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:8:"external";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:528;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:10:"rediscover";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:54:"Indicates whether the menu link should be rediscovered";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:0;}}s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:10:"rediscover";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:570;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:6:"weight";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:6:"Weight";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:172:"Link weight among links in the same menu at the same depth. In the menu, the links with high weight will sink and links with a low weight will be positioned nearer the top.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";i:0;}}s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:3:{s:5:"label";s:6:"hidden";s:4:"type";s:14:"number_integer";s:6:"weight";i:0;}}s:4:"form";a:1:{s:7:"options";a:2:{s:4:"type";s:6:"number";s:6:"weight";i:20;}}}s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:6:"weight";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:0;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:"\0*\0fieldDefinition";r:607;}s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:0;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:8:"expanded";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:16:"Show as expanded";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:164:"If selected and this menu link has children, the menu will always appear expanded. This option may be overridden for the entire menu tree when placing a menu block.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:0;}}s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:3:{s:5:"label";s:6:"hidden";s:4:"type";s:7:"boolean";s:6:"weight";i:0;}}s:4:"form";a:1:{s:7:"options";a:2:{s:8:"settings";a:1:{s:13:"display_label";b:1;}s:6:"weight";i:0;}}}s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:8:"expanded";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:657;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:6:"parent";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:16:"Parent plugin ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:94:"The ID of the parent menu link plugin, or empty string when at the top level of the hierarchy.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:6:"parent";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:709;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:7:"changed";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Changed";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:44:"The time that the menu link was last edited.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:12:"revisionable";b:1;s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:7:"changed";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:changed";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:743;}s:7:"\0*\0type";s:7:"changed";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:16:"default_langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:19:"Default translation";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:58:"A flag indicating whether this is the default translation.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:12:"revisionable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:16:"default_langcode";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:774;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:16:"revision_default";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:11:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:16:"Default revision";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:72:"A flag indicating whether this was a default revision when it was saved.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:16:"storage_required";b:1;s:8:"internal";b:1;s:12:"translatable";b:0;s:12:"revisionable";b:1;s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:16:"revision_default";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:817;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:29:"revision_translation_affected";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:29:"Revision translation affected";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:72:"Indicates if the last edit of a translation belongs to current revision.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:12:"revisionable";b:1;s:12:"translatable";b:1;s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:29:"revision_translation_affected";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:859;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}}'),
('entity.definitions.installed', 'node.entity_type', 'O:36:"Drupal\\Core\\Entity\\ContentEntityType":41:{s:5:"\0*\0id";s:4:"node";s:8:"\0*\0class";s:23:"Drupal\\node\\Entity\\Node";s:11:"\0*\0provider";s:4:"node";s:15:"\0*\0static_cache";b:1;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:12:{s:2:"id";s:3:"nid";s:8:"revision";s:3:"vid";s:6:"bundle";s:4:"type";s:5:"label";s:5:"title";s:8:"langcode";s:8:"langcode";s:4:"uuid";s:4:"uuid";s:6:"status";s:6:"status";s:9:"published";s:6:"status";s:3:"uid";s:3:"uid";s:5:"owner";s:3:"uid";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:16:"\0*\0originalClass";s:23:"Drupal\\node\\Entity\\Node";s:11:"\0*\0handlers";a:9:{s:7:"storage";s:23:"Drupal\\node\\NodeStorage";s:14:"storage_schema";s:29:"Drupal\\node\\NodeStorageSchema";s:12:"view_builder";s:27:"Drupal\\node\\NodeViewBuilder";s:6:"access";s:36:"Drupal\\node\\NodeAccessControlHandler";s:10:"views_data";s:25:"Drupal\\node\\NodeViewsData";s:4:"form";a:4:{s:7:"default";s:20:"Drupal\\node\\NodeForm";s:6:"delete";s:31:"Drupal\\node\\Form\\NodeDeleteForm";s:4:"edit";s:20:"Drupal\\node\\NodeForm";s:23:"delete-multiple-confirm";s:31:"Drupal\\node\\Form\\DeleteMultiple";}s:14:"route_provider";a:1:{s:4:"html";s:36:"Drupal\\node\\Entity\\NodeRouteProvider";}s:12:"list_builder";s:27:"Drupal\\node\\NodeListBuilder";s:11:"translation";s:34:"Drupal\\node\\NodeTranslationHandler";}s:19:"\0*\0admin_permission";N;s:24:"\0*\0collection_permission";s:23:"access content overview";s:25:"\0*\0permission_granularity";s:6:"bundle";s:8:"\0*\0links";a:7:{s:9:"canonical";s:12:"/node/{node}";s:11:"delete-form";s:19:"/node/{node}/delete";s:20:"delete-multiple-form";s:26:"/admin/content/node/delete";s:9:"edit-form";s:17:"/node/{node}/edit";s:15:"version-history";s:22:"/node/{node}/revisions";s:8:"revision";s:43:"/node/{node}/revisions/{node_revision}/view";s:6:"create";s:5:"/node";}s:21:"\0*\0bundle_entity_type";s:9:"node_type";s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Content type";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"\0*\0base_table";s:4:"node";s:22:"\0*\0revision_data_table";s:19:"node_field_revision";s:17:"\0*\0revision_table";s:13:"node_revision";s:13:"\0*\0data_table";s:15:"node_field_data";s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:1;s:19:"\0*\0show_revision_ui";b:1;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Content";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Content";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"content item";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"content items";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:19:"@count content item";s:6:"plural";s:20:"@count content items";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:7:"content";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Content";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";s:26:"entity.node_type.edit_form";s:26:"\0*\0common_reference_target";b:1;s:22:"\0*\0list_cache_contexts";a:1:{i:0;s:21:"user.node_grants:view";}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:9:"node_list";}s:14:"\0*\0constraints";a:2:{s:13:"EntityChanged";N;s:26:"EntityUntranslatableFields";N;}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:25:"\0*\0revision_metadata_keys";a:4:{s:13:"revision_user";s:12:"revision_uid";s:16:"revision_created";s:18:"revision_timestamp";s:20:"revision_log_message";s:12:"revision_log";s:16:"revision_default";s:16:"revision_default";}}');
INSERT INTO `[[dbprefix]]key_value` VALUES
('entity.definitions.installed', 'node.field_storage_definitions', 'a:22:{s:3:"nid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:8:"provider";s:4:"node";s:10:"field_name";s:3:"nid";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:"\0*\0fieldDefinition";r:2;}s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"uuid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"UUID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:8:"provider";s:4:"node";s:10:"field_name";s:4:"uuid";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:15:"field_item:uuid";s:8:"settings";a:3:{s:10:"max_length";i:128;s:8:"is_ascii";b:1;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:36;}s:7:"\0*\0type";s:4:"uuid";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;}}s:11:"unique keys";a:1:{s:5:"value";a:1:{i:0;s:5:"value";}}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:3:"vid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Revision ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:8:"provider";s:4:"node";s:10:"field_name";s:3:"vid";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:"\0*\0fieldDefinition";r:69;}s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:8:"langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Language";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:1:{s:6:"region";s:6:"hidden";}}s:4:"form";a:1:{s:7:"options";a:2:{s:4:"type";s:15:"language_select";s:6:"weight";i:2;}}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:8:"provider";s:4:"node";s:10:"field_name";s:8:"langcode";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:19:"field_item:language";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:103;}s:7:"\0*\0type";s:8:"language";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"type";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";s:12:"Content type";s:8:"required";b:1;s:9:"read-only";b:1;s:8:"provider";s:4:"node";s:10:"field_name";s:4:"type";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:9:"node_type";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}s:18:"\0*\0fieldDefinition";r:139;}s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:18:"revision_timestamp";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:20:"Revision create time";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:47:"The time that the current revision was created.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:8:"provider";s:4:"node";s:10:"field_name";s:18:"revision_timestamp";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:created";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:170;}s:7:"\0*\0type";s:7:"created";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:12:"revision_uid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Revision user";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:50:"The user ID of the author of the current revision.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:8:"provider";s:4:"node";s:10:"field_name";s:12:"revision_uid";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:4:"user";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}s:18:"\0*\0fieldDefinition";r:200;}s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:12:"revision_log";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:20:"Revision log message";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:43:"Briefly describe the changes you have made.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";s:0:"";}}s:7:"display";a:1:{s:4:"form";a:1:{s:7:"options";a:3:{s:4:"type";s:15:"string_textarea";s:6:"weight";i:25;s:8:"settings";a:1:{s:4:"rows";i:4;}}}}s:8:"provider";s:4:"node";s:10:"field_name";s:12:"revision_log";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:22:"field_item:string_long";s:8:"settings";a:1:{s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:237;}s:7:"\0*\0type";s:11:"string_long";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:6:"status";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"Published";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:7:"display";a:1:{s:4:"form";a:2:{s:7:"options";a:3:{s:4:"type";s:16:"boolean_checkbox";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:6:"weight";i:120;}s:12:"configurable";b:1;}}s:8:"provider";s:4:"node";s:10:"field_name";s:6:"status";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:279;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:3:"uid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:11:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Authored by";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:22:"default_value_callback";s:46:"Drupal\\node\\Entity\\Node::getDefaultEntityOwner";s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:35:"The username of the content author.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:3:{s:5:"label";s:6:"hidden";s:4:"type";s:6:"author";s:6:"weight";i:0;}}s:4:"form";a:2:{s:7:"options";a:3:{s:4:"type";s:29:"entity_reference_autocomplete";s:6:"weight";i:5;s:8:"settings";a:3:{s:14:"match_operator";s:8:"CONTAINS";s:4:"size";s:2:"60";s:11:"placeholder";s:0:"";}}s:12:"configurable";b:1;}}s:8:"provider";s:4:"node";s:10:"field_name";s:3:"uid";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:4:"user";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}s:18:"\0*\0fieldDefinition";r:326;}s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:5:"title";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"Title";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:12:"translatable";b:1;s:12:"revisionable";b:1;s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:3:{s:5:"label";s:6:"hidden";s:4:"type";s:6:"string";s:6:"weight";i:-5;}}s:4:"form";a:2:{s:7:"options";a:2:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-5;}s:12:"configurable";b:1;}}s:8:"provider";s:4:"node";s:10:"field_name";s:5:"title";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:380;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:7:"created";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Authored on";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:47:"The date and time that the content was created.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:3:{s:5:"label";s:6:"hidden";s:4:"type";s:9:"timestamp";s:6:"weight";i:0;}}s:4:"form";a:2:{s:7:"options";a:2:{s:4:"type";s:18:"datetime_timestamp";s:6:"weight";i:10;}s:12:"configurable";b:1;}}s:8:"provider";s:4:"node";s:10:"field_name";s:7:"created";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:created";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:424;}s:7:"\0*\0type";s:7:"created";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:7:"changed";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Changed";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:39:"The time that the node was last edited.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:8:"provider";s:4:"node";s:10:"field_name";s:7:"changed";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:changed";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:466;}s:7:"\0*\0type";s:7:"changed";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:7:"promote";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:22:"Promoted to front page";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:7:"display";a:1:{s:4:"form";a:2:{s:7:"options";a:3:{s:4:"type";s:16:"boolean_checkbox";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:6:"weight";i:15;}s:12:"configurable";b:1;}}s:8:"provider";s:4:"node";s:10:"field_name";s:7:"promote";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:497;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:6:"sticky";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:22:"Sticky at top of lists";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:0;}}s:7:"display";a:1:{s:4:"form";a:2:{s:7:"options";a:3:{s:4:"type";s:16:"boolean_checkbox";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:6:"weight";i:16;}s:12:"configurable";b:1;}}s:8:"provider";s:4:"node";s:10:"field_name";s:6:"sticky";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:544;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:16:"default_langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:19:"Default translation";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:58:"A flag indicating whether this is the default translation.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:12:"revisionable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:8:"provider";s:4:"node";s:10:"field_name";s:16:"default_langcode";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:591;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:16:"revision_default";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:11:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:16:"Default revision";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:72:"A flag indicating whether this was a default revision when it was saved.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:16:"storage_required";b:1;s:8:"internal";b:1;s:12:"translatable";b:0;s:12:"revisionable";b:1;s:8:"provider";s:4:"node";s:10:"field_name";s:16:"revision_default";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:634;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:29:"revision_translation_affected";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:29:"Revision translation affected";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:72:"Indicates if the last edit of a translation belongs to current revision.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:12:"revisionable";b:1;s:12:"translatable";b:1;s:8:"provider";s:4:"node";s:10:"field_name";s:29:"revision_translation_affected";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:676;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"body";O:38:"Drupal\\field\\Entity\\FieldStorageConfig":30:{s:15:"\0*\0entityTypeId";s:20:"field_storage_config";s:15:"\0*\0enforceIsNew";b:1;s:12:"\0*\0typedData";N;s:16:"\0*\0cacheContexts";a:0:{}s:12:"\0*\0cacheTags";a:0:{}s:14:"\0*\0cacheMaxAge";i:-1;s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:13:"\0*\0originalId";s:9:"node.body";s:9:"\0*\0status";b:1;s:7:"\0*\0uuid";s:36:"ecaac161-1f86-469c-9653-ad36c02c1de4";s:11:"\0*\0langcode";s:2:"en";s:23:"\0*\0third_party_settings";a:0:{}s:8:"\0*\0_core";a:1:{s:19:"default_config_hash";s:43:"EBUo7qOWqaiZaQ_RC9sLY5IoDKphS34v77VIHSACmVY";}s:14:"\0*\0trustedData";b:1;s:15:"\0*\0dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"text";}}s:12:"\0*\0isSyncing";b:0;s:5:"\0*\0id";s:9:"node.body";s:13:"\0*\0field_name";s:4:"body";s:14:"\0*\0entity_type";s:4:"node";s:7:"\0*\0type";s:17:"text_with_summary";s:9:"\0*\0module";s:4:"text";s:11:"\0*\0settings";a:0:{}s:14:"\0*\0cardinality";i:1;s:15:"\0*\0translatable";b:1;s:9:"\0*\0locked";b:0;s:25:"\0*\0persist_with_no_fields";b:1;s:14:"custom_storage";b:0;s:10:"\0*\0indexes";a:0:{}s:10:"\0*\0deleted";b:0;}s:11:"field_image";O:38:"Drupal\\field\\Entity\\FieldStorageConfig":30:{s:15:"\0*\0entityTypeId";s:20:"field_storage_config";s:15:"\0*\0enforceIsNew";b:1;s:12:"\0*\0typedData";N;s:16:"\0*\0cacheContexts";a:0:{}s:12:"\0*\0cacheTags";a:0:{}s:14:"\0*\0cacheMaxAge";i:-1;s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:13:"\0*\0originalId";s:16:"node.field_image";s:9:"\0*\0status";b:1;s:7:"\0*\0uuid";s:36:"700e4126-c5d7-4a9b-8143-78cac4abe782";s:11:"\0*\0langcode";s:2:"en";s:23:"\0*\0third_party_settings";a:0:{}s:8:"\0*\0_core";a:1:{s:19:"default_config_hash";s:43:"EymokncRIZ7SgQT2IdOQhQJicX4nNc0K89ik-LxmOHE";}s:14:"\0*\0trustedData";b:1;s:15:"\0*\0dependencies";a:1:{s:6:"module";a:3:{i:0;s:4:"file";i:1;s:5:"image";i:2;s:4:"node";}}s:12:"\0*\0isSyncing";b:0;s:5:"\0*\0id";s:16:"node.field_image";s:13:"\0*\0field_name";s:11:"field_image";s:14:"\0*\0entity_type";s:4:"node";s:7:"\0*\0type";s:5:"image";s:9:"\0*\0module";s:5:"image";s:11:"\0*\0settings";a:5:{s:11:"target_type";s:4:"file";s:13:"display_field";b:0;s:15:"display_default";b:0;s:10:"uri_scheme";s:6:"public";s:13:"default_image";a:5:{s:4:"uuid";N;s:3:"alt";s:0:"";s:5:"title";s:0:"";s:5:"width";N;s:6:"height";N;}}s:14:"\0*\0cardinality";i:1;s:15:"\0*\0translatable";b:1;s:9:"\0*\0locked";b:0;s:25:"\0*\0persist_with_no_fields";b:0;s:14:"custom_storage";b:0;s:10:"\0*\0indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:10:"\0*\0deleted";b:0;}s:7:"comment";O:38:"Drupal\\field\\Entity\\FieldStorageConfig":30:{s:15:"\0*\0entityTypeId";s:20:"field_storage_config";s:15:"\0*\0enforceIsNew";b:1;s:12:"\0*\0typedData";N;s:16:"\0*\0cacheContexts";a:0:{}s:12:"\0*\0cacheTags";a:0:{}s:14:"\0*\0cacheMaxAge";i:-1;s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:13:"\0*\0originalId";s:12:"node.comment";s:9:"\0*\0status";b:1;s:7:"\0*\0uuid";s:36:"271091f9-10d6-4330-8fe8-c53e6e398f48";s:11:"\0*\0langcode";s:2:"en";s:23:"\0*\0third_party_settings";a:0:{}s:8:"\0*\0_core";a:1:{s:19:"default_config_hash";s:43:"ktCna9xmWvYZIUfOCUyDQvedn5RtnS4CRmEIwNmvYjc";}s:14:"\0*\0trustedData";b:1;s:15:"\0*\0dependencies";a:1:{s:6:"module";a:2:{i:0;s:7:"comment";i:1;s:4:"node";}}s:12:"\0*\0isSyncing";b:0;s:5:"\0*\0id";s:12:"node.comment";s:13:"\0*\0field_name";s:7:"comment";s:14:"\0*\0entity_type";s:4:"node";s:7:"\0*\0type";s:7:"comment";s:9:"\0*\0module";s:7:"comment";s:11:"\0*\0settings";a:1:{s:12:"comment_type";s:7:"comment";}s:14:"\0*\0cardinality";i:1;s:15:"\0*\0translatable";b:1;s:9:"\0*\0locked";b:0;s:25:"\0*\0persist_with_no_fields";b:0;s:14:"custom_storage";b:0;s:10:"\0*\0indexes";a:0:{}s:10:"\0*\0deleted";b:0;}s:10:"field_tags";O:38:"Drupal\\field\\Entity\\FieldStorageConfig":30:{s:15:"\0*\0entityTypeId";s:20:"field_storage_config";s:15:"\0*\0enforceIsNew";b:1;s:12:"\0*\0typedData";N;s:16:"\0*\0cacheContexts";a:0:{}s:12:"\0*\0cacheTags";a:0:{}s:14:"\0*\0cacheMaxAge";i:-1;s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:13:"\0*\0originalId";s:15:"node.field_tags";s:9:"\0*\0status";b:1;s:7:"\0*\0uuid";s:36:"5b68f621-44f9-4e63-9609-e42e7878f9d1";s:11:"\0*\0langcode";s:2:"en";s:23:"\0*\0third_party_settings";a:0:{}s:8:"\0*\0_core";a:1:{s:19:"default_config_hash";s:43:"WpOE_bs8Bs_HY2ns7n2r__de-xno0-Bxkqep5-MsHAs";}s:14:"\0*\0trustedData";b:1;s:15:"\0*\0dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"node";i:1;s:8:"taxonomy";}}s:12:"\0*\0isSyncing";b:0;s:5:"\0*\0id";s:15:"node.field_tags";s:13:"\0*\0field_name";s:10:"field_tags";s:14:"\0*\0entity_type";s:4:"node";s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0module";s:4:"core";s:11:"\0*\0settings";a:1:{s:11:"target_type";s:13:"taxonomy_term";}s:14:"\0*\0cardinality";i:-1;s:15:"\0*\0translatable";b:1;s:9:"\0*\0locked";b:0;s:25:"\0*\0persist_with_no_fields";b:0;s:14:"custom_storage";b:0;s:10:"\0*\0indexes";a:0:{}s:10:"\0*\0deleted";b:0;}}'),
('entity.definitions.installed', 'node_type.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:5:"\0*\0id";s:9:"node_type";s:8:"\0*\0class";s:27:"Drupal\\node\\Entity\\NodeType";s:11:"\0*\0provider";s:4:"node";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:4:"type";s:5:"label";s:4:"name";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:27:"Drupal\\node\\Entity\\NodeType";s:11:"\0*\0handlers";a:5:{s:6:"access";s:40:"Drupal\\node\\NodeTypeAccessControlHandler";s:4:"form";a:3:{s:3:"add";s:24:"Drupal\\node\\NodeTypeForm";s:4:"edit";s:24:"Drupal\\node\\NodeTypeForm";s:6:"delete";s:38:"Drupal\\node\\Form\\NodeTypeDeleteConfirm";}s:14:"route_provider";a:1:{s:11:"permissions";s:49:"Drupal\\user\\Entity\\EntityPermissionsRouteProvider";}s:12:"list_builder";s:31:"Drupal\\node\\NodeTypeListBuilder";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";s:24:"administer content types";s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:4:{s:9:"edit-form";s:41:"/admin/structure/types/manage/{node_type}";s:11:"delete-form";s:48:"/admin/structure/types/manage/{node_type}/delete";s:23:"entity-permissions-form";s:53:"/admin/structure/types/manage/{node_type}/permissions";s:10:"collection";s:22:"/admin/structure/types";}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";s:4:"node";s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Content type";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Content types";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"content type";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"content types";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:19:"@count content type";s:6:"plural";s:20:"@count content types";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:21:"config:node_type_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";s:4:"type";s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:7:{i:0;s:4:"name";i:1;s:4:"type";i:2;s:11:"description";i:3;s:4:"help";i:4;s:12:"new_revision";i:5;s:12:"preview_mode";i:6;s:17:"display_submitted";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'path_alias.entity_type', 'O:36:"Drupal\\Core\\Entity\\ContentEntityType":41:{s:5:"\0*\0id";s:10:"path_alias";s:8:"\0*\0class";s:34:"Drupal\\path_alias\\Entity\\PathAlias";s:11:"\0*\0provider";s:10:"path_alias";s:15:"\0*\0static_cache";b:1;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:8:"revision";s:11:"revision_id";s:8:"langcode";s:8:"langcode";s:4:"uuid";s:4:"uuid";s:9:"published";s:6:"status";s:6:"bundle";s:0:"";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:16:"\0*\0originalClass";s:34:"Drupal\\path_alias\\Entity\\PathAlias";s:11:"\0*\0handlers";a:4:{s:7:"storage";s:34:"Drupal\\path_alias\\PathAliasStorage";s:14:"storage_schema";s:40:"Drupal\\path_alias\\PathAliasStorageSchema";s:6:"access";s:45:"Drupal\\Core\\Entity\\EntityAccessControlHandler";s:12:"view_builder";s:36:"Drupal\\Core\\Entity\\EntityViewBuilder";}s:19:"\0*\0admin_permission";s:22:"administer url aliases";s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";s:10:"path_alias";s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";s:19:"path_alias_revision";s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"URL alias";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"URL aliases";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"URL alias";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"URL aliases";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:16:"@count URL alias";s:6:"plural";s:18:"@count URL aliases";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:7:"content";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Content";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:11:"route_match";}s:14:"\0*\0constraints";a:2:{s:15:"UniquePathAlias";a:0:{}s:26:"EntityUntranslatableFields";N;}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:25:"\0*\0revision_metadata_keys";a:1:{s:16:"revision_default";s:16:"revision_default";}}'),
('entity.definitions.installed', 'path_alias.field_storage_definitions', 'a:8:{s:2:"id";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:8:"provider";s:10:"path_alias";s:10:"field_name";s:2:"id";s:11:"entity_type";s:10:"path_alias";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:"\0*\0fieldDefinition";r:2;}s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"uuid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"UUID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:8:"provider";s:10:"path_alias";s:10:"field_name";s:4:"uuid";s:11:"entity_type";s:10:"path_alias";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:15:"field_item:uuid";s:8:"settings";a:3:{s:10:"max_length";i:128;s:8:"is_ascii";b:1;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:36;}s:7:"\0*\0type";s:4:"uuid";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;}}s:11:"unique keys";a:1:{s:5:"value";a:1:{i:0;s:5:"value";}}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:11:"revision_id";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Revision ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:8:"provider";s:10:"path_alias";s:10:"field_name";s:11:"revision_id";s:11:"entity_type";s:10:"path_alias";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:"\0*\0fieldDefinition";r:69;}s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:8:"langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Language";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:1:{s:6:"region";s:6:"hidden";}}s:4:"form";a:1:{s:7:"options";a:2:{s:4:"type";s:15:"language_select";s:6:"weight";i:2;}}}s:12:"revisionable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";s:3:"und";}}s:8:"provider";s:10:"path_alias";s:10:"field_name";s:8:"langcode";s:11:"entity_type";s:10:"path_alias";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:19:"field_item:language";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:103;}s:7:"\0*\0type";s:8:"language";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"path";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"System path";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:36:"The path that this alias belongs to.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:12:"revisionable";b:1;s:8:"provider";s:10:"path_alias";s:10:"field_name";s:4:"path";s:11:"entity_type";s:10:"path_alias";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:3:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}s:11:"constraints";a:1:{s:11:"ComplexData";a:1:{s:5:"value";a:2:{s:9:"ValidPath";a:0:{}s:5:"Regex";a:2:{s:7:"pattern";s:6:"/^\\//i";s:7:"message";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:42:"The source path has to start with a slash.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}}}}s:18:"\0*\0fieldDefinition";r:141;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:5:"alias";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"URL alias";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:29:"An alias used with this path.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:12:"revisionable";b:1;s:8:"provider";s:10:"path_alias";s:10:"field_name";s:5:"alias";s:11:"entity_type";s:10:"path_alias";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:3:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}s:11:"constraints";a:1:{s:11:"ComplexData";a:1:{s:5:"value";a:1:{s:5:"Regex";a:2:{s:7:"pattern";s:6:"/^\\//i";s:7:"message";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:41:"The alias path has to start with a slash.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}}}}s:18:"\0*\0fieldDefinition";r:187;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:6:"status";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"Published";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:12:"translatable";b:0;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:8:"provider";s:10:"path_alias";s:10:"field_name";s:6:"status";s:11:"entity_type";s:10:"path_alias";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:232;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:16:"revision_default";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:11:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:16:"Default revision";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:72:"A flag indicating whether this was a default revision when it was saved.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:16:"storage_required";b:1;s:8:"internal";b:1;s:12:"translatable";b:0;s:12:"revisionable";b:1;s:8:"provider";s:10:"path_alias";s:10:"field_name";s:16:"revision_default";s:11:"entity_type";s:10:"path_alias";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:271;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}}'),
('entity.definitions.installed', 'search_page.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:5:"\0*\0id";s:11:"search_page";s:8:"\0*\0class";s:31:"Drupal\\search\\Entity\\SearchPage";s:11:"\0*\0provider";s:6:"search";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:10:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:6:"weight";s:6:"weight";s:6:"status";s:6:"status";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:31:"Drupal\\search\\Entity\\SearchPage";s:11:"\0*\0handlers";a:4:{s:6:"access";s:44:"Drupal\\search\\SearchPageAccessControlHandler";s:12:"list_builder";s:35:"Drupal\\search\\SearchPageListBuilder";s:4:"form";a:3:{s:3:"add";s:36:"Drupal\\search\\Form\\SearchPageAddForm";s:4:"edit";s:37:"Drupal\\search\\Form\\SearchPageEditForm";s:6:"delete";s:35:"Drupal\\Core\\Entity\\EntityDeleteForm";}s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";s:17:"administer search";s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:6:{s:9:"edit-form";s:47:"/admin/config/search/pages/manage/{search_page}";s:11:"delete-form";s:54:"/admin/config/search/pages/manage/{search_page}/delete";s:6:"enable";s:54:"/admin/config/search/pages/manage/{search_page}/enable";s:7:"disable";s:55:"/admin/config/search/pages/manage/{search_page}/disable";s:11:"set-default";s:59:"/admin/config/search/pages/manage/{search_page}/set-default";s:10:"collection";s:26:"/admin/config/search/pages";}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Search page";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Search pages";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"search page";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"search pages";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:18:"@count search page";s:6:"plural";s:19:"@count search pages";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:23:"config:search_page_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";s:4:"page";s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:6:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:4:"path";i:3;s:6:"weight";i:4;s:6:"plugin";i:5;s:13:"configuration";}s:21:"\0*\0mergedConfigExport";a:0:{}}');
INSERT INTO `[[dbprefix]]key_value` VALUES
('entity.definitions.installed', 'shortcut.entity_type', 'O:36:"Drupal\\Core\\Entity\\ContentEntityType":41:{s:5:"\0*\0id";s:8:"shortcut";s:8:"\0*\0class";s:31:"Drupal\\shortcut\\Entity\\Shortcut";s:11:"\0*\0provider";s:8:"shortcut";s:15:"\0*\0static_cache";b:1;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:4:"uuid";s:4:"uuid";s:6:"bundle";s:12:"shortcut_set";s:5:"label";s:5:"title";s:8:"langcode";s:8:"langcode";s:8:"revision";s:0:"";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:16:"\0*\0originalClass";s:31:"Drupal\\shortcut\\Entity\\Shortcut";s:11:"\0*\0handlers";a:4:{s:6:"access";s:44:"Drupal\\shortcut\\ShortcutAccessControlHandler";s:4:"form";a:4:{s:7:"default";s:28:"Drupal\\shortcut\\ShortcutForm";s:3:"add";s:28:"Drupal\\shortcut\\ShortcutForm";s:4:"edit";s:28:"Drupal\\shortcut\\ShortcutForm";s:6:"delete";s:39:"Drupal\\shortcut\\Form\\ShortcutDeleteForm";}s:7:"storage";s:46:"Drupal\\Core\\Entity\\Sql\\SqlContentEntityStorage";s:12:"view_builder";s:36:"Drupal\\Core\\Entity\\EntityViewBuilder";}s:19:"\0*\0admin_permission";N;s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:3:{s:9:"canonical";s:53:"/admin/config/user-interface/shortcut/link/{shortcut}";s:11:"delete-form";s:60:"/admin/config/user-interface/shortcut/link/{shortcut}/delete";s:9:"edit-form";s:53:"/admin/config/user-interface/shortcut/link/{shortcut}";}s:21:"\0*\0bundle_entity_type";s:12:"shortcut_set";s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Shortcut set";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"\0*\0base_table";s:8:"shortcut";s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";s:19:"shortcut_field_data";s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:1;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Shortcut link";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:14:"Shortcut links";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"shortcut link";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:14:"shortcut links";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:20:"@count shortcut link";s:6:"plural";s:21:"@count shortcut links";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:7:"content";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Content";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:24:"config:shortcut_set_list";}s:14:"\0*\0constraints";a:1:{s:26:"EntityUntranslatableFields";N;}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:25:"\0*\0revision_metadata_keys";a:1:{s:16:"revision_default";s:16:"revision_default";}}'),
('entity.definitions.installed', 'shortcut.field_storage_definitions', 'a:8:{s:2:"id";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:23:"The ID of the shortcut.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:8:"shortcut";s:10:"field_name";s:2:"id";s:11:"entity_type";s:8:"shortcut";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:"\0*\0fieldDefinition";r:2;}s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"uuid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"UUID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:25:"The UUID of the shortcut.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:8:"shortcut";s:10:"field_name";s:4:"uuid";s:11:"entity_type";s:8:"shortcut";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:15:"field_item:uuid";s:8:"settings";a:3:{s:10:"max_length";i:128;s:8:"is_ascii";b:1;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:40;}s:7:"\0*\0type";s:4:"uuid";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;}}s:11:"unique keys";a:1:{s:5:"value";a:1:{i:0;s:5:"value";}}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:8:"langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Language";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:1:{s:6:"region";s:6:"hidden";}}s:4:"form";a:1:{s:7:"options";a:2:{s:4:"type";s:15:"language_select";s:6:"weight";i:2;}}}s:12:"translatable";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:34:"The language code of the shortcut.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:8:"shortcut";s:10:"field_name";s:8:"langcode";s:11:"entity_type";s:8:"shortcut";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:19:"field_item:language";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:77;}s:7:"\0*\0type";s:8:"language";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:12:"shortcut_set";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Shortcut set";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:27:"The bundle of the shortcut.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:8:"shortcut";s:10:"field_name";s:12:"shortcut_set";s:11:"entity_type";s:8:"shortcut";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:12:"shortcut_set";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}s:18:"\0*\0fieldDefinition";r:116;}s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:5:"title";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"Name";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:25:"The name of the shortcut.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:12:"translatable";b:1;s:7:"display";a:1:{s:4:"form";a:1:{s:7:"options";a:3:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-10;s:8:"settings";a:1:{s:4:"size";i:40;}}}}s:8:"provider";s:8:"shortcut";s:10:"field_name";s:5:"title";s:11:"entity_type";s:8:"shortcut";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:154;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:6:"weight";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:6:"Weight";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:48:"Weight among shortcuts in the same shortcut set.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:8:"shortcut";s:10:"field_name";s:6:"weight";s:11:"entity_type";s:8:"shortcut";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:0;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:"\0*\0fieldDefinition";r:197;}s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:0;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"link";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"Path";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:37:"The location this shortcut points to.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:7:"display";a:1:{s:4:"form";a:2:{s:7:"options";a:2:{s:4:"type";s:12:"link_default";s:6:"weight";i:0;}s:12:"configurable";b:1;}}s:8:"provider";s:8:"shortcut";s:10:"field_name";s:4:"link";s:11:"entity_type";s:8:"shortcut";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:15:"field_item:link";s:8:"settings";a:2:{s:5:"title";i:0;s:9:"link_type";i:1;}}s:18:"\0*\0fieldDefinition";r:234;}s:7:"\0*\0type";s:4:"link";s:9:"\0*\0schema";a:4:{s:7:"columns";a:3:{s:3:"uri";a:3:{s:11:"description";s:20:"The URI of the link.";s:4:"type";s:7:"varchar";s:6:"length";i:2048;}s:5:"title";a:3:{s:11:"description";s:14:"The link text.";s:4:"type";s:7:"varchar";s:6:"length";i:255;}s:7:"options";a:4:{s:11:"description";s:41:"Serialized array of options for the link.";s:4:"type";s:4:"blob";s:4:"size";s:3:"big";s:9:"serialize";b:1;}}s:7:"indexes";a:1:{s:3:"uri";a:1:{i:0;a:2:{i:0;s:3:"uri";i:1;i:30;}}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:16:"default_langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:19:"Default translation";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:58:"A flag indicating whether this is the default translation.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:12:"revisionable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:8:"provider";s:8:"shortcut";s:10:"field_name";s:16:"default_langcode";s:11:"entity_type";s:8:"shortcut";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:287;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}}'),
('entity.definitions.installed', 'shortcut_set.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:5:"\0*\0id";s:12:"shortcut_set";s:8:"\0*\0class";s:34:"Drupal\\shortcut\\Entity\\ShortcutSet";s:11:"\0*\0provider";s:8:"shortcut";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:34:"Drupal\\shortcut\\Entity\\ShortcutSet";s:11:"\0*\0handlers";a:4:{s:7:"storage";s:34:"Drupal\\shortcut\\ShortcutSetStorage";s:6:"access";s:47:"Drupal\\shortcut\\ShortcutSetAccessControlHandler";s:12:"list_builder";s:38:"Drupal\\shortcut\\ShortcutSetListBuilder";s:4:"form";a:5:{s:7:"default";s:31:"Drupal\\shortcut\\ShortcutSetForm";s:3:"add";s:31:"Drupal\\shortcut\\ShortcutSetForm";s:4:"edit";s:31:"Drupal\\shortcut\\ShortcutSetForm";s:9:"customize";s:33:"Drupal\\shortcut\\Form\\SetCustomize";s:6:"delete";s:42:"Drupal\\shortcut\\Form\\ShortcutSetDeleteForm";}}s:19:"\0*\0admin_permission";N;s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:4:{s:14:"customize-form";s:69:"/admin/config/user-interface/shortcut/manage/{shortcut_set}/customize";s:11:"delete-form";s:66:"/admin/config/user-interface/shortcut/manage/{shortcut_set}/delete";s:9:"edit-form";s:59:"/admin/config/user-interface/shortcut/manage/{shortcut_set}";s:10:"collection";s:37:"/admin/config/user-interface/shortcut";}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";s:8:"shortcut";s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Shortcut set";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Shortcut sets";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"shortcut set";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"shortcut sets";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:19:"@count shortcut set";s:6:"plural";s:20:"@count shortcut sets";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:24:"config:shortcut_set_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";s:3:"set";s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:2:{i:0;s:2:"id";i:1;s:5:"label";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'taxonomy_term.entity_type', 'O:36:"Drupal\\Core\\Entity\\ContentEntityType":41:{s:5:"\0*\0id";s:13:"taxonomy_term";s:8:"\0*\0class";s:27:"Drupal\\taxonomy\\Entity\\Term";s:11:"\0*\0provider";s:8:"taxonomy";s:15:"\0*\0static_cache";b:1;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:9:{s:2:"id";s:3:"tid";s:8:"revision";s:11:"revision_id";s:6:"bundle";s:3:"vid";s:5:"label";s:4:"name";s:8:"langcode";s:8:"langcode";s:4:"uuid";s:4:"uuid";s:9:"published";s:6:"status";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:16:"\0*\0originalClass";s:27:"Drupal\\taxonomy\\Entity\\Term";s:11:"\0*\0handlers";a:9:{s:7:"storage";s:27:"Drupal\\taxonomy\\TermStorage";s:14:"storage_schema";s:33:"Drupal\\taxonomy\\TermStorageSchema";s:12:"view_builder";s:36:"Drupal\\Core\\Entity\\EntityViewBuilder";s:12:"list_builder";s:36:"Drupal\\Core\\Entity\\EntityListBuilder";s:6:"access";s:40:"Drupal\\taxonomy\\TermAccessControlHandler";s:10:"views_data";s:29:"Drupal\\taxonomy\\TermViewsData";s:4:"form";a:4:{s:7:"default";s:24:"Drupal\\taxonomy\\TermForm";s:6:"delete";s:35:"Drupal\\taxonomy\\Form\\TermDeleteForm";s:15:"revision-delete";s:42:"Drupal\\Core\\Entity\\Form\\RevisionDeleteForm";s:15:"revision-revert";s:42:"Drupal\\Core\\Entity\\Form\\RevisionRevertForm";}s:14:"route_provider";a:1:{s:8:"revision";s:52:"Drupal\\Core\\Entity\\Routing\\RevisionHtmlRouteProvider";}s:11:"translation";s:38:"Drupal\\taxonomy\\TermTranslationHandler";}s:19:"\0*\0admin_permission";N;s:24:"\0*\0collection_permission";s:24:"access taxonomy overview";s:25:"\0*\0permission_granularity";s:6:"bundle";s:8:"\0*\0links";a:8:{s:9:"canonical";s:30:"/taxonomy/term/{taxonomy_term}";s:11:"delete-form";s:37:"/taxonomy/term/{taxonomy_term}/delete";s:9:"edit-form";s:35:"/taxonomy/term/{taxonomy_term}/edit";s:6:"create";s:14:"/taxonomy/term";s:8:"revision";s:69:"/taxonomy/term/{taxonomy_term}/revision/{taxonomy_term_revision}/view";s:20:"revision-delete-form";s:71:"/taxonomy/term/{taxonomy_term}/revision/{taxonomy_term_revision}/delete";s:20:"revision-revert-form";s:71:"/taxonomy/term/{taxonomy_term}/revision/{taxonomy_term_revision}/revert";s:15:"version-history";s:40:"/taxonomy/term/{taxonomy_term}/revisions";}s:21:"\0*\0bundle_entity_type";s:19:"taxonomy_vocabulary";s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:10:"Vocabulary";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"\0*\0base_table";s:18:"taxonomy_term_data";s:22:"\0*\0revision_data_table";s:28:"taxonomy_term_field_revision";s:17:"\0*\0revision_table";s:22:"taxonomy_term_revision";s:13:"\0*\0data_table";s:24:"taxonomy_term_field_data";s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:1;s:19:"\0*\0show_revision_ui";b:1;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Taxonomy term";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:14:"Taxonomy terms";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"taxonomy term";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:14:"taxonomy terms";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:20:"@count taxonomy term";s:6:"plural";s:21:"@count taxonomy terms";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:7:"content";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Content";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";s:40:"entity.taxonomy_vocabulary.overview_form";s:26:"\0*\0common_reference_target";b:1;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:18:"taxonomy_term_list";}s:14:"\0*\0constraints";a:3:{s:17:"TaxonomyHierarchy";a:0:{}s:13:"EntityChanged";N;s:26:"EntityUntranslatableFields";N;}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:25:"\0*\0revision_metadata_keys";a:4:{s:13:"revision_user";s:13:"revision_user";s:16:"revision_created";s:16:"revision_created";s:20:"revision_log_message";s:20:"revision_log_message";s:16:"revision_default";s:16:"revision_default";}}'),
('entity.definitions.installed', 'taxonomy_term.field_storage_definitions', 'a:17:{s:3:"tid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Term ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"The term ID.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:8:"taxonomy";s:10:"field_name";s:3:"tid";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:"\0*\0fieldDefinition";r:2;}s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"uuid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"UUID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:14:"The term UUID.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:8:"taxonomy";s:10:"field_name";s:4:"uuid";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:15:"field_item:uuid";s:8:"settings";a:3:{s:10:"max_length";i:128;s:8:"is_ascii";b:1;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:40;}s:7:"\0*\0type";s:4:"uuid";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;}}s:11:"unique keys";a:1:{s:5:"value";a:1:{i:0;s:5:"value";}}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:11:"revision_id";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Revision ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:8:"provider";s:8:"taxonomy";s:10:"field_name";s:11:"revision_id";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:"\0*\0fieldDefinition";r:77;}s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:8:"langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Language";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:1:{s:6:"region";s:6:"hidden";}}s:4:"form";a:1:{s:7:"options";a:2:{s:4:"type";s:15:"language_select";s:6:"weight";i:2;}}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:23:"The term language code.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:8:"taxonomy";s:10:"field_name";s:8:"langcode";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:19:"field_item:language";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:111;}s:7:"\0*\0type";s:8:"language";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:3:"vid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:10:"Vocabulary";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:45:"The vocabulary to which the term is assigned.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:8:"taxonomy";s:10:"field_name";s:3:"vid";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:19:"taxonomy_vocabulary";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}s:18:"\0*\0fieldDefinition";r:151;}s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:16:"revision_created";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:20:"Revision create time";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:47:"The time that the current revision was created.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:8:"provider";s:8:"taxonomy";s:10:"field_name";s:16:"revision_created";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:created";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:189;}s:7:"\0*\0type";s:7:"created";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:13:"revision_user";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Revision user";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:50:"The user ID of the author of the current revision.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:8:"provider";s:8:"taxonomy";s:10:"field_name";s:13:"revision_user";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:4:"user";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}s:18:"\0*\0fieldDefinition";r:219;}s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:20:"revision_log_message";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:20:"Revision log message";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:43:"Briefly describe the changes you have made.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";s:0:"";}}s:7:"display";a:1:{s:4:"form";a:1:{s:7:"options";a:3:{s:4:"type";s:15:"string_textarea";s:6:"weight";i:25;s:8:"settings";a:1:{s:4:"rows";i:4;}}}}s:8:"provider";s:8:"taxonomy";s:10:"field_name";s:20:"revision_log_message";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:22:"field_item:string_long";s:8:"settings";a:1:{s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:256;}s:7:"\0*\0type";s:11:"string_long";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:6:"status";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"Published";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:7:"display";a:1:{s:4:"form";a:2:{s:7:"options";a:3:{s:4:"type";s:16:"boolean_checkbox";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:6:"weight";i:100;}s:12:"configurable";b:1;}}s:8:"provider";s:8:"taxonomy";s:10:"field_name";s:6:"status";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:3:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}s:5:"class";s:22:"Drupal\\user\\StatusItem";}s:18:"\0*\0fieldDefinition";r:298;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"name";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"Name";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:12:"revisionable";b:1;s:8:"required";b:1;s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:3:{s:5:"label";s:6:"hidden";s:4:"type";s:6:"string";s:6:"weight";i:-5;}}s:4:"form";a:2:{s:7:"options";a:2:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-5;}s:12:"configurable";b:1;}}s:8:"provider";s:8:"taxonomy";s:10:"field_name";s:4:"name";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:346;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:11:"description";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Description";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:12:"revisionable";b:1;s:7:"display";a:2:{s:4:"view";a:2:{s:7:"options";a:3:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:6:"weight";i:0;}s:12:"configurable";b:1;}s:4:"form";a:2:{s:7:"options";a:2:{s:4:"type";s:14:"text_textfield";s:6:"weight";i:0;}s:12:"configurable";b:1;}}s:8:"provider";s:8:"taxonomy";s:10:"field_name";s:11:"description";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:20:"field_item:text_long";s:8:"settings";a:1:{s:15:"allowed_formats";a:0:{}}}s:18:"\0*\0fieldDefinition";r:390;}s:7:"\0*\0type";s:9:"text_long";s:9:"\0*\0schema";a:4:{s:7:"columns";a:2:{s:5:"value";a:2:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";}s:6:"format";a:2:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:255;}}s:7:"indexes";a:1:{s:6:"format";a:1:{i:0;s:6:"format";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:6:"weight";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:6:"Weight";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:51:"The weight of this term in relation to other terms.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";i:0;}}s:8:"provider";s:8:"taxonomy";s:10:"field_name";s:6:"weight";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:0;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:"\0*\0fieldDefinition";r:436;}s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:0;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:6:"parent";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Term Parents";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:25:"The parents of this term.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"cardinality";i:-1;s:8:"provider";s:8:"taxonomy";s:10:"field_name";s:6:"parent";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:13:"taxonomy_term";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}s:18:"\0*\0fieldDefinition";r:476;}s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:7:"changed";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Changed";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:39:"The time that the term was last edited.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:12:"revisionable";b:1;s:8:"provider";s:8:"taxonomy";s:10:"field_name";s:7:"changed";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:changed";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:512;}s:7:"\0*\0type";s:7:"changed";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:16:"default_langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:19:"Default translation";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:58:"A flag indicating whether this is the default translation.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:12:"revisionable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:8:"provider";s:8:"taxonomy";s:10:"field_name";s:16:"default_langcode";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:543;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:16:"revision_default";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:11:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:16:"Default revision";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:72:"A flag indicating whether this was a default revision when it was saved.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:16:"storage_required";b:1;s:8:"internal";b:1;s:12:"translatable";b:0;s:12:"revisionable";b:1;s:8:"provider";s:8:"taxonomy";s:10:"field_name";s:16:"revision_default";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:586;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:29:"revision_translation_affected";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:29:"Revision translation affected";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:72:"Indicates if the last edit of a translation belongs to current revision.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:12:"revisionable";b:1;s:12:"translatable";b:1;s:8:"provider";s:8:"taxonomy";s:10:"field_name";s:29:"revision_translation_affected";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:628;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}}'),
('entity.definitions.installed', 'taxonomy_vocabulary.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:5:"\0*\0id";s:19:"taxonomy_vocabulary";s:8:"\0*\0class";s:33:"Drupal\\taxonomy\\Entity\\Vocabulary";s:11:"\0*\0provider";s:8:"taxonomy";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:9:{s:2:"id";s:3:"vid";s:5:"label";s:4:"name";s:6:"weight";s:6:"weight";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:33:"Drupal\\taxonomy\\Entity\\Vocabulary";s:11:"\0*\0handlers";a:5:{s:7:"storage";s:33:"Drupal\\taxonomy\\VocabularyStorage";s:12:"list_builder";s:37:"Drupal\\taxonomy\\VocabularyListBuilder";s:6:"access";s:46:"Drupal\\taxonomy\\VocabularyAccessControlHandler";s:4:"form";a:4:{s:7:"default";s:30:"Drupal\\taxonomy\\VocabularyForm";s:5:"reset";s:40:"Drupal\\taxonomy\\Form\\VocabularyResetForm";s:6:"delete";s:41:"Drupal\\taxonomy\\Form\\VocabularyDeleteForm";s:8:"overview";s:34:"Drupal\\taxonomy\\Form\\OverviewTerms";}s:14:"route_provider";a:2:{s:4:"html";s:54:"Drupal\\taxonomy\\Entity\\Routing\\VocabularyRouteProvider";s:11:"permissions";s:49:"Drupal\\user\\Entity\\EntityPermissionsRouteProvider";}}s:19:"\0*\0admin_permission";s:19:"administer taxonomy";s:24:"\0*\0collection_permission";s:24:"access taxonomy overview";s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:7:{s:8:"add-form";s:29:"/admin/structure/taxonomy/add";s:11:"delete-form";s:61:"/admin/structure/taxonomy/manage/{taxonomy_vocabulary}/delete";s:10:"reset-form";s:60:"/admin/structure/taxonomy/manage/{taxonomy_vocabulary}/reset";s:13:"overview-form";s:63:"/admin/structure/taxonomy/manage/{taxonomy_vocabulary}/overview";s:9:"edit-form";s:54:"/admin/structure/taxonomy/manage/{taxonomy_vocabulary}";s:23:"entity-permissions-form";s:75:"/admin/structure/taxonomy/manage/{taxonomy_vocabulary}/overview/permissions";s:10:"collection";s:25:"/admin/structure/taxonomy";}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";s:13:"taxonomy_term";s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:19:"Taxonomy vocabulary";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Taxonomy";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:10:"vocabulary";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"vocabularies";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:17:"@count vocabulary";s:6:"plural";s:19:"@count vocabularies";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:31:"config:taxonomy_vocabulary_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";s:10:"vocabulary";s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:5:{i:0;s:4:"name";i:1;s:3:"vid";i:2;s:11:"description";i:3;s:6:"weight";i:4;s:12:"new_revision";}s:21:"\0*\0mergedConfigExport";a:0:{}}');
INSERT INTO `[[dbprefix]]key_value` VALUES
('entity.definitions.installed', 'user.entity_type', 'O:36:"Drupal\\Core\\Entity\\ContentEntityType":41:{s:5:"\0*\0id";s:4:"user";s:8:"\0*\0class";s:23:"Drupal\\user\\Entity\\User";s:11:"\0*\0provider";s:4:"user";s:15:"\0*\0static_cache";b:1;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:7:{s:2:"id";s:3:"uid";s:8:"langcode";s:8:"langcode";s:4:"uuid";s:4:"uuid";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:16:"\0*\0originalClass";s:23:"Drupal\\user\\Entity\\User";s:11:"\0*\0handlers";a:9:{s:7:"storage";s:23:"Drupal\\user\\UserStorage";s:14:"storage_schema";s:29:"Drupal\\user\\UserStorageSchema";s:6:"access";s:36:"Drupal\\user\\UserAccessControlHandler";s:12:"list_builder";s:27:"Drupal\\user\\UserListBuilder";s:10:"views_data";s:25:"Drupal\\user\\UserViewsData";s:14:"route_provider";a:1:{s:4:"html";s:36:"Drupal\\user\\Entity\\UserRouteProvider";}s:4:"form";a:3:{s:7:"default";s:23:"Drupal\\user\\ProfileForm";s:6:"cancel";s:31:"Drupal\\user\\Form\\UserCancelForm";s:8:"register";s:24:"Drupal\\user\\RegisterForm";}s:11:"translation";s:37:"Drupal\\user\\ProfileTranslationHandler";s:12:"view_builder";s:36:"Drupal\\Core\\Entity\\EntityViewBuilder";}s:19:"\0*\0admin_permission";s:16:"administer users";s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:4:{s:9:"canonical";s:12:"/user/{user}";s:9:"edit-form";s:17:"/user/{user}/edit";s:11:"cancel-form";s:19:"/user/{user}/cancel";s:10:"collection";s:13:"/admin/people";}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";s:5:"users";s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";s:16:"users_field_data";s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:1;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"User";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"Users";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"user";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"users";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:11:"@count user";s:6:"plural";s:12:"@count users";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:7:"content";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Content";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";s:22:"entity.user.admin_form";s:26:"\0*\0common_reference_target";b:1;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:9:"user_list";}s:14:"\0*\0constraints";a:2:{s:13:"EntityChanged";N;s:26:"EntityUntranslatableFields";N;}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:25:"\0*\0revision_metadata_keys";a:1:{s:16:"revision_default";s:16:"revision_default";}}'),
('entity.definitions.installed', 'user.field_storage_definitions', 'a:18:{s:3:"uid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"User ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"The user ID.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"user";s:10:"field_name";s:3:"uid";s:11:"entity_type";s:4:"user";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:"\0*\0fieldDefinition";r:2;}s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"uuid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"UUID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:14:"The user UUID.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"user";s:10:"field_name";s:4:"uuid";s:11:"entity_type";s:4:"user";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:15:"field_item:uuid";s:8:"settings";a:3:{s:10:"max_length";i:128;s:8:"is_ascii";b:1;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:40;}s:7:"\0*\0type";s:4:"uuid";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;}}s:11:"unique keys";a:1:{s:5:"value";a:1:{i:0;s:5:"value";}}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:8:"langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Language code";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:1:{s:6:"region";s:6:"hidden";}}s:4:"form";a:1:{s:7:"options";a:1:{s:6:"region";s:6:"hidden";}}}s:12:"translatable";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:23:"The user language code.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"user";s:10:"field_name";s:8:"langcode";s:11:"entity_type";s:4:"user";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:19:"field_item:language";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:77;}s:7:"\0*\0type";s:8:"language";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:18:"preferred_langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:23:"Preferred language code";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:77:"The user''s preferred language code for receiving emails and viewing the site.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"user";s:10:"field_name";s:18:"preferred_langcode";s:11:"entity_type";s:4:"user";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:3:{s:4:"type";s:19:"field_item:language";s:8:"settings";a:0:{}s:11:"constraints";a:1:{s:11:"ComplexData";a:1:{s:5:"value";a:2:{s:13:"AllowedValues";a:1:{s:8:"callback";s:60:"Drupal\\user\\Entity\\User::getAllowedConfigurableLanguageCodes";}s:6:"Length";a:1:{s:3:"max";i:12;}}}}}s:18:"\0*\0fieldDefinition";r:115;}s:7:"\0*\0type";s:8:"language";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:24:"preferred_admin_langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:29:"Preferred admin language code";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:68:"The user''s preferred language code for viewing administration pages.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";N;}}s:8:"provider";s:4:"user";s:10:"field_name";s:24:"preferred_admin_langcode";s:11:"entity_type";s:4:"user";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:3:{s:4:"type";s:19:"field_item:language";s:8:"settings";a:0:{}s:11:"constraints";a:1:{s:11:"ComplexData";a:1:{s:5:"value";a:2:{s:13:"AllowedValues";a:1:{s:8:"callback";s:60:"Drupal\\user\\Entity\\User::getAllowedConfigurableLanguageCodes";}s:6:"Length";a:1:{s:3:"max";i:12;}}}}}s:18:"\0*\0fieldDefinition";r:152;}s:7:"\0*\0type";s:8:"language";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"name";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"Name";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:22:"The name of this user.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:11:"constraints";a:2:{s:8:"UserName";a:0:{}s:14:"UserNameUnique";a:0:{}}s:8:"provider";s:4:"user";s:10:"field_name";s:4:"name";s:11:"entity_type";s:4:"user";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:3:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}s:5:"class";s:25:"\\Drupal\\user\\UserNameItem";}s:18:"\0*\0fieldDefinition";r:192;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"pass";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Password";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:35:"The password of this user (hashed).";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"constraints";a:1:{s:18:"ProtectedUserField";N;}s:8:"provider";s:4:"user";s:10:"field_name";s:4:"pass";s:11:"entity_type";s:4:"user";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:19:"field_item:password";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:231;}s:7:"\0*\0type";s:8:"password";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"mail";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"Email";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:23:"The email of this user.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";s:0:"";}}s:11:"constraints";a:3:{s:14:"UserMailUnique";N;s:16:"UserMailRequired";N;s:18:"ProtectedUserField";N;}s:8:"provider";s:4:"user";s:10:"field_name";s:4:"mail";s:11:"entity_type";s:4:"user";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:16:"field_item:email";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:267;}s:7:"\0*\0type";s:5:"email";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:7:"varchar";s:6:"length";i:254;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:8:"timezone";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Timezone";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:26:"The timezone of this user.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"user";s:10:"field_name";s:8:"timezone";s:11:"entity_type";s:4:"user";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:4:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:32;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}s:11:"constraints";a:1:{s:11:"ComplexData";a:1:{s:5:"value";a:1:{s:13:"AllowedValues";a:1:{s:8:"callback";s:44:"Drupal\\user\\Entity\\User::getAllowedTimezones";}}}}s:5:"class";s:24:"Drupal\\user\\TimeZoneItem";}s:18:"\0*\0fieldDefinition";r:304;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:32;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:6:"status";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"User status";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:38:"Whether the user is active or blocked.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:0;}}s:8:"provider";s:4:"user";s:10:"field_name";s:6:"status";s:11:"entity_type";s:4:"user";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:3:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}s:5:"class";s:22:"Drupal\\user\\StatusItem";}s:18:"\0*\0fieldDefinition";r:344;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:7:"created";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Created";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:35:"The time that the user was created.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"user";s:10:"field_name";s:7:"created";s:11:"entity_type";s:4:"user";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:created";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:386;}s:7:"\0*\0type";s:7:"created";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:7:"changed";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Changed";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:39:"The time that the user was last edited.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:8:"provider";s:4:"user";s:10:"field_name";s:7:"changed";s:11:"entity_type";s:4:"user";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:changed";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:415;}s:7:"\0*\0type";s:7:"changed";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:6:"access";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Last access";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:46:"The time that the user last accessed the site.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";i:0;}}s:8:"provider";s:4:"user";s:10:"field_name";s:6:"access";s:11:"entity_type";s:4:"user";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:20:"field_item:timestamp";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:445;}s:7:"\0*\0type";s:9:"timestamp";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:5:"login";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:10:"Last login";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:38:"The time that the user last logged in.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";i:0;}}s:8:"provider";s:4:"user";s:10:"field_name";s:5:"login";s:11:"entity_type";s:4:"user";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:20:"field_item:timestamp";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:477;}s:7:"\0*\0type";s:9:"timestamp";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"init";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Initial email";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:52:"The email address used for initial account creation.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";s:0:"";}}s:8:"provider";s:4:"user";s:10:"field_name";s:4:"init";s:11:"entity_type";s:4:"user";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:16:"field_item:email";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:509;}s:7:"\0*\0type";s:5:"email";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:7:"varchar";s:6:"length";i:254;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:5:"roles";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"Roles";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"cardinality";i:-1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:23:"The roles the user has.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"user";s:10:"field_name";s:5:"roles";s:11:"entity_type";s:4:"user";s:6:"bundle";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:9:"user_role";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}s:18:"\0*\0fieldDefinition";r:542;}s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:255;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:16:"default_langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:19:"Default translation";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:58:"A flag indicating whether this is the default translation.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:12:"revisionable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:8:"provider";s:4:"user";s:10:"field_name";s:16:"default_langcode";s:11:"entity_type";s:4:"user";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:578;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:12:"user_picture";O:38:"Drupal\\field\\Entity\\FieldStorageConfig":30:{s:15:"\0*\0entityTypeId";s:20:"field_storage_config";s:15:"\0*\0enforceIsNew";b:1;s:12:"\0*\0typedData";N;s:16:"\0*\0cacheContexts";a:0:{}s:12:"\0*\0cacheTags";a:0:{}s:14:"\0*\0cacheMaxAge";i:-1;s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:13:"\0*\0originalId";s:17:"user.user_picture";s:9:"\0*\0status";b:1;s:7:"\0*\0uuid";s:36:"97840e9f-94a5-4a72-8a9a-62c48abe9fd6";s:11:"\0*\0langcode";s:2:"en";s:23:"\0*\0third_party_settings";a:0:{}s:8:"\0*\0_core";a:1:{s:19:"default_config_hash";s:43:"0q8-mw8y-Ls5I578sIPQFLp4ljpH7WvVYpzY-I9O-8E";}s:14:"\0*\0trustedData";b:1;s:15:"\0*\0dependencies";a:1:{s:6:"module";a:3:{i:0;s:4:"file";i:1;s:5:"image";i:2;s:4:"user";}}s:12:"\0*\0isSyncing";b:0;s:5:"\0*\0id";s:17:"user.user_picture";s:13:"\0*\0field_name";s:12:"user_picture";s:14:"\0*\0entity_type";s:4:"user";s:7:"\0*\0type";s:5:"image";s:9:"\0*\0module";s:5:"image";s:11:"\0*\0settings";a:5:{s:11:"target_type";s:4:"file";s:13:"display_field";b:0;s:15:"display_default";b:0;s:10:"uri_scheme";s:6:"public";s:13:"default_image";a:5:{s:4:"uuid";N;s:3:"alt";s:0:"";s:5:"title";s:0:"";s:5:"width";N;s:6:"height";N;}}s:14:"\0*\0cardinality";i:1;s:15:"\0*\0translatable";b:1;s:9:"\0*\0locked";b:0;s:25:"\0*\0persist_with_no_fields";b:0;s:14:"custom_storage";b:0;s:10:"\0*\0indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:10:"\0*\0deleted";b:0;}}'),
('entity.definitions.installed', 'user_role.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:5:"\0*\0id";s:9:"user_role";s:8:"\0*\0class";s:23:"Drupal\\user\\Entity\\Role";s:11:"\0*\0provider";s:4:"user";s:15:"\0*\0static_cache";b:1;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:9:{s:2:"id";s:2:"id";s:6:"weight";s:6:"weight";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:23:"Drupal\\user\\Entity\\Role";s:11:"\0*\0handlers";a:4:{s:7:"storage";s:23:"Drupal\\user\\RoleStorage";s:6:"access";s:36:"Drupal\\user\\RoleAccessControlHandler";s:12:"list_builder";s:27:"Drupal\\user\\RoleListBuilder";s:4:"form";a:2:{s:7:"default";s:20:"Drupal\\user\\RoleForm";s:6:"delete";s:35:"Drupal\\Core\\Entity\\EntityDeleteForm";}}s:19:"\0*\0admin_permission";s:22:"administer permissions";s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:4:{s:11:"delete-form";s:45:"/admin/people/roles/manage/{user_role}/delete";s:9:"edit-form";s:38:"/admin/people/roles/manage/{user_role}";s:21:"edit-permissions-form";s:37:"/admin/people/permissions/{user_role}";s:10:"collection";s:19:"/admin/people/roles";}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"Role";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"Roles";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"role";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"roles";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:11:"@count role";s:6:"plural";s:12:"@count roles";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:21:"config:user_role_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";s:4:"role";s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:5:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:6:"weight";i:3;s:8:"is_admin";i:4;s:11:"permissions";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'view.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:5:"\0*\0id";s:4:"view";s:8:"\0*\0class";s:24:"Drupal\\views\\Entity\\View";s:11:"\0*\0provider";s:5:"views";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:9:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:6:"status";s:6:"status";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:24:"Drupal\\views\\Entity\\View";s:11:"\0*\0handlers";a:2:{s:6:"access";s:45:"Drupal\\Core\\Entity\\EntityAccessControlHandler";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";s:16:"administer views";s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"View";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:16:"View entity type";}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"Views";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:16:"View entity type";}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"view";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:16:"View entity type";}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"views";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:16:"View entity type";}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:11:"@count view";s:6:"plural";s:12:"@count views";s:7:"context";s:16:"View entity type";}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:16:"config:view_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";N;s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:8:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:6:"module";i:3;s:11:"description";i:4;s:3:"tag";i:5;s:10:"base_table";i:6;s:10:"base_field";i:7;s:7:"display";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.storage_schema.sql', 'block_content.entity_schema_data', 'a:4:{s:13:"block_content";a:2:{s:11:"primary key";a:1:{i:0;s:2:"id";}s:11:"unique keys";a:1:{s:26:"block_content__revision_id";a:1:{i:0;s:11:"revision_id";}}}s:22:"block_content_revision";a:2:{s:11:"primary key";a:1:{i:0;s:11:"revision_id";}s:7:"indexes";a:1:{s:17:"block_content__id";a:1:{i:0;s:2:"id";}}}s:24:"block_content_field_data";a:2:{s:11:"primary key";a:2:{i:0;s:2:"id";i:1;s:8:"langcode";}s:7:"indexes";a:3:{s:45:"block_content__id__default_langcode__langcode";a:3:{i:0;s:2:"id";i:1;s:16:"default_langcode";i:2;s:8:"langcode";}s:26:"block_content__revision_id";a:1:{i:0;s:11:"revision_id";}s:26:"block_content__status_type";a:3:{i:0;s:6:"status";i:1;s:4:"type";i:2;s:2:"id";}}}s:28:"block_content_field_revision";a:2:{s:11:"primary key";a:2:{i:0;s:11:"revision_id";i:1;s:8:"langcode";}s:7:"indexes";a:1:{s:45:"block_content__id__default_langcode__langcode";a:3:{i:0;s:2:"id";i:1;s:16:"default_langcode";i:2;s:8:"langcode";}}}}'),
('entity.storage_schema.sql', 'block_content.field_schema_data.body', 'a:2:{s:19:"block_content__body";a:4:{s:11:"description";s:42:"Data storage for block_content field body.";s:6:"fields";a:9:{s:6:"bundle";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:88:"The field instance bundle to which this row belongs, used when deleting a field instance";}s:7:"deleted";a:5:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:60:"A boolean indicating whether this data item has been deleted";}s:9:"entity_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:38:"The entity id this data is attached to";}s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:47:"The entity revision id this data is attached to";}s:8:"langcode";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:37:"The language code for this data item.";}s:5:"delta";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:67:"The sequence number for this data item, used for multi-value fields";}s:10:"body_value";a:3:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:1;}s:12:"body_summary";a:3:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:0;}s:11:"body_format";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:255;s:8:"not null";b:0;}}s:11:"primary key";a:4:{i:0;s:9:"entity_id";i:1;s:7:"deleted";i:2;s:5:"delta";i:3;s:8:"langcode";}s:7:"indexes";a:3:{s:6:"bundle";a:1:{i:0;s:6:"bundle";}s:11:"revision_id";a:1:{i:0;s:11:"revision_id";}s:11:"body_format";a:1:{i:0;s:11:"body_format";}}}s:28:"block_content_revision__body";a:4:{s:11:"description";s:54:"Revision archive storage for block_content field body.";s:6:"fields";a:9:{s:6:"bundle";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:88:"The field instance bundle to which this row belongs, used when deleting a field instance";}s:7:"deleted";a:5:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:60:"A boolean indicating whether this data item has been deleted";}s:9:"entity_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:38:"The entity id this data is attached to";}s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:47:"The entity revision id this data is attached to";}s:8:"langcode";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:37:"The language code for this data item.";}s:5:"delta";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:67:"The sequence number for this data item, used for multi-value fields";}s:10:"body_value";a:3:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:1;}s:12:"body_summary";a:3:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:0;}s:11:"body_format";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:255;s:8:"not null";b:0;}}s:11:"primary key";a:5:{i:0;s:9:"entity_id";i:1;s:11:"revision_id";i:2;s:7:"deleted";i:3;s:5:"delta";i:4;s:8:"langcode";}s:7:"indexes";a:3:{s:6:"bundle";a:1:{i:0;s:6:"bundle";}s:11:"revision_id";a:1:{i:0;s:11:"revision_id";}s:11:"body_format";a:1:{i:0;s:11:"body_format";}}}}'),
('entity.storage_schema.sql', 'block_content.field_schema_data.changed', 'a:2:{s:24:"block_content_field_data";a:1:{s:6:"fields";a:1:{s:7:"changed";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}s:28:"block_content_field_revision";a:1:{s:6:"fields";a:1:{s:7:"changed";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'block_content.field_schema_data.default_langcode', 'a:2:{s:24:"block_content_field_data";a:1:{s:6:"fields";a:1:{s:16:"default_langcode";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}s:28:"block_content_field_revision";a:1:{s:6:"fields";a:1:{s:16:"default_langcode";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'block_content.field_schema_data.id', 'a:4:{s:13:"block_content";a:1:{s:6:"fields";a:1:{s:2:"id";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:24:"block_content_field_data";a:1:{s:6:"fields";a:1:{s:2:"id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:22:"block_content_revision";a:1:{s:6:"fields";a:1:{s:2:"id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:28:"block_content_field_revision";a:1:{s:6:"fields";a:1:{s:2:"id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'block_content.field_schema_data.info', 'a:2:{s:24:"block_content_field_data";a:1:{s:6:"fields";a:1:{s:4:"info";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}s:28:"block_content_field_revision";a:1:{s:6:"fields";a:1:{s:4:"info";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'block_content.field_schema_data.langcode', 'a:4:{s:13:"block_content";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}s:24:"block_content_field_data";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}s:22:"block_content_revision";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}s:28:"block_content_field_revision";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'block_content.field_schema_data.reusable', 'a:1:{s:24:"block_content_field_data";a:2:{s:6:"fields";a:1:{s:8:"reusable";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}s:7:"indexes";a:1:{s:29:"block_content_field__reusable";a:1:{i:0;s:8:"reusable";}}}}'),
('entity.storage_schema.sql', 'block_content.field_schema_data.revision_created', 'a:1:{s:22:"block_content_revision";a:1:{s:6:"fields";a:1:{s:16:"revision_created";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'block_content.field_schema_data.revision_default', 'a:1:{s:22:"block_content_revision";a:1:{s:6:"fields";a:1:{s:16:"revision_default";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'block_content.field_schema_data.revision_id', 'a:4:{s:13:"block_content";a:1:{s:6:"fields";a:1:{s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:0;}}}s:24:"block_content_field_data";a:1:{s:6:"fields";a:1:{s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:22:"block_content_revision";a:1:{s:6:"fields";a:1:{s:11:"revision_id";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:28:"block_content_field_revision";a:1:{s:6:"fields";a:1:{s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'block_content.field_schema_data.revision_log', 'a:1:{s:22:"block_content_revision";a:1:{s:6:"fields";a:1:{s:12:"revision_log";a:3:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'block_content.field_schema_data.revision_translation_affected', 'a:2:{s:24:"block_content_field_data";a:1:{s:6:"fields";a:1:{s:29:"revision_translation_affected";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}s:28:"block_content_field_revision";a:1:{s:6:"fields";a:1:{s:29:"revision_translation_affected";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'block_content.field_schema_data.revision_user', 'a:1:{s:22:"block_content_revision";a:2:{s:6:"fields";a:1:{s:13:"revision_user";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;}}s:7:"indexes";a:1:{s:45:"block_content_field__revision_user__target_id";a:1:{i:0;s:13:"revision_user";}}}}'),
('entity.storage_schema.sql', 'block_content.field_schema_data.status', 'a:2:{s:24:"block_content_field_data";a:1:{s:6:"fields";a:1:{s:6:"status";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}s:28:"block_content_field_revision";a:1:{s:6:"fields";a:1:{s:6:"status";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'block_content.field_schema_data.type', 'a:2:{s:13:"block_content";a:2:{s:6:"fields";a:1:{s:4:"type";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:36:"block_content_field__type__target_id";a:1:{i:0;s:4:"type";}}}s:24:"block_content_field_data";a:2:{s:6:"fields";a:1:{s:4:"type";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:36:"block_content_field__type__target_id";a:1:{i:0;s:4:"type";}}}}'),
('entity.storage_schema.sql', 'block_content.field_schema_data.uuid', 'a:1:{s:13:"block_content";a:2:{s:6:"fields";a:1:{s:4:"uuid";a:4:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;s:8:"not null";b:1;}}s:11:"unique keys";a:1:{s:32:"block_content_field__uuid__value";a:1:{i:0;s:4:"uuid";}}}}'),
('entity.storage_schema.sql', 'comment.entity_schema_data', 'a:2:{s:7:"comment";a:1:{s:11:"primary key";a:1:{i:0;s:3:"cid";}}s:18:"comment_field_data";a:2:{s:11:"primary key";a:2:{i:0;s:3:"cid";i:1;s:8:"langcode";}s:7:"indexes";a:5:{s:39:"comment__id__default_langcode__langcode";a:3:{i:0;s:3:"cid";i:1;s:16:"default_langcode";i:2;s:8:"langcode";}s:28:"comment__status_comment_type";a:3:{i:0;s:6:"status";i:1;s:12:"comment_type";i:2;s:3:"cid";}s:19:"comment__status_pid";a:2:{i:0;s:3:"pid";i:1;s:6:"status";}s:16:"comment__num_new";a:7:{i:0;s:9:"entity_id";i:1;s:11:"entity_type";i:2;s:12:"comment_type";i:3;s:6:"status";i:4;s:7:"created";i:5;s:3:"cid";i:6;s:6:"thread";}s:24:"comment__entity_langcode";a:4:{i:0;s:9:"entity_id";i:1;s:11:"entity_type";i:2;s:12:"comment_type";i:3;s:16:"default_langcode";}}}}'),
('entity.storage_schema.sql', 'comment.field_schema_data.changed', 'a:1:{s:18:"comment_field_data";a:1:{s:6:"fields";a:1:{s:7:"changed";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'comment.field_schema_data.cid', 'a:2:{s:7:"comment";a:1:{s:6:"fields";a:1:{s:3:"cid";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:18:"comment_field_data";a:1:{s:6:"fields";a:1:{s:3:"cid";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'comment.field_schema_data.comment_body', 'a:1:{s:21:"comment__comment_body";a:4:{s:11:"description";s:44:"Data storage for comment field comment_body.";s:6:"fields";a:8:{s:6:"bundle";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:88:"The field instance bundle to which this row belongs, used when deleting a field instance";}s:7:"deleted";a:5:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:60:"A boolean indicating whether this data item has been deleted";}s:9:"entity_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:38:"The entity id this data is attached to";}s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:114:"The entity revision id this data is attached to, which for an unversioned entity type is the same as the entity id";}s:8:"langcode";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:37:"The language code for this data item.";}s:5:"delta";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:67:"The sequence number for this data item, used for multi-value fields";}s:18:"comment_body_value";a:3:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:1;}s:19:"comment_body_format";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:255;s:8:"not null";b:0;}}s:11:"primary key";a:4:{i:0;s:9:"entity_id";i:1;s:7:"deleted";i:2;s:5:"delta";i:3;s:8:"langcode";}s:7:"indexes";a:3:{s:6:"bundle";a:1:{i:0;s:6:"bundle";}s:11:"revision_id";a:1:{i:0;s:11:"revision_id";}s:19:"comment_body_format";a:1:{i:0;s:19:"comment_body_format";}}}}'),
('entity.storage_schema.sql', 'comment.field_schema_data.comment_type', 'a:2:{s:7:"comment";a:2:{s:6:"fields";a:1:{s:12:"comment_type";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:38:"comment_field__comment_type__target_id";a:1:{i:0;s:12:"comment_type";}}}s:18:"comment_field_data";a:2:{s:6:"fields";a:1:{s:12:"comment_type";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:38:"comment_field__comment_type__target_id";a:1:{i:0;s:12:"comment_type";}}}}'),
('entity.storage_schema.sql', 'comment.field_schema_data.created', 'a:1:{s:18:"comment_field_data";a:2:{s:6:"fields";a:1:{s:7:"created";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:22:"comment_field__created";a:1:{i:0;s:7:"created";}}}}'),
('entity.storage_schema.sql', 'comment.field_schema_data.default_langcode', 'a:1:{s:18:"comment_field_data";a:1:{s:6:"fields";a:1:{s:16:"default_langcode";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'comment.field_schema_data.entity_id', 'a:1:{s:18:"comment_field_data";a:2:{s:6:"fields";a:1:{s:9:"entity_id";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;}}s:7:"indexes";a:0:{}}}'),
('entity.storage_schema.sql', 'comment.field_schema_data.entity_type', 'a:1:{s:18:"comment_field_data";a:1:{s:6:"fields";a:1:{s:11:"entity_type";a:4:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:6:"binary";b:0;s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'comment.field_schema_data.field_name', 'a:1:{s:18:"comment_field_data";a:1:{s:6:"fields";a:1:{s:10:"field_name";a:4:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:6:"binary";b:0;s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'comment.field_schema_data.homepage', 'a:1:{s:18:"comment_field_data";a:1:{s:6:"fields";a:1:{s:8:"homepage";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'comment.field_schema_data.hostname', 'a:1:{s:18:"comment_field_data";a:1:{s:6:"fields";a:1:{s:8:"hostname";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:128;s:6:"binary";b:0;s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'comment.field_schema_data.langcode', 'a:2:{s:7:"comment";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}s:18:"comment_field_data";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'comment.field_schema_data.mail', 'a:1:{s:18:"comment_field_data";a:1:{s:6:"fields";a:1:{s:4:"mail";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:254;s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'comment.field_schema_data.name', 'a:1:{s:18:"comment_field_data";a:1:{s:6:"fields";a:1:{s:4:"name";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:60;s:6:"binary";b:0;s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'comment.field_schema_data.pid', 'a:1:{s:18:"comment_field_data";a:2:{s:6:"fields";a:1:{s:3:"pid";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;}}s:7:"indexes";a:0:{}}}'),
('entity.storage_schema.sql', 'comment.field_schema_data.status', 'a:1:{s:18:"comment_field_data";a:1:{s:6:"fields";a:1:{s:6:"status";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}}');
INSERT INTO `[[dbprefix]]key_value` VALUES
('entity.storage_schema.sql', 'comment.field_schema_data.subject', 'a:1:{s:18:"comment_field_data";a:1:{s:6:"fields";a:1:{s:7:"subject";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:64;s:6:"binary";b:0;s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'comment.field_schema_data.thread', 'a:1:{s:18:"comment_field_data";a:1:{s:6:"fields";a:1:{s:6:"thread";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'comment.field_schema_data.uid', 'a:1:{s:18:"comment_field_data";a:3:{s:6:"fields";a:1:{s:3:"uid";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:29:"comment_field__uid__target_id";a:1:{i:0;s:3:"uid";}}s:12:"foreign keys";a:1:{s:18:"comment_field__uid";a:2:{s:5:"table";s:5:"users";s:7:"columns";a:1:{s:3:"uid";s:3:"uid";}}}}}'),
('entity.storage_schema.sql', 'comment.field_schema_data.uuid', 'a:1:{s:7:"comment";a:2:{s:6:"fields";a:1:{s:4:"uuid";a:4:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;s:8:"not null";b:1;}}s:11:"unique keys";a:1:{s:26:"comment_field__uuid__value";a:1:{i:0;s:4:"uuid";}}}}'),
('entity.storage_schema.sql', 'file.entity_schema_data', 'a:1:{s:12:"file_managed";a:1:{s:11:"primary key";a:1:{i:0;s:3:"fid";}}}'),
('entity.storage_schema.sql', 'file.field_schema_data.changed', 'a:1:{s:12:"file_managed";a:2:{s:6:"fields";a:1:{s:7:"changed";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:19:"file_field__changed";a:1:{i:0;s:7:"changed";}}}}'),
('entity.storage_schema.sql', 'file.field_schema_data.created', 'a:1:{s:12:"file_managed";a:1:{s:6:"fields";a:1:{s:7:"created";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'file.field_schema_data.fid', 'a:1:{s:12:"file_managed";a:1:{s:6:"fields";a:1:{s:3:"fid";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'file.field_schema_data.filemime', 'a:1:{s:12:"file_managed";a:1:{s:6:"fields";a:1:{s:8:"filemime";a:4:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'file.field_schema_data.filename', 'a:1:{s:12:"file_managed";a:1:{s:6:"fields";a:1:{s:8:"filename";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'file.field_schema_data.filesize', 'a:1:{s:12:"file_managed";a:1:{s:6:"fields";a:1:{s:8:"filesize";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:3:"big";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'file.field_schema_data.langcode', 'a:1:{s:12:"file_managed";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'file.field_schema_data.status', 'a:1:{s:12:"file_managed";a:2:{s:6:"fields";a:1:{s:6:"status";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:18:"file_field__status";a:1:{i:0;s:6:"status";}}}}'),
('entity.storage_schema.sql', 'file.field_schema_data.uid', 'a:1:{s:12:"file_managed";a:2:{s:6:"fields";a:1:{s:3:"uid";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;}}s:7:"indexes";a:1:{s:26:"file_field__uid__target_id";a:1:{i:0;s:3:"uid";}}}}'),
('entity.storage_schema.sql', 'file.field_schema_data.uri', 'a:1:{s:12:"file_managed";a:2:{s:6:"fields";a:1:{s:3:"uri";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:1;s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:15:"file_field__uri";a:1:{i:0;s:3:"uri";}}}}'),
('entity.storage_schema.sql', 'file.field_schema_data.uuid', 'a:1:{s:12:"file_managed";a:2:{s:6:"fields";a:1:{s:4:"uuid";a:4:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;s:8:"not null";b:1;}}s:11:"unique keys";a:1:{s:23:"file_field__uuid__value";a:1:{i:0;s:4:"uuid";}}}}'),
('entity.storage_schema.sql', 'menu_link_content.entity_schema_data', 'a:4:{s:17:"menu_link_content";a:2:{s:11:"primary key";a:1:{i:0;s:2:"id";}s:11:"unique keys";a:1:{s:30:"menu_link_content__revision_id";a:1:{i:0;s:11:"revision_id";}}}s:26:"menu_link_content_revision";a:2:{s:11:"primary key";a:1:{i:0;s:11:"revision_id";}s:7:"indexes";a:1:{s:21:"menu_link_content__id";a:1:{i:0;s:2:"id";}}}s:22:"menu_link_content_data";a:2:{s:11:"primary key";a:2:{i:0;s:2:"id";i:1;s:8:"langcode";}s:7:"indexes";a:3:{s:49:"menu_link_content__id__default_langcode__langcode";a:3:{i:0;s:2:"id";i:1;s:16:"default_langcode";i:2;s:8:"langcode";}s:30:"menu_link_content__revision_id";a:1:{i:0;s:11:"revision_id";}s:33:"menu_link_content__enabled_bundle";a:3:{i:0;s:7:"enabled";i:1;s:6:"bundle";i:2;s:2:"id";}}}s:32:"menu_link_content_field_revision";a:2:{s:11:"primary key";a:2:{i:0;s:11:"revision_id";i:1;s:8:"langcode";}s:7:"indexes";a:1:{s:49:"menu_link_content__id__default_langcode__langcode";a:3:{i:0;s:2:"id";i:1;s:16:"default_langcode";i:2;s:8:"langcode";}}}}'),
('entity.storage_schema.sql', 'menu_link_content.field_schema_data.bundle', 'a:2:{s:17:"menu_link_content";a:1:{s:6:"fields";a:1:{s:6:"bundle";a:4:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:6:"binary";b:0;s:8:"not null";b:1;}}}s:22:"menu_link_content_data";a:1:{s:6:"fields";a:1:{s:6:"bundle";a:4:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:6:"binary";b:0;s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'menu_link_content.field_schema_data.changed', 'a:2:{s:22:"menu_link_content_data";a:1:{s:6:"fields";a:1:{s:7:"changed";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}s:32:"menu_link_content_field_revision";a:1:{s:6:"fields";a:1:{s:7:"changed";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'menu_link_content.field_schema_data.default_langcode', 'a:2:{s:22:"menu_link_content_data";a:1:{s:6:"fields";a:1:{s:16:"default_langcode";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}s:32:"menu_link_content_field_revision";a:1:{s:6:"fields";a:1:{s:16:"default_langcode";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'menu_link_content.field_schema_data.description', 'a:2:{s:22:"menu_link_content_data";a:1:{s:6:"fields";a:1:{s:11:"description";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}s:32:"menu_link_content_field_revision";a:1:{s:6:"fields";a:1:{s:11:"description";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'menu_link_content.field_schema_data.enabled', 'a:2:{s:22:"menu_link_content_data";a:1:{s:6:"fields";a:1:{s:7:"enabled";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}s:32:"menu_link_content_field_revision";a:1:{s:6:"fields";a:1:{s:7:"enabled";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'menu_link_content.field_schema_data.expanded', 'a:1:{s:22:"menu_link_content_data";a:1:{s:6:"fields";a:1:{s:8:"expanded";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'menu_link_content.field_schema_data.external', 'a:2:{s:22:"menu_link_content_data";a:1:{s:6:"fields";a:1:{s:8:"external";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}s:32:"menu_link_content_field_revision";a:1:{s:6:"fields";a:1:{s:8:"external";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'menu_link_content.field_schema_data.id', 'a:4:{s:17:"menu_link_content";a:1:{s:6:"fields";a:1:{s:2:"id";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:22:"menu_link_content_data";a:1:{s:6:"fields";a:1:{s:2:"id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:26:"menu_link_content_revision";a:1:{s:6:"fields";a:1:{s:2:"id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:32:"menu_link_content_field_revision";a:1:{s:6:"fields";a:1:{s:2:"id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'menu_link_content.field_schema_data.langcode', 'a:4:{s:17:"menu_link_content";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}s:22:"menu_link_content_data";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}s:26:"menu_link_content_revision";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}s:32:"menu_link_content_field_revision";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'menu_link_content.field_schema_data.link', 'a:2:{s:22:"menu_link_content_data";a:2:{s:6:"fields";a:3:{s:9:"link__uri";a:4:{s:11:"description";s:20:"The URI of the link.";s:4:"type";s:7:"varchar";s:6:"length";i:2048;s:8:"not null";b:0;}s:11:"link__title";a:4:{s:11:"description";s:14:"The link text.";s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:0;}s:13:"link__options";a:5:{s:11:"description";s:41:"Serialized array of options for the link.";s:4:"type";s:4:"blob";s:4:"size";s:3:"big";s:9:"serialize";b:1;s:8:"not null";b:0;}}s:7:"indexes";a:1:{s:34:"menu_link_content_field__link__uri";a:1:{i:0;a:2:{i:0;s:9:"link__uri";i:1;i:30;}}}}s:32:"menu_link_content_field_revision";a:2:{s:6:"fields";a:3:{s:9:"link__uri";a:4:{s:11:"description";s:20:"The URI of the link.";s:4:"type";s:7:"varchar";s:6:"length";i:2048;s:8:"not null";b:0;}s:11:"link__title";a:4:{s:11:"description";s:14:"The link text.";s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:0;}s:13:"link__options";a:5:{s:11:"description";s:41:"Serialized array of options for the link.";s:4:"type";s:4:"blob";s:4:"size";s:3:"big";s:9:"serialize";b:1;s:8:"not null";b:0;}}s:7:"indexes";a:1:{s:34:"menu_link_content_field__link__uri";a:1:{i:0;a:2:{i:0;s:9:"link__uri";i:1;i:30;}}}}}'),
('entity.storage_schema.sql', 'menu_link_content.field_schema_data.menu_name', 'a:1:{s:22:"menu_link_content_data";a:1:{s:6:"fields";a:1:{s:9:"menu_name";a:4:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'menu_link_content.field_schema_data.parent', 'a:1:{s:22:"menu_link_content_data";a:1:{s:6:"fields";a:1:{s:6:"parent";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'menu_link_content.field_schema_data.rediscover', 'a:1:{s:22:"menu_link_content_data";a:1:{s:6:"fields";a:1:{s:10:"rediscover";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'menu_link_content.field_schema_data.revision_created', 'a:1:{s:26:"menu_link_content_revision";a:1:{s:6:"fields";a:1:{s:16:"revision_created";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'menu_link_content.field_schema_data.revision_default', 'a:1:{s:26:"menu_link_content_revision";a:1:{s:6:"fields";a:1:{s:16:"revision_default";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'menu_link_content.field_schema_data.revision_id', 'a:4:{s:17:"menu_link_content";a:1:{s:6:"fields";a:1:{s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:0;}}}s:22:"menu_link_content_data";a:1:{s:6:"fields";a:1:{s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:26:"menu_link_content_revision";a:1:{s:6:"fields";a:1:{s:11:"revision_id";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:32:"menu_link_content_field_revision";a:1:{s:6:"fields";a:1:{s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'menu_link_content.field_schema_data.revision_log_message', 'a:1:{s:26:"menu_link_content_revision";a:1:{s:6:"fields";a:1:{s:20:"revision_log_message";a:3:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'menu_link_content.field_schema_data.revision_translation_affected', 'a:2:{s:22:"menu_link_content_data";a:1:{s:6:"fields";a:1:{s:29:"revision_translation_affected";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}s:32:"menu_link_content_field_revision";a:1:{s:6:"fields";a:1:{s:29:"revision_translation_affected";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'menu_link_content.field_schema_data.revision_user', 'a:1:{s:26:"menu_link_content_revision";a:2:{s:6:"fields";a:1:{s:13:"revision_user";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;}}s:7:"indexes";a:1:{s:29:"menu_link_content__ef029a1897";a:1:{i:0;s:13:"revision_user";}}}}'),
('entity.storage_schema.sql', 'menu_link_content.field_schema_data.title', 'a:2:{s:22:"menu_link_content_data";a:1:{s:6:"fields";a:1:{s:5:"title";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}s:32:"menu_link_content_field_revision";a:1:{s:6:"fields";a:1:{s:5:"title";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'menu_link_content.field_schema_data.uuid', 'a:1:{s:17:"menu_link_content";a:2:{s:6:"fields";a:1:{s:4:"uuid";a:4:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;s:8:"not null";b:1;}}s:11:"unique keys";a:1:{s:36:"menu_link_content_field__uuid__value";a:1:{i:0;s:4:"uuid";}}}}'),
('entity.storage_schema.sql', 'menu_link_content.field_schema_data.weight', 'a:1:{s:22:"menu_link_content_data";a:1:{s:6:"fields";a:1:{s:6:"weight";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:0;s:4:"size";s:6:"normal";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'node.entity_schema_data', 'a:4:{s:4:"node";a:2:{s:11:"primary key";a:1:{i:0;s:3:"nid";}s:11:"unique keys";a:1:{s:9:"node__vid";a:1:{i:0;s:3:"vid";}}}s:13:"node_revision";a:2:{s:11:"primary key";a:1:{i:0;s:3:"vid";}s:7:"indexes";a:1:{s:9:"node__nid";a:1:{i:0;s:3:"nid";}}}s:15:"node_field_data";a:2:{s:11:"primary key";a:2:{i:0;s:3:"nid";i:1;s:8:"langcode";}s:7:"indexes";a:5:{s:36:"node__id__default_langcode__langcode";a:3:{i:0;s:3:"nid";i:1;s:16:"default_langcode";i:2;s:8:"langcode";}s:9:"node__vid";a:1:{i:0;s:3:"vid";}s:17:"node__status_type";a:3:{i:0;s:6:"status";i:1;s:4:"type";i:2;s:3:"nid";}s:15:"node__frontpage";a:4:{i:0;s:7:"promote";i:1;s:6:"status";i:2;s:6:"sticky";i:3;s:7:"created";}s:16:"node__title_type";a:2:{i:0;s:5:"title";i:1;a:2:{i:0;s:4:"type";i:1;i:4;}}}}s:19:"node_field_revision";a:2:{s:11:"primary key";a:2:{i:0;s:3:"vid";i:1;s:8:"langcode";}s:7:"indexes";a:1:{s:36:"node__id__default_langcode__langcode";a:3:{i:0;s:3:"nid";i:1;s:16:"default_langcode";i:2;s:8:"langcode";}}}}'),
('entity.storage_schema.sql', 'node.field_schema_data.body', 'a:2:{s:10:"node__body";a:4:{s:11:"description";s:33:"Data storage for node field body.";s:6:"fields";a:9:{s:6:"bundle";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:88:"The field instance bundle to which this row belongs, used when deleting a field instance";}s:7:"deleted";a:5:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:60:"A boolean indicating whether this data item has been deleted";}s:9:"entity_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:38:"The entity id this data is attached to";}s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:47:"The entity revision id this data is attached to";}s:8:"langcode";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:37:"The language code for this data item.";}s:5:"delta";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:67:"The sequence number for this data item, used for multi-value fields";}s:10:"body_value";a:3:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:1;}s:12:"body_summary";a:3:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:0;}s:11:"body_format";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:255;s:8:"not null";b:0;}}s:11:"primary key";a:4:{i:0;s:9:"entity_id";i:1;s:7:"deleted";i:2;s:5:"delta";i:3;s:8:"langcode";}s:7:"indexes";a:3:{s:6:"bundle";a:1:{i:0;s:6:"bundle";}s:11:"revision_id";a:1:{i:0;s:11:"revision_id";}s:11:"body_format";a:1:{i:0;s:11:"body_format";}}}s:19:"node_revision__body";a:4:{s:11:"description";s:45:"Revision archive storage for node field body.";s:6:"fields";a:9:{s:6:"bundle";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:88:"The field instance bundle to which this row belongs, used when deleting a field instance";}s:7:"deleted";a:5:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:60:"A boolean indicating whether this data item has been deleted";}s:9:"entity_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:38:"The entity id this data is attached to";}s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:47:"The entity revision id this data is attached to";}s:8:"langcode";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:37:"The language code for this data item.";}s:5:"delta";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:67:"The sequence number for this data item, used for multi-value fields";}s:10:"body_value";a:3:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:1;}s:12:"body_summary";a:3:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:0;}s:11:"body_format";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:255;s:8:"not null";b:0;}}s:11:"primary key";a:5:{i:0;s:9:"entity_id";i:1;s:11:"revision_id";i:2;s:7:"deleted";i:3;s:5:"delta";i:4;s:8:"langcode";}s:7:"indexes";a:3:{s:6:"bundle";a:1:{i:0;s:6:"bundle";}s:11:"revision_id";a:1:{i:0;s:11:"revision_id";}s:11:"body_format";a:1:{i:0;s:11:"body_format";}}}}'),
('entity.storage_schema.sql', 'node.field_schema_data.changed', 'a:2:{s:15:"node_field_data";a:2:{s:6:"fields";a:1:{s:7:"changed";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:19:"node_field__changed";a:1:{i:0;s:7:"changed";}}}s:19:"node_field_revision";a:1:{s:6:"fields";a:1:{s:7:"changed";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'node.field_schema_data.comment', 'a:2:{s:13:"node__comment";a:4:{s:11:"description";s:36:"Data storage for node field comment.";s:6:"fields";a:7:{s:6:"bundle";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:88:"The field instance bundle to which this row belongs, used when deleting a field instance";}s:7:"deleted";a:5:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:60:"A boolean indicating whether this data item has been deleted";}s:9:"entity_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:38:"The entity id this data is attached to";}s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:47:"The entity revision id this data is attached to";}s:8:"langcode";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:37:"The language code for this data item.";}s:5:"delta";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:67:"The sequence number for this data item, used for multi-value fields";}s:14:"comment_status";a:4:{s:11:"description";s:99:"Whether comments are allowed on this entity: 0 = no, 1 = closed (read only), 2 = open (read/write).";s:4:"type";s:3:"int";s:7:"default";i:0;s:8:"not null";b:1;}}s:11:"primary key";a:4:{i:0;s:9:"entity_id";i:1;s:7:"deleted";i:2;s:5:"delta";i:3;s:8:"langcode";}s:7:"indexes";a:2:{s:6:"bundle";a:1:{i:0;s:6:"bundle";}s:11:"revision_id";a:1:{i:0;s:11:"revision_id";}}}s:22:"node_revision__comment";a:4:{s:11:"description";s:48:"Revision archive storage for node field comment.";s:6:"fields";a:7:{s:6:"bundle";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:88:"The field instance bundle to which this row belongs, used when deleting a field instance";}s:7:"deleted";a:5:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:60:"A boolean indicating whether this data item has been deleted";}s:9:"entity_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:38:"The entity id this data is attached to";}s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:47:"The entity revision id this data is attached to";}s:8:"langcode";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:37:"The language code for this data item.";}s:5:"delta";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:67:"The sequence number for this data item, used for multi-value fields";}s:14:"comment_status";a:4:{s:11:"description";s:99:"Whether comments are allowed on this entity: 0 = no, 1 = closed (read only), 2 = open (read/write).";s:4:"type";s:3:"int";s:7:"default";i:0;s:8:"not null";b:1;}}s:11:"primary key";a:5:{i:0;s:9:"entity_id";i:1;s:11:"revision_id";i:2;s:7:"deleted";i:3;s:5:"delta";i:4;s:8:"langcode";}s:7:"indexes";a:2:{s:6:"bundle";a:1:{i:0;s:6:"bundle";}s:11:"revision_id";a:1:{i:0;s:11:"revision_id";}}}}'),
('entity.storage_schema.sql', 'node.field_schema_data.created', 'a:2:{s:15:"node_field_data";a:2:{s:6:"fields";a:1:{s:7:"created";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:19:"node_field__created";a:1:{i:0;s:7:"created";}}}s:19:"node_field_revision";a:1:{s:6:"fields";a:1:{s:7:"created";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'node.field_schema_data.default_langcode', 'a:2:{s:15:"node_field_data";a:1:{s:6:"fields";a:1:{s:16:"default_langcode";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}s:19:"node_field_revision";a:1:{s:6:"fields";a:1:{s:16:"default_langcode";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'node.field_schema_data.field_image', 'a:2:{s:17:"node__field_image";a:5:{s:11:"description";s:40:"Data storage for node field field_image.";s:6:"fields";a:11:{s:6:"bundle";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:88:"The field instance bundle to which this row belongs, used when deleting a field instance";}s:7:"deleted";a:5:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:60:"A boolean indicating whether this data item has been deleted";}s:9:"entity_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:38:"The entity id this data is attached to";}s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:47:"The entity revision id this data is attached to";}s:8:"langcode";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:37:"The language code for this data item.";}s:5:"delta";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:67:"The sequence number for this data item, used for multi-value fields";}s:21:"field_image_target_id";a:4:{s:11:"description";s:26:"The ID of the file entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;}s:15:"field_image_alt";a:4:{s:11:"description";s:56:"Alternative image text, for the image''s ''alt'' attribute.";s:4:"type";s:7:"varchar";s:6:"length";i:512;s:8:"not null";b:0;}s:17:"field_image_title";a:4:{s:11:"description";s:52:"Image title text, for the image''s ''title'' attribute.";s:4:"type";s:7:"varchar";s:6:"length";i:1024;s:8:"not null";b:0;}s:17:"field_image_width";a:4:{s:11:"description";s:33:"The width of the image in pixels.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;}s:18:"field_image_height";a:4:{s:11:"description";s:34:"The height of the image in pixels.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;}}s:11:"primary key";a:4:{i:0;s:9:"entity_id";i:1;s:7:"deleted";i:2;s:5:"delta";i:3;s:8:"langcode";}s:7:"indexes";a:3:{s:6:"bundle";a:1:{i:0;s:6:"bundle";}s:11:"revision_id";a:1:{i:0;s:11:"revision_id";}s:21:"field_image_target_id";a:1:{i:0;s:21:"field_image_target_id";}}s:12:"foreign keys";a:1:{s:21:"field_image_target_id";a:2:{s:5:"table";s:12:"file_managed";s:7:"columns";a:1:{s:21:"field_image_target_id";s:3:"fid";}}}}s:26:"node_revision__field_image";a:5:{s:11:"description";s:52:"Revision archive storage for node field field_image.";s:6:"fields";a:11:{s:6:"bundle";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:88:"The field instance bundle to which this row belongs, used when deleting a field instance";}s:7:"deleted";a:5:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:60:"A boolean indicating whether this data item has been deleted";}s:9:"entity_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:38:"The entity id this data is attached to";}s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:47:"The entity revision id this data is attached to";}s:8:"langcode";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:37:"The language code for this data item.";}s:5:"delta";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:67:"The sequence number for this data item, used for multi-value fields";}s:21:"field_image_target_id";a:4:{s:11:"description";s:26:"The ID of the file entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;}s:15:"field_image_alt";a:4:{s:11:"description";s:56:"Alternative image text, for the image''s ''alt'' attribute.";s:4:"type";s:7:"varchar";s:6:"length";i:512;s:8:"not null";b:0;}s:17:"field_image_title";a:4:{s:11:"description";s:52:"Image title text, for the image''s ''title'' attribute.";s:4:"type";s:7:"varchar";s:6:"length";i:1024;s:8:"not null";b:0;}s:17:"field_image_width";a:4:{s:11:"description";s:33:"The width of the image in pixels.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;}s:18:"field_image_height";a:4:{s:11:"description";s:34:"The height of the image in pixels.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;}}s:11:"primary key";a:5:{i:0;s:9:"entity_id";i:1;s:11:"revision_id";i:2;s:7:"deleted";i:3;s:5:"delta";i:4;s:8:"langcode";}s:7:"indexes";a:3:{s:6:"bundle";a:1:{i:0;s:6:"bundle";}s:11:"revision_id";a:1:{i:0;s:11:"revision_id";}s:21:"field_image_target_id";a:1:{i:0;s:21:"field_image_target_id";}}s:12:"foreign keys";a:1:{s:21:"field_image_target_id";a:2:{s:5:"table";s:12:"file_managed";s:7:"columns";a:1:{s:21:"field_image_target_id";s:3:"fid";}}}}}'),
('entity.storage_schema.sql', 'node.field_schema_data.field_tags', 'a:2:{s:16:"node__field_tags";a:4:{s:11:"description";s:39:"Data storage for node field field_tags.";s:6:"fields";a:7:{s:6:"bundle";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:88:"The field instance bundle to which this row belongs, used when deleting a field instance";}s:7:"deleted";a:5:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:60:"A boolean indicating whether this data item has been deleted";}s:9:"entity_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:38:"The entity id this data is attached to";}s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:47:"The entity revision id this data is attached to";}s:8:"langcode";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:37:"The language code for this data item.";}s:5:"delta";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:67:"The sequence number for this data item, used for multi-value fields";}s:20:"field_tags_target_id";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;}}s:11:"primary key";a:4:{i:0;s:9:"entity_id";i:1;s:7:"deleted";i:2;s:5:"delta";i:3;s:8:"langcode";}s:7:"indexes";a:3:{s:6:"bundle";a:1:{i:0;s:6:"bundle";}s:11:"revision_id";a:1:{i:0;s:11:"revision_id";}s:20:"field_tags_target_id";a:1:{i:0;s:20:"field_tags_target_id";}}}s:25:"node_revision__field_tags";a:4:{s:11:"description";s:51:"Revision archive storage for node field field_tags.";s:6:"fields";a:7:{s:6:"bundle";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:88:"The field instance bundle to which this row belongs, used when deleting a field instance";}s:7:"deleted";a:5:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:60:"A boolean indicating whether this data item has been deleted";}s:9:"entity_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:38:"The entity id this data is attached to";}s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:47:"The entity revision id this data is attached to";}s:8:"langcode";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:37:"The language code for this data item.";}s:5:"delta";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:67:"The sequence number for this data item, used for multi-value fields";}s:20:"field_tags_target_id";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;}}s:11:"primary key";a:5:{i:0;s:9:"entity_id";i:1;s:11:"revision_id";i:2;s:7:"deleted";i:3;s:5:"delta";i:4;s:8:"langcode";}s:7:"indexes";a:3:{s:6:"bundle";a:1:{i:0;s:6:"bundle";}s:11:"revision_id";a:1:{i:0;s:11:"revision_id";}s:20:"field_tags_target_id";a:1:{i:0;s:20:"field_tags_target_id";}}}}'),
('entity.storage_schema.sql', 'node.field_schema_data.langcode', 'a:4:{s:4:"node";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}s:15:"node_field_data";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}s:13:"node_revision";a:2:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:20:"node_field__langcode";a:1:{i:0;s:8:"langcode";}}}s:19:"node_field_revision";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'node.field_schema_data.nid', 'a:4:{s:4:"node";a:1:{s:6:"fields";a:1:{s:3:"nid";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:15:"node_field_data";a:1:{s:6:"fields";a:1:{s:3:"nid";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:13:"node_revision";a:1:{s:6:"fields";a:1:{s:3:"nid";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:19:"node_field_revision";a:1:{s:6:"fields";a:1:{s:3:"nid";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'node.field_schema_data.promote', 'a:2:{s:15:"node_field_data";a:1:{s:6:"fields";a:1:{s:7:"promote";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}s:19:"node_field_revision";a:1:{s:6:"fields";a:1:{s:7:"promote";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'node.field_schema_data.revision_default', 'a:1:{s:13:"node_revision";a:1:{s:6:"fields";a:1:{s:16:"revision_default";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'node.field_schema_data.revision_log', 'a:1:{s:13:"node_revision";a:1:{s:6:"fields";a:1:{s:12:"revision_log";a:3:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'node.field_schema_data.revision_timestamp', 'a:1:{s:13:"node_revision";a:1:{s:6:"fields";a:1:{s:18:"revision_timestamp";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'node.field_schema_data.revision_translation_affected', 'a:2:{s:15:"node_field_data";a:1:{s:6:"fields";a:1:{s:29:"revision_translation_affected";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}s:19:"node_field_revision";a:1:{s:6:"fields";a:1:{s:29:"revision_translation_affected";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'node.field_schema_data.revision_uid', 'a:1:{s:13:"node_revision";a:3:{s:6:"fields";a:1:{s:12:"revision_uid";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;}}s:7:"indexes";a:1:{s:35:"node_field__revision_uid__target_id";a:1:{i:0;s:12:"revision_uid";}}s:12:"foreign keys";a:1:{s:24:"node_field__revision_uid";a:2:{s:5:"table";s:5:"users";s:7:"columns";a:1:{s:12:"revision_uid";s:3:"uid";}}}}}'),
('entity.storage_schema.sql', 'node.field_schema_data.status', 'a:2:{s:15:"node_field_data";a:1:{s:6:"fields";a:1:{s:6:"status";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}s:19:"node_field_revision";a:1:{s:6:"fields";a:1:{s:6:"status";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'node.field_schema_data.sticky', 'a:2:{s:15:"node_field_data";a:1:{s:6:"fields";a:1:{s:6:"sticky";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}s:19:"node_field_revision";a:1:{s:6:"fields";a:1:{s:6:"sticky";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'node.field_schema_data.title', 'a:2:{s:15:"node_field_data";a:1:{s:6:"fields";a:1:{s:5:"title";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:1;}}}s:19:"node_field_revision";a:1:{s:6:"fields";a:1:{s:5:"title";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'node.field_schema_data.type', 'a:2:{s:4:"node";a:2:{s:6:"fields";a:1:{s:4:"type";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:27:"node_field__type__target_id";a:1:{i:0;s:4:"type";}}}s:15:"node_field_data";a:2:{s:6:"fields";a:1:{s:4:"type";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:27:"node_field__type__target_id";a:1:{i:0;s:4:"type";}}}}'),
('entity.storage_schema.sql', 'node.field_schema_data.uid', 'a:2:{s:15:"node_field_data";a:2:{s:6:"fields";a:1:{s:3:"uid";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:26:"node_field__uid__target_id";a:1:{i:0;s:3:"uid";}}}s:19:"node_field_revision";a:2:{s:6:"fields";a:1:{s:3:"uid";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:26:"node_field__uid__target_id";a:1:{i:0;s:3:"uid";}}}}'),
('entity.storage_schema.sql', 'node.field_schema_data.uuid', 'a:1:{s:4:"node";a:2:{s:6:"fields";a:1:{s:4:"uuid";a:4:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;s:8:"not null";b:1;}}s:11:"unique keys";a:1:{s:23:"node_field__uuid__value";a:1:{i:0;s:4:"uuid";}}}}'),
('entity.storage_schema.sql', 'node.field_schema_data.vid', 'a:4:{s:4:"node";a:1:{s:6:"fields";a:1:{s:3:"vid";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:0;}}}s:15:"node_field_data";a:1:{s:6:"fields";a:1:{s:3:"vid";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:13:"node_revision";a:1:{s:6:"fields";a:1:{s:3:"vid";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:19:"node_field_revision";a:1:{s:6:"fields";a:1:{s:3:"vid";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'path_alias.entity_schema_data', 'a:2:{s:10:"path_alias";a:3:{s:11:"primary key";a:1:{i:0;s:2:"id";}s:7:"indexes";a:2:{s:36:"path_alias__alias_langcode_id_status";a:4:{i:0;s:5:"alias";i:1;s:8:"langcode";i:2;s:2:"id";i:3;s:6:"status";}s:35:"path_alias__path_langcode_id_status";a:4:{i:0;s:4:"path";i:1;s:8:"langcode";i:2;s:2:"id";i:3;s:6:"status";}}s:11:"unique keys";a:1:{s:23:"path_alias__revision_id";a:1:{i:0;s:11:"revision_id";}}}s:19:"path_alias_revision";a:2:{s:11:"primary key";a:1:{i:0;s:11:"revision_id";}s:7:"indexes";a:1:{s:14:"path_alias__id";a:1:{i:0;s:2:"id";}}}}'),
('entity.storage_schema.sql', 'path_alias.field_schema_data.alias', 'a:2:{s:10:"path_alias";a:1:{s:6:"fields";a:1:{s:5:"alias";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}s:19:"path_alias_revision";a:1:{s:6:"fields";a:1:{s:5:"alias";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'path_alias.field_schema_data.id', 'a:2:{s:10:"path_alias";a:1:{s:6:"fields";a:1:{s:2:"id";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:19:"path_alias_revision";a:1:{s:6:"fields";a:1:{s:2:"id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'path_alias.field_schema_data.langcode', 'a:2:{s:10:"path_alias";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}s:19:"path_alias_revision";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'path_alias.field_schema_data.path', 'a:2:{s:10:"path_alias";a:1:{s:6:"fields";a:1:{s:4:"path";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}s:19:"path_alias_revision";a:1:{s:6:"fields";a:1:{s:4:"path";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'path_alias.field_schema_data.revision_default', 'a:1:{s:19:"path_alias_revision";a:1:{s:6:"fields";a:1:{s:16:"revision_default";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'path_alias.field_schema_data.revision_id', 'a:2:{s:10:"path_alias";a:1:{s:6:"fields";a:1:{s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:0;}}}s:19:"path_alias_revision";a:1:{s:6:"fields";a:1:{s:11:"revision_id";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'path_alias.field_schema_data.status', 'a:2:{s:10:"path_alias";a:1:{s:6:"fields";a:1:{s:6:"status";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}s:19:"path_alias_revision";a:1:{s:6:"fields";a:1:{s:6:"status";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'path_alias.field_schema_data.uuid', 'a:1:{s:10:"path_alias";a:2:{s:6:"fields";a:1:{s:4:"uuid";a:4:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;s:8:"not null";b:1;}}s:11:"unique keys";a:1:{s:29:"path_alias_field__uuid__value";a:1:{i:0;s:4:"uuid";}}}}'),
('entity.storage_schema.sql', 'shortcut.entity_schema_data', 'a:2:{s:8:"shortcut";a:1:{s:11:"primary key";a:1:{i:0;s:2:"id";}}s:19:"shortcut_field_data";a:2:{s:11:"primary key";a:2:{i:0;s:2:"id";i:1;s:8:"langcode";}s:7:"indexes";a:1:{s:40:"shortcut__id__default_langcode__langcode";a:3:{i:0;s:2:"id";i:1;s:16:"default_langcode";i:2;s:8:"langcode";}}}}'),
('entity.storage_schema.sql', 'shortcut.field_schema_data.default_langcode', 'a:1:{s:19:"shortcut_field_data";a:1:{s:6:"fields";a:1:{s:16:"default_langcode";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'shortcut.field_schema_data.id', 'a:2:{s:8:"shortcut";a:1:{s:6:"fields";a:1:{s:2:"id";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:19:"shortcut_field_data";a:1:{s:6:"fields";a:1:{s:2:"id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'shortcut.field_schema_data.langcode', 'a:2:{s:8:"shortcut";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}s:19:"shortcut_field_data";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'shortcut.field_schema_data.link', 'a:1:{s:19:"shortcut_field_data";a:2:{s:6:"fields";a:3:{s:9:"link__uri";a:4:{s:11:"description";s:20:"The URI of the link.";s:4:"type";s:7:"varchar";s:6:"length";i:2048;s:8:"not null";b:0;}s:11:"link__title";a:4:{s:11:"description";s:14:"The link text.";s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:0;}s:13:"link__options";a:5:{s:11:"description";s:41:"Serialized array of options for the link.";s:4:"type";s:4:"blob";s:4:"size";s:3:"big";s:9:"serialize";b:1;s:8:"not null";b:0;}}s:7:"indexes";a:1:{s:25:"shortcut_field__link__uri";a:1:{i:0;a:2:{i:0;s:9:"link__uri";i:1;i:30;}}}}}'),
('entity.storage_schema.sql', 'shortcut.field_schema_data.shortcut_set', 'a:2:{s:8:"shortcut";a:2:{s:6:"fields";a:1:{s:12:"shortcut_set";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:39:"shortcut_field__shortcut_set__target_id";a:1:{i:0;s:12:"shortcut_set";}}}s:19:"shortcut_field_data";a:2:{s:6:"fields";a:1:{s:12:"shortcut_set";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:39:"shortcut_field__shortcut_set__target_id";a:1:{i:0;s:12:"shortcut_set";}}}}'),
('entity.storage_schema.sql', 'shortcut.field_schema_data.title', 'a:1:{s:19:"shortcut_field_data";a:1:{s:6:"fields";a:1:{s:5:"title";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'shortcut.field_schema_data.uuid', 'a:1:{s:8:"shortcut";a:2:{s:6:"fields";a:1:{s:4:"uuid";a:4:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;s:8:"not null";b:1;}}s:11:"unique keys";a:1:{s:27:"shortcut_field__uuid__value";a:1:{i:0;s:4:"uuid";}}}}'),
('entity.storage_schema.sql', 'shortcut.field_schema_data.weight', 'a:1:{s:19:"shortcut_field_data";a:1:{s:6:"fields";a:1:{s:6:"weight";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:0;s:4:"size";s:6:"normal";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'taxonomy_term.entity_schema_data', 'a:5:{s:18:"taxonomy_term_data";a:2:{s:11:"primary key";a:1:{i:0;s:3:"tid";}s:11:"unique keys";a:1:{s:26:"taxonomy_term__revision_id";a:1:{i:0;s:11:"revision_id";}}}s:22:"taxonomy_term_revision";a:2:{s:11:"primary key";a:1:{i:0;s:11:"revision_id";}s:7:"indexes";a:1:{s:18:"taxonomy_term__tid";a:1:{i:0;s:3:"tid";}}}s:24:"taxonomy_term_field_data";a:2:{s:11:"primary key";a:2:{i:0;s:3:"tid";i:1;s:8:"langcode";}s:7:"indexes";a:5:{s:45:"taxonomy_term__id__default_langcode__langcode";a:3:{i:0;s:3:"tid";i:1;s:16:"default_langcode";i:2;s:8:"langcode";}s:26:"taxonomy_term__revision_id";a:1:{i:0;s:11:"revision_id";}s:25:"taxonomy_term__status_vid";a:3:{i:0;s:6:"status";i:1;s:3:"vid";i:2;s:3:"tid";}s:19:"taxonomy_term__tree";a:3:{i:0;s:3:"vid";i:1;s:6:"weight";i:2;s:4:"name";}s:23:"taxonomy_term__vid_name";a:2:{i:0;s:3:"vid";i:1;s:4:"name";}}}s:28:"taxonomy_term_field_revision";a:2:{s:11:"primary key";a:2:{i:0;s:11:"revision_id";i:1;s:8:"langcode";}s:7:"indexes";a:1:{s:45:"taxonomy_term__id__default_langcode__langcode";a:3:{i:0;s:3:"tid";i:1;s:16:"default_langcode";i:2;s:8:"langcode";}}}s:14:"taxonomy_index";a:2:{s:11:"primary key";a:2:{i:0;s:3:"nid";i:1;s:3:"tid";}s:7:"indexes";a:1:{s:9:"term_node";a:4:{i:0;s:3:"tid";i:1;s:6:"status";i:2;s:6:"sticky";i:3;s:7:"created";}}}}'),
('entity.storage_schema.sql', 'taxonomy_term.field_schema_data.changed', 'a:2:{s:24:"taxonomy_term_field_data";a:1:{s:6:"fields";a:1:{s:7:"changed";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}s:28:"taxonomy_term_field_revision";a:1:{s:6:"fields";a:1:{s:7:"changed";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'taxonomy_term.field_schema_data.default_langcode', 'a:2:{s:24:"taxonomy_term_field_data";a:1:{s:6:"fields";a:1:{s:16:"default_langcode";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}s:28:"taxonomy_term_field_revision";a:1:{s:6:"fields";a:1:{s:16:"default_langcode";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'taxonomy_term.field_schema_data.description', 'a:2:{s:24:"taxonomy_term_field_data";a:2:{s:6:"fields";a:2:{s:18:"description__value";a:3:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:0;}s:19:"description__format";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:255;s:8:"not null";b:0;}}s:7:"indexes";a:0:{}}s:28:"taxonomy_term_field_revision";a:2:{s:6:"fields";a:2:{s:18:"description__value";a:3:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:0;}s:19:"description__format";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:255;s:8:"not null";b:0;}}s:7:"indexes";a:1:{s:40:"taxonomy_term_field__description__format";a:1:{i:0;s:19:"description__format";}}}}'),
('entity.storage_schema.sql', 'taxonomy_term.field_schema_data.langcode', 'a:4:{s:18:"taxonomy_term_data";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}s:24:"taxonomy_term_field_data";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}s:22:"taxonomy_term_revision";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}s:28:"taxonomy_term_field_revision";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'taxonomy_term.field_schema_data.name', 'a:2:{s:24:"taxonomy_term_field_data";a:2:{s:6:"fields";a:1:{s:4:"name";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:25:"taxonomy_term_field__name";a:1:{i:0;s:4:"name";}}}s:28:"taxonomy_term_field_revision";a:1:{s:6:"fields";a:1:{s:4:"name";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}}');
INSERT INTO `[[dbprefix]]key_value` VALUES
('entity.storage_schema.sql', 'taxonomy_term.field_schema_data.parent', 'a:2:{s:21:"taxonomy_term__parent";a:4:{s:11:"description";s:44:"Data storage for taxonomy_term field parent.";s:6:"fields";a:7:{s:6:"bundle";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:88:"The field instance bundle to which this row belongs, used when deleting a field instance";}s:7:"deleted";a:5:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:60:"A boolean indicating whether this data item has been deleted";}s:9:"entity_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:38:"The entity id this data is attached to";}s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:47:"The entity revision id this data is attached to";}s:8:"langcode";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:37:"The language code for this data item.";}s:5:"delta";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:67:"The sequence number for this data item, used for multi-value fields";}s:16:"parent_target_id";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;}}s:11:"primary key";a:4:{i:0;s:9:"entity_id";i:1;s:7:"deleted";i:2;s:5:"delta";i:3;s:8:"langcode";}s:7:"indexes";a:3:{s:11:"revision_id";a:1:{i:0;s:11:"revision_id";}s:16:"parent_target_id";a:1:{i:0;s:16:"parent_target_id";}s:22:"bundle_delta_target_id";a:3:{i:0;s:6:"bundle";i:1;s:5:"delta";i:2;s:16:"parent_target_id";}}}s:30:"taxonomy_term_revision__parent";a:4:{s:11:"description";s:56:"Revision archive storage for taxonomy_term field parent.";s:6:"fields";a:7:{s:6:"bundle";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:88:"The field instance bundle to which this row belongs, used when deleting a field instance";}s:7:"deleted";a:5:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:60:"A boolean indicating whether this data item has been deleted";}s:9:"entity_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:38:"The entity id this data is attached to";}s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:47:"The entity revision id this data is attached to";}s:8:"langcode";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:37:"The language code for this data item.";}s:5:"delta";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:67:"The sequence number for this data item, used for multi-value fields";}s:16:"parent_target_id";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;}}s:11:"primary key";a:5:{i:0;s:9:"entity_id";i:1;s:11:"revision_id";i:2;s:7:"deleted";i:3;s:5:"delta";i:4;s:8:"langcode";}s:7:"indexes";a:3:{s:6:"bundle";a:1:{i:0;s:6:"bundle";}s:11:"revision_id";a:1:{i:0;s:11:"revision_id";}s:16:"parent_target_id";a:1:{i:0;s:16:"parent_target_id";}}}}'),
('entity.storage_schema.sql', 'taxonomy_term.field_schema_data.revision_created', 'a:1:{s:22:"taxonomy_term_revision";a:1:{s:6:"fields";a:1:{s:16:"revision_created";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'taxonomy_term.field_schema_data.revision_default', 'a:1:{s:22:"taxonomy_term_revision";a:1:{s:6:"fields";a:1:{s:16:"revision_default";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'taxonomy_term.field_schema_data.revision_id', 'a:4:{s:18:"taxonomy_term_data";a:1:{s:6:"fields";a:1:{s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:0;}}}s:24:"taxonomy_term_field_data";a:1:{s:6:"fields";a:1:{s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:22:"taxonomy_term_revision";a:1:{s:6:"fields";a:1:{s:11:"revision_id";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:28:"taxonomy_term_field_revision";a:1:{s:6:"fields";a:1:{s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'taxonomy_term.field_schema_data.revision_log_message', 'a:1:{s:22:"taxonomy_term_revision";a:1:{s:6:"fields";a:1:{s:20:"revision_log_message";a:3:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'taxonomy_term.field_schema_data.revision_translation_affected', 'a:2:{s:24:"taxonomy_term_field_data";a:1:{s:6:"fields";a:1:{s:29:"revision_translation_affected";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}s:28:"taxonomy_term_field_revision";a:1:{s:6:"fields";a:1:{s:29:"revision_translation_affected";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'taxonomy_term.field_schema_data.revision_user', 'a:1:{s:22:"taxonomy_term_revision";a:2:{s:6:"fields";a:1:{s:13:"revision_user";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;}}s:7:"indexes";a:1:{s:45:"taxonomy_term_field__revision_user__target_id";a:1:{i:0;s:13:"revision_user";}}}}'),
('entity.storage_schema.sql', 'taxonomy_term.field_schema_data.status', 'a:2:{s:24:"taxonomy_term_field_data";a:1:{s:6:"fields";a:1:{s:6:"status";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}s:28:"taxonomy_term_field_revision";a:1:{s:6:"fields";a:1:{s:6:"status";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'taxonomy_term.field_schema_data.tid', 'a:4:{s:18:"taxonomy_term_data";a:1:{s:6:"fields";a:1:{s:3:"tid";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:24:"taxonomy_term_field_data";a:1:{s:6:"fields";a:1:{s:3:"tid";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:22:"taxonomy_term_revision";a:1:{s:6:"fields";a:1:{s:3:"tid";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:28:"taxonomy_term_field_revision";a:1:{s:6:"fields";a:1:{s:3:"tid";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'taxonomy_term.field_schema_data.uuid', 'a:1:{s:18:"taxonomy_term_data";a:2:{s:6:"fields";a:1:{s:4:"uuid";a:4:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;s:8:"not null";b:1;}}s:11:"unique keys";a:1:{s:32:"taxonomy_term_field__uuid__value";a:1:{i:0;s:4:"uuid";}}}}'),
('entity.storage_schema.sql', 'taxonomy_term.field_schema_data.vid', 'a:2:{s:18:"taxonomy_term_data";a:2:{s:6:"fields";a:1:{s:3:"vid";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:35:"taxonomy_term_field__vid__target_id";a:1:{i:0;s:3:"vid";}}}s:24:"taxonomy_term_field_data";a:2:{s:6:"fields";a:1:{s:3:"vid";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;}}s:7:"indexes";a:0:{}}}'),
('entity.storage_schema.sql', 'taxonomy_term.field_schema_data.weight', 'a:1:{s:24:"taxonomy_term_field_data";a:1:{s:6:"fields";a:1:{s:6:"weight";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:0;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'user.entity_schema_data', 'a:2:{s:5:"users";a:1:{s:11:"primary key";a:1:{i:0;s:3:"uid";}}s:16:"users_field_data";a:3:{s:11:"primary key";a:2:{i:0;s:3:"uid";i:1;s:8:"langcode";}s:7:"indexes";a:1:{s:36:"user__id__default_langcode__langcode";a:3:{i:0;s:3:"uid";i:1;s:16:"default_langcode";i:2;s:8:"langcode";}}s:11:"unique keys";a:1:{s:10:"user__name";a:2:{i:0;s:4:"name";i:1;s:8:"langcode";}}}}'),
('entity.storage_schema.sql', 'user.field_schema_data.access', 'a:1:{s:16:"users_field_data";a:2:{s:6:"fields";a:1:{s:6:"access";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:18:"user_field__access";a:1:{i:0;s:6:"access";}}}}'),
('entity.storage_schema.sql', 'user.field_schema_data.changed', 'a:1:{s:16:"users_field_data";a:1:{s:6:"fields";a:1:{s:7:"changed";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'user.field_schema_data.created', 'a:1:{s:16:"users_field_data";a:2:{s:6:"fields";a:1:{s:7:"created";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:19:"user_field__created";a:1:{i:0;s:7:"created";}}}}'),
('entity.storage_schema.sql', 'user.field_schema_data.default_langcode', 'a:1:{s:16:"users_field_data";a:1:{s:6:"fields";a:1:{s:16:"default_langcode";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'user.field_schema_data.init', 'a:1:{s:16:"users_field_data";a:1:{s:6:"fields";a:1:{s:4:"init";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:254;s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'user.field_schema_data.langcode', 'a:2:{s:5:"users";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}s:16:"users_field_data";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'user.field_schema_data.login', 'a:1:{s:16:"users_field_data";a:1:{s:6:"fields";a:1:{s:5:"login";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'user.field_schema_data.mail', 'a:1:{s:16:"users_field_data";a:2:{s:6:"fields";a:1:{s:4:"mail";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:254;s:8:"not null";b:0;}}s:7:"indexes";a:1:{s:16:"user_field__mail";a:1:{i:0;s:4:"mail";}}}}'),
('entity.storage_schema.sql', 'user.field_schema_data.name', 'a:1:{s:16:"users_field_data";a:1:{s:6:"fields";a:1:{s:4:"name";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:60;s:6:"binary";b:0;s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'user.field_schema_data.pass', 'a:1:{s:16:"users_field_data";a:1:{s:6:"fields";a:1:{s:4:"pass";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'user.field_schema_data.preferred_admin_langcode', 'a:1:{s:16:"users_field_data";a:1:{s:6:"fields";a:1:{s:24:"preferred_admin_langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'user.field_schema_data.preferred_langcode', 'a:1:{s:16:"users_field_data";a:1:{s:6:"fields";a:1:{s:18:"preferred_langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'user.field_schema_data.roles', 'a:1:{s:11:"user__roles";a:4:{s:11:"description";s:34:"Data storage for user field roles.";s:6:"fields";a:7:{s:6:"bundle";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:88:"The field instance bundle to which this row belongs, used when deleting a field instance";}s:7:"deleted";a:5:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:60:"A boolean indicating whether this data item has been deleted";}s:9:"entity_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:38:"The entity id this data is attached to";}s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:114:"The entity revision id this data is attached to, which for an unversioned entity type is the same as the entity id";}s:8:"langcode";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:37:"The language code for this data item.";}s:5:"delta";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:67:"The sequence number for this data item, used for multi-value fields";}s:15:"roles_target_id";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:255;s:8:"not null";b:1;}}s:11:"primary key";a:4:{i:0;s:9:"entity_id";i:1;s:7:"deleted";i:2;s:5:"delta";i:3;s:8:"langcode";}s:7:"indexes";a:3:{s:6:"bundle";a:1:{i:0;s:6:"bundle";}s:11:"revision_id";a:1:{i:0;s:11:"revision_id";}s:15:"roles_target_id";a:1:{i:0;s:15:"roles_target_id";}}}}'),
('entity.storage_schema.sql', 'user.field_schema_data.status', 'a:1:{s:16:"users_field_data";a:1:{s:6:"fields";a:1:{s:6:"status";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'user.field_schema_data.timezone', 'a:1:{s:16:"users_field_data";a:1:{s:6:"fields";a:1:{s:8:"timezone";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:32;s:6:"binary";b:0;s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'user.field_schema_data.uid', 'a:2:{s:5:"users";a:1:{s:6:"fields";a:1:{s:3:"uid";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:16:"users_field_data";a:1:{s:6:"fields";a:1:{s:3:"uid";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'user.field_schema_data.user_picture', 'a:1:{s:18:"user__user_picture";a:5:{s:11:"description";s:41:"Data storage for user field user_picture.";s:6:"fields";a:11:{s:6:"bundle";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:88:"The field instance bundle to which this row belongs, used when deleting a field instance";}s:7:"deleted";a:5:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:60:"A boolean indicating whether this data item has been deleted";}s:9:"entity_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:38:"The entity id this data is attached to";}s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:114:"The entity revision id this data is attached to, which for an unversioned entity type is the same as the entity id";}s:8:"langcode";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:37:"The language code for this data item.";}s:5:"delta";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:67:"The sequence number for this data item, used for multi-value fields";}s:22:"user_picture_target_id";a:4:{s:11:"description";s:26:"The ID of the file entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;}s:16:"user_picture_alt";a:4:{s:11:"description";s:56:"Alternative image text, for the image''s ''alt'' attribute.";s:4:"type";s:7:"varchar";s:6:"length";i:512;s:8:"not null";b:0;}s:18:"user_picture_title";a:4:{s:11:"description";s:52:"Image title text, for the image''s ''title'' attribute.";s:4:"type";s:7:"varchar";s:6:"length";i:1024;s:8:"not null";b:0;}s:18:"user_picture_width";a:4:{s:11:"description";s:33:"The width of the image in pixels.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;}s:19:"user_picture_height";a:4:{s:11:"description";s:34:"The height of the image in pixels.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;}}s:11:"primary key";a:4:{i:0;s:9:"entity_id";i:1;s:7:"deleted";i:2;s:5:"delta";i:3;s:8:"langcode";}s:7:"indexes";a:3:{s:6:"bundle";a:1:{i:0;s:6:"bundle";}s:11:"revision_id";a:1:{i:0;s:11:"revision_id";}s:22:"user_picture_target_id";a:1:{i:0;s:22:"user_picture_target_id";}}s:12:"foreign keys";a:1:{s:22:"user_picture_target_id";a:2:{s:5:"table";s:12:"file_managed";s:7:"columns";a:1:{s:22:"user_picture_target_id";s:3:"fid";}}}}}'),
('entity.storage_schema.sql', 'user.field_schema_data.uuid', 'a:1:{s:5:"users";a:2:{s:6:"fields";a:1:{s:4:"uuid";a:4:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;s:8:"not null";b:1;}}s:11:"unique keys";a:1:{s:23:"user_field__uuid__value";a:1:{i:0;s:4:"uuid";}}}}'),
('post_update', 'existing_updates', 'a:154:{i:0;s:54:"system_post_update_add_description_to_entity_form_mode";i:1;s:54:"system_post_update_add_description_to_entity_view_mode";i:2;s:58:"system_post_update_add_langcode_to_all_translatable_config";i:3;s:47:"system_post_update_amend_config_sync_readme_url";i:4;s:70:"system_post_update_convert_empty_country_and_timezone_settings_to_null";i:5;s:48:"system_post_update_enable_password_compatibility";i:6;s:35:"system_post_update_linkset_settings";i:7;s:44:"system_post_update_mail_notification_setting";i:8;s:38:"system_post_update_mailer_dsn_settings";i:9;s:49:"system_post_update_mailer_structured_dsn_settings";i:10;s:56:"system_post_update_move_development_settings_to_keyvalue";i:11;s:39:"system_post_update_remove_asset_entries";i:12;s:44:"system_post_update_remove_asset_query_string";i:13;s:44:"system_post_update_set_blank_log_url_to_null";i:14;s:54:"system_post_update_set_cron_logging_setting_to_boolean";i:15;s:38:"system_post_update_timestamp_formatter";i:16;s:64:"system_post_update_recalculate_configuration_entity_dependencies";i:17;s:48:"system_post_update_add_region_to_entity_displays";i:18;s:37:"system_post_update_hashes_clear_cache";i:19;s:36:"system_post_update_timestamp_plugins";i:20;s:41:"system_post_update_classy_message_library";i:21;s:37:"system_post_update_field_type_plugins";i:22;s:48:"system_post_update_field_formatter_entity_schema";i:23;s:36:"system_post_update_fix_jquery_extend";i:24;s:40:"system_post_update_change_action_plugins";i:25;s:47:"system_post_update_change_delete_action_plugins";i:26;s:41:"system_post_update_language_item_callback";i:27;s:31:"system_post_update_extra_fields";i:28;s:37:"system_post_update_states_clear_cache";i:29;s:64:"system_post_update_add_expand_all_items_key_in_system_menu_block";i:30;s:35:"system_post_update_clear_menu_cache";i:31;s:46:"system_post_update_layout_plugin_schema_change";i:32;s:60:"system_post_update_entity_reference_autocomplete_match_limit";i:33;s:44:"system_post_update_extra_fields_form_display";i:34;s:39:"system_post_update_uninstall_simpletest";i:35;s:52:"system_post_update_uninstall_entity_reference_module";i:36;s:54:"system_post_update_entity_revision_metadata_bc_cleanup";i:37;s:35:"system_post_update_uninstall_classy";i:38;s:35:"system_post_update_uninstall_stable";i:39;s:44:"system_post_update_claro_dropbutton_variants";i:40;s:37:"system_post_update_schema_version_int";i:41;s:38:"system_post_update_delete_rss_settings";i:42;s:52:"system_post_update_remove_key_value_expire_all_index";i:43;s:44:"system_post_update_service_advisory_settings";i:44;s:44:"system_post_update_delete_authorize_settings";i:45;s:34:"system_post_update_sort_all_config";i:46;s:50:"system_post_update_enable_provider_database_driver";i:47;s:33:"user_post_update_sort_permissions";i:48;s:39:"user_post_update_sort_permissions_again";i:49;s:45:"user_post_update_enforce_order_of_permissions";i:50;s:29:"user_post_update_update_roles";i:51;s:51:"path_alias_post_update_drop_path_alias_status_index";i:52;s:50:"contact_post_update_set_empty_default_form_to_null";i:53;s:62:"contact_post_update_add_message_redirect_field_to_contact_form";i:54;s:41:"help_post_update_add_permissions_to_roles";i:55;s:35:"help_post_update_help_topics_search";i:56;s:38:"help_post_update_help_topics_uninstall";i:57;s:39:"big_pipe_post_update_html5_placeholders";i:58;s:49:"dblog_post_update_convert_recent_messages_to_view";i:59;s:29:"search_post_update_block_page";i:60;s:55:"search_post_update_reindex_after_diacritics_rule_change";i:61;s:54:"block_post_update_disable_blocks_with_missing_contexts";i:62;s:40:"block_post_update_disabled_region_update";i:63;s:42:"block_post_update_fix_negate_in_conditions";i:64;s:45:"block_post_update_replace_node_type_condition";i:65;s:46:"field_post_update_save_custom_storage_property";i:66;s:50:"field_post_update_entity_reference_handler_setting";i:67;s:43:"field_post_update_email_widget_size_setting";i:68;s:47:"field_post_update_remove_handler_submit_setting";i:69;s:44:"filter_post_update_consolidate_filter_config";i:70;s:31:"filter_post_update_sort_filters";i:71;s:32:"text_post_update_allowed_formats";i:72;s:42:"text_post_update_add_required_summary_flag";i:73;s:55:"text_post_update_add_required_summary_flag_form_display";i:74;s:55:"block_content_post_update_block_library_view_permission";i:75;s:51:"block_content_post_update_entity_changed_constraint";i:76;s:51:"block_content_post_update_move_custom_block_library";i:77;s:39:"block_content_post_update_revision_type";i:78;s:42:"block_content_post_update_sort_permissions";i:79;s:51:"block_content_post_update_add_views_reusable_filter";i:80;s:59:"node_post_update_set_node_type_description_and_help_to_null";i:81;s:46:"node_post_update_configure_status_field_widget";i:82;s:41:"node_post_update_node_revision_views_data";i:83;s:40:"node_post_update_glossary_view_published";i:84;s:45:"node_post_update_rebuild_node_revision_routes";i:85;s:50:"node_post_update_modify_base_field_author_override";i:86;s:64:"file_post_update_add_default_filename_sanitization_configuration";i:87;s:41:"file_post_update_add_permissions_to_roles";i:88;s:54:"file_post_update_add_txt_if_allows_insecure_extensions";i:89;s:34:"editor_post_update_image_lazy_load";i:90;s:49:"editor_post_update_sanitize_image_upload_settings";i:91;s:56:"editor_post_update_clear_cache_for_file_reference_filter";i:92;s:32:"ckeditor5_post_update_code_block";i:93;s:40:"ckeditor5_post_update_image_toolbar_item";i:94;s:37:"ckeditor5_post_update_list_multiblock";i:95;s:41:"ckeditor5_post_update_list_start_reversed";i:96;s:51:"ckeditor5_post_update_plugins_settings_export_order";i:97;s:39:"ckeditor5_post_update_alignment_buttons";i:98;s:45:"comment_post_update_enable_comment_admin_view";i:99;s:42:"comment_post_update_add_ip_address_setting";i:100;s:48:"contextual_post_update_fixed_endpoint_and_markup";i:101;s:37:"taxonomy_post_update_set_new_revision";i:102;s:55:"taxonomy_post_update_set_vocabulary_description_to_null";i:103;s:43:"taxonomy_post_update_clear_views_data_cache";i:104;s:64:"taxonomy_post_update_clear_entity_bundle_field_definitions_cache";i:105;s:63:"taxonomy_post_update_handle_publishing_status_addition_in_views";i:106;s:55:"taxonomy_post_update_remove_hierarchy_from_vocabularies";i:107;s:52:"taxonomy_post_update_make_taxonomy_term_revisionable";i:108;s:50:"taxonomy_post_update_configure_status_field_widget";i:109;s:65:"taxonomy_post_update_clear_views_argument_validator_plugins_cache";i:110;s:42:"image_post_update_image_style_dependencies";i:111;s:50:"image_post_update_scale_and_crop_effect_add_anchor";i:112;s:41:"image_post_update_image_loading_attribute";i:113;s:36:"views_post_update_add_missing_labels";i:114;s:39:"views_post_update_boolean_custom_titles";i:115;s:38:"views_post_update_fix_revision_id_part";i:116;s:35:"views_post_update_oembed_eager_load";i:117;s:31:"views_post_update_pager_heading";i:118;s:50:"views_post_update_remove_default_argument_skip_url";i:119;s:43:"views_post_update_remove_skip_cache_setting";i:120;s:54:"views_post_update_rendered_entity_field_cache_metadata";i:121;s:44:"views_post_update_responsive_image_lazy_load";i:122;s:46:"views_post_update_taxonomy_filter_user_context";i:123;s:37:"views_post_update_timestamp_formatter";i:124;s:47:"views_post_update_views_data_argument_plugin_id";i:125;s:46:"views_post_update_update_cacheability_metadata";i:126;s:46:"views_post_update_cleanup_duplicate_views_data";i:127;s:46:"views_post_update_field_formatter_dependencies";i:128;s:36:"views_post_update_taxonomy_index_tid";i:129;s:41:"views_post_update_serializer_dependencies";i:130;s:39:"views_post_update_boolean_filter_values";i:131;s:33:"views_post_update_grouped_filters";i:132;s:42:"views_post_update_revision_metadata_fields";i:133;s:33:"views_post_update_entity_link_url";i:134;s:34:"views_post_update_bulk_field_moved";i:135;s:41:"views_post_update_filter_placeholder_text";i:136;s:47:"views_post_update_views_data_table_dependencies";i:137;s:45:"views_post_update_table_display_cache_max_age";i:138;s:53:"views_post_update_exposed_filter_blocks_label_display";i:139;s:48:"views_post_update_make_placeholders_translatable";i:140;s:41:"views_post_update_limit_operator_defaults";i:141;s:33:"views_post_update_remove_core_key";i:142;s:51:"views_post_update_field_names_for_multivalue_fields";i:143;s:52:"views_post_update_configuration_entity_relationships";i:144;s:48:"views_post_update_rename_default_display_setting";i:145;s:50:"views_post_update_remove_sorting_global_text_field";i:146;s:36:"views_post_update_title_translations";i:147;s:33:"views_post_update_sort_identifier";i:148;s:53:"views_post_update_provide_revision_table_relationship";i:149;s:33:"views_post_update_image_lazy_load";i:150;s:65:"menu_link_content_post_update_make_menu_link_content_revisionable";i:151;s:49:"path_post_update_create_language_content_settings";i:152;s:45:"olivero_post_update_add_olivero_primary_color";i:153;s:46:"update_post_update_set_blank_fetch_url_to_null";}'),
('state', 'announcements_feed.last_fetch', 'i:[[timestamp]];'),
('state', 'asset.css_js_query_string', '[[css_js_query_string]]'),
('state', 'comment.maintain_entity_statistics', 'b:1;'),
('state', 'comment.node_comment_statistics_scale', 'd:1;'),
('state', 'help_search_unindexed_count', 's:1:"0";'),
('state', 'install_task', 's:4:"done";'),
('state', 'install_time', 'i:[[timestamp]];'),
('state', 'node.min_max_update_time', 'a:2:{s:11:"min_created";N;s:11:"max_created";N;}'),
('state', 'router.path_roots', 'a:31:{i:0;s:5:"admin";i:1;s:8:"big_pipe";i:2;s:14:"block-category";i:3;s:5:"block";i:4;s:9:"ckeditor5";i:5;s:7:"comment";i:6;s:8:"comments";i:7;s:7:"contact";i:8;s:4:"user";i:9;s:10:"contextual";i:10;s:6:"editor";i:11;s:4:"file";i:12;s:6:"filter";i:13;s:7:"history";i:14;s:5:"sites";i:15;s:6:"system";i:16;s:4:"node";i:17;s:6:"search";i:18;s:4:"cron";i:19;s:12:"machine_name";i:20;s:0:"";i:21;s:9:"<current>";i:22;s:5:"batch";i:23;s:10:"update.php";i:24;s:29:"entity_reference_autocomplete";i:25;s:7:"session";i:26;s:8:"taxonomy";i:27;s:7:"toolbar";i:28;s:11:".well-known";i:29;s:7:"rss.xml";i:30;s:5:"views";}'),
('state', 'routing.menu_masks.router', 'a:46:{i:0;i:501;i:1;i:500;i:2;i:493;i:3;i:492;i:4;i:464;i:5;i:253;i:6;i:252;i:7;i:251;i:8;i:250;i:9;i:247;i:10;i:246;i:11;i:245;i:12;i:244;i:13;i:232;i:14;i:126;i:15;i:125;i:16;i:124;i:17;i:123;i:18;i:122;i:19;i:117;i:20;i:116;i:21;i:63;i:22;i:62;i:23;i:61;i:24;i:60;i:25;i:53;i:26;i:49;i:27;i:42;i:28;i:31;i:29;i:30;i:30;i:29;i:31;i:28;i:32;i:24;i:33;i:21;i:34;i:15;i:35;i:14;i:36;i:13;i:37;i:12;i:38;i:11;i:39;i:8;i:40;i:7;i:41;i:6;i:42;i:5;i:43;i:3;i:44;i:2;i:45;i:1;}'),
('state', 'routing.non_admin_routes', 'a:97:{i:0;s:13:"big_pipe.nojs";i:1;s:27:"block.category_autocomplete";i:2;s:22:"block_content.add_page";i:3;s:22:"block_content.add_form";i:4;s:33:"entity.block_content.edit_form.bc";i:5;s:35:"entity.block_content.delete_form.bc";i:6;s:31:"ckeditor5.media_entity_metadata";i:7;s:24:"entity.comment.edit_form";i:8;s:15:"comment.approve";i:9;s:24:"entity.comment.canonical";i:10;s:26:"entity.comment.delete_form";i:11;s:13:"comment.reply";i:12;s:31:"comment.new_comments_node_links";i:13;s:21:"comment.node_redirect";i:14;s:17:"contact.site_page";i:15;s:29:"entity.contact_form.canonical";i:16;s:24:"entity.user.contact_form";i:17;s:17:"contextual.render";i:18;s:17:"editor.filter_xss";i:19;s:19:"editor.image_dialog";i:20;s:18:"editor.link_dialog";i:21;s:18:"file.ajax_progress";i:22;s:15:"filter.tips_all";i:23;s:11:"filter.tips";i:24;s:26:"history.get_last_node_view";i:25;s:17:"history.read_node";i:26;s:18:"image.style_public";i:27;s:19:"image.style_private";i:28;s:13:"node.add_page";i:29;s:8:"node.add";i:30;s:19:"entity.node.preview";i:31;s:27:"entity.node.version_history";i:32;s:20:"entity.node.revision";i:33;s:28:"node.revision_revert_confirm";i:34;s:40:"node.revision_revert_translation_confirm";i:35;s:28:"node.revision_delete_confirm";i:36;s:11:"search.view";i:37;s:23:"search.view_help_search";i:38;s:23:"search.help_help_search";i:39;s:23:"search.view_node_search";i:40;s:23:"search.help_node_search";i:41;s:23:"search.view_user_search";i:42;s:23:"search.help_user_search";i:43;s:19:"shortcut.set_switch";i:44;s:16:"system.css_asset";i:45;s:15:"system.js_asset";i:46;s:10:"system.401";i:47;s:10:"system.403";i:48;s:10:"system.404";i:49;s:10:"system.4xx";i:50;s:11:"system.cron";i:51;s:33:"system.machine_name_transliterate";i:52;s:12:"system.files";i:53;s:28:"system.private_file_download";i:54;s:16:"system.temporary";i:55;s:7:"<front>";i:56;s:6:"<none>";i:57;s:8:"<nolink>";i:58;s:8:"<button>";i:59;s:9:"<current>";i:60;s:15:"system.timezone";i:61;s:22:"system.batch_page.html";i:62;s:16:"system.db_update";i:63;s:26:"system.entity_autocomplete";i:64;s:16:"system.csrftoken";i:65;s:30:"entity.taxonomy_term.edit_form";i:66;s:32:"entity.taxonomy_term.delete_form";i:67;s:16:"toolbar.subtrees";i:68;s:13:"user.register";i:69;s:11:"user.logout";i:70;s:19:"user.logout.confirm";i:71;s:9:"user.pass";i:72;s:9:"user.page";i:73;s:9:"user.edit";i:74;s:10:"user.login";i:75;s:19:"user.cancel_confirm";i:76;s:16:"user.reset.login";i:77;s:10:"user.reset";i:78;s:15:"user.reset.form";i:79;s:31:"user.well-known.change_password";i:80;s:21:"view.frontpage.feed_1";i:81;s:21:"view.frontpage.page_1";i:82;s:25:"view.taxonomy_term.feed_1";i:83;s:25:"view.taxonomy_term.page_1";i:84;s:10:"views.ajax";i:85;s:23:"entity.file.delete_form";i:86;s:21:"entity.node.canonical";i:87;s:23:"entity.node.delete_form";i:88;s:21:"entity.node.edit_form";i:89;s:36:"entity.taxonomy_term.version_history";i:90;s:29:"entity.taxonomy_term.revision";i:91;s:41:"entity.taxonomy_term.revision_revert_form";i:92;s:41:"entity.taxonomy_term.revision_delete_form";i:93;s:21:"entity.user.canonical";i:94;s:21:"entity.user.edit_form";i:95;s:23:"entity.user.cancel_form";i:96;s:30:"entity.taxonomy_term.canonical";}'),
('state', 'system.cron_key', '[[system_cron_key]]'),
('state', 'system.cron_last', 'i:[[timestamp]];'),
('state', 'system.private_key', '[[system_private_key]]'),
('state', 'system.profile.files', 'a:17:{s:10:"demo_umami";s:44:"core/profiles/demo_umami/demo_umami.info.yml";s:7:"minimal";s:38:"core/profiles/minimal/minimal.info.yml";s:23:"nightwatch_a11y_testing";s:70:"core/profiles/nightwatch_a11y_testing/nightwatch_a11y_testing.info.yml";s:18:"nightwatch_testing";s:60:"core/profiles/nightwatch_testing/nightwatch_testing.info.yml";s:8:"standard";s:40:"core/profiles/standard/standard.info.yml";s:25:"test_language_negotiation";s:74:"core/profiles/test_language_negotiation/test_language_negotiation.info.yml";s:7:"testing";s:38:"core/profiles/testing/testing.info.yml";s:21:"testing_config_import";s:66:"core/profiles/testing_config_import/testing_config_import.info.yml";s:24:"testing_config_overrides";s:72:"core/profiles/testing_config_overrides/testing_config_overrides.info.yml";s:40:"testing_install_profile_all_dependencies";s:104:"core/profiles/testing_install_profile_all_dependencies/testing_install_profile_all_dependencies.info.yml";s:36:"testing_install_profile_dependencies";s:96:"core/profiles/testing_install_profile_dependencies/testing_install_profile_dependencies.info.yml";s:28:"testing_missing_dependencies";s:80:"core/profiles/testing_missing_dependencies/testing_missing_dependencies.info.yml";s:20:"testing_multilingual";s:64:"core/profiles/testing_multilingual/testing_multilingual.info.yml";s:33:"testing_multilingual_with_english";s:90:"core/profiles/testing_multilingual_with_english/testing_multilingual_with_english.info.yml";s:20:"testing_requirements";s:64:"core/profiles/testing_requirements/testing_requirements.info.yml";s:19:"testing_site_config";s:62:"core/profiles/testing_site_config/testing_site_config.info.yml";s:21:"testing_themes_blocks";s:66:"core/profiles/testing_themes_blocks/testing_themes_blocks.info.yml";}'),
('state', 'system.theme.files', 'a:5:{s:5:"claro";s:32:"core/themes/claro/claro.info.yml";s:7:"olivero";s:36:"core/themes/olivero/olivero.info.yml";s:7:"stable9";s:36:"core/themes/stable9/stable9.info.yml";s:5:"stark";s:32:"core/themes/stark/stark.info.yml";s:16:"starterkit_theme";s:54:"core/themes/starterkit_theme/starterkit_theme.info.yml";}'),
('state', 'twig_extension_hash_prefix', 'a:2:{s:19:"twig_extension_hash";s:0:"";s:17:"twig_cache_prefix";s:0:"";}'),
('state', 'update.last_check', 'i:[[timestamp]];'),
('state', 'views.view_route_names', 'a:12:{s:13:"watchdog.page";s:14:"dblog.overview";s:24:"user_admin_people.page_1";s:22:"entity.user.collection";s:20:"taxonomy_term.page_1";s:30:"entity.taxonomy_term.canonical";s:14:"content.page_1";s:20:"system.admin_content";s:23:"comment.page_unapproved";s:22:"comment.admin_approval";s:22:"comment.page_published";s:13:"comment.admin";s:20:"block_content.page_1";s:31:"entity.block_content.collection";s:12:"files.page_1";s:17:"view.files.page_1";s:12:"files.page_2";s:17:"view.files.page_2";s:16:"frontpage.feed_1";s:21:"view.frontpage.feed_1";s:16:"frontpage.page_1";s:21:"view.frontpage.page_1";s:20:"taxonomy_term.feed_1";s:25:"view.taxonomy_term.feed_1";}'),
('system.schema', 'announcements_feed', 'i:8000;'),
('system.schema', 'automated_cron', 'i:8000;'),
('system.schema', 'big_pipe', 'i:8000;'),
('system.schema', 'block', 'i:8003;'),
('system.schema', 'block_content', 'i:10300;'),
('system.schema', 'breakpoint', 'i:8000;'),
('system.schema', 'ckeditor5', 'i:8000;'),
('system.schema', 'comment', 'i:10100;'),
('system.schema', 'config', 'i:8000;'),
('system.schema', 'contact', 'i:8000;'),
('system.schema', 'contextual', 'i:8000;'),
('system.schema', 'datetime', 'i:8000;'),
('system.schema', 'dblog', 'i:10101;'),
('system.schema', 'dynamic_page_cache', 'i:8000;'),
('system.schema', 'editor', 'i:8001;'),
('system.schema', 'field', 'i:8500;'),
('system.schema', 'field_ui', 'i:8000;'),
('system.schema', 'file', 'i:8700;'),
('system.schema', 'filter', 'i:8000;'),
('system.schema', 'help', 'i:10200;'),
('system.schema', 'history', 'i:10100;'),
('system.schema', 'image', 'i:8201;'),
('system.schema', 'link', 'i:8000;'),
('system.schema', 'menu_link_content', 'i:8601;'),
('system.schema', 'menu_ui', 'i:8000;'),
('system.schema', 'mysql', 'i:8000;'),
('system.schema', 'node', 'i:8700;'),
('system.schema', 'options', 'i:8000;'),
('system.schema', 'page_cache', 'i:8000;'),
('system.schema', 'path', 'i:8200;'),
('system.schema', 'path_alias', 'i:8000;'),
('system.schema', 'search', 'i:8000;'),
('system.schema', 'shortcut', 'i:8000;'),
('system.schema', 'standard', 'i:8000;'),
('system.schema', 'system', 'i:10600;'),
('system.schema', 'taxonomy', 'i:10100;'),
('system.schema', 'text', 'i:8000;'),
('system.schema', 'toolbar', 'i:8000;'),
('system.schema', 'update', 'i:8001;'),
('system.schema', 'user', 'i:10000;'),
('system.schema', 'views', 'i:8500;'),
('system.schema', 'views_ui', 'i:8000;');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]key_value_expire`
--

CREATE TABLE `[[dbprefix]]key_value_expire` (
  `collection` varchar(128) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'A named collection of key and value pairs.',
  `name` varchar(128) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'The key of the key/value pair.',
  `value` longblob NOT NULL COMMENT 'The value of the key/value pair.',
  `expire` int(11) NOT NULL DEFAULT '2147483647' COMMENT 'The time since Unix epoch in seconds when this item expires. Defaults to the maximum possible time.',
  PRIMARY KEY (`collection`,`name`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Generic key/value storage table with an expiration.';

--
-- Dumping data for table `[[dbprefix]]key_value_expire`
--

INSERT INTO `[[dbprefix]]key_value_expire` VALUES
('announcements_feed', 'announcements', 'a:19:{i:0;a:7:{s:2:"id";s:7:"3561543";s:5:"title";s:71:"Drupal Canvas is Now Available: Inside Drupal''s New Visual Page Builder";s:12:"content_html";s:451:"<p><img alt="" height="428" src="/files/Canvas%20graphic.png" width="816" /></p>\n<p>For years, Drupal has been the platform of choice for organizations that need serious digital capabilities—think universities managing millions of pages, government agencies with complex workflows, and Fortune 500 companies running mission-critical websites. The power is undeniable, but there''s always been a catch: you needed technical expertise to unlock it.</p>";s:3:"url";s:97:"https://www.drupal.org/blog/drupal-canvas-is-now-available-inside-drupals-new-visual-page-builder";s:13:"date_modified";s:25:"2025-12-04T22:08:46+00:00";s:14:"date_published";s:25:"2025-12-04T18:24:05+00:00";s:10:"_drupalorg";a:2:{s:8:"featured";b:0;s:7:"version";s:3:">=7";}}i:1;a:7:{s:2:"id";s:7:"3548048";s:5:"title";s:54:"DrupalCon Chicago 2026: Your Stage to Shape the Future";s:12:"content_html";s:270:"<p id="docs-internal-guid-a810d194-7fff-97e4-cc43-6d2b9095cdb4"><em>March 23–26, 2026 | Chicago, IL</em></p>\n<p>Chicago isn''t just hosting DrupalCon 2026—it''s providing the stage where the Drupal community writes its next chapter. And that story starts with you.</p>";s:3:"url";s:101:"https://www.drupal.org/about/announcements/blog/drupalcon-chicago-2026-your-stage-to-shape-the-future";s:13:"date_modified";s:25:"2025-09-22T20:30:38+00:00";s:14:"date_published";s:25:"2025-09-22T20:30:38+00:00";s:10:"_drupalorg";a:2:{s:8:"featured";b:0;s:7:"version";s:3:">=7";}}i:2;a:7:{s:2:"id";s:7:"3546850";s:5:"title";s:76:"DrupalCon Nara 2025: Building Tomorrow in One of Japan''s Most Ancient Cities";s:12:"content_html";s:389:"<p id="docs-internal-guid-cfdebe19-7fff-3b3b-ba27-bc768674ee8c"><em>November 17–19, 2025 | Nara, Japan</em></p>\n<p>The energy is building in Asia. Following July''s groundbreaking first-ever Contribution Day in Tokyo—where developers, translators, and UX experts came together to push Drupal forward—that momentum is heading straight to one of Japan''s most culturally rich cities.</p>";s:3:"url";s:122:"https://www.drupal.org/about/announcements/blog/drupalcon-nara-2025-building-tomorrow-in-one-of-japans-most-ancient-cities";s:13:"date_modified";s:25:"2025-09-15T21:58:39+00:00";s:14:"date_published";s:25:"2025-09-15T21:58:39+00:00";s:10:"_drupalorg";a:2:{s:8:"featured";b:0;s:7:"version";s:3:">=7";}}i:3;a:7:{s:2:"id";s:7:"3545545";s:5:"title";s:93:"DrupalCon Vienna 2025: Where Digital Ambitions Meet Community Innovation - Will you be there?";s:12:"content_html";s:363:"<p id="docs-internal-guid-76ec9440-7fff-0ce8-e907-506bc36a1f27"><em id="docs-internal-guid-ab650729-7fff-376e-b6bd-e2a6b4a06c58">October 14–17, 2025 | Austria Center Vienna</em></p>\n<p>Vienna is calling the global Drupal community home this October, and we can''t wait to see what happens when ambitious minds gather in one of Europe''s most inspiring cities.</p>";s:3:"url";s:137:"https://www.drupal.org/about/announcements/blog/drupalcon-vienna-2025-where-digital-ambitions-meet-community-innovation-will-you-be-there";s:13:"date_modified";s:25:"2025-09-08T20:20:15+00:00";s:14:"date_published";s:25:"2025-09-08T20:19:27+00:00";s:10:"_drupalorg";a:2:{s:8:"featured";b:0;s:7:"version";s:3:">=7";}}i:4;a:7:{s:2:"id";s:7:"3530875";s:5:"title";s:30:"Drupal 11.2.0 is now available";s:12:"content_html";s:324:"<p>The <a href="https://www.drupal.org/project/drupal/releases/11.2.0">second feature release of Drupal 11</a> improves backend and frontend performance and scalability, completes the introduction of OOP support of hooks, adds JSON Schema support, includes AVIF image format capability, supports SDC variants, and more.</p>\n";s:3:"url";s:41:"https://www.drupal.org/blog/drupal-11-2-0";s:13:"date_modified";s:25:"2025-07-17T01:20:03+00:00";s:14:"date_published";s:25:"2025-06-19T05:05:25+00:00";s:10:"_drupalorg";a:2:{s:8:"featured";b:0;s:7:"version";s:1:"*";}}i:5;a:7:{s:2:"id";s:7:"3516956";s:5:"title";s:41:"State of Drupal presentation (March 2025)";s:12:"content_html";s:459:"<p>Three months ago, <a href="https://dri.es/drupal-cms-1-released">we launched Drupal CMS 1.0</a>, our biggest step forward in years. Our goal is ambitious: to <a href="https://dri.es/introducing-drupal-starshot-product-strategy">reimagine Drupal</a> as both radically easier to use and a platform for faster innovation.</p>\n<p>In Dries'' DrupalCon Atlanta keynote last week, he reflected on the journey so far, but mostly talked about the work ahead.</p>\n";s:3:"url";s:87:"https://www.drupal.org/about/announcements/blog/state-of-drupal-presentation-march-2025";s:13:"date_modified";s:25:"2025-04-07T17:05:05+00:00";s:14:"date_published";s:25:"2025-04-02T18:27:47+00:00";s:10:"_drupalorg";a:2:{s:8:"featured";b:0;s:7:"version";s:3:">=7";}}i:6;a:7:{s:2:"id";s:7:"3509234";s:5:"title";s:48:"DrupalCon Atlanta is almost here! 24-27 of March";s:12:"content_html";s:444:"<p>DrupalCon is an exciting and invaluable event for anyone involved in the Drupal community, whether you’re a developer, website owner, or digital professional. If you’re heading to <a href="https://events.drupal.org/atlanta2025" rel="nofollow">DrupalCon Atlanta 2025</a> for the first time, you’re in for a treat! Here''s everything you need to know to make the most of your experience, along with some top tips for how to prepare.</p>";s:3:"url";s:95:"https://www.drupal.org/about/announcements/blog/drupalcon-atlanta-is-almost-here-24-27-of-march";s:13:"date_modified";s:25:"2025-02-26T20:33:54+00:00";s:14:"date_published";s:25:"2025-02-26T20:33:27+00:00";s:10:"_drupalorg";a:2:{s:8:"featured";b:0;s:7:"version";s:3:">=7";}}i:7;a:7:{s:2:"id";s:7:"3499892";s:5:"title";s:32:"Drupal CMS 1.0 is now available!";s:12:"content_html";s:436:"<p>We’re excited to share that Drupal CMS 1.0 has officially launched! This new platform is designed to make it easier than ever for marketers and content teams to create amazing digital experiences, all while staying true to Drupal’s open-source roots.</p>\n<p><img alt="Getting started takes minutes" height="720" src="/files/CMS1-1_1.png" width="1280" /></p>\n<p>Drupal CMS 1.0 is packed with features to make your life easier:</p>";s:3:"url";s:42:"https://www.drupal.org/blog/drupal-cms-1-0";s:13:"date_modified";s:25:"2025-01-15T18:40:24+00:00";s:14:"date_published";s:25:"2025-01-15T17:00:28+00:00";s:10:"_drupalorg";a:2:{s:8:"featured";b:0;s:7:"version";s:2:">7";}}i:9;a:7:{s:2:"id";s:7:"3494304";s:5:"title";s:30:"Drupal 11.1.0 is now available";s:12:"content_html";s:263:"<p>The <a href="https://www.drupal.org/project/drupal/releases/11.1.0" rel="nofollow">first feature release of Drupal 11</a> improves the recipe system, introduces support for hooks written as classes, makes Workspaces more flexible and enhances performance.</p>";s:3:"url";s:41:"https://www.drupal.org/blog/drupal-11-1-0";s:13:"date_modified";s:25:"2024-12-16T20:28:53+00:00";s:14:"date_published";s:25:"2024-12-16T17:50:29+00:00";s:10:"_drupalorg";a:2:{s:8:"featured";b:0;s:7:"version";s:5:">=7.0";}}i:11;a:7:{s:2:"id";s:7:"3480615";s:5:"title";s:58:"DrupalCon Singapore 2024: What Awaits You in the Lion City";s:12:"content_html";s:528:"<p>It’s time to dust off those suitcases and start thinking about where your passport is - <a href="https://events.drupal.org/singapore2024" rel="nofollow">DrupalCon Singapore 2024</a> is just around the corner, and this year’s event promises to be amazing! From 9-11 December, our much-anticipated event will bring together the brightest minds and most passionate contributors from the Drupal community for three days of innovation, learning, and inspiration at the luxurious Parkroyal Collection Marina Bay, Singapore.</p>";s:3:"url";s:105:"https://www.drupal.org/about/announcements/blog/drupalcon-singapore-2024-what-awaits-you-in-the-lion-city";s:13:"date_modified";s:25:"2024-10-14T16:49:44+00:00";s:14:"date_published";s:25:"2024-10-14T16:49:44+00:00";s:10:"_drupalorg";a:2:{s:8:"featured";b:0;s:7:"version";s:5:">=7.0";}}i:12;a:7:{s:2:"id";s:7:"3465580";s:5:"title";s:18:"Drupal 11 released";s:12:"content_html";s:114:"<p>Today is a big day for <a href="https://www.drupal.org/">Drupal</a> as we officially released Drupal 11!</p>\n";s:3:"url";s:46:"https://www.drupal.org/blog/drupal-11-released";s:13:"date_modified";s:25:"2024-08-15T15:10:39+00:00";s:14:"date_published";s:25:"2024-08-01T22:57:58+00:00";s:10:"_drupalorg";a:2:{s:8:"featured";b:0;s:7:"version";s:1:"*";}}i:13;a:7:{s:2:"id";s:7:"3456034";s:5:"title";s:28:"Drupal 10.3 is now available";s:12:"content_html";s:370:"<p>The <a href="https://www.drupal.org/project/drupal/releases/10.3.0" rel="nofollow">third and final feature release of Drupal 10</a> ships with a new experimental Navigation user interface, stable Workspaces functionality, stable Single-Directory Components support, simplified menu editing, taxonomy moderation support, new recipe and access policy APIs and more.</p>";s:3:"url";s:41:"https://www.drupal.org/blog/drupal-10-3-0";s:13:"date_modified";s:25:"2024-09-05T23:00:47+00:00";s:14:"date_published";s:25:"2024-06-20T20:00:04+00:00";s:10:"_drupalorg";a:2:{s:8:"featured";b:0;s:7:"version";s:5:">=7.0";}}i:15;a:7:{s:2:"id";s:7:"3427138";s:5:"title";s:52:"You''re invited to DrupalCon Portland | 6-9 May, 2024";s:12:"content_html";s:384:"<p>DrupalCon is an event for developers, marketers/content editors, site owners, and the Drupal-curious to join with the community. You''ll find incredible keynotes, session content from expert speakers who have helped to build Drupal, networking opportunities with your peers, fun social events, and the chance to deepen your connection by contributing to the open source project.</p>";s:3:"url";s:96:"https://www.drupal.org/about/announcements/blog/youre-invited-to-drupalcon-portland-6-9-may-2024";s:13:"date_modified";s:25:"2024-03-18T19:40:04+00:00";s:14:"date_published";s:25:"2024-03-11T16:49:53+00:00";s:10:"_drupalorg";a:2:{s:8:"featured";b:0;s:7:"version";s:5:">=7.0";}}i:16;a:7:{s:2:"id";s:7:"3408836";s:5:"title";s:28:"Drupal 10.2 is now available";s:12:"content_html";s:378:"<p>The <a href="https://www.drupal.org/project/drupal/releases/10.2.0">second feature release of Drupal 10</a> improves content modeling, block management, menu and taxonomy organization, and permission administration. New options to sanitize file names make it possible to clean up the names of uploaded files, and media item revisions now have a dedicated user interface.</p>\n";s:3:"url";s:41:"https://www.drupal.org/blog/drupal-10-2-0";s:13:"date_modified";s:25:"2024-01-25T18:24:28+00:00";s:14:"date_published";s:25:"2023-12-15T18:27:47+00:00";s:10:"_drupalorg";a:2:{s:8:"featured";b:0;s:7:"version";s:5:">=7.0";}}i:17;a:7:{s:2:"id";s:7:"3403229";s:5:"title";s:75:"Drupal 10 will be supported until the release of Drupal 12 in mid-late 2026";s:12:"content_html";s:190:"<p>Announcing a new major release schedule with long term support for Drupal 10 until mid-late 2026. Drupal 11 will be released in 2024 and work on the dedicated branch starts this week.</p>";s:3:"url";s:103:"https://www.drupal.org/blog/drupal-10-will-be-supported-until-the-release-of-drupal-12-in-mid-late-2026";s:13:"date_modified";s:25:"2024-01-25T18:31:05+00:00";s:14:"date_published";s:25:"2023-11-22T07:13:55+00:00";s:10:"_drupalorg";a:2:{s:8:"featured";b:0;s:7:"version";s:5:">=7.0";}}i:19;a:7:{s:2:"id";s:7:"3368367";s:5:"title";s:28:"Drupal 10.1 is now available";s:12:"content_html";s:257:"<p>This first feature release of Drupal 10 is packed with amazing improvements! It makes customizing the look of your site easier, adds support for decoupled navigation, improves content modeling and editing, block management, performance and many more.</p>";s:3:"url";s:41:"https://www.drupal.org/blog/drupal-10-1-0";s:13:"date_modified";s:25:"2023-10-30T16:22:24+00:00";s:14:"date_published";s:25:"2023-06-22T09:11:30+00:00";s:10:"_drupalorg";a:2:{s:8:"featured";b:0;s:7:"version";s:5:">=7.0";}}i:20;a:7:{s:2:"id";s:7:"3347976";s:5:"title";s:37:"Contribute to Drupal and the Open Web";s:12:"content_html";s:146:"<p>Drupal is an open source project. But what does that mean? How can you as a site-owner participate in the project of building a better web?</p>";s:3:"url";s:85:"https://www.drupal.org/about/announcements/blog/contribute-to-drupal-and-the-open-web";s:13:"date_modified";s:25:"2023-03-14T19:43:12+00:00";s:14:"date_published";s:25:"2023-03-14T19:39:44+00:00";s:10:"_drupalorg";a:2:{s:8:"featured";b:0;s:7:"version";s:5:">=7.0";}}i:21;a:7:{s:2:"id";s:7:"3343486";s:5:"title";s:43:"What to expect from the Announcements feed?";s:12:"content_html";s:197:"<p>Drupal is introducing a new project Announcements feature so that you can see news and updates about the Drupal project and community directly in your Drupal dashboard. Learn what to expect.</p>";s:3:"url";s:90:"https://www.drupal.org/about/announcements/blog/what-to-expect-from-the-announcements-feed";s:13:"date_modified";s:25:"2023-02-21T19:45:53+00:00";s:14:"date_published";s:25:"2023-02-21T19:45:53+00:00";s:10:"_drupalorg";a:2:{s:8:"featured";b:0;s:7:"version";s:5:">=7.0";}}i:22;a:7:{s:2:"id";s:7:"3327047";s:5:"title";s:26:"Drupal 10.0.0 is available";s:12:"content_html";s:296:"<p>Thanks to 2129 contributors from 616 organizations resolving 4083 issues in the past two and a half years, Drupal 10.0.0 is available today! This new version sets Drupal up for continued stability and security for the longer term. All new features will be added to Drupal 10 going forward.</p>";s:3:"url";s:41:"https://www.drupal.org/blog/drupal-10-0-0";s:13:"date_modified";s:25:"2023-10-30T16:21:38+00:00";s:14:"date_published";s:25:"2022-12-15T17:43:23+00:00";s:10:"_drupalorg";a:2:{s:8:"featured";b:0;s:7:"version";s:5:">=7.0";}}}', [[timestamp_nextday]]),
('system', 'advisories_response', 'a:0:{}', [[timestamp]]),
('update', 'fetch_failures', 'N;', [[timestamp]]),
('update', 'update_project_data', 'a:1:{s:6:"drupal";a:16:{s:4:"name";s:6:"drupal";s:4:"info";a:6:{s:4:"name";s:13:"Announcements";s:7:"package";s:4:"Core";s:7:"version";s:6:"10.6.0";s:7:"project";s:6:"drupal";s:9:"datestamp";i:1765965804;s:16:"_info_file_ctime";i:[[timestamp]];}s:9:"datestamp";i:1765965804;s:8:"includes";a:44:{s:18:"announcements_feed";s:13:"Announcements";s:14:"automated_cron";s:14:"Automated Cron";s:8:"big_pipe";s:7:"BigPipe";s:5:"block";s:5:"Block";s:13:"block_content";s:13:"Block Content";s:10:"breakpoint";s:10:"Breakpoint";s:9:"ckeditor5";s:10:"CKEditor 5";s:7:"comment";s:7:"Comment";s:6:"config";s:21:"Configuration Manager";s:7:"contact";s:7:"Contact";s:10:"contextual";s:16:"Contextual Links";s:8:"datetime";s:8:"Datetime";s:5:"dblog";s:16:"Database Logging";s:18:"dynamic_page_cache";s:27:"Internal Dynamic Page Cache";s:6:"editor";s:11:"Text Editor";s:5:"field";s:5:"Field";s:8:"field_ui";s:8:"Field UI";s:4:"file";s:4:"File";s:6:"filter";s:6:"Filter";s:4:"help";s:4:"Help";s:7:"history";s:7:"History";s:5:"image";s:5:"Image";s:4:"link";s:4:"Link";s:17:"menu_link_content";s:17:"Custom Menu Links";s:7:"menu_ui";s:7:"Menu UI";s:5:"mysql";s:5:"MySQL";s:4:"node";s:4:"Node";s:7:"options";s:7:"Options";s:10:"page_cache";s:19:"Internal Page Cache";s:4:"path";s:4:"Path";s:10:"path_alias";s:10:"Path alias";s:6:"search";s:6:"Search";s:8:"shortcut";s:8:"Shortcut";s:6:"system";s:6:"System";s:8:"taxonomy";s:8:"Taxonomy";s:4:"text";s:4:"Text";s:7:"toolbar";s:7:"Toolbar";s:6:"update";s:14:"Update Manager";s:4:"user";s:4:"User";s:5:"views";s:5:"Views";s:8:"views_ui";s:8:"Views UI";s:8:"standard";s:8:"Standard";s:5:"claro";s:5:"Claro";s:7:"olivero";s:7:"Olivero";}s:12:"project_type";s:4:"core";s:14:"project_status";b:1;s:16:"existing_version";s:6:"10.6.0";s:14:"existing_major";s:2:"10";s:12:"install_type";s:8:"official";s:5:"title";s:11:"Drupal core";s:4:"link";s:37:"https://www.drupal.org/project/drupal";s:4:"also";a:1:{i:11;s:6:"11.3.0";}s:8:"releases";a:2:{s:6:"11.3.0";a:10:{s:4:"name";s:13:"drupal 11.3.0";s:7:"version";s:6:"11.3.0";s:3:"tag";s:6:"11.3.0";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/11.3.0";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-11.3.0.tar.gz";s:4:"date";s:10:"1765971890";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.6.0";a:10:{s:4:"name";s:13:"drupal 10.6.0";s:7:"version";s:6:"10.6.0";s:3:"tag";s:6:"10.6.0";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.6.0";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.6.0.tar.gz";s:4:"date";s:10:"1765965714";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:1:{i:0;s:9:"Bug fixes";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}}s:14:"latest_version";s:6:"10.6.0";s:11:"recommended";s:6:"10.6.0";s:6:"status";i:5;}}', [[timestamp]]),
('update', 'update_project_projects', 'a:1:{s:6:"drupal";a:6:{s:4:"name";s:6:"drupal";s:4:"info";a:6:{s:4:"name";s:13:"Announcements";s:7:"package";s:4:"Core";s:7:"version";s:6:"10.6.0";s:7:"project";s:6:"drupal";s:9:"datestamp";i:1765965804;s:16:"_info_file_ctime";i:[[timestamp]];}s:9:"datestamp";i:1765965804;s:8:"includes";a:44:{s:18:"announcements_feed";s:13:"Announcements";s:14:"automated_cron";s:14:"Automated Cron";s:8:"big_pipe";s:7:"BigPipe";s:5:"block";s:5:"Block";s:13:"block_content";s:13:"Block Content";s:10:"breakpoint";s:10:"Breakpoint";s:9:"ckeditor5";s:10:"CKEditor 5";s:7:"comment";s:7:"Comment";s:6:"config";s:21:"Configuration Manager";s:7:"contact";s:7:"Contact";s:10:"contextual";s:16:"Contextual Links";s:8:"datetime";s:8:"Datetime";s:5:"dblog";s:16:"Database Logging";s:18:"dynamic_page_cache";s:27:"Internal Dynamic Page Cache";s:6:"editor";s:11:"Text Editor";s:5:"field";s:5:"Field";s:8:"field_ui";s:8:"Field UI";s:4:"file";s:4:"File";s:6:"filter";s:6:"Filter";s:4:"help";s:4:"Help";s:7:"history";s:7:"History";s:5:"image";s:5:"Image";s:4:"link";s:4:"Link";s:17:"menu_link_content";s:17:"Custom Menu Links";s:7:"menu_ui";s:7:"Menu UI";s:5:"mysql";s:5:"MySQL";s:4:"node";s:4:"Node";s:7:"options";s:7:"Options";s:10:"page_cache";s:19:"Internal Page Cache";s:4:"path";s:4:"Path";s:10:"path_alias";s:10:"Path alias";s:6:"search";s:6:"Search";s:8:"shortcut";s:8:"Shortcut";s:6:"system";s:6:"System";s:8:"taxonomy";s:8:"Taxonomy";s:4:"text";s:4:"Text";s:7:"toolbar";s:7:"Toolbar";s:6:"update";s:14:"Update Manager";s:4:"user";s:4:"User";s:5:"views";s:5:"Views";s:8:"views_ui";s:8:"Views UI";s:8:"standard";s:8:"Standard";s:5:"claro";s:5:"Claro";s:7:"olivero";s:7:"Olivero";}s:12:"project_type";s:4:"core";s:14:"project_status";b:1;}}', [[timestamp]]);
INSERT INTO `[[dbprefix]]key_value_expire` VALUES
('update_available_releases', 'drupal', 'a:10:{s:5:"title";s:11:"Drupal core";s:10:"short_name";s:6:"drupal";s:4:"type";s:12:"project_core";s:18:"supported_branches";s:23:"10.5.,10.6.,11.2.,11.3.";s:18:"composer_namespace";s:11:"drupal/core";s:14:"project_status";s:9:"published";s:4:"link";s:37:"https://www.drupal.org/project/drupal";s:5:"terms";s:0:"";s:8:"releases";a:502:{s:6:"11.3.0";a:10:{s:4:"name";s:13:"drupal 11.3.0";s:7:"version";s:6:"11.3.0";s:3:"tag";s:6:"11.3.0";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/11.3.0";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-11.3.0.tar.gz";s:4:"date";s:10:"1765971890";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:10:"11.3.0-rc2";a:10:{s:4:"name";s:17:"drupal 11.3.0-rc2";s:7:"version";s:10:"11.3.0-rc2";s:3:"tag";s:10:"11.3.0-rc2";s:6:"status";s:9:"published";s:12:"release_link";s:57:"https://www.drupal.org/project/drupal/releases/11.3.0-rc2";s:13:"download_link";s:62:"https://ftp.drupal.org/files/projects/drupal-11.3.0-rc2.tar.gz";s:4:"date";s:10:"1765804707";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";}}s:8:"security";s:58:"RC releases are not covered by Drupal security advisories.";}s:10:"11.3.0-rc1";a:10:{s:4:"name";s:17:"drupal 11.3.0-rc1";s:7:"version";s:10:"11.3.0-rc1";s:3:"tag";s:10:"11.3.0-rc1";s:6:"status";s:9:"published";s:12:"release_link";s:57:"https://www.drupal.org/project/drupal/releases/11.3.0-rc1";s:13:"download_link";s:62:"https://ftp.drupal.org/files/projects/drupal-11.3.0-rc1.tar.gz";s:4:"date";s:10:"1764843586";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";}}s:8:"security";s:58:"RC releases are not covered by Drupal security advisories.";}s:12:"11.3.0-beta1";a:10:{s:4:"name";s:19:"drupal 11.3.0-beta1";s:7:"version";s:12:"11.3.0-beta1";s:3:"tag";s:12:"11.3.0-beta1";s:6:"status";s:9:"published";s:12:"release_link";s:59:"https://www.drupal.org/project/drupal/releases/11.3.0-beta1";s:13:"download_link";s:64:"https://ftp.drupal.org/files/projects/drupal-11.3.0-beta1.tar.gz";s:4:"date";s:10:"1764071187";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";}}s:8:"security";s:60:"Beta releases are not covered by Drupal security advisories.";}s:13:"11.3.0-alpha1";a:10:{s:4:"name";s:20:"drupal 11.3.0-alpha1";s:7:"version";s:13:"11.3.0-alpha1";s:3:"tag";s:13:"11.3.0-alpha1";s:6:"status";s:9:"published";s:12:"release_link";s:60:"https://www.drupal.org/project/drupal/releases/11.3.0-alpha1";s:13:"download_link";s:65:"https://ftp.drupal.org/files/projects/drupal-11.3.0-alpha1.tar.gz";s:4:"date";s:10:"1762423955";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";}}s:8:"security";s:61:"Alpha releases are not covered by Drupal security advisories.";}s:7:"11.2.10";a:10:{s:4:"name";s:14:"drupal 11.2.10";s:7:"version";s:7:"11.2.10";s:3:"tag";s:7:"11.2.10";s:6:"status";s:9:"published";s:12:"release_link";s:54:"https://www.drupal.org/project/drupal/releases/11.2.10";s:13:"download_link";s:59:"https://ftp.drupal.org/files/projects/drupal-11.2.10.tar.gz";s:4:"date";s:10:"1765361834";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:1:{i:0;s:9:"Bug fixes";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"11.2.9";a:10:{s:4:"name";s:13:"drupal 11.2.9";s:7:"version";s:6:"11.2.9";s:3:"tag";s:6:"11.2.9";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/11.2.9";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-11.2.9.tar.gz";s:4:"date";s:10:"1764840100";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:1:{i:0;s:9:"Bug fixes";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"11.2.8";a:10:{s:4:"name";s:13:"drupal 11.2.8";s:7:"version";s:6:"11.2.8";s:3:"tag";s:6:"11.2.8";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/11.2.8";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-11.2.8.tar.gz";s:4:"date";s:10:"1762990140";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:1:{i:0;s:15:"Security update";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"11.2.7";a:10:{s:4:"name";s:13:"drupal 11.2.7";s:7:"version";s:6:"11.2.7";s:3:"tag";s:6:"11.2.7";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/11.2.7";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-11.2.7.tar.gz";s:4:"date";s:10:"1762453153";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"11.2.6";a:10:{s:4:"name";s:13:"drupal 11.2.6";s:7:"version";s:6:"11.2.6";s:3:"tag";s:6:"11.2.6";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/11.2.6";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-11.2.6.tar.gz";s:4:"date";s:10:"1762402744";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"11.2.5";a:10:{s:4:"name";s:13:"drupal 11.2.5";s:7:"version";s:6:"11.2.5";s:3:"tag";s:6:"11.2.5";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/11.2.5";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-11.2.5.tar.gz";s:4:"date";s:10:"1759390965";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"11.2.4";a:10:{s:4:"name";s:13:"drupal 11.2.4";s:7:"version";s:6:"11.2.4";s:3:"tag";s:6:"11.2.4";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/11.2.4";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-11.2.4.tar.gz";s:4:"date";s:10:"1756977008";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"11.2.3";a:10:{s:4:"name";s:13:"drupal 11.2.3";s:7:"version";s:6:"11.2.3";s:3:"tag";s:6:"11.2.3";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/11.2.3";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-11.2.3.tar.gz";s:4:"date";s:10:"1754563343";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"11.2.2";a:10:{s:4:"name";s:13:"drupal 11.2.2";s:7:"version";s:6:"11.2.2";s:3:"tag";s:6:"11.2.2";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/11.2.2";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-11.2.2.tar.gz";s:4:"date";s:10:"1750948270";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"11.2.1";a:10:{s:4:"name";s:13:"drupal 11.2.1";s:7:"version";s:6:"11.2.1";s:3:"tag";s:6:"11.2.1";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/11.2.1";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-11.2.1.tar.gz";s:4:"date";s:10:"1750849338";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"11.2.0";a:10:{s:4:"name";s:13:"drupal 11.2.0";s:7:"version";s:6:"11.2.0";s:3:"tag";s:6:"11.2.0";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/11.2.0";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-11.2.0.tar.gz";s:4:"date";s:10:"1750707923";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:10:"11.2.0-rc2";a:10:{s:4:"name";s:17:"drupal 11.2.0-rc2";s:7:"version";s:10:"11.2.0-rc2";s:3:"tag";s:10:"11.2.0-rc2";s:6:"status";s:9:"published";s:12:"release_link";s:57:"https://www.drupal.org/project/drupal/releases/11.2.0-rc2";s:13:"download_link";s:62:"https://ftp.drupal.org/files/projects/drupal-11.2.0-rc2.tar.gz";s:4:"date";s:10:"1750706924";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:58:"RC releases are not covered by Drupal security advisories.";}s:10:"11.2.0-rc1";a:10:{s:4:"name";s:17:"drupal 11.2.0-rc1";s:7:"version";s:10:"11.2.0-rc1";s:3:"tag";s:10:"11.2.0-rc1";s:6:"status";s:9:"published";s:12:"release_link";s:57:"https://www.drupal.org/project/drupal/releases/11.2.0-rc1";s:13:"download_link";s:62:"https://ftp.drupal.org/files/projects/drupal-11.2.0-rc1.tar.gz";s:4:"date";s:10:"1750707307";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:58:"RC releases are not covered by Drupal security advisories.";}s:12:"11.2.0-beta1";a:10:{s:4:"name";s:19:"drupal 11.2.0-beta1";s:7:"version";s:12:"11.2.0-beta1";s:3:"tag";s:12:"11.2.0-beta1";s:6:"status";s:9:"published";s:12:"release_link";s:59:"https://www.drupal.org/project/drupal/releases/11.2.0-beta1";s:13:"download_link";s:64:"https://ftp.drupal.org/files/projects/drupal-11.2.0-beta1.tar.gz";s:4:"date";s:10:"1750706273";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:60:"Beta releases are not covered by Drupal security advisories.";}s:13:"11.2.0-alpha1";a:10:{s:4:"name";s:20:"drupal 11.2.0-alpha1";s:7:"version";s:13:"11.2.0-alpha1";s:3:"tag";s:13:"11.2.0-alpha1";s:6:"status";s:9:"published";s:12:"release_link";s:60:"https://www.drupal.org/project/drupal/releases/11.2.0-alpha1";s:13:"download_link";s:65:"https://ftp.drupal.org/files/projects/drupal-11.2.0-alpha1.tar.gz";s:4:"date";s:10:"1750705843";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:61:"Alpha releases are not covered by Drupal security advisories.";}s:6:"11.1.9";a:10:{s:4:"name";s:13:"drupal 11.1.9";s:7:"version";s:6:"11.1.9";s:3:"tag";s:6:"11.1.9";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/11.1.9";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-11.1.9.tar.gz";s:4:"date";s:10:"1762992079";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:1:{i:0;s:15:"Security update";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"11.1.8";a:10:{s:4:"name";s:13:"drupal 11.1.8";s:7:"version";s:6:"11.1.8";s:3:"tag";s:6:"11.1.8";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/11.1.8";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-11.1.8.tar.gz";s:4:"date";s:10:"1749167497";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"11.1.7";a:10:{s:4:"name";s:13:"drupal 11.1.7";s:7:"version";s:6:"11.1.7";s:3:"tag";s:6:"11.1.7";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/11.1.7";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-11.1.7.tar.gz";s:4:"date";s:10:"1746678183";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"11.1.6";a:10:{s:4:"name";s:13:"drupal 11.1.6";s:7:"version";s:6:"11.1.6";s:3:"tag";s:6:"11.1.6";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/11.1.6";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-11.1.6.tar.gz";s:4:"date";s:10:"1743628262";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"11.1.5";a:10:{s:4:"name";s:13:"drupal 11.1.5";s:7:"version";s:6:"11.1.5";s:3:"tag";s:6:"11.1.5";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/11.1.5";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-11.1.5.tar.gz";s:4:"date";s:10:"1742407823";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"11.1.4";a:10:{s:4:"name";s:13:"drupal 11.1.4";s:7:"version";s:6:"11.1.4";s:3:"tag";s:6:"11.1.4";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/11.1.4";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-11.1.4.tar.gz";s:4:"date";s:10:"1741210524";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"11.1.3";a:10:{s:4:"name";s:13:"drupal 11.1.3";s:7:"version";s:6:"11.1.3";s:3:"tag";s:6:"11.1.3";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/11.1.3";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-11.1.3.tar.gz";s:4:"date";s:10:"1739986133";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"11.1.2";a:10:{s:4:"name";s:13:"drupal 11.1.2";s:7:"version";s:6:"11.1.2";s:3:"tag";s:6:"11.1.2";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/11.1.2";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-11.1.2.tar.gz";s:4:"date";s:10:"1738796542";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"11.1.1";a:10:{s:4:"name";s:13:"drupal 11.1.1";s:7:"version";s:6:"11.1.1";s:3:"tag";s:6:"11.1.1";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/11.1.1";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-11.1.1.tar.gz";s:4:"date";s:10:"1736204811";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"11.1.0";a:10:{s:4:"name";s:13:"drupal 11.1.0";s:7:"version";s:6:"11.1.0";s:3:"tag";s:6:"11.1.0";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/11.1.0";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-11.1.0.tar.gz";s:4:"date";s:10:"1734369672";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:10:"11.1.0-rc1";a:10:{s:4:"name";s:17:"drupal 11.1.0-rc1";s:7:"version";s:10:"11.1.0-rc1";s:3:"tag";s:10:"11.1.0-rc1";s:6:"status";s:9:"published";s:12:"release_link";s:57:"https://www.drupal.org/project/drupal/releases/11.1.0-rc1";s:13:"download_link";s:62:"https://ftp.drupal.org/files/projects/drupal-11.1.0-rc1.tar.gz";s:4:"date";s:10:"1733153182";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:58:"RC releases are not covered by Drupal security advisories.";}s:12:"11.1.0-beta1";a:10:{s:4:"name";s:19:"drupal 11.1.0-beta1";s:7:"version";s:12:"11.1.0-beta1";s:3:"tag";s:12:"11.1.0-beta1";s:6:"status";s:9:"published";s:12:"release_link";s:59:"https://www.drupal.org/project/drupal/releases/11.1.0-beta1";s:13:"download_link";s:64:"https://ftp.drupal.org/files/projects/drupal-11.1.0-beta1.tar.gz";s:4:"date";s:10:"1731695942";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:60:"Beta releases are not covered by Drupal security advisories.";}s:7:"11.0.13";a:10:{s:4:"name";s:14:"drupal 11.0.13";s:7:"version";s:7:"11.0.13";s:3:"tag";s:7:"11.0.13";s:6:"status";s:9:"published";s:12:"release_link";s:54:"https://www.drupal.org/project/drupal/releases/11.0.13";s:13:"download_link";s:59:"https://ftp.drupal.org/files/projects/drupal-11.0.13.tar.gz";s:4:"date";s:10:"1742408477";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:7:"11.0.12";a:10:{s:4:"name";s:14:"drupal 11.0.12";s:7:"version";s:7:"11.0.12";s:3:"tag";s:7:"11.0.12";s:6:"status";s:9:"published";s:12:"release_link";s:54:"https://www.drupal.org/project/drupal/releases/11.0.12";s:13:"download_link";s:59:"https://ftp.drupal.org/files/projects/drupal-11.0.12.tar.gz";s:4:"date";s:10:"1739988102";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:7:"11.0.11";a:10:{s:4:"name";s:14:"drupal 11.0.11";s:7:"version";s:7:"11.0.11";s:3:"tag";s:7:"11.0.11";s:6:"status";s:9:"published";s:12:"release_link";s:54:"https://www.drupal.org/project/drupal/releases/11.0.11";s:13:"download_link";s:59:"https://ftp.drupal.org/files/projects/drupal-11.0.11.tar.gz";s:4:"date";s:10:"1738797159";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:7:"11.0.10";a:10:{s:4:"name";s:14:"drupal 11.0.10";s:7:"version";s:7:"11.0.10";s:3:"tag";s:7:"11.0.10";s:6:"status";s:9:"published";s:12:"release_link";s:54:"https://www.drupal.org/project/drupal/releases/11.0.10";s:13:"download_link";s:59:"https://ftp.drupal.org/files/projects/drupal-11.0.10.tar.gz";s:4:"date";s:10:"1736206526";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"11.0.9";a:10:{s:4:"name";s:13:"drupal 11.0.9";s:7:"version";s:6:"11.0.9";s:3:"tag";s:6:"11.0.9";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/11.0.9";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-11.0.9.tar.gz";s:4:"date";s:10:"1732283629";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"11.0.8";a:10:{s:4:"name";s:13:"drupal 11.0.8";s:7:"version";s:6:"11.0.8";s:3:"tag";s:6:"11.0.8";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/11.0.8";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-11.0.8.tar.gz";s:4:"date";s:10:"1732132096";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"11.0.7";a:10:{s:4:"name";s:13:"drupal 11.0.7";s:7:"version";s:6:"11.0.7";s:3:"tag";s:6:"11.0.7";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/11.0.7";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-11.0.7.tar.gz";s:4:"date";s:10:"1731407794";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"11.0.6";a:10:{s:4:"name";s:13:"drupal 11.0.6";s:7:"version";s:6:"11.0.6";s:3:"tag";s:6:"11.0.6";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/11.0.6";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-11.0.6.tar.gz";s:4:"date";s:10:"1730969764";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"11.0.5";a:10:{s:4:"name";s:13:"drupal 11.0.5";s:7:"version";s:6:"11.0.5";s:3:"tag";s:6:"11.0.5";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/11.0.5";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-11.0.5.tar.gz";s:4:"date";s:10:"1727946737";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"11.0.4";a:10:{s:4:"name";s:13:"drupal 11.0.4";s:7:"version";s:6:"11.0.4";s:3:"tag";s:6:"11.0.4";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/11.0.4";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-11.0.4.tar.gz";s:4:"date";s:10:"1726136390";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"11.0.3";a:10:{s:4:"name";s:13:"drupal 11.0.3";s:7:"version";s:6:"11.0.3";s:3:"tag";s:6:"11.0.3";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/11.0.3";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-11.0.3.tar.gz";s:4:"date";s:10:"1726074557";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"11.0.2";a:10:{s:4:"name";s:13:"drupal 11.0.2";s:7:"version";s:6:"11.0.2";s:3:"tag";s:6:"11.0.2";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/11.0.2";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-11.0.2.tar.gz";s:4:"date";s:10:"1725526703";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"11.0.1";a:10:{s:4:"name";s:13:"drupal 11.0.1";s:7:"version";s:6:"11.0.1";s:3:"tag";s:6:"11.0.1";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/11.0.1";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-11.0.1.tar.gz";s:4:"date";s:10:"1723108396";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"11.0.0";a:10:{s:4:"name";s:13:"drupal 11.0.0";s:7:"version";s:6:"11.0.0";s:3:"tag";s:6:"11.0.0";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/11.0.0";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-11.0.0.tar.gz";s:4:"date";s:10:"1722578454";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:10:"11.0.0-rc1";a:10:{s:4:"name";s:17:"drupal 11.0.0-rc1";s:7:"version";s:10:"11.0.0-rc1";s:3:"tag";s:10:"11.0.0-rc1";s:6:"status";s:9:"published";s:12:"release_link";s:57:"https://www.drupal.org/project/drupal/releases/11.0.0-rc1";s:13:"download_link";s:62:"https://ftp.drupal.org/files/projects/drupal-11.0.0-rc1.tar.gz";s:4:"date";s:10:"1720736512";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:58:"RC releases are not covered by Drupal security advisories.";}s:12:"11.0.0-beta1";a:10:{s:4:"name";s:19:"drupal 11.0.0-beta1";s:7:"version";s:12:"11.0.0-beta1";s:3:"tag";s:12:"11.0.0-beta1";s:6:"status";s:9:"published";s:12:"release_link";s:59:"https://www.drupal.org/project/drupal/releases/11.0.0-beta1";s:13:"download_link";s:64:"https://ftp.drupal.org/files/projects/drupal-11.0.0-beta1.tar.gz";s:4:"date";s:10:"1715953266";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:60:"Beta releases are not covered by Drupal security advisories.";}s:13:"11.0.0-alpha1";a:10:{s:4:"name";s:20:"drupal 11.0.0-alpha1";s:7:"version";s:13:"11.0.0-alpha1";s:3:"tag";s:13:"11.0.0-alpha1";s:6:"status";s:9:"published";s:12:"release_link";s:60:"https://www.drupal.org/project/drupal/releases/11.0.0-alpha1";s:13:"download_link";s:65:"https://ftp.drupal.org/files/projects/drupal-11.0.0-alpha1.tar.gz";s:4:"date";s:10:"1714797816";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:61:"Alpha releases are not covered by Drupal security advisories.";}s:6:"10.6.0";a:10:{s:4:"name";s:13:"drupal 10.6.0";s:7:"version";s:6:"10.6.0";s:3:"tag";s:6:"10.6.0";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.6.0";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.6.0.tar.gz";s:4:"date";s:10:"1765965714";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:1:{i:0;s:9:"Bug fixes";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:10:"10.6.0-rc1";a:10:{s:4:"name";s:17:"drupal 10.6.0-rc1";s:7:"version";s:10:"10.6.0-rc1";s:3:"tag";s:10:"10.6.0-rc1";s:6:"status";s:9:"published";s:12:"release_link";s:57:"https://www.drupal.org/project/drupal/releases/10.6.0-rc1";s:13:"download_link";s:62:"https://ftp.drupal.org/files/projects/drupal-10.6.0-rc1.tar.gz";s:4:"date";s:10:"1764842812";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";}}s:8:"security";s:58:"RC releases are not covered by Drupal security advisories.";}s:12:"10.6.0-beta1";a:10:{s:4:"name";s:19:"drupal 10.6.0-beta1";s:7:"version";s:12:"10.6.0-beta1";s:3:"tag";s:12:"10.6.0-beta1";s:6:"status";s:9:"published";s:12:"release_link";s:59:"https://www.drupal.org/project/drupal/releases/10.6.0-beta1";s:13:"download_link";s:64:"https://ftp.drupal.org/files/projects/drupal-10.6.0-beta1.tar.gz";s:4:"date";s:10:"1764083058";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";}}s:8:"security";s:60:"Beta releases are not covered by Drupal security advisories.";}s:6:"10.5.8";a:10:{s:4:"name";s:13:"drupal 10.5.8";s:7:"version";s:6:"10.5.8";s:3:"tag";s:6:"10.5.8";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.5.8";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.5.8.tar.gz";s:4:"date";s:10:"1765309285";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:1:{i:0;s:9:"Bug fixes";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.5.7";a:10:{s:4:"name";s:13:"drupal 10.5.7";s:7:"version";s:6:"10.5.7";s:3:"tag";s:6:"10.5.7";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.5.7";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.5.7.tar.gz";s:4:"date";s:10:"1764837891";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:1:{i:0;s:9:"Bug fixes";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.5.6";a:10:{s:4:"name";s:13:"drupal 10.5.6";s:7:"version";s:6:"10.5.6";s:3:"tag";s:6:"10.5.6";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.5.6";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.5.6.tar.gz";s:4:"date";s:10:"1762990833";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:1:{i:0;s:15:"Security update";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.5.5";a:10:{s:4:"name";s:13:"drupal 10.5.5";s:7:"version";s:6:"10.5.5";s:3:"tag";s:6:"10.5.5";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.5.5";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.5.5.tar.gz";s:4:"date";s:10:"1762403351";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.5.4";a:10:{s:4:"name";s:13:"drupal 10.5.4";s:7:"version";s:6:"10.5.4";s:3:"tag";s:6:"10.5.4";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.5.4";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.5.4.tar.gz";s:4:"date";s:10:"1759391576";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.5.3";a:10:{s:4:"name";s:13:"drupal 10.5.3";s:7:"version";s:6:"10.5.3";s:3:"tag";s:6:"10.5.3";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.5.3";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.5.3.tar.gz";s:4:"date";s:10:"1756978175";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.5.2";a:10:{s:4:"name";s:13:"drupal 10.5.2";s:7:"version";s:6:"10.5.2";s:3:"tag";s:6:"10.5.2";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.5.2";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.5.2.tar.gz";s:4:"date";s:10:"1754564029";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.5.1";a:10:{s:4:"name";s:13:"drupal 10.5.1";s:7:"version";s:6:"10.5.1";s:3:"tag";s:6:"10.5.1";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.5.1";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.5.1.tar.gz";s:4:"date";s:10:"1750947651";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.5.0";a:10:{s:4:"name";s:13:"drupal 10.5.0";s:7:"version";s:6:"10.5.0";s:3:"tag";s:6:"10.5.0";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.5.0";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.5.0.tar.gz";s:4:"date";s:10:"1750294139";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:10:"10.5.0-rc1";a:10:{s:4:"name";s:17:"drupal 10.5.0-rc1";s:7:"version";s:10:"10.5.0-rc1";s:3:"tag";s:10:"10.5.0-rc1";s:6:"status";s:9:"published";s:12:"release_link";s:57:"https://www.drupal.org/project/drupal/releases/10.5.0-rc1";s:13:"download_link";s:62:"https://ftp.drupal.org/files/projects/drupal-10.5.0-rc1.tar.gz";s:4:"date";s:10:"1749746527";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:58:"RC releases are not covered by Drupal security advisories.";}s:12:"10.5.0-beta1";a:10:{s:4:"name";s:19:"drupal 10.5.0-beta1";s:7:"version";s:12:"10.5.0-beta1";s:3:"tag";s:12:"10.5.0-beta1";s:6:"status";s:9:"published";s:12:"release_link";s:59:"https://www.drupal.org/project/drupal/releases/10.5.0-beta1";s:13:"download_link";s:64:"https://ftp.drupal.org/files/projects/drupal-10.5.0-beta1.tar.gz";s:4:"date";s:10:"1748162570";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:60:"Beta releases are not covered by Drupal security advisories.";}s:6:"10.4.9";a:10:{s:4:"name";s:13:"drupal 10.4.9";s:7:"version";s:6:"10.4.9";s:3:"tag";s:6:"10.4.9";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.4.9";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.4.9.tar.gz";s:4:"date";s:10:"1762991487";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:1:{i:0;s:15:"Security update";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.4.8";a:10:{s:4:"name";s:13:"drupal 10.4.8";s:7:"version";s:6:"10.4.8";s:3:"tag";s:6:"10.4.8";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.4.8";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.4.8.tar.gz";s:4:"date";s:10:"1749168268";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.4.7";a:10:{s:4:"name";s:13:"drupal 10.4.7";s:7:"version";s:6:"10.4.7";s:3:"tag";s:6:"10.4.7";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.4.7";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.4.7.tar.gz";s:4:"date";s:10:"1746678757";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.4.6";a:10:{s:4:"name";s:13:"drupal 10.4.6";s:7:"version";s:6:"10.4.6";s:3:"tag";s:6:"10.4.6";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.4.6";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.4.6.tar.gz";s:4:"date";s:10:"1743628915";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.4.5";a:10:{s:4:"name";s:13:"drupal 10.4.5";s:7:"version";s:6:"10.4.5";s:3:"tag";s:6:"10.4.5";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.4.5";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.4.5.tar.gz";s:4:"date";s:10:"1742409107";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.4.4";a:10:{s:4:"name";s:13:"drupal 10.4.4";s:7:"version";s:6:"10.4.4";s:3:"tag";s:6:"10.4.4";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.4.4";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.4.4.tar.gz";s:4:"date";s:10:"1741211791";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.4.3";a:10:{s:4:"name";s:13:"drupal 10.4.3";s:7:"version";s:6:"10.4.3";s:3:"tag";s:6:"10.4.3";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.4.3";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.4.3.tar.gz";s:4:"date";s:10:"1739987505";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.4.2";a:10:{s:4:"name";s:13:"drupal 10.4.2";s:7:"version";s:6:"10.4.2";s:3:"tag";s:6:"10.4.2";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.4.2";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.4.2.tar.gz";s:4:"date";s:10:"1738798328";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.4.1";a:10:{s:4:"name";s:13:"drupal 10.4.1";s:7:"version";s:6:"10.4.1";s:3:"tag";s:6:"10.4.1";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.4.1";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.4.1.tar.gz";s:4:"date";s:10:"1736207882";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.4.0";a:10:{s:4:"name";s:13:"drupal 10.4.0";s:7:"version";s:6:"10.4.0";s:3:"tag";s:6:"10.4.0";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.4.0";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.4.0.tar.gz";s:4:"date";s:10:"1734475162";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:10:"10.4.0-rc1";a:10:{s:4:"name";s:17:"drupal 10.4.0-rc1";s:7:"version";s:10:"10.4.0-rc1";s:3:"tag";s:10:"10.4.0-rc1";s:6:"status";s:9:"published";s:12:"release_link";s:57:"https://www.drupal.org/project/drupal/releases/10.4.0-rc1";s:13:"download_link";s:62:"https://ftp.drupal.org/files/projects/drupal-10.4.0-rc1.tar.gz";s:4:"date";s:10:"1733155673";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:58:"RC releases are not covered by Drupal security advisories.";}s:12:"10.4.0-beta1";a:10:{s:4:"name";s:19:"drupal 10.4.0-beta1";s:7:"version";s:12:"10.4.0-beta1";s:3:"tag";s:12:"10.4.0-beta1";s:6:"status";s:9:"published";s:12:"release_link";s:59:"https://www.drupal.org/project/drupal/releases/10.4.0-beta1";s:13:"download_link";s:64:"https://ftp.drupal.org/files/projects/drupal-10.4.0-beta1.tar.gz";s:4:"date";s:10:"1731947109";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:8:"Insecure";i:1;s:9:"Bug fixes";i:2;s:12:"New features";}}s:8:"security";s:60:"Beta releases are not covered by Drupal security advisories.";}s:7:"10.3.14";a:10:{s:4:"name";s:14:"drupal 10.3.14";s:7:"version";s:7:"10.3.14";s:3:"tag";s:7:"10.3.14";s:6:"status";s:9:"published";s:12:"release_link";s:54:"https://www.drupal.org/project/drupal/releases/10.3.14";s:13:"download_link";s:59:"https://ftp.drupal.org/files/projects/drupal-10.3.14.tar.gz";s:4:"date";s:10:"1742410042";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:7:"10.3.13";a:10:{s:4:"name";s:14:"drupal 10.3.13";s:7:"version";s:7:"10.3.13";s:3:"tag";s:7:"10.3.13";s:6:"status";s:9:"published";s:12:"release_link";s:54:"https://www.drupal.org/project/drupal/releases/10.3.13";s:13:"download_link";s:59:"https://ftp.drupal.org/files/projects/drupal-10.3.13.tar.gz";s:4:"date";s:10:"1739986815";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:7:"10.3.12";a:10:{s:4:"name";s:14:"drupal 10.3.12";s:7:"version";s:7:"10.3.12";s:3:"tag";s:7:"10.3.12";s:6:"status";s:9:"published";s:12:"release_link";s:54:"https://www.drupal.org/project/drupal/releases/10.3.12";s:13:"download_link";s:59:"https://ftp.drupal.org/files/projects/drupal-10.3.12.tar.gz";s:4:"date";s:10:"1738798951";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:7:"10.3.11";a:10:{s:4:"name";s:14:"drupal 10.3.11";s:7:"version";s:7:"10.3.11";s:3:"tag";s:7:"10.3.11";s:6:"status";s:9:"published";s:12:"release_link";s:54:"https://www.drupal.org/project/drupal/releases/10.3.11";s:13:"download_link";s:59:"https://ftp.drupal.org/files/projects/drupal-10.3.11.tar.gz";s:4:"date";s:10:"1736208549";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:7:"10.3.10";a:10:{s:4:"name";s:14:"drupal 10.3.10";s:7:"version";s:7:"10.3.10";s:3:"tag";s:7:"10.3.10";s:6:"status";s:9:"published";s:12:"release_link";s:54:"https://www.drupal.org/project/drupal/releases/10.3.10";s:13:"download_link";s:59:"https://ftp.drupal.org/files/projects/drupal-10.3.10.tar.gz";s:4:"date";s:10:"1732284381";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.3.9";a:10:{s:4:"name";s:13:"drupal 10.3.9";s:7:"version";s:6:"10.3.9";s:3:"tag";s:6:"10.3.9";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.3.9";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.3.9.tar.gz";s:4:"date";s:10:"1732132747";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.3.8";a:10:{s:4:"name";s:13:"drupal 10.3.8";s:7:"version";s:6:"10.3.8";s:3:"tag";s:6:"10.3.8";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.3.8";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.3.8.tar.gz";s:4:"date";s:10:"1731407050";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.3.7";a:10:{s:4:"name";s:13:"drupal 10.3.7";s:7:"version";s:6:"10.3.7";s:3:"tag";s:6:"10.3.7";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.3.7";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.3.7.tar.gz";s:4:"date";s:10:"1730969060";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.3.6";a:10:{s:4:"name";s:13:"drupal 10.3.6";s:7:"version";s:6:"10.3.6";s:3:"tag";s:6:"10.3.6";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.3.6";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.3.6.tar.gz";s:4:"date";s:10:"1727948888";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.3.5";a:10:{s:4:"name";s:13:"drupal 10.3.5";s:7:"version";s:6:"10.3.5";s:3:"tag";s:6:"10.3.5";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.3.5";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.3.5.tar.gz";s:4:"date";s:10:"1726134993";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.3.4";a:10:{s:4:"name";s:13:"drupal 10.3.4";s:7:"version";s:6:"10.3.4";s:3:"tag";s:6:"10.3.4";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.3.4";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.3.4.tar.gz";s:4:"date";s:10:"1726072510";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.3.3";a:10:{s:4:"name";s:13:"drupal 10.3.3";s:7:"version";s:6:"10.3.3";s:3:"tag";s:6:"10.3.3";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.3.3";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.3.3.tar.gz";s:4:"date";s:10:"1725528161";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.3.2";a:10:{s:4:"name";s:13:"drupal 10.3.2";s:7:"version";s:6:"10.3.2";s:3:"tag";s:6:"10.3.2";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.3.2";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.3.2.tar.gz";s:4:"date";s:10:"1723109810";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.3.1";a:10:{s:4:"name";s:13:"drupal 10.3.1";s:7:"version";s:6:"10.3.1";s:3:"tag";s:6:"10.3.1";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.3.1";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.3.1.tar.gz";s:4:"date";s:10:"1720094095";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.3.0";a:10:{s:4:"name";s:13:"drupal 10.3.0";s:7:"version";s:6:"10.3.0";s:3:"tag";s:6:"10.3.0";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.3.0";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.3.0.tar.gz";s:4:"date";s:10:"1718911125";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:10:"10.3.0-rc1";a:10:{s:4:"name";s:17:"drupal 10.3.0-rc1";s:7:"version";s:10:"10.3.0-rc1";s:3:"tag";s:10:"10.3.0-rc1";s:6:"status";s:9:"published";s:12:"release_link";s:57:"https://www.drupal.org/project/drupal/releases/10.3.0-rc1";s:13:"download_link";s:62:"https://ftp.drupal.org/files/projects/drupal-10.3.0-rc1.tar.gz";s:4:"date";s:10:"1717621189";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:58:"RC releases are not covered by Drupal security advisories.";}s:12:"10.3.0-beta1";a:10:{s:4:"name";s:19:"drupal 10.3.0-beta1";s:7:"version";s:12:"10.3.0-beta1";s:3:"tag";s:12:"10.3.0-beta1";s:6:"status";s:9:"published";s:12:"release_link";s:59:"https://www.drupal.org/project/drupal/releases/10.3.0-beta1";s:13:"download_link";s:64:"https://ftp.drupal.org/files/projects/drupal-10.3.0-beta1.tar.gz";s:4:"date";s:10:"1715953149";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:60:"Beta releases are not covered by Drupal security advisories.";}s:7:"10.2.12";a:10:{s:4:"name";s:14:"drupal 10.2.12";s:7:"version";s:7:"10.2.12";s:3:"tag";s:7:"10.2.12";s:6:"status";s:9:"published";s:12:"release_link";s:54:"https://www.drupal.org/project/drupal/releases/10.2.12";s:13:"download_link";s:59:"https://ftp.drupal.org/files/projects/drupal-10.2.12.tar.gz";s:4:"date";s:10:"1732281201";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:7:"10.2.11";a:10:{s:4:"name";s:14:"drupal 10.2.11";s:7:"version";s:7:"10.2.11";s:3:"tag";s:7:"10.2.11";s:6:"status";s:9:"published";s:12:"release_link";s:54:"https://www.drupal.org/project/drupal/releases/10.2.11";s:13:"download_link";s:59:"https://ftp.drupal.org/files/projects/drupal-10.2.11.tar.gz";s:4:"date";s:10:"1732133662";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:7:"10.2.10";a:10:{s:4:"name";s:14:"drupal 10.2.10";s:7:"version";s:7:"10.2.10";s:3:"tag";s:7:"10.2.10";s:6:"status";s:9:"published";s:12:"release_link";s:54:"https://www.drupal.org/project/drupal/releases/10.2.10";s:13:"download_link";s:59:"https://ftp.drupal.org/files/projects/drupal-10.2.10.tar.gz";s:4:"date";s:10:"1729096989";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.2.9";a:10:{s:4:"name";s:13:"drupal 10.2.9";s:7:"version";s:6:"10.2.9";s:3:"tag";s:6:"10.2.9";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.2.9";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.2.9.tar.gz";s:4:"date";s:10:"1728387439";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.2.8";a:10:{s:4:"name";s:13:"drupal 10.2.8";s:7:"version";s:6:"10.2.8";s:3:"tag";s:6:"10.2.8";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.2.8";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.2.8.tar.gz";s:4:"date";s:10:"1726073816";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.2.7";a:10:{s:4:"name";s:13:"drupal 10.2.7";s:7:"version";s:6:"10.2.7";s:3:"tag";s:6:"10.2.7";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.2.7";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.2.7.tar.gz";s:4:"date";s:10:"1717660024";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.2.6";a:10:{s:4:"name";s:13:"drupal 10.2.6";s:7:"version";s:6:"10.2.6";s:3:"tag";s:6:"10.2.6";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.2.6";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.2.6.tar.gz";s:4:"date";s:10:"1714597701";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.2.5";a:10:{s:4:"name";s:13:"drupal 10.2.5";s:7:"version";s:6:"10.2.5";s:3:"tag";s:6:"10.2.5";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.2.5";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.2.5.tar.gz";s:4:"date";s:10:"1712130945";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.2.4";a:10:{s:4:"name";s:13:"drupal 10.2.4";s:7:"version";s:6:"10.2.4";s:3:"tag";s:6:"10.2.4";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.2.4";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.2.4.tar.gz";s:4:"date";s:10:"1709715366";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.2.3";a:10:{s:4:"name";s:13:"drupal 10.2.3";s:7:"version";s:6:"10.2.3";s:3:"tag";s:6:"10.2.3";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.2.3";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.2.3.tar.gz";s:4:"date";s:10:"1707347611";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.2.2";a:10:{s:4:"name";s:13:"drupal 10.2.2";s:7:"version";s:6:"10.2.2";s:3:"tag";s:6:"10.2.2";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.2.2";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.2.2.tar.gz";s:4:"date";s:10:"1705511786";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.2.1";a:10:{s:4:"name";s:13:"drupal 10.2.1";s:7:"version";s:6:"10.2.1";s:3:"tag";s:6:"10.2.1";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.2.1";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.2.1.tar.gz";s:4:"date";s:10:"1704448164";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:8:"Insecure";i:1;s:9:"Bug fixes";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.2.0";a:10:{s:4:"name";s:13:"drupal 10.2.0";s:7:"version";s:6:"10.2.0";s:3:"tag";s:6:"10.2.0";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.2.0";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.2.0.tar.gz";s:4:"date";s:10:"1702681674";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:10:"10.2.0-rc1";a:10:{s:4:"name";s:17:"drupal 10.2.0-rc1";s:7:"version";s:10:"10.2.0-rc1";s:3:"tag";s:10:"10.2.0-rc1";s:6:"status";s:9:"published";s:12:"release_link";s:57:"https://www.drupal.org/project/drupal/releases/10.2.0-rc1";s:13:"download_link";s:62:"https://ftp.drupal.org/files/projects/drupal-10.2.0-rc1.tar.gz";s:4:"date";s:10:"1701450971";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:58:"RC releases are not covered by Drupal security advisories.";}s:12:"10.2.0-beta1";a:10:{s:4:"name";s:19:"drupal 10.2.0-beta1";s:7:"version";s:12:"10.2.0-beta1";s:3:"tag";s:12:"10.2.0-beta1";s:6:"status";s:9:"published";s:12:"release_link";s:59:"https://www.drupal.org/project/drupal/releases/10.2.0-beta1";s:13:"download_link";s:64:"https://ftp.drupal.org/files/projects/drupal-10.2.0-beta1.tar.gz";s:4:"date";s:10:"1700578716";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:60:"Beta releases are not covered by Drupal security advisories.";}s:13:"10.2.0-alpha1";a:10:{s:4:"name";s:20:"drupal 10.2.0-alpha1";s:7:"version";s:13:"10.2.0-alpha1";s:3:"tag";s:13:"10.2.0-alpha1";s:6:"status";s:9:"published";s:12:"release_link";s:60:"https://www.drupal.org/project/drupal/releases/10.2.0-alpha1";s:13:"download_link";s:65:"https://ftp.drupal.org/files/projects/drupal-10.2.0-alpha1.tar.gz";s:4:"date";s:10:"1699048959";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:61:"Alpha releases are not covered by Drupal security advisories.";}s:6:"10.1.8";a:10:{s:4:"name";s:13:"drupal 10.1.8";s:7:"version";s:6:"10.1.8";s:3:"tag";s:6:"10.1.8";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.1.8";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.1.8.tar.gz";s:4:"date";s:10:"1705512711";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.1.7";a:10:{s:4:"name";s:13:"drupal 10.1.7";s:7:"version";s:6:"10.1.7";s:3:"tag";s:6:"10.1.7";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.1.7";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.1.7.tar.gz";s:4:"date";s:10:"1701857745";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:8:"Insecure";i:1;s:9:"Bug fixes";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.1.6";a:10:{s:4:"name";s:13:"drupal 10.1.6";s:7:"version";s:6:"10.1.6";s:3:"tag";s:6:"10.1.6";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.1.6";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.1.6.tar.gz";s:4:"date";s:10:"1698841286";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.1.5";a:10:{s:4:"name";s:13:"drupal 10.1.5";s:7:"version";s:6:"10.1.5";s:3:"tag";s:6:"10.1.5";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.1.5";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.1.5.tar.gz";s:4:"date";s:10:"1696456362";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.1.4";a:10:{s:4:"name";s:13:"drupal 10.1.4";s:7:"version";s:6:"10.1.4";s:3:"tag";s:6:"10.1.4";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.1.4";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.1.4.tar.gz";s:4:"date";s:10:"1695227262";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.1.3";a:10:{s:4:"name";s:13:"drupal 10.1.3";s:7:"version";s:6:"10.1.3";s:3:"tag";s:6:"10.1.3";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.1.3";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.1.3.tar.gz";s:4:"date";s:10:"1694101052";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.1.2";a:10:{s:4:"name";s:13:"drupal 10.1.2";s:7:"version";s:6:"10.1.2";s:3:"tag";s:6:"10.1.2";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.1.2";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.1.2.tar.gz";s:4:"date";s:10:"1690972078";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.1.1";a:10:{s:4:"name";s:13:"drupal 10.1.1";s:7:"version";s:6:"10.1.1";s:3:"tag";s:6:"10.1.1";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.1.1";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.1.1.tar.gz";s:4:"date";s:10:"1688632960";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.1.0";a:10:{s:4:"name";s:13:"drupal 10.1.0";s:7:"version";s:6:"10.1.0";s:3:"tag";s:6:"10.1.0";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.1.0";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.1.0.tar.gz";s:4:"date";s:10:"1687424272";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:8:"Insecure";i:1;s:9:"Bug fixes";i:2;s:12:"New features";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:10:"10.1.0-rc1";a:10:{s:4:"name";s:17:"drupal 10.1.0-rc1";s:7:"version";s:10:"10.1.0-rc1";s:3:"tag";s:10:"10.1.0-rc1";s:6:"status";s:9:"published";s:12:"release_link";s:57:"https://www.drupal.org/project/drupal/releases/10.1.0-rc1";s:13:"download_link";s:62:"https://ftp.drupal.org/files/projects/drupal-10.1.0-rc1.tar.gz";s:4:"date";s:10:"1686244833";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:58:"RC releases are not covered by Drupal security advisories.";}s:12:"10.1.0-beta1";a:10:{s:4:"name";s:19:"drupal 10.1.0-beta1";s:7:"version";s:12:"10.1.0-beta1";s:3:"tag";s:12:"10.1.0-beta1";s:6:"status";s:9:"published";s:12:"release_link";s:59:"https://www.drupal.org/project/drupal/releases/10.1.0-beta1";s:13:"download_link";s:64:"https://ftp.drupal.org/files/projects/drupal-10.1.0-beta1.tar.gz";s:4:"date";s:10:"1684130534";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:60:"Beta releases are not covered by Drupal security advisories.";}s:13:"10.1.0-alpha1";a:10:{s:4:"name";s:20:"drupal 10.1.0-alpha1";s:7:"version";s:13:"10.1.0-alpha1";s:3:"tag";s:13:"10.1.0-alpha1";s:6:"status";s:9:"published";s:12:"release_link";s:60:"https://www.drupal.org/project/drupal/releases/10.1.0-alpha1";s:13:"download_link";s:65:"https://ftp.drupal.org/files/projects/drupal-10.1.0-alpha1.tar.gz";s:4:"date";s:10:"1682694475";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:61:"Alpha releases are not covered by Drupal security advisories.";}s:7:"10.0.11";a:10:{s:4:"name";s:14:"drupal 10.0.11";s:7:"version";s:7:"10.0.11";s:3:"tag";s:7:"10.0.11";s:6:"status";s:9:"published";s:12:"release_link";s:54:"https://www.drupal.org/project/drupal/releases/10.0.11";s:13:"download_link";s:59:"https://ftp.drupal.org/files/projects/drupal-10.0.11.tar.gz";s:4:"date";s:10:"1695228927";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:7:"10.0.10";a:10:{s:4:"name";s:14:"drupal 10.0.10";s:7:"version";s:7:"10.0.10";s:3:"tag";s:7:"10.0.10";s:6:"status";s:9:"published";s:12:"release_link";s:54:"https://www.drupal.org/project/drupal/releases/10.0.10";s:13:"download_link";s:59:"https://ftp.drupal.org/files/projects/drupal-10.0.10.tar.gz";s:4:"date";s:10:"1688549719";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.0.9";a:10:{s:4:"name";s:13:"drupal 10.0.9";s:7:"version";s:6:"10.0.9";s:3:"tag";s:6:"10.0.9";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.0.9";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.0.9.tar.gz";s:4:"date";s:10:"1683108606";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.0.8";a:10:{s:4:"name";s:13:"drupal 10.0.8";s:7:"version";s:6:"10.0.8";s:3:"tag";s:6:"10.0.8";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.0.8";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.0.8.tar.gz";s:4:"date";s:10:"1681921539";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.0.7";a:10:{s:4:"name";s:13:"drupal 10.0.7";s:7:"version";s:6:"10.0.7";s:3:"tag";s:6:"10.0.7";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.0.7";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.0.7.tar.gz";s:4:"date";s:10:"1679678060";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:12:"New features";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.0.6";a:10:{s:4:"name";s:13:"drupal 10.0.6";s:7:"version";s:6:"10.0.6";s:3:"tag";s:6:"10.0.6";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.0.6";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.0.6.tar.gz";s:4:"date";s:10:"1679664982";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.0.5";a:10:{s:4:"name";s:13:"drupal 10.0.5";s:7:"version";s:6:"10.0.5";s:3:"tag";s:6:"10.0.5";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.0.5";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.0.5.tar.gz";s:4:"date";s:10:"1678901067";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.0.4";a:10:{s:4:"name";s:13:"drupal 10.0.4";s:7:"version";s:6:"10.0.4";s:3:"tag";s:6:"10.0.4";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.0.4";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.0.4.tar.gz";s:4:"date";s:10:"1677681486";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.0.3";a:10:{s:4:"name";s:13:"drupal 10.0.3";s:7:"version";s:6:"10.0.3";s:3:"tag";s:6:"10.0.3";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.0.3";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.0.3.tar.gz";s:4:"date";s:10:"1675276709";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.0.2";a:10:{s:4:"name";s:13:"drupal 10.0.2";s:7:"version";s:6:"10.0.2";s:3:"tag";s:6:"10.0.2";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.0.2";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.0.2.tar.gz";s:4:"date";s:10:"1674065542";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.0.1";a:10:{s:4:"name";s:13:"drupal 10.0.1";s:7:"version";s:6:"10.0.1";s:3:"tag";s:6:"10.0.1";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.0.1";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.0.1.tar.gz";s:4:"date";s:10:"1672847780";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"10.0.0";a:10:{s:4:"name";s:13:"drupal 10.0.0";s:7:"version";s:6:"10.0.0";s:3:"tag";s:6:"10.0.0";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/10.0.0";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-10.0.0.tar.gz";s:4:"date";s:10:"1671125939";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:10:"10.0.0-rc3";a:10:{s:4:"name";s:17:"drupal 10.0.0-rc3";s:7:"version";s:10:"10.0.0-rc3";s:3:"tag";s:10:"10.0.0-rc3";s:6:"status";s:9:"published";s:12:"release_link";s:57:"https://www.drupal.org/project/drupal/releases/10.0.0-rc3";s:13:"download_link";s:62:"https://ftp.drupal.org/files/projects/drupal-10.0.0-rc3.tar.gz";s:4:"date";s:10:"1670591784";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:58:"RC releases are not covered by Drupal security advisories.";}s:10:"10.0.0-rc2";a:10:{s:4:"name";s:17:"drupal 10.0.0-rc2";s:7:"version";s:10:"10.0.0-rc2";s:3:"tag";s:10:"10.0.0-rc2";s:6:"status";s:9:"published";s:12:"release_link";s:57:"https://www.drupal.org/project/drupal/releases/10.0.0-rc2";s:13:"download_link";s:62:"https://ftp.drupal.org/files/projects/drupal-10.0.0-rc2.tar.gz";s:4:"date";s:10:"1670320927";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:58:"RC releases are not covered by Drupal security advisories.";}s:10:"10.0.0-rc1";a:10:{s:4:"name";s:17:"drupal 10.0.0-rc1";s:7:"version";s:10:"10.0.0-rc1";s:3:"tag";s:10:"10.0.0-rc1";s:6:"status";s:9:"published";s:12:"release_link";s:57:"https://www.drupal.org/project/drupal/releases/10.0.0-rc1";s:13:"download_link";s:62:"https://ftp.drupal.org/files/projects/drupal-10.0.0-rc1.tar.gz";s:4:"date";s:10:"1668612993";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:58:"RC releases are not covered by Drupal security advisories.";}s:12:"10.0.0-beta2";a:10:{s:4:"name";s:19:"drupal 10.0.0-beta2";s:7:"version";s:12:"10.0.0-beta2";s:3:"tag";s:12:"10.0.0-beta2";s:6:"status";s:9:"published";s:12:"release_link";s:59:"https://www.drupal.org/project/drupal/releases/10.0.0-beta2";s:13:"download_link";s:64:"https://ftp.drupal.org/files/projects/drupal-10.0.0-beta2.tar.gz";s:4:"date";s:10:"1664462663";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:60:"Beta releases are not covered by Drupal security advisories.";}s:12:"10.0.0-beta1";a:10:{s:4:"name";s:19:"drupal 10.0.0-beta1";s:7:"version";s:12:"10.0.0-beta1";s:3:"tag";s:12:"10.0.0-beta1";s:6:"status";s:9:"published";s:12:"release_link";s:59:"https://www.drupal.org/project/drupal/releases/10.0.0-beta1";s:13:"download_link";s:64:"https://ftp.drupal.org/files/projects/drupal-10.0.0-beta1.tar.gz";s:4:"date";s:10:"1663358020";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:60:"Beta releases are not covered by Drupal security advisories.";}s:13:"10.0.0-alpha7";a:10:{s:4:"name";s:20:"drupal 10.0.0-alpha7";s:7:"version";s:13:"10.0.0-alpha7";s:3:"tag";s:13:"10.0.0-alpha7";s:6:"status";s:9:"published";s:12:"release_link";s:60:"https://www.drupal.org/project/drupal/releases/10.0.0-alpha7";s:13:"download_link";s:65:"https://ftp.drupal.org/files/projects/drupal-10.0.0-alpha7.tar.gz";s:4:"date";s:10:"1659633851";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:61:"Alpha releases are not covered by Drupal security advisories.";}s:13:"10.0.0-alpha6";a:10:{s:4:"name";s:20:"drupal 10.0.0-alpha6";s:7:"version";s:13:"10.0.0-alpha6";s:3:"tag";s:13:"10.0.0-alpha6";s:6:"status";s:9:"published";s:12:"release_link";s:60:"https://www.drupal.org/project/drupal/releases/10.0.0-alpha6";s:13:"download_link";s:65:"https://ftp.drupal.org/files/projects/drupal-10.0.0-alpha6.tar.gz";s:4:"date";s:10:"1657218740";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:8:"Insecure";i:1;s:9:"Bug fixes";i:2;s:12:"New features";}}s:8:"security";s:61:"Alpha releases are not covered by Drupal security advisories.";}s:13:"10.0.0-alpha5";a:10:{s:4:"name";s:20:"drupal 10.0.0-alpha5";s:7:"version";s:13:"10.0.0-alpha5";s:3:"tag";s:13:"10.0.0-alpha5";s:6:"status";s:9:"published";s:12:"release_link";s:60:"https://www.drupal.org/project/drupal/releases/10.0.0-alpha5";s:13:"download_link";s:65:"https://ftp.drupal.org/files/projects/drupal-10.0.0-alpha5.tar.gz";s:4:"date";s:10:"1654722993";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:8:"Insecure";i:1;s:9:"Bug fixes";i:2;s:12:"New features";}}s:8:"security";s:61:"Alpha releases are not covered by Drupal security advisories.";}s:13:"10.0.0-alpha4";a:10:{s:4:"name";s:20:"drupal 10.0.0-alpha4";s:7:"version";s:13:"10.0.0-alpha4";s:3:"tag";s:13:"10.0.0-alpha4";s:6:"status";s:9:"published";s:12:"release_link";s:60:"https://www.drupal.org/project/drupal/releases/10.0.0-alpha4";s:13:"download_link";s:65:"https://ftp.drupal.org/files/projects/drupal-10.0.0-alpha4.tar.gz";s:4:"date";s:10:"1651875601";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:8:"Insecure";i:1;s:9:"Bug fixes";i:2;s:12:"New features";}}s:8:"security";s:61:"Alpha releases are not covered by Drupal security advisories.";}s:13:"10.0.0-alpha3";a:10:{s:4:"name";s:20:"drupal 10.0.0-alpha3";s:7:"version";s:13:"10.0.0-alpha3";s:3:"tag";s:13:"10.0.0-alpha3";s:6:"status";s:9:"published";s:12:"release_link";s:60:"https://www.drupal.org/project/drupal/releases/10.0.0-alpha3";s:13:"download_link";s:65:"https://ftp.drupal.org/files/projects/drupal-10.0.0-alpha3.tar.gz";s:4:"date";s:10:"1649887793";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:8:"Insecure";i:1;s:9:"Bug fixes";i:2;s:12:"New features";}}s:8:"security";s:61:"Alpha releases are not covered by Drupal security advisories.";}s:13:"10.0.0-alpha2";a:10:{s:4:"name";s:20:"drupal 10.0.0-alpha2";s:7:"version";s:13:"10.0.0-alpha2";s:3:"tag";s:13:"10.0.0-alpha2";s:6:"status";s:9:"published";s:12:"release_link";s:60:"https://www.drupal.org/project/drupal/releases/10.0.0-alpha2";s:13:"download_link";s:65:"https://ftp.drupal.org/files/projects/drupal-10.0.0-alpha2.tar.gz";s:4:"date";s:10:"1645204305";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:8:"Insecure";i:1;s:9:"Bug fixes";i:2;s:12:"New features";}}s:8:"security";s:61:"Alpha releases are not covered by Drupal security advisories.";}s:13:"10.0.0-alpha1";a:10:{s:4:"name";s:20:"drupal 10.0.0-alpha1";s:7:"version";s:13:"10.0.0-alpha1";s:3:"tag";s:13:"10.0.0-alpha1";s:6:"status";s:9:"published";s:12:"release_link";s:60:"https://www.drupal.org/project/drupal/releases/10.0.0-alpha1";s:13:"download_link";s:65:"https://ftp.drupal.org/files/projects/drupal-10.0.0-alpha1.tar.gz";s:4:"date";s:10:"1643404041";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:1:{i:0;s:8:"Insecure";}}s:8:"security";s:61:"Alpha releases are not covered by Drupal security advisories.";}s:6:"9.5.11";a:10:{s:4:"name";s:13:"drupal 9.5.11";s:7:"version";s:6:"9.5.11";s:3:"tag";s:6:"9.5.11";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/9.5.11";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-9.5.11.tar.gz";s:4:"date";s:10:"1695228016";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:1:{i:0;s:15:"Security update";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"9.5.10";a:10:{s:4:"name";s:13:"drupal 9.5.10";s:7:"version";s:6:"9.5.10";s:3:"tag";s:6:"9.5.10";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/9.5.10";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-9.5.10.tar.gz";s:4:"date";s:10:"1688550984";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.5.9";a:10:{s:4:"name";s:12:"drupal 9.5.9";s:7:"version";s:5:"9.5.9";s:3:"tag";s:5:"9.5.9";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.5.9";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.5.9.tar.gz";s:4:"date";s:10:"1683121532";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:8:"Insecure";i:1;s:9:"Bug fixes";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.5.8";a:10:{s:4:"name";s:12:"drupal 9.5.8";s:7:"version";s:5:"9.5.8";s:3:"tag";s:5:"9.5.8";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.5.8";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.5.8.tar.gz";s:4:"date";s:10:"1681922649";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.5.7";a:10:{s:4:"name";s:12:"drupal 9.5.7";s:7:"version";s:5:"9.5.7";s:3:"tag";s:5:"9.5.7";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.5.7";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.5.7.tar.gz";s:4:"date";s:10:"1679677448";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.5.6";a:10:{s:4:"name";s:12:"drupal 9.5.6";s:7:"version";s:5:"9.5.6";s:3:"tag";s:5:"9.5.6";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.5.6";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.5.6.tar.gz";s:4:"date";s:10:"1679664389";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.5.5";a:10:{s:4:"name";s:12:"drupal 9.5.5";s:7:"version";s:5:"9.5.5";s:3:"tag";s:5:"9.5.5";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.5.5";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.5.5.tar.gz";s:4:"date";s:10:"1678902101";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.5.4";a:10:{s:4:"name";s:12:"drupal 9.5.4";s:7:"version";s:5:"9.5.4";s:3:"tag";s:5:"9.5.4";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.5.4";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.5.4.tar.gz";s:4:"date";s:10:"1677680813";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.5.3";a:10:{s:4:"name";s:12:"drupal 9.5.3";s:7:"version";s:5:"9.5.3";s:3:"tag";s:5:"9.5.3";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.5.3";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.5.3.tar.gz";s:4:"date";s:10:"1675281829";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.5.2";a:10:{s:4:"name";s:12:"drupal 9.5.2";s:7:"version";s:5:"9.5.2";s:3:"tag";s:5:"9.5.2";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.5.2";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.5.2.tar.gz";s:4:"date";s:10:"1674066112";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.5.1";a:10:{s:4:"name";s:12:"drupal 9.5.1";s:7:"version";s:5:"9.5.1";s:3:"tag";s:5:"9.5.1";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.5.1";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.5.1.tar.gz";s:4:"date";s:10:"1672849046";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.5.0";a:10:{s:4:"name";s:12:"drupal 9.5.0";s:7:"version";s:5:"9.5.0";s:3:"tag";s:5:"9.5.0";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.5.0";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.5.0.tar.gz";s:4:"date";s:10:"1671115839";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:9:"9.5.0-rc2";a:10:{s:4:"name";s:16:"drupal 9.5.0-rc2";s:7:"version";s:9:"9.5.0-rc2";s:3:"tag";s:9:"9.5.0-rc2";s:6:"status";s:9:"published";s:12:"release_link";s:56:"https://www.drupal.org/project/drupal/releases/9.5.0-rc2";s:13:"download_link";s:61:"https://ftp.drupal.org/files/projects/drupal-9.5.0-rc2.tar.gz";s:4:"date";s:10:"1670593040";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:58:"RC releases are not covered by Drupal security advisories.";}s:9:"9.5.0-rc1";a:10:{s:4:"name";s:16:"drupal 9.5.0-rc1";s:7:"version";s:9:"9.5.0-rc1";s:3:"tag";s:9:"9.5.0-rc1";s:6:"status";s:9:"published";s:12:"release_link";s:56:"https://www.drupal.org/project/drupal/releases/9.5.0-rc1";s:13:"download_link";s:61:"https://ftp.drupal.org/files/projects/drupal-9.5.0-rc1.tar.gz";s:4:"date";s:10:"1668611189";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:58:"RC releases are not covered by Drupal security advisories.";}s:11:"9.5.0-beta2";a:10:{s:4:"name";s:18:"drupal 9.5.0-beta2";s:7:"version";s:11:"9.5.0-beta2";s:3:"tag";s:11:"9.5.0-beta2";s:6:"status";s:9:"published";s:12:"release_link";s:58:"https://www.drupal.org/project/drupal/releases/9.5.0-beta2";s:13:"download_link";s:63:"https://ftp.drupal.org/files/projects/drupal-9.5.0-beta2.tar.gz";s:4:"date";s:10:"1664463958";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:60:"Beta releases are not covered by Drupal security advisories.";}s:11:"9.5.0-beta1";a:10:{s:4:"name";s:18:"drupal 9.5.0-beta1";s:7:"version";s:11:"9.5.0-beta1";s:3:"tag";s:11:"9.5.0-beta1";s:6:"status";s:9:"published";s:12:"release_link";s:58:"https://www.drupal.org/project/drupal/releases/9.5.0-beta1";s:13:"download_link";s:63:"https://ftp.drupal.org/files/projects/drupal-9.5.0-beta1.tar.gz";s:4:"date";s:10:"1663358587";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:60:"Beta releases are not covered by Drupal security advisories.";}s:6:"9.4.15";a:10:{s:4:"name";s:13:"drupal 9.4.15";s:7:"version";s:6:"9.4.15";s:3:"tag";s:6:"9.4.15";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/9.4.15";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-9.4.15.tar.gz";s:4:"date";s:10:"1683122076";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"9.4.14";a:10:{s:4:"name";s:13:"drupal 9.4.14";s:7:"version";s:6:"9.4.14";s:3:"tag";s:6:"9.4.14";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/9.4.14";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-9.4.14.tar.gz";s:4:"date";s:10:"1681922120";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"9.4.13";a:10:{s:4:"name";s:13:"drupal 9.4.13";s:7:"version";s:6:"9.4.13";s:3:"tag";s:6:"9.4.13";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/9.4.13";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-9.4.13.tar.gz";s:4:"date";s:10:"1679665413";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"9.4.12";a:10:{s:4:"name";s:13:"drupal 9.4.12";s:7:"version";s:6:"9.4.12";s:3:"tag";s:6:"9.4.12";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/9.4.12";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-9.4.12.tar.gz";s:4:"date";s:10:"1678901516";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"9.4.11";a:10:{s:4:"name";s:13:"drupal 9.4.11";s:7:"version";s:6:"9.4.11";s:3:"tag";s:6:"9.4.11";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/9.4.11";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-9.4.11.tar.gz";s:4:"date";s:10:"1675282255";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"9.4.10";a:10:{s:4:"name";s:13:"drupal 9.4.10";s:7:"version";s:6:"9.4.10";s:3:"tag";s:6:"9.4.10";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/9.4.10";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-9.4.10.tar.gz";s:4:"date";s:10:"1674066615";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.4.9";a:10:{s:4:"name";s:12:"drupal 9.4.9";s:7:"version";s:5:"9.4.9";s:3:"tag";s:5:"9.4.9";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.4.9";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.4.9.tar.gz";s:4:"date";s:10:"1670421053";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.4.8";a:10:{s:4:"name";s:12:"drupal 9.4.8";s:7:"version";s:5:"9.4.8";s:3:"tag";s:5:"9.4.8";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.4.8";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.4.8.tar.gz";s:4:"date";s:10:"1665072393";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.4.7";a:10:{s:4:"name";s:12:"drupal 9.4.7";s:7:"version";s:5:"9.4.7";s:3:"tag";s:5:"9.4.7";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.4.7";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.4.7.tar.gz";s:4:"date";s:10:"1664383239";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:8:"Insecure";i:1;s:15:"Security update";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.4.6";a:10:{s:4:"name";s:12:"drupal 9.4.6";s:7:"version";s:5:"9.4.6";s:3:"tag";s:5:"9.4.6";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.4.6";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.4.6.tar.gz";s:4:"date";s:10:"1663681319";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.4.5";a:10:{s:4:"name";s:12:"drupal 9.4.5";s:7:"version";s:5:"9.4.5";s:3:"tag";s:5:"9.4.5";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.4.5";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.4.5.tar.gz";s:4:"date";s:10:"1659545453";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.4.4";a:10:{s:4:"name";s:12:"drupal 9.4.4";s:7:"version";s:5:"9.4.4";s:3:"tag";s:5:"9.4.4";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.4.4";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.4.4.tar.gz";s:4:"date";s:10:"1659037490";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.4.3";a:10:{s:4:"name";s:12:"drupal 9.4.3";s:7:"version";s:5:"9.4.3";s:3:"tag";s:5:"9.4.3";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.4.3";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.4.3.tar.gz";s:4:"date";s:10:"1658333415";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.4.2";a:10:{s:4:"name";s:12:"drupal 9.4.2";s:7:"version";s:5:"9.4.2";s:3:"tag";s:5:"9.4.2";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.4.2";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.4.2.tar.gz";s:4:"date";s:10:"1657157309";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.4.1";a:10:{s:4:"name";s:12:"drupal 9.4.1";s:7:"version";s:5:"9.4.1";s:3:"tag";s:5:"9.4.1";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.4.1";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.4.1.tar.gz";s:4:"date";s:10:"1655845511";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.4.0";a:10:{s:4:"name";s:12:"drupal 9.4.0";s:7:"version";s:5:"9.4.0";s:3:"tag";s:5:"9.4.0";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.4.0";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.4.0.tar.gz";s:4:"date";s:10:"1655311138";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:8:"Insecure";i:1;s:9:"Bug fixes";i:2;s:12:"New features";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:9:"9.4.0-rc2";a:10:{s:4:"name";s:16:"drupal 9.4.0-rc2";s:7:"version";s:9:"9.4.0-rc2";s:3:"tag";s:9:"9.4.0-rc2";s:6:"status";s:9:"published";s:12:"release_link";s:56:"https://www.drupal.org/project/drupal/releases/9.4.0-rc2";s:13:"download_link";s:61:"https://ftp.drupal.org/files/projects/drupal-9.4.0-rc2.tar.gz";s:4:"date";s:10:"1654890055";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:15:"Security update";i:1;s:9:"Bug fixes";i:2;s:8:"Insecure";}}s:8:"security";s:58:"RC releases are not covered by Drupal security advisories.";}s:9:"9.4.0-rc1";a:10:{s:4:"name";s:16:"drupal 9.4.0-rc1";s:7:"version";s:9:"9.4.0-rc1";s:3:"tag";s:9:"9.4.0-rc1";s:6:"status";s:9:"published";s:12:"release_link";s:56:"https://www.drupal.org/project/drupal/releases/9.4.0-rc1";s:13:"download_link";s:61:"https://ftp.drupal.org/files/projects/drupal-9.4.0-rc1.tar.gz";s:4:"date";s:10:"1654740019";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:58:"RC releases are not covered by Drupal security advisories.";}s:11:"9.4.0-beta1";a:10:{s:4:"name";s:18:"drupal 9.4.0-beta1";s:7:"version";s:11:"9.4.0-beta1";s:3:"tag";s:11:"9.4.0-beta1";s:6:"status";s:9:"published";s:12:"release_link";s:58:"https://www.drupal.org/project/drupal/releases/9.4.0-beta1";s:13:"download_link";s:63:"https://ftp.drupal.org/files/projects/drupal-9.4.0-beta1.tar.gz";s:4:"date";s:10:"1653938214";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:60:"Beta releases are not covered by Drupal security advisories.";}s:12:"9.4.0-alpha1";a:10:{s:4:"name";s:19:"drupal 9.4.0-alpha1";s:7:"version";s:12:"9.4.0-alpha1";s:3:"tag";s:12:"9.4.0-alpha1";s:6:"status";s:9:"published";s:12:"release_link";s:59:"https://www.drupal.org/project/drupal/releases/9.4.0-alpha1";s:13:"download_link";s:64:"https://ftp.drupal.org/files/projects/drupal-9.4.0-alpha1.tar.gz";s:4:"date";s:10:"1651875606";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:8:"Insecure";i:1;s:9:"Bug fixes";i:2;s:12:"New features";}}s:8:"security";s:61:"Alpha releases are not covered by Drupal security advisories.";}s:6:"9.3.22";a:10:{s:4:"name";s:13:"drupal 9.3.22";s:7:"version";s:6:"9.3.22";s:3:"tag";s:6:"9.3.22";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/9.3.22";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-9.3.22.tar.gz";s:4:"date";s:10:"1664382666";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"9.3.21";a:10:{s:4:"name";s:13:"drupal 9.3.21";s:7:"version";s:6:"9.3.21";s:3:"tag";s:6:"9.3.21";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/9.3.21";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-9.3.21.tar.gz";s:4:"date";s:10:"1659544886";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"9.3.20";a:10:{s:4:"name";s:13:"drupal 9.3.20";s:7:"version";s:6:"9.3.20";s:3:"tag";s:6:"9.3.20";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/9.3.20";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-9.3.20.tar.gz";s:4:"date";s:10:"1659037977";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"9.3.19";a:10:{s:4:"name";s:13:"drupal 9.3.19";s:7:"version";s:6:"9.3.19";s:3:"tag";s:6:"9.3.19";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/9.3.19";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-9.3.19.tar.gz";s:4:"date";s:10:"1658333887";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"9.3.18";a:10:{s:4:"name";s:13:"drupal 9.3.18";s:7:"version";s:6:"9.3.18";s:3:"tag";s:6:"9.3.18";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/9.3.18";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-9.3.18.tar.gz";s:4:"date";s:10:"1657238772";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"9.3.17";a:10:{s:4:"name";s:13:"drupal 9.3.17";s:7:"version";s:6:"9.3.17";s:3:"tag";s:6:"9.3.17";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/9.3.17";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-9.3.17.tar.gz";s:4:"date";s:10:"1655846622";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"9.3.16";a:10:{s:4:"name";s:13:"drupal 9.3.16";s:7:"version";s:6:"9.3.16";s:3:"tag";s:6:"9.3.16";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/9.3.16";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-9.3.16.tar.gz";s:4:"date";s:10:"1654888736";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"9.3.15";a:10:{s:4:"name";s:13:"drupal 9.3.15";s:7:"version";s:6:"9.3.15";s:3:"tag";s:6:"9.3.15";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/9.3.15";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-9.3.15.tar.gz";s:4:"date";s:10:"1654098765";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"9.3.14";a:10:{s:4:"name";s:13:"drupal 9.3.14";s:7:"version";s:6:"9.3.14";s:3:"tag";s:6:"9.3.14";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/9.3.14";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-9.3.14.tar.gz";s:4:"date";s:10:"1653506291";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"9.3.13";a:10:{s:4:"name";s:13:"drupal 9.3.13";s:7:"version";s:6:"9.3.13";s:3:"tag";s:6:"9.3.13";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/9.3.13";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-9.3.13.tar.gz";s:4:"date";s:10:"1652261874";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"9.3.12";a:10:{s:4:"name";s:13:"drupal 9.3.12";s:7:"version";s:6:"9.3.12";s:3:"tag";s:6:"9.3.12";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/9.3.12";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-9.3.12.tar.gz";s:4:"date";s:10:"1650467536";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"9.3.11";a:10:{s:4:"name";s:13:"drupal 9.3.11";s:7:"version";s:6:"9.3.11";s:3:"tag";s:6:"9.3.11";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/9.3.11";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-9.3.11.tar.gz";s:4:"date";s:10:"1649897391";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"9.3.10";a:10:{s:4:"name";s:13:"drupal 9.3.10";s:7:"version";s:6:"9.3.10";s:3:"tag";s:6:"9.3.10";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/9.3.10";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-9.3.10.tar.gz";s:4:"date";s:10:"1649890098";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:8:"Insecure";i:1;s:9:"Bug fixes";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.3.9";a:10:{s:4:"name";s:12:"drupal 9.3.9";s:7:"version";s:5:"9.3.9";s:3:"tag";s:5:"9.3.9";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.3.9";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.3.9.tar.gz";s:4:"date";s:10:"1647899360";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.3.8";a:10:{s:4:"name";s:12:"drupal 9.3.8";s:7:"version";s:5:"9.3.8";s:3:"tag";s:5:"9.3.8";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.3.8";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.3.8.tar.gz";s:4:"date";s:10:"1647446914";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.3.7";a:10:{s:4:"name";s:12:"drupal 9.3.7";s:7:"version";s:5:"9.3.7";s:3:"tag";s:5:"9.3.7";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.3.7";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.3.7.tar.gz";s:4:"date";s:10:"1646300599";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.3.6";a:10:{s:4:"name";s:12:"drupal 9.3.6";s:7:"version";s:5:"9.3.6";s:3:"tag";s:5:"9.3.6";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.3.6";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.3.6.tar.gz";s:4:"date";s:10:"1645029460";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.3.5";a:10:{s:4:"name";s:12:"drupal 9.3.5";s:7:"version";s:5:"9.3.5";s:3:"tag";s:5:"9.3.5";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.3.5";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.3.5.tar.gz";s:4:"date";s:10:"1644011676";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.3.4";a:10:{s:4:"name";s:12:"drupal 9.3.4";s:7:"version";s:5:"9.3.4";s:3:"tag";s:5:"9.3.4";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.3.4";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.3.4.tar.gz";s:4:"date";s:10:"1643832805";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.3.3";a:10:{s:4:"name";s:12:"drupal 9.3.3";s:7:"version";s:5:"9.3.3";s:3:"tag";s:5:"9.3.3";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.3.3";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.3.3.tar.gz";s:4:"date";s:10:"1642607769";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.3.2";a:10:{s:4:"name";s:12:"drupal 9.3.2";s:7:"version";s:5:"9.3.2";s:3:"tag";s:5:"9.3.2";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.3.2";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.3.2.tar.gz";s:4:"date";s:10:"1641351799";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.3.1";a:10:{s:4:"name";s:12:"drupal 9.3.1";s:7:"version";s:5:"9.3.1";s:3:"tag";s:5:"9.3.1";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.3.1";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.3.1.tar.gz";s:4:"date";s:10:"1641342679";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.3.0";a:10:{s:4:"name";s:12:"drupal 9.3.0";s:7:"version";s:5:"9.3.0";s:3:"tag";s:5:"9.3.0";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.3.0";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.3.0.tar.gz";s:4:"date";s:10:"1639051276";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:9:"9.3.0-rc1";a:10:{s:4:"name";s:16:"drupal 9.3.0-rc1";s:7:"version";s:9:"9.3.0-rc1";s:3:"tag";s:9:"9.3.0-rc1";s:6:"status";s:9:"published";s:12:"release_link";s:56:"https://www.drupal.org/project/drupal/releases/9.3.0-rc1";s:13:"download_link";s:61:"https://ftp.drupal.org/files/projects/drupal-9.3.0-rc1.tar.gz";s:4:"date";s:10:"1637959424";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:58:"RC releases are not covered by Drupal security advisories.";}s:11:"9.3.0-beta3";a:10:{s:4:"name";s:18:"drupal 9.3.0-beta3";s:7:"version";s:11:"9.3.0-beta3";s:3:"tag";s:11:"9.3.0-beta3";s:6:"status";s:9:"published";s:12:"release_link";s:58:"https://www.drupal.org/project/drupal/releases/9.3.0-beta3";s:13:"download_link";s:63:"https://ftp.drupal.org/files/projects/drupal-9.3.0-beta3.tar.gz";s:4:"date";s:10:"1637764182";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:60:"Beta releases are not covered by Drupal security advisories.";}s:11:"9.3.0-beta2";a:10:{s:4:"name";s:18:"drupal 9.3.0-beta2";s:7:"version";s:11:"9.3.0-beta2";s:3:"tag";s:11:"9.3.0-beta2";s:6:"status";s:9:"published";s:12:"release_link";s:58:"https://www.drupal.org/project/drupal/releases/9.3.0-beta2";s:13:"download_link";s:63:"https://ftp.drupal.org/files/projects/drupal-9.3.0-beta2.tar.gz";s:4:"date";s:10:"1637196496";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:60:"Beta releases are not covered by Drupal security advisories.";}s:11:"9.3.0-beta1";a:10:{s:4:"name";s:18:"drupal 9.3.0-beta1";s:7:"version";s:11:"9.3.0-beta1";s:3:"tag";s:11:"9.3.0-beta1";s:6:"status";s:9:"published";s:12:"release_link";s:58:"https://www.drupal.org/project/drupal/releases/9.3.0-beta1";s:13:"download_link";s:63:"https://ftp.drupal.org/files/projects/drupal-9.3.0-beta1.tar.gz";s:4:"date";s:10:"1636746050";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:60:"Beta releases are not covered by Drupal security advisories.";}s:12:"9.3.0-alpha1";a:10:{s:4:"name";s:19:"drupal 9.3.0-alpha1";s:7:"version";s:12:"9.3.0-alpha1";s:3:"tag";s:12:"9.3.0-alpha1";s:6:"status";s:9:"published";s:12:"release_link";s:59:"https://www.drupal.org/project/drupal/releases/9.3.0-alpha1";s:13:"download_link";s:64:"https://ftp.drupal.org/files/projects/drupal-9.3.0-alpha1.tar.gz";s:4:"date";s:10:"1635510285";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:61:"Alpha releases are not covered by Drupal security advisories.";}s:6:"9.2.21";a:10:{s:4:"name";s:13:"drupal 9.2.21";s:7:"version";s:6:"9.2.21";s:3:"tag";s:6:"9.2.21";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/9.2.21";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-9.2.21.tar.gz";s:4:"date";s:10:"1654889475";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"9.2.20";a:10:{s:4:"name";s:13:"drupal 9.2.20";s:7:"version";s:6:"9.2.20";s:3:"tag";s:6:"9.2.20";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/9.2.20";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-9.2.20.tar.gz";s:4:"date";s:10:"1653507225";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"9.2.19";a:10:{s:4:"name";s:13:"drupal 9.2.19";s:7:"version";s:6:"9.2.19";s:3:"tag";s:6:"9.2.19";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/9.2.19";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-9.2.19.tar.gz";s:4:"date";s:10:"1652306637";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"9.2.18";a:10:{s:4:"name";s:13:"drupal 9.2.18";s:7:"version";s:6:"9.2.18";s:3:"tag";s:6:"9.2.18";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/9.2.18";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-9.2.18.tar.gz";s:4:"date";s:10:"1650466972";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"9.2.17";a:10:{s:4:"name";s:13:"drupal 9.2.17";s:7:"version";s:6:"9.2.17";s:3:"tag";s:6:"9.2.17";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/9.2.17";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-9.2.17.tar.gz";s:4:"date";s:10:"1649898006";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"9.2.16";a:10:{s:4:"name";s:13:"drupal 9.2.16";s:7:"version";s:6:"9.2.16";s:3:"tag";s:6:"9.2.16";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/9.2.16";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-9.2.16.tar.gz";s:4:"date";s:10:"1647898826";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"9.2.15";a:10:{s:4:"name";s:13:"drupal 9.2.15";s:7:"version";s:6:"9.2.15";s:3:"tag";s:6:"9.2.15";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/9.2.15";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-9.2.15.tar.gz";s:4:"date";s:10:"1647447411";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"9.2.14";a:10:{s:4:"name";s:13:"drupal 9.2.14";s:7:"version";s:6:"9.2.14";s:3:"tag";s:6:"9.2.14";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/9.2.14";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-9.2.14.tar.gz";s:4:"date";s:10:"1647027629";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"9.2.13";a:10:{s:4:"name";s:13:"drupal 9.2.13";s:7:"version";s:6:"9.2.13";s:3:"tag";s:6:"9.2.13";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/9.2.13";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-9.2.13.tar.gz";s:4:"date";s:10:"1645029955";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"9.2.12";a:10:{s:4:"name";s:13:"drupal 9.2.12";s:7:"version";s:6:"9.2.12";s:3:"tag";s:6:"9.2.12";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/9.2.12";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-9.2.12.tar.gz";s:4:"date";s:10:"1644012448";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"9.2.11";a:10:{s:4:"name";s:13:"drupal 9.2.11";s:7:"version";s:6:"9.2.11";s:3:"tag";s:6:"9.2.11";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/9.2.11";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-9.2.11.tar.gz";s:4:"date";s:10:"1642608353";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:8:"Insecure";i:1;s:15:"Security update";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"9.2.10";a:10:{s:4:"name";s:13:"drupal 9.2.10";s:7:"version";s:6:"9.2.10";s:3:"tag";s:6:"9.2.10";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/9.2.10";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-9.2.10.tar.gz";s:4:"date";s:10:"1637765544";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.2.9";a:10:{s:4:"name";s:12:"drupal 9.2.9";s:7:"version";s:5:"9.2.9";s:3:"tag";s:5:"9.2.9";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.2.9";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.2.9.tar.gz";s:4:"date";s:10:"1637184936";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.2.8";a:10:{s:4:"name";s:12:"drupal 9.2.8";s:7:"version";s:5:"9.2.8";s:3:"tag";s:5:"9.2.8";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.2.8";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.2.8.tar.gz";s:4:"date";s:10:"1635961216";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:8:"Insecure";i:1;s:9:"Bug fixes";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.2.7";a:10:{s:4:"name";s:12:"drupal 9.2.7";s:7:"version";s:5:"9.2.7";s:3:"tag";s:5:"9.2.7";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.2.7";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.2.7.tar.gz";s:4:"date";s:10:"1633544267";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.2.6";a:10:{s:4:"name";s:12:"drupal 9.2.6";s:7:"version";s:5:"9.2.6";s:3:"tag";s:5:"9.2.6";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.2.6";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.2.6.tar.gz";s:4:"date";s:10:"1631721555";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.2.5";a:10:{s:4:"name";s:12:"drupal 9.2.5";s:7:"version";s:5:"9.2.5";s:3:"tag";s:5:"9.2.5";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.2.5";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.2.5.tar.gz";s:4:"date";s:10:"1630534729";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.2.4";a:10:{s:4:"name";s:12:"drupal 9.2.4";s:7:"version";s:5:"9.2.4";s:3:"tag";s:5:"9.2.4";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.2.4";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.2.4.tar.gz";s:4:"date";s:10:"1628791178";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.2.3";a:10:{s:4:"name";s:12:"drupal 9.2.3";s:7:"version";s:5:"9.2.3";s:3:"tag";s:5:"9.2.3";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.2.3";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.2.3.tar.gz";s:4:"date";s:10:"1627997922";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.2.2";a:10:{s:4:"name";s:12:"drupal 9.2.2";s:7:"version";s:5:"9.2.2";s:3:"tag";s:5:"9.2.2";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.2.2";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.2.2.tar.gz";s:4:"date";s:10:"1626882385";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.2.1";a:10:{s:4:"name";s:12:"drupal 9.2.1";s:7:"version";s:5:"9.2.1";s:3:"tag";s:5:"9.2.1";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.2.1";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.2.1.tar.gz";s:4:"date";s:10:"1625664286";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.2.0";a:10:{s:4:"name";s:12:"drupal 9.2.0";s:7:"version";s:5:"9.2.0";s:3:"tag";s:5:"9.2.0";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.2.0";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.2.0.tar.gz";s:4:"date";s:10:"1623847798";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:9:"9.2.0-rc1";a:10:{s:4:"name";s:16:"drupal 9.2.0-rc1";s:7:"version";s:9:"9.2.0-rc1";s:3:"tag";s:9:"9.2.0-rc1";s:6:"status";s:9:"published";s:12:"release_link";s:56:"https://www.drupal.org/project/drupal/releases/9.2.0-rc1";s:13:"download_link";s:61:"https://ftp.drupal.org/files/projects/drupal-9.2.0-rc1.tar.gz";s:4:"date";s:10:"1623080867";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:58:"RC releases are not covered by Drupal security advisories.";}s:11:"9.2.0-beta3";a:10:{s:4:"name";s:18:"drupal 9.2.0-beta3";s:7:"version";s:11:"9.2.0-beta3";s:3:"tag";s:11:"9.2.0-beta3";s:6:"status";s:9:"published";s:12:"release_link";s:58:"https://www.drupal.org/project/drupal/releases/9.2.0-beta3";s:13:"download_link";s:63:"https://ftp.drupal.org/files/projects/drupal-9.2.0-beta3.tar.gz";s:4:"date";s:10:"1622207568";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:60:"Beta releases are not covered by Drupal security advisories.";}s:11:"9.2.0-beta2";a:10:{s:4:"name";s:18:"drupal 9.2.0-beta2";s:7:"version";s:11:"9.2.0-beta2";s:3:"tag";s:11:"9.2.0-beta2";s:6:"status";s:9:"published";s:12:"release_link";s:58:"https://www.drupal.org/project/drupal/releases/9.2.0-beta2";s:13:"download_link";s:63:"https://ftp.drupal.org/files/projects/drupal-9.2.0-beta2.tar.gz";s:4:"date";s:10:"1622068611";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:4:{i:0;s:15:"Security update";i:1;s:9:"Bug fixes";i:2;s:12:"New features";i:3;s:8:"Insecure";}}s:8:"security";s:60:"Beta releases are not covered by Drupal security advisories.";}s:11:"9.2.0-beta1";a:10:{s:4:"name";s:18:"drupal 9.2.0-beta1";s:7:"version";s:11:"9.2.0-beta1";s:3:"tag";s:11:"9.2.0-beta1";s:6:"status";s:9:"published";s:12:"release_link";s:58:"https://www.drupal.org/project/drupal/releases/9.2.0-beta1";s:13:"download_link";s:63:"https://ftp.drupal.org/files/projects/drupal-9.2.0-beta1.tar.gz";s:4:"date";s:10:"1621506248";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:8:"Insecure";i:1;s:9:"Bug fixes";i:2;s:12:"New features";}}s:8:"security";s:60:"Beta releases are not covered by Drupal security advisories.";}s:12:"9.2.0-alpha1";a:10:{s:4:"name";s:19:"drupal 9.2.0-alpha1";s:7:"version";s:12:"9.2.0-alpha1";s:3:"tag";s:12:"9.2.0-alpha1";s:6:"status";s:9:"published";s:12:"release_link";s:59:"https://www.drupal.org/project/drupal/releases/9.2.0-alpha1";s:13:"download_link";s:64:"https://ftp.drupal.org/files/projects/drupal-9.2.0-alpha1.tar.gz";s:4:"date";s:10:"1620291652";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:61:"Alpha releases are not covered by Drupal security advisories.";}s:6:"9.1.15";a:10:{s:4:"name";s:13:"drupal 9.1.15";s:7:"version";s:6:"9.1.15";s:3:"tag";s:6:"9.1.15";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/9.1.15";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-9.1.15.tar.gz";s:4:"date";s:10:"1637766681";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"9.1.14";a:10:{s:4:"name";s:13:"drupal 9.1.14";s:7:"version";s:6:"9.1.14";s:3:"tag";s:6:"9.1.14";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/9.1.14";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-9.1.14.tar.gz";s:4:"date";s:10:"1637185450";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"9.1.13";a:10:{s:4:"name";s:13:"drupal 9.1.13";s:7:"version";s:6:"9.1.13";s:3:"tag";s:6:"9.1.13";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/9.1.13";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-9.1.13.tar.gz";s:4:"date";s:10:"1631722011";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"9.1.12";a:10:{s:4:"name";s:13:"drupal 9.1.12";s:7:"version";s:6:"9.1.12";s:3:"tag";s:6:"9.1.12";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/9.1.12";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-9.1.12.tar.gz";s:4:"date";s:10:"1628791786";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"9.1.11";a:10:{s:4:"name";s:13:"drupal 9.1.11";s:7:"version";s:6:"9.1.11";s:3:"tag";s:6:"9.1.11";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/9.1.11";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-9.1.11.tar.gz";s:4:"date";s:10:"1626882849";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"9.1.10";a:10:{s:4:"name";s:13:"drupal 9.1.10";s:7:"version";s:6:"9.1.10";s:3:"tag";s:6:"9.1.10";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/9.1.10";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-9.1.10.tar.gz";s:4:"date";s:10:"1622828120";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.1.9";a:10:{s:4:"name";s:12:"drupal 9.1.9";s:7:"version";s:5:"9.1.9";s:3:"tag";s:5:"9.1.9";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.1.9";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.1.9.tar.gz";s:4:"date";s:10:"1622056478";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.1.8";a:10:{s:4:"name";s:12:"drupal 9.1.8";s:7:"version";s:5:"9.1.8";s:3:"tag";s:5:"9.1.8";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.1.8";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.1.8.tar.gz";s:4:"date";s:10:"1620214182";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.1.7";a:10:{s:4:"name";s:12:"drupal 9.1.7";s:7:"version";s:5:"9.1.7";s:3:"tag";s:5:"9.1.7";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.1.7";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.1.7.tar.gz";s:4:"date";s:10:"1619022156";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.1.6";a:10:{s:4:"name";s:12:"drupal 9.1.6";s:7:"version";s:5:"9.1.6";s:3:"tag";s:5:"9.1.6";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.1.6";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.1.6.tar.gz";s:4:"date";s:10:"1617795446";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.1.5";a:10:{s:4:"name";s:12:"drupal 9.1.5";s:7:"version";s:5:"9.1.5";s:3:"tag";s:5:"9.1.5";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.1.5";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.1.5.tar.gz";s:4:"date";s:10:"1614869503";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.1.4";a:10:{s:4:"name";s:12:"drupal 9.1.4";s:7:"version";s:5:"9.1.4";s:3:"tag";s:5:"9.1.4";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.1.4";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.1.4.tar.gz";s:4:"date";s:10:"1612380948";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.1.3";a:10:{s:4:"name";s:12:"drupal 9.1.3";s:7:"version";s:5:"9.1.3";s:3:"tag";s:5:"9.1.3";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.1.3";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.1.3.tar.gz";s:4:"date";s:10:"1611161215";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.1.2";a:10:{s:4:"name";s:12:"drupal 9.1.2";s:7:"version";s:5:"9.1.2";s:3:"tag";s:5:"9.1.2";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.1.2";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.1.2.tar.gz";s:4:"date";s:10:"1609984407";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:8:"Insecure";i:1;s:9:"Bug fixes";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.1.1";a:10:{s:4:"name";s:12:"drupal 9.1.1";s:7:"version";s:5:"9.1.1";s:3:"tag";s:5:"9.1.1";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.1.1";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.1.1.tar.gz";s:4:"date";s:10:"1609979034";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.1.0";a:10:{s:4:"name";s:12:"drupal 9.1.0";s:7:"version";s:5:"9.1.0";s:3:"tag";s:5:"9.1.0";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.1.0";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.1.0.tar.gz";s:4:"date";s:10:"1606933254";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:9:"9.1.0-rc3";a:10:{s:4:"name";s:16:"drupal 9.1.0-rc3";s:7:"version";s:9:"9.1.0-rc3";s:3:"tag";s:9:"9.1.0-rc3";s:6:"status";s:9:"published";s:12:"release_link";s:56:"https://www.drupal.org/project/drupal/releases/9.1.0-rc3";s:13:"download_link";s:61:"https://ftp.drupal.org/files/projects/drupal-9.1.0-rc3.tar.gz";s:4:"date";s:10:"1606357271";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:58:"RC releases are not covered by Drupal security advisories.";}s:9:"9.1.0-rc2";a:10:{s:4:"name";s:16:"drupal 9.1.0-rc2";s:7:"version";s:9:"9.1.0-rc2";s:3:"tag";s:9:"9.1.0-rc2";s:6:"status";s:9:"published";s:12:"release_link";s:56:"https://www.drupal.org/project/drupal/releases/9.1.0-rc2";s:13:"download_link";s:61:"https://ftp.drupal.org/files/projects/drupal-9.1.0-rc2.tar.gz";s:4:"date";s:10:"1606332982";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:58:"RC releases are not covered by Drupal security advisories.";}s:9:"9.1.0-rc1";a:10:{s:4:"name";s:16:"drupal 9.1.0-rc1";s:7:"version";s:9:"9.1.0-rc1";s:3:"tag";s:9:"9.1.0-rc1";s:6:"status";s:9:"published";s:12:"release_link";s:56:"https://www.drupal.org/project/drupal/releases/9.1.0-rc1";s:13:"download_link";s:61:"https://ftp.drupal.org/files/projects/drupal-9.1.0-rc1.tar.gz";s:4:"date";s:10:"1605722782";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:4:{i:0;s:15:"Security update";i:1;s:9:"Bug fixes";i:2;s:12:"New features";i:3;s:8:"Insecure";}}s:8:"security";s:58:"RC releases are not covered by Drupal security advisories.";}s:11:"9.1.0-beta1";a:10:{s:4:"name";s:18:"drupal 9.1.0-beta1";s:7:"version";s:11:"9.1.0-beta1";s:3:"tag";s:11:"9.1.0-beta1";s:6:"status";s:9:"published";s:12:"release_link";s:58:"https://www.drupal.org/project/drupal/releases/9.1.0-beta1";s:13:"download_link";s:63:"https://ftp.drupal.org/files/projects/drupal-9.1.0-beta1.tar.gz";s:4:"date";s:10:"1604672644";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:60:"Beta releases are not covered by Drupal security advisories.";}s:12:"9.1.0-alpha1";a:10:{s:4:"name";s:19:"drupal 9.1.0-alpha1";s:7:"version";s:12:"9.1.0-alpha1";s:3:"tag";s:12:"9.1.0-alpha1";s:6:"status";s:9:"published";s:12:"release_link";s:59:"https://www.drupal.org/project/drupal/releases/9.1.0-alpha1";s:13:"download_link";s:64:"https://ftp.drupal.org/files/projects/drupal-9.1.0-alpha1.tar.gz";s:4:"date";s:10:"1603466665";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:61:"Alpha releases are not covered by Drupal security advisories.";}s:6:"9.0.14";a:10:{s:4:"name";s:13:"drupal 9.0.14";s:7:"version";s:6:"9.0.14";s:3:"tag";s:6:"9.0.14";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/9.0.14";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-9.0.14.tar.gz";s:4:"date";s:10:"1622055778";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"9.0.13";a:10:{s:4:"name";s:13:"drupal 9.0.13";s:7:"version";s:6:"9.0.13";s:3:"tag";s:6:"9.0.13";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/9.0.13";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-9.0.13.tar.gz";s:4:"date";s:10:"1620218506";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"9.0.12";a:10:{s:4:"name";s:13:"drupal 9.0.12";s:7:"version";s:6:"9.0.12";s:3:"tag";s:6:"9.0.12";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/9.0.12";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-9.0.12.tar.gz";s:4:"date";s:10:"1619020951";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"9.0.11";a:10:{s:4:"name";s:13:"drupal 9.0.11";s:7:"version";s:6:"9.0.11";s:3:"tag";s:6:"9.0.11";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/9.0.11";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-9.0.11.tar.gz";s:4:"date";s:10:"1611161749";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"9.0.10";a:10:{s:4:"name";s:13:"drupal 9.0.10";s:7:"version";s:6:"9.0.10";s:3:"tag";s:6:"9.0.10";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/9.0.10";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-9.0.10.tar.gz";s:4:"date";s:10:"1607029536";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.0.9";a:10:{s:4:"name";s:12:"drupal 9.0.9";s:7:"version";s:5:"9.0.9";s:3:"tag";s:5:"9.0.9";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.0.9";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.0.9.tar.gz";s:4:"date";s:10:"1606359757";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.0.8";a:10:{s:4:"name";s:12:"drupal 9.0.8";s:7:"version";s:5:"9.0.8";s:3:"tag";s:5:"9.0.8";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.0.8";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.0.8.tar.gz";s:4:"date";s:10:"1605720638";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.0.7";a:10:{s:4:"name";s:12:"drupal 9.0.7";s:7:"version";s:5:"9.0.7";s:3:"tag";s:5:"9.0.7";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.0.7";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.0.7.tar.gz";s:4:"date";s:10:"1602100055";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.0.6";a:10:{s:4:"name";s:12:"drupal 9.0.6";s:7:"version";s:5:"9.0.6";s:3:"tag";s:5:"9.0.6";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.0.6";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.0.6.tar.gz";s:4:"date";s:10:"1600275813";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.0.5";a:10:{s:4:"name";s:12:"drupal 9.0.5";s:7:"version";s:5:"9.0.5";s:3:"tag";s:5:"9.0.5";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.0.5";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.0.5.tar.gz";s:4:"date";s:10:"1599167739";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.0.4";a:10:{s:4:"name";s:12:"drupal 9.0.4";s:7:"version";s:5:"9.0.4";s:3:"tag";s:5:"9.0.4";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.0.4";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.0.4.tar.gz";s:4:"date";s:10:"1599046734";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.0.3";a:10:{s:4:"name";s:12:"drupal 9.0.3";s:7:"version";s:5:"9.0.3";s:3:"tag";s:5:"9.0.3";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.0.3";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.0.3.tar.gz";s:4:"date";s:10:"1596664575";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.0.2";a:10:{s:4:"name";s:12:"drupal 9.0.2";s:7:"version";s:5:"9.0.2";s:3:"tag";s:5:"9.0.2";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.0.2";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.0.2.tar.gz";s:4:"date";s:10:"1594237418";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.0.1";a:10:{s:4:"name";s:12:"drupal 9.0.1";s:7:"version";s:5:"9.0.1";s:3:"tag";s:5:"9.0.1";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.0.1";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.0.1.tar.gz";s:4:"date";s:10:"1592417721";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"9.0.0";a:10:{s:4:"name";s:12:"drupal 9.0.0";s:7:"version";s:5:"9.0.0";s:3:"tag";s:5:"9.0.0";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/9.0.0";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-9.0.0.tar.gz";s:4:"date";s:10:"1591221685";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:8:"Insecure";i:1;s:9:"Bug fixes";i:2;s:12:"New features";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:9:"9.0.0-rc1";a:10:{s:4:"name";s:16:"drupal 9.0.0-rc1";s:7:"version";s:9:"9.0.0-rc1";s:3:"tag";s:9:"9.0.0-rc1";s:6:"status";s:9:"published";s:12:"release_link";s:56:"https://www.drupal.org/project/drupal/releases/9.0.0-rc1";s:13:"download_link";s:61:"https://ftp.drupal.org/files/projects/drupal-9.0.0-rc1.tar.gz";s:4:"date";s:10:"1590187579";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:58:"RC releases are not covered by Drupal security advisories.";}s:11:"9.0.0-beta3";a:10:{s:4:"name";s:18:"drupal 9.0.0-beta3";s:7:"version";s:11:"9.0.0-beta3";s:3:"tag";s:11:"9.0.0-beta3";s:6:"status";s:9:"published";s:12:"release_link";s:58:"https://www.drupal.org/project/drupal/releases/9.0.0-beta3";s:13:"download_link";s:63:"https://ftp.drupal.org/files/projects/drupal-9.0.0-beta3.tar.gz";s:4:"date";s:10:"1589587936";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:60:"Beta releases are not covered by Drupal security advisories.";}s:11:"9.0.0-beta2";a:10:{s:4:"name";s:18:"drupal 9.0.0-beta2";s:7:"version";s:11:"9.0.0-beta2";s:3:"tag";s:11:"9.0.0-beta2";s:6:"status";s:9:"published";s:12:"release_link";s:58:"https://www.drupal.org/project/drupal/releases/9.0.0-beta2";s:13:"download_link";s:63:"https://ftp.drupal.org/files/projects/drupal-9.0.0-beta2.tar.gz";s:4:"date";s:10:"1585597395";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:15:"Security update";i:1;s:9:"Bug fixes";i:2;s:8:"Insecure";}}s:8:"security";s:60:"Beta releases are not covered by Drupal security advisories.";}s:11:"9.0.0-beta1";a:10:{s:4:"name";s:18:"drupal 9.0.0-beta1";s:7:"version";s:11:"9.0.0-beta1";s:3:"tag";s:11:"9.0.0-beta1";s:6:"status";s:9:"published";s:12:"release_link";s:58:"https://www.drupal.org/project/drupal/releases/9.0.0-beta1";s:13:"download_link";s:63:"https://ftp.drupal.org/files/projects/drupal-9.0.0-beta1.tar.gz";s:4:"date";s:10:"1584734060";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:60:"Beta releases are not covered by Drupal security advisories.";}s:12:"9.0.0-alpha2";a:10:{s:4:"name";s:19:"drupal 9.0.0-alpha2";s:7:"version";s:12:"9.0.0-alpha2";s:3:"tag";s:12:"9.0.0-alpha2";s:6:"status";s:9:"published";s:12:"release_link";s:59:"https://www.drupal.org/project/drupal/releases/9.0.0-alpha2";s:13:"download_link";s:64:"https://ftp.drupal.org/files/projects/drupal-9.0.0-alpha2.tar.gz";s:4:"date";s:10:"1583349043";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:61:"Alpha releases are not covered by Drupal security advisories.";}s:12:"9.0.0-alpha1";a:10:{s:4:"name";s:19:"drupal 9.0.0-alpha1";s:7:"version";s:12:"9.0.0-alpha1";s:3:"tag";s:12:"9.0.0-alpha1";s:6:"status";s:9:"published";s:12:"release_link";s:59:"https://www.drupal.org/project/drupal/releases/9.0.0-alpha1";s:13:"download_link";s:64:"https://ftp.drupal.org/files/projects/drupal-9.0.0-alpha1.tar.gz";s:4:"date";s:10:"1581447927";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:61:"Alpha releases are not covered by Drupal security advisories.";}s:6:"8.9.20";a:10:{s:4:"name";s:13:"drupal 8.9.20";s:7:"version";s:6:"8.9.20";s:3:"tag";s:6:"8.9.20";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/8.9.20";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-8.9.20.tar.gz";s:4:"date";s:10:"1637185966";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:1:{i:0;s:15:"Security update";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"8.9.19";a:10:{s:4:"name";s:13:"drupal 8.9.19";s:7:"version";s:6:"8.9.19";s:3:"tag";s:6:"8.9.19";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/8.9.19";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-8.9.19.tar.gz";s:4:"date";s:10:"1631722431";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"8.9.18";a:10:{s:4:"name";s:13:"drupal 8.9.18";s:7:"version";s:6:"8.9.18";s:3:"tag";s:6:"8.9.18";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/8.9.18";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-8.9.18.tar.gz";s:4:"date";s:10:"1628792296";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"8.9.17";a:10:{s:4:"name";s:13:"drupal 8.9.17";s:7:"version";s:6:"8.9.17";s:3:"tag";s:6:"8.9.17";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/8.9.17";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-8.9.17.tar.gz";s:4:"date";s:10:"1626883324";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"8.9.16";a:10:{s:4:"name";s:13:"drupal 8.9.16";s:7:"version";s:6:"8.9.16";s:3:"tag";s:6:"8.9.16";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/8.9.16";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-8.9.16.tar.gz";s:4:"date";s:10:"1622058087";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"8.9.15";a:10:{s:4:"name";s:13:"drupal 8.9.15";s:7:"version";s:6:"8.9.15";s:3:"tag";s:6:"8.9.15";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/8.9.15";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-8.9.15.tar.gz";s:4:"date";s:10:"1620216983";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"8.9.14";a:10:{s:4:"name";s:13:"drupal 8.9.14";s:7:"version";s:6:"8.9.14";s:3:"tag";s:6:"8.9.14";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/8.9.14";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-8.9.14.tar.gz";s:4:"date";s:10:"1619021518";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"8.9.13";a:10:{s:4:"name";s:13:"drupal 8.9.13";s:7:"version";s:6:"8.9.13";s:3:"tag";s:6:"8.9.13";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/8.9.13";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-8.9.13.tar.gz";s:4:"date";s:10:"1611162272";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"8.9.12";a:10:{s:4:"name";s:13:"drupal 8.9.12";s:7:"version";s:6:"8.9.12";s:3:"tag";s:6:"8.9.12";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/8.9.12";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-8.9.12.tar.gz";s:4:"date";s:10:"1609977009";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"8.9.11";a:10:{s:4:"name";s:13:"drupal 8.9.11";s:7:"version";s:6:"8.9.11";s:3:"tag";s:6:"8.9.11";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/8.9.11";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-8.9.11.tar.gz";s:4:"date";s:10:"1607030087";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"8.9.10";a:10:{s:4:"name";s:13:"drupal 8.9.10";s:7:"version";s:6:"8.9.10";s:3:"tag";s:6:"8.9.10";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/8.9.10";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-8.9.10.tar.gz";s:4:"date";s:10:"1606360301";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.9.9";a:10:{s:4:"name";s:12:"drupal 8.9.9";s:7:"version";s:5:"8.9.9";s:3:"tag";s:5:"8.9.9";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.9.9";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.9.9.tar.gz";s:4:"date";s:10:"1605721120";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.9.8";a:10:{s:4:"name";s:12:"drupal 8.9.8";s:7:"version";s:5:"8.9.8";s:3:"tag";s:5:"8.9.8";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.9.8";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.9.8.tar.gz";s:4:"date";s:10:"1604595269";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.9.7";a:10:{s:4:"name";s:12:"drupal 8.9.7";s:7:"version";s:5:"8.9.7";s:3:"tag";s:5:"8.9.7";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.9.7";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.9.7.tar.gz";s:4:"date";s:10:"1602100507";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.9.6";a:10:{s:4:"name";s:12:"drupal 8.9.6";s:7:"version";s:5:"8.9.6";s:3:"tag";s:5:"8.9.6";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.9.6";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.9.6.tar.gz";s:4:"date";s:10:"1600276267";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.9.5";a:10:{s:4:"name";s:12:"drupal 8.9.5";s:7:"version";s:5:"8.9.5";s:3:"tag";s:5:"8.9.5";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.9.5";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.9.5.tar.gz";s:4:"date";s:10:"1599168205";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.9.4";a:10:{s:4:"name";s:12:"drupal 8.9.4";s:7:"version";s:5:"8.9.4";s:3:"tag";s:5:"8.9.4";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.9.4";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.9.4.tar.gz";s:4:"date";s:10:"1599047691";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.9.3";a:10:{s:4:"name";s:12:"drupal 8.9.3";s:7:"version";s:5:"8.9.3";s:3:"tag";s:5:"8.9.3";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.9.3";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.9.3.tar.gz";s:4:"date";s:10:"1596665051";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.9.2";a:10:{s:4:"name";s:12:"drupal 8.9.2";s:7:"version";s:5:"8.9.2";s:3:"tag";s:5:"8.9.2";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.9.2";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.9.2.tar.gz";s:4:"date";s:10:"1594237961";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.9.1";a:10:{s:4:"name";s:12:"drupal 8.9.1";s:7:"version";s:5:"8.9.1";s:3:"tag";s:5:"8.9.1";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.9.1";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.9.1.tar.gz";s:4:"date";s:10:"1592418237";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.9.0";a:10:{s:4:"name";s:12:"drupal 8.9.0";s:7:"version";s:5:"8.9.0";s:3:"tag";s:5:"8.9.0";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.9.0";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.9.0.tar.gz";s:4:"date";s:10:"1591204117";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:8:"Insecure";i:1;s:9:"Bug fixes";i:2;s:12:"New features";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:9:"8.9.0-rc1";a:10:{s:4:"name";s:16:"drupal 8.9.0-rc1";s:7:"version";s:9:"8.9.0-rc1";s:3:"tag";s:9:"8.9.0-rc1";s:6:"status";s:9:"published";s:12:"release_link";s:56:"https://www.drupal.org/project/drupal/releases/8.9.0-rc1";s:13:"download_link";s:61:"https://ftp.drupal.org/files/projects/drupal-8.9.0-rc1.tar.gz";s:4:"date";s:10:"1590189096";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:58:"RC releases are not covered by Drupal security advisories.";}s:11:"8.9.0-beta3";a:10:{s:4:"name";s:18:"drupal 8.9.0-beta3";s:7:"version";s:11:"8.9.0-beta3";s:3:"tag";s:11:"8.9.0-beta3";s:6:"status";s:9:"published";s:12:"release_link";s:58:"https://www.drupal.org/project/drupal/releases/8.9.0-beta3";s:13:"download_link";s:63:"https://ftp.drupal.org/files/projects/drupal-8.9.0-beta3.tar.gz";s:4:"date";s:10:"1589746375";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:60:"Beta releases are not covered by Drupal security advisories.";}s:11:"8.9.0-beta2";a:10:{s:4:"name";s:18:"drupal 8.9.0-beta2";s:7:"version";s:11:"8.9.0-beta2";s:3:"tag";s:11:"8.9.0-beta2";s:6:"status";s:9:"published";s:12:"release_link";s:58:"https://www.drupal.org/project/drupal/releases/8.9.0-beta2";s:13:"download_link";s:63:"https://ftp.drupal.org/files/projects/drupal-8.9.0-beta2.tar.gz";s:4:"date";s:10:"1585863226";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:60:"Beta releases are not covered by Drupal security advisories.";}s:11:"8.9.0-beta1";a:10:{s:4:"name";s:18:"drupal 8.9.0-beta1";s:7:"version";s:11:"8.9.0-beta1";s:3:"tag";s:11:"8.9.0-beta1";s:6:"status";s:9:"published";s:12:"release_link";s:58:"https://www.drupal.org/project/drupal/releases/8.9.0-beta1";s:13:"download_link";s:63:"https://ftp.drupal.org/files/projects/drupal-8.9.0-beta1.tar.gz";s:4:"date";s:10:"1585263710";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:8:"Insecure";i:1;s:9:"Bug fixes";i:2;s:12:"New features";}}s:8:"security";s:60:"Beta releases are not covered by Drupal security advisories.";}s:6:"8.8.12";a:10:{s:4:"name";s:13:"drupal 8.8.12";s:7:"version";s:6:"8.8.12";s:3:"tag";s:6:"8.8.12";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/8.8.12";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-8.8.12.tar.gz";s:4:"date";s:10:"1606360866";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"8.8.11";a:10:{s:4:"name";s:13:"drupal 8.8.11";s:7:"version";s:6:"8.8.11";s:3:"tag";s:6:"8.8.11";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/8.8.11";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-8.8.11.tar.gz";s:4:"date";s:10:"1605721628";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"8.8.10";a:10:{s:4:"name";s:13:"drupal 8.8.10";s:7:"version";s:6:"8.8.10";s:3:"tag";s:6:"8.8.10";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/8.8.10";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-8.8.10.tar.gz";s:4:"date";s:10:"1600276704";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.8.9";a:10:{s:4:"name";s:12:"drupal 8.8.9";s:7:"version";s:5:"8.8.9";s:3:"tag";s:5:"8.8.9";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.8.9";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.8.9.tar.gz";s:4:"date";s:10:"1599168716";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.8.8";a:10:{s:4:"name";s:12:"drupal 8.8.8";s:7:"version";s:5:"8.8.8";s:3:"tag";s:5:"8.8.8";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.8.8";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.8.8.tar.gz";s:4:"date";s:10:"1592418750";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.8.7";a:10:{s:4:"name";s:12:"drupal 8.8.7";s:7:"version";s:5:"8.8.7";s:3:"tag";s:5:"8.8.7";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.8.7";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.8.7.tar.gz";s:4:"date";s:10:"1591203837";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.8.6";a:10:{s:4:"name";s:12:"drupal 8.8.6";s:7:"version";s:5:"8.8.6";s:3:"tag";s:5:"8.8.6";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.8.6";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.8.6.tar.gz";s:4:"date";s:10:"1589989060";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.8.5";a:10:{s:4:"name";s:12:"drupal 8.8.5";s:7:"version";s:5:"8.8.5";s:3:"tag";s:5:"8.8.5";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.8.5";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.8.5.tar.gz";s:4:"date";s:10:"1585861530";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.8.4";a:10:{s:4:"name";s:12:"drupal 8.8.4";s:7:"version";s:5:"8.8.4";s:3:"tag";s:5:"8.8.4";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.8.4";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.8.4.tar.gz";s:4:"date";s:10:"1584560524";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.8.3";a:10:{s:4:"name";s:12:"drupal 8.8.3";s:7:"version";s:5:"8.8.3";s:3:"tag";s:5:"8.8.3";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.8.3";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.8.3.tar.gz";s:4:"date";s:10:"1583347094";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.8.2";a:10:{s:4:"name";s:12:"drupal 8.8.2";s:7:"version";s:5:"8.8.2";s:3:"tag";s:5:"8.8.2";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.8.2";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.8.2.tar.gz";s:4:"date";s:10:"1580598849";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.8.1";a:10:{s:4:"name";s:12:"drupal 8.8.1";s:7:"version";s:5:"8.8.1";s:3:"tag";s:5:"8.8.1";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.8.1";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.8.1.tar.gz";s:4:"date";s:10:"1576695785";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.8.0";a:10:{s:4:"name";s:12:"drupal 8.8.0";s:7:"version";s:5:"8.8.0";s:3:"tag";s:5:"8.8.0";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.8.0";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.8.0.tar.gz";s:4:"date";s:10:"1575450481";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:8:"Insecure";i:1;s:9:"Bug fixes";i:2;s:12:"New features";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:9:"8.8.0-rc1";a:10:{s:4:"name";s:16:"drupal 8.8.0-rc1";s:7:"version";s:9:"8.8.0-rc1";s:3:"tag";s:9:"8.8.0-rc1";s:6:"status";s:9:"published";s:12:"release_link";s:56:"https://www.drupal.org/project/drupal/releases/8.8.0-rc1";s:13:"download_link";s:61:"https://ftp.drupal.org/files/projects/drupal-8.8.0-rc1.tar.gz";s:4:"date";s:10:"1574462580";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:58:"RC releases are not covered by Drupal security advisories.";}s:11:"8.8.0-beta1";a:10:{s:4:"name";s:18:"drupal 8.8.0-beta1";s:7:"version";s:11:"8.8.0-beta1";s:3:"tag";s:11:"8.8.0-beta1";s:6:"status";s:9:"published";s:12:"release_link";s:58:"https://www.drupal.org/project/drupal/releases/8.8.0-beta1";s:13:"download_link";s:63:"https://ftp.drupal.org/files/projects/drupal-8.8.0-beta1.tar.gz";s:4:"date";s:10:"1573256280";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:60:"Beta releases are not covered by Drupal security advisories.";}s:12:"8.8.0-alpha1";a:10:{s:4:"name";s:19:"drupal 8.8.0-alpha1";s:7:"version";s:12:"8.8.0-alpha1";s:3:"tag";s:12:"8.8.0-alpha1";s:6:"status";s:9:"published";s:12:"release_link";s:59:"https://www.drupal.org/project/drupal/releases/8.8.0-alpha1";s:13:"download_link";s:64:"https://ftp.drupal.org/files/projects/drupal-8.8.0-alpha1.tar.gz";s:4:"date";s:10:"1571355784";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:61:"Alpha releases are not covered by Drupal security advisories.";}s:6:"8.7.14";a:10:{s:4:"name";s:13:"drupal 8.7.14";s:7:"version";s:6:"8.7.14";s:3:"tag";s:6:"8.7.14";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/8.7.14";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-8.7.14.tar.gz";s:4:"date";s:10:"1589988665";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"8.7.13";a:10:{s:4:"name";s:13:"drupal 8.7.13";s:7:"version";s:6:"8.7.13";s:3:"tag";s:6:"8.7.13";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/8.7.13";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-8.7.13.tar.gz";s:4:"date";s:10:"1585861883";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"8.7.12";a:10:{s:4:"name";s:13:"drupal 8.7.12";s:7:"version";s:6:"8.7.12";s:3:"tag";s:6:"8.7.12";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/8.7.12";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-8.7.12.tar.gz";s:4:"date";s:10:"1584552250";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"8.7.11";a:10:{s:4:"name";s:13:"drupal 8.7.11";s:7:"version";s:6:"8.7.11";s:3:"tag";s:6:"8.7.11";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/8.7.11";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-8.7.11.tar.gz";s:4:"date";s:10:"1576695785";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"8.7.10";a:10:{s:4:"name";s:13:"drupal 8.7.10";s:7:"version";s:6:"8.7.10";s:3:"tag";s:6:"8.7.10";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/8.7.10";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-8.7.10.tar.gz";s:4:"date";s:10:"1573687985";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.7.9";a:10:{s:4:"name";s:12:"drupal 8.7.9";s:7:"version";s:5:"8.7.9";s:3:"tag";s:5:"8.7.9";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.7.9";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.7.9.tar.gz";s:4:"date";s:10:"1573063387";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.7.8";a:10:{s:4:"name";s:12:"drupal 8.7.8";s:7:"version";s:5:"8.7.8";s:3:"tag";s:5:"8.7.8";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.7.8";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.7.8.tar.gz";s:4:"date";s:10:"1570044484";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.7.7";a:10:{s:4:"name";s:12:"drupal 8.7.7";s:7:"version";s:5:"8.7.7";s:3:"tag";s:5:"8.7.7";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.7.7";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.7.7.tar.gz";s:4:"date";s:10:"1567593185";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.7.6";a:10:{s:4:"name";s:12:"drupal 8.7.6";s:7:"version";s:5:"8.7.6";s:3:"tag";s:5:"8.7.6";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.7.6";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.7.6.tar.gz";s:4:"date";s:10:"1565206385";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.7.5";a:10:{s:4:"name";s:12:"drupal 8.7.5";s:7:"version";s:5:"8.7.5";s:3:"tag";s:5:"8.7.5";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.7.5";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.7.5.tar.gz";s:4:"date";s:10:"1563380885";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.7.4";a:10:{s:4:"name";s:12:"drupal 8.7.4";s:7:"version";s:5:"8.7.4";s:3:"tag";s:5:"8.7.4";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.7.4";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.7.4.tar.gz";s:4:"date";s:10:"1562225587";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.7.3";a:10:{s:4:"name";s:12:"drupal 8.7.3";s:7:"version";s:5:"8.7.3";s:3:"tag";s:5:"8.7.3";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.7.3";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.7.3.tar.gz";s:4:"date";s:10:"1559762581";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.7.2";a:10:{s:4:"name";s:12:"drupal 8.7.2";s:7:"version";s:5:"8.7.2";s:3:"tag";s:5:"8.7.2";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.7.2";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.7.2.tar.gz";s:4:"date";s:10:"1558597086";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.7.1";a:10:{s:4:"name";s:12:"drupal 8.7.1";s:7:"version";s:5:"8.7.1";s:3:"tag";s:5:"8.7.1";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.7.1";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.7.1.tar.gz";s:4:"date";s:10:"1557335588";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.7.0";a:10:{s:4:"name";s:12:"drupal 8.7.0";s:7:"version";s:5:"8.7.0";s:3:"tag";s:5:"8.7.0";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.7.0";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.7.0.tar.gz";s:4:"date";s:10:"1556737085";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:9:"8.7.0-rc1";a:10:{s:4:"name";s:16:"drupal 8.7.0-rc1";s:7:"version";s:9:"8.7.0-rc1";s:3:"tag";s:9:"8.7.0-rc1";s:6:"status";s:9:"published";s:12:"release_link";s:56:"https://www.drupal.org/project/drupal/releases/8.7.0-rc1";s:13:"download_link";s:61:"https://ftp.drupal.org/files/projects/drupal-8.7.0-rc1.tar.gz";s:4:"date";s:10:"1555603385";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:4:{i:0;s:15:"Security update";i:1;s:9:"Bug fixes";i:2;s:12:"New features";i:3;s:8:"Insecure";}}s:8:"security";s:58:"RC releases are not covered by Drupal security advisories.";}s:11:"8.7.0-beta2";a:10:{s:4:"name";s:18:"drupal 8.7.0-beta2";s:7:"version";s:11:"8.7.0-beta2";s:3:"tag";s:11:"8.7.0-beta2";s:6:"status";s:9:"published";s:12:"release_link";s:58:"https://www.drupal.org/project/drupal/releases/8.7.0-beta2";s:13:"download_link";s:63:"https://ftp.drupal.org/files/projects/drupal-8.7.0-beta2.tar.gz";s:4:"date";s:10:"1554684784";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:8:"Insecure";i:1;s:9:"Bug fixes";i:2;s:12:"New features";}}s:8:"security";s:60:"Beta releases are not covered by Drupal security advisories.";}s:11:"8.7.0-beta1";a:10:{s:4:"name";s:18:"drupal 8.7.0-beta1";s:7:"version";s:11:"8.7.0-beta1";s:3:"tag";s:11:"8.7.0-beta1";s:6:"status";s:9:"published";s:12:"release_link";s:58:"https://www.drupal.org/project/drupal/releases/8.7.0-beta1";s:13:"download_link";s:63:"https://ftp.drupal.org/files/projects/drupal-8.7.0-beta1.tar.gz";s:4:"date";s:10:"1553881681";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:60:"Beta releases are not covered by Drupal security advisories.";}s:12:"8.7.0-alpha2";a:10:{s:4:"name";s:19:"drupal 8.7.0-alpha2";s:7:"version";s:12:"8.7.0-alpha2";s:3:"tag";s:12:"8.7.0-alpha2";s:6:"status";s:9:"published";s:12:"release_link";s:59:"https://www.drupal.org/project/drupal/releases/8.7.0-alpha2";s:13:"download_link";s:64:"https://ftp.drupal.org/files/projects/drupal-8.7.0-alpha2.tar.gz";s:4:"date";s:10:"1553106180";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:61:"Alpha releases are not covered by Drupal security advisories.";}s:12:"8.7.0-alpha1";a:10:{s:4:"name";s:19:"drupal 8.7.0-alpha1";s:7:"version";s:12:"8.7.0-alpha1";s:3:"tag";s:12:"8.7.0-alpha1";s:6:"status";s:9:"published";s:12:"release_link";s:59:"https://www.drupal.org/project/drupal/releases/8.7.0-alpha1";s:13:"download_link";s:64:"https://ftp.drupal.org/files/projects/drupal-8.7.0-alpha1.tar.gz";s:4:"date";s:10:"1552602484";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:61:"Alpha releases are not covered by Drupal security advisories.";}s:6:"8.6.18";a:10:{s:4:"name";s:13:"drupal 8.6.18";s:7:"version";s:6:"8.6.18";s:3:"tag";s:6:"8.6.18";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/8.6.18";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-8.6.18.tar.gz";s:4:"date";s:10:"1573687985";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"8.6.17";a:10:{s:4:"name";s:13:"drupal 8.6.17";s:7:"version";s:6:"8.6.17";s:3:"tag";s:6:"8.6.17";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/8.6.17";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-8.6.17.tar.gz";s:4:"date";s:10:"1560756785";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"8.6.16";a:10:{s:4:"name";s:13:"drupal 8.6.16";s:7:"version";s:6:"8.6.16";s:3:"tag";s:6:"8.6.16";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/8.6.16";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-8.6.16.tar.gz";s:4:"date";s:10:"1557335588";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"8.6.15";a:10:{s:4:"name";s:13:"drupal 8.6.15";s:7:"version";s:6:"8.6.15";s:3:"tag";s:6:"8.6.15";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/8.6.15";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-8.6.15.tar.gz";s:4:"date";s:10:"1555533181";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:8:"Insecure";i:1;s:15:"Security update";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"8.6.14";a:10:{s:4:"name";s:13:"drupal 8.6.14";s:7:"version";s:6:"8.6.14";s:3:"tag";s:6:"8.6.14";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/8.6.14";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-8.6.14.tar.gz";s:4:"date";s:10:"1554688384";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:8:"Insecure";i:1;s:9:"Bug fixes";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"8.6.13";a:10:{s:4:"name";s:13:"drupal 8.6.13";s:7:"version";s:6:"8.6.13";s:3:"tag";s:6:"8.6.13";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/8.6.13";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-8.6.13.tar.gz";s:4:"date";s:10:"1553099584";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"8.6.12";a:10:{s:4:"name";s:13:"drupal 8.6.12";s:7:"version";s:6:"8.6.12";s:3:"tag";s:6:"8.6.12";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/8.6.12";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-8.6.12.tar.gz";s:4:"date";s:10:"1552601584";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"8.6.11";a:10:{s:4:"name";s:13:"drupal 8.6.11";s:7:"version";s:6:"8.6.11";s:3:"tag";s:6:"8.6.11";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/8.6.11";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-8.6.11.tar.gz";s:4:"date";s:10:"1552511584";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"8.6.10";a:10:{s:4:"name";s:13:"drupal 8.6.10";s:7:"version";s:6:"8.6.10";s:3:"tag";s:6:"8.6.10";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/8.6.10";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-8.6.10.tar.gz";s:4:"date";s:10:"1550691784";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.6.9";a:10:{s:4:"name";s:12:"drupal 8.6.9";s:7:"version";s:5:"8.6.9";s:3:"tag";s:5:"8.6.9";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.6.9";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.6.9.tar.gz";s:4:"date";s:10:"1549628580";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.6.8";a:10:{s:4:"name";s:12:"drupal 8.6.8";s:7:"version";s:5:"8.6.8";s:3:"tag";s:5:"8.6.8";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.6.8";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.6.8.tar.gz";s:4:"date";s:10:"1549466580";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.6.7";a:10:{s:4:"name";s:12:"drupal 8.6.7";s:7:"version";s:5:"8.6.7";s:3:"tag";s:5:"8.6.7";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.6.7";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.6.7.tar.gz";s:4:"date";s:10:"1547682180";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.6.6";a:10:{s:4:"name";s:12:"drupal 8.6.6";s:7:"version";s:5:"8.6.6";s:3:"tag";s:5:"8.6.6";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.6.6";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.6.6.tar.gz";s:4:"date";s:10:"1547663557";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.6.5";a:10:{s:4:"name";s:12:"drupal 8.6.5";s:7:"version";s:5:"8.6.5";s:3:"tag";s:5:"8.6.5";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.6.5";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.6.5.tar.gz";s:4:"date";s:10:"1546467485";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.6.4";a:10:{s:4:"name";s:12:"drupal 8.6.4";s:7:"version";s:5:"8.6.4";s:3:"tag";s:5:"8.6.4";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.6.4";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.6.4.tar.gz";s:4:"date";s:10:"1544011681";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.6.3";a:10:{s:4:"name";s:12:"drupal 8.6.3";s:7:"version";s:5:"8.6.3";s:3:"tag";s:5:"8.6.3";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.6.3";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.6.3.tar.gz";s:4:"date";s:10:"1541602684";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.6.2";a:10:{s:4:"name";s:12:"drupal 8.6.2";s:7:"version";s:5:"8.6.2";s:3:"tag";s:5:"8.6.2";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.6.2";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.6.2.tar.gz";s:4:"date";s:10:"1539816180";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.6.1";a:10:{s:4:"name";s:12:"drupal 8.6.1";s:7:"version";s:5:"8.6.1";s:3:"tag";s:5:"8.6.1";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.6.1";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.6.1.tar.gz";s:4:"date";s:10:"1536585780";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.6.0";a:10:{s:4:"name";s:12:"drupal 8.6.0";s:7:"version";s:5:"8.6.0";s:3:"tag";s:5:"8.6.0";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.6.0";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.6.0.tar.gz";s:4:"date";s:10:"1536186480";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:9:"8.6.0-rc1";a:10:{s:4:"name";s:16:"drupal 8.6.0-rc1";s:7:"version";s:9:"8.6.0-rc1";s:3:"tag";s:9:"8.6.0-rc1";s:6:"status";s:9:"published";s:12:"release_link";s:56:"https://www.drupal.org/project/drupal/releases/8.6.0-rc1";s:13:"download_link";s:61:"https://ftp.drupal.org/files/projects/drupal-8.6.0-rc1.tar.gz";s:4:"date";s:10:"1534532580";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:58:"RC releases are not covered by Drupal security advisories.";}s:11:"8.6.0-beta2";a:10:{s:4:"name";s:18:"drupal 8.6.0-beta2";s:7:"version";s:11:"8.6.0-beta2";s:3:"tag";s:11:"8.6.0-beta2";s:6:"status";s:9:"published";s:12:"release_link";s:58:"https://www.drupal.org/project/drupal/releases/8.6.0-beta2";s:13:"download_link";s:63:"https://ftp.drupal.org/files/projects/drupal-8.6.0-beta2.tar.gz";s:4:"date";s:10:"1533298080";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:60:"Beta releases are not covered by Drupal security advisories.";}s:11:"8.6.0-beta1";a:10:{s:4:"name";s:18:"drupal 8.6.0-beta1";s:7:"version";s:11:"8.6.0-beta1";s:3:"tag";s:11:"8.6.0-beta1";s:6:"status";s:9:"published";s:12:"release_link";s:58:"https://www.drupal.org/project/drupal/releases/8.6.0-beta1";s:13:"download_link";s:63:"https://ftp.drupal.org/files/projects/drupal-8.6.0-beta1.tar.gz";s:4:"date";s:10:"1533270485";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:8:"Insecure";i:1;s:9:"Bug fixes";i:2;s:12:"New features";}}s:8:"security";s:60:"Beta releases are not covered by Drupal security advisories.";}s:12:"8.6.0-alpha1";a:10:{s:4:"name";s:19:"drupal 8.6.0-alpha1";s:7:"version";s:12:"8.6.0-alpha1";s:3:"tag";s:12:"8.6.0-alpha1";s:6:"status";s:9:"published";s:12:"release_link";s:59:"https://www.drupal.org/project/drupal/releases/8.6.0-alpha1";s:13:"download_link";s:64:"https://ftp.drupal.org/files/projects/drupal-8.6.0-alpha1.tar.gz";s:4:"date";s:10:"1532033881";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:8:"Insecure";i:1;s:9:"Bug fixes";i:2;s:12:"New features";}}s:8:"security";s:61:"Alpha releases are not covered by Drupal security advisories.";}s:6:"8.5.15";a:10:{s:4:"name";s:13:"drupal 8.5.15";s:7:"version";s:6:"8.5.15";s:3:"tag";s:6:"8.5.15";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/8.5.15";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-8.5.15.tar.gz";s:4:"date";s:10:"1555533181";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:8:"Insecure";i:1;s:15:"Security update";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"8.5.14";a:10:{s:4:"name";s:13:"drupal 8.5.14";s:7:"version";s:6:"8.5.14";s:3:"tag";s:6:"8.5.14";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/8.5.14";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-8.5.14.tar.gz";s:4:"date";s:10:"1553099584";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:8:"Insecure";i:1;s:15:"Security update";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"8.5.13";a:10:{s:4:"name";s:13:"drupal 8.5.13";s:7:"version";s:6:"8.5.13";s:3:"tag";s:6:"8.5.13";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/8.5.13";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-8.5.13.tar.gz";s:4:"date";s:10:"1552601584";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:8:"Insecure";i:1;s:9:"Bug fixes";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"8.5.12";a:10:{s:4:"name";s:13:"drupal 8.5.12";s:7:"version";s:6:"8.5.12";s:3:"tag";s:6:"8.5.12";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/8.5.12";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-8.5.12.tar.gz";s:4:"date";s:10:"1552511584";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:8:"Insecure";i:1;s:9:"Bug fixes";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"8.5.11";a:10:{s:4:"name";s:13:"drupal 8.5.11";s:7:"version";s:6:"8.5.11";s:3:"tag";s:6:"8.5.11";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/8.5.11";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-8.5.11.tar.gz";s:4:"date";s:10:"1550691784";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:8:"Insecure";i:1;s:15:"Security update";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:6:"8.5.10";a:10:{s:4:"name";s:13:"drupal 8.5.10";s:7:"version";s:6:"8.5.10";s:3:"tag";s:6:"8.5.10";s:6:"status";s:9:"published";s:12:"release_link";s:53:"https://www.drupal.org/project/drupal/releases/8.5.10";s:13:"download_link";s:58:"https://ftp.drupal.org/files/projects/drupal-8.5.10.tar.gz";s:4:"date";s:10:"1547682180";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:8:"Insecure";i:1;s:9:"Bug fixes";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.5.9";a:10:{s:4:"name";s:12:"drupal 8.5.9";s:7:"version";s:5:"8.5.9";s:3:"tag";s:5:"8.5.9";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.5.9";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.5.9.tar.gz";s:4:"date";s:10:"1547663557";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:8:"Insecure";i:1;s:15:"Security update";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.5.8";a:10:{s:4:"name";s:12:"drupal 8.5.8";s:7:"version";s:5:"8.5.8";s:3:"tag";s:5:"8.5.8";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.5.8";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.5.8.tar.gz";s:4:"date";s:10:"1539816180";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:8:"Insecure";i:1;s:15:"Security update";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.5.7";a:10:{s:4:"name";s:12:"drupal 8.5.7";s:7:"version";s:5:"8.5.7";s:3:"tag";s:5:"8.5.7";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.5.7";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.5.7.tar.gz";s:4:"date";s:10:"1536187080";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.5.6";a:10:{s:4:"name";s:12:"drupal 8.5.6";s:7:"version";s:5:"8.5.6";s:3:"tag";s:5:"8.5.6";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.5.6";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.5.6.tar.gz";s:4:"date";s:10:"1533156780";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.5.5";a:10:{s:4:"name";s:12:"drupal 8.5.5";s:7:"version";s:5:"8.5.5";s:3:"tag";s:5:"8.5.5";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.5.5";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.5.5.tar.gz";s:4:"date";s:10:"1530738820";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.5.4";a:10:{s:4:"name";s:12:"drupal 8.5.4";s:7:"version";s:5:"8.5.4";s:3:"tag";s:5:"8.5.4";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.5.4";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.5.4.tar.gz";s:4:"date";s:10:"1528319584";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.5.3";a:10:{s:4:"name";s:12:"drupal 8.5.3";s:7:"version";s:5:"8.5.3";s:3:"tag";s:5:"8.5.3";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.5.3";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.5.3.tar.gz";s:4:"date";s:10:"1524672780";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.5.2";a:10:{s:4:"name";s:12:"drupal 8.5.2";s:7:"version";s:5:"8.5.2";s:3:"tag";s:5:"8.5.2";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.5.2";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.5.2.tar.gz";s:4:"date";s:10:"1524073147";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.5.1";a:10:{s:4:"name";s:12:"drupal 8.5.1";s:7:"version";s:5:"8.5.1";s:3:"tag";s:5:"8.5.1";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.5.1";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.5.1.tar.gz";s:4:"date";s:10:"1522263480";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.5.0";a:10:{s:4:"name";s:12:"drupal 8.5.0";s:7:"version";s:5:"8.5.0";s:3:"tag";s:5:"8.5.0";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.5.0";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.5.0.tar.gz";s:4:"date";s:10:"1520457780";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:9:"8.5.0-rc1";a:10:{s:4:"name";s:16:"drupal 8.5.0-rc1";s:7:"version";s:9:"8.5.0-rc1";s:3:"tag";s:9:"8.5.0-rc1";s:6:"status";s:9:"published";s:12:"release_link";s:56:"https://www.drupal.org/project/drupal/releases/8.5.0-rc1";s:13:"download_link";s:61:"https://ftp.drupal.org/files/projects/drupal-8.5.0-rc1.tar.gz";s:4:"date";s:10:"1519234680";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:4:{i:0;s:8:"Insecure";i:1;s:15:"Security update";i:2;s:9:"Bug fixes";i:3;s:12:"New features";}}s:8:"security";s:58:"RC releases are not covered by Drupal security advisories.";}s:11:"8.5.0-beta1";a:10:{s:4:"name";s:18:"drupal 8.5.0-beta1";s:7:"version";s:11:"8.5.0-beta1";s:3:"tag";s:11:"8.5.0-beta1";s:6:"status";s:9:"published";s:12:"release_link";s:58:"https://www.drupal.org/project/drupal/releases/8.5.0-beta1";s:13:"download_link";s:63:"https://ftp.drupal.org/files/projects/drupal-8.5.0-beta1.tar.gz";s:4:"date";s:10:"1518211380";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:60:"Beta releases are not covered by Drupal security advisories.";}s:12:"8.5.0-alpha1";a:10:{s:4:"name";s:19:"drupal 8.5.0-alpha1";s:7:"version";s:12:"8.5.0-alpha1";s:3:"tag";s:12:"8.5.0-alpha1";s:6:"status";s:9:"published";s:12:"release_link";s:59:"https://www.drupal.org/project/drupal/releases/8.5.0-alpha1";s:13:"download_link";s:64:"https://ftp.drupal.org/files/projects/drupal-8.5.0-alpha1.tar.gz";s:4:"date";s:10:"1516320484";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:61:"Alpha releases are not covered by Drupal security advisories.";}s:5:"8.4.8";a:10:{s:4:"name";s:12:"drupal 8.4.8";s:7:"version";s:5:"8.4.8";s:3:"tag";s:5:"8.4.8";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.4.8";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.4.8.tar.gz";s:4:"date";s:10:"1524672780";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.4.7";a:10:{s:4:"name";s:12:"drupal 8.4.7";s:7:"version";s:5:"8.4.7";s:3:"tag";s:5:"8.4.7";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.4.7";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.4.7.tar.gz";s:4:"date";s:10:"1524073147";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.4.6";a:10:{s:4:"name";s:12:"drupal 8.4.6";s:7:"version";s:5:"8.4.6";s:3:"tag";s:5:"8.4.6";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.4.6";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.4.6.tar.gz";s:4:"date";s:10:"1522263480";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.4.5";a:10:{s:4:"name";s:12:"drupal 8.4.5";s:7:"version";s:5:"8.4.5";s:3:"tag";s:5:"8.4.5";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.4.5";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.4.5.tar.gz";s:4:"date";s:10:"1519234680";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:8:"Insecure";i:1;s:15:"Security update";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.4.4";a:10:{s:4:"name";s:12:"drupal 8.4.4";s:7:"version";s:5:"8.4.4";s:3:"tag";s:5:"8.4.4";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.4.4";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.4.4.tar.gz";s:4:"date";s:10:"1515021185";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.4.3";a:10:{s:4:"name";s:12:"drupal 8.4.3";s:7:"version";s:5:"8.4.3";s:3:"tag";s:5:"8.4.3";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.4.3";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.4.3.tar.gz";s:4:"date";s:10:"1512600784";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.4.2";a:10:{s:4:"name";s:12:"drupal 8.4.2";s:7:"version";s:5:"8.4.2";s:3:"tag";s:5:"8.4.2";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.4.2";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.4.2.tar.gz";s:4:"date";s:10:"1509719885";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.4.1";a:10:{s:4:"name";s:12:"drupal 8.4.1";s:7:"version";s:5:"8.4.1";s:3:"tag";s:5:"8.4.1";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.4.1";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.4.1.tar.gz";s:4:"date";s:10:"1509562384";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:9:"Bug fixes";i:1;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:5:"8.4.0";a:10:{s:4:"name";s:12:"drupal 8.4.0";s:7:"version";s:5:"8.4.0";s:3:"tag";s:5:"8.4.0";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.4.0";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.4.0.tar.gz";s:4:"date";s:10:"1507146244";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:44:"Covered by Drupal''s security advisory policy";}s:9:"8.4.0-rc2";a:10:{s:4:"name";s:16:"drupal 8.4.0-rc2";s:7:"version";s:9:"8.4.0-rc2";s:3:"tag";s:9:"8.4.0-rc2";s:6:"status";s:9:"published";s:12:"release_link";s:56:"https://www.drupal.org/project/drupal/releases/8.4.0-rc2";s:13:"download_link";s:61:"https://ftp.drupal.org/files/projects/drupal-8.4.0-rc2.tar.gz";s:4:"date";s:10:"1505911444";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:8:"Insecure";i:1;s:9:"Bug fixes";i:2;s:12:"New features";}}s:8:"security";s:58:"RC releases are not covered by Drupal security advisories.";}s:9:"8.4.0-rc1";a:10:{s:4:"name";s:16:"drupal 8.4.0-rc1";s:7:"version";s:9:"8.4.0-rc1";s:3:"tag";s:9:"8.4.0-rc1";s:6:"status";s:9:"published";s:12:"release_link";s:56:"https://www.drupal.org/project/drupal/releases/8.4.0-rc1";s:13:"download_link";s:61:"https://ftp.drupal.org/files/projects/drupal-8.4.0-rc1.tar.gz";s:4:"date";s:10:"1504733043";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:58:"RC releases are not covered by Drupal security advisories.";}s:11:"8.4.0-beta1";a:10:{s:4:"name";s:18:"drupal 8.4.0-beta1";s:7:"version";s:11:"8.4.0-beta1";s:3:"tag";s:11:"8.4.0-beta1";s:6:"status";s:9:"published";s:12:"release_link";s:58:"https://www.drupal.org/project/drupal/releases/8.4.0-beta1";s:13:"download_link";s:63:"https://ftp.drupal.org/files/projects/drupal-8.4.0-beta1.tar.gz";s:4:"date";s:10:"1502992144";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:60:"Beta releases are not covered by Drupal security advisories.";}s:12:"8.4.0-alpha1";a:10:{s:4:"name";s:19:"drupal 8.4.0-alpha1";s:7:"version";s:12:"8.4.0-alpha1";s:3:"tag";s:12:"8.4.0-alpha1";s:6:"status";s:9:"published";s:12:"release_link";s:59:"https://www.drupal.org/project/drupal/releases/8.4.0-alpha1";s:13:"download_link";s:64:"https://ftp.drupal.org/files/projects/drupal-8.4.0-alpha1.tar.gz";s:4:"date";s:10:"1501790944";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:3:{i:0;s:9:"Bug fixes";i:1;s:12:"New features";i:2;s:8:"Insecure";}}s:8:"security";s:61:"Alpha releases are not covered by Drupal security advisories.";}s:5:"8.3.9";a:10:{s:4:"name";s:12:"drupal 8.3.9";s:7:"version";s:5:"8.3.9";s:3:"tag";s:5:"8.3.9";s:6:"status";s:9:"published";s:12:"release_link";s:52:"https://www.drupal.org/project/drupal/releases/8.3.9";s:13:"download_link";s:57:"https://ftp.drupal.org/files/projects/drupal-8.3.9.tar.gz";s:4:"date";s:10:"1522263480";s:5:"files";s:0:"";s:5:"terms";a:1:{s:12:"Release type";a:2:{i:0;s:15:"Security update";i:1;s:8:"Insecure";}}s:8:"securi