// Code property handler
function pagelayer_elp_code(row, prop){
	
	var rows = prop.rows ? prop.rows : '8';
	
	var div = '<div class="pagelayer-elp-editor-div">'+
				'<textarea rows="'+rows+'" class="pagelayer-elp-editor" ></textarea>'+
			'</div>';
			
	row.append(div);
	
	var editor = row.find('.pagelayer-elp-editor');
	editor.val(jQuery.parseHTML(prop.c['val'])[0].data);
	
	// Handle on change
	editor.on('input', function(){
		_pagelayer_set_atts(row, pagelayer_trim(pagelayer_htmlEntities(jQuery(this).val())));// Save and Render
	});
}

function pagelayer_render_end_pl_dm_code(el){
    documentor_higlight_code(el.$);
}

function pagelayer_render_end_pl_dm_table_content(el){
    documentor_tableOfContents(el.$.find('.documentor-table-content'));
}

var sidebar_tmp = {'atts': {'hide_parent':'', 'show_child':'', 'hide_count':''}, html:''};
function pagelayer_render_end_pl_dm_sidebar(el){
	
	if(sidebar_tmp.html && sidebar_tmp.atts.hide_parent == el.atts['hide_parent'] && sidebar_tmp.atts.show_child == el.atts['show_child'] && sidebar_tmp.atts.hide_count == el.atts['hide_count']){
		el.$.find('.documentor_sidebar_nav_list').html(sidebar_tmp.html);
		return;
	}else{
		sidebar_tmp.atts.hide_parent = el.atts['hide_parent'];
		sidebar_tmp.atts.show_child = el.atts['show_child'];
		sidebar_tmp.atts.hide_count = el.atts['hide_count'];
	}
	
	jQuery.ajax({
		url: pagelayer_ajax_url+'?&action=documentor_ajax_sidebar',
		type: 'post',
		data: {
            data: el.atts,
            pagelayer_nonce: pagelayer_ajax_nonce,
			template_name: 'pl_dm_sidebar',
		},
		success: function(response, status, xhr){
			var json = jQuery.parseJSON(response);
            		el.$.find('.documentor_sidebar_nav_list').html(json['posts']);
			sidebar_tmp.html = json['posts'];
        }
	});
}

var documentor_ajax_render_timer = {}; 
function pagelayer_render_end_pl_dm_breadcrumbs(el){
	
	clearTimeout(documentor_ajax_render_timer);
	documentor_ajax_render_timer = setTimeout(function(){
		jQuery.ajax({
			url: pagelayer_ajax_url+'?&action=documentor_ajax_template_part',
			type: 'post',
			data: {
				data:el.atts,
				pagelayer_nonce: pagelayer_ajax_nonce,
				template_name: 'pl_dm_breadcrumbs',
			},
			success: function(response, status, xhr){
				var json = jQuery.parseJSON(response);
				var html = jQuery(json['posts']).find('.documentor-breadcrumbs').html();
				el.$.find('.documentor-breadcrumbs').html(html);
			}
		});
	}, 500);
}

function pagelayer_render_end_pl_dm_feedback(el){
	
	clearTimeout(documentor_ajax_render_timer);
	documentor_ajax_render_timer = setTimeout(function(){
		jQuery.ajax({
			url: pagelayer_ajax_url+'?&action=documentor_ajax_template_part',
			type: 'post',
			data: {
				data:el.atts,
				pagelayer_nonce: pagelayer_ajax_nonce,
				template_name: 'pl_dm_feedback',
	
			},
			success: function(response, status, xhr){
				var json = jQuery.parseJSON(response);
				var html = jQuery(json['posts']).find('.documentor-feedback').html();
				el.$.find('.documentor-feedback').html(html);
			}
		});
	}, 500);
}

function pagelayer_render_end_pl_dm_article(el){
	el.$.find('.documentor-single-articles ul').html('<li class="page_item"><a href="javascript_void(0)">Sub Category 1</a></li><li class="page_item"><a href="javascript_void(0)">Sub Category 2</a></li>');
}

function pagelayer_render_end_pl_dm_title(el){
	el.$.find('h1').html('Title');
}

function pagelayer_render_end_pl_dm_adjacent_links(el){
	
	clearTimeout(documentor_ajax_render_timer);
	documentor_ajax_render_timer = setTimeout(function(){
		jQuery.ajax({
			url: pagelayer_ajax_url+'?&action=documentor_ajax_template_part',
			type: 'post',
			data: {
				data:el.atts,
				pagelayer_nonce: pagelayer_ajax_nonce,
				post_id: pagelayer_postID,
				template_name: 'pl_dm_adjacent_links',
			},
			success: function(response, status, xhr){
				var json = jQuery.parseJSON(response);
				var html = jQuery(json['posts']).find('.documentor-adjacent-links').html();
				el.$.find('.documentor-adjacent-links').html(html);
			}
		});
	}, 500);
}

function pagelayer_render_end_pl_dm_archive_box(el){

	clearTimeout(documentor_ajax_render_timer);
	documentor_ajax_render_timer = setTimeout(function(){
		jQuery.ajax({
			url: pagelayer_ajax_url+'?&action=documentor_ajax_template_part',
			type: 'post',
			data: {
				data:el.atts,
				pagelayer_nonce: pagelayer_ajax_nonce,
				post_id: pagelayer_postID,
				template_name: 'pl_dm_archive_box',
			},
			success: function(response, status, xhr){
				var json = jQuery.parseJSON(response);
				var html = jQuery(json['posts']).find('.documentor-archive-box').html();
				el.$.find('.documentor-archive-box').html(html);
			}
		});
	}, 500);
}
