<?php
/**
 * Single docs sidebar template
 *
 * This template can be overridden by copying it to yourtheme/documentor/single/sidebar.php.
 *
 * @author  softaculous
 * @package documentor/Templates
 * @version 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// phpcs:ignore
$show_parents = documentor()->get_option( 'sidebar_show_nav_parents', 'documentor_single', false );

?>

<div class="documentor-single-sidebar">
    <div class="documentor-single-sidebar-wrap">
        <?php if ( documentor()->get_option( 'sidebar_show_search', 'documentor_single', true ) ) : ?>
            <form role="search" method="get" class="documentor-search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
                <input type="search" class="documentor-search-field" placeholder="<?php echo esc_attr__( 'Type to search', 'documentor' ); ?>" value="<?php echo get_search_query(); ?>" name="s" autocomplete="off">
                <input type="hidden" name="post_type" value="docs">
                <?php if ( ! $show_parents ) : ?>
                    <input type="hidden" name="child_of" value="<?php echo esc_attr( documentor()->get_current_doc_id() ); ?>">
                <?php endif; ?>
            </form>
	    <div class="documentor-search-form-result"></div>
        <?php endif; ?>

        <?php
        // phpcs:ignore
        $nav_list = wp_list_pages(
            array(
                'title_li'  => '',
                'order'     => 'menu_order',
                'child_of'  => $show_parents ? 0 : documentor()->get_current_doc_id(),
                'echo'      => false,
                'post_type' => 'docs',
                'walker'    => new Documentor_Walker_Docs(),
            )
        );
        if ( $nav_list ) {
            // phpcs:ignore
            $show_childs = documentor()->get_option( 'sidebar_show_nav_childs', 'documentor_single', false );
            ?>
	    <a class="documentor-sidebar-toggler"><i class="fas fa-times"></i></a>
            <ul class="documentor-nav-list<?php echo ( $show_childs ? ' documentor-nav-list-show-childs' : '' ); ?>">
                <?php
                // phpcs:ignore
                echo $nav_list;
                ?>
            </ul>
        <?php } ?>
    </div>
</div>
