from defence360agent.contracts.plugins import MessageSink
from defence360agent.model.instance import db
from defence360agent.utils import recurring_check


class Checkpoint(MessageSink):
    """
    Checkpoint imunify360.db periodically to limit unexpected WAL file growing.
    """

    ONE_DAY = 24 * 60 * 60

    def __init__(self, *, checkpoint_period=ONE_DAY, db=db):
        self._checkpoint_period = checkpoint_period
        self._db = db
        self._task = None

    async def create_sink(self, loop):
        self._loop = loop
        self._task = self._loop.create_task(
            recurring_check(self._checkpoint_period)(self._checkpoint)()
        )

    async def shutdown(self):
        task, self._task = self._task, None  # avoid cancelling twice
        if task is None or task.cancelled():
            return
        task.cancel()
        # CancelledError is handled by @recurring_check():
        await task

    async def _checkpoint(self):
        # 1. may not shrink database wal file in case of this command will be
        # during external read process took place
        # 2. returning immediately without result if database
        # has concurrent transaction
        self._db.execute_sql("PRAGMA wal_checkpoint(TRUNCATE)")
