# todo: figure out how HookEvents.* is typed
# type: ignore
from defence360agent.contracts.config import HookEvents
from defence360agent.contracts.messages import Message

STARTED, FINISHED = "started", "finished"


class _HookEventBase(Message):
    event = None
    subtype = None

    def __repr__(self):
        filtered = {k: v for k, v in self.items() if k != "DUMP"}
        return f"{self.__class__.__qualname__}({repr(filtered)})"


class _Agent(_HookEventBase):
    event = HookEvents.AGENT


class _License(_HookEventBase):
    event = HookEvents.LICENSE


class _MalwareScanning(_HookEventBase):
    event = HookEvents.MALWARE_SCANNING


class _MalwareDetected(_HookEventBase):
    event = HookEvents.MALWARE_DETECTED


class _MalwareCleanup(_HookEventBase):
    event = HookEvents.MALWARE_CLEANUP


class HookEvent:
    class AgentStarted(_Agent):
        subtype = STARTED

    class AgentMisconfig(_Agent):
        subtype = "misconfig"

    class LicenseExpired(_License):
        subtype = "expired"

    class LicenseExpiring(_License):
        subtype = "expiring"

    class LicenseRenewed(_License):
        subtype = "renewed"

    class MalwareScanningStarted(_MalwareScanning):
        subtype = STARTED

    class MalwareScanningFinished(_MalwareScanning):
        subtype = FINISHED

    class MalwareDetectedCritical(_MalwareDetected):
        subtype = "critical"

    class MalwareCleanupStarted(_MalwareCleanup):
        subtype = STARTED

    class MalwareCleanupFinished(_MalwareCleanup):
        subtype = FINISHED
