from collections import defaultdict

from defence360agent.contracts.config import ConfigFile
from defence360agent.rpc_tools.lookup import RootEndpoints
from defence360agent.utils.config import update_config
from defence360agent.rpc_tools import lookup
from defence360agent.api.server.events import EventsAPI
from defence360agent.feature_management.checkers import config_cleanup


class AdvisorEndpoints(RootEndpoints):
    @lookup.bind("advisor", "apply")
    async def advisor_apply(self, advices):
        return await self._apply(advices)

    @lookup.bind("advisor", "apply-all")
    async def apply_all(self):
        advices = await EventsAPI.advices()
        return await self._apply(advices)

    async def _apply(self, advices):
        target_conf = defaultdict(dict)
        current_conf = ConfigFile().config_to_dict()
        for advise in advices:
            self._extract_conf_from_advise(advise, current_conf, target_conf)

        await update_config(self._sink, target_conf)
        return {"items": config_cleanup(ConfigFile().config_to_dict())}

    @staticmethod
    def _extract_conf_from_advise(advise, current_conf, target_conf):
        for section_key, section_value in advise["ignore"].items():
            for value_key, ignored_values in section_value.items():
                if current_conf[section_key][value_key] in ignored_values:
                    return
        for section_key, section_value in advise["config_action"].items():
            target_conf[section_key].update(section_value)
