"""Run default hooks for files update and log errors if any."""
from logging import getLogger
from defence360agent.utils import check_run, CheckRunError

logger = getLogger(__name__)

DEFAULT_HOOKS = {}


async def default_hook(files_index_object, is_updated) -> None:
    """Run delivered hooks for files update. Errors are logged up on stack."""
    if is_updated:
        hook = DEFAULT_HOOKS.get(files_index_object.type)
        if hook and hook.exists():
            try:
                await check_run([hook])
            except CheckRunError as e:
                logger.error("Error during hook execution: %s", e)
