import json
import logging

from defence360agent.utils import CheckRunError, check_run

logger = logging.getLogger(__name__)

EXECUTABLE = "cl-hosting-smart-advice"
APP_NAME = "imunify"


async def sync_advices(advices):
    payload = json.dumps(advices)
    try:
        out = await check_run(
            [EXECUTABLE, "sync", "--app", APP_NAME, "--json", payload]
        )
    except CheckRunError as e:
        logger.warning(
            "Failed to sync advices with `cl-hosting-smart-advice`: %s", e
        )
        return False
    else:
        result = json.loads(out)
        return result.get("success", False)
