from dataclasses import dataclass, field
from datetime import datetime, timezone
from typing import Optional


@dataclass
class MyImunifyWPAdvice:
    username: str
    domain: str
    website: str
    panel_url: str
    id: int
    type: str
    status: str
    description: str
    detailed_description: str
    is_premium: str
    module_name: str
    license_status: str
    subscription_status: str
    upgrade_url: str
    total_stages: int
    completed_stages: int
    created_at: Optional[datetime] = field(
        default_factory=lambda: datetime.now(timezone.utc).isoformat()
    )
    updated_at: Optional[datetime] = field(
        default_factory=lambda: datetime.now(timezone.utc).isoformat()
    )

    def to_advice(self):
        return {
            "created_at": self.created_at,
            "updated_at": self.updated_at,
            "metadata": {
                "app": "imunify",
                "username": self.username,
                "domain": self.domain,
                "website": self.website,
                "panel_url": self.panel_url,
            },
            "advice": {
                "id": self.id,
                "type": self.type,
                "status": self.status,
                "description": self.description,
                "is_premium": self.is_premium,
                "module_name": self.module_name,
                "license_status": self.license_status,
                "subscription": {
                    "status": self.subscription_status,
                    "upgrade_url": self.upgrade_url,
                },
                "total_stages": self.total_stages,
                "completed_stages": self.completed_stages,
                "detailed_description": self.detailed_description,
            },
        }
