import os
from logging import getLogger

logger = getLogger(__name__)
MU_PLUGIN_INSTALLATION = "mu_plugin_installation"
ADVICE_EMAIL_NOTIFICATION = "advice_email_notification"
MU_PLUGIN_KEYS = [MU_PLUGIN_INSTALLATION, ADVICE_EMAIL_NOTIFICATION]


class WordPressMuPlugin:
    def prepare_for_mu_plugin_installation(
        self, activation_status, mu_plugin_status
    ):
        """
        Must use plugin works only if cl-hosting-smart-advice is installed
        So it is a requirement to be sure it is installed
        It is expected to be installed by default with Imunify360
        """
        if not all([activation_status == "active", mu_plugin_status]):
            logger.warning(
                "Nothing to prepare for Must Use plugin as settings "
                "are not turned on, activation status=%s mu_plugin_status=%s",
                str(activation_status),
                str(mu_plugin_status),
            )
            return

        if not mu_plugin_status:
            logger.warning(
                "Nothing to prepare for Must Use plugin "
                "as mu_plugin_status=%s",
                str(mu_plugin_status),
            )
            return

        if not os.path.exists("/usr/sbin/cl-hosting-smart-advice"):
            raise ValueError(
                "cl-hosting-smart-advice rpm package is not installed "
                "in the system, please install it and try again"
            )
