import os


def path(p: str):
    """
    Make safe sequence from path-like string

    Useful if p contains unprintable sequence

    If p is safe to be printed (e.g. via logger) return it as is
    If it can cause an exception, return bytes instead
    """

    try:
        p.encode()
    except UnicodeEncodeError:
        return os.fsencode(p)

    return p
