from pathlib import Path

from defence360agent.subsys.persistent_state import save_state
from defence360agent.utils import CheckRunError, check_run
from defence360agent.contracts.config import Packaging

DOCTOR_CMD = (
    "bash <(wget -qq -O - "
    "https://repo.imunify360.cloudlinux.com/defence360/imunify-doctor.sh)"
)


async def _package_get_doctor_key():
    dir_ = Packaging.DATADIR
    if not Path(dir_).is_dir():
        dir_ = "/opt/imunify360/venv/share/imunify360"
    out = await check_run([Path(dir_, "scripts", "imunify-doctor.sh")])
    key = out.decode().strip()
    return key


async def _repo_get_doctor_key():
    out = await check_run(DOCTOR_CMD, shell=True)
    key = out.decode().strip()
    if not key:
        raise ValueError("Doctor key is empty")
    return key


async def get_doctor_key():
    try:
        key = await _repo_get_doctor_key()
    except (CheckRunError, ValueError):
        key = await _package_get_doctor_key()
    save_state("doctor_key", {"doctor_key": key})
    return key
