import time


def check_lock(check_lock_period: int, lock_file):
    if not lock_file.exists():
        lock_file.parent.mkdir(parents=True, exist_ok=True)
        lock_file.write_text(str(time.time() + check_lock_period))
        return 0

    if (time_left := is_period_passed(check_lock_period, lock_file)) <= 0:
        lock_file.write_text(str(time.time() + check_lock_period))
        return 0
    else:
        return time_left


def is_period_passed(period, lock_file):
    try:
        when_to_run = float(lock_file.read_text())
    except (FileNotFoundError, ValueError):
        return 0
    return when_to_run - time.time()
