"""High-level file operations."""
import errno
import logging
import shutil

logger = logging.getLogger(__name__)


def rmtree(path, ignore_errors=False, onerror=None, *, max_tries=3):
    """More robust shutil.rmtree.

    Retry on "Directory not empty" race condition:
    https://github.com/ansible/ansible/issues/34335#issuecomment-362995700
    """
    for i in range(1, max_tries + 1):
        try:
            return shutil.rmtree(path, ignore_errors, onerror)
        except OSError as e:
            if i == max_tries or e.errno not in [
                errno.EEXIST,
                errno.ENOTEMPTY,
            ]:
                raise

            # Got "Directory not empty" and attempts are not exhausted yet
            logger.warning("Can't remove %s tree, reason: %s", path, e)
