import urllib.request
import logging
import datetime

from defence360agent.api.server import API
from defence360agent.internals.iaid import IndependentAgentIDAPI
from defence360agent.rpc_tools.utils import run_in_executor_decorator

logger = logging.getLogger(__name__)


class EventsAPI(API):
    ADVICES_API_URL_TEMPLATE = (
        "{base}/api/dashboard/events?dashboard=false&"
        "popup=true&not_snoozed_at={not_snoozed_at}"
    )
    NOTIFICATIONS_API_URL_TEMPLATE = (
        "{base}/api/dashboard/v2/events?notification=1&enduser=true"
    )
    SMART_ADVICE_API_URL_TEMPLATE = (
        "{base}/api/dashboard/v2/events?smartadvice=true"
    )

    @classmethod
    @run_in_executor_decorator
    def advices(cls):
        request = urllib.request.Request(
            cls.ADVICES_API_URL_TEMPLATE.format(
                base=cls._BASE_URL,
                not_snoozed_at=int(datetime.datetime.now().timestamp()),
            ),
            method="GET",
        )
        result = cls.request(request)
        return result["result"]

    @classmethod
    async def notification(cls):
        request = urllib.request.Request(
            cls.NOTIFICATIONS_API_URL_TEMPLATE.format(base=cls._BASE_URL),
            method="GET",
            headers={"X-Auth": await IndependentAgentIDAPI.get_token()},
        )
        return await cls._send_notifications(request)

    @classmethod
    async def smart_advices(cls):
        request = urllib.request.Request(
            cls.SMART_ADVICE_API_URL_TEMPLATE.format(base=cls._BASE_URL),
            method="GET",
            headers={"X-Auth": await IndependentAgentIDAPI.get_token()},
        )
        return cls.request(request)["result"]

    @classmethod
    @run_in_executor_decorator
    def _send_notifications(cls, request):
        result = cls.request(request)
        return result["result"]
