import logging
from urllib.parse import urljoin
from urllib.request import Request

from defence360agent.api.server import API, APIError
from defence360agent.internals.iaid import (
    IndependentAgentIDAPI,
    IAIDTokenError,
)

logger = logging.getLogger(__name__)


class CleanupRevertAPI(API):
    URL = urljoin(API._BASE_URL, "/api/cleanup/revert")

    @classmethod
    async def paths(cls):
        try:
            token = await IndependentAgentIDAPI.get_token()
        except IAIDTokenError:
            return []

        request = Request(cls.URL, headers={"X-Auth": token})
        try:
            result = await cls.async_request(request)
        except APIError as exc:
            logger.warning("Failed to fetch cleanup revert data: %s", exc)
            return []

        return result["paths"]
