import os
from typing import Optional

from defence360agent.application.determine_hosting_panel import GP_FILE


class BaseConfig:
    @classmethod
    def exists(cls):
        return os.path.exists(cls._conf_path)

    @classmethod
    def to_dict(cls):
        from configparser import ConfigParser

        integration_conf = ConfigParser()
        integration_conf.read(cls._conf_path)

        return integration_conf

    @classmethod
    def get(cls, section: str, option: str) -> Optional[str]:
        """
        Return *option* value in *section* in config if exist,
        None otherwise.
        """
        try:
            return cls.to_dict()[section][option]
        except KeyError:
            return None


class IntegrationConfig(BaseConfig):
    _conf_path = GP_FILE


class ClIntegrationConfig(BaseConfig):
    _conf_path = "/opt/cpvendor/etc/integration.ini"
