from peewee import (
    Model,
    AutoField,
    CharField,
    TextField,
    TimestampField,
    Check,
)
from datetime import datetime, timezone


class AnalystCleanupRequest(Model):
    """
    Model for storing analyst cleanup requests.
    Tracks request details and status for each cleanup request submitted.
    """

    class Meta:
        db_table = "analyst_cleanup_requests"

    id = AutoField()
    username = CharField(null=False)
    zendesk_id = CharField(null=False)
    ticket_link = TextField(null=False)
    created_at = TimestampField(null=False, default=datetime.now(timezone.utc))
    status = CharField(
        null=False,
        default="pending",
        constraints=[Check("status in ('pending','in_progress','completed')")],
    )
    last_updated = TimestampField(
        null=False, default=datetime.now(timezone.utc)
    )


def migrate(migrator, database, fake=False, **kwargs):
    migrator.create_model(AnalystCleanupRequest)


def rollback(migrator, database, fake=False, **kwargs):
    analyst_cleanup_request = migrator.orm["analyst_cleanup_requests"]
    migrator.drop_model(analyst_cleanup_request)
