from peewee import BooleanField, CharField, Model


class MyImunify(Model):
    class Meta:
        db_table = "myimunify"

    user = CharField(unique=True)
    protection = BooleanField(null=False, default=False)


def migrate(migrator, _db, fake=False, **__):
    if fake:
        return
    migrator.create_model(MyImunify)


def rollback(migrator, _db, fake=False, **__):
    if fake:
        return
    migrator.remove_model(MyImunify)
