import logging
from pathlib import Path

logger = logging.getLogger(__name__)


def migrate(migrator, _db, fake=False, **__):
    if fake:
        return
    try:
        id_files = Path("/").glob("home*/*/.secure_site_id")
        for id_file in id_files:
            if not id_file.is_symlink():
                id_file.unlink(missing_ok=True)
    except Exception:
        logger.exception(
            "An exception occurred while deleting .secure_site_id files"
        )


def rollback(*_, **__):
    """Not supported"""
