from peewee import CharField


def migrate(migrator, *_, fake=False, **__):
    malware_history = migrator.orm["malware_history"]
    migrator.add_fields(
        malware_history,
        db_host=CharField(null=True),
        db_port=CharField(null=True),
        db_name=CharField(null=True),
    )


def rollback(migrator, *_, fake=False, **__):
    malware_history = migrator.orm["malware_history"]
    migrator.remove_fields(malware_history, "db_host", "db_port", "db_name")
