from time import time

from peewee import CharField, Check, IntegerField, Model, PrimaryKeyField


class MalwareIgnorePath(Model):
    class Meta:
        db_table = "malware_ignore_path"
        indexes = ((("path", "resource_type"), True),)  # True refers to unique

    CACHE = None

    id = PrimaryKeyField()
    path = CharField()
    resource_type = CharField(
        null=False, constraints=[Check("resource_type in ('file','db')")]
    )
    added_date = IntegerField(null=False, default=lambda: int(time()))


def migrate(migrator, *_, fake=False, **__):
    migrator.sql(
        "ALTER TABLE malware_ignore_path RENAME TO malware_ignore_path_old;"
    )
    migrator.create_model(MalwareIgnorePath)
    migrator.sql(
        "INSERT INTO malware_ignore_path(path,added_date,resource_type) "
        "SELECT path,added_date,resource_type FROM malware_ignore_path_old"
    )
    migrator.sql("DROP TABLE malware_ignore_path_old;")


def rollback(*_, **__):
    pass
