from peewee import CharField, Check

from defence360agent.utils import importer

MalwareScanResourceType = importer.get(
    module="imav.malwarelib.config",
    name="MalwareScanResourceType",
    default=None,
)


def migrate(migrator, *_, fake=False, **__):
    malware_history = migrator.orm["malware_history"]
    migrator.add_fields(
        malware_history,
        app_name=CharField(null=True),
        resource_type=CharField(
            null=False,
            constraints=[
                Check(
                    "resource_type in {}".format(
                        (
                            MalwareScanResourceType.DB.value,
                            MalwareScanResourceType.FILE.value,
                        )
                    )
                )
            ],
            default=MalwareScanResourceType.FILE.value,
        ),
    )


def rollback(migrator, *_, fake=False, **__):
    malware_history = migrator.orm["malware_history"]
    migrator.remove_fields(malware_history, "app_name", "resource_type")
