from defence360agent.contracts.config import (
    IConfig,
    LocalConfig,
    NonBaseMerger,
)


def migrate(*_, config_file: IConfig = LocalConfig(), fake=False, **__):
    if fake:
        return

    config = NonBaseMerger(
        names=(NonBaseMerger.get_layer_names())
    ).configs_to_dict(force_read=True)

    permission_settings = config.setdefault("PERMISSIONS", {})

    user_override_malware_actions = permission_settings.get(
        "user_override_malware_actions"
    )
    if user_override_malware_actions is None:
        permission_settings["user_override_malware_actions"] = True
        config_file.dict_to_config(
            {"PERMISSIONS": permission_settings},
            validate=False,
            without_defaults=True,
        )


def rollback(*_, **__):
    pass
