"""
This migration is needed to cleanup modsec config on cPanel
by removing includes for modsec2.imunify.conf
File is automatically included from /etc/apache2/conf.d, thus no
explicit includes are needed
"""
import logging
import subprocess

logger = logging.getLogger(__name__)


def migrate(migrator, database, fake=False, **kwargs):
    if fake:
        return

    for conf in ["includes/modsec2.imunify.conf", "modsec2.imunify.conf"]:
        try:
            subprocess.run(
                [
                    "/usr/sbin/whmapi1",
                    "modsec_make_config_inactive",
                    "config={}".format(conf),
                ],
                check=True,
            )
        except FileNotFoundError:
            pass
        except Exception:
            logger.exception("Failed to make %s inactive", conf)


def rollback(migrator, database, fake=False, **kwargs):
    pass
