import logging

logger = logging.getLogger(__name__)


def migrate(migrator, database, fake=False, **kwargs):
    MalwareHistory = migrator.orm["malware_history"]
    try:
        for entry in MalwareHistory.select():
            if entry.initiator in ["manual", "on-demand", "realtime"]:
                entry.cause, entry.initiator = entry.initiator, entry.cause
            entry.save()
    except Exception as e:
        logger.exception(e)


def rollback(migrator, database, fake=False, **kwargs):
    pass
