import os

import yaml

from defence360agent.contracts.config import IConfigFile, LocalConfig
from defence360agent.utils import log_error_and_ignore


@log_error_and_ignore()
def migrate(
    migrator,
    database,
    fake=False,
    config_file: IConfigFile = LocalConfig(),
    **kwargs
):
    if fake:
        return

    if not os.path.exists(config_file.path):
        return

    with open(config_file.path) as f:
        conf = yaml.safe_load(f)

    malware_settings = conf.setdefault("MALWARE_SCANNING", {})
    value = malware_settings.pop("scan_modified_files", None)
    malware_settings["scan_modified_files"] = value

    config_file.dict_to_config(conf, validate=False)


def rollback(migrator, database, fake=False, **kwargs):
    pass
