from time import time

from peewee import Model, CharField, IntegerField, BooleanField

from defence360agent.model.simplification import FilenameField


class EventHook(Model):
    class Meta:
        db_table = "event_hook"

    path = FilenameField(null=False)
    event = CharField(null=False)
    created = IntegerField(null=False, default=lambda: int(time()))
    native = BooleanField(default=False)


def migrate(migrator, database, fake=False, **kwargs):
    migrator.create_model(EventHook)


def rollback(migrator, database, fake=False, **kwargs):
    EventHook = migrator.orm["event_hook"]
    migrator.remove_model(EventHook)
