import logging

from defence360agent.utils import run_coro, antivirus_mode


logger = logging.getLogger(__name__)


@antivirus_mode.skip
def migrate(migrator, database, fake=False, **kwargs):
    if fake:
        return

    from im360.subsys.panels.plesk import Plesk
    from im360.subsys.panels.plesk.mod_security import (
        plesk_supports_custom_vendors,
    )

    try:
        if Plesk.is_installed() and run_coro(plesk_supports_custom_vendors()):
            panel = Plesk()
            installed_vendors = run_coro(panel.modsec_vendor_list())
            if "imunify360" in " ".join(installed_vendors):
                run_coro(panel.install_settings())
    except Exception as e:
        logger.warning('Unable to reinstall modsec "custom" ruleset: %s', e)


def rollback(migrator, database, fake=False, **kwargs):
    pass
