import contextlib
import logging
import os

from defence360agent.contracts.config import ConfigFile, NONE

logger = logging.getLogger(__name__)

# Before DEF-35627 the cron file was defined in MalwareScanSchedule.CRON_PATH and was located here
CRON_PATH = "/etc/cron.d/imunify_scan_schedule"


def _update_config(path=None):
    config = {
        "MALWARE_SCAN_SCHEDULE": {
            "interval": NONE,
        }
    }

    try:
        config_file = ConfigFile(path=path)
        config_file.dict_to_config(config)
    except Exception:
        logger.exception("Failed to set malware scan schedule config")


def _remove_cron(path=CRON_PATH):
    with contextlib.suppress(FileNotFoundError):
        os.unlink(path)


def migrate(migrator, database, fake=False, **kwargs):
    # Stubbed in DEF-11010
    # if fake:
    #     return
    #
    # _update_config()
    # _remove_cron()
    pass


def rollback(migrator, database, fake=False, **kwargs):
    pass
