import logging
import os

from defence360agent.contracts.config import ConfigFile, Core

logger = logging.getLogger(__name__)


def migrate(migrator, database, fake=False, **kwargs):
    """Write your migrations here."""
    if fake:
        return
    usernames = [None]
    if os.path.exists(Core.USER_CONFDIR):
        usernames.extend(os.listdir(Core.USER_CONFDIR))
    for username in usernames:
        config_file = ConfigFile(username=username)
        config = config_file.config_to_dict()
        if not config:
            continue
        default_action = config.setdefault("MALWARE_SCANNING", {}).get(
            "default_action"
        )
        if default_action == "quarantine":
            config["MALWARE_SCANNING"]["default_action"] = "notify"
            try:
                config_file.dict_to_config(
                    config, overwrite=True, validate=False
                )
            except Exception:
                pass


def rollback(migrator, database, fake=False, **kwargs):
    pass
