import logging
import os

from defence360agent.contracts.config import (
    ConfigsValidator,
    ConfigsValidatorError,
    LocalConfig,
)

logger = logging.getLogger(__name__)


# NOTE:
# "MOD_SEC_BLOCK_BY_CUSTOM_RULE" keys are validated even if they are strings.
# This migration is probably not needed anymore anyway.


def migrate(migrator, database, fake=False, **kwargs):
    if fake:
        return

    # adding brute-force rule to existing config
    # this is needed until DEFA-689 is done
    try:
        try:
            ConfigsValidator.validate_system_config()
        except ConfigsValidatorError:
            local_config = LocalConfig()
            backup_config = local_config.path + ".invalid"
            os.rename(local_config.path, backup_config)
            default_config = local_config.config_to_dict()
            local_config.dict_to_config(default_config)
            logger.warning(
                "Invalid config replaced with default one."
                " Old config save in %s",
                backup_config,
            )
    except Exception:
        logger.exception("Failed to replace invalid config with default one")


def rollback(migrator, database, fake=False, **kwargs):
    pass
