import logging

from peewee import BooleanField

logger = logging.getLogger(__name__)


def migrate(migrator, database, fake=False, **kwargs):
    FeatureManagementPerms = migrator.orm["feature_management_permissions"]
    migrator.add_fields(
        FeatureManagementPerms, cleanup=BooleanField(default=False)
    )


def rollback(migrator, database, fake=False, **kwargs):
    FeatureManagementPerms = migrator.orm["feature_management_permissions"]
    migrator.remove_fields(FeatureManagementPerms, "cleanup")
