import logging
import os
import shutil
import subprocess

from defence360agent.utils import antivirus_mode, run_coro

logger = logging.getLogger(__name__)

OLD_DISABLED_RULES_CONFIG = "/etc/apache2/conf.d/i360_modsec_disable.conf"


@antivirus_mode.skip
def migrate(migrator, database, fake=False, **kwargs):
    if fake:
        return
    from im360.subsys.panels.cpanel import cPanel

    try:
        if not cPanel.is_installed() or not run_coro(
            cPanel.installed_modsec()
        ):
            return

        hp = cPanel()

        if os.path.exists(OLD_DISABLED_RULES_CONFIG):
            shutil.move(
                OLD_DISABLED_RULES_CONFIG,
                os.path.join(
                    hp.DISABLED_RULES_CONFIG_DIR,
                    hp.GLOBAL_DISABLED_RULES_CONFIG_FILENAME,
                ),
            )

            subprocess.check_call(hp.REBUILD_HTTPDCONF_CMD)
    except Exception as e:
        logger.exception("Failed to delete old rules config with %s", e)


def rollback(migrator, database, fake=False, **kwargs):
    pass
