import pwd
import shutil
import os
import logging

from defence360agent.contracts.config import Core

logger = logging.getLogger(__name__)


def migrate(migrator, database, fake=False, **kwargs):
    try:
        for user in pwd.getpwall():
            try:
                src = os.path.join(user.pw_dir, Core.USER_CONFIG_FILE_NAME)
                if os.path.isfile(src) and not os.path.islink(src):
                    dst_dir = os.path.join(Core.USER_CONFDIR, user.pw_name)
                    os.mkdir(dst_dir)
                    os.chown(dst_dir, 0, user.pw_gid)
                    os.chmod(dst_dir, 0o750)
                    dst_file = os.path.join(
                        dst_dir, Core.USER_CONFIG_FILE_NAME
                    )
                    shutil.move(src, dst_file)
                    os.chown(dst_file, 0, user.pw_gid)
                    os.chmod(dst_file, 0o640)
            except OSError as e:
                logger.warning("Something went wrong: %s", str(e))
    except Exception:
        logger.exception("Failed to migrate config for %s", user)


def rollback(migrator, database, fake=False, **kwargs):
    pass
