import logging

logger = logging.getLogger(__name__)


def migrate(migrator, database, fake=False, **kwargs):
    if fake:
        return

    CountrySubnets = migrator.orm["country_subnets"]
    migrator.sql("DELETE FROM country_subnets")
    migrator.add_not_null(CountrySubnets, "network_address")
    migrator.add_not_null(
        CountrySubnets,
        "netmask",
    )
    migrator.add_not_null(CountrySubnets, "version")


def rollback(migrator, database, fake=False, **kwargs):
    CountrySubnets = migrator.orm["country_subnets"]
    migrator.drop_not_null(
        CountrySubnets, "network_address", "netmask", "version"
    )
