import logging
from time import time

import peewee as pw


logger = logging.getLogger(__name__)


def migrate(migrator, database, fake=False, **kwargs):
    """Write your migrations here."""

    Country = migrator.orm["country"]

    class IPListNew(pw.Model):
        # available list names

        ip = pw.CharField(null=False)
        listname = pw.CharField(
            null=False,
            constraints=[pw.Check("listname in ('WHITE','BLACK','GRAY')")],
        )
        expiration = pw.IntegerField(
            default=0, null=True  # 0 - never
        )  # null - the same :(
        imported_from = pw.CharField(null=True)
        ctime = pw.IntegerField(
            null=True, default=lambda: int(time())  # those
        )  # are OK
        deep = pw.IntegerField(null=True)
        comment = pw.CharField(null=True)
        country = pw.ForeignKeyField(Country, null=True)
        no_captcha = pw.BooleanField(null=False, default=False)
        full_access = pw.BooleanField(null=True)
        auto_whitelisted = pw.BooleanField(null=True, default=False)

        network_address = pw.IntegerField(null=False)
        netmask = pw.IntegerField(null=False)
        version = pw.IntegerField(null=False)

        class Meta:
            db_table = "iplist_new"
            primary_key = pw.CompositeKey(
                "network_address", "netmask", "version"
            )

    migrator.create_model(IPListNew)


def rollback(migrator, database, fake=False, **kwargs):
    """Write your rollback migrations here."""
    pass
