import logging

from defence360agent.contracts.config import ConfigFile

logger = logging.getLogger(__name__)


def migrate(migrator, database, fake=False, **kwargs):
    if fake:
        return

    config_file = ConfigFile()
    config = config_file.config_to_dict()
    if not config:
        return

    if "IPTABLES_RULE_CHECK" in config:
        config.pop("IPTABLES_RULE_CHECK")
        config_file.dict_to_config(config, overwrite=True, validate=False)


def rollback(migrator, database, fake=False, **kwargs):
    """Write your rollback migrations here."""
    pass
